{ =========================================================================== }
{ W5X-var.inc - Variables for Multi-level windows           ver 5.X, 12-20-88 }
{                                                                             }
{ This file contains all the variables needed for WNDW5X.TPU.  This lets you  }
{ know the variables being used, but it cannot be recompiled with WNDW5X.PAS  }
{ unless you have the complete source code.                                   }
{   Copyright (C) 1987,1988 by James H. LeMay,  All rights reserved.          }
{ =========================================================================== }

const
  { Change these to suit your data needs.  Source code required. }
  MaxWndw        =  5;  { 1 - 254 : windows per video page }
  MaxVirtualWndw =  2;  { 0 - 254 : total number of virtual windows - 1 }
  MaxPageUsed    =  1;  { 0 - MaxPage : top video page number (usually 0) }
                        { This can be greater than an expected MaxPage }

type
  { Place all of your window names needed for random-access here: }
  WindowNames = (
    Window0,       { Reserved for the non-window area. }
    Window1,  Window2,  Window3,  Window4,  Window5,
    aWindow,       { A name for non-unique windows. }
    FreeWindow);   { Reserved for a freed virtual windows stat. }
  Borders = (
    NoBrdr, BlankBrdr, SingleBrdr, DoubleBrdr, HdoubleBrdr,
    VdoubleBrdr, SolidBrdr, EvenSolidBrdr, ThinSolidBrdr1,
    ThinSolidBrdr2, LhatchBrdr, MhatchBrdr, HhatchBrdr,
    UserBrdr1, UserBrdr2);
  BrdrParts = (
    BrdrTL,BrdrTH,BrdrTR,BrdrLV,BrdrRV,
    BrdrBL,BrdrBH,BrdrBR,BrdrLT,BrdrHL,
    BrdrRT,BrdrTT,BrdrVL,BrdrBT,BrdrCL);
  BrdrRec =
    record
      case byte of
        1: (TL,TH,TR,LV,RV,BL,BH,BR,LT,HL,RT,TT,VL,BT,CL: char);
        2: (BrdrArray: array[BrdrTL..BrdrCL] of char);
      end;
        { The first letter of the border acronym mean:
            T = top or tee  B = bottom
            V = vertical    H = horiz
            L = left        R = right
            P = partition   C = cross
          The second letter is the same except for:
            T = tee         L = line
          Here they are in their relative positions:
            TL  TH  TT  TH  TR
            LV      VL      RV
            LT  HL  CL  HL  RT
            LV      VL      RV
            BL  BH  BT  BH  BR    }

  DirType = (NoDir,Up,Down,VeryTop,Top,Bottom,VeryBottom,FarLeft,Left,Right,
             FarRight,Center,Horiz,Vertical);
  WordArray        = array[0..32000] of word;  { Virtual array }
  WordArrayPtrType = ^WordArray;
  WndwStatType =
    record
      WSrow,WScol,WSrows,WScols,WSrow2,WScol2: byte; { Window w/ border }
      Wrow ,Wcol ,Wrows ,Wcols ,Wrow2 ,Wcol2:  byte; { Window only }
      WndwAttr,BrdrAttr,
      OrigAttr:            integer;     { Original window attribute. }
      WSbrdr,WSline:       Borders;
      WSname:              WindowNames;
      WSwhereR,WSwhereC:   byte;             { window-relative }
      WSmodes:             word;
      WScursor:            word;             { cursor mode for the window }
      ULcol,ULcols,ULrows: byte;             { peculiar Underlay location }
      ULbytes:             word;             { size in bytes for underlay }
      ULptr:               WordArrayPtrType; { For Underlay }
      VScrRec:             VScrRecType;      { Screen stats for Qwik }
      RefRow,RefCol:       byte;             { Viewed corner in virtual wndw
                                               or original WSrow & WScol for
                                               hidden window }
      ViewBrdr:            Borders;          { Border viewed on the CRT }
      VI:                  word;             { Virtual level index }
    end;
  WndwStatsType    = array[0..MaxWndw]        of WndwStatType;
  {$IfDef AddVirtual }
  VirtualStatsType = array[0..MaxVirtualWndw] of WndwStatType;
  {$EndIf }
  MarginRec =
    record   { Margins for limiting movement with MoveWindow or VResizeWindow }
      LeftMargin, RightMargin, TopMargin, BottomMargin: byte;
    end;

const
  Brdr: array [BlankBrdr..UserBrdr2] of BrdrRec =
    {   TL,TH,TR,LV,RV,BL,BH,BR,LT,HL,RT,TT,VL,BT,CL  }
    ((BrdrArray:'               '),  { BlankBrdr      }
     (BrdrArray:'ĿĴ³'),  { SingleBrdr     }
     (BrdrArray:'ͻͼ͹˺'),  { DoubleBrdr     }
     (BrdrArray:'͸;͵ѳ'),  { HdoubleBrdr    }
     (BrdrArray:'ķĽĶҺ'),  { VdoubleBrdr    }
     (BrdrArray:'۳'),  { SolidBrdr      }
     (BrdrArray:'߳'),  { EvenSolidBrdr  }
     (BrdrArray:'߳'),  { ThinSolidBrdr1 }
     (BrdrArray:'ܳ'),  { ThinSolidBrdr2 }
     (BrdrArray:'İ'),  { LhatchBrdr     }
     (BrdrArray:'ı'),  { MhatchBrdr     }
     (BrdrArray:'Ĳ'),  { HhatchBrdr     }
     (BrdrArray:''),  { UserBrdr1      }  { Make your own }
     (BrdrArray:'')); { UserBrdr2      }  { Make your own }

    { Valid modes for SetWindowModes: }
  RelMode       = $0001; { 00000001b - Window relative; temporary stats }
  PermMode      = $0002; { 00000010b - Can't be moved or removed, no underlay }
  ShadowLeft    = $0004; { 00000100b - Shadow on the left side }
  ShadowRight   = $0008; { 00001000b - Shadow on the right side }
  ZoomMode      = $0010; { 00010000b - Zoom effect on Make and AccessWindow }
  HiddenMode    = $0020; { 00100000b - Create window while Hidden }
  VirtualMode   = $0040; { 01000000b - Create Virtual window as well }
  CursorOffMode = $0080; { 10000000b - Leave cursor off at all times }
  SeeThruMode   = $0100; { 00000001b - Doesn't clear screen inside window }
  NoHideMode    = $0200; { 00000010b - Ignores request to hide window }
  NoAccessMode  = $0400; { 00000100b - Ignores request to access window }
  NoMoveMode    = $0800; { 00001000b - Ignores request to move/resize window }
    { Other modes for program detection: }
  ToCRTmode     = $1000; { 00010000b - Writing to CRT }
  ToHiddenMode  = $2000; { 00100000b - Writing to Hidden window }
  ToVirtualMode = $4000; { 01000000b - Writing to Virtual window }

  ShadowColor: integer = Black;
  ShadowChar:  char    = ' ';
  TitleOfs:    byte    = 1;     { # of cols title placed offset from border }

var
    { Boolean values corresponding to the above modes.  Automatically
      set for the window you are in. }
  RelFlag, PermFlag, ZoomFlag, HiddenFlag, VirtualFlag, CursorOffFlag,
  SeeThruFlag, NoHideFlag, NoAccessFlag, NoMoveFlag,
  ToCRTFlag, ToHiddenFlag, ToVirtualFlag: boolean;

  { -- Keep the following 10 variables in order for PageStatRec! -- }
  WndwStat:       WndwStatsType;
  TopWndwStat:    WndwStatType;  { Window stats on the top Level Index }
  TWS:            WndwStatType absolute TopWndwStat;      { one in the same }
    {$IfDef AddVirtual }
  TopVirtualStat: WndwStatType;  { Optional virtual stats for top window. }
  TVS:            WndwStatType absolute TopVirtualStat;   { one in the same }
    {$EndIf }
  LI,                         { Top Level Index }
  HLI,                        { Hidden Level Index }
  WI:             word;       { Window Index to save top stat (HLI or LI) }
  PLI:            byte;       { Permanent window Level Index }
  CursorDefault,              { Default cursor mode for each window }
  WindowModes:    word;       { Logical sum of all window modes listed above }
  Margins:        MarginRec;  { Limits for moving or resizing windows }

type
  PageStatRec =
    record
      PageWS:     WndwStatsType;        { Equivalent to WndwStat }
      PageTWS:    WndwStatType;         { Equivalent to TopWndwStat }
        {$IfDef AddVirtual }
      PageTVS:    WndwStatType;         { Equivalent to TopVirtualStat }
        {$EndIf }
      PageLI,PageHLI,PageWI: word;      { Equivalent to LI, HLI, and WI }
      PagePLI:               byte;      { Equivalent to PLI }
      PageCursor,
      PageModes:             word;      { Equivalent to WindowModes. }
      PageMargins:           MarginRec; { Equivalent to Margins. }
    end;
  PageStatRecs = array[0..MaxPageUsed] of PageStatRec;

var
    {$IfDef MultiPage }
  PageStat:       ^PageStatRecs;
  TopPageStat:    PageStatRec absolute WndwStat;
    {$EndIf }
    {$IfDef AddVirtual }
  VirtualStat:    ^VirtualStatsType;
  VirtualRows,               { Default rows for virtual screen. }
  VirtualCols:    byte;      { Default cols for virtual screen. }
  VirtualSize:    word;      { VirtualCols * (VirtualRow+2) * 2 }
    {$EndIf }
  MaxValidPage:   byte;      { The lesser of MaxPage or MaxPageUsed }
  ZoomDelay:      byte;      { Delay in ms between each Qbox for zoom effect }
  AddrGoof:       pointer;   { Contains Far address of Goof }
