{ =========================================================================== }
{ Goof.pas - Displays fatal programming errors              ver 5.X, 12-20-88 }
{                                                                             }
{ This file contains a convenient way to alert you of programming errors      }
{ since it is possible to create unseen errors with virtual and hidden        }
{ windows.  You can edit and recompile this unit at any time since it is      }
{ indirectly called.  But you MUST use it, else when CallGoof is              }
{ called or your machine will lock up.  So be sure to place this Unit as      }
{ the last unit in the MAIN program (see demos).                              }
{   Copyright (C) 1987,1988 by James H. LeMay,  All rights reserved.          }
{ =========================================================================== }

{ R-,S-,I-,D-,T-,F-,V-,B-,N-,L+ }       { TP4 directives }
{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}  { TP5 directives }

UNIT Goof;

INTERFACE

uses
  Qwik, Wndw;

procedure ShowGoof (ErrorNum: byte);


IMPLEMENTATION

procedure ShowGoof; { (ErrorNum: byte); }
type  Str40 = string[40];
var
  Row,Rows,Col,Cols:   byte;
  Msg1,Msg2,MemS,MaxS: Str40;
begin
  Msg2 := '';
  case ErrorNum of
    1: begin
         Msg1 := 'Not enough Heap space!';
         Str (memavail,MemS);
         Str (maxavail,MaxS);
         Msg2 := 'Mem='+MemS+'/'+'Max='+MaxS;
       end;
    2: Msg1 := 'Too many Windows!';
    3: Msg1 := 'Too many Virtual Windows!';
    4: Msg1 := 'Perm window out of order!';
    5: Msg1 := 'No window to remove!';
    6: Msg1 := 'Hidden window not found!';
    7: Msg1 := 'Virtual screen not found!';
    8: Msg1 := 'Video page not available!';
  end;
  LI := 0;                      { Set top window level }
  TopWndwStat := WndwStat[0];   { Get original CRT stat }
  QScrRec := TWS.VScrRec;       { Set Qwik stats }
  QwritePage (0);               { Ensure we are writing to page 0 }
  QviewPage (0);                { Ensure we are viewing page 0 }
  Rows := 5;
  Cols := 42;
  Row := succ((CRTrows-Rows) shr 1);
  Col := succ((CRTcols-Cols) shr 1);
  WindowModes := RelMode;
  MakeWindow (Row,Col,Rows,Cols,LightGrayBG,LightGrayBG+Blink,
              DoubleBrdr,aWindow);
  WWriteC (1,Msg1);
  WWriteC (2,Msg2);
  WWriteC (3,'Program halted.');
  SetCursor (CursorInitial);
  Halt;
end;

BEGIN
  AddrGoof := @ShowGoof;
END.
