{$S-,R-,V-,D-,T-}
{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}
{         TechnoJocks Turbo Toolkit v4.00            Released: Feb 1, 1988    }
{                                                                             }
{         Module: FastTTT   --  fast screen update procedures                 }
{         Credits: Brian Foley and Marshall Brain for ASM concept             }
{                                                                             }
{                       Copyright R. D. Ainsbury (c) 1986                     }
{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}

unit FastTTT;

interface

type
  DisplayType = (Monochrome, CGA, EGA, MCGA, VGA);
var
  BaseOfScreen : Word;       {Base address of video memory}
  WaitForRetrace : Boolean;  {Check for snow on color cards?}
  Speed : longint;           {delay factor for growbox routine}

Function  Attr(F,B:byte):byte;
Procedure FastWrite(Col,Row,Attr:byte; St:string);
Procedure PlainWrite(Col,Row:byte; St:string);
Function  CurrentDisplay: DisplayType;
Function  Replicate(N:byte; Character:char):string;
Procedure Box(X1,Y1,X2,Y2,F,B,boxtype:integer);
Procedure FBox(X1,Y1,X2,Y2,F,B,boxtype:integer);
Procedure GrowFBox(X1,Y1,X2,Y2,F,B,boxtype:integer);
Procedure HorizLine(X1,X2,Y,F,B,lineType:byte);
Procedure VertLine(X,Y1,Y2,F,B,lineType:byte);
Procedure ClearText(x1,y1,x2,y2,F,B:integer);
Procedure ClearLine(Y,F,B:integer);
Procedure WriteAT(X,Y,F,B:integer; St:string);
Procedure WriteBetween(X1,X2,Y,F,B:byte; St:string);
Procedure WriteCenter(LineNO,F,B:integer; St:string);
Procedure WriteVert(X,Y,F,B:integer; St:string);
Procedure ReinitFastWrite;

implementation

  {$L FASTTTT}

  {$F+}
  Procedure FastWrite(Col,Row,Attr:byte; St:string); external;
  Procedure PlainWrite(Col,Row:byte; St:string); external;
  Function CurrentDisplay: DisplayType; external;
  Function CurrentVideoMode: Byte; external;
  {$F-}

  Function Attr(F,B:byte):byte;
  {converts foreground(F) and background(B) colors to combined Attribute byte}
  begin
      Attr := (B Shl 4) or F;
  end;  {Func Attr}

  Function Replicate(N : byte; Character:char):string;
  {returns a string with Character repeated N times}
  var tempstr : string;
  begin
      If not (N in [1..80]) then N := 1;
      fillchar(tempstr,N+1,Character);
      Tempstr[0] := chr(N);
      Replicate := Tempstr;
  end;

  Procedure ClearText(x1,y1,x2,y2,F,B:integer);
  var
    Y : integer;
    attrib : byte;
  begin
      If x2 > 80 then x2 := 80;
      Attrib := attr(F,B);
      For Y := y1 to y2 do
          Fastwrite(X1,Y,attrib,replicate(X2-X1+1,' '));
  end;   {cleartext}

  Procedure ClearLine(Y,F,B:integer);
  begin
      Fastwrite(1,Y,attr(F,B),replicate(80,' '));
  end;

  Procedure Box(X1,Y1,X2,Y2,F,B,boxtype:integer);
  {Draws a box on the screen}
  var
    I:integer;
    corner1,corner2,corner3,corner4,
    horizline,
    vertline : char;
    attrib : byte;
  begin
      case boxtype of
      0:begin
            corner1:=' ';
            corner2:=' ';
            corner3:=' ';
            corner4:=' ';
            horizline:=' ';
            vertline:=' ';
        end;
      1:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
      2:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
      3:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
      4:begin
            corner1:='';
            corner2:='';
            corner3:='';
            corner4:='';
            horizline:='';
            vertline:='';
        end;
    else
       corner1:=chr(ord(Boxtype));
       corner2:=chr(ord(Boxtype));
       corner3:=chr(ord(Boxtype));
       corner4:=chr(ord(Boxtype));
       horizline:=chr(ord(Boxtype));
       vertline:=chr(ord(Boxtype));
    end;{case}
    attrib := attr(F,B);
    FastWrite(X1,Y1,attrib,corner1);
    FastWrite(X1+1,Y1,attrib,replicate(X2-X1-1,horizline));
    FastWrite(X2,Y1,attrib,corner2);
    For I := Y1+1 to Y2-1 do
    begin
        FastWrite(X1,I,attrib,vertline);
        FastWrite(X2,I,attrib,vertline);
    end;
    FastWrite(X1,Y2,attrib,corner3);
    FastWrite(X1+1,Y2,attrib,replicate(X2-X1-1,horizline));
    FastWrite(X2,Y2,attrib,corner4);
  end; {Proc Box}

  Procedure FBox(X1,Y1,X2,Y2,F,B,boxtype:integer);
  {Draws a box and clears text within Box frame}
  begin
      Box(X1,Y1,X2,Y2,F,B,boxtype);
      ClearText(succ(X1),succ(Y1),pred(X2),pred(Y2),F,B);
  end;

  Procedure GrowFBox(X1,Y1,X2,Y2,F,B,boxtype:integer);
  {Draws exploding filled box!}
  var I,TX1,TY1,TX2,TY2,Ratio : integer;
  begin
      If 2*(Y2 -Y1 +1) > X2 - X1 + 1 then
         Ratio :=   2
      else
         Ratio :=  1;
      TX2 := (X2 - X1) div 2 + X1 + 2;
      TX1 := TX2 - 3;                 {needs a box 3 by 3 minimum}
      TY2 := (Y2 - Y1) div 2 + Y1 + 2;
      TY1 := TY2 - 3;
      repeat
           FBox(TX1,TY1,TX2,TY2,F,B,BoxType);
           If TX1 >= X1 + (1*Ratio) then TX1 := TX1 - (1*Ratio) else TX1 := X1;
           If TY1 > Y1  then TY1 := TY1 - 1;
           If TX2 + (1*Ratio) <= X2 then TX2 := TX2 + (1*Ratio) else TX2 := X2;
           If TY2 + 1 <= Y2 then TY2 := TY2 + 1;
           For I := 1 to Speed*1000 do {nothing};
      Until (TX1 = X1) and (TY1 = Y1) and (TX2 = X2) and (TY2 = Y2);
      FBox(TX1,TY1,TX2,TY2,F,B,BoxType);
  end;

  procedure HorizLine(X1,X2,Y,F,B,lineType : byte);
  var
    I : integer;
    Horizline : char;
    attrib : byte;
  begin
      If (lineType in [2,4]) then
         horizline := ''
      else
         horizline := '';
      Attrib := attr(F,B);
      If X2 > X1 then
         FastWrite(X1,Y,attrib,replicate(X2-X1+1,Horizline))
      else
         FastWrite(X1,Y,attrib,replicate(X1-X2+1,Horizline));
  end;   {horizline}

  Procedure VertLine(X,Y1,Y2,F,B,lineType : byte);
  var
    I : integer;
    vertline : char;
    attrib : byte;
  begin
      If (linetype in [2,4])then
         vertline := ''
      else
         vertline := '';
      Attrib := attr(F,B);
      If Y2 > Y1 then
         For I := Y1 to Y2 do Fastwrite(X,I,Attrib,Vertline)
      else
         For I := Y2 to Y1 do Fastwrite(X,I,Attrib,Vertline);
  end;   {vertline}

  Procedure WriteAT(X,Y,F,B:integer;St:string);
  begin
      Fastwrite(X,Y,attr(F,B),St);
  end;

  Procedure WriteCenter(LineNO,F,B:integer;St:string);
  begin
      Fastwrite(40 - length(St) div 2,Lineno,attr(F,B),St);
  end;

  Procedure WriteBetween(X1,X2,Y,F,B:byte;St:string);
  var X : integer;
  begin
      If length(St) >= X2 - X1 + 1 then
         WriteAT(X1,Y,F,B,St)
      else
      begin
          x := X1 + (X2 - X1 + 1 - length(St)) div 2 ;
          WriteAT(X,Y,F,B,St);
      end;
  end;

  Procedure WriteVert(X,Y,F,B:integer;ST : string);
  var
    I:integer;
    Tempstr:string;
  begin
      If length(St) > 26 - Y then delete(St,27 - Y,80);
      For I := 1 to length(St) do
      begin
          Tempstr := st[I];
          Fastwrite(X,Y-1+I,attr(F,B),St[I]);
      end;
  end;


  Procedure ReinitFastWrite;
    {-Initializes WaitForRetrace and BaseOfScreen}
  begin                      {InitFastWrite}
    {initialize WaitForRetrace and BaseOfScreen}
    if CurrentVideoMode = 7 then
       BaseOfScreen := $B000  {Mono}
    else
       BaseOfScreen := $B800; {Color}
    WaitForRetrace := (CurrentDisplay = CGA);
 end;                       {InitFastWrite}

begin   {the following is always called when the unit is loaded}
    ReinitFastWrite;
    Speed := 200;
end.
