{
    Program:     DBSRCH  (Dbase Serch Utility)

    Version:     1.00
    Date:        January 06, 1989

    Language:    Borland Turbo Pascal v4.0/5.0
    Environment: IBM/PC compatible, MS-DOS v2.0 or higher

    A Dbase utility program to
      1) Garner information on the setup of a .DBF file

      2) Output selected records of a .DBF file (output to screen, printer,
         or another file

      3) Search though a specific field in a .DBF file for a set of strings
         of numeric value (depends on field type)

    Copyright (c) 1989 by David Loseke
                          LoByte Systems and Software
                          #4 Okaw South
                          Mahomet, IL  61853

    Permission is granted to use this program, or portions thereof, for
    both commercial and non-commercial purposes. All other rights are
    reserved to the original author.

    As all programs can be improved, if you find better ways of doing
    things here, drop me a line.
}
{$M 12288,0,8192}
program search_dbf_file;

uses db,dos,crt;

const
   maxfields = 20;         {Maximum number of field that will output}
   maxfieldlength = 254;   {Dbase maximum field length}
   maxdisplaystring = 67;  {For out put to screen}
   maxoutput = 5080;       {Max fields * maxfieldlength}
   backgroundcolor = black;
   foregroundcolor = lightgray;
   recattrib = $0F;        {Bright white on black}
   { Define some important keystrokes: }
   Bs       =   #8;
   Cr       =  #13;
   ESC      =  #27;
   Leftkey  = #203;
   Rightkey = #205;
   F1       = #187;             F6       = #192;  { function keys }
   F2       = #188;             F7       = #193;
   F3       = #189;             F8       = #194;
   F4       = #190;             F9       = #195;
   F5       = #191;             F10      = #196;
   Intchar  =  #27;             AltF     = #161;
   Space    =  #32;

type
   fieldname = string[10];
   fieldrecord = record      {For Dbase file header, stores filed info}
                  fieldname       : fieldname;
                  fieldtype       : char;
                  fieldlength     : integer;
                  fielddecchar    : char;
                  fieldoffset     : integer;
               end; {fieldrecord}
   fielddata = array [1..maxfields] of fieldrecord;
   datestring = string[8];
   outputf = array [1..maxfields] of boolean; {Used to control field output}
   filestring = string[77];
   maxstring = string[255];
   searchstring = ^searchstringrec;
   searchstringrec = record                   {Used to store search strings}
                        stringtosearch : maxstring;
                        prevrec,nextrec : searchstring;
                     end;  {record}

var
   whatfields : fielddata;
   outputflds : outputf;
   out : text;                     {Directs output}
   whereout,dbfile : filestring;
   lastupdate : datestring;
   f : file;
   recordlength : word;
   numberoffields,iotest, contintest,
   recnums, lastfieldnum, initialrecordoffset : integer;  {varius field data}
   dbfilesize : longint;
   endtest : boolean;
   ch : char;
   casesensitive : boolean;
   y : byte;

{============================  LIBRARY   ================================}

{A SET OF PROCEDURE/FUNCTION FROM LOSLIBR USED IN THIS PROGRAM}


function getkey : char;
{ Read a character, convert function/arrow keys to upper ASCII by
  adding 128 to the ordinal value of the second scan code.  If Intchar is
  pressed, set the global variable Interrupted in order to stop the program.
}
var ch : char;
begin
  ch := readkey;
  if (ch = #0) then      { Check for extended character }
  begin
    ch := readkey;
    ch := chr(ord(ch) + 128);    { change extended chars to upper ASCII }
  end;
  getkey := ch;
end; { getkey }

procedure writestring(col,row,attrib:byte;str:string);
{This procedure writes a string to display memory.  It works both for color and
 mono}

begin
  inline
    ($1E/                 {   push    ds}
     $1E/                 {   push    ds}
     $8A/$86/row/         {   mov     al,row[bp]}
     $B3/$50/             {   mov     bl,+$50}
     $F6/$E3/             {   mul     bl}
     $2B/$DB/             {   sub     bx,bx}
     $8A/$9E/col/         {   mov     bl,col[bp]}
     $03/$C3/             {   add     ax,bx}
     $03/$C0/             {   add     ax,ax}
     $8B/$F8/             {   mov     di,ax}
     $BE/$00/$00/         {   mov     si,$0000}
     $8A/$BE/attrib/      {   mov     bh,attrib[bp]}
     $8A/$8E/str/         {   mov     cl,srt[bp]}
     $22/$C9/             {   and     cl,cl}
     $74/$3E/             {   jz      }
     $2B/$C0/             {   sub     ax,ax}
     $8E/$D8/             {   mov     ds,ax}
     $A0/$49/$04/         {   mov     al,[$0449]}
     $1F/                 {   mov     pop     ds}
     $2C/$07/             {   sub     al,$07}
     $74/$22/             {   jz     }
     $BA/$00/$B8/         {   mov     dx,$b800}
     $8E/$DA/             {   mov     ds,dx}
     $BA/$DA/$03/         {   mov     dx,$03da}
     $46/                 {   inc     si}
     $8A/$9A/str/         {   mov     bl,str[bp]}
     $EC/                 {   in      al,dx}
     $A8/$01/             {   test    al,$01}
     $75/$FB/             {   jnz     }
     $FA/                 {   cli}
     $EC/                 {   in      al,dx}
     $A8/$01/             {   test    al,$01}
     $74/$FB/             {   jz      }
     $89/$1D/             {   mov     [di],bx}
     $47/                 {   inc     di}
     $47/                 {   inc     di}
     $E2/$EA/             {   loop    x57}
     $2A/$C0/             {   sub     al,al}
     $74/$10/             {   jz      }
     $BA/$00/$B0/         {   mov     dx,$b000}
     $8E/$DA/             {   mov     ds,dx}
     $46/                 {   inc     si}
     $8A/$9A/str/         {   mov     bl,str[bp]}
     $89/$1D/             {   mov     [di],bx}
     $47/                 {   inc     di}
     $47/                 {   inc     di}
     $E2/$F5/             {   loop     }
     $1F                  {   pop     ds}
  );
end;

{NEXT TWO FUNCTIONS COURTESY BYTE MAGAZINE}

function beforestring(source, target : string) : string;


begin
   if pos(target,source) = 0 then
      beforestring := source
   else
      beforestring := copy(source,1,pos(target,source)-1)
end; {beforestring}


function afterstring(source,target : string) : string;

begin
   if pos(target,source) = 0 then
      afterstring := ''
   else
      afterstring := copy(source,pos(target,source) + 1,length(source)-
                     pos(target,source))
end; {afterstring}


{=====================================================================}

{======================  FUNCTION GETDBFILEDATA   =====================}

procedure getdbfiledata(var afile : file);
{Reads Dbase header file and garners info on the file}

var
   bufstring : array [1..32] of char;
   month, day, year : integer;
   yearstring, daystring, monthstring : string[2];

begin
   seek(afile,0);
   blockread(afile,bufstring,32); {First 32 bytes of header contains the
                                   basic info on the file}
   year := ord(bufstring[2]);     {Year file created a offset 2}
   month := ord(bufstring[3]);    {Month at offset 3}
   day := ord(bufstring[4]);      {Date at offset 4}
   str(year:2,yearstring);        {Next three converts to strings}
   str(month:2,monthstring);
   str(day:2,daystring);
   lastupdate := monthstring + '/' + daystring + '/' + yearstring;
   recnums := ord(bufstring[6]) * 256 + ord(bufstring[5]);
       {Number of records in file at byte 5 & 6. Stores LSB first}

   recordlength := ord(bufstring[12]) * 256 + ord(bufstring[11]);
       {Total length in bytes of each record contained in bytes 11 & 12
         stored LSB first}

end;

{=======================================================================}

{==================== PROCEDURE GETFIELDDATA ===========================}

procedure getfielddata(var afile : file);
{Reads in Dbase header file to get filed data}


const
   dbfieldlength = 32;  {The info on each field is stored in 32 byte
                         segments.  There is one for each field}

   firstfieldoffset = 32; {FIrst field info segment starts at offset 32}

var
   outputoffset,index,field : integer;
   endtest1 : boolean;
   fieldbuffer : array [1..32] of char;
   chbuffer : char;



begin
   index := firstfieldoffset; {Keeps track of file offset}
   endtest1 := false;      {Flags the fact that we are through field info}
   numberoffields := 0;    {Counts number of fields}
   while not endtest1 do   {This part gets number of fields}
   begin
      seek(afile,index);
      blockread(afile,chbuffer,1); {We are looking for the char 0Dh to
                                    signify the field info section is over
                                    and we are into the record section}

      if ord(chbuffer) <> $0D then  {Not end of field section}
      begin
         inc(numberoffields);       {Starting another fields section so
                                     increment field counter}

         index := index + dbfieldlength; {Set up next fields offset}
      end
      else
         endtest1 := true;  {End of fields section found}
   end;
   index := firstfieldoffset;{Lets start over and find field data}
   endtest1 := false;
   field := 1;               {First field}
   outputoffset := 0;
   while (field <= numberoffields) and (field <= maxfields) do
   begin
      seek(afile,index);
      blockread(afile,fieldbuffer,32); {Contains data for a field}
      with whatfields[field] do
      begin
         fieldname := copy(fieldbuffer,1,10);{Name is contained in first 10
                                              bytes from offest 1, within
                                              field data section}
         fieldtype := fieldbuffer[12];       {Field type at offset 12}
         fieldlength := ord(fieldbuffer[17]);{Field length at offset 17}
         fielddecchar := fieldbuffer[18];    {# of decimal point at 18}
         fieldoffset := outputoffset;        {Computes offset to this field's
                                              within record}
         outputoffset := outputoffset + fieldlength;
      end;
      inc(field);                            {Next field}
      index := index + dbfieldlength;
   end; {while}
   lastfieldnum := field - 1;                {Number of actual fields}
end;


{=======================================================================}

{=======================  PROCEDURE OUTPUTFILESTATS  ===================}

procedure outputfilestats(var af : file;alastfieldnum : integer);
{This procedure outputs the Dbase file stats to the screen}


var
  field : integer;

begin
   clrscr;
   dbfilesize := (filesize(af)) div 1024;
   writeln('File... ',dbfile,' was last updated on ',lastupdate,
           ' and occupies ',dbfilesize,'K bytes');

   writeln('It contains ',recnums,' records with  ',recordlength,' bytes per record');
   writeln('File structure :  Field        type   length   decimal');
   writeln('                ');


   for field := 1 to alastfieldnum do
      with whatfields[field] do
      begin
         write('                  ',fieldname:10,fieldtype:5,fieldlength:9);
         if fieldtype = 'N' then
            write(ord(fielddecchar):9);
         writeln;
      end;
   write('Press any key to continue...');
   repeat until keypressed;
   ch := readkey;
end;

{=======================================================================}

{==================  PROCEDURE FIELDOUTPUT ======================}

procedure fieldoutput(fieldname,outstring : string);
{This procedure outputs the contents of a field to the selected output with
 a field label}

const
  fieldspace = '            ';


var
   initial,lasttst : boolean;
   numtodisplay,i,outputmarker : integer;
   lastspace,k,last,outstringlength : integer;
   dsplystrng : string[maxdisplaystring];



begin
   outstringlength := length(outstring);
   initial := true;
   outputmarker := 1;
   if whereout = 'CON' then
   begin
      if y <= 22 then  {y keeps track of line on screen}
         writestring(1,y,recattrib,fieldname); {write the field name}
      repeat
         if (y > 22) then

            {If output reaches end of screen, procedure will stop output
            and prompt for key press, clear screen, reset y, and then
            recall itself recursively to complete output.  Screen does
            not scroll!!!}

         begin
            y := 1;
            writestring(4,24,recattrib,'Press any key to continue...');
            repeat until keypressed;
            ch := readkey;
            clrscr;
            fieldoutput(fieldname,outstring);
            exit;
         end;
         while (outstring[outputmarker] = ' ') and  {remove spaces}
               (outputmarker <= length(outstring)) do
            inc(outputmarker);
         if (outstringlength - outputmarker + 1) > maxdisplaystring then

            {This is a simple function to cause line wrap on output.  It
             first starts at the char at maxdisplaystring in the output
             string looking backwards for the first space, at which point
             it will output up to the space char and reset the string to
             the first char after the space. If it cannot find a space then
             it outputs the first maxdisplaystring chars of string.  This
             function will be better written in assembly in future vers.}

         begin
            lastspace := 0;
            last := outputmarker + maxdisplaystring - 1;
            if last > length(outstring) then
               last := length(outstring);
            k := last;
            lasttst := false;
            repeat
               if outstring[k] = ' ' then
               begin
                  lastspace := k;
                  lasttst := true;
               end;
               dec(k);
            until lasttst or (k < outputmarker);
            if lastspace <> 0 then
               numtodisplay := lastspace - outputmarker + 1
            else
               numtodisplay := maxdisplaystring;
         end
         else
            numtodisplay := outstringlength - outputmarker + 1;
         dsplystrng := copy(outstring,outputmarker,numtodisplay);
         writestring(12,y,recattrib,dsplystrng); {display string}
         inc(y);
         outputmarker := outputmarker + numtodisplay;
         while (outstring[outputmarker] = ' ') and
                (outputmarker <= length(outstring)) do
            inc(outputmarker);
      until (outputmarker > length(outstring));
   end
   else
   begin   {this same as section above but takes into account that the
            output is to a file or printer}

      write(out,fieldname,'  ');
      if length(fieldname) < 10 then
         for i := length(fieldname)+1 to 10 do
            write(out,' ');
      repeat
         while outstring[outputmarker] = ' 'do
            inc(outputmarker);
         lastspace := 0;
         last := outputmarker + maxdisplaystring - 1;
         if last > length(outstring) then
            last := length(outstring);
         k := last;
         lasttst := false;
         repeat
            if outstring[k] = ' ' then
            begin
               lastspace := k;
               lasttst := true;
            end;
            dec(k);
         until lasttst or (k < outputmarker);
         if lastspace <> 0 then
            numtodisplay := lastspace - outputmarker + 1
         else
            numtodisplay := maxdisplaystring;
         dsplystrng := copy(outstring,outputmarker,numtodisplay);
         if not initial then
            write(out,fieldspace);
         writeln(out,dsplystrng);
         outputmarker := outputmarker + numtodisplay;
         while outstring[outputmarker] = ' 'do
            inc(outputmarker);
         if initial then
            initial := false;
      until (outputmarker > length(outstring));
   end;

end;

{=====================================================================}





{========================  PROCEDURE OUTPUTRECS  =======================}

procedure outputrecs(var thefile : file; whichrecord : integer);
{This procedure gets reads in the file from disk and outputs one field
 at a time}

type
   bufarray = array [1..maxoutput] of char; {A buffer to hold maximum psbl.
                                             field data}
   anoutstring = string[maxfieldlength];

var
   bufptr : bufarray;
   i : integer;
   offset : longint;
   stringout : anoutstring;


procedure getstringout(var source,dest;length : integer);
{Copys a section of the buffer to the string to output. TP's copy will
 not works because buffer string leagth exceeds 255 bytes}

begin
Inline(
  $1E/                   {  push    ds               ;save ds}
  $55/                   {  push    bp               ;save bp}
  $31/$C9/               {  xor     cx,cx            ;clear cx}
  $C5/$B6/>source/       {  lds     si,>source[bp]   ;move source into DS:SI}
  $C4/$BE/>dest/         {  les     di,>dest[bp]     ;move dest into DS:ES}
  $8B/$8E/>length/       {  mov     cx,>length[bp]   ;move length into cx}
  $FC/                   {  cld                      ;set operation to forward}
  $F2/$A4/               {  rep     movsb            ;repeat (move the string)}
  $5D/                   {  pop     bp               ;restore bp}
  $1F);                  {  pop     ds               ;restore ds}


end;

begin
   offset := initialrecordoffset + (whichrecord - 1)*recordlength;
      {Compute offset to the record}

   seek(thefile,offset);
   blockread(thefile,bufptr,recordlength);
   y := 1;
   for i := 1 to lastfieldnum do
      if outputflds[i] then  {outputflds is a boolean array to control
                              whether a field is output or not.  It is
                              set up in set defaultsettings and can be
                              changed in another procedure}

         with whatfields[i] do
         begin
            getstringout(bufptr[fieldoffset + 1],stringout[1],fieldlength );
            stringout[0] := chr(fieldlength);
            if fieldtype = 'D' then {if fieldtype = D then date string}
               stringout := copy(stringout,5,2)+'/'+copy(stringout,7,2)+'/'+
                            copy(stringout,3,2);
         fieldoutput(fieldname,stringout);
         end;

end;

{=======================================================================}

{================  PROCEDURE RECOUT  ===================================}

procedure recout(firstrec,lastrec : integer;var afile : file;
                 var stoptest : boolean);
{Controls which records will be output, and sets up output}
var
   i : integer;


begin
   clrscr;
   for i := firstrec to lastrec do
   begin
      if whereout <> 'CON' then
      begin
         writeln(out);
      end;
      writeln(out,'recordnumber==> ',i);
      if whereout <> 'CON' then
      begin
         clrscr;
         write('Writing recordnumber ',i,' to ');
         if whereout = 'PRN' then writeln('the printer')
         else
            writeln('file ',whereout);
      end;
      outputrecs(afile,i);
      if whereout = 'CON'then
      begin
         writestring(4,24,recattrib,'Press any key to continue...ESC to exit');
         repeat until keypressed;
         ch := readkey;
         if ch = ESC then    {Offers user a chance to terminate here}
         begin
            stoptest := true;
            exit;
         end
      end;
      clrscr;
      if whereout <> 'CON' then
      begin
         if whereout = 'PRN' then
         begin
            writeln(out);
            writeln(out);
         end
         else
            writeln(out);
      end
   end;
end;
{=======================================================================}
{================  PROCEDURE OUTPUTRECORDS =============================}

procedure outputrecords(var afile : file;lastnum : integer;reclenght : word);

{Gets the records to output from the user}


var
   firstrec,lastrec : integer;
   rectest,doexit,dummybool : boolean;


begin
   clrscr;
   repeat
      rectest := true;
      write('Enter initial record for output (largest=',recnums,')   >');
      readln(firstrec);
      if firstrec > recnums then
      begin
         writeln(^G,'FIRST RECORD LARGER THAN FINAL DATABASE RECORD!!! Please reenter');
         writeln('Maximum record in this database is ',recnums,' records');
         delay(5000);
         clrscr;
         rectest := false;
      end;
   until rectest;
   clrscr;
   repeat
      rectest := true;
      write('Enter final record for output (largest=',recnums,')  >');
      readln(lastrec);
      writeln;
      if lastrec < firstrec then
      begin
         writeln(^G,'LAST RECORD LARGER THAT FIRST!!! Please reenter');

         delay(5000);
         clrscr;
         rectest := false;
      end;
      if lastrec > recnums then
      begin
         writeln(^G,'LAST RECORD LARGER THAN FINAL DATABASE RECORD!!! Please reenter');
         writeln('Maximum record in this database is ',recnums,' records');
         delay(5000);
         clrscr;
         rectest := false;
      end;
   until rectest;
   doexit := false;
   if doexit then
   begin
      clrscr;
      exit;
   end;
   recout(firstrec,lastrec,afile,dummybool);

end;


{=======================================================================}

{==================  PROCEDURE GETWHICHOUTPUT  ======================}

procedure getwhichoutput;
{This procedure prompts the user to change the output default settings}

const
   charvalue = 65;

var
   outch : char;
   testout :  boolean;
   i, selection, j, l : integer;
   charstorage : array [1..maxfields] of integer;
   tempfieldstorage : outputf;


begin
   for i := 1 to maxfields do
     tempfieldstorage[i] := outputflds[i];
   for i := 1 to maxfields do
      outputflds[i] := false;
   for l := 1 to maxfields do
      charstorage[l] := 0;
   clrscr;
   {Outputs a list of fields}

   writeln('FIELD OUTPUT MENU');
   writeln('SELECT FIELDS TO OUTPUT (Type letter of fields, <RTN> to confirm,');
   writeln('                         <ESC> to return to menu <No changes made>)');
   for i := 1 to lastfieldnum do
      writeln('  ',chr(i+64),') ',whatfields[i].fieldname);
   writeln;
   write('FIELDS SELECTED =>');
   {Gets which fields to output from user}

   testout := false;
   l := 1;
   repeat
      repeat
         outch := getkey;
         outch := upcase(outch);
         selection := ord(outch);
      until selection in [65..(lastfieldnum+64),8,13,27];
      case selection of
        13  : testout := true;
        27  : begin
                 for j := 1 to maxfields do
                    outputflds[j] := tempfieldstorage[j];
                 testout := true;
              end;
         8  : begin
                 if l <> 1 then
                 begin
                    dec(l);
                    write(^H,' ',^H^H);
                    outputflds[charstorage[l]] := false;
                 end
              end;
      else
         if not outputflds[selection - 64] then
         begin
            outputflds[selection - 64] := true;
            write(' ',chr(selection));
            charstorage[l] := selection - 64;
            inc(l);
         end
      end;  {case}
   until testout;
end;

{=======================================================================}

{====================== PROCEDURE SETDEFAULTSETINGS ===================}

procedure setdefaultsettings;
{sets initial default setting for program}


var i : integer;

begin
   for i := 1 to maxfields do
     outputflds[i] := true;
   whereout := 'CON';
   assign(out,whereout);
   rewrite(out);
   casesensitive := true;
end;

{=======================================================================}

{======================  PROCEDURE GETDBFILE  ==========================}

procedure getdbfile(var datafile : filestring);
{Used to input current (or new) files}

begin
   clrscr;
   write('Enter name of file > ');readln(datafile);
end;

{=======================================================================}

{====================== PROCEDURE GETNEWDEFAULTSETTINGS  ==============}
procedure getnewdefaultsettings(var atest : boolean);
{Used to alter default settings}

var
  tempch,testch : char;
  dirinfo : searchrec;
  tempout : filestring;


begin
   clrscr;
   writeln('CHANGE DEFAULT SETTINGS MENU... ');
   writeln('SELECT F1,F2,F3,F4,F9 OR F10 ');
   writeln;
   writeln('  F1) Select FIELDS to output');
   writeln('  F2) Select output to screen, printer, or a file');
   writeln('  F3) Select selected Dbase file');
   writeln('  F4) Select whether string searches are case sensitive');
   writeln('  F9) Return to previous setting screen');
   writeln('  F10) To exit to main menu');
   repeat
      testch := getkey;
   until testch in [F1,F2,F3,F4,F9,F10];
   case testch of
      F1  : getwhichoutput;
      F2  : begin
                close(out);
                clrscr;
                writeln('Output to <S>creen, <P>rinter or <F>ile? ');
                repeat
                   tempch := readkey;
                   tempch := upcase(tempch);
                until tempch in ['P','S','F'];
                case tempch of
                   'P' : begin
                            whereout := 'PRN';
                            assign(out,whereout);
                            rewrite(out);
                         end;
                   'S' : begin
                            whereout := 'CON';
                            assign(out,whereout);
                            rewrite(out);
                         end;
                   'F' : begin
                            write('Enter file name >');
                            readln(tempout);
                            findfirst(tempout,$3F,dirinfo);
                            if doserror = 0 then
                            begin
                               clrscr;
                               writeln('File ',tempout,' already exits!!');
                               write('Do you wish to <A>ppend to, <R>ewrite the file,');
                               writeln(' or ESC to abort?');
                               repeat
                               tempch := readkey;
                               tempch := upcase(tempch);
                               until tempch in ['A','R',ESC];
                               case tempch of
                                 'A' : begin
                                          whereout := tempout;
                                          assign(out,whereout);
                                          append(out);
                                       end;
                                 'R' : begin
                                          whereout := tempout;
                                          assign(out,whereout);
                                          rewrite(out);
                                       end;
                                 ESC : begin
                                          clrscr;
                                          writeln('File operation aborted..output defaulting to screen');
                                          delay(1000);
                                          whereout := 'CON';
                                          assign(out,whereout);
                                          rewrite(out);
                                       end;
                               end {case}
                            end
                            else
                            begin
                               whereout := tempout;
                               assign(out,whereout);
                               rewrite(out);
                            end
                         end
                end {case}
             end;
      F3  : begin
                close(f);
                getdbfile(dbfile);
                assign(f,dbfile);
                reset(f,1);
                getdbfiledata(f);
                getfielddata(f);
                setdefaultsettings;
                initialrecordoffset := (numberoffields + 1) * 32 + 2;
                if numberoffields > maxfields then
                begin
                   writeln;
                   writeln(^G,'PLEASE NOTE!!! Total number of fields in database is ',numberoffields);
                   writeln('This program will only function with the first ',maxfields,' fields');
                   writeln('in the database.  Please consult default settings to confirm which');
                   writeln('fields will be used (or use main menu selection A)');
                   writeln;
                   writeln('Press any key to continue...');
                   repeat until keypressed;
                   testch := readkey;
                end
             end;
      F4  : begin
                clrscr;
                writeln('Do you want searches to be');
                writeln;
                writeln('<C>ase sensitive or');
                writeln('<N>on case sensitive');
                writeln;
                writeln;
                writeln('NOTE!!! Non case sensitive searches are slower!!');
                repeat
                   tempch := readkey;
                   tempch := upcase(tempch);
                until tempch in ['C','N'];
                if tempch = 'C' then
                   casesensitive := true
                else
                   casesensitive := false;
             end;
      F10  : atest := true;
      F9   : exit;
   end {case}
end;

{======================================================================}

{====================== PROCEDURE CHANGEDEFAULTSETTINGS ===============}
procedure changedefaultsettings;
{Shows current default settings and prompts for changes if wanted}

var
  outputindex,i : integer;
  outtest : boolean;




begin
   outtest := false;
   repeat
      clrscr;
      write('DEFAULT SETTINGS      Using file ');
      highvideo;
      writeln(dbfile);
      lowvideo;
      write('Current output is directed to ');
      highvideo;
      outputindex := 0;
      if whereout = 'CON' then outputindex := 1;
      if whereout = 'PRN' then outputindex := 2;
      case outputindex of
         1 : writeln('the screen');
         2 : writeln('the printer');
      else
         writeln('file ',whereout);
      end; {case}
      lowvideo;
      write('String searches will be ');
      highvideo;
      if casesensitive then
         writeln('case sensitive')
      else
         writeln('non case sensitive');
      lowvideo;
      writeln('The FIELDS that will be output are:');
      highvideo;
      for i := 1 to lastfieldnum do
         if outputflds[i] then
            writeln('                                    ',whatfields[i].fieldname);
      lowvideo;
      gotoxy(1,25);write('Press any key to change, ESC to exit...');
      repeat
      until keypressed;
      ch := getkey;
      if ch <> ESC then
         getnewdefaultsettings(outtest)
      else
         outtest := true;
   until outtest;
end;

{======================================================================}


{=======================  PROCEDURE SEARCH ===============================}
procedure search(var thefile : file;firstsearchptr : searchstring ;
                          first,last,searchnum : integer);
{Searches file for string ( or numeric) match in a particular field}


var
   searchptr : searchstring;
   offset : longint;
   buffer,outsearchstring,outbufstring : maxstring;
   readbuf : array [1..maxfieldlength] of char;
   testforstring,quittest,outputrec : boolean;
   i, code : integer;
   buftest, searchtest : real;

procedure strtoupper(var inputstring,outputstring);
{Converts a string to uppercase.  Used if search not case sensetive}

begin
Inline(
  $55/                   {     push  bp}
  $1E/                   {     push  ds}
  $C5/$B6/>inputstring/  {     LDS   si,>inputstring[bp]}
  $C4/$BE/>outputstring/ {     LES   di,>outputstring[bp]}
  $FC/                   {     CLD}
  $AC/                   {     LODSB}
  $AA/                   {     STOSB}
  $88/$C1/               {     mov   cl,al}
  $30/$ED/               {     xor   ch,ch}
  $E3/$00/               {     JCXZ  L1}
  $AC/                   {L1:  LODSB}
  $3C/$61/               {     CMP   al,'a'}
  $72/$06/               {     JB    L2}
  $3C/$7A/               {     CMP   al,'z'}
  $77/$02/               {     JA    L2}
  $2C/$20/               {     sub   al,'a'-'A'}
  $AA/                   {L2:  STOSB}
  $E2/$F2/               {     LOOP  L1}
  $1F/                   {L3:  pop   ds}
  $5D);                  {     pop   bp}


end;

begin
   quittest := false;
   testforstring :=  true;
   offset := ((numberoffields + 1) * 32 + 2) + ((first-1) * recordlength) +
                  whatfields[searchnum].fieldoffset ;
   reset(thefile,1);
   i := first;
   while i <= last do
   begin
      clrscr;
      searchptr := firstsearchptr;
      writeln('SEARCHING');
      seek(thefile, offset);
      blockread(thefile,readbuf,whatfields[searchnum].fieldlength);
      buffer := copy(readbuf,1,whatfields[searchnum].fieldlength);
      outputrec := true;
      while (searchptr <> nil) and outputrec do
      begin
         if whatfields[searchnum].fieldtype <> 'N' then
         begin
            if casesensitive then
               if pos(searchptr^.stringtosearch,buffer) <> 0 then
                  outputrec := true
               else
                  outputrec := false
            else
            begin
               strtoupper(searchptr^.stringtosearch,outsearchstring);
               strtoupper(buffer,outbufstring);
               if pos(outsearchstring,outbufstring) <> 0 then
                  outputrec := true
               else
                  outputrec := false;
            end
         end
         else
         begin
            val(buffer,buftest,code);
            val(searchptr^.stringtosearch,searchtest,code);
            if buftest = searchtest then
               outputrec := true
            else
               outputrec := false;
         end;
      searchptr := searchptr^.nextrec;
      end;
      if outputrec then
      begin
         recout(i,i,thefile,quittest);
         if quittest then exit;
         testforstring := false;

      end;
      inc(i);
      offset := offset + recordlength;
   end;
   if testforstring then
   begin
      clrscr;
      writeln(^G,'SEARCH STRING(S) NOT FOUND!!!)');
      delay(2000)
   end
end;

{=====================================================================}


{=======================  PROCEDURE SEARCHFORSTRING  ==================}
procedure searchforstring(var afile : file;lastnum : integer;reclenght : word);
{Gets a set of strings to search for}


var
   clearstring : string[maxfieldlength];
   markptr : pointer;
   currentptr,origptr, stringptr,backptr : searchstring;
   stringsearch : string[maxfieldlength];
   fieldsearchnum,i,selection : integer;
   firstsearchrec, lastsearchrec : integer;
   outch : char;
   lengthtest, rectest,searchtest,atest : boolean;


function converttodate(inputstring : string) : datestring;

var
   monthstring, datestring : string[2];

begin
   monthstring := beforestring(inputstring,'/');
   if length(monthstring) < 2 then
      monthstring := '0' + monthstring;
   inputstring := afterstring(inputstring,'/');
   datestring := beforestring(inputstring,'/');
   if length(datestring) < 2 then
      datestring := '0' + datestring;
   inputstring := afterstring(inputstring,'/');
   converttodate := '19' + inputstring + monthstring + datestring;
end;


begin
   fillchar(clearstring,sizeof(clearstring),' ');
   clearstring[0] := #254;
   searchtest := false;
   repeat
      clrscr;
      writeln('SELECT FIELD TO SEARCH (Type letter of field');
      for i := 1 to lastfieldnum do
         writeln('  ',chr(i+64),') ',whatfields[i].fieldname);
      writeln;
      write('FIELD SELECTED =>');
      repeat
         outch := getkey;
         outch := upcase(outch);
         selection := ord(outch);
      until selection in [65..(lastfieldnum+64)];
      fieldsearchnum := selection - 64;
      lengthtest := true;
      mark(markptr);
      new(origptr);
      origptr^.prevrec := nil;
      origptr^.nextrec := nil;
      backptr := origptr;
      while lengthtest do
      begin
         clrscr;
         write('Enter ');
         case whatfields[fieldsearchnum].fieldtype of
            'D'  :  write('date to search for (00/00/00) >');
            'N'  :  write('number to search for >');
         else
            write('string to search for ');
            if casesensitive then
               write('(case sensitive) >')
            else
               write('(non-case sensitive) >');
         end;
         readln(stringsearch);
         if (whatfields[fieldsearchnum].fieldtype = 'D') and
            (stringsearch <> '') then
            stringsearch := converttodate(stringsearch);
         if length(stringsearch) <= whatfields[fieldsearchnum].fieldlength then
            lengthtest := false
         else
         begin
            writeln(^G,'SEARCH STRING LENGTH EXCEEDS FIELD LENGTH!!! Please reenter');
            delay(5000);
            clrscr;
         end
      end;
      if stringsearch <> '' then
         origptr^.stringtosearch := stringsearch
      else
      begin
         release(markptr);
         exit;
      end;
      repeat
         stringsearch := '';
         lengthtest := true;
         while lengthtest do
         begin
            clrscr;
            writeln('Enter RETURN to continue or');
            case whatfields[fieldsearchnum].fieldtype of
               'D'  :  write('enter another date to search for (00/00/00) >');

               'N'  :  write('enter another number to search for >');
            else
               write('enter another string to search for ');
               if casesensitive then
                  write('(case sensitive) >')
               else
                  write('(non-case sensitive) >');
            end;
            readln(stringsearch);
            if (whatfields[fieldsearchnum].fieldtype = 'D') and
               (stringsearch <> '') then
               stringsearch := converttodate(stringsearch);
            if length(stringsearch) <= whatfields[fieldsearchnum].fieldlength then
               lengthtest := false
            else
            begin
               writeln(^G,'SEARCH STRING LENGTH EXCEEDS FIELD LENGTH!!! Please reenter');
               delay(5000);
               clrscr;
            end
         end;
         if stringsearch <> '' then
         begin
            if maxavail >= sizeof(searchstringrec) then
            begin
               new(stringptr);
               stringptr^.prevrec := backptr;
               backptr^.nextrec := stringptr;
               stringptr^.nextrec := nil;
               stringptr^.stringtosearch := stringsearch;
               backptr := stringptr;
            end
            else
            begin
               writeln(^G,'Insufficient memory for more search items. Starting search');
               delay(1500);
               stringsearch := '';
            end
         end;
      until stringsearch = '';
      clrscr;
      repeat
         rectest := true;
         write('Enter initial record for search (largest=',recnums,')  >');
         readln(firstsearchrec);
         if firstsearchrec > recnums then
         begin
            writeln(^G,'FIRST RECORD LARGER THAN FINAL DATABASE RECORD!!! Please reenter');
            writeln('Maximum record in this database is ',recnums,' records');
            delay(5000);
            clrscr;
            rectest := false;
         end;
      until rectest;
      clrscr;
      repeat
         rectest := true;
         write('Enter final record for search (largest=',recnums,')  >');
         readln(lastsearchrec);
         writeln;
         if lastsearchrec < firstsearchrec then
         begin
            writeln(^G,'LAST RECORD LARGER THAT FIRST!!! Please reenter');
            delay(5000);
            clrscr;
            rectest := false;
         end;
         if lastsearchrec > recnums then
         begin
            writeln(^G,'LAST RECORD LARGER THAN FINAL DATABASE RECORD!!! Please reenter');
            writeln('Maximum record in this database is ',recnums,' records');
            delay(5000);
            clrscr;
            rectest := false;
         end;
      until rectest;
      clrscr;
      writeln('SEARCH FUNCTION PARAMETERS');
      write('Search field...');
      highvideo;
      writeln(whatfields[fieldsearchnum].fieldname);
      lowvideo;
      writeln;
      write('From record number ');
      highvideo;
      writeln(firstsearchrec,' to ',lastsearchrec);
      lowvideo;
      writeln;
      write('You have chosen to search for ');
      if whatfields[fieldsearchnum].fieldtype = 'D' then
        writeln(' (NOTE: Date converted to Dbase format) ...')
      else
         writeln('...');
      highvideo;
      write(origptr^.stringtosearch);
      lowvideo;
      gotoxy(1,14);
      writeln('Press Return to set search parameters again');
      writeln('LEFT or RIGHT arrows to scroll through search parameters');
      writeln('or SPACE bar to begin search');
      currentptr := origptr;
      atest := false;
      repeat
         repeat
            outch := getkey;
         until outch in [CR,LeftKey,RightKey,SPACE];
         case outch of
            SPACE   :  begin searchtest := true;atest := true;end;
            CR      :  begin release(markptr);atest := true;end;
            LeftKey :  begin
                          if currentptr^.prevrec <> nil then
                          begin
                             currentptr := currentptr^.prevrec;
                             gotoxy(1,7);write(clearstring);
                             highvideo;
                             gotoxy(1,7);write(currentptr^.stringtosearch);
                             lowvideo;
                          end
                          else
                          begin
                             sound(440);delay(250);nosound;
                          end
                       end;
            RightKey : begin
                          if currentptr^.nextrec <> nil then
                          begin
                             currentptr := currentptr^.nextrec;
                             gotoxy(1,7);write(clearstring);
                             highvideo;
                             gotoxy(1,7);write(currentptr^.stringtosearch);
                             lowvideo;
                          end
                          else
                          begin
                             sound(440);delay(250);nosound;
                          end
                       end
         end; {case}
      until atest;
   until searchtest;
   search(afile,origptr,firstsearchrec,lastsearchrec,fieldsearchnum);
   release(markptr);
end;

{=======================================================================}


{==========================   MAIN    ==================================}


begin
   textbackground(backgroundcolor);
   textcolor(foregroundcolor);
   clrscr;
   if paramcount >= 1 then
      dbfile := paramstr(1)
   else
      getdbfile(dbfile);
   assign(f,dbfile);
   reset(f,1);
   getdbfiledata(f);
   getfielddata(f);
   setdefaultsettings;
   initialrecordoffset := (numberoffields + 1) * 32 + 2; {Record section of file}
   if numberoffields > maxfields then
   begin
      writeln;
      writeln(^G,'PLEASE NOTE!!! Total number of fields in database is ',numberoffields);
      writeln('This program will only function with the first ',maxfields,' fields');
      writeln('in the database.  Please consult default settings to confirm which');
      writeln('fields will be used (or use main menu selection A)');
      writeln;
      writeln('Press any key to continue...');
      repeat until keypressed;
      ch := readkey;
   end;
   endtest := false;
   repeat
      clrscr;
      writeln('MAIN MENU... File > ',dbfile);
      writeln('SELECT F1 - F6 OR F10 TO QUIT');
      writeln;
      writeln('  F1) Get information on selected Dbase file');
      writeln('  F2) Output selected records');
      writeln('  F3) Search selected Dbase file');
      writeln('  F4) Get (change) file name');
      writeln('  F5) Change output default settings');
      writeln('  F6) Dos shell');
      writeln('  F10) Exit program');
      repeat
         ch := getkey;
      until ch in [F1,F2,F3,F4,F5,F6,F10];
      case ch of
         F1  : outputfilestats(f,lastfieldnum);
         F2  : if recnums <> 0 then
                begin
                   outputrecords(f, lastfieldnum, recordlength);
                end
                else
                begin
                   clrscr;
                   writeln(^G,'Database does not contain any records to output!!!');
                   delay(3000);
                end;
         F3  : if recnums <> 0 then
                begin
                   searchforstring(f, lastfieldnum, recordlength);
                end
                else
                begin
                   clrscr;
                   writeln(^G,'Database does not contain any records to search!!!');
                   delay(3000);
                end;
         F4  : begin
                   close(f);
                   getdbfiledata(f);
                   getfielddata(f);
                   setdefaultsettings;
                   initialrecordoffset := (numberoffields + 1) * 32 + 2;
                   if numberoffields > maxfields then
                   begin
                      writeln;
                      writeln(^G,'PLEASE NOTE!!! Total number of fields in database is ',numberoffields);
                      writeln('This program will only function with the first ',maxfields,' fields');
                      writeln('in the database.  Please consult default settings to confirm which');
                      writeln('fields will be used (or use main menu selection A)');
                      writeln;
                      writeln('Press any key to continue...');
                      repeat until keypressed;
                      ch := readkey;
                   end
                end;
         F10  : endtest := true;
         F5  : changedefaultsettings;
         F6  : begin
                   clrscr;
                   writeln('Type exit to return to Dbase search');
                   swapvectors;
                   exec('\command.com','');
                   swapvectors;
                   if doserror <> 0 then
                   begin
                      if doserror = 2 then
                      begin
                         clrscr;
                         writeln(^G,'COMMAND.COM NOT FOUND!!!');
                         delay(2000);
                         clrscr;
                      end
                      else
                      begin
                         clrscr;
                         writeln(^G,'DOS ERROR #',doserror);
                         delay(2000);
                         clrscr;
                      end
                   end
                end;
      end; {case}
   until endtest;
   close(f);
   close(out);
end.