// ---------------------------------------------------------------------------------------------------------------
// Script for Eshop.html example
// ---------------------------------------------------------------------------------------------------------------
var LCnt, LPrice;         // Defines arrays needed only for real e-shop
Grids.CookieExpires = 1;  // Sets TreeGrid cookies to expire after this session

// ---------------------------------------------------------------------------------------------------------------
// TreeGrid event handler
// Changes color of cells for upgrading to red
Grids.OnGetColor = function(G,row,col,r,g,b,type) {
if(row.id!='Total' && row.O>0 && !type) b=128;
if((row.B || col>="I" && col!="S") && col && G.CanEdit(row,col)){ b-=15; g-=15; }
if(r==255 && g==255 && b==255) return "";
return "rgb("+r+","+g+","+b+")";
}

// ---------------------------------------------------------------------------------------------------------------
// TreeGrid event handler
// Called after every cell change
// Sets the cell is marked as changed only if contains not null value
// Also re-generates the report 
Grids.OnValueChanged = function(G,row,col,val) {
if(val<0) val = 0;
if(row.id=="CW" && val>1000) val = 1000;
var z = row[col]; row[col] = val;
var nl = !val && !row.D && !row.S && !row.F && !row.H && !row.J && !row.L && !row.N;
if(nl) row.Changed=0;
G.Recalculate(row,col,1);
UpdateOrder();
if(!nl){
   row[col] = z;
   G.ColorRow(row);
   }
G.SaveCfg();
return val;
}

// ---------------------------------------------------------------------------------------------------------------
// TreeGrid event handler
// Called after grid finished rendering
// Re-generates report for the first time - if grid loaded its state and values from cookies
Grids.OnRenderFinish = function(G){
UpdateOrder();
}

// ---------------------------------------------------------------------------------------------------------------
// Main function to generate report
function UpdateOrder(){
var G = Grids[0];
var F = G.GetRowById("Results"); // Gets the row to display there the report

var A = new Array(),a=0,B = new Array(),b=0;
var D1 = [["D","BASIC","B","C"],["S","PERSONAL","P","R"],["F","STANDARD","S","E"],["H","GRAND","G","G"]];
var D2 = [["J","STANDARD","S","BASIC","B","I"],["L","GRAND","G","STANDARD","S","K"],["N","GRAND","G","BASIC","B","M"]];

// --- Iterates all variable rows and checks if the appropriate cells contain value
for(var r=G.GetFirst();r;r=G.GetNext(r)){
   if((r.id=="ES" || r.id=="SCE") && r.F){
      var x = new Object();
      x.Count = r.F;
      x.Price = 250*x.Count;
      x.Name = r.A + " " + G.GetString(r,"I").replace(/DIV/g,"I");
      x.Id = r.id;
      A[a++] = x;
      }
   else if(r.id=="CW" && r.F){
      var x = new Object();
      x.Count = r.F;
      x.Price = 55*x.Count;
      x.Name = "custom work";
      x.Id = r.id;
      A[a++] = x;
      }
   else for(var i=0;i<4;i++){
      if(D1[i] && r[D1[i][0]]){
         var x = new Object();
         x.Count = r[D1[i][0]];
         x.Price = r[D1[i][3]]*x.Count;
         x.Name = r.A+" <B>"+D1[i][1]+"</B>";
         x.Id = D1[i][2]+r.id.split("_")[0];
         A[a++] = x;
         if(r.B){
            x = new Object();
            x.Count = r[D1[i][0]];
            x.Name = r.B+" <B>"+D1[i][1]+"</B>";
            x.Id = D1[i][2]+r.id.split("_")[1];
            x.Price = r[D1[i][3]]*x.Count;
            B[b++] = x;
            }      
         }
      if(D2[i] && r[D2[i][0]]){
         var x = new Object();
         x.Count = r[D2[i][0]];
         x.Price = r[D1[i][5]]*x.Count;
         x.Name = r.A+" <B>"+D2[i][1]+"</B>";
         x.Id = D2[i][2]+r.id.split("_")[0];
         A[a++] = x;
      
         x = new Object();
         x.Count = r[D2[i][0]];
         x.Price = r[D2[i][5]]*x.Count;
         if(r.B){
            x.Name = r.B+" <B>"+D2[i][3]+"</B>";
            x.Id = D2[i][4]+r.id.split("_")[1];
            }
         else {
            x.Name = r.A+" <B>"+D2[i][3]+"</B>";
            x.Id = D2[i][4]+r.id.split("_")[0];
            }
         B[b++] = x;
         }
      }
   }
   
// --- Removes duplicities from ordered items (when upgrading A->B and B->C)
for(var i=0;i<B.length;i++) {
   if(!B[i]) continue;
   for(var j=0;j<B.length;j++) {
      if(!B[j]) continue;
      if(i!=j && B[i].Id==B[j].Id) {
         B[i].Count+=B[j].Count;
         B[j] = null;
         b--;
         }
      }
   }
for(var i=0;i<A.length;i++) {
   if(!A[i]) continue;
   for(var j=0;j<A.length;j++) {
      if(!A[j]) continue;
      if(i!=j && A[i].Id==A[j].Id) {
         A[i].Count+=A[j].Count;
         A[i].Price+=A[j].Price;
         A[j] = null;
         a--;
         }
      }
   }

for(var i=0;i<B.length;i++){
   if(!B[i]) continue;
   for(var j=0;j<A.length;j++){
      if(!A[j]) continue;
      if(B[i].Id==A[j].Id){
         if(B[i].Count==A[j].Count){ A[j] = null; B[i] = null; a--; b--; break;}
         else if(B[i].Count<A[j].Count){ A[j].Count-=B[i].Count; A[j].Price-=B[i].Price; B[i] = null; b--; break; }
         else { B[i].Count-=A[j].Count; B[i].Price-=A[j].Price; A[j] = null; a--; }            
         }
      }
   }

// --- Creates the report text
F.C = "";
if(b){
   F.C += "<BR><I>You declare you have already purchased these components:</I><BR>";
   for(var i=0;i<B.length;i++){
      if(B[i]) F.C += "&nbsp;&nbsp;&nbsp;<SPAN style='color:red;'><B>"+B[i].Count + "</B>x "+B[i].Name+"</SPAN><BR>";
      }
   F.C += "<HR>";
   }

if(a){
   LCnt = new Object(); LPrice = new Object();
   if(!b) F.C+="<BR>";
   F.C += "<B>Your order:</B><BR>";
   for(var i=0;i<A.length;i++){
      if(A[i]){ 
         var mult = "x";
         if(A[i].Id=="ES" || A[i].Id=="SCE") mult = " years of";
         else if(A[i].Id=="CW") mult = " hours of";
         F.C += "&nbsp;&nbsp;&nbsp;<SPAN style='color:blue;'><B>"+A[i].Count + "</B>"+mult+" "+A[i].Name+"</SPAN><BR>";
         if(!LCnt[A[i].Id]) LCnt[A[i].Id] = A[i].Count;
         else LCnt[A[i].Id] += A[i].Count;
         if(!LPrice[A[i].Id]) LPrice[A[i].Id] = A[i].Price;
         else LPrice[A[i].Id] += A[i].Price;
         }
      }
   F.C += "<HR>";
   F.C += "Total order price is <B>"+G.GetRowById("Total").O+"</B> USD&nbsp;&nbsp;&nbsp;<BUTTON onclick='Submit();'><B style='color:\"green\"'>Purchase this order</B></BUTTON><BR>";
   F.C += "<BR>";
   }
else F.C = "<I>No order yet</I>"

G.RefreshRow(F);   // refreshes the row 
G.SetScrollBars(); // updates the grid size when report changed
}

// ---------------------------------------------------------------------------------------------------------------
// Function called when calculating from formula in XML data
function AddYear(y){
var d=new Date(); 
d.setFullYear(d.getFullYear()+y); 
return d.getTime();
}
// ---------------------------------------------------------------------------------------------------------------