// SampleCPPDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SampleCPP.h"
#include "SampleCPPDlg.h"
#include "import.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSampleCPPDlg dialog




CSampleCPPDlg::CSampleCPPDlg(CWnd* pParent)
	: CDialog(CSampleCPPDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSampleCPPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_CREATE_DIRECTORY, m_NewDirName);
	DDX_Control(pDX, IDC_EDIT_CREATE_FILE, m_fileName);
}

BEGIN_MESSAGE_MAP(CSampleCPPDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_NOTIFY(TVN_ITEMEXPANDING, IDC_TREE1, &CSampleCPPDlg::OnTvnItemexpandingTree1)
	ON_BN_CLICKED(IDC_REMOVE_DIRECTORY, &CSampleCPPDlg::OnBnClickedRemoveDirectory)
	ON_BN_CLICKED(IDC_CREATE_DIRECTORY, &CSampleCPPDlg::OnBnClickedCreateDirectory)
	ON_BN_CLICKED(IDC_CREATE_FILE, &CSampleCPPDlg::OnBnClickedCreateFile)
	ON_BN_CLICKED(IDC_DELETE_FILE_BUTTON, &CSampleCPPDlg::OnBnClickedDeleteFileButton)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// CSampleCPPDlg message handlers

BOOL CSampleCPPDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	ASSERT(pCtrl != NULL);
	CBitmap bm;
	m_TreeImages.Create(IDB_FOLDER, 16, 1, RGB(255, 255, 255));
	bm.LoadBitmapW(IDB_FOLDER_OPEN);
	m_TreeImages.Add(&bm, RGB(255,255,255));
	CBitmap cbm;	
	cbm.LoadBitmapW(IDB_FILE_UNKNOWN);
	m_TreeImages.Add(&cbm, RGB(255,255,255));
	pCtrl->SetImageList(&m_TreeImages, TVSIL_NORMAL);
	RefreshDisplay(pCtrl);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//Function to get files list for the path
void CSampleCPPDlg::GetFilesList(CString path, __out CList<CString, CString&>& res)
{
	res.RemoveAll();
	WIN32_FIND_DATA findData;
	HANDLE findHandle = FindFirstFileL(path + _T("\\*"), __out &findData);
	if(findHandle != INVALID_HANDLE_VALUE)
	{
		do
        {
			CString currentFileName = findData.cFileName;
			// It's a file; add it to the results.
			if(((int)findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0)
			{
				res.AddTail(path + _T("\\") +currentFileName);
			}          
        }
        while (FindNextFileL(findHandle, __out &findData));
		// Close the find handle.
		FindCloseL(findHandle);
     }    
}

//Function to get directories list for the path
void CSampleCPPDlg::GetDirectoriesList(CString path,__out CList<CString, CString&>& res)
{
	res.RemoveAll();
	WIN32_FIND_DATA findData;
	HANDLE findHandle = FindFirstFileL(path + _T("\\*"), __out &findData);
	if(findHandle != INVALID_HANDLE_VALUE)
	{
		do
		{
			CString currentFileName = findData.cFileName;
			// It's a directory; add it to the results.
			if(((int)findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0)
			{
				if(currentFileName != "." && currentFileName != "..")
				{
					res.AddTail(path + _T("\\") + currentFileName);
				}
			}
		}
		while (FindNextFileL(findHandle, __out &findData));
		FindCloseL(findHandle);
	}	
}

//Function to get full path to the tree item of the tree control
CString CSampleCPPDlg::FullPath(CTreeCtrl *pCtrl, HTREEITEM hTreeItem)
{
	CString fullPath = pCtrl->GetItemText(hTreeItem);
	HTREEITEM hParentItem = pCtrl->GetParentItem(hTreeItem);
	while(hParentItem != NULL)
	{
		CString itemText = pCtrl->GetItemText(hParentItem);
		fullPath = itemText + _T("\\") + fullPath;
		hParentItem = pCtrl->GetParentItem(hParentItem);
	}
	//remove extra backslash
	if(fullPath.GetLength() > 2)
		fullPath.Delete(2, 1);
	return fullPath;
}

//Function to fill the child items of the tree item for the tree control
void CSampleCPPDlg::Fill(CTreeCtrl* pCtrl, HTREEITEM hTreeItem)
{
	CList<CString, CString&> directoriesList;
	GetDirectoriesList(FullPath(pCtrl, hTreeItem), __out directoriesList);
	for(int i = 0; i < directoriesList.GetSize(); i++)
	{
		CString itemText = directoriesList.GetAt(directoriesList.FindIndex(i));
		HTREEITEM tempItem = pCtrl->InsertItem(itemText.Right(itemText.GetLength() - itemText.ReverseFind('\\') -1), hTreeItem, TVI_LAST);
		pCtrl->InsertItem(L"*", tempItem, TVI_LAST);
		pCtrl->SetItemImage(tempItem, 0, 1);
	}

	CList<CString, CString&> filesList;
	GetFilesList(FullPath(pCtrl, hTreeItem), __out filesList);
	for(int i = 0; i < filesList.GetSize(); i++)
	{
		CString itemText = filesList.GetAt(filesList.FindIndex(i));
		HTREEITEM tempItem = pCtrl->InsertItem(itemText.Right(itemText.GetLength() - itemText.ReverseFind('\\') -1), hTreeItem, TVI_LAST);
		pCtrl->SetItemImage(tempItem, 2, 2);
	}
}

void CSampleCPPDlg::RefreshDisplay(CTreeCtrl* pCtrl)
{
	pCtrl->DeleteAllItems();
	drives = GetLogicalDrives();
	TVINSERTSTRUCT tvInsert;
	HTREEITEM hTreeNode;
	for(int i = 0; i < 32; i++)
	{
		if(_bittest(&drives, i))
		{	
			tvInsert.hParent = NULL;
			tvInsert.hInsertAfter = NULL;
			tvInsert.item.mask = TVIF_TEXT;
			char disk = 65 + i;
			CString drive(disk);
			drive = drive + L":\\";
			LPWSTR dr = drive.GetBuffer();
			tvInsert.item.pszText = dr;
			hTreeNode = pCtrl->InsertItem(&tvInsert);
			Fill(pCtrl, hTreeNode);
		}
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSampleCPPDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSampleCPPDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CSampleCPPDlg::OnTvnItemexpandingTree1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	ASSERT(pCtrl != NULL);
	HTREEITEM hSelectedItem = pNMTreeView->itemNew.hItem;
	if(pNMTreeView->action != TVE_COLLAPSE)
	{
		pCtrl->SetItemImage(hSelectedItem, 1, 1);
		HTREEITEM hChildItem = pCtrl->GetChildItem(hSelectedItem);
		CString text = pCtrl->GetItemText(hChildItem);
		if(text == L"*")
		{
			pCtrl->DeleteItem(hChildItem);
			Fill(pCtrl, hSelectedItem);
		}
	}
	else
	{
		pCtrl->SetItemImage(hSelectedItem, 0, 0);
	}
	
	*pResult = 0;
}

void CSampleCPPDlg::OnBnClickedRefreshButton()
{
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	ASSERT(pCtrl != NULL);
	RefreshDisplay(pCtrl);
}

void CSampleCPPDlg::OnBnClickedRemoveDirectory()
{
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	ASSERT(pCtrl != NULL);
	HTREEITEM hSelectedItem = pCtrl->GetSelectedItem();
	HTREEITEM hChildItem = pCtrl->GetChildItem(hSelectedItem);
	CString root = FullPath(pCtrl, hSelectedItem);
	RemoveDirectoryL(root);
	int lastWin32Error = GetLastError();
	CheckForTrial(lastWin32Error);
	RefreshDisplay(pCtrl);
}

void CSampleCPPDlg::OnBnClickedCreateDirectory()
{
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	ASSERT(pCtrl != NULL);
	HTREEITEM hSelectedItem = pCtrl->GetSelectedItem();
	CString root = FullPath(pCtrl, hSelectedItem);
	LPTSTR dirName = new WCHAR[260];
	m_NewDirName.GetLine(0, dirName);
	CreateDirectoryL(root + L"\\" + dirName, NULL);
	delete [] dirName;
	RefreshDisplay(pCtrl);	
}

void CSampleCPPDlg::OnBnClickedCreateFile()
{
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	ASSERT(pCtrl != NULL);
	HTREEITEM hSelectedItem = pCtrl->GetSelectedItem();
	CString root = FullPath(pCtrl, hSelectedItem);	
	LPTSTR fileName = new WCHAR[260];
	m_fileName.GetLine(0, fileName);
	HANDLE fileHandle = CreateFileL(root + L"\\" + fileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL);
	int lastWin32Error = GetLastError();	
	delete [] fileName;
	CheckForTrial(lastWin32Error);
	RefreshDisplay(pCtrl);	
}

void CSampleCPPDlg::OnBnClickedDeleteFileButton()
{
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	ASSERT(pCtrl != NULL);
	HTREEITEM hSelectedItem = pCtrl->GetSelectedItem();
	HTREEITEM hChildItem = pCtrl->GetChildItem(hSelectedItem);
	CString root = FullPath(pCtrl, hSelectedItem);
	DeleteFileL(root);
	int lastWin32Error = GetLastError();
	CheckForTrial(lastWin32Error);
	RefreshDisplay(pCtrl);
}

void CSampleCPPDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	CTreeCtrl* pCtrl = (CTreeCtrl*) GetDlgItem(IDC_TREE1);
	if(pCtrl != NULL)
	{
		pCtrl->MoveWindow(0, 150, cx - 5, cy - 150 - 5);
	}
}
void CSampleCPPDlg::CheckForTrial(DWORD errorCode)
{
	if (errorCode == 0x5)
	{
		MessageBox(L"Limited in trial version.", L"", MB_OK | MB_ICONWARNING);
	}
}
