Attribute VB_Name = "modMain"
Option Explicit

Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public Sub Main()
    On Error GoTo ER

    Dim lSleepTime As Long

    Randomize Timer

    'Load the interface if the command line is "/I"
    If InStr(1, UCase(Command), "/I", vbTextCompare) = 0 Then 'Should be <> 0 for production
        'Previous instance running, load again?
        If App.PrevInstance = True Then
            Dim msgReturn As VbMsgBoxResult
            
            msgReturn = MsgBox("The program is already running as a service." & vbCrLf & _
                               "Do you want to load the interface anyway?", vbExclamation + vbYesNo, "RSI - Load Interface?")
        
            If msgReturn = vbNo Then
                'User said no, just end
                End
            End If
        End If
        
        'Show the interface
        Load frmMain
        frmMain.Show
    Else
        'Start the "poll" only. No interface.
        
        'Only allow the program to run as a service once
        If App.PrevInstance = True Then End
        
        'Load the service form
        Load frmService
        
        'Perform a random delay between 1 and 3 minutes
        lSleepTime = Int((Rnd * 120000) + 60000)
        doDelay lSleepTime
        
        'Check poll status to see if an inventory should be performed
        Dim oRemote As clsRemote
        Set oRemote = New clsRemote
        
        If oRemote.GetPollStatus = True Then
            Dim oSave As clsSaveSystemInfo
            Set oSave = New clsSaveSystemInfo
            oSave.SaveSystemInfo
            
            'Cleanup
            Set oSave = Nothing
        End If

        'Cleanup
        Set oRemote = Nothing

        'Start polling
        Call PollForScan
    End If

    Exit Sub
ER:
    Call ErrorHandler(Err.Description, Err.Number, Err.Source, "modMain@Main", True)
End Sub

Private Sub doDelay(lMS As Long)
    'General delay sub
    
    Dim lCount As Long
    
    Do
        Sleep 100
        lCount = lCount + 100
        DoEvents
    Loop Until lCount >= lMS
End Sub

Private Sub PollForScan()
    Dim oRemote As clsRemote
    Set oRemote = New clsRemote

    'Reset randomization
    Rnd -1
    Randomize Timer

    Do
        'Random delay between 2 and 10 minutes
        doDelay (120000) + Int(Rnd * 540000)
        
        'Check the remote file to see if a scan should be performed
        If oRemote.GetPollStatus = True Then
            Dim oSave As clsSaveSystemInfo
            Set oSave = New clsSaveSystemInfo
            oSave.SaveSystemInfo
            
            'Cleanup
            Set oSave = Nothing
        End If
    Loop
    
    Set oRemote = Nothing
End Sub
