<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% //PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>
 
<% PageUtils.setRequiredLoginStatus("user",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_USER_PREFS,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String successParam;
try
{
	boolean doNotifications=controller.getCurrentInstallationConfig().isDoNotifications();
	SessionInfo sessionInfo=controller.getSessionInfo();
	User user=sessionInfo.getUser();
	user.setUsername(controller.getParam("username"));
	user.setFullname(controller.getParam("fullname"));
	user.setDropUserCookie(controller.getParamAsBoolean("dropUserCookie"));
	
	// we only set this once:
	if (controller.getParamAsInt("secretQuestion",0)>0)
	{
		user.setSecretQuestion(controller.getParamAsInt("secretQuestion"));
		user.setSecretAnswer(controller.getParam("secretAnswer"));
	}

	if (doNotifications)
	{
		user.setEmailAddress(controller.getParam("emailAddress"));
		user.setPreDeadlineReminderBeforeMillis(controller.getParamAsLong("preDeadlineReminderBeforeMillis"));
		user.setDefaultNotificationPref(controller.getParamAsInt("defaultNotificationPref"));
		user.setSendMissedDeadlineReminder(controller.getParamAsBoolean("sendMissedDeadlineReminder"));
		user.setSendICalendarFileWithNotification(controller.getParamAsBoolean("sendICalendarFileWithNotification"));
	}
	String password=controller.getParam("password","");
	if (password.trim().length()>0)
	{
		// if the user entered a password, then he/she wants to change it (otherwise leave it):
		user.setPassword(controller.getParam("password"));
	}
	Manager.updateUser(user);
	sessionInfo.setUser(user);
	controller.setSessionInfo(sessionInfo);
	successParam="true";
}
catch (Exception e)
{
	Printer.pe("updating User in user prefs",e);
	successParam="false";
}

controller.redirect("showPrefsChanges.jsp?success="+successParam);
%>



<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

