<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>
       

<% PageUtils.jspStart(request); %>
<% //PageUtils.forceNoCache(response); %>
     
<%@ page import="java.util.*" %>   

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_FEEDBACK,request); %>
 
<%@ include file="../global/topInclude.jsp" %>
<%!

%>        

<%
 
boolean doNotifications=controller.isOkToDoNotifications();
boolean isSupportRequest=controller.getParamAsBoolean("isSupportRequest",false);

if (isSupportRequest)
{
	PageUtils.setSection(WorkRollConstants.SECTION_SUPPORT,request);
}
User user=controller.getSessionInfo().getUser();

String fullname="";
String emailAddress="";
String companyName="";
if (user!=null)
{
	fullname=PageUtils.nonNull(user.getFullname());
	emailAddress=PageUtils.nonNull(user.getEmailAddress());
	companyName=PageUtils.nonNull(controller.getCurrentInstallationConfig().getCompanyName());
}

Properties sysProps=null;
try
{
	sysProps=controller.getSystemProperties();
}
catch (Exception e)
{
	sysProps=new Properties();
}

String javaVersion="";
try
{
	javaVersion+=sysProps.getProperty("java.vm.version","");
	javaVersion+=", "+sysProps.getProperty("java.vm.vendor","");
	javaVersion+=", "+sysProps.getProperty("java.vm.name","");
	javaVersion+=" / ";
	javaVersion+=", "+sysProps.getProperty("java.version","");
	javaVersion+=", "+sysProps.getProperty("java.vendor","");


}
catch (Throwable t) {}

String appServer="";
try
{
	appServer+=application.getServerInfo();
	appServer+="; Servlet API "+application.getMajorVersion()+"."+application.getMinorVersion();
}
catch (Throwable t)
{}

String productKey=null;
try
{
	productKey=new String(controller.getCurrentInstallationConfig().getProductKey());
}
catch (Throwable t)
{}
if (productKey==null)
{
	productKey="[unregistered]";
}



String operatingSystem=sysProps.getProperty("os.name","")+" "+sysProps.getProperty("os.version","")+" ("+sysProps.getProperty("os.arch","")+")";


%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/popupHeadInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">


var doNotifications=<%=doNotifications?"true":"false"%>
var browserVer=(navigator.appName+" "+navigator.appVersion).replace(/Microsoft Internet Explorer/g,"MSIE")
var commentsEmailAddress="<%=WorkRollConstants.COMMENTS_EMAIL_ADDRESS%>"


function isValidForm(formObj)
{
	var els=formObj.elements

	if (trim(els["fullname"].value).length==0)
	{
		errorAlert("You have not entered your name. Please fix and try again.",els["fullname"])
		return false
	}
	if (trim(els["emailAddress"].value).length==0)
	{
		errorAlert("You have not entered your email address. Please fix and try again.",els["emailAddress"])
		return false
	}
	if (trim(els["comments"].value).length==0)
	{
		errorAlert("You have not entered any comments. Please fix and try again.",els["comments"])
		return false
	}
	
	// all reqd fields entered; now check for invalid entries:
	if (!isValidEmail(trim(els["emailAddress"].value)))
	{
		errorAlert("\""+trim(els["emailAddress"].value)+"\" is not a valid e-mail address. Please fix and try again.  \"myname@mycompany.com\" is an example of a valid e-mail address.",els["emailAddress"])
		return false
	}

	if (!(window.doNotifications))
	{
		setTimeout("sendSuccess(true)",2000)
	}
	hidePageAndShowPleaseWait()
	return true
}


  
 
function sendSuccess(isSuccess)
{
	if (isSuccess)
	{
		generalAlert("Thank you; your message has been sent.")
		top.close()
	}
	else
	{
		generalAlert("Hmm, there was a problem sending your message; please check with your administrator to make sure that he or she has configured e-mail properly.  In the meantime, you may send your comment via e-mail to "+window.commentsEmailAddress+".")
	}
} 

</script> 

<style type="text/css">
.inputClass {padding:2px; height:20px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; width:294px; } 
.textareaClass {padding:4px; height:120px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; } 
.selectClass {padding:2px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; }

</style>

 
  
 
</head>

<%@ include file="../global/bodyOpen.jsp" %>  

<div id=popupMainDiv>
<form <%
if (doNotifications)
{
	%>
	action=send.jsp target=hiddensubmitter
	<%
}
else
{
	%>
	action="mailto:<%=WorkRollConstants.COMMENTS_EMAIL_ADDRESS%>" 
	<%
}
%> method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>

<font class=bodyFont>

<%
if (isSupportRequest)
{
	%>
	<span class=firstSentenceFont>Need technical support?</span> Please enter your question or a description of the problem you are having below, then press the "get help" button. <%
	if (!doNotifications)
	{
		%>
		<i>Note: your administrator has not configured WorkRoll to send e-mail, so this message will be sent via the e-mail program on your computer.  If you have difficulty with this form, you can instead send mail directly to <a href="mailto:<%=WorkRollConstants.COMMENTS_EMAIL_ADDRESS%>">this address</a>, but please use this form if possible, as it contains prepopulated information about your WorkRoll server's configuration.</i>
		<%
	}

}
else
{
	%>
	<span class=firstSentenceFont>Please send your question or comment</span> by completing the form below and pressing the "send" button. <%
	if (!doNotifications)
	{
		%>
		<i>Note: your administrator has not configured WorkRoll to send e-mail, so this message will be sent via the e-mail program on your computer.  If you have difficulty with this form, you can instead send mail directly to <a href="mailto:<%=WorkRollConstants.COMMENTS_EMAIL_ADDRESS%>">this address</a>.</i>
		<%
	}

}
%>

<%=HtmlUtils.doubleLB(request)%>
 
<span class=boldishFont>Your name</span><BR>
<input type=text class=inputClass name=fullname id=fullname value="<%=fullname%>"><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Your e-mail address</span><BR>
<input type=text class=inputClass name=emailAddress id=emailAddress value="<%=emailAddress%>"><%=HtmlUtils.doubleLB(request)%>





<%
if (isSupportRequest)
{
	%><input type=hidden name=commentType value="support@workroll.com"><%
}
else
{
	%><span class=boldishFont>What is your question or comment regarding?</span><BR>
	<select name=commentType id=commentType class=selectClass>
	<option value="comments@workroll.com">Choose one...</option>
	<option value="suggestions@workroll.com">Suggestion/feature request</option>
	<option value="support@workroll.com">Technical support</option>
	<option value="sales@workroll.com">License/upgrade question</option>
	<option value="comments@workroll.com">Something else</option>
	</select><%=HtmlUtils.doubleLB(request)%><%
}
%>

<%
if (isSupportRequest)
{
	%><span class=boldishFont>URL related to your question or problem</span> (optional)<BR> 
<input type=text class=inputClass name=supportUrl id=supportUrl value="<%=controller.getParam("currUrl","")%>"><%=HtmlUtils.doubleLB(request)%><%
}
else
{
	%><%
}
%>


<%
if (isSupportRequest)
{
	%><span class=boldishFont>Your question, or a description of the problem<BR>you're having </span>(in as much detail as possible)<%
}
else
{
	%><span class=boldishFont>Your comment or question</span><%
}
%><BR>
<textarea class=textareaClass rows=10 cols=40 name=comments id=comments wrap=virtual></textarea><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>WorkRoll version</span> (optional)<BR>
<input type=text class=inputClass name=appVersion id=appVersion value="<%=controller.getAppVersion()%>"><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>WorkRoll product key</span> (optional/if applicable)<BR>
<input type=text class=inputClass name=productKey id=appVersion value="<%=productKey%>"><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Application server and version</span> (optional)<BR>
<input type=text class=inputClass name=appServer id=appServer value="<%=appServer%>"><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Application server operating system</span> (optional)<BR>
<input type=text class=inputClass name=operatingSyste id=operatingSystem value="<%=operatingSystem%>"><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Application server Java version</span> (optional)<BR>
<input type=text class=inputClass name=javaVersion id=javaVersion value="<%=javaVersion%>"><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Your browser and operating system</span> (optional)<BR>
<script>
document.write("<input type=text class=inputClass name=browserVer id=browserVer value=\""+browserVer+"\">")
</script><%=HtmlUtils.doubleLB(request)%>



<%
if (isSupportRequest)
{
	%>
	<input  class=formButton type=submit value="get help" style=width:75px;>
	<%
}
else
{
	%>
	<input  class=formButton type=submit value=send>
	<%
}
%>

 <input  class=formButton type=button value=cancel onclick="top.close()"><BR>

<BR>
</font>

</form>	

</div>

<%@ include file="../global/popupBodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

