<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setSkipTrialPeriodExpireCheck(true,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>

<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>
 
<%


InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
char[] currentKeyChars=installationConfig.getProductKey();
String currentKey=(currentKeyChars==null?"":new String(currentKeyChars));
boolean appAlreadyRegistered=(currentKey.trim().length()>0);

boolean keyError=false;
String key=controller.getParam("k");
if (key.trim().length()>0)
{
	keyError=true;
}
if (key.trim().length()==0)
{
	key=""+currentKey;
}



%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

function isValidForm(formObj)
{
	var els=formObj.elements
	if (trim(els["k"].value).length==0)
	{
		errorAlert("You have not entered a product key. Please enter the product key you received after purchasing a WorkRoll license or upgrade and try again.",els["k"])
		return false
	}
	
	if (trim(els["k"].value).length!=27)
	{
		errorAlert("\""+trim(els["k"].value)+"\" is not a valid product key. Product keys are 27 characters long and contain only numerals.  Please fix and try again.",els["k"])
		return false
	}
	hidePageAndShowPleaseWait()
	return true
}

<% pageContext.include("js/js.jsp"); %>

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
                                     
<form action=processUpdateKey.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<font class=bodyFont>

<%
if (keyError)
{
	%>
	<div class=errorDiv>The product key you entered was not valid.  Please make sure you entered it correctly, then press "update" again. <%
	if (currentKey.trim().length()>0)
	{
		%>
		If you do not try again to enter your new key, the installation will stay configured with your current key,  <b><%=currentKey%></b>.
		<%
	}
	%></div><br>
	<%
}


%>


<span class=standardTextBlockWidth>

<%
if (!appAlreadyRegistered)
{
	%>
	<span class=boldishFont>Enter your new product key</span> in the form below.  Entering the product key you've just received will activate your license and allow WorkRoll to function beyond your ten-day trial period.
	<%
}
else
{
	%>
	<span class=boldishFont>Enter your new product key</span> in the form below.  Entering the product key you've just received will activate the license or upgrade you've just purchased.
	<%
}
%>


</span>
<%=HtmlUtils.doubleLB(request)%><BR>

<span class=boldishFont>New product key</span><BR>
<input type=text class=inputText size=30 name=k id=k value="<%=key%>"><br><br>


<input  class=formButton type=submit value=update><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

