<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
  
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredLoginStatus("superuser",request); %>

<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
String companyName=PageUtils.nonNull(installationConfig.getCompanyName());
String adminName=PageUtils.nonNull(installationConfig.getAdminName());
String adminEmail=PageUtils.nonNull(installationConfig.getAdminEmail());

boolean success=controller.getParamAsBoolean("success",true);

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>

<span class=standardTextBlockWidth><form>
<font class=bodyFont>
<%
if (success)
{
	%>
	<span class=firstSentenceFont>Your changes have been made</span> and appear below.  
	<%
}
else
{
	%>
	<span class=firstSentenceFont>There was a problem.</span> Some or all of your data may not have been saved. Please review the values below.
	<%
}

%>



You may now:

<ul>
<%
if (!success)
{
	%>
	<li><A href="../feedback/compose.jsp">report the problem you just experienced</a>
	<%
}
%>
<li><A href="menu.jsp">return to the global admin menu</a>
<li><a href="generalConfig.jsp">make more general-configuration changes</a>
<li><a href="emailConfig.jsp">make e-mail configuration changes</a>



<%=HtmlUtils.doubleLB(request)%>
</ul>

<span class=boldishFont>Company or registrant name</span>: <%=companyName%><%=HtmlUtils.doubleLB(request)%>


<span class=boldishFont>Primary contact name</span>: <%=adminName%><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Primary contact e-mail</span>: <%=HtmlUtils.getMailtoLink(adminEmail)%><%=HtmlUtils.doubleLB(request)%>





<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>
</form>
</span>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

