<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
  
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredLoginStatus("superuser",request); %>

<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
String mailSubjectPrefixInitialNotification=PageUtils.nonNull(installationConfig.getMailSubjectPrefixInitialNotification());
String mailSubjectPrefixChangeNotification=PageUtils.nonNull(installationConfig.getMailSubjectPrefixChangeNotification());
String mailSubjectPrefixReminderApproaching=PageUtils.nonNull(installationConfig.getMailSubjectPrefixReminderApproaching());
String mailSubjectPrefixReminderMissed=PageUtils.nonNull(installationConfig.getMailSubjectPrefixReminderMissed());
String smtpHost=PageUtils.nonNull(installationConfig.getSmtpHost());
String smtpLocalhost=PageUtils.nonNull(installationConfig.getSmtpLocalhost());
String smtpUsername=PageUtils.nonNull(installationConfig.getSmtpUsername());
String smtpPassword=PageUtils.nonNull(installationConfig.getSmtpPassword());
String companyName=PageUtils.nonNull(installationConfig.getCompanyName());
String adminName=PageUtils.nonNull(installationConfig.getAdminName());
String adminEmail=PageUtils.nonNull(installationConfig.getAdminEmail());
int smtpPort=installationConfig.getSmtpPort();
boolean doNotifications=installationConfig.isDoNotifications();

boolean success=controller.getParamAsBoolean("success",true);

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>

<span class=standardTextBlockWidth><form>
<font class=bodyFont>
<%
if (success)
{
	%>
	<span class=firstSentenceFont>Your changes have been made.</span> Your new e-mail configuration is below.  
	<%
}
else
{
	%>
	<span class=firstSentenceFont>There was a problem.</span> Some or all of your data may not have been saved. The current e-mail configuration is below.  
	<%
}

if (controller.getParam("defAddrAdded","").length()>0)
{
	String addrExplanationText;
	if (controller.getParam("defAddrAdded").indexOf("postmaster@")>-1)
	{
		addrExplanationText="Since you have not configured an administrator e-mail address, this address is the default address for the SMTP server you have specified (\""+controller.getParam("defAddrAdded")+"\"). ";
	}
	else
	{
		addrExplanationText="Since you have configured an administrator e-mail address, that address (\""+controller.getParam("defAddrAdded")+"\") has been used. ";
	}
	%>
	<i>Please note: you have enabled e-mail notifications, but one or more of your users did not have an assigned e-mail address. <%=addrExplanationText%>  However, you should review the current list of users and supply a user-specific e-mail address for each user that did not have one.</i>
	<%
}
%>



You may now:

<ul>
<%
if (!success)
{
	%>
	<li><A href="../feedback/compose.jsp">report the problem you just experienced</a>
	<%
}
if (controller.getParam("defAddrAdded","").length()>0)
{
	%>
	<li><A href="users.jsp">Supply each user with a user-specific e-mail address (see above)</a>
	<%
}
%>
<li><A href="menu.jsp">return to the global admin menu</a>
<li><a href="emailConfig.jsp">make more e-mail configuration changes</a>



<%=HtmlUtils.doubleLB(request)%>
</ul>



<span class=boldishFont>Enable e-mail notifications/reminders?</span>: <%=doNotifications?"yes":"no"%><%=HtmlUtils.doubleLB(request)%>
<%
if (doNotifications)
{
	%>
	<span class=boldishFont>SMTP mail-server hostname</span>: <%=smtpHost%><BR>
	<span class=boldishFont>Localhost name (for HELO commands)</span>: <%=smtpLocalhost%><BR>
	<span class=boldishFont>SMTP username</span>: <%=smtpUsername%><BR>
	<span class=boldishFont>Password for above username:</span> <%=HtmlUtils.getPasswordAsterisks(smtpPassword)%><BR>
	<span class=boldishFont>SMTP port number:</span> <%=smtpPort%><BR>
	<span class=boldishFont>Prefix for new-issue notifications:</span> <%=mailSubjectPrefixInitialNotification%><BR>
	<span class=boldishFont>Prefix for changed-issue notifications:</span> <%=mailSubjectPrefixChangeNotification%><BR>
	<span class=boldishFont>Prefix for issue reminders (missed deadline):</span> <%=mailSubjectPrefixReminderMissed%><BR>
	<span class=boldishFont>Prefix for issue reminders (approaching deadline):</span> <%=mailSubjectPrefixReminderApproaching%><BR>
	<%=HtmlUtils.doubleLB(request)%><%
}
%>





<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>
</form>
</span>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

