<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

  
<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

ArrayList allInstances=Manager.selectAllInstances();
if (allInstances==null)
{
	allInstances=new ArrayList();
}
String[] names=new String[allInstances.size()];
String[] rootUrls=new String[allInstances.size()];
int[] ids=new int[allInstances.size()];

for (int i=0; i<allInstances.size(); i++)
{
	Instance instance=(Instance)allInstances.get(i);
	names[i]=instance.getName();
	rootUrls[i]=instance.getRootUrl();
	ids[i]=instance.getId();
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

var numInstances=<%=allInstances.size()%>
var doNotifications=<%=(controller.getCurrentInstallationConfig().isDoNotifications()?"true":"false")%>

function isValidForm(formObj)
{
	var els=formObj.elements
	// we have at least one instance; make sure that all instances entered have all fields entered:
	for (var i=0; i<numInstances; i++)
	{
		var instanceName=trim(els["name"+i].value)
		if (instanceName.length==0)
		{
			errorAlert("You have left a name blank; all instances must have a name. Please fix and try again.",els["name"+i])
			return false
		}
	}
	if (duplicateInstanceNamesInForm(formObj,numInstances))
	{
		return false
	}
	hidePageAndShowPleaseWait()
	return true
}

<% pageContext.include("js/js.jsp"); %>

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>

<form action=processInstances.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<input type=hidden name=numInstances id=numInstances value="<%=names.length%>">
<font class=bodyFont>

<span class=standardTextBlockWidth><span class=firstSentenceFont>Edit instances here<%=HelpManager.helpLink("instance",request)%></span>.  If you've changed your mind and don't want to edit any instances right now, click the "cancel" button below.</span>
</span><%=HtmlUtils.doubleLB(request)%><BR>

<table border=0 cellspacing=0 cellpadding=0>
<%@ include file="instancesTableHeaderRow.jsp" %>



<% 

for (int i=0; i<names.length; i++)
{
	%>
	<input type=hidden name=id<%=i%> id=id<%=i%> value="<%=ids[i]%>">
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=24>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=25 name=name<%=i%> id=name<%=i%> value="<%=names[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=45 name=rootUrl<%=i%> id=rootUrl<%=i%> value="<%=rootUrls[i]%>">&nbsp;<BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr> 
	<%=HtmlUtils.getHorizRuleTr(4, request)%>
	<%
}
  
%>

</table><BR>

<input  class=formButton type=submit value=change> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

