<%@ page import="com.workroll.app.*" %>
<%@ page import="com.workroll.app.util.*" %>
<%@ page import="com.workroll.app.control.*" %>

<% PageUtils.forceNoCache(response); %>
<% PageUtils.setPathToAppRoot("../../",request); %>


<%!
static final String FS=WorkRollConstants.FILE_SEPARATOR;
%>
 

<%
Controller controller=new Controller();
controller.initController(pageContext);
String dbPath=com.workroll.app.filesystem.FileSystem.getDbPath(application,true);

boolean haveDbPath=(dbPath!=null && dbPath.trim().length()>0);

if (haveDbPath && com.workroll.app.filesystem.FileSystem.isInstalledAsWebapp(application))
{
	// if user is installing as non-web-app, then he'll specify db path on this page; however, if is installing as
	// webapp, we can pass the dbpath right on to the set-database jsp:
	controller.redirect("setDbLocation.jsp?dbPath="+java.net.URLEncoder.encode(dbPath));
}





%>
 
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>

<HEAD>

<TITLE>Welcome to WorkRoll</TITLE>

<%@ include file="../../global/headInclude.jsp" %>


<script>
function createDb(dbLoc)
{
	if (dbLoc==null)
	{
		location.href="specifyDbLocInstrux.jsp"
	}
	else
	{
		var dbCreateSuccess=false
		if (dbCreateSuccess)
		{
			generalAlert("The database was successfully created at \""+dbLoc+"\".  To continue configuration, press \"OK.\"")
		}
		else
		{
			errorAlert("WorkRoll encountered an error when it tried to create the database at \""+dbLoc+"\". Please make sure that this is a valid path on the WorkRoll server and try again.")
		}
	}
}

function isValidForm(formObj)
{
	var els=formObj.elements
	if (els["dbPath"].value.length==0)
	{
		alert("Please enter a filesystem path  (such as \"c:\\workrolldb\" for Windows or \"/misc/workrolldb\" for UNIX) in the textbox and try again.")
		return false
	}
	return true
}


</script>

<style type=text/css>
a {text-decoration:none;}
.bodyText {font-family:arial,helvetica; font-size:11px; color:#000000;}
.formButton {background-color:#870000; color:#cccc99; border:1px solid #870000; width:65px; }
#mainDiv {position:absolute; top:93px; left:15px; }
</style>
 
</HEAD>

<BODY onload="if (window.init) {init()}" BGCOLOR="#FFFFFF" link=#ff6600 vlink=#ff6600 alink=#ff6600>
<div id=mainDiv>
<form action=setDbLocation.jsp onsubmit="return isValidForm(this)">
<img src=../../images/workRollInstaller.gif height=73 width=588><BR><BR>
<span style="width:450px;">
<font class=bodyText><B>Welcome to Workroll.</B><BR><BR>
If you are reading this text and if you see the words "WorkRoll Installer" in orange above, then you have successfully configured your application server to recognize WorkRoll.<BR><BR>



<%
if (haveDbPath)
{
	%>
	WorkRoll has created its database, so now we'll customize your WorkRoll installation.  Click <B><a href="compileJsps.jsp">here</B></a> to begin.<BR>	
	<%
}
else
{
	if (!(com.workroll.app.filesystem.FileSystem.isInstalledAsWebapp(application)))
	{
		%>
		The next step is for WorkRoll to create a place on your file system for its database.  This database can be anywhere on the server where you just installed WorkRoll.  Please specify a path for the database in the textbox below (e.g. "c:\workrolldb" for Windows, or "/misc/workrolldb" for UNIX), then click the "create" button.  WorkRoll will attempt to create the database (and, if it doesn't exist, the directory you specify) at this location, and will tell you if it encounters a problem:<BR><BR>
		<input type=text size=40 name=dbPath value="">
		<input type=submit value="create" class=formButton><BR>

		<%
	}
	else
	{
		%>
		<B>However,</B> since you have installed WorkRoll as a J2EE web application (that is, via a WAR file), you must specify a "workroll.db.path" context parameter as directed in the <a href="http://www.workroll.com/wr/download/webapp.jsp" target=_blank>installation instructions</a> before installation can continue.  (If you are in a rush and your application server runs WAR files unextracted, you may add this context parameter to workroll/WEB-INF/web.xml, however this is not recommended, as your configuration may be erased if you ever upgrade to a newer version of WorkRoll.  If you do opt to configure WorkRoll in this way, please make a note of the path that you specify in this parameter.)<BR>

		<%
	}
}
%>
<BR>
<%@ include file="helpInclude.jsp" %>

</font>
</span>

</form>
</div>
</BODY>

</HTML>
