// Viewtree.h : interface of the CViewTree class
//
/////////////////////////////////////////////////////////////////////////////
#if !defined(AFX_VIEWTREE_H__00E433B9_33BC_11D3_88CA_00C0F023D5BE__INCLUDED_)
#define AFX_VIEWTREE_H__00E433B9_33BC_11D3_88CA_00C0F023D5BE__INCLUDED_

#include "Defines.h"

class CViewTree : public CTreeView
{
protected: // create from serialization only
	CViewTree();
	DECLARE_DYNCREATE(CViewTree)

	HTREEITEM m_hDesktop; // the hItem for the Desktop (tree root)
	void AddPhonyChild(HTREEITEM hItem);
	void OnCloseCleanTree(void);
	void RecurseCleanTree(CTreeCtrl* pControl, HTREEITEM hItem);
	BOOL IsDriveReady(HITEMHELPER * pHelper, const char * szRoot);
	void PopulateExpandingParent(HTREEITEM hItem);
	CString ItemToPath(HTREEITEM hItem);
	BOOL m_bRefuseSelection;
	BOOL AreThereSubDirs(CString sStart);
	void ResetTree(void);
	void FillFromTreeSelect(CString sRoot);

// Attributes
public:
	CWinExpDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CViewTree)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CViewTree();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

	void FillEmptyTree(void);

public:

// Generated message map functions
protected:
	//{{AFX_MSG(CViewTree)
	afx_msg void OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnImage();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnKeydown(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in View.cpp
inline CWinExpDoc* CViewTree::GetDocument()
   { return (CWinExpDoc*)m_pDocument; }
#endif

#endif // !defined(AFX_VIEWTREE_H__00E433B9_33BC_11D3_88CA_00C0F023D5BE__INCLUDED_)

/////////////////////////////////////////////////////////////////////////////
