/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import stec.ss.ssBuffer;
import stec.ss.ssException;
import stec.ss.ssProgram;
import stec.ss.ssSystem;
import stec.ss.ssToken;

final class ssTokenizer {
    private ssSystem system;
    private ssBuffer source;
    private int currentTokenOffset;
    private int nextTokenOffset;
    private int mark;
    protected String sValue;
    protected int iValue;

    protected ssTokenizer(ssProgram _program) {
        this.system = _program.system;
        this.source = _program.getSource();
        this.currentTokenOffset = 0;
        this.nextTokenOffset = 0;
        this.mark = 0;
    }

    protected final int mark() {
        this.mark = this.currentTokenOffset;
        return this.mark;
    }

    protected final int reset() {
        this.currentTokenOffset = this.mark;
        this.mark = 0;
        return this.currentTokenOffset;
    }

    protected final int reset(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.source.length()) {
            n = this.source.length();
        }
        this.currentTokenOffset = n;
        this.mark = 0;
        return this.currentTokenOffset;
    }

    protected final byte getNextToken() throws ssException {
        byte token = this.peekAtNextToken();
        this.currentTokenOffset = this.nextTokenOffset;
        return token;
    }

    protected final void incrementTokenOffset() {
        this.currentTokenOffset = this.nextTokenOffset;
    }

    protected final byte peekAtNextToken() throws ssException {
        this.nextTokenOffset = this.currentTokenOffset;
        if (this.nextTokenOffset < this.source.length()) {
            if (this.system.gProcessor == 3) {
                return this.peekAtNextStatementToken();
            }
            if (this.system.gInStatement) {
                return this.peekAtNextStatementToken();
            }
            return this.peekAtNextDataBlock();
        }
        return -1;
    }

    private final byte peekAtNextStatementToken() throws ssException {
        byte tbyt;
        int tOffset;
        byte bToken = this.source.getByteAt(this.nextTokenOffset);
        switch (bToken) {
            case 13: {
                ++this.nextTokenOffset;
                return 13;
            }
            case 10: {
                ++this.nextTokenOffset;
                return 10;
            }
            case 59: {
                ++this.nextTokenOffset;
                return 59;
            }
            case 46: {
                return this.parseDot();
            }
            case 35: {
                if (this.nextTokenOffset != 0 || this.system.gCurrentLineNumber != 1) break;
                return this.parseCommand();
            }
        }
        char chr = (char)bToken;
        if (Character.isDigit(chr)) {
            return this.parseNumber();
        }
        if (Character.isLetter(chr) || "@$_".indexOf(chr) != -1) {
            return this.parseSymbol();
        }
        if ("\t ".indexOf(chr) != -1) {
            return this.parseDelimiter();
        }
        if ("'\"".indexOf(chr) != -1) {
            return this.parseString();
        }
        if (this.system.gProcessor != 3 && bToken == 37 && (tOffset = this.nextTokenOffset + 1) < this.source.length() && (tbyt = this.source.getByteAt(tOffset)) == 62) {
            this.system.gInStatement = false;
            this.nextTokenOffset += 2;
            return 66;
        }
        return this.parseOther();
    }

    private final byte peekAtNextDataBlock() throws ssException {
        int lineCount = 0;
        int sOffset = this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            byte byt = this.source.getByteAt(this.nextTokenOffset);
            if (byt == 10) {
                ++lineCount;
            } else if (byt == 60) {
                int tOffset = this.nextTokenOffset + 1;
                if (tOffset >= this.source.length()) break;
                if (this.source.getByteAt(tOffset) == 37) {
                    this.nextTokenOffset += 2;
                    this.system.gInStatement = true;
                    int length = this.nextTokenOffset - sOffset - 2;
                    if (length > 0) {
                        this.iValue = lineCount;
                        this.sValue = new String(this.source.getByteArray(), sOffset, length);
                        return 48;
                    }
                    return 66;
                }
            } else if (byt == 35 && this.nextTokenOffset == 0 && this.system.gCurrentLineNumber == 1) {
                return this.parseCommand();
            }
            ++this.nextTokenOffset;
        }
        if (this.nextTokenOffset == sOffset) {
            return -1;
        }
        this.iValue = lineCount;
        this.sValue = new String(this.source.getByteArray(), sOffset, this.nextTokenOffset - sOffset);
        return 48;
    }

    private final byte parseNumber() throws ssException {
        int type = 50;
        int sOffset = this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length() && Character.isDigit((char)this.source.getByteAt(this.nextTokenOffset))) {
            ++this.nextTokenOffset;
        }
        if (this.source.getByteAt(this.nextTokenOffset) == 46) {
            ++this.nextTokenOffset;
            while (this.nextTokenOffset < this.source.length() && Character.isDigit((char)this.source.getByteAt(this.nextTokenOffset))) {
                ++this.nextTokenOffset;
            }
            if (this.source.getByteAt(this.nextTokenOffset - 1) != 46) {
                type = 52;
            } else {
                char chr = (char)this.source.getByteAt(this.nextTokenOffset);
                if (Character.isLetter(chr) || "@$_".indexOf(chr) != -1) {
                    --this.nextTokenOffset;
                }
            }
        }
        int length = this.nextTokenOffset - sOffset;
        if (type == 50 && this.source.getByteAt(this.nextTokenOffset - 1) == 46) {
            --length;
        }
        this.sValue = new String(this.source.getByteArray(), sOffset, length);
        return (byte)type;
    }

    private final byte parseDelimiter() {
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length() && "\t ".indexOf(this.source.getByteAt(this.nextTokenOffset)) != -1) {
            ++this.nextTokenOffset;
        }
        return 32;
    }

    private final byte parseString() throws ssException {
        byte quote = this.source.getByteAt(this.nextTokenOffset);
        ++this.nextTokenOffset;
        int sOffset = this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            if (this.source.getByteAt(this.nextTokenOffset) == quote) {
                this.sValue = new String(this.source.getByteArray(), sOffset, this.nextTokenOffset - sOffset);
                ++this.nextTokenOffset;
                return 51;
            }
            ++this.nextTokenOffset;
        }
        throw new ssException(12, "end of file", String.valueOf((char)quote));
    }

    private final byte parseSymbol() throws ssException {
        int token;
        block1: {
            char chr;
            int sOffset = this.nextTokenOffset++;
            while (this.nextTokenOffset < this.source.length() && (Character.isLetterOrDigit(chr = (char)this.source.getByteAt(this.nextTokenOffset)) || "@$_".indexOf(chr) != -1)) {
                ++this.nextTokenOffset;
            }
            String sToken = new String(this.source.getByteArray(), sOffset, this.nextTokenOffset - sOffset);
            token = ssToken.bToken(sToken);
            if (token != -1) break block1;
            token = 49;
            this.sValue = sToken.toLowerCase();
        }
        return (byte)token;
    }

    private final byte parseDot() throws ssException {
        int tOffset = this.nextTokenOffset + 1;
        if (tOffset < this.source.length() && Character.isDigit((char)this.source.getByteAt(tOffset))) {
            return this.parseNumber();
        }
        ++this.nextTokenOffset;
        return 46;
    }

    private final byte parseCommand() throws ssException {
        this.iValue = 0;
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            if (this.source.getByteAt(this.nextTokenOffset) == 10) {
                ++this.nextTokenOffset;
                this.iValue = 1;
                break;
            }
            ++this.nextTokenOffset;
        }
        if (this.iValue == 1) {
            return 116;
        }
        return 66;
    }

    private final byte parseOther() throws ssException {
        int token;
        block13: {
            byte tbyt;
            int tOffset;
            token = 0;
            byte byt = this.source.getByteAt(this.nextTokenOffset);
            if (byt == 47) {
                int tOffset2 = this.nextTokenOffset + 1;
                if (tOffset2 < this.source.length()) {
                    byte tbyt2 = this.source.getByteAt(tOffset2);
                    if (tbyt2 == 42) {
                        return this.parseCommentBlock();
                    }
                    if (tbyt2 == 47) {
                        return this.parseComment();
                    }
                }
            } else if (byt == 60) {
                int tOffset3 = this.nextTokenOffset + 1;
                if (tOffset3 < this.source.length()) {
                    byte tbyt3 = this.source.getByteAt(tOffset3);
                    if (tbyt3 == 61) {
                        this.nextTokenOffset += 2;
                        token = 54;
                    } else if (tbyt3 == 62) {
                        this.nextTokenOffset += 2;
                        token = 53;
                    }
                }
            } else if (byt == 62 && (tOffset = this.nextTokenOffset + 1) < this.source.length() && (tbyt = this.source.getByteAt(tOffset)) == 61) {
                this.nextTokenOffset += 2;
                token = 55;
            }
            if (token != 0) break block13;
            token = ssToken.bToken(byt);
            if (token == -1) {
                throw new ssException(8, "token", String.valueOf((char)byt));
            }
            ++this.nextTokenOffset;
        }
        return (byte)token;
    }

    private final byte parseCommentBlock() throws ssException {
        int lineCount = 0;
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length()) {
            byte byt = this.source.getByteAt(this.nextTokenOffset);
            if (byt == 10) {
                ++lineCount;
            } else if (byt == 42) {
                int tOffset = this.nextTokenOffset + 1;
                if (tOffset >= this.source.length()) break;
                if (this.source.getByteAt(tOffset) == 47) {
                    this.nextTokenOffset += 2;
                    if (lineCount == 0) {
                        return 39;
                    }
                    this.iValue = lineCount;
                    return 116;
                }
            }
            ++this.nextTokenOffset;
        }
        throw new ssException(12, "end of file", "*/");
    }

    private final byte parseComment() {
        ++this.nextTokenOffset;
        while (this.nextTokenOffset < this.source.length() && this.source.getByteAt(this.nextTokenOffset) != 10) {
            ++this.nextTokenOffset;
        }
        return 39;
    }
}

