/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import stec.ss.ssException;
import stec.ss.ssSession;
import stec.ss.ssSystem;

abstract class ssRequest {
    protected ssSystem system;
    protected InputStream is;
    protected Hashtable queryString = null;
    protected Hashtable content = null;
    protected String contentData = null;
    protected int requestMethod = 0;
    protected Hashtable cookies = null;

    protected ssRequest(ssSystem _system) {
        this.system = _system;
    }

    protected static final String decode(String eValue) {
        StringBuffer dValue = new StringBuffer();
        int eOffset = 0;
        int dOffset = 0;
        while (eOffset < eValue.length()) {
            char chr = eValue.charAt(eOffset);
            if (chr == '+') {
                chr = ' ';
            } else if (chr == '%') {
                chr = (char)Integer.valueOf(eValue.substring(++eOffset, eOffset + 2), 16).byteValue();
            }
            dValue.append(chr);
            ++eOffset;
            ++dOffset;
        }
        return dValue.toString();
    }

    protected final Hashtable parseRequest(String request) {
        Hashtable ht = new Hashtable();
        StringTokenizer qst = new StringTokenizer(request, "&");
        while (qst.hasMoreTokens()) {
            String token = qst.nextToken();
            int offset = token.indexOf(61);
            String key = ssRequest.decode(token.substring(0, offset));
            String value = ssRequest.decode(token.substring(offset + 1));
            Object o = ht.get(key);
            Vector<String> v = o == null ? new Vector<String>() : (Vector<String>)o;
            v.addElement(value);
            ht.put(key, v);
        }
        return ht;
    }

    protected final Hashtable QueryString() {
        if (this.queryString != null) {
            return this.queryString;
        }
        this.requestMethod = 1;
        String queryStringData = this.queryStringData();
        if (queryStringData == null) {
            return null;
        }
        this.queryString = this.parseRequest(queryStringData);
        return this.queryString;
    }

    protected final Object QueryString(String key) {
        Hashtable ht = this.QueryString();
        if (ht == null) {
            return null;
        }
        Object o = ht.get(key);
        if (o == null) {
            return null;
        }
        Vector v = (Vector)o;
        if (v.size() == 1) {
            return (String)v.elementAt(0);
        }
        return v;
    }

    protected final String QueryString(String key, int index) {
        Hashtable ht = this.QueryString();
        if (ht == null) {
            return null;
        }
        Object o = ht.get(key);
        if (o == null) {
            return null;
        }
        if ((o = ((Vector)o).elementAt(index)) == null) {
            return null;
        }
        return (String)o;
    }

    protected final int available() throws IOException {
        return this.is.available();
    }

    protected final int read() throws IOException {
        return this.is.read();
    }

    protected final int read(byte[] buffer) throws IOException {
        return this.is.read(buffer);
    }

    protected final int read(byte[] buffer, int offset, int length) throws IOException {
        return this.is.read(buffer, offset, length);
    }

    protected final long skip(long bytes) throws IOException {
        return this.is.skip(bytes);
    }

    protected final String contentData() throws IOException {
        int bytesRead;
        if (this.contentData != null) {
            return this.contentData;
        }
        int contentLength = this.length();
        if (contentLength == 0) {
            return null;
        }
        byte[] buffer = new byte[contentLength];
        ByteArrayOutputStream aBuffer = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.is);
        for (int totalBytesRead = 0; totalBytesRead < contentLength; totalBytesRead += bytesRead) {
            bytesRead = bufferedInputStream.read(buffer);
            aBuffer.write(buffer, 0, bytesRead);
        }
        this.contentData = aBuffer.toString();
        return this.contentData;
    }

    protected final Hashtable Content() throws IOException, ssException {
        if (this.content != null) {
            return this.content;
        }
        this.requestMethod = 2;
        String contentData = this.contentData();
        if (contentData == null) {
            return null;
        }
        String sContentType = this.type();
        if (sContentType == null) {
            return null;
        }
        if (!sContentType.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            return null;
        }
        this.content = this.parseRequest(contentData);
        return this.content;
    }

    protected final Object Content(String key) throws IOException, ssException {
        Hashtable ht = this.Content();
        if (ht == null) {
            return null;
        }
        Object o = ht.get(key);
        if (o == null) {
            return null;
        }
        Vector v = (Vector)o;
        if (v.size() == 1) {
            return (String)v.elementAt(0);
        }
        return v;
    }

    protected final String Content(String key, int index) throws IOException, ssException {
        Hashtable ht = this.Content();
        if (ht == null) {
            return null;
        }
        Object o = ht.get(key);
        if (o == null) {
            return null;
        }
        if ((o = ((Vector)o).elementAt(index)) == null) {
            return null;
        }
        return (String)o;
    }

    protected final String formData() throws IOException, ssException {
        if (this.requestMethod == 0) {
            if (this.method().equalsIgnoreCase("get")) {
                return this.queryStringData();
            }
            return new String(this.contentData());
        }
        if (this.requestMethod == 1) {
            return this.queryStringData();
        }
        if (this.requestMethod == 2) {
            return new String(this.contentData);
        }
        throw new ssException(14, "request method", Integer.toString(this.requestMethod), "value");
    }

    protected final Hashtable Form() throws IOException, ssException {
        if (this.requestMethod == 0) {
            if (this.method().equalsIgnoreCase("get")) {
                return this.QueryString();
            }
            return this.Content();
        }
        if (this.requestMethod == 1) {
            return this.queryString;
        }
        if (this.requestMethod == 2) {
            return this.content;
        }
        throw new ssException(14, "request method", Integer.toString(this.requestMethod), "value");
    }

    protected final Object Form(String key) throws IOException, ssException {
        if (this.requestMethod == 0) {
            this.Form();
        }
        if (this.requestMethod == 1) {
            return this.QueryString(key);
        }
        if (this.requestMethod == 2) {
            return this.Content(key);
        }
        throw new ssException(14, "request method", Integer.toString(this.requestMethod), "value");
    }

    protected final String Form(String key, int index) throws IOException, ssException {
        if (this.requestMethod == 0) {
            this.Form();
        }
        if (this.requestMethod == 1) {
            return this.QueryString(key, index);
        }
        if (this.requestMethod == 2) {
            return this.Content(key, index);
        }
        throw new ssException(14, "request method", Integer.toString(this.requestMethod), "value");
    }

    protected final Hashtable Cookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        String cookieData = this.cookieData();
        if (cookieData == null) {
            return null;
        }
        this.cookies = this.parseCookies(cookieData);
        return this.cookies;
    }

    protected final Hashtable parseCookies(String cookie) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        StringTokenizer qst = new StringTokenizer(cookie, "; ");
        while (qst.hasMoreTokens()) {
            String token = qst.nextToken();
            int offset = token.indexOf(61);
            if (offset == -1) continue;
            String key = ssRequest.decode(token.substring(0, offset));
            String value = ssRequest.decode(token.substring(offset + 1));
            ht.put(key, value);
        }
        return ht;
    }

    protected final String Cookies(String name) {
        Hashtable ht = this.Cookies();
        if (ht == null) {
            return null;
        }
        Object cookie = ht.get(name);
        if (cookie == null) {
            return null;
        }
        return (String)cookie;
    }

    protected final String path() {
        String path = this.script();
        if (path == null) {
            return null;
        }
        int offset = path.lastIndexOf("/");
        if (offset != -1) {
            path = path.substring(0, offset);
        }
        return path;
    }

    protected abstract Hashtable ServerVariable();

    protected abstract String ServerVariable(String var1);

    protected abstract int length();

    protected abstract String method();

    protected abstract String type();

    protected abstract String script();

    protected abstract String queryStringData();

    protected abstract String cookieData();

    protected abstract ssSession getSession(boolean var1);

    protected abstract boolean isSessionFromCookie();

    protected abstract boolean isSessionFromURL();

    protected abstract boolean isSessionValid();

    protected abstract boolean isSecure();
}

