package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: EmployeeTerritories <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class EmployeeTerritoriesCached extends EmployeeTerritoriesBase
    implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public EmployeeTerritoriesCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected EmployeeTerritoriesCached(CS cs, int EmployeeID,
        String TerritoryID) throws SQLException {
        super(cs, EmployeeID, TerritoryID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public EmployeeTerritoriesCached(CS cs, ResultSet rs)
        throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Sets this row of EmployeeTerritories to reference the ref row of Employees
     */
    public void setEmployeeIDRef(EmployeesCached ref) {
        setEmployeeID(ref.getEmployeeID());
    }

    /**
     * Gets this row of EmployeeTerritories from referenced row of Employees
     */
    public EmployeesCached getEmployeeIDRef()
        throws SQLException, CloneNotSupportedException {
        return getEmployeeIDRef(cs);
    }

    /**
     * Gets this row of EmployeeTerritories from referenced row of Employees
     */
    public EmployeesCached getEmployeeIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        return EmployeesCached.instance(cs, getEmployeeID());
    }

    /**
     * Sets this row of EmployeeTerritories to reference the ref row of Territories
     */
    public void setTerritoryIDRef(TerritoriesCached ref) {
        setTerritoryID(ref.getTerritoryID());
    }

    /**
     * Gets this row of EmployeeTerritories from referenced row of Territories
     */
    public TerritoriesCached getTerritoryIDRef()
        throws SQLException, CloneNotSupportedException {
        return getTerritoryIDRef(cs);
    }

    /**
     * Gets this row of EmployeeTerritories from referenced row of Territories
     */
    public TerritoriesCached getTerritoryIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        return TerritoriesCached.instance(cs, getTerritoryID());
    }

    /**
     * Gets a LinkedList of EmployeeTerritoriesCached's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, getEmployeeID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of EmployeeTerritoriesCached's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithEmployeeIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithEmployeeIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeeTerritoriesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeeTerritoriesCached's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public Iterator getIteratorWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getIteratorWithEmployeeIDValueOf(cs, getEmployeeID(), maxResults);
    }

    /**
     * Gets an Iterator of EmployeeTerritoriesCached's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithEmployeeIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of EmployeeTerritoriesCached's by querying table field TerritoryID
     * for equality with the same TerritoryID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTerritoryID(int maxResults)
        throws SQLException {
        return getLinkedListWithTerritoryIDValueOf(cs, getTerritoryID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of EmployeeTerritoriesCached's by querying table field TerritoryID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTerritoryIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTerritoryIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new EmployeeTerritoriesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of EmployeeTerritoriesCached's by querying table field TerritoryID
     * for equality with the same TerritoryID as this instance.
     */
    public Iterator getIteratorWithSameValueOfTerritoryID(int maxResults)
        throws SQLException {
        return getIteratorWithTerritoryIDValueOf(cs, getTerritoryID(),
            maxResults);
    }

    /**
     * Gets an Iterator of EmployeeTerritoriesCached's by querying table field TerritoryID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTerritoryIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithTerritoryIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return EmployeeTerritoriesCached.delete(cs, EmployeeID, TerritoryID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int EmployeeID, String TerritoryID)
        throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                EmployeeTerritoriesCached.class,
                
            new Integer(EmployeeID), TerritoryID
            });

        return EmployeeTerritoriesBase.delete(cs, EmployeeID, TerritoryID);
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            Cache.getCache().removeSynchronized(new Object[] {
                    EmployeeTerritoriesCached.class,
                    
                new Integer(old_EmployeeID), old_TerritoryID
                });

            int res = super.updateAll();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] {
            EmployeeTerritoriesCached.class,
            
            new Integer(EmployeeID), TerritoryID
        };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached EmployeeTerritoriesCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] {
                EmployeeTerritoriesCached.class
            });
    }

    /**
     * Flush a cached EmployeeTerritoriesCached item.
     */
    public static void flushCache(int EmployeeID, String TerritoryID) {
        Cache.getCache().removeSynchronized(new Object[] {
                EmployeeTerritoriesCached.class,
                
            new Integer(EmployeeID), TerritoryID
            });
    }

    private static EmployeeTerritoriesCached cacheLookup(int EmployeeID,
        String TerritoryID) throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (EmployeeTerritoriesCached.class) {
            EmployeeTerritoriesCached t = (EmployeeTerritoriesCached) c.get(new Object[] {
                        EmployeeTerritoriesCached.class,
                        
                    new Integer(EmployeeID), TerritoryID
                    });

            if (t != null) {
                return (EmployeeTerritoriesCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static EmployeeTerritoriesCached instance(CS cs, int EmployeeID,
        String TerritoryID) throws SQLException, CloneNotSupportedException {
        EmployeeTerritoriesCached t = cacheLookup(EmployeeID, TerritoryID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new EmployeeTerritoriesCached(cs, EmployeeID, TerritoryID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth)
        throws SQLException, CloneNotSupportedException {
        Element root = new Element("EmployeeTerritoriesCached");

        root.setAttribute("EmployeeID", String.valueOf(getEmployeeID()));

        root.addContent(new Element("TerritoryID").setText(getTerritoryID()));

        if (depth > 0) {
            EmployeesCached temp1 = getEmployeeIDRef(cs);

            if (temp1 != null) {
                root.addContent(temp1.toXML(depth - 1));
            }

            TerritoriesCached temp2 = getTerritoryIDRef(cs);

            if (temp2 != null) {
                root.addContent(temp2.toXML(depth - 1));
            }
        }

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() throws SQLException, CloneNotSupportedException {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
