package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: CustomerDemographics <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class CustomerDemographicsCached extends CustomerDemographicsBase
    implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public CustomerDemographicsCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected CustomerDemographicsCached(CS cs, String CustomerTypeID)
        throws SQLException {
        super(cs, CustomerTypeID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public CustomerDemographicsCached(CS cs, ResultSet rs)
        throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Gets a LinkedList of CustomerDemographicsCached's by querying table field CustomerTypeID
     * for equality with the same CustomerTypeID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCustomerTypeID(int maxResults)
        throws SQLException {
        return getLinkedListWithCustomerTypeIDValueOf(cs, getCustomerTypeID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of CustomerDemographicsCached's by querying table field CustomerTypeID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCustomerTypeIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCustomerTypeIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new CustomerDemographicsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of CustomerDemographicsCached's by querying table field CustomerTypeID
     * for equality with the same CustomerTypeID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCustomerTypeID(int maxResults)
        throws SQLException {
        return getIteratorWithCustomerTypeIDValueOf(cs, getCustomerTypeID(),
            maxResults);
    }

    /**
     * Gets an Iterator of CustomerDemographicsCached's by querying table field CustomerTypeID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCustomerTypeIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCustomerTypeIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return CustomerDemographicsCached.delete(cs, CustomerTypeID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, String CustomerTypeID)
        throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                CustomerDemographicsCached.class, CustomerTypeID
            });

        return CustomerDemographicsBase.delete(cs, CustomerTypeID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            Cache.getCache().removeSynchronized(new Object[] {
                    CustomerDemographicsCached.class,
                    
                old_CustomerTypeID
                });

            int res = super.updateAll();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { CustomerDemographicsCached.class, CustomerTypeID };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached CustomerDemographicsCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] {
                CustomerDemographicsCached.class
            });
    }

    /**
     * Flush a cached CustomerDemographicsCached item.
     */
    public static void flushCache(String CustomerTypeID) {
        Cache.getCache().removeSynchronized(new Object[] {
                CustomerDemographicsCached.class, CustomerTypeID
            });
    }

    private static CustomerDemographicsCached cacheLookup(String CustomerTypeID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (CustomerDemographicsCached.class) {
            CustomerDemographicsCached t = (CustomerDemographicsCached) c.get(new Object[] {
                        CustomerDemographicsCached.class, CustomerTypeID
                    });

            if (t != null) {
                return (CustomerDemographicsCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static CustomerDemographicsCached instance(CS cs,
        String CustomerTypeID) throws SQLException, CloneNotSupportedException {
        CustomerDemographicsCached t = cacheLookup(CustomerTypeID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new CustomerDemographicsCached(cs, CustomerTypeID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth) {
        Element root = new Element("CustomerDemographicsCached");

        root.addContent(new Element("CustomerTypeID").setText(
                getCustomerTypeID()));

        root.addContent(new Element("CustomerDesc").setText(getCustomerDesc()));

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
