/*
 * Decompiled with CFR 0.152.
 */
package org.aris.hldb.pools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import org.aris.hldb.pools.ConnectionProviderI;

public class ConnectionPoolProvider
implements ConnectionProviderI {
    private String dbName = null;
    private int maxConnections = -1;
    private int openConnections = 0;
    private LinkedList avail = new LinkedList();

    public ConnectionPoolProvider(String db_name, int max_Connections) {
        this.dbName = db_name;
        this.maxConnections = max_Connections;
    }

    public synchronized Connection allocConnection() throws SQLException {
        Connection con;
        if (this.openConnections == this.maxConnections) {
            con = (Connection)this.avail.removeFirst();
            this.avail.addLast(con);
        } else {
            con = DriverManager.getConnection(this.dbName);
            this.avail.addLast(con);
            ++this.openConnections;
        }
        return con;
    }
}

