/*
 * Decompiled with CFR 0.152.
 */
package org.aris.oodb;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.aris.dbutils.ColumnInfo;
import org.aris.dbutils.CrossReferenceInfo;
import org.aris.dbutils.DBInfo;
import org.aris.dbutils.PrimaryKeyInfo;
import org.aris.dbutils.TableInfo;
import org.aris.oodb.db.DbI;
import org.aris.utils.various.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.transform.JDOMSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TableToClass {
    private final String encoding = "UTF-8";
    private String catalog;
    private String outputJavaCode;
    private DBInfo dbInfo;
    private Element template;
    private Element commonParams;
    private DbI dbi;
    private Hashtable templateCache = new Hashtable();
    static /* synthetic */ Class class$0;

    public TableToClass(DBInfo dbInfo, Element template, Element commonParams, String catalog, DbI dbi) {
        this.catalog = catalog;
        this.dbInfo = dbInfo;
        this.dbi = dbi;
        this.template = template;
        this.commonParams = commonParams;
    }

    public String fixTableName(String tableName, boolean addExt) {
        String s = (addExt &= this.template.getChildText("ext") != null) ? String.valueOf(tableName) + this.template.getChildText("ext") : tableName;
        return s.replaceAll(" ", "_");
    }

    public void convertAll(int debugLevel) throws SQLException, SAXException, TransformerException, IOException {
        Iterator itct = this.template.getChildren("convertType").iterator();
        String path = this.template.getChildText("outputDir");
        String outfile = this.template.getChildText("outputFile");
        String package_ = this.template.getChildText("package");
        FileOutputStream os = null;
        OutputStreamWriter osw = null;
        if (outfile != null) {
            os = new FileOutputStream(outfile);
            osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
        }
        while (itct.hasNext()) {
            String convertType = ((Element)itct.next()).getText();
            Iterator it = this.dbInfo.getTables(this.catalog).values().iterator();
            while (it.hasNext()) {
                TableInfo ti = (TableInfo)it.next();
                if (ti.getTABLE_TYPE().equals(convertType) && !this.dbi.isSystemObject(ti.getTABLE_NAME())) {
                    String table = ti.getTABLE_NAME();
                    System.out.println("\n[Converting :" + this.catalog + "." + table + "]");
                    this.convert(table, package_, debugLevel);
                    if (os == null) {
                        this.saveToFile(String.valueOf(path) + this.fixTableName(table, true) + ".java");
                        continue;
                    }
                    osw.write(this.outputJavaCode);
                    continue;
                }
                if (debugLevel <= 0) continue;
                System.out.println("[skipped " + ti.getTABLE_NAME() + " " + ti.getTABLE_TYPE() + "]");
            }
        }
        if (os != null) {
            osw.close();
            os.close();
        }
    }

    public String convert(String table, String package_, int debugLevel) throws SQLException, SAXException, TransformerException, IOException {
        Element root = new Element("ROOT");
        Element ctemp = (Element)this.template.clone();
        String s = ctemp.getChildText("extends");
        if (s != null) {
            s = s.replaceAll("##", this.fixTableName(table, false));
            ctemp.getChild("extends").setText(s);
        }
        root.addContent((Content)ctemp);
        if (this.commonParams != null) {
            root.addContent((Content)((Element)this.commonParams.clone()));
        }
        Element classInfo = new Element("CLASSINFO");
        classInfo.setAttribute("tableName", table);
        if (package_ != null) {
            classInfo.setAttribute("package", package_);
        }
        root.addContent((Content)classInfo);
        root.addContent((Content)new Element("CLASSNAME").setText(this.fixTableName(table, true)));
        Iterator it = this.dbInfo.getColumnsIterator(this.catalog, table);
        while (it.hasNext()) {
            ColumnInfo ci = (ColumnInfo)it.next();
            System.out.print(ci.getCOLUMN_NAME());
            Element cie = ci.toXML(this.dbi);
            if (it.hasNext()) {
                cie.setAttribute("hasMore", "1");
                System.out.print(",");
            } else {
                cie.setAttribute("hasMore", "0");
            }
            root.addContent((Content)cie);
        }
        Iterator itpk = this.dbInfo.getPrimaryKeys(this.catalog, table).values().iterator();
        if (itpk.hasNext()) {
            TreeMap col = this.dbInfo.getColumns(this.catalog, table);
            Element pke = new Element("PRIMARYKEYS");
            root.addContent((Content)pke);
            String commaSep = "";
            String commaSepJT = "";
            while (itpk.hasNext()) {
                PrimaryKeyInfo pki = (PrimaryKeyInfo)itpk.next();
                Element pkie = pki.toXML(this.dbInfo, this.dbi);
                pke.addContent((Content)pkie);
                commaSep = String.valueOf(commaSep) + pki.getCOLUMN_NAME();
                ColumnInfo ci = (ColumnInfo)col.get(pki.getCOLUMN_NAME());
                commaSepJT = String.valueOf(commaSepJT) + ci.getJavaType(this.dbi) + " " + pki.getCOLUMN_NAME();
                if (itpk.hasNext()) {
                    pkie.setAttribute("hasMore", "1");
                    commaSep = String.valueOf(commaSep) + ",";
                    commaSepJT = String.valueOf(commaSepJT) + ",";
                    continue;
                }
                pkie.setAttribute("hasMore", "0");
            }
            pke.setAttribute("commaSep", commaSep);
            pke.setAttribute("commaSepJavaType", commaSepJT);
        }
        Element cre = new Element("CROSSREFERENCES");
        root.addContent((Content)cre);
        TreeMap tmcr = this.dbInfo.getCrossReferencesMatched(this.catalog, table);
        Iterator itcr = tmcr.values().iterator();
        while (itcr.hasNext()) {
            LinkedList ll = (LinkedList)itcr.next();
            Iterator itll = ll.iterator();
            Element cre1 = null;
            String crcs = "";
            String crcsFK = "";
            String crcsjtFK = "";
            String crcsPK = "";
            String crcsjtPK = "";
            while (itll.hasNext()) {
                CrossReferenceInfo cri = (CrossReferenceInfo)itll.next();
                if (cre1 == null) {
                    cre1 = new Element("RELATIONSHIP");
                    cre.addContent((Content)cre1);
                    cre1.setAttribute("name", cri.getFK_NAME());
                    cre1.setAttribute("references", cri.getPKTABLE_NAME());
                }
                Element crie = cri.toXML(this.dbInfo, this.dbi);
                crcs = String.valueOf(crcs) + cri.getFKCOLUMN_NAME();
                crcsFK = String.valueOf(crcsFK) + cri.getFKCOLUMN_NAME();
                crcsjtFK = String.valueOf(crcsjtFK) + this.dbi.getJavaType(cri.getFKCOLUMNInfo(this.dbInfo)).getJavaType() + " " + cri.getFKCOLUMN_NAME();
                crcsPK = String.valueOf(crcsPK) + cri.getPKCOLUMN_NAME();
                crcsjtPK = String.valueOf(crcsjtPK) + this.dbi.getJavaType(cri.getPKCOLUMNInfo(this.dbInfo)).getJavaType() + " " + cri.getPKCOLUMN_NAME();
                if (itll.hasNext()) {
                    crie.setAttribute("hasMore", "1");
                    crcsFK = String.valueOf(crcsFK) + ",";
                    crcsjtFK = String.valueOf(crcsjtFK) + ",";
                    crcsPK = String.valueOf(crcsPK) + ",";
                    crcsjtPK = String.valueOf(crcsjtPK) + ",";
                } else {
                    crie.setAttribute("hasMore", "0");
                }
                cre1.addContent((Content)crie);
            }
            if (cre1 == null) continue;
            cre1.setAttribute("helpStr", crcs);
            cre1.setAttribute("commaSepFK", crcsFK);
            cre1.setAttribute("commaSepJavaTypeFK", crcsjtFK);
            cre1.setAttribute("commaSepPK", crcsPK);
            cre1.setAttribute("commaSepJavaTypePK", crcsjtPK);
        }
        if (debugLevel > 0) {
            System.out.println();
            XmlUtils.dumpXML((Element)root, (String)("XML dump of " + table));
        }
        StringWriter sw = new StringWriter();
        this.Transform(this.template.getChildText("file"), root, sw);
        this.outputJavaCode = sw.toString();
        return this.outputJavaCode;
    }

    public void Transform(String xsl, Element xml, Writer output) throws SAXException, TransformerException, IOException {
        InputStream sXSL = null;
        try {
            Templates tt = (Templates)this.templateCache.get(xsl);
            if (tt == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.aris.oodb.templates.ResourceHolder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                sXSL = clazz.getResourceAsStream(xsl);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                SAXSource source = new SAXSource(reader, new InputSource(sXSL));
                TransformerFactory factory = TransformerFactory.newInstance();
                tt = factory.newTemplates(source);
                this.templateCache.put(xsl, tt);
            }
            Transformer transformer = tt.newTransformer();
            JDOMSource ss = new JDOMSource(xml);
            transformer.transform((Source)ss, new StreamResult(output));
        }
        finally {
            if (sXSL != null) {
                sXSL.close();
            }
        }
    }

    public void saveToFile(String fileName) throws IOException {
        FileOutputStream os = new FileOutputStream(fileName);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
        osw.write(this.outputJavaCode);
        osw.close();
        os.close();
    }

    public String getJavaCode() {
        return this.outputJavaCode;
    }

    public void setJavaCode(String javaCode) {
        this.outputJavaCode = javaCode;
    }
}

