// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "BCGCBDotNetExample.h"
#include "FindComboBox.h"
#include "OptionsDlg.h"
#include "MainFrm.h"

#include "BCGPTabbedControlBar.h"
#include "BCGPMiniFrameWnd.h"

#include "UndoBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

const int  iMaxUserToolbars		= 10;
const UINT uiFirstUserToolBarId	= AFX_IDW_CONTROLBAR_FIRST + 40;
const UINT uiLastUserToolBarId	= uiFirstUserToolBarId + iMaxUserToolbars - 1;

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_OUTPUT, OnViewOutput)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OUTPUT, OnUpdateViewOutput)
	ON_COMMAND(ID_VIEW_BUILD_TOOLBAR, OnViewBuildToolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BUILD_TOOLBAR, OnUpdateViewBuildToolbar)
	ON_COMMAND(ID_VIEW_WATCH, OnViewWatch)
	ON_UPDATE_COMMAND_UI(ID_VIEW_WATCH, OnUpdateViewWatch)
	ON_COMMAND(ID_WINDOW_MANAGER, OnWindowManager)
	ON_COMMAND(ID_HELP_KEYBOARDMAP, OnHelpKeyboardmap)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_VIEW_CLASS, OnViewClass)
	ON_UPDATE_COMMAND_UI(ID_VIEW_CLASS, OnUpdateViewClass)
	ON_COMMAND(ID_VIEW_RESOURCE, OnViewResource)
	ON_UPDATE_COMMAND_UI(ID_VIEW_RESOURCE, OnUpdateViewResource)
	ON_COMMAND(ID_VIEW_FILE, OnViewFile)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FILE, OnUpdateViewFile)
	ON_COMMAND(ID_VIEW_DYNAMICHELP, OnViewDynamichelp)
	ON_UPDATE_COMMAND_UI(ID_VIEW_DYNAMICHELP, OnUpdateViewDynamichelp)
	ON_COMMAND(ID_FILE_NEW_PROJECT, OnFileNewProject)
	ON_COMMAND(ID_FILE_NEW_BLANK_SOLUTION, OnFileNewBlankSolution)
	ON_COMMAND(ID_FILE_OPEN_SOLUTION, OnFileOpenSolution)
	ON_COMMAND(ID_FILE_CLOSE_SOLUTION, OnFileCloseSolution)
	ON_COMMAND(ID_FILE_SAVE_ALL, OnFileSaveAll)
	ON_COMMAND(ID_VIEW_PROPERTIES, OnViewProperties)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PROPERTIES, OnUpdateViewProperties)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	ON_COMMAND(ID_TOOLS_CONNECT_TO_DATABASE, OnToolsConnectToDatabase)
	ON_COMMAND(ID_TOOLS_DEBUG_PROCESSES, OnToolsDebugProcesses)
	ON_WM_CLOSE()
	ON_COMMAND(ID_VIEW_FULLSCREEN, OnViewFullScreen)
	ON_WM_GETMINMAXINFO()
	ON_COMMAND(ID_VIEW_TOOLBOX, OnViewToolbox)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBOX, OnUpdateViewToolbox)
	ON_COMMAND(ID_VIEW_INFOBAR, OnViewInfobar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_INFOBAR, OnUpdateViewInfobar)
	ON_COMMAND(ID_VIEW_EDIT_TOOLBAR, OnViewEditToolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_EDIT_TOOLBAR, OnUpdateViewEditToolbar)
	ON_COMMAND(ID_TOOLS_OPTIONS, OnToolsOptions)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_VIEW_CUSTOMIZE, OnViewCustomize)
	ON_REGISTERED_MESSAGE(BCGM_RESETTOOLBAR, OnToolbarReset)
	ON_REGISTERED_MESSAGE(BCGM_TOOLBARMENU, OnToolbarContextMenu)
	ON_COMMAND_RANGE(ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10, OnToolsViewUserToolbar)
	ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10, OnUpdateToolsViewUserToolbar)
	ON_REGISTERED_MESSAGE(BCGM_CUSTOMIZEHELP, OnHelpCustomizeToolbars)
	ON_REGISTERED_MESSAGE(BCGM_CREATETOOLBAR, OnToolbarCreateNew)
	ON_COMMAND(ID_TOOLBOX, OnToolBox)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	IDS_CARET_POS,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL, 
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	CBCGPPopupMenu::SetForceShadow (TRUE);

	m_bFullScreen	= false;
	m_pwndFullScreenBar	= NULL;
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	CBCGPVisualManager::SetDefaultManager (RUNTIME_CLASS (CBCGPVisualManagerXP));
	CBCGPToolbarComboBoxButton::SetFlatMode ();

	//--------------------------
	// Load toolbar user images:
	//--------------------------
	if (!m_UserImages.Load (_T(".\\UserImages.bmp")))
	{
		TRACE(_T("Failed to load user images\n"));
		ASSERT (FALSE);
	}
	else
	{
		CBCGPToolBar::SetUserImages (&m_UserImages);
	}

	CBCGPToolBar::EnableQuickCustomization ();

	// TODO: Define your own basic commands. Be sure, that each pulldown 
	// menu have at least one basic command.

	CList<UINT, UINT>	lstBasicCoomads;

	lstBasicCoomads.AddTail (ID_FILE_NEW);
	lstBasicCoomads.AddTail (ID_FILE_OPEN);
	lstBasicCoomads.AddTail (ID_FILE_SAVE);
	lstBasicCoomads.AddTail (ID_FILE_PRINT);
	lstBasicCoomads.AddTail (ID_APP_EXIT);
	lstBasicCoomads.AddTail (ID_EDIT_CUT);
	lstBasicCoomads.AddTail (ID_EDIT_PASTE);
	lstBasicCoomads.AddTail (ID_EDIT_UNDO);
	lstBasicCoomads.AddTail (ID_APP_ABOUT);
	lstBasicCoomads.AddTail (ID_VIEW_TOOLBAR);
	lstBasicCoomads.AddTail (ID_VIEW_CUSTOMIZE);
	lstBasicCoomads.AddTail (ID_VIEW_TOOLBARS);
	lstBasicCoomads.AddTail (ID_DUMMY_COMPILE);
	lstBasicCoomads.AddTail (ID_DUMMY_BUILD);
	lstBasicCoomads.AddTail (ID_DUMMY_GO);
	lstBasicCoomads.AddTail (ID_DUMMY_EXECUTE);
	lstBasicCoomads.AddTail (ID_DUMMY_SELECT_ACTIVE_CONFIGURATION);
	lstBasicCoomads.AddTail (ID_VIEW_CB_CAPTION);
	lstBasicCoomads.AddTail (ID_TOOLS_MACRO);
	lstBasicCoomads.AddTail (ID_TOOLS_OPTIONS);

	lstBasicCoomads.AddTail (ID_WINDOW_TILE_HORZ);
	CBCGPToolBar::SetBasicCommands (lstBasicCoomads);

	//-----------------
	// Create menu bar:
	//-----------------

	if (!m_wndMenuBar.Create (this))
	{
		TRACE0("Failed to create menubar\n");
		return -1;      // fail to create
	}

	m_wndMenuBar.SetBarStyle(m_wndMenuBar.GetBarStyle() | CBRS_SIZE_DYNAMIC | CBRS_TOOLTIPS | CBRS_FLYBY);

	//--------------------------------------------
	// Menu will not take the focus on activation:
	//--------------------------------------------
	CBCGPPopupMenu::SetForceMenuFocus (FALSE);

	//----------------------
	// Create Resource toolbar:
	//----------------------
	if (!m_wndToolbarResource.Create(this,
		WS_CHILD|CBRS_TOP|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_HIDE_INPLACE|CBRS_SIZE_DYNAMIC|
		CBRS_GRIPPER | CBRS_BORDER_3D,
		IDR_TOOLBAR_RESOURCE) || 
		!m_wndToolbarResource.LoadToolBar (IDR_TOOLBAR_RESOURCE))
	{
		TRACE0("Failed to create build toolbar\n");
		return FALSE;      // fail to create
	}

	//---------------------
	// Create main toolbar:
	//---------------------
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	CString strMainToolbarTitle;
	strMainToolbarTitle.LoadString (IDS_MAIN_TOOLBAR);
	m_wndToolBar.SetWindowText (strMainToolbarTitle);

	//----------------------
	// Create Build toolbar:
	//----------------------
	if (!m_wndToolbarBuild.Create(this,
		WS_CHILD|WS_VISIBLE|CBRS_TOP|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_HIDE_INPLACE|CBRS_SIZE_DYNAMIC|
		CBRS_GRIPPER | CBRS_BORDER_3D,
		ID_VIEW_BUILD_TOOLBAR) ||
		!m_wndToolbarBuild.LoadToolBar (IDR_BUILD))
	{
		TRACE0("Failed to create build toolbar\n");
		return FALSE;      // fail to create
	}

	CString strBuildToolbarTitle;
	strBuildToolbarTitle.LoadString (IDS_BUILD_TOOLBAR);
	m_wndToolbarBuild.SetWindowText (strBuildToolbarTitle);

	//---------------------
	// Create Edit toolbar:
	//---------------------
	if (!m_wndToolbarEdit.Create(this,
		WS_CHILD|WS_VISIBLE|CBRS_TOP|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_HIDE_INPLACE|CBRS_SIZE_DYNAMIC|
		CBRS_GRIPPER | CBRS_BORDER_3D,
		ID_VIEW_EDIT_TOOLBAR) ||
		!m_wndToolbarEdit.LoadToolBar (IDR_EDIT))
	{
		TRACE0("Failed to create edit toolbar\n");
		return FALSE;      // fail to create
	}

	CString strEditToolbarTitle;
	strEditToolbarTitle.LoadString (IDS_EDIT_TOOLBAR);
	m_wndToolbarEdit.SetWindowText (strEditToolbarTitle);

	//--------------------------------------------------------------
	// Load menu items images (not placed on the standard toolbars):
	//--------------------------------------------------------------
	CBCGPToolBar::AddToolBarForImageCollection (IDR_MENU_IMAGES);

	//-------------------
	// Create status bar:
	//-------------------
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	m_wndStatusBar.SetPaneStyle (0, SBPS_STRETCH);

	//--------------------------------
	// Create docking control windows:
	//--------------------------------
	if (!CreateDockingBars ())
	{
		return -1;
	}

	//--------------------------------
	// Create Information Bar:
	//--------------------------------
	if (!m_wndInfoBar.Create (_T("Info"), this, CRect (0, 0, 100, 100),
		TRUE , 
		ID_VIEW_INFOBAR, 
		WS_CHILD | WS_VISIBLE,
		CBRS_BCGP_REGULAR_TABS,
		CBRS_BCGP_CLOSE | CBRS_BCGP_FLOAT | CBRS_BCGP_AUTO_ROLLUP))
	{
		TRACE0("Failed to create infor bar bar\n");
		return -1;      // fail to create
	}

	m_wndToolBar.EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, _T("Customize..."));
	m_wndToolbarBuild.EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, _T("Customize..."));
	m_wndToolbarEdit.EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, _T("Customize..."));

	m_wndMenuBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolbarBuild.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolbarEdit.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolbarResource.EnableDocking(CBRS_ALIGN_ANY);
	m_wndClassView.EnableDocking(CBRS_ALIGN_ANY);
	m_wndResourceView.EnableDocking(CBRS_ALIGN_ANY);
	m_wndFileView.EnableDocking(CBRS_ALIGN_ANY);
	m_wndOutputView.EnableDocking(CBRS_ALIGN_ANY);
	m_wndDynamicHelpView.EnableDocking(CBRS_ALIGN_ANY);
	m_wndPropertiesBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndToolBoxBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndInfoBar.EnableDocking (0);

	m_wndWatchBar.EnableDocking(CBRS_ALIGN_ANY);

	EnableDocking(CBRS_ALIGN_ANY);

	EnableAutoHideBars(CBRS_ALIGN_ANY);

	DockControlBar(&m_wndMenuBar);
	DockControlBar(&m_wndToolBar);
	DockControlBar(&m_wndPropertiesBar);
	DockControlBar(&m_wndToolBoxBar);

	DockControlBar(&m_wndToolbarBuild);
	CRect rc(100, 100, 200, 200);
	ClientToScreen	(rc);
	m_wndToolbarEdit.FloatControlBar (rc);

	DockControlBar(&m_wndClassView);

	CBCGPDockingControlBar* pTabbedBar = NULL; 
	m_wndResourceView.AttachToTabWnd (&m_wndClassView, DM_SHOW, TRUE, &pTabbedBar);
	m_wndFileView.AttachToTabWnd (pTabbedBar, DM_SHOW, TRUE, &pTabbedBar);
	m_wndToolBoxBar.AttachToTabWnd (pTabbedBar, DM_SHOW, TRUE, &pTabbedBar);

	DockControlBar(&m_wndOutputView);

	m_wndDynamicHelpView.DockToWindow (&m_wndPropertiesBar, CBRS_ALIGN_BOTTOM);
	m_wndWatchBar.DockToWindow (&m_wndOutputView, CBRS_ALIGN_LEFT);

	m_wndInfoBar.FloatControlBar (CRect (300, 200, 400, 300));
	//----------------------------------------
	// Allow user-defined toolbars operations:
	//----------------------------------------
	InitUserToobars (NULL,
					uiFirstUserToolBarId,
					uiLastUserToolBarId);

	//------------------------
	// Enable windows manager:
	//------------------------
	EnableWindowsDialog (ID_WINDOW_MANAGER, _T("Windows..."), TRUE);
	return 0;
}

BOOL CMainFrame::SetDefaultFont(CFont& Font, CWnd* pWnd /* = NULL */)
{
	if (pWnd == NULL)
	{
		pWnd = this;
	}

	LOGFONT logFont;
	HFONT hFont = (HFONT)::GetStockObject(SYSTEM_FONT);
	CDC* pDC = pWnd->GetDC();
	CFont* pFont = pDC->SelectObject(CFont::FromHandle(hFont));

	pDC->SelectObject(pFont);
	::DeleteObject(hFont);

	pFont->GetLogFont(&logFont);
	CString sFontName = _T("MS Sans Serif");
	CopyMemory(logFont.lfFaceName,(LPCTSTR)sFontName,(sFontName.GetLength() + 1) * sizeof(TCHAR));
	logFont.lfHeight = 8;
	logFont.lfWidth = 0;
	logFont.lfEscapement = 0;
	logFont.lfOrientation = 0;
	logFont.lfWeight = FW_NORMAL;
	logFont.lfItalic = 0;
	logFont.lfUnderline = 0;
	logFont.lfStrikeOut = 0;
	
	if (!Font.CreateFontIndirect(&logFont))
	{
		return FALSE;
	}

	pWnd->SetFont(&Font);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


void CMainFrame::OnViewCustomize()
{
	//------------------------------------
	// Create a customize toolbars dialog:
	//------------------------------------
	CBCGPToolbarCustomize* pDlgCust = new CBCGPToolbarCustomize (this,
		TRUE /* Automatic menus scaning */,
		BCGCUSTOMIZE_MENU_SHADOWS | BCGCUSTOMIZE_TEXT_LABELS | 
		BCGCUSTOMIZE_LOOK_2000 | BCGCUSTOMIZE_MENU_ANIMATIONS |
		BCGCUSTOMIZE_SELECT_SKINS);

	pDlgCust->EnableUserDefinedToolbars ();

	//-----------------
	// Setup combboxes:
	//-----------------
	pDlgCust->ReplaceButton (ID_EDIT_FIND, CFindComboButton ());

	CBCGPToolbarComboBoxButton comboButtonConfig (ID_DUMMY_SELECT_ACTIVE_CONFIGURATION, 
			CImageHash::GetImageOfCommand (ID_DUMMY_SELECT_ACTIVE_CONFIGURATION, FALSE),
			CBS_DROPDOWNLIST);
	comboButtonConfig.AddItem (_T("Win32 Debug"));
	comboButtonConfig.AddItem (_T("Win32 Release"));
	comboButtonConfig.SelectItem (0);

	pDlgCust->ReplaceButton (ID_DUMMY_SELECT_ACTIVE_CONFIGURATION, comboButtonConfig);

	//-----------------------------------
	// Add dropdown resources button:
	//-----------------------------------
	pDlgCust->AddButton (_T("Build"), CBCGPDropDownToolbarButton (_T("Add Resource"), &m_wndToolbarResource));

	//-------------------------
	// Setup undo/redo buttons:
	//-------------------------
	pDlgCust->ReplaceButton (ID_EDIT_UNDO, CUndoButton (ID_EDIT_UNDO, _T("&Undo")));
	pDlgCust->ReplaceButton (ID_EDIT_REDO, CUndoButton (ID_EDIT_REDO, _T("&Redo")));

	pDlgCust->Create ();
}

LRESULT CMainFrame::OnToolbarContextMenu(WPARAM,LPARAM lp)
{
	CPoint point (BCG_GET_X_LPARAM(lp), BCG_GET_Y_LPARAM(lp));

	CMenu menu;
	VERIFY(menu.LoadMenu (IDR_POPUP_CONTROLBAR));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);

	SetupToolbarMenu (*pPopup, ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10);

	CBCGPPopupMenu* pPopupMenu = new CBCGPPopupMenu;
	pPopupMenu->SetAutoDestroy (FALSE);
	pPopupMenu->Create (this, point.x, point.y, pPopup->GetSafeHmenu ());

	return 0;
}

void CMainFrame::OnToolsViewUserToolbar (UINT uiId)
{
	CBCGPToolBar* pUserToolBar = GetUserBarByIndex (uiId - ID_VIEW_USER_TOOLBAR1);
	if (pUserToolBar == NULL)
	{
		ASSERT (FALSE);
		return;
	}

	
	ShowControlBar (pUserToolBar, !pUserToolBar->IsVisible (), FALSE, FALSE);
	RecalcLayout ();
}

void CMainFrame::OnUpdateToolsViewUserToolbar (CCmdUI* pCmdUI)
{
	CBCGPToolBar* pUserToolBar = GetUserBarByIndex (pCmdUI->m_nID - ID_VIEW_USER_TOOLBAR1);
	if (pUserToolBar == NULL)
	{
		pCmdUI->Enable (FALSE);
		return;
	}

	pCmdUI->Enable(!IsFullScreen ());
	pCmdUI->SetCheck (pUserToolBar->IsVisible ());
}

afx_msg LRESULT CMainFrame::OnToolbarReset(WPARAM wp,LPARAM)
{
	UINT uiToolBarId = (UINT) wp;

	switch (uiToolBarId)
	{
	case IDR_MAINFRAME:
		{
			ASSERT (m_wndToolbarResource.GetSafeHwnd () != NULL);

			//-----------------------------------
			// Replace dropdown resources button:
			//-----------------------------------
			m_wndToolBar.ReplaceButton (ID_DUMMY_INSERT_RESOURCE,
					CBCGPDropDownToolbarButton (_T("Add Resource"), &m_wndToolbarResource));

			//--------------------------------------
			// Replace "Find..." button by combobox:
			//--------------------------------------
			m_wndToolBar.ReplaceButton (ID_EDIT_FIND, CFindComboButton ());

			//-------------------------------------
			// Replace "Undo" button by menubutton:
			//-------------------------------------
			m_wndToolBar.ReplaceButton (ID_EDIT_UNDO, CUndoButton (ID_EDIT_UNDO, _T("&Undo")));
			m_wndToolBar.ReplaceButton (ID_EDIT_REDO, CUndoButton (ID_EDIT_REDO, _T("&Redo")));
		}
		break;

	case IDR_BUILD:
		{
			//-----------------------------------------------
			// Replace "Confoguration..." button by combobox:
			//-----------------------------------------------
			CBCGPToolbarComboBoxButton comboButton (ID_DUMMY_SELECT_ACTIVE_CONFIGURATION, 
				CImageHash::GetImageOfCommand (ID_DUMMY_SELECT_ACTIVE_CONFIGURATION, FALSE),
				CBS_DROPDOWNLIST);
			comboButton.AddItem (_T("Win32 Debug"));
			comboButton.AddItem (_T("Win32 Release"));
			comboButton.SelectItem (0);

			m_wndToolbarBuild.ReplaceButton (ID_DUMMY_SELECT_ACTIVE_CONFIGURATION,
											comboButton);
		}
		break;
	}

	return 0;
}

LRESULT CMainFrame::OnHelpCustomizeToolbars(WPARAM wp, LPARAM lp)
{
//	int iPageNum = (int) wp;

	CBCGPToolbarCustomize* pDlg = (CBCGPToolbarCustomize*) lp;
	ASSERT_VALID (pDlg);

	// TODO: show help about page number iPageNum


	return 0;
}

BOOL CMainFrame::OnShowPopupMenu (CBCGPPopupMenu* pMenuPopup)
{
    CBCGPMDIFrameWnd::OnShowPopupMenu (pMenuPopup);

    if (pMenuPopup == NULL)
	{
		return TRUE;
	}

    if (pMenuPopup->GetMenuBar ()->CommandToIndex (ID_VIEW_TOOLBARS) >= 0)
    {
		if (CBCGPToolBar::IsCustomizeMode ())
		{
			return FALSE;
		}

		pMenuPopup->RemoveAllItems ();

		CMenu menu;
		VERIFY(menu.LoadMenu (IDR_POPUP_TOOLBAR));

		CMenu* pPopup = menu.GetSubMenu(0);
		ASSERT(pPopup != NULL);

		SetupToolbarMenu (*pPopup, ID_VIEW_USER_TOOLBAR1, ID_VIEW_USER_TOOLBAR10);
		pMenuPopup->GetMenuBar ()->ImportFromMenu (*pPopup, TRUE);
    }

	return TRUE;
}

void CMainFrame::OnViewOutput() 
{
	ShowControlBar (&m_wndOutputView,
					!m_wndOutputView.IsVisible (),
					FALSE, FALSE);
	RecalcLayout ();
}

void CMainFrame::OnUpdateViewOutput(CCmdUI* pCmdUI) 
{
	if (pCmdUI->m_pOther != NULL &&
		!pCmdUI->m_pOther->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		pCmdUI->SetCheck (m_wndOutputView.IsVisible ());
	}
}

void CMainFrame::OnViewBuildToolbar() 
{
	ShowControlBar (&m_wndToolbarBuild,
					!m_wndToolbarBuild.IsVisible (),
					FALSE, FALSE);
}

void CMainFrame::OnUpdateViewBuildToolbar(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!IsFullScreen ());
	pCmdUI->SetCheck (m_wndToolbarBuild.IsVisible ());
}

void CMainFrame::OnViewWatch() 
{
	ShowControlBar (&m_wndWatchBar,
					!m_wndWatchBar.IsVisible (),
					FALSE, FALSE);
}

void CMainFrame::OnUpdateViewWatch(CCmdUI* pCmdUI) 
{
	if (pCmdUI->m_pOther != NULL &&
		!pCmdUI->m_pOther->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		pCmdUI->SetCheck (m_wndWatchBar.IsVisible ());
	}
}

void CMainFrame::OnWindowManager() 
{
	ShowWindowsDialog ();
}

BOOL CMainFrame::LoadFrame(UINT nIDResource, DWORD dwDefaultStyle, CWnd* pParentWnd, CCreateContext* pContext) 
{
	if (!CMDIFrameWnd::LoadFrame(nIDResource, dwDefaultStyle, pParentWnd, pContext))
	{
		return FALSE;
	}

	// Add some tools for example....
	CBCGPUserToolsManager* pUserToolsManager = theApp.GetUserToolsManager ();
	if (pUserToolsManager != NULL &&
		pUserToolsManager->GetUserTools ().IsEmpty ())
	{
		CBCGPUserTool* pTool1 = pUserToolsManager->CreateNewTool ();
		pTool1->m_strLabel = _T("Notepad");
		pTool1->SetCommand (_T("notepad.exe"));

		CBCGPUserTool* pTool2 = pUserToolsManager->CreateNewTool ();
		pTool2->m_strLabel = _T("Paint Brush");
		pTool2->SetCommand (_T("mspaint.exe"));

		CBCGPUserTool* pTool3 = pUserToolsManager->CreateNewTool ();
		pTool3->m_strLabel = _T("Windows Explorer");
		pTool3->SetCommand (_T("explorer.exe"));

		CBCGPUserTool* pTool4 = pUserToolsManager->CreateNewTool ();
		pTool4->m_strLabel = _T("BCGSoft On-Line");
		pTool4->SetCommand (_T("http://www.bcgsoft.com"));
	}

	EnableMDITabs (TRUE, FALSE, CBCGPTabWnd::LOCATION_TOP, TRUE);

	//----------------------------------------------------
	// Enable customization button fore all user toolbars:
	//----------------------------------------------------
	for (int i = 0; i < iMaxUserToolbars; i ++)
	{
		CBCGPToolBar* pUserToolbar = GetUserBarByIndex (i);
		if (pUserToolbar != NULL)
		{
			pUserToolbar->EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, _T("Customize..."));
		}
	}


	return TRUE;
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	//----------------------------------------------------
	// If control located on toolbar has focus, we should 
	// redirect clipboard commands to this control:
	//----------------------------------------------------
	if (CFindComboButton::HasFocus () &&
		HIWORD (wParam) == 1)	// Command from accelerator
	{
		UINT uiCmd = LOWORD (wParam);
		switch (uiCmd)
		{
		case ID_EDIT_PASTE:
			::SendMessage (::GetFocus (), WM_PASTE, 0, 0);
			return TRUE;

		case ID_EDIT_COPY:
			::SendMessage (::GetFocus (), WM_COPY, 0, 0);
			return TRUE;

		case ID_EDIT_CUT:
			::SendMessage (::GetFocus (), WM_CUT, 0, 0);
			return TRUE;
		}
	}
	
	return CMDIFrameWnd::OnCommand(wParam, lParam);
}

void CMainFrame::OnHelpKeyboardmap() 
{
	CBCGPKeyMapDlg dlg (this, TRUE /* Enable Print */);
	dlg.DoModal ();
}

void CMainFrame::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	if (pWnd->GetSafeHwnd () == m_wndClientArea.GetSafeHwnd ())
	{
		OnToolbarContextMenu (0, MAKELPARAM(point.x, point.y));
	}
	else if (pWnd->GetSafeHwnd () == m_wndClientArea.GetMDITabs ().GetSafeHwnd ())
	{
		CBCGPTabWnd& wndTab = (CBCGPTabWnd&) m_wndClientArea.GetMDITabs ();
		
		CRect rectTabs;
		wndTab.GetTabsRect (rectTabs);

		CPoint ptTab = point;
		wndTab.ScreenToClient (&ptTab);

		const int nTab = wndTab.GetTabFromPoint (ptTab);

		if (nTab >= 0)
		{
			wndTab.SetActiveTab (nTab);
			theApp.ShowPopupMenu (IDR_POPUP_MDITABS, point, this);
		}
	}
}

void CMainFrame::OnViewClass() 
{
	// demonstartes how to make bar active in autohide mode and inactive when non-tabbed
	BOOL bAutoHideMode = m_wndClassView.IsAutoHideMode ();
	BOOL bTabbed = m_wndClassView.IsTabbed ();

	ShowControlBar (&m_wndClassView,
					!m_wndClassView.IsVisible (),
					FALSE, bAutoHideMode || !bTabbed);
	RecalcLayout ();
}

void CMainFrame::OnUpdateViewClass(CCmdUI* pCmdUI) 
{
	if (pCmdUI->m_pOther != NULL &&
		!pCmdUI->m_pOther->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		pCmdUI->SetCheck (m_wndClassView.IsVisible ());	
	}
}

void CMainFrame::OnViewResource() 
{
	// demonstartes how to make bar active in autohide mode and inactive when non-tabbed
	BOOL bAutoHideMode = m_wndResourceView.IsAutoHideMode ();
	BOOL bTabbed = m_wndResourceView.IsTabbed ();

	ShowControlBar (&m_wndResourceView,
					!m_wndResourceView.IsVisible (),
					FALSE, bAutoHideMode || !bTabbed);
	RecalcLayout ();
}

void CMainFrame::OnUpdateViewResource(CCmdUI* pCmdUI) 
{
	if (pCmdUI->m_pOther != NULL &&
		!pCmdUI->m_pOther->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		pCmdUI->SetCheck (m_wndResourceView.IsVisible ());	
	}
}

void CMainFrame::OnViewFile() 
{
	// demonstartes how to make bar active in autohide mode and inactive when non-tabbed
	BOOL bAutoHideMode = m_wndFileView.IsAutoHideMode ();
	BOOL bTabbed = m_wndFileView.IsTabbed ();

	ShowControlBar (&m_wndFileView,
					!m_wndFileView.IsVisible (),
					FALSE, bAutoHideMode || !bTabbed);
	RecalcLayout ();
}

void CMainFrame::OnUpdateViewFile(CCmdUI* pCmdUI) 
{
	if (pCmdUI->m_pOther != NULL &&
		!pCmdUI->m_pOther->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		pCmdUI->SetCheck (m_wndFileView.IsVisible ());	
	}
}


LRESULT CMainFrame::OnToolbarCreateNew(WPARAM wp,LPARAM lp)
{
	LRESULT lres = CBCGPMDIFrameWnd::OnToolbarCreateNew (wp,lp);
	if (lres == 0)
	{
		return 0;
	}

	CBCGPToolBar* pUserToolbar = (CBCGPToolBar*) lres;
	ASSERT_VALID (pUserToolbar);

	pUserToolbar->EnableCustomizeButton (TRUE, ID_VIEW_CUSTOMIZE, _T("Customize..."));
	return lres;
}

BOOL CMainFrame::CreateDockingBars ()
{
	//------------------
	// Crate class view:
	//------------------
	if (!m_wndClassView.Create (_T("Class View"), this, CRect (0, 0, 200, 200),
		TRUE, 
		ID_VIEW_CLASS,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_LEFT | CBRS_FLOAT_MULTI))
	{
		TRACE0("Failed to create Class View bar\n");
		return FALSE;      // fail to create
	}

	HICON hClassViewIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_CLASS_VIEW),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndClassView.SetIcon (hClassViewIcon, FALSE);

	//----------------------
	// Create resource view:
	//----------------------
	if (!m_wndResourceView.Create (_T("Resource View"), this, CRect (0, 0, 200, 200),
		TRUE, 
		ID_VIEW_RESOURCE,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_LEFT | CBRS_FLOAT_MULTI))
	{
		TRACE0("Failed to create Resource View bar\n");
		return FALSE;      // fail to create
	}

	HICON hResViewIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_RES_VIEW),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndResourceView.SetIcon (hResViewIcon, FALSE);

	//------------------
	// Create file view:
	//------------------
	if (!m_wndFileView.Create (_T("Solution Explorer"), this, CRect (0, 0, 200, 200),
		TRUE, 
		ID_VIEW_FILE,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_LEFT| CBRS_FLOAT_MULTI))
	{
		TRACE0("Failed to create Solution Explorer bar\n");
		return FALSE;      // fail to create
	}

	HICON hFileViewIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_FILE_VIEW),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndFileView.SetIcon (hFileViewIcon, FALSE);


	//////////////////////////////////New Output////////////////////////////////////////
	if (!m_wndOutputView.Create (_T("Output"), this, CRect (0, 0, 100, 100),
		TRUE, 
		ID_VIEW_OUTPUT,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_BOTTOM | CBRS_FLOAT_MULTI))
	{
		TRACE0("Failed to create output bar\n");
		return FALSE;      // fail to create
	}

	HICON hOutputBarIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_OUTPUT_BAR),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndOutputView.SetIcon (hOutputBarIcon, FALSE);

	if (!m_wndDynamicHelpView.Create (_T("Dynamic Help"), this, CRect (0, 0, 200, 200),
		TRUE, 
		ID_VIEW_DYNAMICHELP,
		WS_CHILD | WS_VISIBLE | CBRS_RIGHT))
	{
		TRACE0("Failed to create Dynamic Help Bar\n");
		return FALSE;		// fail to create
	}

	HICON hDynamicHelpIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_DYNAMICHELP_VIEW),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndDynamicHelpView.SetIcon (hDynamicHelpIcon, FALSE);


	//------------------
	// Create watch bar:
	//------------------
	if (!m_wndWatchBar.Create (_T("Watch"), this, CRect (0, 0, 100, 100),
		TRUE, 
		ID_VIEW_WATCH,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_BOTTOM | CBRS_FLOAT_MULTI))
	{
		TRACE0("Failed to create watch bar\n");
		return FALSE;      // fail to create
	}

	HICON hWatchBarIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_WATCH_BAR),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndWatchBar.SetIcon (hWatchBarIcon, FALSE);

	if (!m_wndPropertiesBar.Create (_T("Properties"), this, CRect (0, 0, 200, 200),
		TRUE, 
		ID_VIEW_PROPERTIES,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_RIGHT | CBRS_FLOAT_MULTI))
	{
		TRACE0("Failed to create Properties Bar\n");
		return FALSE;		// fail to create
	}
	
	HICON hPropertiesBarIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_PROPERTIES_BAR),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndPropertiesBar.SetIcon (hPropertiesBarIcon, FALSE);

	if (!m_wndToolBoxBar.Create (_T("ToolBox"), this, CRect (0, 0, 200, 200),
		TRUE, 
		ID_TOOLBOX,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CBRS_RIGHT | CBRS_FLOAT_MULTI))
	{
		TRACE0("Failed to create ToolBox Bar\n");
		return FALSE;		// fail to create
	}
	
	HICON hToolBoxBarIcon = (HICON) ::LoadImage (::AfxGetResourceHandle (), 
				MAKEINTRESOURCE (IDI_TOOLBOX_BAR),
				IMAGE_ICON, ::GetSystemMetrics (SM_CXSMICON), ::GetSystemMetrics (SM_CYSMICON), 0);
	m_wndToolBoxBar.SetIcon (hToolBoxBarIcon, FALSE);

	return TRUE;
}

void CMainFrame::OnViewDynamichelp() 
{
	// demonstartes how to make bar active in autohide mode and inactive when non-tabbed
	BOOL bAutoHideMode = m_wndDynamicHelpView.IsAutoHideMode ();
	BOOL bTabbed = m_wndDynamicHelpView.IsTabbed ();

	ShowControlBar (&m_wndDynamicHelpView,
					!m_wndDynamicHelpView.IsVisible (),
					FALSE, bAutoHideMode || !bTabbed);
	RecalcLayout ();
	
}

void CMainFrame::OnUpdateViewDynamichelp(CCmdUI* pCmdUI) 
{
	if (pCmdUI->m_pOther != NULL &&
		!pCmdUI->m_pOther->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		pCmdUI->SetCheck (m_wndDynamicHelpView.IsVisible ());	
	}
}

void CMainFrame::OnFileNewProject() 
{
	// TODO: Add your command handler code here
	
}

void CMainFrame::OnFileNewBlankSolution() 
{
	// TODO: Add your command handler code here
	
}

void CMainFrame::OnFileOpenSolution() 
{
	// TODO: Add your command handler code here
	
}

void CMainFrame::OnFileCloseSolution() 
{
	// TODO: Add your command handler code here
	
}

void CMainFrame::OnFileSaveAll() 
{
	// TODO: Add your command handler code here
	
}

void CMainFrame::OnViewProperties() 
{
	// demonstartes how to make bar active in autohide mode and inactive when non-tabbed
	BOOL bAutoHideMode = m_wndPropertiesBar.IsAutoHideMode ();
	BOOL bTabbed = m_wndPropertiesBar.IsTabbed ();

	ShowControlBar (&m_wndPropertiesBar,
					!m_wndPropertiesBar.IsVisible (),
					FALSE, bAutoHideMode || !bTabbed);
	RecalcLayout ();
}

void CMainFrame::OnUpdateViewProperties(CCmdUI* pCmdUI) 
{
	if (pCmdUI->m_pOther != NULL &&
		!pCmdUI->m_pOther->IsKindOf (RUNTIME_CLASS (CBCGPPopupMenuBar)))
	{
		pCmdUI->SetCheck (m_wndPropertiesBar.IsVisible ());	
	}
}

void CMainFrame::OnViewRefresh() 
{
	// TODO: Add your command handler code here
}

void CMainFrame::OnToolsConnectToDatabase() 
{
	// TODO: Add your command handler code here
}

void CMainFrame::OnToolsDebugProcesses() 
{
	// TODO: Add your command handler code here
	
}

void CMainFrame::OnClose() 
{
	if (m_bFullScreen)
	{
		OnViewFullScreen();	// Return to normal mode
	}

	CMDIFrameWnd::OnClose();
}

void CMainFrame::OnViewFullScreen()
{
	WINDOWPLACEMENT wpNew;
	
	if (!m_bFullScreen)
	{
		// We'll need these to restore the original state.
		m_wpPrev.length	= sizeof m_wpPrev;
		GetWindowPlacement(&m_wpPrev);
		
		CMDIChildWnd*	pChildWnd	= MDIGetActive();
		if (pChildWnd == NULL)
		{
			return;
		}

		CWnd* pViewWnd = pChildWnd->GetActiveView();
		if (pViewWnd == NULL)
		{
			return;
		}

		CRect rectDesktop, rectFrame, rectView;

		// Adjust RECT to new size of window
		VERIFY(::GetWindowRect(::GetDesktopWindow(), &rectDesktop));
		GetWindowRect(&rectFrame);
		pViewWnd->GetWindowRect(&rectView);
		rectFrame.InflateRect(
			rectView.left - rectDesktop.left,
			rectView.top - rectDesktop.top,
			rectDesktop.right - rectView.right,
			rectDesktop.bottom - rectView.bottom);
		
		// Remember this for OnGetMinMaxInfo()
		m_rectFullScreenWindow = rectFrame;
		
		wpNew					= m_wpPrev;
		wpNew.showCmd			= SW_SHOWNORMAL;
		wpNew.rcNormalPosition	= rectFrame;
		
		m_pwndFullScreenBar	= new CBCGPToolBar;
		
		if (!m_pwndFullScreenBar->Create(this))
		{
            TRACE0("Failed to create toolbar\n");
			return;      // fail to create
		}
		
		//don't allow the toolbar to dock
		CBCGPToolbarButton	button(ID_VIEW_FULLSCREEN, -1, _T("Close Full Screen"), FALSE, TRUE);
		m_pwndFullScreenBar->InsertButton(button);
		m_pwndFullScreenBar->EnableDocking(0);
		m_pwndFullScreenBar->SetWindowPos(0, 100, 100, 100, 100, SWP_NOZORDER | SWP_NOACTIVATE | SWP_SHOWWINDOW);
		m_pwndFullScreenBar->SetWindowText(_T("Full Screen"));
		m_pwndFullScreenBar->FloatControlBar(CRect(100, 100, 200, 200));
		m_bFullScreen = true;
	}
	else
	{
		// Destroy the toolbar
		CWnd*	pWnd	= m_pwndFullScreenBar->GetParentMiniFrame();
		if (pWnd == NULL)
			pWnd	= m_pwndFullScreenBar;
		VERIFY(pWnd->DestroyWindow());

		delete m_pwndFullScreenBar; 
		
		m_pwndFullScreenBar = NULL;
		m_bFullScreen = false;
		
		{	// This is a workaround to prevent the toolbars from being broken
			//	into different rows, when the window is maximized and
			//	the restored position is too small.
			WINDOWPLACEMENT	wpNew(m_wpPrev);
			VERIFY(::CopyRect(&wpNew.rcNormalPosition, &m_rectFullScreenWindow));
			VERIFY(SetWindowPlacement(&wpNew));
		}

		wpNew	= m_wpPrev;
	}
	
	VERIFY(SetWindowPlacement(&wpNew));
}

void CMainFrame::OnGetMinMaxInfo(MINMAXINFO* lpMMI)
{
	if (m_bFullScreen)
	{
		lpMMI->ptMaxSize.x		=
		lpMMI->ptMaxTrackSize.x	= m_rectFullScreenWindow.Width();

		lpMMI->ptMaxSize.y		=
		lpMMI->ptMaxTrackSize.y	= m_rectFullScreenWindow.Height();
	}
}

void CMainFrame::OnViewToolbox() 
{
	// demonstartes how to make bar active in autohide mode and inactive when non-tabbed
	BOOL bAutoHideMode = m_wndToolBoxBar.IsAutoHideMode ();
	BOOL bTabbed = m_wndToolBoxBar.IsTabbed ();

	ShowControlBar (&m_wndToolBoxBar,
					!m_wndToolBoxBar.IsVisible (),
					FALSE, bAutoHideMode || !bTabbed);
	RecalcLayout ();
}

void CMainFrame::OnUpdateViewToolbox(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_wndToolBoxBar.IsVisible ());
}

void CMainFrame::OnViewInfobar() 
{
	BOOL bAutoHideMode = m_wndInfoBar.IsAutoHideMode ();
	BOOL bTabbed = m_wndInfoBar.IsTabbed ();

	ShowControlBar (&m_wndInfoBar,
					!m_wndInfoBar.IsVisible (),
					FALSE, bAutoHideMode || !bTabbed);
	RecalcLayout ();
	
}

void CMainFrame::OnUpdateViewInfobar(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck (m_wndInfoBar.IsVisible ());
}

void CMainFrame::OnViewEditToolbar() 
{
	ShowControlBar (&m_wndToolbarEdit,
					!m_wndToolbarEdit.IsVisible (),
					FALSE, FALSE);
}

void CMainFrame::OnUpdateViewEditToolbar(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!IsFullScreen ());
	pCmdUI->SetCheck (m_wndToolbarEdit.IsVisible ());
}

void CMainFrame::OnToolBox() 
{
	CString str;
	str.Format (_T("Toolbox item clicked\nPage = %d, item = %d"), m_wndToolBoxBar.GetActivePage (),
		m_wndToolBoxBar.GetLastClickedTool (m_wndToolBoxBar.GetActivePage ()));
	MessageBox (str);
}

CBCGPToolbarComboBoxButton* CMainFrame::GetFindCombo()
{
	CBCGPToolbarComboBoxButton* pFindCombo = NULL;

	CObList listButtons;
	if (CBCGPToolBar::GetCommandButtons (ID_EDIT_FIND_COMBO, listButtons) > 0)
	{
		for (POSITION posCombo = listButtons.GetHeadPosition (); 
			 pFindCombo == NULL && posCombo != NULL;)
		{
			CBCGPToolbarComboBoxButton* pCombo = 
				DYNAMIC_DOWNCAST (CBCGPToolbarComboBoxButton, listButtons.GetNext (posCombo));

			if (pCombo != NULL)
			{
				pFindCombo = pCombo;
			}
		}
	}

	return pFindCombo;
}

void CMainFrame::OnToolsOptions() 
{
	COptionsDlg dlgOptions (_T("Options"), this);
	dlgOptions.DoModal ();
}
