/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Serializer;
import org.apache.xalan.serialize.SerializerFactory;
import org.apache.xalan.templates.OutputProperties;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerIdentityImpl
extends Transformer
implements TransformerHandler,
DeclHandler {
    boolean m_flushedStartDoc = false;
    private FileOutputStream m_outputStream = null;
    private ContentHandler m_resultContentHandler;
    private LexicalHandler m_resultLexicalHandler;
    private DTDHandler m_resultDTDHandler;
    private DeclHandler m_resultDeclHandler;
    private Serializer m_serializer;
    private Result m_result;
    private String m_systemID;
    private Hashtable m_params;
    private ErrorListener m_errorListener = new DefaultErrorHandler();
    URIResolver m_URIResolver;
    private OutputProperties m_outputFormat = new OutputProperties("xml");
    boolean m_foundFirstElement;

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.attributeDecl(eName, aName, type, valueDefault, value);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.characters(ch, start, length);
    }

    public void clearParameters() {
        if (this.m_params == null) {
            return;
        }
        this.m_params.clear();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushStartDoc();
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.comment(ch, start, length);
        }
    }

    private void createResultContentHandler(Result outputTarget) throws TransformerException {
        if (outputTarget instanceof SAXResult) {
            SAXResult saxResult = (SAXResult)outputTarget;
            this.m_resultContentHandler = saxResult.getHandler();
            this.m_resultLexicalHandler = saxResult.getLexicalHandler();
            if (this.m_resultContentHandler instanceof Serializer) {
                this.m_serializer = (Serializer)((Object)this.m_resultContentHandler);
            }
        } else if (outputTarget instanceof DOMResult) {
            Document doc;
            short type;
            DOMResult domResult = (DOMResult)outputTarget;
            Node outputNode = domResult.getNode();
            if (outputNode != null) {
                type = outputNode.getNodeType();
                doc = type == 9 ? (Document)outputNode : outputNode.getOwnerDocument();
            } else {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    doc = db.newDocument();
                }
                catch (ParserConfigurationException pce) {
                    throw new TransformerException(pce);
                }
                outputNode = doc;
                type = outputNode.getNodeType();
                ((DOMResult)outputTarget).setNode(outputNode);
            }
            this.m_resultContentHandler = type == 11 ? new DOMBuilder(doc, (DocumentFragment)outputNode) : new DOMBuilder(doc, outputNode);
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        } else if (outputTarget instanceof StreamResult) {
            StreamResult sresult = (StreamResult)outputTarget;
            String method = this.m_outputFormat.getProperty("method");
            try {
                Serializer serializer;
                this.m_serializer = serializer = SerializerFactory.getSerializer(this.m_outputFormat.getProperties());
                if (sresult.getWriter() != null) {
                    serializer.setWriter(sresult.getWriter());
                } else if (sresult.getOutputStream() != null) {
                    serializer.setOutputStream(sresult.getOutputStream());
                } else if (sresult.getSystemId() != null) {
                    String fileURL = sresult.getSystemId();
                    if (fileURL.startsWith("file:///")) {
                        fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                    }
                    this.m_outputStream = new FileOutputStream(fileURL);
                    serializer.setOutputStream(this.m_outputStream);
                } else {
                    throw new TransformerException(XSLMessages.createMessage(147, null));
                }
                this.m_resultContentHandler = serializer.asContentHandler();
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
        } else {
            throw new TransformerException(XSLMessages.createMessage(148, new Object[]{outputTarget.getClass().getName()}));
        }
        if (this.m_resultContentHandler instanceof DTDHandler) {
            this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof DeclHandler) {
            this.m_resultDeclHandler = (DeclHandler)((Object)this.m_resultContentHandler);
        }
        if (this.m_resultContentHandler instanceof LexicalHandler) {
            this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.elementDecl(name, model);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endDocument();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.m_resultContentHandler.endElement(uri, localName, qName);
    }

    public void endEntity(String name) throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.endEntity(name);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.endPrefixMapping(prefix);
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.externalEntityDecl(name, publicId, systemId);
        }
    }

    protected final void flushStartDoc() throws SAXException {
        if (!this.m_flushedStartDoc) {
            this.m_resultContentHandler.startDocument();
            this.m_flushedStartDoc = true;
        }
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.m_outputFormat.getProperties()).clone();
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        String value = null;
        OutputProperties props = this.m_outputFormat;
        value = props.getProperty(name);
        if (value == null && !props.isLegalPropertyKey(name)) {
            throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{name}));
        }
        return value;
    }

    public Object getParameter(String name) {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.get(name);
    }

    public String getSystemId() {
        return this.m_systemID;
    }

    public Transformer getTransformer() {
        return this;
    }

    public URIResolver getURIResolver() {
        return this.m_URIResolver;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.m_resultContentHandler.ignorableWhitespace(ch, start, length);
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.m_resultDeclHandler != null) {
            this.m_resultDeclHandler.internalEntityDecl(name, value);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.m_resultDTDHandler != null) {
            this.m_resultDTDHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (this.m_resultContentHandler == null) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        this.m_resultContentHandler.setDocumentLocator(locator);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.m_errorListener = listener;
    }

    public void setOutputProperties(Properties oformat) throws IllegalArgumentException {
        if (oformat != null) {
            String method = (String)((Hashtable)oformat).get("method");
            this.m_outputFormat = method != null ? new OutputProperties(method) : new OutputProperties();
        }
        if (oformat != null) {
            this.m_outputFormat.copyFrom(oformat);
        }
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        if (!this.m_outputFormat.isLegalPropertyKey(name)) {
            throw new IllegalArgumentException(XSLMessages.createMessage(197, new Object[]{name}));
        }
        this.m_outputFormat.setProperty(name, value);
    }

    public void setParameter(String name, Object value) {
        if (this.m_params == null) {
            this.m_params = new Hashtable();
        }
        this.m_params.put(name, value);
    }

    public void setResult(Result result) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException(XSLMessages.createMessage(145, null));
        }
        this.m_result = result;
    }

    public void setSystemId(String systemID) {
        this.m_systemID = systemID;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_URIResolver = resolver;
    }

    public void skippedEntity(String name) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.skippedEntity(name);
    }

    public void startCDATA() throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.startCDATA();
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.flushStartDoc();
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void startDocument() throws SAXException {
        try {
            if (this.m_resultContentHandler == null) {
                this.createResultContentHandler(this.m_result);
            }
        }
        catch (TransformerException te) {
            throw new SAXException(te.getMessage(), te);
        }
        this.m_flushedStartDoc = false;
        this.m_foundFirstElement = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.m_foundFirstElement && this.m_serializer != null) {
            Serializer newSerializer;
            this.m_foundFirstElement = true;
            try {
                newSerializer = SerializerSwitcher.switchSerializerIfHTML(uri, localName, this.m_outputFormat.getProperties(), this.m_serializer);
            }
            catch (TransformerException te) {
                throw new SAXException(te);
            }
            if (newSerializer != this.m_serializer) {
                try {
                    this.m_resultContentHandler = newSerializer.asContentHandler();
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                if (this.m_resultContentHandler instanceof DTDHandler) {
                    this.m_resultDTDHandler = (DTDHandler)((Object)this.m_resultContentHandler);
                }
                if (this.m_resultContentHandler instanceof LexicalHandler) {
                    this.m_resultLexicalHandler = (LexicalHandler)((Object)this.m_resultContentHandler);
                }
                this.m_serializer = newSerializer;
            }
        }
        this.flushStartDoc();
        this.m_resultContentHandler.startElement(uri, localName, qName, attributes);
    }

    public void startEntity(String name) throws SAXException {
        if (this.m_resultLexicalHandler != null) {
            this.m_resultLexicalHandler.startEntity(name);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.flushStartDoc();
        this.m_resultContentHandler.startPrefixMapping(prefix, uri);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source source, Result outputTarget) throws TransformerException {
        this.createResultContentHandler(outputTarget);
        try {
            if (source instanceof DOMSource) {
                dsource = (DOMSource)source;
                this.m_systemID = dsource.getSystemId();
                dNode = dsource.getNode();
                if (dNode == null) {
                    messageStr = XSLMessages.createMessage(108, null);
                    throw new IllegalArgumentException(messageStr);
                }
                try {
                    block41: {
                        if (dNode.getNodeType() != 9) {
                            this.startDocument();
                        }
                        try {
                            if (dNode.getNodeType() == 2) {
                                data = dNode.getNodeValue();
                                chars = data.toCharArray();
                                this.characters(chars, 0, chars.length);
                                break block41;
                            }
                            walker = new TreeWalker(this, new DOM2Helper(), this.m_systemID);
                            walker.traverse(dNode);
                        }
                        catch (Throwable var7_19) {
                            var8_15 = null;
                            if (dNode.getNodeType() == 9) throw var7_19;
                            this.endDocument();
                            throw var7_19;
                        }
                    }
                    var8_14 = null;
                    if (dNode.getNodeType() != 9) {
                        this.endDocument();
                    }
                }
                catch (SAXException se) {
                    throw new TransformerException(se);
                }
                var4_24 = null;
                if (this.m_outputStream == null) return;
                try {
                    this.m_outputStream.close();
                }
                catch (IOException v0) {}
                this.m_outputStream = null;
                return;
            }
            xmlSource = SAXSource.sourceToInputSource(source);
            if (xmlSource == null) {
                throw new TransformerException(XSLMessages.createMessage(149, new Object[]{source.getClass().getName()}));
            }
            if (xmlSource.getSystemId() != null) {
                this.m_systemID = xmlSource.getSystemId();
            }
            try {
                reader = null;
                if (source instanceof SAXSource) {
                    reader = ((SAXSource)source).getXMLReader();
                }
                v1 = isUserReader = reader != null;
                if (reader == null) {
                    try {
                        factory = SAXParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        jaxpParser = factory.newSAXParser();
                        reader = jaxpParser.getXMLReader();
                    }
                    catch (ParserConfigurationException ex) {
                        throw new SAXException(ex);
                    }
                    catch (FactoryConfigurationError ex1) {
                        throw new SAXException(ex1.toString());
                    }
                    catch (NoSuchMethodError v2) {
                    }
                    catch (AbstractMethodError v3) {}
                }
                if (reader == null) {
                    reader = XMLReaderFactory.createXMLReader();
                }
                try {
                    reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                }
                catch (SAXException v4) {}
                inputHandler = this;
                reader.setContentHandler(inputHandler);
                if (inputHandler instanceof DTDHandler) {
                    reader.setDTDHandler(inputHandler);
                }
                try {
                    if (inputHandler instanceof LexicalHandler) {
                        reader.setProperty("http://xml.org/sax/properties/lexical-handler", inputHandler);
                    }
                    if (inputHandler instanceof DeclHandler) {
                        reader.setProperty("http://xml.org/sax/properties/declaration-handler", inputHandler);
                    }
                }
                catch (SAXException v5) {}
                try {
                    if (inputHandler instanceof LexicalHandler) {
                        reader.setProperty("http://xml.org/sax/handlers/LexicalHandler", inputHandler);
                    }
                    if (inputHandler instanceof DeclHandler) {
                        reader.setProperty("http://xml.org/sax/handlers/DeclHandler", inputHandler);
                    }
                }
                catch (SAXNotRecognizedException v6) {}
                reader.parse(xmlSource);
            }
            catch (WrappedRuntimeException wre) {
                throwable = wre.getException();
                if (true) ** GOTO lbl123
            }
            catch (SAXException se) {
                throw new TransformerException(se);
            }
            catch (IOException ioe) {
                throw new TransformerException(ioe);
            }
            var4_25 = null;
            if (this.m_outputStream == null) return;
        }
        catch (Throwable var3_27) {
            var4_26 = null;
            if (this.m_outputStream == null) throw var3_27;
            try {}
            catch (IOException v7) {}
            this.m_outputStream.close();
            this.m_outputStream = null;
            throw var3_27;
        }
        try {}
        catch (IOException v8) {}
        this.m_outputStream.close();
        this.m_outputStream = null;
        return;
        do {
            throwable = ((WrappedRuntimeException)throwable).getException();
lbl123:
            // 2 sources

        } while (throwable instanceof WrappedRuntimeException);
        throw new TransformerException(wre.getException());
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.m_resultDTDHandler != null) {
            this.m_resultDTDHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }
}

