/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.util.TooManyListenersException;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.trace.EndSelectionEvent;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TraceListenerEx;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.XPath;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class TraceManager {
    private TransformerImpl m_transformer;
    private Vector m_traceListeners = null;

    public TraceManager(TransformerImpl transformer) {
        this.m_transformer = transformer;
    }

    public void addTraceListener(TraceListener tl) throws TooManyListenersException {
        TransformerImpl.S_DEBUG = true;
        if (this.m_traceListeners == null) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(tl);
    }

    public void fireGenerateEvent(GenerateEvent te) {
        if (this.m_traceListeners != null) {
            int nListeners = this.m_traceListeners.size();
            int i = 0;
            while (i < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                tl.generated(te);
                ++i;
            }
        }
    }

    public void fireSelectedEndEvent(int sourceNode, ElemTemplateElement styleNode, String attributeName, XPath xpath, XObject selection) throws TransformerException {
        if (this.hasTraceListeners()) {
            Node source = this.m_transformer.getXPathContext().getDTM(sourceNode).getNode(sourceNode);
            this.fireSelectedEndEvent(new EndSelectionEvent(this.m_transformer, source, styleNode, attributeName, xpath, selection));
        }
    }

    public void fireSelectedEndEvent(EndSelectionEvent se) throws TransformerException {
        if (this.hasTraceListeners()) {
            int nListeners = this.m_traceListeners.size();
            int i = 0;
            while (i < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                if (tl instanceof TraceListenerEx) {
                    ((TraceListenerEx)tl).selectEnd(se);
                }
                ++i;
            }
        }
    }

    public void fireSelectedEvent(int sourceNode, ElemTemplateElement styleNode, String attributeName, XPath xpath, XObject selection) throws TransformerException {
        if (this.hasTraceListeners()) {
            Node source = this.m_transformer.getXPathContext().getDTM(sourceNode).getNode(sourceNode);
            this.fireSelectedEvent(new SelectionEvent(this.m_transformer, source, styleNode, attributeName, xpath, selection));
        }
    }

    public void fireSelectedEvent(SelectionEvent se) throws TransformerException {
        if (this.hasTraceListeners()) {
            int nListeners = this.m_traceListeners.size();
            int i = 0;
            while (i < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                tl.selected(se);
                ++i;
            }
        }
    }

    public void fireTraceEvent(ElemTemplateElement styleNode) {
        if (this.hasTraceListeners()) {
            int sourceNode = this.m_transformer.getXPathContext().getCurrentNode();
            Node source = this.m_transformer.getXPathContext().getDTM(sourceNode).getNode(sourceNode);
            this.fireTraceEvent(new TracerEvent(this.m_transformer, source, this.m_transformer.getMode(), styleNode));
        }
    }

    public void fireTraceEvent(TracerEvent te) {
        if (this.hasTraceListeners()) {
            int nListeners = this.m_traceListeners.size();
            int i = 0;
            while (i < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i);
                tl.trace(te);
                ++i;
            }
        }
    }

    public boolean hasTraceListeners() {
        return this.m_traceListeners != null;
    }

    public void removeTraceListener(TraceListener tl) {
        if (this.m_traceListeners != null) {
            this.m_traceListeners.removeElement(tl);
        }
    }
}

