/*
 * Decompiled with CFR 0.152.
 */
package javak.zs;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.ResultSet;
import javak.exception.ZSjavakException;
import javak.iface.zs.I_DBZS;
import javak.iface.zs.I_DBZSInfo;
import javak.iface.zs.I_ResultSet;
import javak.iface.zs.I_ZSFactory;
import javak.iface.zs.I_ZSFactoryRMI;
import javak.zs.DBjavakMetaInfo;
import javak.zs.DBjavakResultSet;
import javak.zs.DBjavakZugriff;
import javak.zs.ZSAssert;

public class DBjavakFactory
extends UnicastRemoteObject
implements I_ZSFactory,
I_ZSFactoryRMI {
    public static final String REGNAMERMI = "DBjavakFactory";
    private static String codebase = "";

    public static void setCodebase(String string) throws ZSjavakException {
        ZSAssert.assert(string != null, "String invalid (null)");
        codebase = string;
    }

    public static String getCodebase() {
        return codebase;
    }

    public DBjavakFactory() throws RemoteException {
    }

    public DBjavakFactory(String string) throws RemoteException {
        if (string == null) {
            string = "";
        }
        codebase = string;
    }

    public I_ResultSet i_resultset(ResultSet resultSet) throws ZSjavakException {
        try {
            return new DBjavakResultSet(resultSet);
        }
        catch (ZSjavakException zSjavakException) {
            throw zSjavakException;
        }
        catch (Exception exception) {
            throw new ZSjavakException(exception, "Error at creation of an I_ResultSet in factory");
        }
    }

    public I_DBZS i_dbzs(boolean bl) throws RemoteException, ZSjavakException {
        if (!codebase.equals("")) {
            try {
                I_ZSFactoryRMI i_ZSFactoryRMI = this.getRMIFactory();
                return i_ZSFactoryRMI.i_dbzs();
            }
            catch (ZSjavakException zSjavakException) {
                throw new ZSjavakException(zSjavakException, "Error on Server " + codebase + " !!");
            }
            catch (RemoteException remoteException) {
                throw new ZSjavakException(remoteException, "RemoteException: Error with codebase " + codebase + " !!");
            }
            catch (Exception exception) {
                throw new ZSjavakException(exception, "Error occured on server " + codebase + " !!");
            }
        }
        return new DBjavakZugriff(this, bl);
    }

    public I_DBZS i_dbzs() throws RemoteException, ZSjavakException {
        return this.i_dbzs(true);
    }

    public I_DBZSInfo i_dbzsInfo(Connection connection) throws ZSjavakException {
        try {
            return new DBjavakMetaInfo(connection, this);
        }
        catch (ZSjavakException zSjavakException) {
            throw zSjavakException;
        }
        catch (Exception exception) {
            throw new ZSjavakException(exception, "Error at creation of I_DBZSInfo in Factory");
        }
    }

    private I_ZSFactoryRMI getRMIFactory() throws RemoteException, MalformedURLException, NotBoundException, ZSjavakException {
        return (I_ZSFactoryRMI)Naming.lookup("//" + codebase + "/" + REGNAMERMI);
    }

    public static void main(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        try {
            DBjavakFactory dBjavakFactory = new DBjavakFactory();
            Naming.rebind(REGNAMERMI, dBjavakFactory);
            System.out.println("RMIServer-object is registered with name 'DBjavakFactory' !!");
        }
        catch (Exception exception) {
            System.out.println("RMIServer-Error: " + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

