/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.sqlBuilder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Vector;
import javak.bo.ModelAttribute;
import javak.bo.ModelTable;
import javak.bo.sqlBuilder.ViewAttributeListEntryRenderer;
import javak.bo.sqlBuilder.ViewTableFrameManager;
import javak.bo.sqlBuilder.sqlBuilderController;
import javak.exception.BOjavakException;
import javak.iface.bo.I_BOSetText;
import javak.iface.bo.I_TableData;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

class ViewTableFrame
extends JInternalFrame {
    private JList attributes = null;
    private ViewTableFrameManager containerManager = null;
    private int markedIndex = 0;
    private int maxHeight = 0;
    private ModelTable myTable = null;
    private Vector metaListeners = null;

    private ViewTableFrame getSelfReference() {
        return this;
    }

    public ModelTable getModelTable() {
        return this.myTable;
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        if (bl) {
            this.containerManager.setLastActiveFrame(this);
        }
        super.setSelected(bl);
    }

    public ViewTableFrame(ModelTable modelTable, FontMetrics fontMetrics, ViewTableFrameManager viewTableFrameManager, sqlBuilderController sqlBuilderController2) {
        super(modelTable.getName(), true, true, false, false);
        this.containerManager = viewTableFrameManager;
        this.myTable = modelTable;
        this.metaListeners = new Vector(2, 2);
        Vector vector = modelTable.getAttributes();
        ViewAttributeListEntryRenderer viewAttributeListEntryRenderer = new ViewAttributeListEntryRenderer(sqlBuilderController2);
        this.attributes = new JList(vector);
        this.attributes.setCellRenderer(viewAttributeListEntryRenderer);
        this.attributes.setVisibleRowCount(vector.size());
        this.getContentPane().add((Component)this.attributes, "Center");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                try {
                    ViewTableFrame.this.getSelfReference().setSelected(true);
                }
                catch (Exception exception) {
                    ViewTableFrame.this.containerManager.setErrorMsg(exception.getMessage());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = ViewTableFrame.this.attributes.locationToIndex(mouseEvent.getPoint());
                if (mouseEvent.getClickCount() == 2) {
                    try {
                        ViewTableFrame.this.containerManager.addTable(ViewTableFrame.this.myTable.getName(), ViewTableFrame.this.getAttrString(n), "", "", "");
                    }
                    catch (BOjavakException bOjavakException) {
                        ViewTableFrame.this.containerManager.setErrorMsg(bOjavakException.toString());
                    }
                } else if (mouseEvent.getClickCount() == 1) {
                    ViewTableFrame.this.fireMetainfoEvent((ModelAttribute)ViewTableFrame.this.attributes.getModel().getElementAt(n));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                ViewTableFrame.this.markedIndex = ViewTableFrame.this.attributes.locationToIndex(mouseEvent.getPoint());
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                ViewTableFrame.this.getSelfReference().getRootPane().getBounds(rectangle);
                int n = mouseEvent.getX() + rectangle.x + ViewTableFrame.this.getSelfReference().getX();
                int n2 = mouseEvent.getY() + rectangle.y + ViewTableFrame.this.getSelfReference().getY();
                ViewTableFrame.this.containerManager.delegateMouseReleased(mouseEvent, ViewTableFrame.this.getSelfReference(), ViewTableFrame.this.markedIndex, n, n2);
            }
        };
        this.attributes.addMouseListener(mouseAdapter);
        mouseAdapter = new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                ViewTableFrame.this.getSelfReference().getBounds(rectangle);
                int n = mouseEvent.getX() + ViewTableFrame.this.getSelfReference().getX();
                int n2 = mouseEvent.getY() + ViewTableFrame.this.getSelfReference().getY();
                if (n < rectangle.x || n > rectangle.x + rectangle.width || n2 < rectangle.y || n2 > rectangle.y + rectangle.height) {
                    ViewTableFrame.this.containerManager.deactivateFocus();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        AncestorListener ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                ViewTableFrame.this.containerManager.mouseReleasedAfterMoving();
            }
        };
        this.addAncestorListener(ancestorListener);
        InternalFrameListener internalFrameListener = new InternalFrameListener(){

            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            }

            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                ViewTableFrame.this.fireMetainfoEvent(ViewTableFrame.this.myTable);
            }

            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                ViewTableFrame.this.attributes.clearSelection();
            }

            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                ViewTableFrame.this.containerManager.setLastActiveFrame(null);
                ViewTableFrame.this.containerManager.removeAttrContainer(ViewTableFrame.this.getSelfReference());
                ViewTableFrame.this.containerManager.mouseReleasedAfterMoving();
            }
        };
        this.addInternalFrameListener(internalFrameListener);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                try {
                    ViewTableFrame.this.getSelfReference().setSelected(true);
                }
                catch (Exception exception) {
                    ViewTableFrame.this.containerManager.setErrorMsg(exception.getMessage());
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                ViewTableFrame.this.getSelfReference().getRootPane().getBounds(rectangle);
                ViewTableFrame.this.getSelfReference().setSize(rectangle.width, ViewTableFrame.this.maxHeight);
            }
        };
        this.addMouseMotionListener(mouseMotionAdapter);
        mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                ViewTableFrame.this.setMarkedIndex(ViewTableFrame.this.markedIndex);
                if (ViewTableFrame.this.containerManager.getNrOfElements() < 2) {
                    return;
                }
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                ViewTableFrame.this.getSelfReference().getRootPane().getBounds(rectangle);
                int n = mouseEvent.getX() + rectangle.x + ViewTableFrame.this.getSelfReference().getX();
                int n2 = mouseEvent.getY() + rectangle.y + ViewTableFrame.this.getSelfReference().getY();
                ViewTableFrame.this.containerManager.drawMovingMouse(mouseEvent, ViewTableFrame.this.getSelfReference(), ViewTableFrame.this.markedIndex, n, n2);
            }
        };
        this.attributes.addMouseMotionListener(mouseMotionAdapter);
        JMenuItem jMenuItem = new JMenuItem("Remove table from view");
        JPopupMenu jPopupMenu = new JPopupMenu(modelTable.getName());
        jPopupMenu.add(jMenuItem);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Remove table from view")) {
                    ViewTableFrame.this.containerManager.removeAttrContainer(ViewTableFrame.this.getSelfReference());
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.pack();
        Dimension dimension = this.getPreferredSize();
        int n = this.calcMinimumTitleWidth(modelTable.getName(), fontMetrics);
        if (n > dimension.width) {
            dimension.width = n;
        }
        this.maxHeight = dimension.height;
        this.setSize(dimension);
        this.setVisible(true);
    }

    public int getRelationPaintY(int n) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        this.getSelfReference().getRootPane().getBounds(rectangle);
        Component component = this.attributes.getCellRenderer().getListCellRendererComponent(this.attributes, this.attributes.getModel().getElementAt(n), n, false, false);
        return this.getY() + rectangle.y + this.attributes.indexToLocation((int)n).y + component.getMaximumSize().height / 2;
    }

    public int getRelationPaintX(int n) {
        int n2;
        int n3 = this.getX();
        if (n >= n3 + (n2 = this.getWidth()) / 2) {
            return n3 + n2;
        }
        return n3;
    }

    public int getClickedAttrIdx(int n, int n2) {
        return this.attributes.locationToIndex(new Point(n, n2));
    }

    public int getMarkedAttrIdx() {
        return this.attributes.getSelectedIndex();
    }

    public String getAttrString(int n) {
        return ((ModelAttribute)this.attributes.getModel().getElementAt(n)).getName();
    }

    public int getAttrIndex(String string) {
        int n = this.attributes.getModel().getSize();
        int n2 = 0;
        while (n2 < n) {
            if (this.getAttrString(n2).equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setMarkedIndex(int n) {
        this.attributes.setSelectedIndex(n);
    }

    private int calcMinimumTitleWidth(String string, FontMetrics fontMetrics) {
        int n = fontMetrics.stringWidth(string);
        return n + 75;
    }

    public void addMetaInfoListener(I_BOSetText i_BOSetText) {
        if (i_BOSetText != null && !this.metaListeners.contains(i_BOSetText)) {
            this.metaListeners.add(i_BOSetText);
        }
    }

    public void removeMetaInfoListener(I_BOSetText i_BOSetText) {
        this.metaListeners.remove(i_BOSetText);
    }

    public void fireMetainfoEvent(I_TableData i_TableData) {
        Enumeration enumeration = this.metaListeners.elements();
        while (enumeration.hasMoreElements()) {
            I_BOSetText i_BOSetText = (I_BOSetText)enumeration.nextElement();
            try {
                i_BOSetText.boSetText(i_TableData);
            }
            catch (BOjavakException bOjavakException) {
                // empty catch block
            }
        }
    }
}

