<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>

<% PageUtils.setSkipTrialPeriodExpireCheck(true,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>

<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%
boolean isPopup=(controller.getParamAsBoolean("isPopup"));

InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
SessionInfo sessionInfo=controller.getSessionInfo();
String username=controller.getParam("username");
String password=controller.getParam("password");

String requiredUserTypeForLogin=PageUtils.nonNull(sessionInfo.getRequiredUserTypeForLogin()).trim().toLowerCase();

User user=Manager.selectUserByUsername(username);
if (user==null || !(user.getPassword().equals(password)))
{
	// bad username or password:
	controller.redirect("login.jsp?isPopup="+(isPopup?"true":"false")+"&errorCode=1&username="+URLEncoder.encode(username));
}
else if (requiredUserTypeForLogin.equals("superuser") && !user.isSuperUser())
{
	// valid authentication info but wrong privileges:
	controller.redirect("login.jsp?isPopup="+(isPopup?"true":"false")+"&errorCode=2&username="+URLEncoder.encode(username));
}
else if (!user.isActive())
{
	// User found, but is not active; inactive users cannot log in:
	controller.redirect("login.jsp?isPopup="+(isPopup?"true":"false")+"&errorCode=3&username="+URLEncoder.encode(username));
}
else
{
	// successful login (but check for secret question/answer -- either way, we'll log the user in, since q/ans is not strictly reqd):
	String redirectUrl;
	if (user.getSecretAnswer()==null || user.getSecretAnswer().trim().length()==0)
	{
		redirectUrl="loginSecretQuestion.jsp?isPopup="+(isPopup?"true":"false");
	}
	else
	{
		redirectUrl=PageUtils.nonNull(sessionInfo.getPostLoginDestinationUrl());
	}
	PageUtils.loginUser(user, controller);
	if (redirectUrl.length()==0)
	{
		// ...then user hit the login page directly rather than being redirected to
		// it from a login-required page, so just send them to a "you're logged in"
		// page:
		redirectUrl="loginConfirm.jsp?isPopup="+(isPopup?"true":"false");
	}
	controller.redirect(redirectUrl);
	
}


%>



<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

