<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String mode=controller.getParam("mode"); // "add" or "edit"
boolean success=controller.getParamAsBoolean("success",true);



ArrayList allInstances=Manager.selectAllInstances();
if (allInstances==null)
{
	allInstances=new ArrayList();
}
String[] names=new String[allInstances.size()];
String[] rootUrls=new String[allInstances.size()];
int[] ids=new int[allInstances.size()];

int numRootUrls=0;

for (int i=0; i<allInstances.size(); i++)
{
	Instance instance=(Instance)allInstances.get(i);
	names[i]=instance.getName();
	rootUrls[i]=instance.getRootUrl();
	if (rootUrls[i]!=null && rootUrls[i].trim().length()>0)
	{
		numRootUrls++;
	}
	ids[i]=instance.getId();
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>

<script language="JavaScript">

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
<span class=standardTextBlockWidth>
<form>
<font class=bodyFont>


<%
if (success)
{
String urlReminder="";
	if (numRootUrls>0)
	{
		urlReminder=" You may want to test the root urls you've entered by clicking on them; urls will launch in a seperate window. ";
	}
	if (mode.equals("edit"))
	{
		%>
		<span class=firstSentenceFont>Your changes have been made.</span> The current set of instances appears below. <%=urlReminder%> You may now:

		<ul>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="instances.jsp">make more instance changes</a>
		<li><a href="addInstances.jsp">add instances</a>
		<%=HtmlUtils.doubleLB(request)%>
		</ul>
		<%
	}
	if (mode.equals("add"))
	{
		%>
		<span class=firstSentenceFont>Your additions have been made.</span> The current set of instances appears below.  <%=urlReminder%> <i>Note: each of the instances you've just added is now associated with all projects.  If you want to dissociate instances from projects, you must do that on the project-admin page.</i> You may now:

		<ul>
		<li><A href="projects.jsp">dissociate instances from projects on the project-admin page</a>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="addInstances.jsp">add more instances</a>
		<li><a href="instances.jsp">make instance changes</a>

		<%=HtmlUtils.doubleLB(request)%>
		</ul>
		<%
	}
}
else
{
	%>
	<span class=firstSentenceFont>There was a problem.</span> Some or all of your data may not have been saved. The current list of instances is below.  You may now:

		<ul>
		<li><A href="../feedback/compose.jsp">report the problem you just experienced</a>
		<li><A href="menu.jsp">return to the global admin menu</a>
		<li><a href="addInstances.jsp">add more instances</a>
		<li><a href="instances.jsp">make instance changes</a>

		<%=HtmlUtils.doubleLB(request)%>
		</ul>

	<%
}
%>

<table border=0 cellspacing=0 cellpadding=0 width=350> 
<%@ include file="instancesTableHeaderRow.jsp" %>
 
<% 

for (int i=0; i<names.length; i++)
{
	%>
	<input type=hidden name=id<%=i%> id=id<%=i%> value="<%=ids[i]%>">
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=22>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<%=names[i]%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<%=HtmlUtils.getLink(rootUrls[i])%>&nbsp;&nbsp;&nbsp;<BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr>
	<%=HtmlUtils.getHorizRuleTr(4, request)%>
	<%
}

%>

</table><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form></span>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

