<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>

<% PageUtils.forceNoCache(response); %>


<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>

<%@ page import="com.workroll.app.util.*" %>
 

<% PageUtils.setRequiredLoginStatus("none",request); %>

<% PageUtils.setPathToAppRoot("../../",request); %>

<% PageUtils.setSection(WorkRollConstants.SECTION_INSTALL,request); %>

<%@ include file="../../global/installTopInclude.jsp" %>



<%
String databasePath=controller.getParam("dbPath");
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../../global/headInclude.jsp" %>

<%@ include file="../../global/validationJs.jsp" %>

<script language="JavaScript">

var databasePath="<%
out.print(GeneralUtils.stringReplace(databasePath,'\\',"\\\\"));
%>"

if (databasePath.length>0)
{
	generalAlert("The database has been created in \""+databasePath+"\".  Please click OK to continue.")
}

function isValidForm(formObj)
{
	var els=formObj.elements

	if (trim(els["fullname"].value).length==0)
	{
		errorAlert("You have not entered a full name; please fix and try again.",els["fullname"])
		return false
	}
	if (trim(els["username"].value).length==0)
	{
		errorAlert("You have not entered a username; please fix and try again.",els["username"])
		return false
	}
	if (trim(els["password"].value).length==0)
	{
		errorAlert("You have not entered a password; please fix and try again.",els["password"].value)
		return false
	}
	if (trim(els["retypepassword"].value).length==0)
	{
		errorAlert("You have not retyped the password you entered; please fix and try again.",els["retypepassword"])
		return false
	}
	if (trim(els["email"].value).length==0)
	{
		errorAlert("You have not entered an e-mail address; this address will only be shared with other users of your WorkRoll installation.  Please fix and try again.",els["password"].value)
		return false
	}
	if (trim(els["secretAnswer"].value).length==0)
	{
		errorAlert("You have not entered an answer to the secret question you chose.  Please fix and try again.",els["password"].value)
		return false
	}

	if (radioGroupValue(formObj,"agreeToTerms")!="true")
	{
		errorAlert("You have not indicated that you agree to the terms of use agreement by checking the \"yes\" button following the agreement text.  You cannot proceed without agreeing to these terms. If you agree to the terms, please check the \"yes\" button and try again.")
		return false
	}
	
	// we now have all fields completed that need to be; now check for invalid entries:
	if (!isValidUsername(trim(els["username"].value)))
	{
		errorAlert("The username \""+trim(els["username"].value)+"\" is not valid; usernames may contain only letters, numbers, underscores, dashes, and periods, and must be between "+USERNAME_MIN_LENGTH+" and "+USERNAME_MAX_LENGTH+" characters long. Please fix and try again.",els["username"])
		return false
	}
	if (trim(els["email"].value).length>0 && !isValidEmail(trim(els["email"].value)))
	{
		errorAlert("The e-mail address you have entered is not valid.  Please fix and try again.  \"myname@mycompany.com\" is an example of a valid e-mail address.",els["email"].value)
		return false
	}
	
	if (""+trim(els["password"].value)!=""+trim(els["retypepassword"].value))
	{
		errorAlert("The password you have entered does not match what you entered in the \"Retype the password\" box; please fix and try again.",els["password"])
		return false
	}
	if (!isValidPassword(trim(els["password"].value)))
	{
		errorAlert("The password \""+trim(els["password"].value)+"\" is not valid; passwords may contain only letters, numbers, underscores, dashes, and periods, and must be between "+PASSWORD_MIN_LENGTH+" and "+PASSWORD_MAX_LENGTH+" characters long. Please fix and try again.",els["password"])
		return false
	}

	
	
	hidePageAndShowPleaseWait()
	
	return true
}


<% pageContext.include("../js/js.jsp"); %>


</script>

<style type="text/css">

</style>
</head>

<%@ include file="../../global/bodyOpen.jsp" %>

<div id=mainDiv>

<font class=bodyFont>
<%@ include file="helpInclude.jsp" %>
</font>
<BR>


<span class=standardTextBlockWidth>

<form method=post action=createSuperuser.jsp name=mainForm id=mainForm onsubmit="return isValidForm(this)">
<font class=bodyFont><span class=firstSentenceFont>Now we'll create an administrator account for you,</span>  and also make you the primary contact for other users of your WorkRoll installation.  An "administrator" is a user who has access access to WorkRoll functions that "regular" users do not (such as the ability to create other user accounts). The "primary contact" is an admistrator whose name and e-mail address appear on certain WorkRoll screens in case other users need to perform administrator-only tasks.<BR><BR>

If you are setting up this application but won't ultimately play an administrator role or the "primary contact" role, that's okay; you can change your account settings later (also, more than one user can be an admiinistrator).<BR><BR>

Please enter the following information, then and press "continue":<BR>
<BR>
<span class=boldishFont>Your full name</span> (for example, <i>John Smith</i>):<BR>
<input class=inputText type=text size=40 name=fullname id=fullname><%=HtmlUtils.doubleLB(request)%>
 
<span class=boldishFont>Your e-mail address</span>:<BR>
<input class=inputText type=text size=40 name=email id=email><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Choose a username</span> (for example, <i>jsmith</i>):<BR>
<input class=inputText type=text size=16 name=username id=username><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Choose a password</span>:<BR>
<input class=inputText type=password size=16 maxlength=16 name=password id=password><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Re-type the password:</span><BR>
<input class=inputText type=password size=16 maxlength=16 name=retypepassword id=retypepassword><%=HtmlUtils.doubleLB(request)%>


<span class=boldishFont>Choose a secret question</span> (for if you forget your password)<BR>
<select class=selectText style="width:310px;" name=secretQuestion id=secretQuestion>
<%

for (int i=0; i<WorkRollConstants.SECRET_QUESTION_LABELS.length; i++)
{
	%>
	<option value="<%
	out.print(WorkRollConstants.SECRET_QUESTION_VALUES[i]);
	%>"><%
	out.print(WorkRollConstants.SECRET_QUESTION_LABELS[i]);
	%></option>
	<%
}
%>
</select><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont>Answer to secret question</span> (Note: If you lose your password, you will need to remember <I>exactly</I> what you typed here to get it back; you will also not be able to change this field once you submit this page.)<BR>
<input type=text class=inputText name=secretAnswer id=secretAnswer value="" size=16><%=HtmlUtils.doubleLB(request)%>

<span class=boldishFont><input type=checkbox name=dropUserCookie id=dropUserCookieTrue value=true id=dropUserCookieTrue><label for="dropUserCookieTrue">Remember me on this computer</label></span><BR>
<BR>

<BR>
<span class=boldishFont>"Registered-to" name</span> (optional: if you choose to purchase WorkRoll, this person's or company's name will appear at the top of every screen, for example, <i>John Smith</i> or <i>AAA Amalgamated, Inc.</i>; you may enter a value here whether or not you have purchased WorkRoll):<BR>
<input class=inputText type=text size=40 name=companyName id=companyName><%=HtmlUtils.doubleLB(request)%>
       

<BR>
 
<span class=boldishFont>Terms of use:</span> please read the following terms of use agreement...<BR>
<textarea class=textareaText name=termsText id=termsText rows=8 cols=70 readonly=true>WORKROLL.COM (HEREINAFTER "WORKROLL") WILL ALLOW YOU TO USE THE WORKROLL WEB-BASED ISSUE-TRACKING APPLICATION (THE "SOFTWARE") TO YOU ONLY ON THE CONDITION THAT YOU ACCEPT ALL OF THE TERMS IN THIS AGREEMENT. PLEASE READ THE TERMS CAREFULLY.

1. LICENSE. WorkRoll hereby grants you a nonexclusive license to install and use the Software for a free trial period, and then on one server PER LICENSE PURCHASED. You may copy the Software for backup purposes, provided that you reproduce all copyright and other proprietary notices that are on the original copy of the Software.

2. RESTRICTIONS. WorkRoll retains all right, title, and interest in and to the Software, and any rights not granted to you herein are reserved by WorkRoll. Any attempt to transfer any of the rights, duties or obligations hereunder is void. You may not rent, lease, loan, or resell the Software, or any part thereof. You may not reproduce, distribute, publicly perform or publicly display the Software except as expressly permitted under Section 1, and you may not create derivative works of the Software. You may not make the Software available for download to anyone else on any computer system or network. You may not reverse-engineer or otherwise modify the code-level operation of this Software.

3. NO WARRANTY. THE SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY WARRANTY OR CONDITION, WHETHER EXPRESS, IMPLIED OR STATUTORY. Some jurisdictions do not allow the disclaimer of implied warranties, so the foregoing disclaimer may not apply to you. This warranty gives you specific legal rights and you may also have other legal rights.

4. LIMITATION OF LIABILITY. IN NO EVENT WILL WORKROLL OR ITS SUPPLIERS BE LIABLE FOR ANY LOST PROFITS OR OTHER CONSEQUENTIAL, INCIDENTAL OR SPECIAL DAMAGES (HOWEVER ARISING, INCLUDING NEGLIGENCE) IN CONNECTION WITH THE SOFTWARE OR THIS AGREEMENT, EVEN IF WORKROLL HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. Some jurisdictions do not allow the foregoing limitations of liability, so the foregoing limitations may not apply to you.

5. TERM AND TERMINATION. This Agreement shall continue until terminated. You may terminate the Agreement at any time by deleting all copies of the Software. This license terminates automatically if you violate any terms of the Agreement. Upon termination you must promptly delete all copies of the Software. The sections "RESTRICTIONS," "NO WARRANTY," "LIMITATION OF LIABILITY," "INDEMNITY," and "GENERAL" shall survive termination.

6. INDEMNITY. You agree to defend and indemnify WorkRoll against all claims, losses, liabilities, damages, costs and expenses, including attorney's fees, which WorkRoll may incur in connection with your breach of this Agreement.

7. GENERAL. The Software is a "commercial item." This Agreement is governed and interpreted in accordance with the laws of the State of New York without giving effect to its conflict of laws provisions. The United Nations Convention on Contracts for the International Sale of Goods is expressly disclaimed. Any claim arising out of or related to this Agreement must be brought exclusively in a federal or state court located in Kings County, New York and you consent to the jurisdiction of such courts. If any provision of this Agreement shall be invalid, the validity of the remaining provisions of this Agreement shall not be affected. This Agreement is the entire and exclusive agreement between WorkRoll and you with respect to the Software and supersedes all prior agreements (whether written or oral) and other communications between WorkRoll and you with respect to the Software.
</textarea><BR>
...and click "yes" below if you accept these terms.<%=HtmlUtils.doubleLB(request)%>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;I agree to the above terms: <%=HtmlUtils.getYesNoRadios(false,"agreeToTerms")%><BR><BR>


<BR>
<input  class=formButton type=submit value="continue"> <%=HtmlUtils.doubleLB(request)%>


<br>





<%@ include file="helpInclude.jsp" %>



</font>

</form></span>
</div>

<%@ include file="../../global/bodyClose.jsp" %>

</html>


<%@ include file="../../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>







