<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>


<%@ page import="java.net.*" %>
<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.db.Manager" %>
<%@ page import="com.workroll.app.mail.Mailer" %>
<%@ page import="com.workroll.app.util.PageUtils" %>
<%@ page import="com.workroll.app.filesystem.FileSystem" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>


<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_INSTALL,request); %>


<%@ include file="../../global/installTopInclude.jsp" %>

<%!

%>

<%


String smtpHost=controller.getParam("smtpHost");
String smtpUsername=controller.getParam("smtpUsername");
String smtpPassword=controller.getParam("smtpPassword");
int smtpPort=Integer.parseInt(controller.getParam("smtpPort",""+WorkRollConstants.DEFAULT_SMTP_PORT));
String testAddr=controller.getParam("testAddr");
String initialNotificationPrefix=controller.getParam("initialNotificationPrefix");
String changeNotificationPrefix=controller.getParam("changeNotificationPrefix");
String reminderPrefix=controller.getParam("reminderPrefix");


int successCode=Mailer.sendTestMessage(smtpHost, smtpUsername, smtpPassword, smtpPort, testAddr);

if (successCode==Mailer.SUCCESS)
{
	InstallationConfig installationConfig=controller.getCurrentInstallationConfig();
	installationConfig.setMailSubjectPrefixInitialNotification(initialNotificationPrefix);
	installationConfig.setMailSubjectPrefixChangeNotification(changeNotificationPrefix);
	installationConfig.setMailSubjectPrefixReminder(reminderPrefix);
	installationConfig.setDoNotifications(true);
	installationConfig.setSmtpHost(smtpHost);
	installationConfig.setSmtpUsername(smtpUsername);
	installationConfig.setSmtpPassword(smtpPassword);
	installationConfig.setSmtpPort(smtpPort);
	installationConfig.setInstallTimeInMillis(new Date().getTime()); // trial starts now (if field not already set; setter method checks).
	installationConfig.setAgreementRead(true); // if we got here, we assume this
	installationConfig.setInitialConfigurationComplete(true);
	controller.storeInstallationConfig(installationConfig);

	controller.redirect("initialConfigFinished.jsp?testAddr="+URLEncoder.encode(testAddr));
}
else
{ 
	controller.redirect
	(
		"getMailConfig.jsp"
		+"?testAddr="+URLEncoder.encode(testAddr)
		+"&smtpUsername="+URLEncoder.encode(smtpUsername)
		+"&smtpHost="+URLEncoder.encode(smtpHost)
		+"&initialNotificationPrefix="+URLEncoder.encode(initialNotificationPrefix)
		+"&changeNotificationPrefix="+URLEncoder.encode(changeNotificationPrefix)
		+"&reminderPrefix="+URLEncoder.encode(reminderPrefix)
		+"&smtpPort="+smtpPort
		+"&successCode="+successCode
	);
}

%>


<%@ include file="../../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

