// ViewList.cpp : implementation file
//

#include "stdafx.h"
#include "WinExp.h"

#include "doc.h"
#include "ViewTree.h"
#include "ViewList.h"
#include "mainfrm.h"
#include <math.h> //pow

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CViewList

IMPLEMENT_DYNCREATE(CViewList, CListView)

BEGIN_MESSAGE_MAP(CViewList, CListView)
	//{{AFX_MSG_MAP(CViewList)
	ON_NOTIFY_REFLECT(LVN_KEYDOWN, OnKeydown)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDblclk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
CViewList::CViewList()
{
	m_sPath = "";
}

/////////////////////////////////////////////////////////////////////////////
CViewList::~CViewList()
{
}

/////////////////////////////////////////////////////////////////////////////
BOOL CViewList::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
/*
#define LVS_ICON                0x0000
#define LVS_REPORT              0x0001
#define LVS_SMALLICON           0x0002
#define LVS_LIST                0x0003
#define LVS_TYPEMASK            0x0003
*/
	DWORD dwListStyle = AfxGetApp()->GetProfileInt("WinExp", "ListStyle", LVS_ICON);
	if (dwListStyle <= LVS_TYPEMASK)
	{
		dwStyle	|= dwListStyle; // which mode
	}
	else
	{
		ASSERT(0);
	}
	if (dwListStyle == LVS_ICON)
	{
		dwStyle	|= LVS_ALIGNTOP; 
	}
	else
	{
		dwStyle	|= LVS_ALIGNLEFT; 
	}
	return CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
}

/////////////////////////////////////////////////////////////////////////////
BOOL CViewList::PreCreateWindow(CREATESTRUCT& cs) 
{
	return CListView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CViewList drawing

void CViewList::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
}

/////////////////////////////////////////////////////////////////////////////
// CViewList diagnostics

#ifdef _DEBUG
void CViewList::AssertValid() const
{
	CListView::AssertValid();
}

void CViewList::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}

CWinExpDoc* CViewList::GetDocument() // non-debug version is inline
{
	return STATIC_DOWNCAST(CWinExpDoc, m_pDocument);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CViewList message handlers

void CViewList::OnInitialUpdate() 
{
	CListView::OnInitialUpdate();
	
	// get list
	CListCtrl& cTheList = GetListCtrl();

	// get main win
	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
	ASSERT(pFWnd->m_pSmallImageList != NULL);
	ASSERT(pFWnd->m_pNormalImageList != NULL);

	// do the menu 
	DWORD dwStyle = ::GetWindowLong(cTheList.m_hWnd, GWL_STYLE); 
	DWORD dwMask = dwStyle & LVS_TYPEMASK;
	SetListTypeMenuCheck(dwMask);
	// make image list identical to tree's (not LVSIL_NORMAL unless ICON mode)
	if (dwMask == LVS_ICON)
	{
		cTheList.SetImageList(pFWnd->m_pNormalImageList, LVSIL_NORMAL);
	}
	else
	{
		cTheList.SetImageList(pFWnd->m_pSmallImageList, LVSIL_SMALL);
	}

	// build list columns
	CRect cr;
	GetClientRect(&cr);

	int nWidth = cr.Width()/4;

	// set up the grid column titles
	CString s;
	LV_COLUMN lvcol;
	lvcol.cx = nWidth;
	lvcol.mask = LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM;
	lvcol.fmt = LVCFMT_LEFT;
	lvcol.pszText = (LPSTR)"Name";
	lvcol.iSubItem = eItem;
	cTheList.InsertColumn(eItem, &lvcol);

	// second col
	lvcol.fmt = LVCFMT_RIGHT;
	lvcol.pszText = (LPSTR)"Size";
	lvcol.iSubItem = eSize;
	cTheList.InsertColumn(eSize, &lvcol);

	// third col
	lvcol.fmt = LVCFMT_LEFT;
	lvcol.pszText = (LPSTR)"Type";
	lvcol.iSubItem = eType;
	cTheList.InsertColumn(eType, &lvcol);

	// fourth col
	lvcol.pszText = (LPSTR)"Modified";
	lvcol.iSubItem = eModified;
	cTheList.InsertColumn(eModified, &lvcol);
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::OnKeydown(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;

	switch (pLVKeyDow->wVKey)
	{
	case 0xd: // return/enter
		{
			DrillDown();
			break;
		}
	case 0x74: // F5
		{
			RefreshList();
			break;
		}
	case 0x9: // tab
		{
			CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
			CViewTree * pTreeView = (CViewTree*)pFWnd->m_wndSplitter.GetPane(PANE_ROW_ZERO, eTreeWinPane);
			ASSERT(pTreeView != NULL);
			pTreeView->SetFocus();
			break;
		}
	default :
		{
			break;
		}
	}
	
	*pResult = 0;
}


/////////////////////////////////////////////////////////////////////////////
void CViewList::OnDblclk(NMHDR* pNMHDR, LRESULT* pResult) 
{
	DrillDown();
	
	*pResult = 0;
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::DrillDown(void)
{
	CListCtrl& cTheList = GetListCtrl();

	POSITION pos = cTheList.GetFirstSelectedItemPosition();
	if (pos != NULL)
	{
		int nItem = cTheList.GetNextSelectedItem(pos);
		if (nItem >= 0 && nItem < cTheList.GetItemCount())
		{
			CString sFolder = cTheList.GetItemText(nItem, 0);
			CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
			CViewTree * pTreeView = (CViewTree*)pFWnd->m_wndSplitter.GetPane(PANE_ROW_ZERO, eTreeWinPane);
			ASSERT(pTreeView != NULL);
			pTreeView->FillFromTreeSelect(sFolder);
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::RefreshList(void)
{
	if (m_sPath.GetLength())
	{
		FillList(m_sPath);
	}
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::AdjustStyle(DWORD dwNewStyle)
{
	CListCtrl& cTheList = GetListCtrl();

	// You can use the LVS_TYPEMASK mask to isolate 
	//	the window styles that correspond to the current view: 
	//	LVS_ICON, LVS_SMALLICON, LVS_LIST, and LVS_REPORT. 
	//	MSDN - Using List View Controls

	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();

	DWORD dwNewAlignFlag; 
	DWORD dwNewAlignStyle; 
	switch(dwNewStyle)
	{
	case LVS_ICON:
		{
			dwNewAlignStyle = LVS_ALIGNTOP;
			dwNewAlignFlag = LVA_ALIGNTOP;
			cTheList.SetImageList(pFWnd->m_pNormalImageList, LVSIL_NORMAL);
			break;
		}
	case LVS_REPORT:
	case LVS_LIST:
		{
			dwNewAlignStyle = LVS_ALIGNLEFT;
			dwNewAlignFlag = LVA_ALIGNLEFT; 
			cTheList.SetImageList(pFWnd->m_pSmallImageList, LVSIL_SMALL);
			break;
		}
	case LVS_SMALLICON:
		{
			dwNewAlignStyle = LVS_ALIGNTOP;
			dwNewAlignFlag = LVA_ALIGNTOP; 
			cTheList.SetImageList(pFWnd->m_pSmallImageList, LVSIL_SMALL);
			break;
		}
	default :
		{
			ASSERT(0);
			break;
		}
	}

	DWORD dwOldStyle = ::GetWindowLong(cTheList.m_hWnd, GWL_STYLE); 
	DWORD dwOldStyleMasked = dwOldStyle & LVS_TYPEMASK;
	if (dwOldStyleMasked != dwNewStyle)
	{
		if (dwOldStyleMasked == LVS_REPORT)
		{
			SaveColumnWidths();
		}

		dwOldStyle &= ~LVS_ALIGNMASK;
		dwOldStyle &= ~LVS_TYPEMASK;
        ::SetWindowLong(cTheList.m_hWnd, GWL_STYLE, 
						dwOldStyle | dwNewStyle | dwNewAlignStyle);
		// not sure why I need this if() but I do
		if (dwNewStyle != LVS_REPORT && dwNewStyle != LVS_LIST)
		{
/*
#define LVS_ALIGNTOP            0x0000
#define LVS_ALIGNLEFT           0x0800
#define LVS_ALIGNMASK           0x0c00

#define LVA_DEFAULT             0x0000
#define LVA_ALIGNLEFT           0x0001
#define LVA_ALIGNTOP            0x0002
#define LVA_SNAPTOGRID          0x0005
*/
			BOOL b = cTheList.Arrange(dwNewAlignFlag);
			ASSERT(b);
		}
		// do the menu for the display limiting
		SetListTypeMenuCheck(dwNewStyle);
	} 
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::SaveColumnWidths(void)
{
	// for the interested student
}

/////////////////////////////////////////////////////////////////////////////
// note the trick
void CViewList::SetListTypeMenuCheck(DWORD dwNewStyle)
{
/*
#define LVS_ICON			0x0000
#define LVS_REPORT			0x0001
#define LVS_SMALLICON		0x0002
#define LVS_LIST			0x0003
#define LVS_TYPEMASK		0x0003

#define ID_LARGE_ICONS		32790
#define ID_DETAILS			32791
#define ID_SMALL_ICONS		32792
#define ID_LIST				32793
*/
	ASSERT((ID_LARGE_ICONS%10) == 0);
	ASSERT(dwNewStyle >= LVS_ICON && dwNewStyle <= LVS_LIST);
	CMenu * pMenu = AfxGetMainWnd()->GetMenu();
	pMenu->CheckMenuItem(  ID_LARGE_ICONS, 
					MF_BYCOMMAND|MF_UNCHECKED );
	pMenu->CheckMenuItem(  ID_DETAILS, 
					MF_BYCOMMAND|MF_UNCHECKED );
	pMenu->CheckMenuItem(  ID_SMALL_ICONS, 
					MF_BYCOMMAND|MF_UNCHECKED );
	pMenu->CheckMenuItem(  ID_LIST, 
					MF_BYCOMMAND|MF_UNCHECKED );
	pMenu->CheckMenuItem(  ID_LARGE_ICONS + dwNewStyle, // <---------- trick
					MF_BYCOMMAND|MF_CHECKED );
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::FillList(CString sPath)
{
	CListCtrl& cTheList = GetListCtrl();

	// I am going to re-fill the list, so reset it now
	EmptyListAndPath();

	FillListWithFolders(sPath);
	FillListWithFiles(sPath);
	m_sPath = sPath;
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::FillListWithFolders(CString sPath)
{
	//prep a structure for the list
	LV_ITEM lvitem;
	// text and image
	lvitem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
	// must be zero for the 0th column
	lvitem.iSubItem = 0;
	// file param
	lvitem.lParam = eLPFolder;
	// fill in pszText, iItem and iImage later 

	CPtrList pList; // name of sub directories filled by FindSubs
	// get main win
	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
	pFWnd->FindSubItems(sPath, &pList, FILE_ATTRIBUTE_DIRECTORY);
	SortByAlpha(&pList);
	CListCtrl& cTheList = GetListCtrl();
	
	int i = 0;
	while (pList.GetCount())
	{
		// make list entry

		SUBITEM * pItem = (SUBITEM *)pList.GetHead();
		// form the list control structure
		// text 
		lvitem.pszText = (LPSTR)pItem->szName;
		// point to the row number
		lvitem.iItem = i;	  
		// image 
		lvitem.iImage = IDI_FOLDCLS - IDI_REMOVE;
		// do the insert
		int nRet = cTheList.InsertItem(&lvitem); 
		// a check
		ASSERT(nRet != -1);

		// fill other columns with stuff

		// do col 1
		BOOL bRet = cTheList.SetItemText(nRet, eSize, "");	 
		ASSERT(bRet);

		// do col 2
		bRet = cTheList.SetItemText(nRet, eType, "File Folder");	 
		ASSERT(bRet);

		// do col 3
		FILETIME ft;
		ft.dwHighDateTime = pItem->dwHighDateTime;
		ft.dwLowDateTime = pItem->dwLowDateTime;
		CString sTime = MakeModifiedString(ft);
		bRet = cTheList.SetItemText(nRet, eModified, sTime);	 
		ASSERT(bRet);

		delete pItem;
		pList.RemoveHead();
		i++;
	}
}

/////////////////////////////////////////////////////////////////////////////
CString CViewList::MakeModifiedString(FILETIME ft)
{
	FILETIME ftLocal;
	::FileTimeToLocalFileTime(&ft, &ftLocal);
	SYSTEMTIME st;
	::FileTimeToSystemTime(&ftLocal, &st);
	CString sTime;
	CString sAMPM = "AM";
	if (st.wHour > 11)
	{
	sAMPM = "PM";
	if (st.wHour > 12)
	{
	st.wHour -= 12;
	}
	}
	sTime.Format("%.2d/%.2d/%.4d %d:%.2d %s",
		st.wMonth, st.wDay, st.wYear, st.wHour, st.wMinute, sAMPM);
	return sTime;
} 

/////////////////////////////////////////////////////////////////////////////
// assume the path passed in does NOT have trailing slash
void CViewList::FillListWithFiles(CString sPath) 
{
	if (sPath.GetLength() == 0)
	{
		return;// will get here on initial tree build
	}

	CPtrList pList; // name of sub directories filled by FindSubs
	CMainFrame * pFWnd = (CMainFrame *)AfxGetMainWnd();
	pFWnd->FindSubItems(sPath, &pList, 0);
	SortByAlpha(&pList);
	CListCtrl& cTheList = GetListCtrl();

	while (pList.GetCount())
	{
		SUBITEM * pItem = (SUBITEM *)pList.GetHead();

		//prep a structure for the list
		LV_ITEM lvitem;
		// text and image
		lvitem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		// must be zero for the 0th column
		lvitem.iSubItem = 0;
		// file param
		lvitem.lParam = eLPFile;
		// file icon
		lvitem.iImage = IDI_DOC-IDI_REMOVE;
		// file icon
		lvitem.iItem = cTheList.GetItemCount();
		// fill in pszText
		lvitem.pszText = (LPSTR)pItem->szName;

		int nRet = cTheList.InsertItem(&lvitem); 
		// a check
		ASSERT(nRet != -1);

		// fill other columns with stuff

		// do col 1
		int nHi = pItem->nFileSizeHigh;
		int nLo = pItem->nFileSizeLow;
		double fHi = nHi;
		double fLo = nLo;
		double fTotal = fHi * pow(2,32) + fLo;
		fTotal /= 1024;
		CString sNum = MakePrettyNumber(fTotal);
		BOOL bRet = cTheList.SetItemText(nRet, eSize, sNum);
		ASSERT(bRet);

		// do col 2
		CString sName = pItem->szName;
		int nFind = sName.Find('.');
		if (nFind != -1)
		{
			sName = sName.Right(sName.GetLength() - nFind - 1);
			sName.MakeUpper();
			sName += " File";
		}
		else
		{
			sName = "File";
		}
		bRet = cTheList.SetItemText(nRet, eType, sName);
		ASSERT(bRet);

		// do col 3
		FILETIME ft;
		ft.dwHighDateTime = pItem->dwHighDateTime;
		ft.dwLowDateTime = pItem->dwLowDateTime;
		CString sTime = MakeModifiedString(ft);
		bRet = cTheList.SetItemText(nRet, eModified, sTime);
		ASSERT(bRet);

		delete pItem;
		pList.RemoveHead();		
	}
}

/////////////////////////////////////////////////////////////////////////////
// converts double to a string like: 23,456,789 (with commas)
CString CViewList::MakePrettyNumber(double fNum)
{
	// let printf do its thing. reverse it. load the reverse version into new string
	// every third item, add a comma. reverse the result and return

	char szBuf[16];
	sprintf( szBuf, "%.0f", fNum );
	CString in = szBuf;
	in.MakeReverse();
	CString out  = "";
	int i, n;
	i = 0;
	n = in.GetLength();
	while( i < n )
	{
		out += in.GetAt( i );
		i++;
		if( (i % 3 == 0) && (i != n) )  // do if the third one. dont do if at end
		{
			out += ",";
		}     
	}
	out.MakeReverse();
	out += "KB";
	return out;
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::EmptyListAndPath(void)
{
	CListCtrl& cTheList = GetListCtrl();
	cTheList.DeleteAllItems();
	m_sPath = "";
}

/////////////////////////////////////////////////////////////////////////////
void CViewList::SortByAlpha(CPtrList * pList)
{ 
	int nStartCount = pList->GetCount();	// save and compare at end
	CPtrList cListTemp;						// holding tank for sorting
	POSITION posN, posMaxN, posNewN;		// for sorting the List
	
	// the sorter. Find the higher name. copy it and the associated name to the Temp
	// lists. remove the largest size (and name) from the original list and interate
	// until the original lists are empty.
	while (!pList->IsEmpty())
	{
		int nCount = pList->GetCount();
		int nCountTemp = cListTemp.GetCount();
		posN = pList->GetHeadPosition();
		posMaxN = posN; // init the max to the first
		SUBITEM * pItem = (SUBITEM *)pList->GetNext(posN);
		CString sFileName = pItem->szName;
		sFileName.MakeLower();
		while(posN != NULL)
		{
			posNewN = posN;
		    SUBITEM * pItemTemp = (SUBITEM * )pList->GetNext(posN); // burn it off to advance the pos
			CString sFileNameTest = pItemTemp->szName;
			sFileNameTest.MakeLower();
			BOOL bResult = FALSE;
			if (sFileNameTest > sFileName)
			{
				bResult = TRUE;
			}
			if( bResult )
		    {
		    	sFileName = sFileNameTest;
		    	posMaxN = posNewN;
		    }
		}
		// we have the max value positions now so copy them and trim orignial lists
		cListTemp.AddHead(pList->GetAt(posMaxN));
		pList->RemoveAt(posMaxN); 
	}
	
	ASSERT(cListTemp.GetCount() == nStartCount);

	// original lists are now empty - copy the sorted results back to them
	posN = cListTemp.GetHeadPosition();
	while( posN != NULL )
	{
		pList->AddTail(cListTemp.GetNext(posN));
	}
}




