/*
 * Decompiled with CFR 0.152.
 */
package com.others;

import com.others.ImageCodec;
import com.others.ImageDecodeParam;
import com.others.ImageDecoder;
import com.others.ImageEncodeParam;
import com.others.ImageEncoder;
import com.others.SeekableStream;
import com.others.TIFFImageDecoder;
import com.others.TIFFImageEncoder;
import java.awt.image.RenderedImage;
import java.io.OutputStream;

public final class TIFFCodec
extends ImageCodec {
    public String getFormatName() {
        return "tiff";
    }

    public Class getEncodeParamClass() {
        return Class.forName("com.others.TIFFEncodeParam");
    }

    public Class getDecodeParamClass() {
        return Class.forName("com.others.TIFFDecodeParam");
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        return new TIFFImageEncoder(outputStream, imageEncodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new TIFFImageDecoder(seekableStream, imageDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 4;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        if (byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0) {
            return true;
        }
        return byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42;
    }
}

