VERSION 5.00
Begin VB.UserControl ProgressBar 
   ClientHeight    =   420
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3876
   ScaleHeight     =   35
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   323
   ToolboxBitmap   =   "ProgressBar.ctx":0000
   Begin VB.PictureBox Picture1 
      FillStyle       =   0  'Solid
      Height          =   372
      Left            =   0
      ScaleHeight     =   27
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   317
      TabIndex        =   0
      Top             =   0
      Width           =   3852
   End
End
Attribute VB_Name = "ProgressBar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' Zeal Progress Bar Control
' Version 1.2
' Copyright (c) 2000-2002 Hai Li, Zeal SoftStudio
' http://www.zealsoft.com (English)
' http://zealsoft.nease.net (Chinese)
' info@zealsoft.com
'
' This is a CARDWARE. If you want to use it, please send
' a postcard(not e-mail) to the author. The address is
'     Hai Li
'     No. 1607 Unit 133
'     Beijing Institute of Tech.
'     Beijing 100081
'     China

Option Explicit
'Default Property Values:
Const m_def_Orientation = 0
Const m_def_Value = 50
Const m_def_Min = 0
Const m_def_Max = 100
Const m_def_BarText = "%"
'Property Variables:
Dim m_Orientation As Variant
Dim m_Value As Single
Dim m_Min As Single
Dim m_Max As Single
Dim m_BarText As String
'Event Declarations:
Event Click() 'MappingInfo=UserControl,UserControl,-1,Click
Attribute Click.VB_Description = "Occurs when the user presses and then releases a mouse button over an object."
Event DblClick() 'MappingInfo=UserControl,UserControl,-1,DblClick
Attribute DblClick.VB_Description = " Occurs when the user presses and releases a mouse button and then presses and releases it again over an object."
Event KeyDown(KeyCode As Integer, Shift As Integer) 'MappingInfo=Picture1,Picture1,-1,KeyDown
Attribute KeyDown.VB_Description = "Occurs when the user presses a key while an object has the focus."
Event KeyPress(KeyAscii As Integer) 'MappingInfo=Picture1,Picture1,-1,KeyPress
Attribute KeyPress.VB_Description = "Occurs when the user presses and releases an ANSI key."
Event KeyUp(KeyCode As Integer, Shift As Integer) 'MappingInfo=Picture1,Picture1,-1,KeyUp
Attribute KeyUp.VB_Description = "Occurs when the user releases a key while an object has the focus."
Event MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single) 'MappingInfo=Picture1,Picture1,-1,MouseDown
Attribute MouseDown.VB_Description = "Occurs when the user presses the mouse button while an object has the focus."
Event MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single) 'MappingInfo=Picture1,Picture1,-1,MouseMove
Attribute MouseMove.VB_Description = "Occurs when the user moves the mouse."
Event MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single) 'MappingInfo=Picture1,Picture1,-1,MouseUp
Attribute MouseUp.VB_Description = "Occurs when the user releases the mouse button while an object has the focus."

Public Enum MyBorderStyle
    None
    Fixed
End Enum

Public Enum OrientationType
    zOrientationHorizontal
    zOrientationVertical
End Enum

Private Sub Picture1_Paint()
    Dim hBrush As Long, hBrushOld As Long
    Dim rc As RECT, sString As String
    Dim nWidth As Long, nHeight As Long
    Dim nBackColor As Long, nForeColor As Long
    
    Dim m_Percent As Single
    
    ' Translate VB's OleColor to API's COLORREF
    OleTranslateColor BackColor, 0, nBackColor
    OleTranslateColor ForeColor, 0, nForeColor
    
    ' Caculate the percent
    m_Percent = (m_Value - m_Min) / (m_Max - m_Min)
    
    ' Set the string to be displayed
    sString = Format(m_Percent * 100, "#0") + m_BarText
    
    nWidth = Picture1.TextWidth(sString)
    nHeight = Picture1.TextHeight(sString)
    
    ' Draw the left part
    Picture1.ForeColor = nBackColor
    Picture1.FillColor = nForeColor
    rc.Left = 0
    If m_Orientation = zOrientationHorizontal Then
        rc.Right = Picture1.ScaleWidth * m_Percent
        rc.Top = 0
    Else
        rc.Right = Picture1.ScaleWidth
        rc.Top = Picture1.ScaleHeight * (1 - m_Percent)
    End If
    rc.Bottom = Picture1.ScaleHeight

    SetBkColor Picture1.hdc, nForeColor
    ExtTextOut Picture1.hdc, _
            (Picture1.ScaleWidth - nWidth) / 2, _
            (Picture1.ScaleHeight - nHeight) / 2, _
            ETO_CLIPPED Or ETO_OPAQUE, _
            rc, _
            sString, _
            Len(sString), _
            ByVal 0&
            
    ' Draw the right part
    If m_Orientation = zOrientationHorizontal Then
        rc.Left = rc.Right
        rc.Right = Picture1.ScaleWidth
    Else
        rc.Bottom = rc.Top
        rc.Top = 0
    End If
    Picture1.ForeColor = nForeColor
    Picture1.FillColor = nBackColor
    
    SetBkColor Picture1.hdc, nBackColor
    ExtTextOut Picture1.hdc, _
        (Picture1.ScaleWidth - nWidth) / 2, _
        (Picture1.ScaleHeight - nHeight) / 2, _
        ETO_CLIPPED Or ETO_OPAQUE, _
        rc, _
        sString, _
        Len(sString), _
        ByVal 0&
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!UserControl,UserControl,-1,BackColor
Public Property Get BackColor() As OLE_COLOR
Attribute BackColor.VB_Description = " Returns/sets the background color used to display text and graphics in an object."
    BackColor = UserControl.BackColor
End Property

Public Property Let BackColor(ByVal New_BackColor As OLE_COLOR)
    UserControl.BackColor() = New_BackColor
    PropertyChanged "BackColor"
    Refresh
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!UserControl,UserControl,-1,ForeColor
Public Property Get ForeColor() As OLE_COLOR
Attribute ForeColor.VB_Description = " Returns/sets the foreground color used to display text and graphics in an object."
    ForeColor = UserControl.ForeColor
End Property

Public Property Let ForeColor(ByVal New_ForeColor As OLE_COLOR)
    UserControl.ForeColor() = New_ForeColor
    PropertyChanged "ForeColor"
    Refresh
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!UserControl,UserControl,-1,Font
Public Property Get Font() As Font
Attribute Font.VB_Description = "Returns a Font object."
Attribute Font.VB_UserMemId = -512
    Set Font = Picture1.Font
End Property

Public Property Set Font(ByVal New_Font As Font)
    Set Picture1.Font = New_Font
    PropertyChanged "Font"
    Refresh
End Property

Public Property Get Value() As Single
Attribute Value.VB_Description = "Returns/sets a number that specifies the value of the ProgressBar control."
    Value = m_Value
End Property

Public Property Let Value(ByVal New_Value As Single)
    m_Value = New_Value
    PropertyChanged "Value"
    Refresh
End Property

Public Property Get Min() As Single
Attribute Min.VB_Description = "Returns or sets the ProgressBar control's minimum value."
    Min = m_Min
End Property

Public Property Let Min(ByVal New_Min As Single)
    If New_Min > Max Then Err.Raise 380
    m_Min = New_Min
    PropertyChanged "Min"
    Refresh
End Property

Public Property Get Max() As Single
Attribute Max.VB_Description = "Returns or sets the ProgressBar control's maximum value."
    Max = m_Max
End Property

Public Property Let Max(ByVal New_Max As Single)
    If m_Min > New_Max Then Err.Raise 380
    m_Max = New_Max
    PropertyChanged "Max"
    Refresh
End Property

'Initialize Properties for User Control
Private Sub UserControl_InitProperties()
    m_Value = m_def_Value
    m_Min = m_def_Min
    m_Max = m_def_Max
    m_Orientation = m_def_Orientation
    m_BarText = m_def_BarText
    UserControl.ForeColor = vbBlue
End Sub

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

    UserControl.BackColor = PropBag.ReadProperty("BackColor", &H8000000F)
    UserControl.ForeColor = PropBag.ReadProperty("ForeColor", vbBlue)
    Set Picture1.Font = PropBag.ReadProperty("Font", Ambient.Font)
    m_Value = PropBag.ReadProperty("Value", m_def_Value)
    m_Min = PropBag.ReadProperty("Min", m_def_Min)
    m_Max = PropBag.ReadProperty("Max", m_def_Max)
    m_Orientation = PropBag.ReadProperty("Orientation", m_def_Orientation)
    m_BarText = PropBag.ReadProperty("BarText", m_def_BarText)
    Picture1.BorderStyle = PropBag.ReadProperty("BorderStyle", 1)
    Picture1.OLEDragMode = PropBag.ReadProperty("OLEDragMode", 0)
    Picture1.OLEDropMode = PropBag.ReadProperty("OLEDropMode", 0)
End Sub

Private Sub UserControl_Resize()
    Picture1.Width = ScaleWidth
    Picture1.Height = ScaleHeight
End Sub

'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("BackColor", UserControl.BackColor, &H8000000F)
    Call PropBag.WriteProperty("ForeColor", UserControl.ForeColor, vbBlue)
    Call PropBag.WriteProperty("Font", Picture1.Font, Ambient.Font)
    Call PropBag.WriteProperty("Value", m_Value, m_def_Value)
    Call PropBag.WriteProperty("Min", m_Min, m_def_Min)
    Call PropBag.WriteProperty("Max", m_Max, m_def_Max)
    Call PropBag.WriteProperty("BarText", m_BarText, m_def_BarText)
    Call PropBag.WriteProperty("Orientation", m_Orientation, m_def_Orientation)
    Call PropBag.WriteProperty("BorderStyle", Picture1.BorderStyle, 1)
    Call PropBag.WriteProperty("OLEDragMode", Picture1.OLEDragMode, 0)
    Call PropBag.WriteProperty("OLEDropMode", Picture1.OLEDropMode, 0)
End Sub

Public Property Get Orientation() As OrientationType
Attribute Orientation.VB_Description = "Returns or sets a value that determines the orientation (horizontal or vertical) of the object."
    Orientation = m_Orientation
End Property

Public Property Let Orientation(ByVal New_Orientation As OrientationType)
    m_Orientation = New_Orientation
    ' Swap the Height and Width
    Dim temp
    
    temp = Height
    Height = Width
    Width = temp
    PropertyChanged "Orientation"
End Property

Public Property Get BarText() As String
Attribute BarText.VB_Description = "Returns or sets the text of Progress Bar control."
    BarText = m_BarText
End Property

Public Property Let BarText(ByVal New_BarText As String)
    m_BarText = New_BarText
    PropertyChanged "BarText"
    Refresh
End Property

'
'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!Picture1,Picture1,-1,BorderStyle
Public Property Get BorderStyle() As MyBorderStyle
Attribute BorderStyle.VB_Description = "Returns/sets the border style for an object."
    BorderStyle = Picture1.BorderStyle
End Property

Public Property Let BorderStyle(ByVal New_BorderStyle As MyBorderStyle)
    Picture1.BorderStyle() = New_BorderStyle
    PropertyChanged "BorderStyle"
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!Picture1,Picture1,-1,Refresh
Public Sub Refresh()
Attribute Refresh.VB_Description = "Forces a complete repaint of a object."
    Picture1.Refresh
End Sub

Private Sub UserControl_Click()
    RaiseEvent Click
End Sub

Private Sub UserControl_DblClick()
    RaiseEvent DblClick
End Sub

Private Sub Picture1_KeyDown(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyDown(KeyCode, Shift)
End Sub

Private Sub Picture1_KeyPress(KeyAscii As Integer)
    RaiseEvent KeyPress(KeyAscii)
End Sub

Private Sub Picture1_KeyUp(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyUp(KeyCode, Shift)
End Sub

Private Sub Picture1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    RaiseEvent MouseDown(Button, Shift, x, y)
End Sub

Private Sub Picture1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    RaiseEvent MouseMove(Button, Shift, x, y)
End Sub

Private Sub Picture1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    RaiseEvent MouseUp(Button, Shift, x, y)
End Sub

' Display the copyright dialog
Public Sub ShowAbout()
Attribute ShowAbout.VB_Description = "Display the copyright dialog."
Attribute ShowAbout.VB_UserMemId = -552
    frmAbout.Show vbModal
End Sub
