// OleSafeArrayEx.cpp: implementation of the COleSafeArrayEx class.
//
//////////////////////////////////////////////////////////////////////

#include "mbu.h"
#include "OleSafeArrayEx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COleSafeArrayEx::COleSafeArrayEx():COleSafeArray()
{

}

COleSafeArrayEx::~COleSafeArrayEx()
{

}

BOOL COleSafeArrayEx::ToWordArray(CWordArray& wordArray, const VARIANT* pvArray)
{
	
	WORD* pwData;
	LONG* plData;
	long lCount;
	long lLbound=0;
	long lUbound=0;
	
	
	const VARIANT* pvSrc= (pvArray==NULL) ? this : pvArray;    
	
	//Not array 
	if ((pvSrc->vt&VT_ARRAY)==0) {
		return FALSE;
	}
	
	//integer only 
	if (((pvSrc->vt&0x0FFF)!=VT_I2)&&((pvSrc->vt&0x0FFF)!=VT_I4)) {
		return FALSE;
	}
	
	//vectors only 
	if (::SafeArrayGetDim(pvSrc->parray)!=1) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetLBound(pvSrc->parray,1, &lLbound)) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetUBound(pvSrc->parray, 1, &lUbound)) {
		return FALSE;
	}
	
	if ((pvSrc->vt&0x0FFF)==VT_I2) {
		
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pwData)) {
			return FALSE;
		}
	}
	else {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&plData)) {
			return FALSE;
		}
	}

	
	wordArray.SetSize(lUbound-lLbound+1);
	
	//integer 
	if ((pvSrc->vt&0x0FFF)==VT_I2) {
		::memcpy(wordArray.GetData(),pwData,(UINT)((lUbound-lLbound+1)*sizeof(WORD)));
	}
	else {
		for (lCount=0;lCount<=(lUbound-lLbound);lCount++) {
			wordArray[lCount]=(WORD)plData[lCount];
		}
	}
	
	::SafeArrayUnaccessData(pvSrc->parray);
	return TRUE;
}


BOOL COleSafeArrayEx::ToBoolByteArray(CByteArray& byteArray, const VARIANT* pvArray) {

	VARIANT_BOOL* pbData;
	short* piData;
	LONG* plData;
	long lCount;
	long lLbound=0;
	long lUbound=0;
	
	
	const VARIANT* pvSrc= (pvArray==NULL) ? this : pvArray;    
	
	//Not array 
	if ((pvSrc->vt&VT_ARRAY)==0) {
		return FALSE;
	}
	
	//integer only 
	if (((pvSrc->vt&0x0FFF)!=VT_I2)&&((pvSrc->vt&0x0FFF)!=VT_I4)&&((pvSrc->vt&0x0FFF)!=VT_BOOL)) {
		return FALSE;
	}
	//vectors only 
	if (::SafeArrayGetDim(pvSrc->parray)!=1) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetLBound(pvSrc->parray,1, &lLbound)) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetUBound(pvSrc->parray, 1, &lUbound)) {
		return FALSE;
	}
	
	if ((pvSrc->vt&0x0FFF)==VT_I2) {
		
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&piData)) {
			return FALSE;
		}
	}
	else if ((pvSrc->vt&0x0FFF)==VT_I4) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&plData)) {
			return FALSE;
		}
	}
	else if ((pvSrc->vt&0x0FFF)==VT_BOOL) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pbData)) {
			return FALSE;
		}
	}
	else {
		return FALSE;
	}
	
	byteArray.SetSize(lUbound-lLbound+1);
	
	//integer 
	
	for (lCount=0;lCount<=(lUbound-lLbound);lCount++) {
		if ((pvSrc->vt&0x0FFF)==VT_I2) {
			byteArray[lCount]=(VARIANT_FALSE!=piData[lCount]);
		}
		else if ((pvSrc->vt&0x0FFF)==VT_I4) {
			byteArray[lCount]=(VARIANT_FALSE!=plData[lCount]);
		}
		else if ((pvSrc->vt&0x0FFF)==VT_BOOL) {
			byteArray[lCount]=(VARIANT_FALSE!=pbData[lCount]);
			
		}
	}

	::SafeArrayUnaccessData(pvSrc->parray);

	return TRUE;

}

BOOL COleSafeArrayEx::ToByteArray(CByteArray& byteArray, const VARIANT* pvArray) {
	
	BYTE* pbyData;
	short* piData;
	LONG* plData;
	long lCount;
	long lLbound=0;
	long lUbound=0;
	
	
	const VARIANT* pvSrc= (pvArray==NULL) ? this : pvArray;    
	
	//Not array 
	if ((pvSrc->vt&VT_ARRAY)==0) {
		return FALSE;
	}
	
	//integer only 
	if (((pvSrc->vt&0x0FFF)!=VT_I2)&&((pvSrc->vt&0x0FFF)!=VT_I4)&&((pvSrc->vt&0x0FFF)!=VT_UI1)) {
		return FALSE;
	}
	//vectors only 
	if (::SafeArrayGetDim(pvSrc->parray)!=1) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetLBound(pvSrc->parray,1, &lLbound)) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetUBound(pvSrc->parray, 1, &lUbound)) {
		return FALSE;
	}
	
	if ((pvSrc->vt&0x0FFF)==VT_I2) {
		
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&piData)) {
			return FALSE;
		}
	}
	else if ((pvSrc->vt&0x0FFF)==VT_I4) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&plData)) {
			return FALSE;
		}
	}
	else if ((pvSrc->vt&0x0FFF)==VT_UI1) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pbyData)) {
			return FALSE;
		}
	}
	else {
		return FALSE;
	}
	
	byteArray.SetSize(lUbound-lLbound+1);
	
	//integer 
	
	for (lCount=0;lCount<=(lUbound-lLbound);lCount++) {
		if ((pvSrc->vt&0x0FFF)==VT_I2) {
			byteArray[lCount]=BYTE(piData[lCount]);
		}
		else if ((pvSrc->vt&0x0FFF)==VT_I4) {
			byteArray[lCount]=BYTE(plData[lCount]);
		}
		else if ((pvSrc->vt&0x0FFF)==VT_UI1) {
			byteArray[lCount]=BYTE(pbyData[lCount]);
			
		}
	}

	::SafeArrayUnaccessData(pvSrc->parray);

	return TRUE;
}

BOOL COleSafeArrayEx::ToDoubleArray(CDoubleArray& doubleArray, const VARIANT* pvArray) {

	double* pdData;
	float* pfData;
	long lCount;
	long lLbound=0;
	long lUbound=0;
	
	
	const VARIANT* pvSrc= (pvArray==NULL) ? this : pvArray;    
	
	//Not array 
	if ((pvSrc->vt&VT_ARRAY)==0) {
		return FALSE;
	}
	
	//verify Type 
	if (((pvSrc->vt&0x0FFF)!=VT_R4)&&((pvSrc->vt&0x0FFF)!=VT_R8)) {
		return FALSE;
	}
	//vectors only 
	if (::SafeArrayGetDim(pvSrc->parray)!=1) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetLBound(pvSrc->parray,1, &lLbound)) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetUBound(pvSrc->parray, 1, &lUbound)) {
		return FALSE;
	}
	
	if ((pvSrc->vt&0x0FFF)==VT_R4) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pfData)) {
			return FALSE;
		}
	}
	else if ((pvSrc->vt&0x0FFF)==VT_R8) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pdData)) {
			return FALSE;
		}
	}
	else {
		return FALSE;
	}
	
	doubleArray.SetSize(lUbound-lLbound+1);
	
	for (lCount=0;lCount<=(lUbound-lLbound);lCount++) {
		if ((pvSrc->vt&0x0FFF)==VT_R4) {
			doubleArray[lCount]=pfData[lCount];
		}
		else if ((pvSrc->vt&0x0FFF)==VT_R8) {
			doubleArray[lCount]=pdData[lCount];
			
		}
	}

	::SafeArrayUnaccessData(pvSrc->parray);

	return TRUE;


}

BOOL COleSafeArrayEx::ToDblArray(CDblArray& doubleArray, const VARIANT* pvArray) {

	double* pdData;
	float* pfData;
	long lCount;
	long lLbound=0;
	long lUbound=0;
	
	
	const VARIANT* pvSrc= (pvArray==NULL) ? this : pvArray;    
	
	//Not array 
	if ((pvSrc->vt&VT_ARRAY)==0) {
		return FALSE;
	}
	
	//verify Type 
	if (((pvSrc->vt&0x0FFF)!=VT_R4)&&((pvSrc->vt&0x0FFF)!=VT_R8)) {
		return FALSE;
	}
	//vectors only 
	if (::SafeArrayGetDim(pvSrc->parray)!=1) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetLBound(pvSrc->parray,1, &lLbound)) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetUBound(pvSrc->parray, 1, &lUbound)) {
		return FALSE;
	}
	
	if ((pvSrc->vt&0x0FFF)==VT_R4) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pfData)) {
			return FALSE;
		}
	}
	else if ((pvSrc->vt&0x0FFF)==VT_R8) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pdData)) {
			return FALSE;
		}
	}
	else {
		return FALSE;
	}
	
	doubleArray.SetSize(lUbound-lLbound+1);
	
	for (lCount=0;lCount<=(lUbound-lLbound);lCount++) {
		if ((pvSrc->vt&0x0FFF)==VT_R4) {
			doubleArray[lCount]=pfData[lCount];
		}
		else if ((pvSrc->vt&0x0FFF)==VT_R8) {
			doubleArray[lCount]=pdData[lCount];
			
		}
	}

	::SafeArrayUnaccessData(pvSrc->parray);

	return TRUE;


}


BOOL COleSafeArrayEx::ToFloatArray(CFloatArray& floatArray, const VARIANT* pvArray) {

	double* pdData;
	float* pfData;
	long lCount;
	long lLbound=0;
	long lUbound=0;
	
	
	const VARIANT* pvSrc= (pvArray==NULL) ? this : pvArray;    
	
	//Not array 
	if ((pvSrc->vt&VT_ARRAY)==0) {
		return FALSE;
	}
	
	//verify Type 
	if (((pvSrc->vt&0x0FFF)!=VT_R4)&&((pvSrc->vt&0x0FFF)!=VT_R8)) {
		return FALSE;
	}
	//vectors only 
	if (::SafeArrayGetDim(pvSrc->parray)!=1) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetLBound(pvSrc->parray,1, &lLbound)) {
		return FALSE;
	}
	
	if FAILED(::SafeArrayGetUBound(pvSrc->parray, 1, &lUbound)) {
		return FALSE;
	}
	
	if ((pvSrc->vt&0x0FFF)==VT_R4) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pfData)) {
			return FALSE;
		}
	}
	else if ((pvSrc->vt&0x0FFF)==VT_R8) {
		if FAILED(::SafeArrayAccessData(pvSrc->parray,(void HUGEP* FAR*)&pdData)) {
			return FALSE;
		}
	}
	else {
		return FALSE;
	}
	
	floatArray.SetSize(lUbound-lLbound+1);
	
	for (lCount=0;lCount<=(lUbound-lLbound);lCount++) {
		if ((pvSrc->vt&0x0FFF)==VT_R4) {
			floatArray[lCount]=pfData[lCount];
		}
		else if ((pvSrc->vt&0x0FFF)==VT_R8) {
			floatArray[lCount]=float(pdData[lCount]);
			
		}
	}

	::SafeArrayUnaccessData(pvSrc->parray);

	return TRUE;


}


BOOL COleSafeArrayEx::ToVariantArray(const CWordArray& wArrayScr,VARIANT* pvarDest,VARTYPE vtDest){

	WORD* pwData;
	LONG* plData;
	long lCount;
	
	VARIANT* pvDest= (pvarDest==NULL) ? this : pvarDest;   

	if FAILED(::VariantClear(pvDest)) {
		return FALSE;
	}

	pvDest->vt=(VT_ARRAY|vtDest);
	pvDest->parray=::SafeArrayCreateVector(vtDest,0,wArrayScr.GetSize());
	
	if (NULL==pvDest->parray) {
		return FALSE;
	}
	
	if ((pvDest->vt&0x0FFF)==VT_I2) {
		
		if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&pwData)) {
			return FALSE;
		}
	}
	else {
		if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&plData)) {
			return FALSE;
		}
	}

	//integer 
	if ((pvDest->vt&0x0FFF)==VT_I2) {
		::memcpy(pwData,wArrayScr.GetData(),(UINT)((wArrayScr.GetSize())*sizeof(WORD)));
	}
	else {
		for (lCount=0;lCount<wArrayScr.GetSize();lCount++) {

			 plData[lCount]=wArrayScr[lCount];
		}
	}

    ::SafeArrayUnaccessData(pvDest->parray);
	return TRUE;

}


BOOL COleSafeArrayEx::ToVariantArray(const CByteArray& byteArrayScr,VARIANT* pvarDest,VARTYPE vtDest){
	
	WORD* pwData;
	LONG* plData;
	BYTE* pbyData;

	long lCount;
	
	VARIANT* pvDest= (pvarDest==NULL) ? this : pvarDest;   

	if FAILED(::VariantClear(pvDest)) {
		return FALSE;
	}

	pvDest->vt=(VT_ARRAY|vtDest);
	pvDest->parray=::SafeArrayCreateVector(vtDest,0,byteArrayScr.GetSize());
	
	if (NULL==pvDest->parray) {
		return FALSE;
	}
	
	if ((pvDest->vt&0x0FFF)==VT_I2) {
		
		if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&pwData)) {
			return FALSE;
		}
	}
	else if ((pvDest->vt&0x0FFF)==VT_I4){
		if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&plData)) {
			return FALSE;
		}
	}
	else if ((pvDest->vt&0x0FFF)==VT_UI1){
		if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&pbyData)) {
			return FALSE;
		}
	}

	for (lCount=0;lCount<byteArrayScr.GetSize();lCount++) {
		
		if ((pvDest->vt&0x0FFF)==VT_I2) {
			pwData[lCount] = byteArrayScr[lCount];
		}
		else if ((pvDest->vt&0x0FFF)==VT_I4) {

			plData[lCount] = byteArrayScr[lCount];

		}
		else if ((pvDest->vt&0x0FFF)==VT_UI1) {

			pbyData[lCount] = byteArrayScr[lCount];
			
		}
	}
	
	
    ::SafeArrayUnaccessData(pvDest->parray);
	
	return TRUE;

}



BOOL COleSafeArrayEx::ToVariantArray(const double* pdArrayScr,int iSize, VARIANT* pvarDest){
	
	double* pdData;
	long lCount;
	
	VARIANT* pvDest= (pvarDest==NULL) ? this : pvarDest;   

	if FAILED(::VariantClear(pvDest)) {
		return FALSE;
	}

	pvDest->vt=(VT_ARRAY|VT_R8);
	pvDest->parray=::SafeArrayCreateVector(VT_R8,0,iSize);
	
	if (NULL==pvDest->parray) {
		return FALSE;
	}
	
	
	if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&pdData)) {
		return FALSE;
	}
	

	for (lCount=0;lCount<iSize;lCount++) {
			pdData[lCount] = pdArrayScr[lCount];
	}
	
    ::SafeArrayUnaccessData(pvDest->parray);
	
	return TRUE;

}

BOOL COleSafeArrayEx::ToVariantArray(const float* pfArrayScr,int iSize, VARIANT* pvarDest){
	
	float* pfData;
	long lCount;
	
	VARIANT* pvDest= (pvarDest==NULL) ? this : pvarDest;   

	if FAILED(::VariantClear(pvDest)) {
		return FALSE;
	}

	pvDest->vt=(VT_ARRAY|VT_R4);
	pvDest->parray=::SafeArrayCreateVector(VT_R4,0,iSize);
	
	if (NULL==pvDest->parray) {
		return FALSE;
	}
	
	
	if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&pfData)) {
		return FALSE;
	}
	

	for (lCount=0;lCount<iSize;lCount++) {
			pfData[lCount] = pfArrayScr[lCount];
	}
	
    ::SafeArrayUnaccessData(pvDest->parray);
	
	return TRUE;

}



BOOL COleSafeArrayEx::ToVariantBoolArray(const CByteArray& byArrayScr,VARIANT* pvarDest) {

	VARIANT_BOOL* pvbData;
	long lCount;
	
	VARIANT* pvDest= (pvarDest==NULL) ? this : pvarDest;   

	if FAILED(::VariantClear(pvDest)) {
		return FALSE;
	}

	pvDest->vt=(VT_ARRAY|VT_BOOL);
	pvDest->parray=::SafeArrayCreateVector(VT_BOOL,0,byArrayScr.GetSize());
	
	if (NULL==pvDest->parray) {
		return FALSE;
	}
	
	
	if FAILED(::SafeArrayAccessData(pvDest->parray,(void HUGEP* FAR*)&pvbData)) {
		return FALSE;
	}


	for (lCount=0;lCount<byArrayScr.GetSize();lCount++) {
		if (FALSE==byArrayScr[lCount]) {
			 pvbData[lCount]=VARIANT_FALSE;
		}
		else {
			pvbData[lCount]=VARIANT_TRUE;
		}
	}
	

    ::SafeArrayUnaccessData(pvDest->parray);
	return TRUE;

}