VERSION 5.00
Object = "{C0A58BC3-1600-4C2C-8DDB-2DD7FDE5CA63}#1.0#0"; "vbalIml200_75B4A91C.ocx"
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmOutlookDemo 
   Caption         =   "Outlook Style Grid Demonstration"
   ClientHeight    =   6135
   ClientLeft      =   465
   ClientTop       =   885
   ClientWidth     =   11400
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "OutlookDemo.frx":0000
   LinkTopic       =   "Form2"
   ScaleHeight     =   409
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   760
   Begin iGrid250_Demo.StatusBar StatusBar 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      Top             =   5790
      Width           =   11400
      _ExtentX        =   20108
      _ExtentY        =   609
   End
   Begin iGrid250_75B4A91C.iGrid grdOutlook 
      Height          =   2415
      Left            =   720
      TabIndex        =   1
      Top             =   360
      Width           =   3495
      _ExtentX        =   6165
      _ExtentY        =   4260
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Tahoma"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin vbalIml200_75B4A91C.vbalImageList ilsIcons 
      Left            =   2520
      Top             =   3780
      _ExtentX        =   953
      _ExtentY        =   953
      Size            =   16072
      Images          =   "OutlookDemo.frx":0442
      Version         =   131072
      KeyCount        =   14
      Keys            =   "minus_btnplus_btn"
   End
   Begin VB.Frame fraOpt 
      Caption         =   "Options"
      Height          =   5175
      Left            =   5040
      TabIndex        =   0
      Top             =   60
      Width           =   3195
      Begin VB.PictureBox Picture1 
         BorderStyle     =   0  'None
         Height          =   4875
         Left            =   60
         ScaleHeight     =   4875
         ScaleWidth      =   3075
         TabIndex        =   2
         TabStop         =   0   'False
         Top             =   240
         Width           =   3075
         Begin VB.CommandButton cmdGrouping 
            Caption         =   "Apply Grouping"
            Height          =   375
            Left            =   60
            TabIndex        =   8
            Top             =   4380
            Width           =   2955
         End
         Begin VB.ListBox lstCols 
            Height          =   1860
            Left            =   60
            Style           =   1  'Checkbox
            TabIndex        =   7
            Top             =   240
            Width           =   1275
         End
         Begin VB.OptionButton optAll 
            Caption         =   "All messages"
            Height          =   255
            Left            =   1440
            TabIndex        =   6
            Top             =   900
            Width           =   1455
         End
         Begin VB.OptionButton optUnread 
            Caption         =   "Unread messages"
            Height          =   255
            Left            =   1440
            TabIndex        =   5
            Top             =   600
            Value           =   -1  'True
            Width           =   1635
         End
         Begin VB.OptionButton optNone 
            Caption         =   "None"
            Height          =   255
            Left            =   1440
            TabIndex        =   4
            Top             =   300
            Width           =   1635
         End
         Begin iGrid250_75B4A91C.iGrid grdGroupBy 
            Height          =   1755
            Left            =   60
            TabIndex        =   9
            Top             =   2580
            Width           =   2955
            _ExtentX        =   5212
            _ExtentY        =   3096
            BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   204
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
         End
         Begin VB.Label Label1 
            AutoSize        =   -1  'True
            Caption         =   "Auto-Preview:"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   195
            Index           =   1
            Left            =   1440
            TabIndex        =   11
            Top             =   0
            Width           =   1200
         End
         Begin VB.Label Label1 
            AutoSize        =   -1  'True
            Caption         =   "Columns:"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   195
            Index           =   0
            Left            =   60
            TabIndex        =   10
            Top             =   0
            Width           =   765
         End
         Begin VB.Label Label1 
            AutoSize        =   -1  'True
            Caption         =   "Grouping:"
            BeginProperty Font 
               Name            =   "Tahoma"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   195
            Index           =   2
            Left            =   120
            TabIndex        =   3
            Top             =   2340
            Width           =   810
         End
      End
   End
   Begin vbalIml200_75B4A91C.vbalImageList vbalImageList1 
      Left            =   8400
      Top             =   3480
      _ExtentX        =   953
      _ExtentY        =   953
      Size            =   1148
      Images          =   "OutlookDemo.frx":432A
      Version         =   131072
      KeyCount        =   1
      Keys            =   ""
   End
End
Attribute VB_Name = "frmOutlookDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const ROW_COUNT = 200

Private Declare Function GetTickCount Lib "kernel32" () As Long
Private t1 As Long, t2 As Long

Private m_bGroup As Boolean
Private m_bUseItemCheck As Boolean

Private m_lBMinusIco As Long
Private m_lBPlusIco As Long

Dim sGroupCols(0 To 2) As String
Dim eOrder(0 To 2) As String
Dim m_iSelCount As Integer

Public fC_OK As Boolean

Private m_bDragRow As Boolean

Private Sub cmdGrouping_Click()
   Dim i As Long
   
   Screen.MousePointer = vbHourglass
   
   With grdGroupBy
      m_iSelCount = 0
      
      For i = 1 To .RowCount
         If .RowVisible(i) Then
            If .CellValue(i, "field") <> "(none)" Then
               m_iSelCount = m_iSelCount + 1
               sGroupCols(m_iSelCount - 1) = .CellValue(i, "field")
               eOrder(m_iSelCount - 1) = .CellValue(i, "order")
            End If
         End If
      Next i
      
      If m_iSelCount > 0 Then
         t1 = GetTickCount
         DoGroup m_iSelCount
         t2 = GetTickCount
         StatusBar.SetText "Grouped " & ROW_COUNT & " rows by " & m_iSelCount & " field(s) in " & t2 - t1 & " msec"
      Else
         DoGroup 0
      End If
   End With
   
   Screen.MousePointer = vbDefault
End Sub

Private Sub Form_Load()
   Dim iRow As Long
   Dim iIconUrgent As Long
   Dim iIconAttach As Long
   Dim iIconFlag As Long
   Dim iIconType As Long
   Dim iIdx As Long
   Dim dDate As Date
   Dim lCol As Long
   Dim iCol As Long
   Dim lHeight As Long

   m_lBMinusIco = ilsIcons.ItemIndex("minus_btn")
   m_lBPlusIco = ilsIcons.ItemIndex("plus_btn")
   
   m_bGroup = False
   With grdOutlook
      .Redraw = False    ' ' Turn redraw off for speed:
   
      ' Set up the grid:
      
      .ImageList = ilsIcons        ' Source of icons.  This can be vbAccelerator ImageList
      .Header.ImageList = ilsIcons  ' a VB ImageList control, class or
      .RowMode = True ' Row mode - select the entire row and draw grouped cells:
      .DefaultRowHeight = 3 + 16 * 15 / Screen.TwipsPerPixelY
      .Header.Flat = True
      .GridLines = igGridLinesNone
      .GridLines = igGridLinesHorizontal
      .GridLineColor = vbWhite
      .BackColor = vbWhite
      .FocusRect = False 'True
      .Editable = False
      
      ' Add the columns:
      .AddCol sKey:="group1", _
         lWidth:=17, _
         bVisible:=False, _
         bIncludeInSelect:=False, _
         bAllowSizing:=False
      .AddCol sKey:="group2", _
         lWidth:=17, _
         bVisible:=False, _
         bIncludeInSelect:=False, _
         bAllowSizing:=False
      .AddCol sKey:="group3", _
         lWidth:=17, _
         bVisible:=False, _
         bIncludeInSelect:=False, _
         bAllowSizing:=False
      .AddCol sKey:="urgency", _
         iIconIndex:=6, _
         lWidth:=26, _
         bIncludeInSelect:=False, _
         eSortType:=igSortByIcon, _
         bAllowSizing:=False
      .AddCol sKey:="type", _
         iIconIndex:=7, _
         lWidth:=26, _
         bIncludeInSelect:=False, _
         eSortType:=igSortByIcon, _
         bAllowSizing:=False
      .AddCol sKey:="attach", _
         iIconIndex:=9, _
         lWidth:=26, _
         bIncludeInSelect:=False, _
         eSortType:=igSortByIcon, _
         bAllowSizing:=False
      .AddCol sKey:="flag", _
         iIconIndex:=10, _
         lWidth:=26, _
         bIncludeInSelect:=False, _
         eSortType:=igSortByIcon, _
         bAllowSizing:=False
      .AddCol sKey:="from", _
         sHeader:="From", _
         lWidth:=96
      .AddCol sKey:="subject", _
         sHeader:="Subject", _
         lWidth:=206
      .AddCol sKey:="received", _
         sHeader:="Received", _
         lWidth:=96
      .ColDefaultCell("received").sFmtString = "dd/mm/yy hh:mm"
      .AddCol sKey:="to", _
         sHeader:="To", _
         lWidth:=96
      ' Add two invisible columns to cache status information:
      .AddCol sKey:="read", _
         bVisible:=False
      .AddCol sKey:="ID", _
         bVisible:=False
      ' The special "rowcolumntext" column must be added to the end
      ' of the available columns.  This never appears as a column
      ' header, but the text in it is drawn underneath the row (assuming
      ' the row is high enough for it, starting at the column
      ' specified by .RowTextStartCol:
      .AddCol sKey:="body", _
         lWidth:=96 + 206 + 96 + 96, _
         bRowTextCol:=True
      ' You can specify specifically at which column the text will start
      ' like this:
      '  .RowTextStartCol = .ColIndex("from")
      ' If you do this you need to track the ColOrderChanged event to
      ' ensure you are at the right column if the user moves this column
      ' to the end of the grid.  If you don't specify this setting, the
      ' grid will automatically start drawing rowtext at the position
      ' of the first column included in the select (bIncludeInSelect
      ' parameter of AddCol)
         
      .KeyPressBehaviour = igKeyPressSearchDefCol
      .KeySearchCol = .ColIndex("subject")
      
      ' Add some demonstration rows:
      
      ' Set up a bold font:
      Dim sFntUnread As New StdFont
      sFntUnread.Name = "Tahoma"
      sFntUnread.Size = 8
      sFntUnread.Bold = True
      
      ' Create some pretend text for From, Subject and Body
      Dim sFrom(1 To 10) As String
      sFrom(1) = "Carl Ridenhour"
      sFrom(2) = "Dale Winton"
      sFrom(3) = "Richard D James"
      sFrom(4) = "Luke Slater"
      sFrom(5) = "Mark Bell"
      sFrom(6) = "Frank Black"
      sFrom(7) = "Richard Clayderman"
      sFrom(8) = "James Last"
      sFrom(9) = "Thurston Moore"
      sFrom(10) = "Beth Gibbons"
      
      Dim sSubject(1 To 10) As String
      sSubject(1) = "Check out this demo"
      sSubject(2) = "RE: Sonic Bubblebath Remix"
      sSubject(3) = "FW: The secret world of plants"
      sSubject(4) = "U know u gonna dig this"
      sSubject(5) = "RE: FW: What Mandelson didn't say"
      sSubject(6) = "viz New York Trip"
      sSubject(7) = "Belated Happy Birthday"
      sSubject(8) = "RE: What's the score?"
      sSubject(9) = "vbAccelerator: Excellent site!"
      sSubject(10) = "Pass the peas..."
      
      Dim sBody(1 To 10) As String
      sBody(1) = "Impress passing airline passengers by painting a large blue rectangle in your back garden.  They will think that you have a swimming pool."
      sBody(2) = "Bus drivers: pretend to be an airline pilot by wedging the accelerator pedal down with a brick, tying the steering wheel to your seat with a rope and then walking up and down the aisle asking passengers if they are having a nice trip."
      sBody(3) = "A bloke walks into a butchers.  He says ""I bet you 100 that you can't get that meat down from the top shelf"".  The butcher looks up, thinks for a moment, then says ""Sorry mate, can't do it, the steaks are too high""."
      sBody(4) = "A skeleton walks into a bar.  He goes up to the barman and asks for a pint of beer and a mop."
      sBody(5) = "What's red and invisible?  Not a tomato."
      sBody(6) = "President Clinton was reviewing his Christmas shopping with Hilary.  He said ""Well, I think I did a bit better this year, but I wish I hadn't splashed out on that dress""."
      sBody(7) = "Jeffrey Archer Rhyming Slang Pt 1: Whistles and Flute - Shoplifting a Suit."
      sBody(8) = "Jeffrey Archer Rhyming Slang Pt 2: Trouble and Strife: Prostitute"
      sBody(9) = "Small ad (inadvertently) printed in Birmingham Evening Mail: 'For Sale: Blow-up Doll.  Almost as new, needs cleaning.  Slightly stained.  Easy clean plastic maids outfit.  Offers around 100.'"
      sBody(10) = "Say goodbye to Millenium Bug Fears with the Trouser Press 2000." & vbCrLf & "Belgian scientists have been working around the clock to find a solution to the Millenium's most worrying problem - what happens if your trousers are trapped in their press at midnight on December 31st 1999." & vbCrLf & vbCrLf & "Rest assured that thanks to this miracle of bug-free microchip technology you will be wearing a crisply-creased pair of your favourite trousers to greet the new Millenium. (Batteries extra)."
      
      .MemMngWantFreeRows = 100
      
      ' Now add the rows:
      .RowCount = ROW_COUNT
      For iRow = 1 To ROW_COUNT
         
         ' set the urgency:
         iIconUrgent = Rnd * 3
         Select Case iIconUrgent
         Case 1
            iIconUrgent = 4
         Case 2
            iIconUrgent = 5
         Case Else
            iIconUrgent = -1
         End Select
         .CellIcon(iRow, "urgency") = iIconUrgent
         
         ' set the type:
         If (iRow < 16) Then
            iIconType = 0
         Else
            iIconType = Rnd * 2 + 1
         End If
         .CellIcon(iRow, "type") = iIconType
         
         ' set the attachment:
         If Rnd * 20 > 17 Then
            iIconAttach = 11
         Else
            iIconAttach = -1
         End If
         .CellIcon(iRow, "attach") = iIconAttach
         
         ' set the Flag:
         If Rnd * 20 > 18 Then
            iIconFlag = 10
         Else
            iIconFlag = -1
         End If
         .CellIcon(iRow, "flag") = iIconFlag
         
         ' mark as irrelevant ("junk mail"):
         iIdx = Int(Rnd * 9) + 1
         If iIdx = 7 Or iIdx = 8 Then
            lCol = vbButtonFace
         Else
            lCol = -1
         End If
         
         ' from:
         .CellValue(iRow, "from") = sFrom(iIdx)
         .CellForeColor(iRow, "from") = lCol
         If (iRow < 16) Then
            .CellFont(iRow, "from") = sFntUnread
         End If
         
         ' subject:
         iIdx = Int(Rnd * 9) + 1
         .CellValue(iRow, "subject") = sSubject(iIdx)
         .CellForeColor(iRow, "subject") = lCol
         If (iRow < 16) Then
            .CellFont(iRow, "subject") = sFntUnread
         End If
         
         ' date:
         dDate = Now
         dDate = DateAdd("m", -Rnd * 12, dDate)
         dDate = DateAdd("d", -Rnd * 31, dDate)
         dDate = dDate + TimeSerial(Rnd * 24, Rnd * 60, Rnd * 60)
         .CellValue(iRow, "received") = dDate
         .CellForeColor(iRow, "received") = lCol
         If (iRow < 16) Then
            .CellFont(iRow, "received") = sFntUnread
         End If
         
         ' to:
         .CellValue(iRow, "to") = "Steve McMahon"
         .CellForeColor(iRow, "to") = lCol
         If (iRow < 16) Then
            .CellFont(iRow, "to") = sFntUnread
         End If
         
         ' body
         iIdx = Int(Rnd * 9) + 1
         .CellValue(iRow, "body") = sBody(iIdx)
         .CellForeColor(iRow, "body") = RGB(0, 0, &H80)
         .CellTextFlags(iRow, "body") = igTextWordBreak
         lHeight = .EvaluateTextHeight(iRow, "body") + .DefaultRowHeight + 3

         ' Read/unread marker:
         If (iRow < 16) Then
            .CellValue(iRow, "read") = "NOTREAD"
            .RowHeight(iRow) = lHeight
         Else
            .CellValue(iRow, "read") = "READ"
         End If
         
         ' ID marker:
         .CellValue(iRow, "ID") = iRow
                  
      Next iRow
      
      
      ' Add the columns to the Cols ListBox:
      m_bUseItemCheck = False
      For iCol = 1 To .ColCount
         If (.ColVisible(iCol)) And (iCol <> 14) Then
            If (.ColHeaderText(iCol) = "") Then
               lstCols.AddItem StrConv(.ColKey(iCol), vbProperCase)
            Else
               lstCols.AddItem .ColHeaderText(iCol)
            End If
            lstCols.Selected(lstCols.ListCount - 1) = True
         End If
      Next iCol
      lstCols.ListIndex = -1
      m_bUseItemCheck = True

      .Redraw = True
   End With
   
   
   With grdGroupBy
      With .Header
         .UseXPStyles = False
         .HotTrack = False
         .Buttons = False
         .DragCols = False
         .Flat = True
      End With
      .BorderStyle = igBorderThin
      .ImageList = vbalImageList1
      .FocusRect = True
      .HighlightSelCells = False
      .GridLines = igGridLinesNone
      .DefaultRowHeight = 3 + 15 * 15 / Screen.TwipsPerPixelY
      .BackColor = vbWhite
      .FocusRectColor1 = vbWhite
      .FocusRectColor2 = vbBlack
      .ShowControlsInAllCells = True
      .UseXPStyles = False
      
      With .Combos.Add("field")
         .AddItem sItemText:="(none)", vItemValue:="(none)"
         For iRow = 0 To lstCols.ListCount - 1
            .AddItem _
               sItemText:=lstCols.List(iRow), _
               vItemValue:=LCase$(lstCols.List(iRow))
         Next
         .MaxHeightInItems = .ListCount
      End With
      
      With .Combos.Add("order")
         .AddItem sItemText:="Ascending", vItemValue:="asc"
         .AddItem sItemText:="Descending", vItemValue:="desc"
      End With
      
      .AddCol sKey:="drag", lWidth:=19, bAllowSizing:=False
      .ColDefaultCell("drag").iIconIndex = 0
      
      .AddCol sKey:="field", _
         sHeader:="Field", _
         lWidth:=80, _
         bAllowSizing:=False
      With .ColDefaultCell("field")
         .eType = igCellCombo
         .sCtrlKey = "field"
         .eTypeFlags = igComboBtnFlat
         .vValue = "(none)"
         .oForeColor = vbButtonFace
         .iIndent = 2
         .eTextFlags = igTextVCenter Or igTextSingleLine
      End With
      
      .AddCol sKey:="order", _
         sHeader:="Order", _
         lWidth:=80, _
         bAllowSizing:=False
      With .ColDefaultCell("order")
         .eType = igCellCombo
         .sCtrlKey = "order"
         .eTypeFlags = igComboBtnFlat
         .vValue = "asc"
         .oForeColor = vbButtonFace
         .iIndent = 2
         .eTextFlags = igTextVCenter Or igTextSingleLine
      End With
      
      .Combos("field").SetWidth .ColWidth("field")
      .Combos("order").SetWidth .ColWidth("order")
      
      .RowCount = 3
   End With
   
   gpCheckShowTips Me
End Sub

Public Sub DoGroup(ByVal iItems As Long)
   Dim i As Long
   Dim iRow As Long
   Dim iCol As Long
   Dim iNumber As Long
   Dim sFnt As StdFont
   Dim iFnt As IFont
   Static iRefCount As Long
   Dim bNewGroupRow As Boolean
   Dim j As Long

With grdOutlook

   iRefCount = iRefCount + 1
   iNumber = iItems - 1
   If (iNumber > 2) Then
      MsgBox "Can't do it - max grouping is restricted to 3 columns for this demo.", vbInformation
   Else
      ' Stop redraw for speed:
      If (iRefCount = 1) Then
         .Redraw = False
      End If
      
      If (iNumber < 0) Then
         m_bGroup = False
         ' Remove all existing group rows:
         For iRow = .RowCount To 1 Step -1
            If .RowIsGroup(iRow) Then
               .RemoveRow iRow
            End If
         Next iRow
         For i = 0 To 2
            .ColVisible("group" & i + 1) = False
         Next i
         For iRow = 1 To .RowCount
            .RowVisible(iRow) = True
         Next iRow
      Else

         ' Remove groupings:
         DoGroup 0

         m_bGroup = True
         ' Make the relevant headers visible:
         For i = 0 To 2
            If (i <= iNumber) Then
               .ColVisible("group" & i + 1) = True
            Else
               .ColVisible("group" & i + 1) = False
            End If
         Next i
         
         ' Sort the grid according to the groupings:
         With .SortObject
            .ColCount = iNumber + 1
            For i = 0 To iNumber
               .SortCol(i + 1) = grdOutlook.ColIndex(sGroupCols(i))
               .SortOrder(i + 1) = IIf(eOrder(i) = "asc", igSortAsc, igSortDesc)
               .SortType(i + 1) = grdOutlook.ColSortType(sGroupCols(i))
            Next i
         End With
         .Sort    ' Calling without parameters uses SortObject
         
         ' Now add grouping rows:
         ReDim vLastItem(0 To iNumber) As Variant
         Set iFnt = .Font
         iFnt.Clone sFnt
         sFnt.Bold = True
         iRow = 1
         Do
            .RowTag(iRow) = CBool(iNumber = 0)
            
            bNewGroupRow = False
            For i = 0 To iNumber
               iCol = .ColIndex(sGroupCols(i))
               If .ColSortType(sGroupCols(i)) = igSortByIcon Then
                  If .CellIcon(iRow, iCol) <> vLastItem(i) Then
                     vLastItem(i) = .CellIcon(iRow, iCol)
                     For j = i + 1 To iNumber
                        vLastItem(j) = Empty
                     Next
                     .AddRow _
                        vRowBefore:=iRow, bGroupRow:=True, _
                        lGroupColStartIndex:=i + 1, vTag:=False
                     .CellValue(iRow, "body") = ""
                     .CellExtraIcon(iRow, "body") = m_lBPlusIco
                     .CellIcon(iRow, "body") = vLastItem(i)
                     .CellBackColor(iRow, "body") = vbButtonFace
                     .CellFont(iRow, "body") = sFnt
                     iRow = iRow + 1
                  End If
               Else
                  If .CellText(iRow, iCol) <> vLastItem(i) Then
                     vLastItem(i) = .CellText(iRow, iCol)
                     For j = i + 1 To iNumber
                        vLastItem(j) = Empty
                     Next
                     .AddRow _
                        vRowBefore:=iRow, bGroupRow:=True, _
                        lGroupColStartIndex:=i + 1, vTag:=False
                     .CellExtraIcon(iRow, "body") = m_lBPlusIco
                     .CellValue(iRow, "body") = vLastItem(i)
                     .CellBackColor(iRow, "body") = vbButtonFace
                     .CellFont(iRow, "body") = sFnt
                     iRow = iRow + 1
                  End If
               End If
            Next
            iRow = iRow + 1
         Loop While iRow <= .RowCount
         
         For iRow = 1 To .RowCount
            If .RowGroupStartCol(iRow) <> 1 Then
               .RowVisible(iRow) = False
            End If
         Next iRow
      End If
      
      ' Start redrawing again:
      If (iRefCount = 1) Then
         .Redraw = True
      End If
   End If
   iRefCount = iRefCount - 1

End With

End Sub

Private Sub Form_Resize()
   On Error Resume Next
   fraOpt.Move Me.ScaleWidth - fraOpt.Width - 2, 0, fraOpt.Width, Me.ScaleHeight - StatusBar.Height - 2
   grdOutlook.Move 2, 5, Me.ScaleWidth - fraOpt.Width - 10, Me.ScaleHeight - StatusBar.Height - 7
End Sub

Private Sub grdGroupBy_BeforeCommitEdit(ByVal lRow As Long, ByVal lCol As Long, eResult As EEditResults, ByVal sNewText As String, vNewValue As Variant, ByVal lConvErr As Long)
   Dim iRow As Long
   
   If grdGroupBy.ColKey(lCol) = "field" Then
      If vNewValue = "(none)" Then Exit Sub
      For iRow = 1 To grdGroupBy.RowCount
         If iRow <> lRow Then
            If vNewValue = grdGroupBy.CellValue(iRow, "field") Then
               MsgBox "'" & sNewText & "' field is already present in the field list." & vbCrLf & _
                  "Try to select another value.", vbOKOnly + vbCritical, Me.Caption
               eResult = igEditResCancel
            End If
         End If
      Next
   End If
End Sub

Private Sub grdGroupBy_ColDividerDblClick(ByVal lCol As Long, bDoDefault As Boolean)
   bDoDefault = False
End Sub

Private Sub grdGroupBy_MouseDown(ByVal Button As Integer, Shift As Integer, ByVal X As Single, ByVal Y As Single, ByVal lRow As Long, ByVal lCol As Long, bDoDefault As Boolean, ByVal bUnderControl As Boolean)
   ' special effect for the first column:
   ' start dragging just the user has pressed the mouse button
   If lCol = 1 Then
      pStartDragGroup
   End If
End Sub

Private Sub grdGroupBy_MouseUp(ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Single, ByVal Y As Single, ByVal lRow As Long, ByVal lCol As Long, bDoDefault As Boolean)
   If m_bDragRow Then
      Me.MousePointer = vbDefault
      m_bDragRow = False
      With grdGroupBy
         .Redraw = False
         .RowMode = False
         .FocusRectColor1 = vbWhite
         .FocusRectColor2 = vbBlack
         .Redraw = True
      End With
   End If
End Sub

Private Sub grdGroupBy_RequestEdit(ByVal lRow As Long, ByVal lCol As Long, ByVal iKeyAscii As Integer, bCancel As Boolean, sText As String, lMaxLength As Long, eTextEditOpt As iGrid250_75B4A91C.ETextEditFlags)
   If lCol = 1 Then bCancel = True
End Sub

Private Sub pStartDragGroup()
   If Not m_bDragRow Then
      Me.MousePointer = vbSizeNS
      
      With grdGroupBy
         .Redraw = False
         .RowMode = True
         .FocusRectColor1 = vbRed
         .FocusRectColor2 = vbRed
         .Redraw = True
      End With
      
      m_bDragRow = True
   End If
End Sub

Private Sub grdGroupBy_StartCellDrag(ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Single, ByVal Y As Single, ByVal lRow As Long, ByVal lCol As Long)
   ' start dragging if the user drag a cell from the Field or Order column
   ' this event is fired by iGrid after the user has held down the mouse button
   ' and started moving the mouse while the mouse pointer has been over a cell
   pStartDragGroup
End Sub

Private Sub grdOutlook_ColHeaderBeginDrag(ByVal lCol As Long, bCancel As Boolean)
   Select Case lCol
   Case Is <= 3
      bCancel = True
   Case Is <= 7
      bCancel = True
      MsgBox "You can't drag this column!"
   End Select
End Sub

Private Sub grdOutlook_ColHeaderClick(ByVal lCol As Long, bDoDefault As Boolean, ByVal Shift As Integer, ByVal X As Long, ByVal Y As Long)
   If lCol <= 3 Then
      ' do not sort by the columns that contains the plus/minus buttons
      ' after the grid has been grouped
      bDoDefault = False
      Exit Sub
   End If

   If m_bGroup Then
      If vbNo = MsgBox("Sorting by this column will remove your groupings.  Are you sure you want to do this?" & vbCrLf & vbCrLf & "Note: this problem is fixable in code, but I leave it as an exercise...", vbYesNo Or vbQuestion) Then
         bDoDefault = False
         Exit Sub
      Else
         ' remove grouping
         DoGroup 0
      End If
   End If
   
   t1 = GetTickCount
   StatusBar.SetText "Sorting..."
   ' iGrid will sort the contents after this event
   ' See the ContentsSorted event that displays in the status bar how long the sorting was performed
End Sub

Private Sub grdOutlook_ColHeaderEndDrag(ByVal lCol As Long, ByVal lColBefore As Long, bCancel As Boolean)
   If lColBefore <= 7 Then
      MsgBox "You can't move any columns into this area"
      bCancel = True
   End If
End Sub

Private Sub grdOutlook_ContentsSorted()
   ' raised after the user has sorted the grid interactively
   ' we set the t1 variable in the ColHeaderClick event
   t2 = GetTickCount
   StatusBar.SetText "Sorted in " & t2 - t1 & " msec"
End Sub

Private Sub grdOutlook_DblClick(ByVal lRow As Long, ByVal lCol As Long, bRequestEdit As Boolean)
   Dim lItemData As Long
   Dim bIgnoreUntilNext As Boolean
   Dim lCurLevel As Long

   If (lRow = 0) Or (lCol = 0) Then Exit Sub
      
   With grdOutlook
      
   ' Dbl clicked on a valid cell.  Find out whether it is a group or not:
   If (.ColKey(lCol) <> "body") Then Exit Sub
   
   .Redraw = False
   
   lItemData = .RowGroupStartCol(lRow)
   If (.CellExtraIcon(lRow, "body") = m_lBMinusIco) Then
      ' collapse:
      .CellExtraIcon(lRow, "body") = m_lBPlusIco
      lRow = lRow + 1
      Do While lRow <= .RowCount
         If .RowGroupStartCol(lRow) = 0 Or .RowGroupStartCol(lRow) > lItemData Then
            ' Save row visibility for the further expanding
            .RowTag(lRow) = .RowVisible(lRow)
            ' Hide row
            .RowVisible(lRow) = False
         Else
            Exit Do
         End If
         lRow = lRow + 1
      Loop
   Else
      ' expand:
      .CellExtraIcon(lRow, "body") = m_lBMinusIco
      lRow = lRow + 1
      Do While lRow <= .RowCount
         lCurLevel = .RowGroupStartCol(lRow)
         If lCurLevel = 0 Then lCurLevel = m_iSelCount + 1
         Select Case lCurLevel
         Case Is <= lItemData
            Exit Do
         Case lItemData + 1
            .RowVisible(lRow) = True
         Case Else
            .RowVisible(lRow) = .RowTag(lRow)
         End Select
         lRow = lRow + 1
      Loop
   End If
   
   .Redraw = True

   End With
End Sub

Private Sub grdOutlook_MouseDown(ByVal Button As Integer, Shift As Integer, ByVal X As Single, ByVal Y As Single, ByVal lRow As Long, ByVal lCol As Long, bDoDefault As Boolean, ByVal bUnderControl As Boolean)
   Dim lGroupLevel As Long
   
   If lRow <> 0 And lCol <> 0 Then
      If grdOutlook.RowIsGroup(lRow) Then
         lGroupLevel = grdOutlook.RowGroupStartCol(lRow)
         If ((lGroupLevel - 1) * 19 <= X) And (X <= 19 * lGroupLevel - 4) Then
            grdOutlook_DblClick lRow, lCol, False
         End If
      End If
   End If
End Sub

Private Sub lstCols_ItemCheck(Item As Integer)
   If Not m_bUseItemCheck Then Exit Sub
   grdOutlook.ColVisible(LCase(lstCols.Text)) = lstCols.Selected(Item)
End Sub

Private Sub optAll_Click()
   Dim i As Long
   
   grdOutlook.Redraw = False
   
   For i = 1 To grdOutlook.RowCount
      If Not grdOutlook.RowIsGroup(i) Then
         grdOutlook.RowHeight(i) = grdOutlook.EvaluateTextHeight(i, 14) + grdOutlook.DefaultRowHeight + 3
      End If
   Next i
   
   grdOutlook.Redraw = True
End Sub

' No preview:
Private Sub optNone_Click()
   Dim i As Long
   
   grdOutlook.Redraw = False
   
   For i = 1 To grdOutlook.RowCount
      If Not grdOutlook.RowIsGroup(i) Then
         grdOutlook.RowHeight(i) = grdOutlook.DefaultRowHeight
      End If
   Next i
   
   grdOutlook.Redraw = True
End Sub

' Preview unread only:
Private Sub optUnread_Click()
   Dim i As Long
   Dim lHeight As Long
   
   grdOutlook.Redraw = False
   
   For i = 1 To grdOutlook.RowCount
      If Not grdOutlook.RowIsGroup(i) Then
         If (grdOutlook.CellValue(i, "read") = "NOTREAD") Then
            lHeight = grdOutlook.EvaluateTextHeight(i, "body") + grdOutlook.DefaultRowHeight + 3
            grdOutlook.RowHeight(i) = lHeight
         Else
            grdOutlook.RowHeight(i) = grdOutlook.DefaultRowHeight
         End If
      End If
   Next i
   
   grdOutlook.Redraw = True
End Sub

Private Sub grdGroupBy_AfterCommitEdit(ByVal lRow As Long, ByVal lCol As Long)
   With grdGroupBy
      If .ColKey(lCol) = "field" Then
         If .CellValue(lRow, "field") = "(none)" Then
            .CellForeColor(lRow, "field") = vbButtonFace
            .CellForeColor(lRow, "order") = vbButtonFace
         Else
            .CellForeColor(lRow, "field") = vbWindowText
            .CellForeColor(lRow, "order") = vbWindowText
         End If
      End If
   End With
End Sub

Private Sub grdGroupBy_MouseMove(ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Single, ByVal Y As Single, ByVal lRow As Long, ByVal lCol As Long)
   Dim sFld As String, sOrd As String
   Dim oFldBClr As OLE_COLOR, oOrdBClr As OLE_COLOR
   Dim oFldFClr As OLE_COLOR, oOrdFClr As OLE_COLOR
   
   If m_bDragRow Then
      With grdGroupBy
         If (lRow <> .CurRow) And (lRow <> 0) Then
            .Redraw = False
            
            sFld = .CellValue(lRow, "field")
            sOrd = .CellValue(lRow, "order")
            oFldBClr = .CellBackColor(lRow, "field")
            oOrdBClr = .CellBackColor(lRow, "order")
            oFldFClr = .CellForeColor(lRow, "field")
            oOrdFClr = .CellForeColor(lRow, "order")
            
            .CellValue(lRow, "field") = .CellValue(.CurRow, "field")
            .CellValue(lRow, "order") = .CellValue(.CurRow, "order")
            .CellBackColor(lRow, "field") = .CellBackColor(.CurRow, "field")
            .CellBackColor(lRow, "order") = .CellBackColor(.CurRow, "order")
            .CellForeColor(lRow, "field") = .CellForeColor(.CurRow, "field")
            .CellForeColor(lRow, "order") = .CellForeColor(.CurRow, "order")
            
            .CellValue(.CurRow, "field") = sFld
            .CellValue(.CurRow, "order") = sOrd
            .CellBackColor(.CurRow, "field") = oFldBClr
            .CellBackColor(.CurRow, "order") = oOrdBClr
            .CellForeColor(.CurRow, "field") = oFldFClr
            .CellForeColor(.CurRow, "order") = oOrdFClr
            
            .CurRow = lRow
            
            .Redraw = True
         End If
      End With
   End If
End Sub


