package demo;

import java.awt.*;
import java.awt.event.*;

import com.japisoft.formula.*;
import com.japisoft.formula.node.*;

/**
 * Here a straightforward demonstration for expression evaluation using a little
 * AWT interface
 * 
 * @author (c) 2002 JAPISoft
 */
public class Demo extends Panel implements ActionListener, ItemListener {
	private TextField cField;

	private Choice cChoice;
	private Checkbox cCB;
	private Label cLabel;

	public Demo() {
		super();
		initUI();
	}

	Formula f;

	private void initUI() {
		setLayout(new BorderLayout());

		Button mB = new Button("Evaluate");
		Button mB2 = new Button("Clear");
		mB.setActionCommand("evaluate");
		mB2.setActionCommand("clear");

		Panel mPanel = new Panel();
		mPanel.add(mB);
		mPanel.add(mB2);

		Panel mPanel2 = new Panel();
		mPanel2.setLayout(new BorderLayout());
		mPanel2.add(cChoice = new Choice(), BorderLayout.NORTH);
		mPanel2.add(cField = new TextField(), BorderLayout.CENTER);
		mPanel2.add( cCB = new Checkbox( "High precision" ), BorderLayout.SOUTH );
		
		add(mPanel2, BorderLayout.CENTER);
		add(mPanel, BorderLayout.SOUTH);
		add(cLabel = new Label("Result"), BorderLayout.NORTH);

		mB.addActionListener(this);
		mB2.addActionListener(this);

		cField.addActionListener(this);

		FormulaFactory mFac = FormulaFactory.getInstance();
		f = mFac.getFormula();

		//

		cChoice.add("2*cos(PI) - sin(1.4)");
		cChoice.add("A=(1*57)/3.0");
		cChoice.add("2A + 1");
		cChoice.add("ERROR=1/0");
		cChoice.add("( ( 1 < 2 ) && ( 2 >=2 ) ) || ( 1 <= 0 )");
		cChoice.add("( ( true XOR true ) And true ) or true");
		cChoice.add("log10(10) * cos( degTorad( 180 ) )");
		cChoice.add("if ( 1 < 2 ) then \"OK\" else \"??\" ");
		cChoice.add("if false then ( 1 + 1 ) else ( 2+2 )");
		cChoice
				.add("(\"test1\" == \"test\") || ( strcontains( \"test1\", \"test\" ) )");
		cChoice.addItemListener(this);
	}

	public void actionPerformed(ActionEvent e) {
		String mCom = e.getActionCommand();
		if ("clear".equals(mCom)) {
			cField.setText("");
			cField.setForeground(Color.black);
			cLabel.setText("");
		} else if (("evaluate".equals(mCom)) || (e.getSource() == cField)) {
			if (("".equals(cField.getText())) || (cField.getText() == null))
				return;
			// Evaluate the expression
			try {
				cField.setForeground(Color.black);
				f.setHighPrecisionMode( cCB.getState() );
				f.setExpression(cField.getText());
				cLabel.setText(">>" + f.evaluate() + "<<");
			} catch (EvaluateException ex) {
				cLabel.setText("Error : " + ex.getMessage());
				cField.setForeground(Color.red);
				cField.setCaretPosition(ex.getPos());
			}
		}
	}

	public void itemStateChanged(ItemEvent e) {
		String s = e.getItem().toString();
		cField.setText(s);
	}

}

