/*
 * Decompiled with CFR 0.152.
 */
package org.aris.hldb;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import org.aris.hldb.pools.ConnectionProviderI;

class AvailCS {
    private Stack avail = new Stack();
    private int cs_count = 0;
    private ConnectionProviderI hlcon;
    private int rst;
    private int rsc;
    private String sql;
    private int m_maxInPool = 100;

    public int getMaxInPool() {
        return this.m_maxInPool;
    }

    public void setMaxInPool(int maxInPool) {
        this.m_maxInPool = maxInPool;
    }

    public AvailCS(ConnectionProviderI hl_con, String _sql_, int resultSetType, int resultSetConcurency, int maxInPool) {
        this.hlcon = hl_con;
        this.rst = resultSetType;
        this.rsc = resultSetConcurency;
        this.sql = _sql_;
        this.m_maxInPool = maxInPool;
    }

    public AvailCS(ConnectionProviderI hl_con, String _sql_, int maxInPool) {
        this.hlcon = hl_con;
        this.rst = 1003;
        this.rsc = 1007;
        this.sql = _sql_;
        this.m_maxInPool = maxInPool;
    }

    public CallableStatement allocCS() throws SQLException {
        CallableStatement cs;
        if (this.avail.isEmpty()) {
            Connection con = this.hlcon.allocConnection();
            cs = con.prepareCall(this.sql, this.rst, this.rsc);
            ++this.cs_count;
        } else {
            cs = (CallableStatement)this.avail.pop();
        }
        return cs;
    }

    public void freeCS(CallableStatement cs) {
        if (this.avail.size() < this.m_maxInPool) {
            try {
                cs.clearParameters();
                cs.clearWarnings();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.avail.push(cs);
        } else {
            try {
                try {
                    cs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            finally {
                --this.cs_count;
            }
        }
    }

    public int getCSCount() {
        return this.cs_count;
    }

    public String getSql() {
        return this.sql;
    }
}

