#ifndef __sound__
#define __sound__
#include <globals.h>
#include <CError.h>
#include <CMP3.h>
#include <CWav.h>
#include <CMidi.h>

#ifdef DEBUG_NOVA
#pragma comment(lib,"CSoundD.lib")
#endif
#ifndef DEBUG_NOVA
#pragma comment(lib,"CSound.lib")
#endif


class CSound
{
private:
	IDirectMusicLoader8 *Loader;
	IDirectMusicPerformance8 *Perf;
	int channels;
	CError *error;
	int Create(int num_channels, CError *err);
	int Destroy();
public:
	int erro;
	CSound();
	CSound(int num_channels, CError *err);
	~CSound();
	CWav *Create_Wav(WCHAR *file);
	int Destroy_Wav(CWav *wav);
	CMidi *Create_Midi(WCHAR *file);
	int Destroy_Midi(CMidi *midi);
	CMP3 *Create_MP3(WCHAR *file);
	int Destroy_MP3(CMP3 *MP3);
	int Stop_All();
};

#endif
