#include <CInput.h>
CInput::CInput()
{
	input=NULL;
	keyboard=NULL;
	mouse_x=0;
	mouse_y=0;
	mouse_z=0;
	r_button=0;
	l_button=0;
	m_button=0;
	for(int w=0;w<256;w++)
		input_buff[w]=0;
}

CInput::~CInput()
{
	this->destroy();
}

bool CInput::keydown(int key)
{
	if(key>256)
	{
		if(key==RIGHT_MOUSE)
		{
			if(r_button==1)
				return true;
		}
		if(key==LEFT_MOUSE)
		{
			if(l_button==1)
				return true;
		}
		if(key==MIDDLE_MOUSE)
		{
			if(m_button==1)
				return true;
		}
		return false;
	}
	if(input_buff[key]&0x80)
		return true;
	return false;
}

int CInput::xaxis()
{
	return mouse_x;
}

int CInput::yaxis()
{
	return mouse_y;
}

int CInput::zaxis()
{
	return mouse_z;
}

int CInput::create(HINSTANCE hinstance,HWND main)
{
	error=DirectInput8Create(hinstance,DIRECTINPUT_VERSION,IID_IDirectInput8,(void**)&input,NULL);
	if(FAILED(error))
		return D_ERROR;

	error=input->CreateDevice(GUID_SysKeyboard, &keyboard, NULL); 
	if(FAILED(error))
		return D_ERROR;

	error=keyboard->SetDataFormat(&c_dfDIKeyboard);
	if(FAILED(error))
		return D_ERROR;

	error=keyboard->SetCooperativeLevel(main,DISCL_FOREGROUND|DISCL_NONEXCLUSIVE); 
	if(FAILED(error))
		return D_ERROR;

	DIPROPDWORD  dip;
	dip.diph.dwSize=sizeof(DIPROPDWORD);
	dip.diph.dwHeaderSize=sizeof(DIPROPHEADER);
	dip.diph.dwObj=0;
	dip.diph.dwHow=DIPH_DEVICE;
	dip.dwData=32;
	error=keyboard->SetProperty(DIPROP_BUFFERSIZE,&dip.diph);
	if(FAILED(error))
		return D_ERROR;

	keyboard->Acquire();
	DWORD Items = INFINITE; 
	keyboard->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),NULL,&Items,0);

	error=input->CreateDevice(GUID_SysMouse, &mouse, NULL);
	if(FAILED(error))
		return D_ERROR;

	error=mouse->SetDataFormat(&c_dfDIMouse);
	if(FAILED(error))
		return D_ERROR;

	error=mouse->SetCooperativeLevel(main,DISCL_EXCLUSIVE|DISCL_FOREGROUND);
	if(FAILED(error))
		return D_ERROR;

	dip.diph.dwSize=sizeof(DIPROPDWORD);
	dip.diph.dwHeaderSize=sizeof(DIPROPHEADER);
	dip.diph.dwObj=0;
	dip.diph.dwHow=DIPH_DEVICE;
	dip.dwData=DIPROPAXISMODE_REL;
	error=mouse->SetProperty(DIPROP_AXISMODE,&dip.diph);
	if(FAILED(error))
		return D_ERROR;

	dip.diph.dwSize=sizeof(DIPROPDWORD);
	dip.diph.dwHeaderSize=sizeof(DIPROPHEADER);
	dip.diph.dwObj=0;
	dip.diph.dwHow=DIPH_DEVICE;
	dip.dwData=32;
	error=mouse->SetProperty(DIPROP_BUFFERSIZE,&dip.diph);
	if(FAILED(error))
		return D_ERROR;

	return D_FINE;
}

int CInput::destroy()
{
	if(input)
	{
		if(keyboard)
		{
			keyboard->Unacquire();
			keyboard->Release();
			keyboard=NULL;
		}
		if(mouse)
		{
			mouse->Unacquire();
			mouse->Release();
			mouse=NULL;
		}
		input->Release();
		input=NULL;
	}
	return D_FINE;
}

int CInput::get_mouse()
{
	DIDEVICEOBJECTDATA data;
	DWORD numelements=1;
	while(DIERR_INPUTLOST==mouse->Acquire());
	mouse_x=0;
	mouse_y=0;
	mouse_z=0;
	numelements=1;
	while(numelements>0)
	{
	    numelements=1;
		error=mouse->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),&data,&numelements,0);
		if(FAILED(error))
		{
			return D_ERROR;
		}
		if(numelements==0)
			break;
		switch (data.dwOfs) 
		{
			case DIMOFS_X: 
				mouse_x=data.dwData;
			    break;
			case DIMOFS_Y: 
	            mouse_y=data.dwData;
		        break;
			case DIMOFS_Z: 
				mouse_z=data.dwData;
	            break;
		    case DIMOFS_BUTTON0:
				if(data.dwData&0x80)
					l_button=1;
				else
					l_button=0;
				break;
			case DIMOFS_BUTTON1:
				if(data.dwData&0x80)
					r_button=1;
				else
					r_button=0;
				break;
			case DIMOFS_BUTTON2:
				if(data.dwData&0x80)
					m_button=1;
				else
					m_button=0;
				break;
			case DIMOFS_BUTTON3:
				if(data.dwData&0x80)
					m_button=1;
				else
					m_button=0;
				break;
		}
	}
	return D_FINE;
}

int CInput::get_keyboard()
{
	DIDEVICEOBJECTDATA data;
	DWORD numelements=1;

	while(DIERR_INPUTLOST==keyboard->Acquire());
	while(numelements>0)
	{
		numelements=1;
		error=keyboard->GetDeviceData(sizeof(DIDEVICEOBJECTDATA),&data,&numelements,0);
		if(FAILED(error))
		{
			return D_ERROR;
		}
		if(numelements==0)
			break;
		input_buff[data.dwOfs]=data.dwData;
	}
	return D_FINE;
}