/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;

public class MonteCarlo
extends CardGame {
    private int a;
    private boolean b;
    private int c;

    public MonteCarlo(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Monte Carlo", deck, gameTable, n2, n3);
    }

    protected void SetupCells() {
        for (int i2 = 0; i2 < 27; ++i2) {
            this.Table.AddCell(new TableCell());
        }
    }

    protected void Layout() {
        this.Table.Resize(12 + (6 + this.CardWidth) * 7, 10 + (4 + this.CardHeight) * 5);
        int n2 = this.Table.getSize().height - this.CardHeight - 5;
        for (int i2 = 0; i2 < 5; ++i2) {
            int n3 = i2 * 5;
            int n4 = 5 + i2 * (4 + this.CardHeight);
            for (int i3 = 0; i3 < 5; ++i3) {
                this.Table.GetCell(n3 + i3).SetPos(6 + i3 * (6 + this.CardWidth), n4);
            }
        }
        this.Table.GetCell(25).SetPos(6 + 6 * (6 + this.CardWidth), n2);
        this.Table.GetCell(26).SetPos(6 + 6 * (6 + this.CardWidth), 5);
    }

    protected void PlaceCards() {
        TableCell tableCell;
        int n2 = 52;
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int i3 = 0; i3 < 5; ++i3) {
                Card card = this.MyDeck.Pick();
                tableCell = this.Table.GetCell(i3 + i2 * 5);
                CardWrapper cardWrapper = this.Table.WrapCard(card);
                tableCell.AddCard(cardWrapper);
                cardWrapper.SetFrontUp(true);
                --n2;
            }
        }
        tableCell = this.Table.GetCell(25);
        while (n2-- > 0) {
            Card card = this.MyDeck.Pick();
            CardWrapper cardWrapper = this.Table.WrapCard(card);
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(false);
        }
        this.a = 0;
        this.b = false;
        this.Table.StatusMsg("Pairs removed: " + this.a);
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
        CardWrapper cardWrapper2;
        UndoStep undoStep = this.NewMove(true);
        if (n2 == 25) {
            this.g(undoStep);
            this.h(undoStep);
        } else if (n2 != 26 && (cardWrapper2 = this.Table.GetCell(n2).GetWrapper(-1)) != null) {
            if (cardWrapper2.HasFlags(4)) {
                cardWrapper2.ClearFlags(4);
                this.b = false;
            } else if (this.b) {
                this.f(n2, cardWrapper2, undoStep);
            } else {
                cardWrapper2.AddFlags(4);
                this.b = true;
                this.c = n2;
            }
            this.Table.StatusMsg("Pairs removed: " + this.a);
            this.Table.repaint();
            if (this.a >= 26) {
                this.GameOver(true);
            }
        }
        this.AddUndo(undoStep);
    }

    private void f(int n2, CardWrapper cardWrapper, UndoStep undoStep) {
        CardWrapper cardWrapper2 = this.Table.GetCell(this.c).GetWrapper(-1);
        int n3 = this.c / 5;
        int n4 = this.c % 5;
        int n5 = n2 / 5;
        int n6 = n2 % 5;
        if (n3 - 1 <= n5 && n5 <= n3 + 1 && n4 - 1 <= n6 && n6 <= n4 + 1 && cardWrapper2.GetCard().GetValue() == cardWrapper.GetCard().GetValue()) {
            TableCell tableCell = this.Table.GetCell(26);
            cardWrapper2.ClearFlags(4);
            this.b = false;
            undoStep.AddMove(cardWrapper2);
            undoStep.AddMove(cardWrapper);
            tableCell.AddCard(cardWrapper2);
            tableCell.AddCard(cardWrapper);
            ++this.a;
            return;
        }
        this.Beep();
    }

    private void g(UndoStep undoStep) {
        block0: for (int i2 = 0; i2 < 25; ++i2) {
            TableCell tableCell = this.Table.GetCell(i2);
            if (tableCell.GetCard(-1) != null) continue;
            for (int i3 = i2 + 1; i3 < 25; ++i3) {
                TableCell tableCell2 = this.Table.GetCell(i3);
                CardWrapper cardWrapper = tableCell2.GetWrapper(-1);
                if (cardWrapper == null) continue;
                undoStep.AddMove(cardWrapper, tableCell2);
                tableCell.AddCard(cardWrapper);
                continue block0;
            }
        }
    }

    private void h(UndoStep undoStep) {
        TableCell tableCell = this.Table.GetCell(25);
        for (int i2 = 0; i2 < 25; ++i2) {
            TableCell tableCell2 = this.Table.GetCell(i2);
            if (tableCell2.GetCard(-1) != null) continue;
            CardWrapper cardWrapper = tableCell.GetWrapper(-1);
            if (cardWrapper == null) break;
            undoStep.AddMove(cardWrapper, tableCell);
            tableCell2.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(true);
        }
    }

    public void Undo() {
        super.Undo();
        this.a = this.Table.GetCell(26).GetCardsCount() / 2;
        this.Table.StatusMsg("Pairs removed: " + this.a);
    }
}

