/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Rectangle;
import java.util.Vector;

public class Klondike
extends CardGame {
    public Klondike(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Klondike", deck, gameTable, n2, n3);
    }

    protected void SetupCells() {
        int n2;
        for (n2 = 0; n2 < 9; ++n2) {
            this.Table.AddCell(new TableCell());
        }
        for (n2 = 0; n2 < 4; ++n2) {
            TableCell tableCell = new TableCell();
            tableCell.SetBackground(this.MyDeck.GetPlaceholder(n2));
            this.Table.AddCell(tableCell);
        }
    }

    protected void Layout() {
        int n2;
        this.Table.Resize(12 + (6 + this.CardWidth) * 7, (int)((double)this.CardHeight * 3.5));
        float f2 = (float)((double)this.CardWidth / 88.0);
        int n3 = (int)(10.0f * f2);
        int n4 = this.Table.getBounds().height - this.CardHeight - 5;
        for (n2 = 0; n2 < 7; ++n2) {
            TableCell tableCell = this.Table.GetCell(n2);
            tableCell.SetPos(6 + n2 * (6 + this.CardWidth), 5);
            tableCell.SetCardSpacing(0, n3);
        }
        this.Table.GetCell(7).SetPos(6, n4);
        this.Table.GetCell(8).SetPos(12 + this.CardWidth, n4);
        for (n2 = 0; n2 < 4; ++n2) {
            this.Table.GetCell(9 + n2).SetPos(6 + (n2 + 3) * (6 + this.CardWidth), n4);
        }
    }

    protected void PlaceCards() {
        TableCell tableCell;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0};
        int n2 = 52;
        for (int i2 = 0; i2 < 7; ++i2) {
            for (int i3 = 0; i3 < 7; ++i3) {
                if (nArray[i3] > i3) continue;
                tableCell = this.Table.GetCell(i3);
                CardWrapper cardWrapper = this.Table.WrapCard(this.MyDeck.Pick());
                tableCell.AddCard(cardWrapper);
                cardWrapper.SetFrontUp(nArray[i3] == i3);
                int n3 = i3;
                nArray[n3] = nArray[n3] + 1;
                --n2;
            }
        }
        tableCell = this.Table.GetCell(7);
        while (n2-- > 0) {
            CardWrapper cardWrapper = this.Table.WrapCard(this.MyDeck.Pick());
            tableCell.AddCard(cardWrapper);
            cardWrapper.SetFrontUp(false);
        }
    }

    private boolean e(Card card, int n2) {
        Card card2 = this.Table.GetCell(n2).GetCard(-1);
        int n3 = card.GetValue();
        int n4 = card.GetColor();
        int n5 = card.GetSuit();
        return card2 == null && (n3 == 1 && n2 >= 9 || n3 == 13 && n2 < 7) || card2 != null && (n2 < 9 && n4 != card2.GetColor() && card2.GetValue() == n3 + 1 || n2 >= 9 && card2.GetSuit() == n5 && card2.GetValue() == n3 - 1);
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
        if (n2 == 7) {
            TableCell tableCell = this.Table.GetCell(7);
            TableCell tableCell2 = this.Table.GetCell(8);
            UndoStep undoStep = this.NewMove(true);
            for (int i2 = 0; i2 < 3; ++i2) {
                CardWrapper cardWrapper2 = tableCell.PopCard();
                if (cardWrapper2 == null) {
                    while ((cardWrapper2 = tableCell2.PopCard()) != null) {
                        undoStep.AddMove(cardWrapper2, tableCell2);
                        cardWrapper2.SetFrontUp(false);
                        tableCell.AddCard(cardWrapper2);
                    }
                    cardWrapper2 = tableCell.PopCard();
                }
                if (cardWrapper2 == null) continue;
                undoStep.AddMove(cardWrapper2, tableCell);
                cardWrapper2.SetFrontUp(true);
                tableCell2.AddCard(cardWrapper2);
            }
            this.AddUndo(undoStep);
            if (cardWrapper != null) {
                this.Table.invalidate();
            }
        }
    }

    public void CardDblClick(CardWrapper cardWrapper, int n2, int n3) {
        if (n2 != 7 && n2 <= 8) {
            TableCell tableCell = this.Table.GetCell(n2);
            CardWrapper cardWrapper2 = tableCell.PopCard();
            Card card = cardWrapper2.GetCard();
            boolean bl = false;
            UndoStep undoStep = this.NewMove();
            for (int i2 = 0; !bl && i2 < 4; ++i2) {
                if (!this.e(card, 9 + i2)) continue;
                undoStep.AddMove(cardWrapper2, tableCell);
                this.Table.GetCell(9 + i2).AddCard(cardWrapper2);
                bl = true;
            }
            if (bl) {
                cardWrapper2 = tableCell.GetWrapper(-1);
                if (cardWrapper2 != null) {
                    undoStep.AddCard(cardWrapper2);
                    cardWrapper2.SetFrontUp(true);
                }
                this.Table.invalidate();
                this.CheckGameOver();
            } else {
                tableCell.AddCard(cardWrapper2);
                this.Beep();
            }
            this.AddUndo(undoStep);
        }
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
        TableCell tableCell = this.Table.GetCell(n2);
        if (n2 < 7) {
            if (cardWrapper == tableCell.GetWrapper(-1)) {
                cardWrapper.SetMoving(true);
                return;
            }
            int n6 = tableCell.GetCardsCount();
            for (int i2 = 0; i2 < n6; ++i2) {
                CardWrapper cardWrapper2 = tableCell.GetWrapper(i2);
                if (!cardWrapper2.GetFrontUp()) continue;
                cardWrapper2.SetMoving(true);
            }
            return;
        }
        if (n2 == 8) {
            tableCell.GetWrapper(-1).SetMoving(true);
        }
    }

    public void CardMouseUp(int n2, int n3) {
        Vector vector = new Vector();
        this.GetMovingCards(vector);
        if (vector.size() > 0) {
            int n4;
            Object object;
            Rectangle rectangle = new Rectangle();
            Object object2 = null;
            int n5 = 0;
            int n6 = 0;
            this.GetCardsRect(vector, rectangle);
            CardWrapper cardWrapper = (CardWrapper)vector.get(0);
            int n7 = vector.size() == 1 ? 12 : 6;
            for (int i2 = 0; i2 <= n7; ++i2) {
                if (i2 == 7 || i2 == 8 || (object = this.Table.GetCell(i2)) == cardWrapper.GetCell() || (n4 = ((TableCell)object).CoverArea(rectangle)) <= n5) continue;
                object2 = object;
                n5 = n4;
                n6 = i2;
            }
            if (n5 > 25 && this.e(cardWrapper.GetCard(), n6)) {
                TableCell tableCell = cardWrapper.GetCell();
                object = this.NewMove();
                for (n4 = 0; n4 < vector.size(); ++n4) {
                    cardWrapper = (CardWrapper)vector.get(n4);
                    ((UndoStep)object).AddMove(cardWrapper);
                    ((TableCell)object2).AddCard(cardWrapper);
                }
                cardWrapper = tableCell.GetWrapper(-1);
                if (cardWrapper != null) {
                    ((UndoStep)object).AddCard(cardWrapper);
                    cardWrapper.SetFrontUp(true);
                }
                this.AddUndo((UndoStep)object);
            }
        }
        super.CardMouseUp(n2, n3);
        this.CheckGameOver();
    }

    public void CheckGameOver() {
        block2: {
            for (int i2 = 9; i2 <= 12; ++i2) {
                Card card = this.Table.GetCell(i2).GetCard(-1);
                if (card != null && card.GetValue() >= 13) {
                    continue;
                }
                break block2;
            }
            this.GameOver(true);
        }
    }
}

