/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire.Games;

import WizSolitaire.Card;
import WizSolitaire.CardGame;
import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Rectangle;
import java.util.Vector;

public class BakersDozen
extends CardGame {
    private int a;

    public BakersDozen(Deck deck, GameTable gameTable, int n2, int n3) {
        super("Baker's Dozen", deck, gameTable, n2, n3);
    }

    protected void SetupCells() {
        for (int i2 = 0; i2 < 17; ++i2) {
            this.Table.AddCell(new TableCell());
        }
    }

    protected void Layout() {
        TableCell tableCell;
        int n2;
        this.Table.Resize(12 + (10 + this.CardWidth << 3), 10 + (15 + this.CardHeight << 2));
        float f2 = (float)((double)this.CardWidth / 88.0);
        int n3 = (int)(14.0f * f2);
        for (n2 = 0; n2 < 4; ++n2) {
            tableCell = this.Table.GetCell(n2 + 0);
            tableCell.SetBackground(this.MyDeck.GetPlaceholder(n2));
            tableCell.SetPos(6 + 7 * (10 + this.CardWidth), 5 + n2 * (this.CardHeight + 15));
        }
        for (n2 = 0; n2 < 7; ++n2) {
            tableCell = this.Table.GetCell(n2 + 4);
            tableCell.SetPos(6 + n2 * (10 + this.CardWidth), 5);
            tableCell.SetCardSpacing(0, n3);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            tableCell = this.Table.GetCell(n2 + 4 + 7);
            tableCell.SetPos(6 + n2 * (10 + this.CardWidth), 5 + 2 * (this.CardHeight + 15));
            tableCell.SetCardSpacing(0, n3);
        }
    }

    protected void PlaceCards() {
        for (int i2 = 4; i2 <= 16; ++i2) {
            TableCell tableCell = this.Table.GetCell(i2);
            for (int i3 = 0; i3 < 4; ++i3) {
                Card card = this.MyDeck.Pick();
                CardWrapper cardWrapper = this.Table.WrapCard(card);
                tableCell.AddCard(cardWrapper, card.GetValue() != 13);
                cardWrapper.SetFrontUp(true);
            }
        }
        this.a = 0;
    }

    private boolean e(Card card, int n2) {
        Card card2 = this.Table.GetCell(n2).GetCard(-1);
        int n3 = card.GetValue();
        boolean bl = false;
        if (n2 >= 0 && n2 <= 3) {
            bl = card2 == null && n3 == 1 || card2 != null && n3 == card2.GetValue() + 1 && card.GetSuit() == card2.GetSuit();
        } else if (n2 >= 4 && n2 <= 16) {
            bl = card2 != null && n3 == card2.GetValue() - 1;
        }
        return bl;
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
        TableCell tableCell = this.Table.GetCell(n2);
        if (cardWrapper == tableCell.GetWrapper(-1) && n2 >= 4 && n2 <= 16) {
            cardWrapper.SetMoving(true);
        }
    }

    public void CardMouseUp(int n2, int n3) {
        Vector vector = new Vector();
        this.GetMovingCards(vector);
        if (vector.size() > 0) {
            Rectangle rectangle = new Rectangle();
            TableCell tableCell = null;
            int n4 = 0;
            int n5 = 0;
            this.GetCardsRect(vector, rectangle);
            CardWrapper cardWrapper = (CardWrapper)vector.get(0);
            for (int i2 = 0; i2 <= 16; ++i2) {
                int n6;
                TableCell tableCell2 = this.Table.GetCell(i2);
                if (tableCell2 == cardWrapper.GetCell() || (n6 = tableCell2.CoverArea(rectangle)) <= n4) continue;
                tableCell = tableCell2;
                n4 = n6;
                n5 = i2;
            }
            if (n4 > 25 && this.e(cardWrapper.GetCard(), n5)) {
                UndoStep undoStep = this.NewMove();
                for (int i3 = 0; i3 < vector.size(); ++i3) {
                    cardWrapper = (CardWrapper)vector.get(i3);
                    undoStep.AddMove(cardWrapper);
                    tableCell.AddCard(cardWrapper);
                }
                this.AddUndo(undoStep);
                if (tableCell.GetCardsCount() >= 13 && ++this.a == 4) {
                    this.GameOver(true);
                }
            }
        }
        super.CardMouseUp(n2, n3);
    }

    public void Undo() {
        super.Undo();
        this.a = 0;
        for (int i2 = 0; i2 <= 3; ++i2) {
            if (this.Table.GetCell(i2).GetCardsCount() < 13) continue;
            ++this.a;
        }
    }
}

