/*
 * Decompiled with CFR 0.152.
 */
package WizSolitaire;

import WizSolitaire.CardWrapper;
import WizSolitaire.Deck;
import WizSolitaire.GameTable;
import WizSolitaire.Settings;
import WizSolitaire.TableCell;
import WizSolitaire.UndoStep;
import java.awt.Rectangle;
import java.util.Vector;

public abstract class CardGame {
    protected String Name;
    protected Deck MyDeck;
    protected GameTable Table;
    protected int CardWidth;
    protected int CardHeight;
    protected int Played = 0;
    protected int Won = 0;
    protected boolean HasBeenPlayed = false;
    protected int PlayTime = 0;
    protected int TotalPlayTime = 0;
    protected Vector UndoSteps = new Vector();

    public CardGame(String string, Deck deck, GameTable gameTable, int n2, int n3) {
        this.Name = string;
        this.MyDeck = deck;
        this.Table = gameTable;
        this.CardWidth = n2;
        this.CardHeight = n3;
    }

    protected abstract void SetupCells();

    protected abstract void Layout();

    protected abstract void PlaceCards();

    public String GetName() {
        return this.Name;
    }

    public void LoadSettings(Settings settings) {
        this.LoadSettings(settings, this.Name);
    }

    public void SaveSettings(Settings settings) {
        this.SaveSettings(settings, this.Name);
    }

    protected void LoadSettings(Settings settings, String string) {
        this.Played = settings.getInt(string + ".Played", 0);
        this.Won = settings.getInt(string + ".Won", 0);
        this.TotalPlayTime = settings.getInt(string + ".PlayTime", 0);
    }

    protected void SaveSettings(Settings settings, String string) {
        settings.setInt(string + ".Played", this.Played);
        settings.setInt(string + ".Won", this.Won);
        settings.setInt(string + ".PlayTime", this.TotalPlayTime);
    }

    public void Start() {
        this.HasBeenPlayed = false;
        this.PlayTime = 0;
        this.Table.Clear();
        this.MyDeck.Shuffle();
        this.ResetUndo();
        this.SetupCells();
        this.PlaceCards();
        this.Layout();
        this.Table.invalidate();
    }

    public void ResizeDeck(int n2, int n3) {
        this.CardWidth = n2;
        this.CardHeight = n3;
        this.MyDeck.Resize(n2, n3);
        this.Layout();
        this.Table.invalidate();
        this.Layout();
    }

    public void ClearFlagsAll(int n2) {
        int n3 = this.Table.GetCellCount();
        while (--n3 >= 0) {
            TableCell tableCell = this.Table.GetCell(n3);
            int n4 = tableCell.GetCardsCount();
            while (--n4 >= 0) {
                tableCell.GetWrapper(n4).ClearFlags(n2);
            }
        }
    }

    public void CardMouseUp(int n2, int n3) {
        this.ClearFlagsAll(2);
        this.Table.invalidate();
    }

    public void CardClick(CardWrapper cardWrapper, int n2, int n3) {
    }

    public void CardDblClick(CardWrapper cardWrapper, int n2, int n3) {
    }

    public void CardMouseDown(CardWrapper cardWrapper, int n2, int n3, int n4, int n5) {
    }

    public void GetMovingCards(Vector vector) {
        int n2 = this.Table.GetCellCount();
        while (--n2 >= 0) {
            TableCell tableCell = this.Table.GetCell(n2);
            int n3 = tableCell.GetCardsCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                CardWrapper cardWrapper = tableCell.GetWrapper(i2);
                if (!cardWrapper.IsMoving()) continue;
                vector.add(cardWrapper);
            }
        }
    }

    public void GetCardsRect(Vector vector, Rectangle rectangle) {
        rectangle.x = 10000000;
        rectangle.y = 10000000;
        rectangle.width = -1000000;
        rectangle.height = -1000000;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Rectangle rectangle2 = ((CardWrapper)vector.get(i2)).getBounds();
            if (rectangle2.x < rectangle.x) {
                rectangle.x = rectangle2.x;
            }
            if (rectangle2.y < rectangle.y) {
                rectangle.y = rectangle2.y;
            }
            if (rectangle2.x + rectangle2.width - 1 > rectangle.width) {
                rectangle.width = rectangle2.x + rectangle2.width - 1;
            }
            if (rectangle2.y + rectangle2.height - 1 <= rectangle.height) continue;
            rectangle.height = rectangle2.y + rectangle2.height - 1;
        }
    }

    public void GameOver(boolean bl) {
        if (bl) {
            ++this.Won;
        }
        this.TotalPlayTime += this.PlayTime;
        this.Table.GameOver(bl);
        this.ResetUndo();
    }

    public void CountAsPlayed() {
        if (!this.HasBeenPlayed) {
            this.HasBeenPlayed = true;
            this.Table.StartPlayTimer();
            ++this.Played;
        }
    }

    public long Tick() {
        return ++this.PlayTime;
    }

    public void Beep() {
    }

    protected void ResetUndo() {
        this.UndoSteps.clear();
        this.Table.GetWin().menuUndo.setEnabled(false);
    }

    protected UndoStep NewMove() {
        return this.NewMove(false);
    }

    protected UndoStep NewMove(boolean bl) {
        UndoStep undoStep = new UndoStep();
        undoStep.BeginStep(bl);
        return undoStep;
    }

    protected void AddUndo(UndoStep undoStep) {
        undoStep.EndStep();
        if (undoStep.IsValid()) {
            this.UndoSteps.add(undoStep);
            this.Table.GetWin().menuUndo.setEnabled(true);
        }
    }

    public void Undo() {
        if (this.UndoSteps.size() > 0) {
            UndoStep undoStep = (UndoStep)this.UndoSteps.lastElement();
            undoStep.Undo();
            this.UndoSteps.remove(undoStep);
            this.Table.repaint();
            this.Table.GetWin().menuUndo.setEnabled(this.UndoSteps.size() > 0);
        }
    }
}

