.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtConfigure-Widget XtMove-Widget XtResize-Widget wid-get
.na
.TH XtConfigureWidget __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtConfigureWidget, XtMoveWidget, XtResizeWidget \- move and resize widgets
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtConfigureWidget(Widget \fIw\fP, Position \fIx\fP, Position \fIy\fP,
Dimension \fIwidth\fP, Dimension \fIheight\fP, Dimension \fIborder_width\fP);
.HP
void XtMoveWidget(Widget \fIw\fP, Position \fIx\fP, Position \fIy\fP);
.HP
void XtResizeWidget(Widget \fIw\fP, Dimension \fIwidth\fP, Dimension
\fIheight\fP, Dimension \fIborder_width\fP);
.HP
void XtResizeWindow(Widget \fIw\fP);
.SH ARGUMENTS
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
.br
.ns
.IP \fIborder_width\fP 1i
Specify the new widget size.
.IP \fIw\fP 1i
Specifies the widget.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the new widget x and y coordinates.
.SH DESCRIPTION
The
.B XtConfigureWidget
function returns immediately if the specified geometry fields
are the same as the old values.
Otherwise,
.B XtConfigureWidget
writes the new x, y, width, height, and border_width values
into the widget and, if the widget is realized, makes an Xlib
.B XConfigureWindow
call on the widget's window.
.LP
If either the new width or height is different from its old value,
.B XtConfigureWidget
calls the widget's resize procedure to notify it of the size change;
otherwise, it simply returns.
.LP
The
.B XtMoveWidget
function returns immediately if the specified geometry fields
are the same as the old values.
Otherwise,
.B XtMoveWidget
writes the new x and y values into the widget
and, if the widget is realized, issues an Xlib
.B XMoveWindow
call on the widget's window.
.LP
The
.B XtResizeWidget
function returns immediately if the specified geometry fields
are the same as the old values.
Otherwise,
.B XtResizeWidget
writes the new width, height, and border_width values into
the widget and, if the widget is realized, issues an
.B XConfigureWindow
call on the widget's window.
.LP
If the new width or height are different from the old values,
.B XtResizeWidget
calls the widget's resize procedure to notify it of the size change.
.LP
The
.B XtResizeWindow
function calls the
.B XConfigureWindow
Xlib function to make the window of the specified widget match its width,
height, and border width.
This request is done unconditionally because there is no way to tell if these
values match the current values.
Note that the widget's resize procedure is not called.
.LP
There are very few times to use
.BR XtResizeWindow ;
instead, you should use
.BR XtResizeWidget .
.SH "SEE ALSO"
XtMakeGeometryRequest(__libmansuffix__),
XtQueryGeometry(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
