//
//  XTHtmlTagParserError.m
//  TadsTerp
//
//  Created by Rune Berg on 02/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTHtmlTagParserError.h"


@implementation XTHtmlTagParserError

- (id)initWithMessage:(NSString *)message atIndex:(NSUInteger) index
{
    self = [super init];
    if (self) {
		_message = message;
		_index = index;
    }
    return self;
}

+ (instancetype)errorWithMessage:(NSString *)message atIndex:(NSUInteger) index
{
	XTHtmlTagParserError *error = [[XTHtmlTagParserError alloc] initWithMessage:message atIndex:index];
	return error;
}

+ (instancetype)unexpectedCharacter:(unichar)ch atIndex:(NSUInteger) index
{
	NSString *message = [NSString stringWithFormat:@"Unexpected character '%C'", ch];
	XTHtmlTagParserError *error = [XTHtmlTagParserError errorWithMessage:message atIndex:index];
	return error;
}

@end
