#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

whiteCoat : Person 'tall balding avunclar white-coated man (in) (a) white man/coat' 
   'tall white-coated man' 
  "He's tall, balding, and slightly avuncular looking. "
  isHim = true
  killPlayer()
  {    
    if(canSee(gPlayerChar))
    {
       "\bThe tall man in a white coat comes striding up to you, accompanied 
       by your erstwhile guardian, brandishing a large machine pistol. "; 
       guardian.moveIntoForTravel(location);     
       guardian.setCurState(guardianPistol);
       pistol.moveInto(guardian);
       if(redButton.daemonID != nil)
       {
         redButton.daemonID.removeEvent();
         redButton.daemonID = nil;
         sirenNoise.stop();
       }
       if(gRevealed('yes-circle'))
         initiateConversation(whiteCoatTalking, 'sign-node');
       else
         initiateConversation(whiteCoatTalking, whiteNode);    
    }
  }
  startKillDaemon()
  {
    if(daemonID == nil){
      daemonID = new Daemon(self, &killDaemon, 1);
      waitingTurns = 5;
    }
  }
  daemonID = nil
  killDaemon()
  {
    if(canSee(gPlayerChar))
    {
      daemonID.removeEvent();
      daemonID = nil;
      killPlayer;
    }
    else
     if(--waitingTurns == 0)
     {
       daemonID.removeEvent();
       daemonID = nil;
       moveIntoForTravel(nil);
     }
  }
  waitingTurns = 0
  smellDesc = "You can't detect anything very distinctive about his odour. "
  cannotKissActorMsg = 'No, not your type, he\'s definitely not your type. ' 
  uselessToAttackMsg = 'You might overpower him if he was
   alone, but unfortunately he\'s not. '
;

+ statement : Readable 'statement' 'statement'
  "It reads, <q>I hereby certify that I have drawn a square circle, thereby
   demonstrating beyond all reasonable doubt that the feat is easily achievable.
   I further certify that any references to square circles I may have made in 
   the past or may make in the future are to be understood in the light of the
   fact that I have demonstrated beyond any shadow of a doubt that this figure 
   is easy to draw. I thus wish it to be known that any talk of drawing a 
    square circle on my part is to 
   be understood as a figure of speech denoting an apparent difficulty that is 
   in fact easily overcome by the intelligent application of reason.</q>
   <.reveal squarecircle-statement><<achieve()>>"
   achieve() { achievement.awardPointsOnce(); }
   
   achievement : Achievement { +1 "reading the statement the white-coated man
     wanted you to sign" }
;

+ GiveShowTopic [document, pandraPicture]
  topicResponse()
  {
    "The white-coated man snatches the document from your grasp, crying,
     <q>How the <i>hell</i> did you get hold of this? Well, now you know
     who you are, and the game's well and truly up!</q> He turns to the
     guardian and snaps, <q>Shoot him!</q><.p>
     The guardian wastes no time in obeying.<.p>";
     endGame(ftDeath);
  }
;

+ GiveShowTopic [whiteEnvelope, brownEnvelope]
  "<q>What are you doing with this?</q> he frowns. <q>But never mind that now,
   we were discussing something more immediately relevant, so what's your answer
   to that?</q><.convstay><.topics>";
;

++ AltTopic
   topicResponse()
   { 
     "He opens the envelope and peers inside. Seeing the document, he snatches
      it out and rapidly scans it, the colour draining from his face.<.p>
      <q>How the hell...</q> he begins, and then turns to the guarding and
      snaps, <q>Shoot him!</q><.p>
      The guardian obeys instantly.<.p>";
      endGame(ftDeath);
   }
   isActive = document.isIn(gDobj)
;


+ whiteCoatTalking : InConversationState
  specialDesc = "The white-coated man is standing right in front of you. "
  stateDesc = "He's standing right in front of you. "
  isInitState = true
  attentionSpan = nil
;

++ whiteCoatStanding : ConversationReadyState
  isInitState = true
  specialDesc = "A man in a white coat is standing here. "
;

+ whiteNode : ConvNode 'white-node'
  npcGreetingMsg  {
  "The man in the white coat stops, looks you up and down, then remarks, <q>";    
   if(oldClothes.isWornBy(gPlayerChar) && !gRevealed('clothes-remark'))   
     "Where did you get those <i>dreadful</i> old clothes from -- they\'re scarcely
       an improvement! <.reveal clothes-remark>";
   else if(gPlayerChar.isIn(courtyard)) 
     "I hope you weren't thinking of trying to escape! ";
   else if(gRevealed('blue door open'))
     "Tsk! Thinking you could escape us was unwise -- very unwise! ";
   if(gRevealed('square-circle-question'))  
     "Now, as I asked you before -- you have ";
   else
      "Congratulations!</q> he beams, <q>You\'ve just <.reveal square-circle-question>";
    "drawn a square circle, right?</q><<gSetSeen(whiteCoat)>><.topics> ";
  }
  limitSuggestions = true
  npcContinueList : CyclicEventList 
  {
   [    
    '<q>We\'re still waiting for your answer.</q> the
       man in the white coat insists.<.topics> ',
    nil,
    '<q>A simple yes or no is all I need</q> the white-coated
      man prompts you.<.topics> ',
    nil   
   ]
  }
  canEndConversation(actor, reason)
  {
    if(reason == endConvTravel)
      "The guardian motions you with his pistol to stay right where you are. ";
    else
      "They're not about to let you off that easily. ";
    return nil;
  }
  
;

++ YesTopic, SuggestedYesTopic
  "<q>Yes, that's right.</q> you agree. <q>It occurred to me that it could
   be done on the surface of a sphere, so I...</q>\b
   <q>Yes, quite so.</q> he interrupts, <q>I know how you did it. And
    to think people say it can't be done! Well, you and I know better now,
    don't we? Anyway, I just need you to sign
    this statement to certify that you have indeed drawn a square circle.</q>
    He holds out a statement to you.<.convnode sign-node><.reveal yes-circle>"
   timesToSuggest = nil 
;

++ NoTopic, SuggestedNoTopic, CyclicEventList
  [
    '<q>A square circle? Of course not!</q> you reply.\b
     <q>I suggest you reconsider that answer very carefully.</q> the
     man in the white coat warns you, <q>Now, have you just drawn
     a square circle or haven\'t you?</q><.convstay>',
     
    '<q>No, of course not.</q> you insist.\b
     The white-coated man raises one eyebrow, <q>Are you sure about
     that? If you really <i>haven\'t</i> drawn a square circle then you
     must have broken out of prison illegally, in which case...</q> he
     nods significantly towards the pistol aimed at your chest. <q>So,
     let\'s try one more time, shall we? Have you or have you not just
     drawn a square circle?</q><.convstay>',
     
     new function {

       "<q>No, I haven\'t!</q> you declare.\b
       <q>Then it would appear you <<gRevealed('blue door open') ?
        'are no better than an escaped prisoner' : 'have been released by mistake'>>,</q> he
       concludes, <q>so <<gRevealed('blue door open') ? 'we\'d better put you
       somewhere more secure' : 'it\'s back to your cell for you'>>!</q>\b
       Before you can protest you feel a jab in your arm as a the
       white-coated man stabs it with a syringe and injects you with something. 
       You try to speak, but lose consciousness before you can utter a word.<.p>";
       reImprison();
      }      
  ]  
  timesToSuggest = nil
;

++ DefaultAnyTopic, StopEventList
 [
   '<q>Never mind about that; the only thing I\'m interested in is 
    your square circle.</q> the white-coated man interrupts. <q>You
    have drawn one, haven\'t you?</q><.convstay> ',
    '<q>You have drawn a square circle, haven\'t you?</q> the white
    coated man insists. <.convstay>',
    '<q>Your square circle -- yes or no?</q> the man demands.<.convstay>'
 ]
  deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;

+ ConvNode 'sign-node'
  limitSuggestions = true
  canEndConversation(actor, reason)
  {
    if(reason == endConvTravel)
      "The guardian motions you with his pistol to stay right where you are. ";
    else
      "They're not about to let you off that easily. ";
    return nil;
  }
  npcContinueList : ShuffledEventList
  {
   [ '<q>Just sign the statement and you can go.</q> he assures you.<.topics>',
     nil,
     '<q>The statement.</q> he prompts you.<.topics> ',
     '<q>All we need is your signature.</q> he reminds you.<.topics> '   
   ]
  }
  npcGreetingMsg
  {
    "<q>Ah, there you are!</q> declares the man in the white coat,
     <<oldClothes.isWornBy(gPlayerChar) ? 'eyeing your tattered attire with
      evident disdain, ' : ''>> <q>I assume you've changed your mind about signing 
      that statement -- you will sign it now, won't you?</q>";
  }
;

++ AskAboutForTopic, SuggestedAskForTopic @statement
  topicResponse
  {
   "<q>May I see the statement please?</q> you ask.\b
    <q>Of course.</q> he agrees equably, handing it to you,
    <q>Now, just sign it please, and we'll be finished with you.</q>
    <.convstay><.topics>";
    statement.moveInto(gPlayerChar);
    gSetSeen(statement);
    
  } 
  isActive = (statement.isIn(whiteCoat))
  name = 'the statement'
  timesToSuggest = nil  
;

++ SpecialTopic 'sign' ['sign', 'statement', 'yes']
  topicResponse
  {
    "<q>Er, might I borrow a pen?</q> you ask.\b
     <q>Of course,</q> he replies, handing you a sleek gold biro.\b
     You sign the statement with an automatic flourish of the pen and hand 
     both pen and statement back to the man in the white coat.
     It's only after you've done so that it dawns on you that you've just
     signed <i>your name</i>. But before you can pursue that insight
     the white-coated man finishes checking your signature and distracts
     your attention by saying, <q>Good, that seems to
     be in order. Thank you for your co-operation. In return I can assure you that
     you will <i>never</i> return to prison. Indeed, all your troubles are now
     over -- for good!</q>\b
     <q>Thank goodness for that!</q> you declare.\b
     So then, you reflect, you signed your name and it was --
     you break off your musings once again when you see the man in the white coat nod 
     to the guardian; the look the latter gives you as he tightens his grip on his pistol
     banishes every other thought from your mind.\b
     <q>But...</q> you begin.\b";
     inputManager.pauseForMore(true);
     "<q>Regrettably,</q> the white-coated man starts to explain, <q>you have 
      become far too wayward not to meet a tragic...</q>\b
     You never hear the end of that sentence, since the guardian pulls the trigger
     before its conclusion; the bullets rip into your heart, 
     lungs and chest, and you know no more.\b ";
     endGame(ftDeath);     
  }
  timesToSuggest = nil
;

++ SpecialTopic, CyclicEventList 'refuse' ['refuse', 'no']
  [
    '<q>No, I won\'t sign it.</q> you refuse.\b
     <q>Come now!</q> he pleads, <q>What\'s the harm of it? Just one little
     signature and we\'ll be done with you for good!</q><.convstay><.topics>',
     
     '<q>I won\'t sign!</q> you declare stoutly.\b
      <q>I strongly suggest you reconsider that decision.</q> he admonishes you.
      <.convstay><.topics> ',
      
     new function {
//       gTranscript.deactivate;
       "<q>There's something fishy -- I'm not signing that statement, and you
        can't make me!</q> you decide.\b
        <q>You're obviously not hungry enough,</q> he surmises, <q>Maybe some
         more reflection on your crimes will change your mind.</q>\b
         Before you have any chance to work out what he might mean, you feel
         a sharp prick as he plunges a syringe into your arm. You open your
         mouth to protest, but already your lips, tongue and larynx have
         become numb, and no sound comes out. For a moment you
         feel a little woozy, as your surroundings seems to spin around
         you and go strangely out of focus; and then you pass out...<.p>"; 
        
        reImprison();
        
     } 
     
  ]
  timesToSuggest = nil
;

++ SpecialTopic, ShuffledEventList 'ask why'
  ['ask', 'him', 'man', 'in', 'white', 'coat', 'why']
  [
    '<q>Why are you so anxious for me to sign?</q> you ask suspiciously.\b
     <q>It\'s just a formality,</q> he assures you, with a fixed smile.<.convstay> 
     <.topics>',
     
    '<q>But what\'s the point of it?</q> you demand, <q>Why do you need me
     to sign this?</q>\b
     <q>Simply to confirm that you\'ve fulfilled the conditions of your
      release.</q> he replies.<.convstay><.topics>',
      
    '<q>But you know I\'ve drawn a square circle,</q> you protest, <q>you
     even said you know how I\'ve done it, and your goon with the gun
     has shown you the globe! So why do you need me to sign this bit of
     paper as well?</q>\b
     The white-coated man\'s smile becomes even more strained as he replies,
     <q>Regulations. I mean how would it look if we let you out and you
      hadn\'t confirmed that you\'d served your sentence? That would never do,
      would it? Dear me, no.</q><.convstay><.topics>',
      
    '<q>I still don\'t see why I need to sign this thing.</q> you protest.\b
     <q>Perhaps because refusal to do so could be construed as the mark of
      a rebellious and unreformed character,</q> the white-coated man answers,
      his smile now rapidly starting to fade altogether, <q>Whereas your
      willingness to co-operate in this tiny matter would help to reassure us
      that you are indeed a responsible and reformed citizen who need not be
      returned to prison.</q><.convstay><.topics>'    
      
  ]
  [
    '<q>I still don\'t see why I should.</q> you maintain.\b
     <q>You\'d prefer to go back to prison?</q> he asks, <q>Surely not!</q><.convstay>
     <.topics>',
     
    '<q>Why is this statement so important?</q> you demand.\b
     <q>As I said, it\'s just routine paperwork,</q> he shrugs.<.convstay><.topics>',
     
    '<q>What\'s the <i>real</i> reason you want me to sign this thing?</q>
     you ask.\b
     <q>Regulations!</q> he snaps.<.convstay><.topics> ' 
    
  ]
;

++ AskTellTopic, StopEventList @t_signature
  [
    '<q>How can I sign? I can\'t even remember my own name!</q> you point out.<.p>
     <q>Don\'t worry,</q> he assures you, <q>you\'ll find your signature comes
     easily enough.</q><.convstay><.topics>',
     
    '<q>So I don\'t even need to know my own name to sign?</q> you ask.<.p>
     <q>Muscle memory,</q> he assures you, <q>You won\'t have any trouble scrawling
      your signature, trust me.</q><.convstay><.topics>'
  ]
;

++ DefaultAnyTopic, ShuffledEventList
  [
    '<q>Just sign the statement.</q> he insists.<.convstay><.topics> ',
    '<q>Never mind that now, we just need your signature.</q> he reminds you.
     <.convstay><.topics> ',
    '<q>Trying to change the subject won\'t help at all,</q> he tells you,
     <q>Just sign!</q> <.convstay><.topics> ',
    '<q>The pursuit of irrelevance has never been a virtue in my book!</q>
     he declares, <q>The point at issue is the statement -- we need you
     to sign it.</q><.convstay><.topics> ', 
    '<q>The sooner you sign the statement the sooner this will all be
     over for all of us.</q> he points out, <q>So for goodness\'s sake,
     just sign!</q><.convstay><.topics> ',
    '<q>The truly rational course of action right now is for you to
     sign the statement,</q> he insists, <q>so please do get on with it!</q>
     <.convstay><.topics> ' 
  ]   
  deferToEntry(other) { return !other.ofKind(DefaultTopic); }
;

+ conditionalEastAgenda : AgendaItem
  isReady = (!getActor.canSee(gPlayerChar))
  moved = nil
  isDone = (moved || getActor.canSee(gPlayerChar))
  invokeItem()
  {
     newActorAction(getActor, East);
     moved = true;
  } 
;


function reImprison()
{
  inputManager.pauseForMore(true);  
//  morePrompt();
  gPlayerChar.posture = lying;
  gPlayerChar.asleep = true; 
  whiteCoat.moveIntoForTravel(nil);
  if(gRevealed('guard-watch'))
  {
     guardian.moveIntoForTravel(prisonRoad);
     guardian.setCurState(guardianWatching);
  }
  else
     guardian.moveIntoForTravel(nil); 
  statement.moveInto(whiteCoat);
  if(gRevealed('blue door open'))
  {
    foreach(local cur in gPlayerChar.getOutermostRoom().contents)
    {
      if(!cur.ofKind(NonPortable) && !cur.ofKind(SenseConnector))
        cur.moveInto(prisonHut);
    }
    foreach(local cur in gPlayerChar.contents)
    {
      if(!cur.ofKind(Component)  && !cur.isWornBy(gPlayerChar))
      {
        if(cur is in (swivelChair, guardChair))
          cur.moveIntoForTravel(wayOut);
        else  
          cur.moveIntoForTravel(prisonHut);
      }
    }
    if(padlock.isIn(prisonHut) && !padlock.isIn(skylightRing))
    {
      padlock.baseMoveInto(skylightRing);
      padlock.makeOpen(nil);
    }
    gPlayerChar.moveIntoForTravel(prisonHut);
    "<.p>After a period of blackness, consciousness slowly returns. You become
     gradually aware that you are lying somewhere not at all comfortable. When
     at last your eyes manage to blink open you find it's the floor of a small
     hut.<.p>";    
    
    
    
    nestedActorAction(gPlayerChar, Look);
    skylight.makeOpen(nil);
    
    return;
  }
  gPlayerChar.moveIntoForTravel(cellBed);  
  foreach(local cur in gPlayerChar.contents)
    if(!cur.isWorn && !cur.ofKind(Component)) 
    {       
      cur.moveInto(vestibule);
    }
  if(cellDoor.isOpen) cellDoor.makeOpen(nil);
  cellDoor.makeLocked(true);
  desk.moveInto(cell);  
  redBook.moveInto(bookcase);
  blueBook.moveInto(bookcase);
  greenBook.moveInto(bookcase);
  swivelChair.moveInto(cell);
  bulb.moveInto(lightFitting);
  bulb.moved = nil;
  bulb.makeLit(true);
  power.on=true;
   
  tinBox.moveInto(cellBed.subUnderside);  
  tinBox.discovered = nil;  
  tinSandBox.moveInto(nil);
  filedIronKey.moveInto(nil);
 
  note.moveInto(nil);
  foodNote.moveInto(nil);
  if(greenBox.isOpen) greenBox.makeOpen(nil);
  if(yellowBox.isOpen) yellowBox.makeOpen(nil);
  if(whiteBox.isOpen) whiteBox.makeOpen(nil);
  local sel = rand(2);
  if(sel)
  {
    ironKey.discovered = nil;
    ironKey.baseMoveInto(mattress);
    brassKey.baseMoveInto(redBook.subContainer);
    sandwich.baseMoveInto(tinBox);
    newFoodNote.baseMoveInto(tinBox);    
    if(!pen.isIn(nil)) pen.baseMoveInto(drawer);    
  }
  else
  {
    brassKey.discovered = nil;
    brassKey.baseMoveInto(mattress);
    ironKey.baseMoveInto(drawer);
    sandwich.baseMoveInto(redBook.subContainer);
    newFoodNote.baseMoveInto(redBook.subContainer);
    if(!pen.isIn(nil)) pen.baseMoveInto(tinBox);    
  }
  redBook.subContainer.makeOpen(nil);
  drawer.makeOpen(nil);
  tinBox.makeOpen(nil);
  drawer.makeLocked(true);
  tinBox.makeLocked(true);
  "Nothing. Blackness. Insensibility. An indefinite period of groping towards 
   consciousness, interspersed with strange dreams and fragmentary recollections.
   Then, slowly, groggily, woozily, you come to.
   <<gRevealed('back-in-cell') ? '' : 'It\'s all too clear where you are.
    The only question is whether your jailers can really have 
    been either daft enough or obliging enough to hide everything in the same places 
    -- well, that and whether it\'s simply your dismay at being
    returned to the cell that makes the mattress feel even less comfortable 
    than before. <.reveal back-in-cell>'>><.p>";  
  nestedActorAction(gPlayerChar, Look);
//  gTranscript.activate;
}
