/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import org.zmpp.swingui.Canvas;
import org.zmpp.swingui.ColorTranslator;
import org.zmpp.swingui.CursorWindow;
import org.zmpp.swingui.FontFactory;
import org.zmpp.swingui.ScreenFont;
import org.zmpp.swingui.TextCursorImpl;
import org.zmpp.swingui.Viewport;
import org.zmpp.swingui.WindowArea;
import org.zmpp.swingui.WindowStyle;
import org.zmpp.swingui.WordWrapper;
import org.zmpp.vm.TextCursor;
import org.zmpp.vm.Window6;

public class Window6Impl
implements Window6,
CursorWindow {
    private TextCursor cursor;
    private FontFactory fontFactory;
    private int interruptRoutine;
    private int interruptCount;
    private int background;
    private int foreground;
    private ScreenFont font;
    private Viewport viewport;
    private WindowArea area;
    private WindowStyle style;
    private int windownum;

    public Window6Impl(Viewport viewport, FontFactory fontFactory, int n) {
        this.viewport = viewport;
        this.fontFactory = fontFactory;
        this.windownum = n;
        this.cursor = new TextCursorImpl(this);
        this.area = new WindowArea();
        this.style = new WindowStyle();
    }

    public TextCursor getCursor() {
        return this.cursor;
    }

    public void drawPicture(BufferedImage bufferedImage, int n, int n2) {
        this.getCanvas().drawImage(bufferedImage, n2 - 1, n - 1);
    }

    public void move(int n, int n2) {
        this.area.setPosition(n2, n);
    }

    public void setBufferMode(boolean bl) {
        this.style.setIsWrapped(bl);
    }

    public void setSize(int n, int n2) {
        this.area.setSize(n2, n);
    }

    public void setStyle(int n, int n2) {
        this.style.setFlags(n, n2);
    }

    public void setMargins(int n, int n2) {
        this.area.setMargins(n, n2);
    }

    public int getProperty(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return this.area.getProperty(n);
            }
            case 5: {
                return this.cursor.getColumn();
            }
            case 4: {
                return this.cursor.getLine();
            }
            case 9: {
                return this.interruptCount;
            }
            case 8: {
                return this.interruptRoutine;
            }
            case 12: {
                return this.font.getNumber();
            }
            case 10: {
                return this.font.getStyle();
            }
            case 11: {
                return this.getColorData();
            }
            case 13: {
                return this.getFontSize();
            }
            case 14: {
                return this.style.getFlags();
            }
            case 15: {
                return this.getAvailableLines();
            }
        }
        return 0;
    }

    private int getFontSize() {
        int n = this.getCanvas().getFontHeight(this.getFont());
        int n2 = this.getCanvas().getCharWidth(this.getFont(), '0');
        return n << 8 & 0xF0 | n2 & 0xF;
    }

    private int getColorData() {
        return this.background << 8 & 0xF0 | this.foreground & 0xF;
    }

    public void setBackground(int n) {
        this.background = n;
    }

    public void setForeground(int n) {
        this.foreground = n;
    }

    public int setFont(int n) {
        ScreenFont screenFont = this.fontFactory.getFont(n);
        if (screenFont == null) {
            return this.font.getNumber();
        }
        this.font = screenFont;
        return this.font.getNumber();
    }

    public void setTextStyle(int n) {
        this.font = this.fontFactory.getTextStyle(this.font, n);
    }

    public void eraseLine(int n) {
        Canvas canvas = this.getCanvas();
        if (n == 1) {
            int n2 = this.getCurrentX();
            this.area.clip(canvas);
            canvas.fillRect(this.getBackgroundColor(), n2, this.getCurrentY() - canvas.getFontAscent(this.font.getFont()), this.area.getOutputWidth() - n2, canvas.getFontHeight(this.font.getFont()));
        } else {
            int n3 = this.getX(this.cursor.getColumn() + 1);
            this.area.clip(canvas);
            canvas.fillRect(this.getBackgroundColor(), n3, this.getCurrentY() - canvas.getFontAscent(this.font.getFont()), n, canvas.getFontHeight(this.font.getFont()));
        }
    }

    public int getHeight() {
        return this.area.getHeight();
    }

    public void resize(int n) {
        int n2 = this.getCanvas().getFontHeight(this.getFont()) * n;
        this.area.setPosition(1, 1);
        this.area.setSize(this.getCanvas().getWidth(), n2);
    }

    public void setVerticalBounds(int n, int n2) {
        this.area.setPosition(1, n);
        this.area.setSize(this.getCanvas().getWidth(), n2);
    }

    public void printString(String string) {
        int n = this.area.getOutputWidth();
        WordWrapper wordWrapper = new WordWrapper(n, this.getCanvas(), this.getFont(), this.isBuffered());
        String[] stringArray = wordWrapper.wrap(this.getCurrentX(), string);
        this.printLines(stringArray);
    }

    public void updateCursorCoordinates() {
    }

    public boolean isBuffered() {
        return this.style.isWrapped();
    }

    public void backspace(char c) {
    }

    public void clear() {
        this.area.fill(this.getCanvas(), this.getBackgroundColor());
        this.resetCursorToHome();
    }

    private Canvas getCanvas() {
        return this.viewport.getCanvas();
    }

    private Font getFont() {
        return this.font.getFont();
    }

    private void printLines(String[] stringArray) {
        Color color = this.getTextColor();
        Color color2 = this.getTextBackground();
        if ((this.getFont().getStyle() & 1) > 0 && !this.font.isReverseVideo()) {
            color = color.brighter();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.printLine(string, color2, color);
            if (!Window6Impl.endsWithNewLine(string)) continue;
            this.newline();
        }
    }

    private void printLine(String string, Color color, Color color2) {
        Canvas canvas = this.getCanvas();
        this.area.clip(canvas);
        canvas.fillRect(color, this.getCurrentX(), this.getCurrentY() - canvas.getFontHeight(this.getFont()) + canvas.getFontDescent(this.getFont()), canvas.getStringWidth(this.getFont(), string), canvas.getFontHeight(this.getFont()));
        canvas.drawString(color2, this.getFont(), this.getCurrentX(), this.getCurrentY(), string);
        this.cursor.setColumn(this.cursor.getColumn() + string.length());
    }

    private static boolean endsWithNewLine(String string) {
        return string.length() > 0 && string.charAt(string.length() - 1) == '\n';
    }

    private void newline() {
        this.cursor.setLine(this.cursor.getLine() + 1);
        this.cursor.setColumn(1);
    }

    private Color getBackgroundColor() {
        return ColorTranslator.getInstance().translate(this.background, this.viewport.getDefaultBackground());
    }

    private Color getForegroundColor() {
        return ColorTranslator.getInstance().translate(this.foreground, this.viewport.getDefaultForeground());
    }

    private Color getTextBackground() {
        return this.font.isReverseVideo() ? this.getForegroundColor() : this.getBackgroundColor();
    }

    private Color getTextColor() {
        return this.font.isReverseVideo() ? this.getBackgroundColor() : this.getForegroundColor();
    }

    private int getCurrentX() {
        int n = this.getCanvas().getCharWidth(this.getFont(), '0');
        return this.area.getMarginLeft() + (this.cursor.getColumn() - 1) * n;
    }

    private int getX(int n) {
        int n2 = this.getCanvas().getCharWidth(this.getFont(), '0');
        return this.area.getMarginLeft() + (n - 1) * n2;
    }

    private int getCurrentY() {
        Font font = this.getFont();
        Canvas canvas = this.getCanvas();
        return this.area.getStartY() + (this.cursor.getLine() - 1) * canvas.getFontHeight(font) + (canvas.getFontHeight(font) - canvas.getFontDescent(font));
    }

    private void resetCursorToHome() {
        this.getCursor().setPosition(this.getAvailableLines(), 1);
    }

    private int getAvailableLines() {
        Canvas canvas = this.getCanvas();
        int n = canvas.getFontDescent(this.getFont());
        int n2 = canvas.getFontHeight(this.getFont());
        return (this.area.getOutputHeight() - n) / n2;
    }
}

