/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <stdlib.h>
#include <ctype.h>

#include "glk.h"

struct named_selector {
	unsigned selector;
	char *name;
};

static struct named_selector selector[] = {
    { 0x0001, "exit" },
    { 0x0002, "set_interrupt_handler" },
    { 0x0003, "tick" },
    { 0x0004, "gestalt" },
    { 0x0005, "gestalt_ext" },
    { 0x0020, "window_iterate" },
    { 0x0021, "window_get_rock" },
    { 0x0022, "window_get_root" },
    { 0x0023, "window_open" },
    { 0x0024, "window_close" },
    { 0x0025, "window_get_size" },
    { 0x0026, "window_set_arrangement" },
    { 0x0027, "window_get_arrangement" },
    { 0x0028, "window_get_type" },
    { 0x0029, "window_get_parent" },
    { 0x002A, "window_clear" },
    { 0x002B, "window_move_cursor" },
    { 0x002C, "window_get_stream" },
    { 0x002D, "window_set_echo_stream" },
    { 0x002E, "window_get_echo_stream" },
    { 0x002F, "set_window" },
    { 0x0040, "stream_iterate" },
    { 0x0041, "stream_get_rock" },
    { 0x0042, "stream_open_file" },
    { 0x0043, "stream_open_memory" },
    { 0x0044, "stream_close" },
    { 0x0045, "stream_set_position" },
    { 0x0046, "stream_get_position" },
    { 0x0047, "stream_set_current" },
    { 0x0048, "stream_get_current" },
    { 0x0060, "fileref_create_temp" },
    { 0x0061, "fileref_create_by_name" },
    { 0x0062, "fileref_create_by_prompt" },
    { 0x0063, "fileref_destroy" },
    { 0x0064, "fileref_iterate" },
    { 0x0065, "fileref_get_rock" },
    { 0x0066, "fileref_delete_file" },
    { 0x0067, "fileref_does_file_exist" },
    { 0x0080, "put_char" },
    { 0x0081, "put_char_stream" },
    { 0x0082, "put_string" },
    { 0x0083, "put_string_stream" },
    { 0x0084, "put_buffer" },
    { 0x0085, "put_buffer_stream" },
    { 0x0086, "set_style" },
    { 0x0087, "set_style_stream" },
    { 0x0090, "get_char_stream" },
    { 0x0091, "get_line_stream" },
    { 0x0092, "get_buffer_stream" },
    { 0x00A0, "char_to_lower" },
    { 0x00A1, "char_to_upper" },
    { 0x00B0, "stylehint_set" },
    { 0x00B1, "stylehint_clear" },
    { 0x00B2, "style_distinguish" },
    { 0x00B3, "style_measure" },
    { 0x00C0, "select" },
    { 0x00C1, "select_poll" },
    { 0x00D0, "request_line_event" },
    { 0x00D1, "cancel_line_event" },
    { 0x00D2, "request_char_event" },
    { 0x00D3, "cancel_char_event" },
    { 0x00D4, "request_mouse_event" },
    { 0x00D5, "cancel_mouse_event" },
    { 0x00D6, "request_timer_events" },
	{ 0, NULL }
};

static char classify[] =    "nnnnnnnnyyynnynn"
							"nnnnnnnnnnnnnnnn"
							"yyyyyyyyyyyyyyyy"
							"yyyyyyyyyyyyyyyy"
							"yyyyyyyyyyyyyyyy"
							"yyyyyyyyyyyyyyyy"
							"yyyyyyyyyyyyyyyy"
							"yyyyyyyyyyyyyyyn"
							"nnnnnnnnnnnnnnnn"
							"nnnnnnnnnnnnnnnn"
							"yyyynyannnyyynnn"
							"yyyaaynynayyyyny"
							"aaaayyyyayaaaaaa"
							"ayaaaayaaaaayany"
							"yyyayyyyyyyyyyyy"
							"ayyyyayyyyyyyany";

int lglk_classify_output(unsigned char ch) {
	if(classify[ch] == 'y')
		return gestalt_CharOutput_ExactPrint;
	if(classify[ch] == 'a')
		return gestalt_CharOutput_ApproxPrint;
	return gestalt_CharOutput_CannotPrint;
}

void glk_tick(void) {
	/*  We don't need to do anything in particular  */
}

glui32 glk_gestalt(glui32 id, glui32 val) {
	return glk_gestalt_ext(id, val, NULL);	
}

glui32 glk_gestalt_ext(glui32 id, glui32 val, void *ptr) {
	int at;

	switch(id) {
		case gestalt_Version:
			return 0x00000400;

		case gestalt_CharInput:
			if(val >= ' ' && val <= 126)
				return 1;
			if(val <= keycode_Left && val >= keycode_Func12)
				return 1;
			return 0;

		case gestalt_LineInput:
			if(val >= ' ' && val <= 126)
				return 1;
			return 0;

		case gestalt_CharOutput:
			if(val >= 0 && val < 256) 
				return lglk_classify_output((unsigned char)val);
			return gestalt_CharOutput_CannotPrint;

		case gestalt_MouseInput:
			return 0;
			
		case gestalt_Timer:
			return 1;

		case gestalt_FunctionIDToName:
			for(at = 0; selector[at].selector; at++) {
				if(selector[at].selector == val) {
					if(ptr != NULL)
						*(char **)ptr = selector[at].name;
					return 1;
				}
			}
			return 0;

		case gestalt_FunctionNameToID:
			if(ptr == NULL)
				return 0;

			for(at = 0; selector[at].selector; at++) {
				if(!strcmp(selector[at].name, ptr)) {
					return selector[at].selector;
				}
			}
			return 0;
	}

	return 0;
}

unsigned char glk_char_to_lower(unsigned char ch) {
	if(ch >= 'A' && ch <= 'Z')
		return ch + 'a' - 'A';
	if(ch >= 0xC0 && ch <= 0xDE && ch != 0xD7)
		return ch + 0x20;

	return ch;
}

unsigned char glk_char_to_upper(unsigned char ch) {
	if(ch >= 'a' && ch <= 'z')
		return ch + 'A' - 'a';
	if(ch >= 0xE0 && ch <= 0xFE && ch != 0xF7)
		return ch - 0x20;

	return ch;
}
