#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// NPCS: GENERAL: Npc class
// NPCS: ALIENS: Alien class modifications
// NPCS: ALIENS: INDIVIDUAL ALIENS: Modifications of individual aliens
// NPCS: ALIENS: INDIVIDUAL ALIENS: killPcAmusingly
// NPCS: ALIENS: Corpses
// NPCS: ALIENS: Actor states
// NPCS: ALIENS: Weapons and weapon modifications
// NPCS: ALIENS: NPC description reports
// NPCS: ALIENS: NPC description reports (outdated)
// NPCS: ALIENS: NPC ACTION REPORTS: endgameProfSequence (arguing)
// NPCS: ALIENS: NPC ACTION REPORTS: enemyState, etc.
// NPCS: ALIENS: NPC ACTION REPORTS: endgameDaemon (all daemon stuff other than NPC attacks)
// NPCS: ALIENS: NPC ACTION REPORTS: endgameJeopardy (NPC attacking stuff)
// NPCS: PRISONERS: BEHAVIOR: Greeting you
// NPCS: PRISONERS: BEHAVIOR: Taking and/or stealing food
// NPCS: PRISONERS: BEHAVIOR: Give/show stuff to Vicki/Diane
// NPCS: PRISONERS: BEHAVIOR: Marching north
// NPCS: PRISONERS: Endgame conversation
// DEBUG STUFF

// -------------------------------------------------------------------
// NPCS: GENERAL: Npc class
// -------------------------------------------------------------------

// Npc: A class for NPCs *in the alien building*, not including any
// NPCs that may exist in any virtual world.
//
// Subclasses and derivative objects:
// Aliens: neton, ovan, oldGuard, youngGuard, assistant
// Prisoners: vicki, diane

class Npc: ShadowCaster, Person
  //npcGoDir(dir) {
  //}
  location = nil
  realLocation = nil
  mainMoveInto(newContainer)
  {
    // notify my container that I'm being removed
    sendNotifyRemove(self, newContainer, &notifyRemove);
    // notify my new container that I'm about to be added
    if (newContainer != nil)
      newContainer.sendNotifyInsert(self, newContainer, &notifyInsert);
    // notify myself that I'm about to be moved
    notifyMoveInto(newContainer);
    // perform the basic containment change
    scMoveInto(newContainer);
    // note that I've been moved
    moved = true;
  }
//  // Turning my Npc-class aliens into class ShadowCaster caused them 
//  // not to be able to hear you. I don't know why, as I don't yet
//  // understand LookupTables. Therefore I will have to try to solve 
//  // this with a kludge.
//  canHear(obj) {
//    return true;
//  }
//  canBeTalkedTo(talker, sense, info) {
//    return true;
//  }
//  npcMoveInto(newRoom) {
//    local lst = [];
//    // realLocation is now the new room.
//    realLocation = newRoom;
//    // It seems a little dicey to set the location of the actor to anything,
//    // since MultiLoc's are not designed for you to do that to them.
//    // But apparently I must do it. NPCs are obviously not designed 
//    // to be MultiLoc objects, and it's hard to avoid nil object errors
//    // unless I do this.
//    location = realLocation;
//    // Momentarily remove this NPC from the game.
//    baseMoveInto(nil);
//    // If newRoom is nil, we're done.
//    if (!newRoom) {
//      //agendaList = new Vector(10);
//      return;
//    }
//    // Make "lst" equal to a list of all the rooms visible from the
//    // NPC's new realLocation (realLocation itself should be part of the list),
//    // with no elements of the list repeated.
//    lst = [newRoom];
//    for (local a = 1; a <= newRoom.visibleRooms.length; a++) {
//      lst = lst + newRoom.visibleRooms[a, 1];
//    }
//    // Here's a strategy that should work: simply make it so that
//    // locationList equals "lst", then initializeLocation
//    locationList = lst;
//    initializeLocation();
//  }
;

//modify ovan
//    throwTargetHitWith(projectile, path)
//    {
//        /* 
//         *   figure out where we fall to when we hit this object, then send
//         *   the object being thrown to that location 
//         */
//        getHitFallDestination(projectile, path)
//            .receiveDrop(projectile, new DropTypeThrow(self, path));
//        //local k = inputManager.getKey(nil, nil);
//        //if (k=='q') { k=0;k=k/k; }
//    }
//  getDropDestination(obj, path) {
//    return inherited(obj, path);
//  }
//;

// -------------------------------------------------------------------
// NPCS: ALIENS: Alien class modifications
// -------------------------------------------------------------------

// The Alien class, like the Prisoner class, is defined in 1npcs.t.

modify Alien
  verticalValue() {
    local val;
    if (!location) return 0;
    if (!location.isInFishCorridor) return 0;
    switch (location) {
      case hallway6: val = 10; break;
      case stairs:   val = 20; break;
      case hallway9: val = 30; break;
      case skyway:   val = 40; break;
      default:       val = 50; break;
    }
    val = val + yValue;
    return val;
  }
  hasCrap = nil
  hasGuacamole = nil
  replaceWithCorpse {
    if (asscCorpse.ofKind(ShadowCaster))
      asscCorpse.scMoveInto(self.realLocation);
    else
      asscCorpse.moveInto(self.realLocation);
    asscCorpse.yBaseValue = self.yValue;
    asscCorpse.xBaseValue = self.xValue;
    if (contents.length) {
      for (local a = contents.length; a >= 1; a--) {
        if (contents[a].wornBy)
          contents[a].wornBy = asscCorpse;
        contents[a].moveInto(asscCorpse);
      }
    }
    self.scMoveInto(nil);
  }
  sayCurse {
    "<<theName>> curses";
  }
  tossGunAdverb = 'disgustedly'
  tossGunDisgustedly(obj) {
    "\^<<sayCurse>>. \^<<tossGunAdverb>>, he tosses 
      <<obj.theName>> down to the floor. ";
    obj.moveInto(location);
    adjustXYValuesOfFallenContents(obj, self);
    if (weapons.indexOf(obj))
      weapons = weapons.removeElementAt(weapons.indexOf(obj));
  }
  asscCorpse = nil // override
  electricPistolBlastCount = 0
  // Getting hit twice by the electric pistol will be 
  // deadly.
  electricPistolBlastThreshold = 2
  //iobjFor(ThrowAt) {
  //  verify {
  //    if (gIobj && gDobj && gDobj.ofKind(Gun) 
  //        && !gDobj.isSetToExplode)
  //      illogical('What, throw a firearm to your enemies? 
  //        Don<./s>t be a fool! ');
  //  }
  //}
;
modify Actor
  shootEffectProp {
    if (self == gActor) return &shootEffectMe;
    if (ofKind(Prisoner)) return &shootEffectFriend;
    return &shootEffectEnemy;
  }
;

// -------------------------------------------------------------------
// NPCS: ALIENS: INDIVIDUAL ALIENS: Modifications of individual aliens
// -------------------------------------------------------------------

modify neton
  asscCorpse = netonCorpse
  projectileResponse1 = 'Neton shrugs and marches on. '
  projectileResponse2 = 'Neton frowns, but marches on. '
  projectileResponse3 = 'Neton scowls in annoyance. '
  projectileResponse4 = 'Neton growls ferociously. '
  genericName = 'professor'
  zapT = disappear(
    zapTText, self, 'neon', 'Neton'
  )
  zapTText =
    'Neton is vaporized into a cloud of colorless gas!
        The cloud quickly dissipates, mixing with the
        surrounding air.
      <p>This confuses you for a moment, until you realize
        what must have happened. Neon is a colorless gas; 
        perhaps you have just transformed Neton into neon. '
;

modify ovan
  asscCorpse = ovanCorpse
  projectileResponse1 = 'Ovan shrugs and marches on. '
  projectileResponse2 = 'Ovan shrugs and marches on. '
  projectileResponse3 = 'Ovan shrugs and marches on. '
  projectileResponse4 = 'Ovan frowns in sadness. '
  genericName = 'professor'
  sayCurse {
    "Ovan frowns";
  }
  tossGunAdverb = 'irritably'
  zapAry = die(
    zapAryText
    , 'nova', 'Ovan', killEverybody
  )
  zapAryText =
    'Ovan disappears, and then suddenly there is a cataclysmic
        nuclear explosion! In fact, the explosion is so
        cataclysmic that it destroys not only the earth, 
        but also the whole rest of the solar system.
      <p>You will never understand why this 
        happened; you are already dead, after all. 
        If you were alive, however, you might have taken
        this opportunity
        to reflect on the dire consequences
        of turning Ovan into a nova. '
;

modify youngGuard
  asscCorpse = youngGuardCorpse
  projectileResponse1 = 'The ' + name + ' shrugs and marches on. '
  projectileResponse2 = 'The ' + name + '<./s>s eyes smolder in anger. '
  projectileResponse3 = 'The ' + name + '<./s>s eyes smolder in rage. '
  projectileResponse4 = 'The ' + name + '<./s>s eyes smolder in murderous rage. '
  genericName = 'guard'
;
modify oldGuard
  asscCorpse = oldGuardCorpse
  projectileResponse1 = 'The ' + name + ' shrugs and marches on. '
  projectileResponse2 = 'The ' + name + '<./s>s eyes smolder in anger. '
  projectileResponse3 = 'The ' + name + '<./s>s eyes smolder in rage. '
  projectileResponse4 = 'The ' + name + '<./s>s eyes smolder in murderous rage. '
  genericName = 'guard'
;

modify assistant
  asscCorpse = assistantCorpse
  projectileResponse1 = 
    'The assistant shrugs and marches on. '
  projectileResponse2 =
    'The assistant stoically accepts this and marches on. '
  projectileResponse3 =
    'The assistant stoically accepts this and marches on. '
  projectileResponse4 =
    'The assistant, remarkably, maintains his composure. '
  genericName = 'assistant'
  zapT = transform(self, assisan)
  //zapAry = die(
  //  zapAryText, 'satanists', 'assistant'
  //)
  zapAryText =
    'The assistant is transformed into an assembly of satanists! 
      <p>The satanists, perhaps eager to perform a human sacrifice,
        see you, realize that you have summoned them, and cast 
        their level 9 Kill Summoner spell. '
;

// -------------------------------------------------------------------
// NPCS: ALIENS: INDIVIDUAL ALIENS: killPcAmusingly
// -------------------------------------------------------------------

modify neton
  killPcAmusingly {
    "<.p>Later that evening, when it<./s>s all over, 
        Neton will write in his journal,
        <.q>Killed one human, Gary Randall, today, after I 
        deemed him no longer necessary to the department.<./q> 
      <p>Decades later, after Neton<./s>s death, his journal
        will transferred to the university 
        archives, where, twenty thousand years later, 
        it will be uncovered by historians. 
        The historians will read Neton<./s>s reference to you 
        with some bemusement.
      <p>Thus, you can be proud. You have secured for yourself 
        a kind of immortality. ";
  }
;

modify ovan
  killPcAmusingly {
    "<.p>Later that evening, when it<./s>s all over, 
        Ovan will write an e-mail message to a childhood buddy, 
        saying, <.q>I killed a human today! Woot!<./q> 
      <p>Fifteen years later, that childhood buddy will rise to
        become Arch-Governor of Western Australia. Upon his death,
        the Arch-Governor<./s>s computer will be transferred 
        to the Continental Museum, where, twenty thousand years later, 
        it will be investigated by historians. 
        The historians will read Ovan<./s>s message about you 
        with some bemusement.
      <p>Thus, you can be proud. You have secured for yourself 
        a kind of immortality. ";
  }
;

modify Guard
  killPcAmusingly {
    "<.p>Two weeks later, 
        <<glob.imminentDeathBySlowingField ? 'the guard' : theName>> 
        will be awarded the 
        Pin of Competence, <.q>for perfectly 
        adequate use of force in the elimination of a 
        human being no longer deemed useful.<./q>
      <p>These words will be typed and preserved in the university
        archives, where, twenty thousand years later,
        they will be uncovered by historians. 
        The historians will read this reference to you 
        with some bemusement.
      <p>Thus, you can be proud. You have secured for yourself 
        a kind of immortality. ";
  }
;

modify assistant
  killPcAmusingly {
    "<.p>Later that evening, when it<./s>s all over, 
        the assistant will write in his journal,
        <.q>I feel regretful. I was forced to use 
        deadly violence today, albeit against a human.<./q> 
      <p>Years later, the assistant will quit his job with the university
        and become a famous master in the martial arts.
        Eventually, his journal is published and becomes
        a venerated text. In the words of one scholar,
        <.q>Compassion is a necessary virtue. 
        Even after killing a human,
        the Moon Master felt regretful.<./q>
        Countless Oo will read these words
        and learn from the fine example of the Moon Master.
      <p>Thus, you can be proud. You have secured for yourself 
        a kind of immortality. ";
  }
;

// -------------------------------------------------------------------
// NPCS: ALIENS: Corpses
// -------------------------------------------------------------------

//modify playerMessages
//  askDisambig(actor, originalText, matchList, fullMatchList,
//              requiredNum, askingAgain, dist)
//  {
//    inherited(actor, originalText, matchList, fullMatchList,
//              requiredNum, askingAgain, dist);
//    if (matchList[1].obj_ != ovanIcepick && matchList[2].obj_ != ovanIcepick) {
//      local k = 0; k=k/k;
//    }
//  }
//;

class Corpse: ShadowCaster, Soft, Heavy
  isListed = (!isDistant)
  isListedInContents = (!isDistant)
  isListedInInventory = true // moot, but whatever.
  contentsListed = nil // very important: possessions/clothing not listed.
  alienName = (asscAlien.name)
  theAlienName = (asscAlien.theName)
  shootEffectProp = &shootEffectCorpse
  nearDesc {
    "\^<<theAlienName>><./s>s dead body is sprawled out 
      on the floor, eyes 
      staring lifelessly at the ceiling. ";
    //say(soiledDesc);
  }
  aName = (theName)
  // NPC corpses need to be referenceable with both "it" and "him."
  isHim = true
  isIt = true
  // NPC corpse possessions need to be referenceable as, 
  // e.g., "Neton's icepick," not just "the icepick in Neton's body."
  canOwn(obj) { return true; }
  // As a last resort, "on the body" is better than "in the body"
  objInPrep = 'on'
  theNamePossAdj {
    return asscAlien.theName + '<./s>s';
  }
  asscAlien = nil // override
  hasCrap = asscAlien.hasCrap
  hasGuacamole = asscAlien.hasGuacamole
  soiledDesc() {
    if (hasCrap && hasGuacamole)
      return 'He has been splattered with guacamole dip 
        and some other substance most foul. ';
    else if (hasCrap)
      return 'He has been splattered with a truly foul substance. ';
    else if (hasGuacamole)
      return 'He has been splattered with guacamole dip. ';
    else
      return '';
  }
  smellDesc() {
    if (hasCrap && hasGuacamole)
      "He reeks of bad guacamole dip and another
        substance even more foul. ";
    else if (hasCrap)
      "He reeks of something truly foul. ";
    else if (hasGuacamole)
      "He reeks of bad guacamole dip. ";
    else
      "He doesn<./s>t smell like much. ";
  }
  // Borrow these next two methods from class Actor
  examineListContents() {
    // I'm not sure if this is technically part of the contents, 
    // but this kludge will do the job.
    say(soiledDesc);
    // if I'm not the player character, show my inventory
    if (!isPlayerChar())
      holdingDesc;
  }
  holdingDesc {
    // show our contents as for a normal "examine", but using the
    // special contents lister for what an actor is holding 
    examineListContentsWith(corpseHoldingDescInventoryListerLong);
  }
  wordName = alienName
  dobjFor(Shoot) {
    verify { logicalRank(90, 'corpse'); }
  }
  dobjFor(ShootWith) {
    verify { logicalRank(90, 'corpse'); }
  }
;

corpseHoldingDescInventoryListerLong: actorHoldingDescInventoryListerLong
  showInventoryEmpty(parent) {
    // empty inventory - saying nothing in an actor description
  }
  showInventoryWearingOnly(parent, wearing) {
    // we're carrying nothing but wearing some items
    "He<./s>s wearing <<wearing>>. ";
    //local k = 0; k=k/k;
  }
  showInventoryCarryingOnly(parent, carrying) {
    // we have only carried items to report
    "\^<<corpseCarryingStr(carrying)>> <<carrying>>. ";
    //local k = 0; k=k/k;
  }
  showInventoryShortLists(parent, carrying, wearing) {
    // short lists - combine carried and worn in a single sentence
    "\^<<corpseCarryingStr(carrying)>> <<carrying>>, and
    he<./s>s wearing <<wearing>>. ";
    //local k = 0; k=k/k;
  }
  showInventoryLongLists(parent, carrying, wearing) {
    // long lists - show carried and worn in separate sentences
    "\^<<corpseCarryingStr(carrying)>> <<carrying>>.
    He<./s>s wearing <<wearing>>. ";
    //local k = 0; k=k/k;
  }
  corpseCarryingStr(carrying) {
    if (carrying.find(', ') || carrying.find(' and '))
      return 'in his hands he is clutching';
    else
      return 'in his hand he is clutching';
  }
;

netonCorpse: Corpse
  'n neton neton\'s dead body corpse alien oo professor prof -*bodies*corpses*profs*professors*aliens*oos'
  'Neton<./s>s body'
  isProperName = true
  asscAlien = neton
  zapT = disappear(
    neton.zapTText, self, 'neon', 'Neton'
  )
;
ovanCorpse: Corpse
  'o ovan ovan\'s dead body corpse alien oo professor prof -*bodies*corpses*profs*professors*aliens*oos'
  'Ovan<./s>s body'
  isProperName = true
  asscAlien = ovan
  zapAry = die(
    ovan.zapAryText
    , 'nova', 'Ovan', killEverybody
  )
;
youngGuardCorpse: Corpse
  'young younger muscular youthful body corpse guard guards\' guard\'s oo alien -*guards*bodies*corpses*aliens*oos'
  'young guard<./s>s body'
  asscAlien = youngGuard
;
oldGuardCorpse: Corpse
  'old older elder elderly body corpse guard guards\' guard\'s oo alien -*guards*bodies*corpses*aliens*oos'
  'old guard<./s>s body'
  asscAlien = oldGuard
;
assistantCorpse: Corpse
  'body corpse alien assistant assistant\'s oo (moon) master asst assistant -*bodies*corpses*aliens*oos'
  'assistant<./s>s body'
  asscAlien = assistant
  zapT = transform(self, assisan)
  //zapAry = die(
  //  assistant.zapAryText, 'satanists', 'assistant'
  //)
;

//class Corpse: Heavy
//  shootEffectProp = &shootEffectCorpse
//;
//netonCorpse: Corpse
//;
//ovanCorpse: Corpse
//;
//youngGuardCorpse: Corpse
//;
//oldGuardCorpse: Corpse
//;
//assistantCorpse: Corpse
//;

// -------------------------------------------------------------------
// NPCS: ALIENS: Actor states
// -------------------------------------------------------------------

strPlusSpace(str) {
  if (str && str != '')
    return str + ' ';
  else
    return str;
}

modify ActorState
  stateGerund(str) {
    return str;
  }
;
class EndgameActorState: ActorState
  stateGerund(str) {
    return strPlusSpace(str) 
      + 'facing you and giving you a mean look';
  }
;
class EndgameProfessorState: EndgameActorState
  stateGerund(str) {
    if (neton.realLocation == office) {
      switch (endgameProfSequence.epsValue) {
        case 8:
          return 'Neton fiercely glaring at a dejected Ovan';
        case 9:
          return 'Neton looking on as Ovan prepares to leave';
        case 10:
          return 'Ovan grinning broadly at Neton';
        default:
          return strPlusSpace(str) + 'facing each other
            in a state of exasperation';
      }
    }
    else if (!neton.facingYou && neton.isIn(hallway4))
      return strPlusSpace(str) + 'facing to the south';
    else
      return inherited(str);
  }
;
class EndgameGuardState: EndgameActorState
;
netonEndgameState: EndgameProfessorState
  location = neton
;
ovanEndgameState: EndgameProfessorState
  location = ovan
;
oldGuardEndgameState: EndgameGuardState
  location = oldGuard
  stateGerund(str) {
    if (getActor.getFoodItem)
      return strPlusSpace(str) + 'sitting and eating ' 
        + getActor.getFoodItem.aName;
    else
      return inherited(str);
  }
;
modify oldGuard
  getFoodItem {
    foreach(local cur in oldGuard.contents) {
      if (cur.ofKind(Food))
        return cur;
    }
    return nil;
  }
;

oldGuardSandwich: Food
  'sandwich' 'sandwich'
  hasBeenMovedIntoNil = nil
;

youngGuardEndgameState: EndgameGuardState
  location = youngGuard
;
assistantEndgameState: EndgameActorState
  location = assistant
;

// -------------------------------------------------------------------
// NPCS: ALIENS: Weapons and weapon modifications
// -------------------------------------------------------------------

// Perhaps move this stuff to 3guns.t.

modify Alien
  // Override this for all aliens, or bugs will result.
  weapons = []
  // Most of the NPCs will never have weapons that are not range 
  // weapons. The only two exceptions are Neton and Ovan.
  rangeWeapons = (weapons)
  // This will produce errors if weapons = [], hence the need 
  // to override the weapons property.
  standardWeapon = (weapons[weapons.length])
  runVerb = 'run'
;

// Neton and Ovan, uniquely, start out with melee weapons
// rather than range weapons. Furthermore, any further weapons
// they gain will definitely be range weapons and will definitely
// be added to the front of the weapons list. So Neton's and Ovan's
// rangeWeapons list will always consist of all but the last
// element of the weapons list.
modify neton
  rangeWeapons = (weapons.sublist(1, weapons.length - 1))
;
modify ovan
  rangeWeapons = (weapons.sublist(1, weapons.length - 1))
;
modify neton
  //weapon = netonIcepick
  weapons = [netonIcepick]
;
modify ovan
  //weapon = ovanIcepick
  weapons = [ovanIcepick]
;
modify oldGuard
  //weapon = oldGuardHandCannon
  weapons = [oldGuardHandCannon]
;
modify youngGuard
  //weapon = youngGuardHandCannon
  weapons = [youngGuardHandCannon]
;
modify assistant
  //weapon = dagger
  weapons = [dagger]
;
modify HandCannon
  // Follow these defaults:
  //maxHitDistance = (slowingField.isOn ? 150 : 200)
  //maxAlwaysShootDistance = (maxHitDistance + 25)
  
  attackUnderOrdersParagraph {
    "<p>\^<<location.theName>><./s>s face lights up. He raises 
        his hand cannon and fires straight at you. 
      <p>For a moment, you are engulfed in blinding light
        and agonizing pain. Then you lose consciousness. ";
  }
  // Common range weapon methods/properties:
  suddenRangeAttackParagraph(str, bothGuards) {
    if (!bothGuards)
      "\^<<str>><<asscGuard ? asscGuard.theName : 'the guard'>> 
        raises his hand cannon and fires at you. ";
    else
      "\^<<str>>the guards raise their hand cannons
        and fire at you. ";
  }
  deathParagraph(extra, bothGuards) {
    if (bothGuards) {
      if (location == oldGuard)
        "The young guard misses you, but the old guard does not. ";
      else
        "The old guard misses you, but the young guard does not. ";
    }
    else if (extra) {
      "This time, he does not miss. ";
    }
    "<.p>";
    "For a moment, you are engulfed in blinding light and 
      agonizing pain. ";
    "Then <<glob.youCollapseToTheFloor>>. ";
  }
  reportNpcMiss(stat, bothGuards) {
    if (!bothGuards)
      "A bolt of plasma flies by you, 
        missing<<byWhatMargin(stat)>>. ";
    else
      "Two bolts of plasma fly by you, 
        missing<<byWhatMargin(stat)>>. ";
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo { }
  slowedAssaultSentence =
    "With calm deliberation, he raises his hand cannon
      and fires straight at you. "
  assaultingYouDesc =
    "aiming his hand cannon straight at you and opening fire. "
  isNewToNpc = nil
  asscGuard = nil
  // PC shooting stuff
  defaultShootResult = kill
  shootPrefixMsg(obj, complex) {
    return 'A bright bolt of light pulses from the hand cannon' 
      + throughMsg(' and through the ','',obj, complex) + '. ';
  }
  shootEffectEnemy {
    sayForArt('A bright bolt pulses from the hand cannon' 
      + throughMsg(', passes through the ',',',gDobj,true) 
      + ' and hits {the dobj/him}, engulfing him in a 
      blinding aura. After a few seconds in which 
      {the dobj/he} is paralyzed
      in agony, the alien falls dead to the floor. ');
    doShootResult(gDobj, kill);
  }
  beamWord = 'bolt of light'
;

// The NpcPossession class is redundant. I'm just being
// extra sure in case I later make RangeWeapon not derivative
// of NpcPossession.

dagger: NpcPossession, RangeWeapon, Thing
  'metal dagger/knife/blade' 'dagger'
  "The dagger is made of smooth, gleaming metal.
      Its blade is handsomely curved, and looks 
      extremely sharp. "
  attackUnderOrdersParagraph {
    "<p>Nodding, <<location.theName>> pulls out 
        a dagger, then expertly slashes you 
        straight across your neck.
      <p>Paralyzed you may be, but
        that does not stop you from falling
        back onto the floor. After several agonizing 
        minutes, during which you can do nothing 
        but watch your blood spill out, eventually 
        you lose consciousness. ";
  }
  suddenRangeAttackParagraph(str, bothGuards) {
    "\^<<str>><<location.theName>> lifts his dagger, then hurls it
      at you. ";
  }
  deathParagraph(extra, bothGuards) {
    if (!glob.imminentDeathBySlowingField) {
      "To your shock, it lands right in your neck. 
        <.p>";
      "Suffice it to say, your remaining moments of life are 
        excruciatingly painful. After much flailing about, finally 
        <<glob.youCollapseToTheFloor>>. ";
    }
    else {
      "<p>Paralyzed you may be, but
        that does not stop you from falling
        back onto the floor. After several agonizing 
        minutes, during which you can do nothing 
        but watch your blood spill out, eventually 
        you lose consciousness. ";
    }
  }
  // dagger.reportNpcMiss is included for the sake of completeness,
  // but if it is ever actually executed, we'll be in trouble!
  reportNpcMiss(stat, bothGuards) {
    "The dagger flies by you, 
      missing<<byWhatMargin(stat)>>. ";
  }
  // This weapon never runs out of ammo.
  //reportNoNpcAmmo {
  //  "ERROR! Dagger out of ammo! ERROR! ";
  //}
  slowedAssaultSentence =
    "With calm deliberation, he hurls his dagger at you. 
      To your shock, it lands right in your neck. "
  assaultingYouDesc {
    if (!glob.imminentDeathBySlowingField)
      "hurling his dagger straight at you. ";
    else
      "slashing his dagger straight across your neck. ";
  }
  refrainFromAttacking {
    "\^<<location.theName>> lifts his dagger as if to throw
      it at you, but then lowers it again, apparently
      thinking better of the idea. ";
  }
  // A dagger "running out of ammo" is nonsensical; hence,
  // make sure this never happens.
  ammo = 9999
  missingRevealsShoddiness = nil
  // This is presumably redundant, but just to be sure:
  shootConsequences {
    if (location && location.ofKind(Alien)) {
      location.hasFiredThisTurn = true;
    }
  }
  // The dagger, uniquely, will never be thrown except when its
  // wielder (the assistant) knows that he can hit his target.
  maxAlwaysShootDistance = (maxHitDistance)
  isNewToNpc = nil
  // Action handling
  iobjFor(AttackWith) {
    verify { }
  }
  iobjFor(CutWith) {
    verify { }
  }
;

// The NpcPossession class is redundant. I'm just being
// extra sure in case I later make MeleeWeapon not derivative
// of NpcPossession.

class Icepick: NpcPossession, MeleeWeapon, Thing
  'metal ice instrument/pick/icepick/blade/tip' 'icepick'
  "The weapon<./s>s handle is made of
      smooth metal; its blade tapers to a sharp, thin tip. 
      Ominously, something inside it seems to be 
      flickering with an unnatural kind of light. "
  lookInDesc =
    "Something inside the tip of the icepick seems to be 
        flickering with an unnatural kind of light, but 
        you can<./s>t see any more than that. "
  isEquivalent = true
  // suddenRangeAttackParagraph() is unnecessary
  deathParagraph(extra, bothGuards) {
    "<.p>";
    "That was no ordinary icepick. 
      For several agonizing moments, you feel like 
      you are being electrocuted. ";
    "Then <<glob.youCollapseToTheFloor>>. ";
  }
  // reportNpcMiss() is unnecessary
  // reportNoNpcAmmo() is unnecessary
  slowedAssaultSentence =
    "With some effort, he reaches over and pokes into your ribs
      with his icepick. "
  assaultingYouDesc =
    "lunging toward you and poking into your ribs with his icepick. "
  
  
  
  hittingYouPhrase = "poking into your ribs with his icepick"
  hitsYouPhrase = "pokes you in your ribs"
  lastDitchSentence(plur) {
    "As a desperate, last-ditch effort, 
      <<plur ? 'they throw their' : 'he throws his'>>
      <<plur ? pluralName : name>> 
      at you as hard as 
      <<plur ? 'they' : 'he'>> can. ";
  }
  lastDitchPhrase(plur) {
    "throwing <<plur ? 'their' : 'his'>>
      <<plur ? pluralName : name>> 
      at you as hard as 
      <<plur ? 'they' : 'he'>> can. ";
  }
  attackPcAfterPcStumblesNear(attacking) {
    if (attacking) {
      "You lunge straight at ";
      if (location)
        "<<location.theName>>, ";
      else
        "the alien, ";
      "but he reacts much more quickly than you expected. ";
    }
    else {
      "You begin moving in that direction, but as soon as 
        you get close to ";
      if (location)
        "<<location.theName>>, the alien makes his move. ";
      else
        "the alien, he makes his move. ";
    }
    "Taking a huge gamble, he throws his icepick at you 
      as hard as he can. ";
  }
  rangeAttackSomehowSucceeds {
    if (location)
      "\^<<location.theName>><./s>s ";
    else
      "The ";
    "<<name>> manages to hit you,
        and it is no ordinary <<name>>. 
        For several agonizing moments, you feel like 
        you are being electrocuted. ";
    "Then <<glob.youCollapseToTheFloor>>. ";
  }
  lungesAttackPhrase(plur) {
    if (plur)
      "lunge at you with their icepicks";
    else
      "lunges at you with his icepick";
  }
  isNewToNpc = nil
  // Action handling
  iobjFor(AttackWith) {
    verify { }
  }
  iobjFor(CutWith) {
    verify { }
  }
;
netonIcepick: Icepick
;
ovanIcepick: Icepick
;

modify glob
  youCollapseToTheFloor {
    if (me.posture != lying && !glob.imminentDeathBySlowingField)
      return 'you collapse to the floor';
    else
      return 'you lose consciousness';
  }
;

// -------------------------------------------------------------------
// NPCS: ALIENS: NPC description reports
// -------------------------------------------------------------------

// The following methods are designed to give reports about
// the NPCs, mainly when they are not in action -- e.g., for 
// room descriptions.

modify glob
  // give list of visible NPCs
  getNpcList {
    local npcLst = 
      [neton, ovan, oldGuard, youngGuard, assistant, vicki, diane];
    local lst = [];
    local prelimLst = gPlayerChar.scopeList();
    prelimLst = prelimLst.subset(
      { x: ((x.ofKind(Npc) || (x.asscThing && x.asscThing.ofKind(Npc)))
        && me.canSee(x)) }
    );
    //local k=0;k=k/k;
    for (local a = 1; a <= npcLst.length; a++) {
      if (prelimLst.indexWhich(
           { x: (x == npcLst[a] || x.asscThing == npcLst[a]) }
         ))
      {
        lst = lst + npcLst[a];
      }
    }
    return lst;
  }
  dirList = ['north', 'south', 'west', 'east', 'coincident']
  getFormattedNpcList(exclude) {
    local lst1 = getNpcList;
    // If exclude is non-nil, we assume it's a list of NPCs to exclude.
    // So exclude them.
    if (exclude)
      lst1 = lst1 - exclude;
    // vec2 = a new vector consisting of four empty lists
    local vec2 = 
      //new Vector(4, 
        [ 
          [], [], [], [], []
        ]
      //)
    ;
    local dirVal = nil;
    local prp;
    local desd; // sort descending
    local tempLst = [];
    local oldCount;
    if (lst1.length == 0)
      return vec2;
    // Put each the actors in getNpcList into one of the five elements
    // of the vec2 list, depending on whether they're north, east,
    // coincident, etc.
    for (local a = 1; a <= lst1.length; a++) {
      dirVal = dirList.indexOf(lst1[a].relDirStr);
      if (dirVal)
        vec2[dirVal] = vec2[dirVal].append(lst1[a]);
    }
    // Sort vec2's elements according to how far away the actors are.
    for (local a = 1; a <= 5; a++) {
      // Skip over this element of vec2 if it's empty.
      if (vec2[a].length > 0) {
        if (dirList[a] == 'south' || dirList[a] == 'east' || dirList[a] == 'coincident')
          desd = nil;
        else
          desd = true;
        if (dirList[a] == 'south' || dirList[a] == 'north' || dirList[a] == 'coincident')
          prp = &absYValForList;
        else
          prp = &absXValForList;
          
        vec2[a] = vec2[a].sort(desd, { x, y: x.(prp) - y.(prp) } );
        //if (me.location == skyway) { local k=0; k=k/k; }
        tempLst = [];
        oldCount = 0;
        vec2[a] = vec2[a] + formattedListToken;
        for (local b = 1; b <= vec2[a].length - 1; b++) {
          if (vec2[a][b].(prp) != vec2[a][b+1].(prp)) {
            tempLst = tempLst.append(vec2[a].sublist(oldCount+1,b-oldCount));
            oldCount = b;
          }
        }
        vec2[a] = tempLst;
//        local elemDiff;
//        // I'll have to do the sorting manually instead:
//        tempLst = [];
//        // e.g. if the first alien listed is neton, add the list [neton] 
//        // to tempLst
//        tempLst.append([vec2[a][1]]);
//        if (me.location == skyway) { local k=0; k=k/k; }
//        if (vec2[a].length > 1) {
//          for (local b = 2; b <= vec2[a].length; b++) {
//            for (local c = 1; c <= tempLst.length; c++) {
//              elemDiff = vec2[a][b].(prp) - tempLst[c][1].(prp);
//              if (elemDiff == 0) {
//                tempLst[c] = tempLst[c].append(vec2[a][b]);
//                break;
//              }
//              else if ((elemDiff < 0 && !desd) || (elemDiff > 0 && desd)) {
//                tempLst = tempLst.insertAt(c, [vec2[a][b]]);
//                break;
//              }
//              else if (c == tempLst.length) {
//                tempLst.append([vec2[a][b]]);
//                break;
//              }
//            }
//          }
//        }
//        vec2[a] = tempLst;
      }
    }
    return vec2;
  }
  getFormattedAlienListForMovement {
    local lst1 = getNpcList;
    local vec2 = 
      [ 
        [], // NPCs moving normally, whether slowed or not
        [], // NPCs who have just stepped into the slowing field
        [], // NPCs (i.e. guards) who have just stepped into view from the west
        []  // NPCs (i.e. assistant) have just stepped out of the confRoom
      ]
    ;
    
    //local dirVal = nil;
    //local prp;
    //local desd; // sort descending
    //local tempLst = [];
    local oldCount;
    local normallyMoving = [];
    
    // If any of the NPCs in the list are stunned, remove them from the list,
    // as they clearly can't move.
    if (lst1.length) {
      for (local a = lst1.length; a >= 1; a--) {
        if (lst1[a].isStunned)
          lst1 = lst1.removeElementAt(a);
      }
    }
    // If no one is moving at all, return an empty set of lists.
    if (lst1.length == 0)
      return vec2;
    for (local a = 1; a <= lst1.length; a++) {
      // Add to "stepped out of confRoom" list
      if (lst1[a].realLocation == hallway6 && 
          lst1[a].realLocationBeforeMove == confRoom)
        vec2[4] = vec2[4] + lst1[a];
      // Add to "stepped into view from the west" list
      else if (lst1[a].realLocation == hallway6 && 
               lst1[a].realLocationBeforeMove == hallway5)
        vec2[3] = vec2[3] + lst1[a];
      // Add to "stepped into the slowing field" list
      else if (lst1[a].realLocation == hallway6 &&
               lst1[a].yValue == 1 &&
               lst1[a].realLocationBeforeMove == hallway6 &&
               lst1[a].yValueBeforeMove != 1)
        vec2[2] = vec2[2] + lst1[a];
      // Otherwise, add it to the "normally running" list for now.
      else
        normallyMoving = normallyMoving + lst1[a];
    }
//    return normallyMoving;
    if (normallyMoving.length) {
      // <UNCERTAINTY>
      normallyMoving = normallyMoving.sort(nil, { x, y: x.absoluteYValue - y.absoluteYValue } );
      normallyMoving = normallyMoving + formattedMovementListToken;
      oldCount = 0;
      for (local a = 1; a <= normallyMoving.length - 1; a++) {
        if (normallyMoving[a].absoluteYValue != normallyMoving[a+1].absoluteYValue) {
          vec2[1] = vec2[1].append(normallyMoving.sublist(oldCount+1, a-oldCount));
//          return [a, oldCount, normallyMoving, vec2];
          oldCount = a;
        }
      }
      // </UNCERTAINTY>
    }
    return vec2;
  }
/*
  getFormattedNpcList {
    local lst1 = getNpcList;
    // vec2 = a new vector consisting of four empty lists
    local vec2 = 
      //new Vector(4, 
        [ 
          [], [], [], [], []
        ]
      //);
      ;
    local dirVal = nil;
    local prp;
    local desd; // sort descending
    local tempLst = [];
    local oldCount;
    if (lst1.length == 0)
      return vec2;
    // Put each the actors in getNpcList into one of the five elements
    // of the vec2 list, depending on whether they're north, east,
    // coincident, etc.
    for (local a = 1; a <= lst1.length; a++) {
      dirVal = dirList.indexOf(lst1[a].relDirStr);
      if (dirVal)
        vec2[dirVal] = vec2[dirVal].append(lst1[a]);
    }
    // Sort vec2's elements according to how far away the actors are.
    for (local a = 1; a <= 4; a++) {
      // Skip over this element of vec2 if it's empty.
      if (vec2[a].length > 0) {
        if (dirList[a] == 'south' || dirList[a] == 'east')
          desd = nil;
        else
          desd = true;
        if (dirList[a] == 'south' || dirList[a] == 'north')
          prp = &absYValForList;
        else
          prp = &absXValForList;
          
        vec2[a] = vec2[a].sort(desd, { x, y: x.(prp) - y.(prp) } );
        //if (me.location == skyway) { local k=0; k=k/k; }
        tempLst = [];
        oldCount = 0;
        vec2[a] = vec2[a] + formattedListToken; // coffin is a token thing to add one to the list
        for (local b = 1; b <= vec2[a].length - 1; b++) {
          if (vec2[a][b].(prp) != vec2[a][b+1].(prp)) {
            tempLst = tempLst.append(vec2[a].sublist(oldCount+1,b-oldCount));
            oldCount = b;
          }
        }
        vec2[a] = tempLst;
        
//        local elemDiff;
//        // I'll have to do the sorting manually instead:
//        tempLst = [];
//        // e.g. if the first alien listed is neton, add the list [neton] 
//        // to tempLst
//        tempLst.append([vec2[a][1]]);
//        if (me.location == skyway) { local k=0; k=k/k; }
//        if (vec2[a].length > 1) {
//          for (local b = 2; b <= vec2[a].length; b++) {
//            for (local c = 1; c <= tempLst.length; c++) {
//              elemDiff = vec2[a][b].(prp) - tempLst[c][1].(prp);
//              if (elemDiff == 0) {
//                tempLst[c] = tempLst[c].append(vec2[a][b]);
//                break;
//              }
//              else if ((elemDiff < 0 && !desd) || (elemDiff > 0 && desd)) {
//                tempLst = tempLst.insertAt(c, [vec2[a][b]]);
//                break;
//              }
//              else if (c == tempLst.length) {
//                tempLst.append([vec2[a][b]]);
//                break;
//              }
//            }
//          }
//        }
//        vec2[a] = tempLst;
      }
    }
    return vec2;
  }
*/
  sayGerundList(lst) {
    say(lst[1].curState.stateGerund(simpleListerSq(lst, 
      &theNameWrtStunning)));
    ". ";
  }
  reportParty(lst) {
    lst = lst[1];
    "<.p>";
    "\^<<lst[1].relLocStr(nil)>>, you see ";
    sayGerundList(lst);
    //simpleLister(lst, &theNameWrtStunning);
    //if (lst[1].curState.stateGerund != nil)
    //  " <<lst[1].curState.stateGerund>>";
    //". ";
  }
  reportCoincidentParty(lst) {
    local mentionedSlowing = nil;
    "<.p>\^";
    if (gPlayerChar.getOutermostRoom.isInFishCorridor) {
      // Say opening adjective phrase:
      if (lst[1][1].isVeryCloseToPc ||
          (lst[1][1].getOutermostRoom == hallway6 && me.getOutermostRoom == hallway6)) {
        "Standing here";
      }
      else {
        "<<lst[1][1].relLocStr(nil)>>";
      }
      // Continue phrase with reference to slowing field:
      if (lst[1][1].getOutermostRoom == hallway6 && 
          lst[1][1].yValue == 1 && slowingField.isOn) {
        ", in the slowing field right next to you,";
        mentionedSlowing = true;
      }
      else if (lst[1][1].getOutermostRoom == hallway6 && 
          lst[1][1].yValue == 0 && slowingField.isOn) {
        ", on the other side of the slowing field,";
        mentionedSlowing = true;
      }
      else if (lst[1][1].isVeryCloseToPc ||
          (lst[1][1].getOutermostRoom == hallway6 && 
          me.getOutermostRoom == hallway6)) {
        " right next to you";
      }
      // Give verb:
      " <<lst[1].length == 1 ? 'is' : 'are'>> ";
    }
    // List the NPC(s):
    for (local a = 1; a <= lst.length; a++) {
      if (a > 1)
        ", followed by ";
      // List the NPCs. This is a simple matter unless
      // it's the first time we've seen Vicki or Diane.
      if (!lst[a].indexOf(vicki) || vicki.hasBeenIdentified) {
        simpleLister(lst[a], &theNameWrtStunning);
      }
      // If this is the first time we've seen Vicki and Diane,
      // use &aName as the listing property.
      else {
        simpleLister(lst[a], &aName);
      }
      if (lst[a][1].getOutermostRoom == hallway6 && 
          lst[a][1].yValue == 1 && slowingField.isOn 
          && !mentionedSlowing) {
        " (in the slowing field)";
        mentionedSlowing = true;
      }
      if (lst[a][1].getOutermostRoom == hallway6 && 
          lst[a][1].yValue == 0 && slowingField.isOn 
          && !mentionedSlowing) {
        " (on the other side of the slowing field)";
        mentionedSlowing = true;
      }
    }
    // If we didn't already give the verb, say 
    // "[is/are] standing here"
    if (!gPlayerChar.getOutermostRoom.isInFishCorridor) {
      " <<lst.length == 1 && lst[1].length == 1 ? 'is' : 'are'>>
        standing here";
    }
    // Give stateGerund, if applicable.
    if (lst[1][1].curState.stateGerund('') != '') {
      if (lst.length <= 1)
        ", <<lst[1][1].curState.stateGerund('')>>";
      else
        ". They are <<lst.length == 2 ? 'both' : 'all'>>
          <<lst[1][1].curState.stateGerund('')>>";
    }
    ". ";
    //"[REPORTING COINCIDENT PARTY!] ";
    
    //lst = lst[1];
    //"<.p>";
    //"\^";
    //simpleLister(lst, &theNameWrtStunning);
    //" <<lst.length == 1 ? 'is' : 'are'>> standing here";
    ////if (gPlayerChar.getOutermostRoom == hallway6)
    ////  " ";
    //if (gPlayerChar.getOutermostRoom.isInFishCorridor)
    //  " right next to you";
    //if (lst[1].curState.stateGerund('') != '')
    //  say(lst[1].curState.stateGerund(', '));
    //". ";
    ////if (lst[1].curState.stateGerund('') != '')
    ////  ",<<lst[1].curState.stateGerund('')>>";
    ////". ";
  }
  reportNearParties(lst) {
    local largestParty = 0;
    local totalMembers = 0;
    local didParenthetical = nil;
    for (local a = 1; a <= lst.length; a++) {
      if (lst[a].length > largestParty) largestParty = lst[a].length;
      totalMembers = totalMembers + lst[a].length;
    }
    "<.p>";
    "\^<<lst[1][1].relLocStr(nil)>>, you see ";
    simpleLister(lst[1], &theNameWrtStunning);
    if (lst.length > 1) { // should always be true
      for (local a = 2; a <= lst.length; a++) {
        // Do "; " and ", " if you want.
        if (largestParty > 2) ", "; else ", ";
        "followed by ";
        simpleLister(lst[a], &theNameWrtStunning);
        // Do parenthetical stuff
        if (lst[a][1].realLocation == hallway6 && slowingField.isOn) {
          if (lst[a][1].yValue == 1) {
            " (in the slowing field)";
            didParenthetical = true;
          }
          // I decided didParenthetical is irrelevant, but I am keeping it here 
          // in case I change my mind again. Hence "didParenthetical || true".
          else if (lst[a][1].yValue == 0 && (didParenthetical || true)) {
            " (on the other side of the slowing field)";
          }
        }
      }
    }
    ". ";
    if (lst[1][1].curState.stateGerund('') != '')
      "They are <<totalMembers > 2 ? 'all' : 'both'>>
        <<lst[1][1].curState.stateGerund('')>>. ";
  }
  reportFarParties(lst, dirStr) {
    local prp;
    local lastAbsVal;
    local largestParty = 0;
    local totalMembers = 0;
    if (dirStr == 'south' || dirStr == 'north')
      prp = &absYValForList;
    else
      prp = &absXValForList;
    for (local a = 1; a <= lst.length; a++) {
      if (lst[a].length > largestParty) largestParty = lst[a].length;
      totalMembers = totalMembers + lst[a].length;
    }
    "<.p>";
    "\^<<lst[1][1].relLocStr(nil)>>, you see ";
    simpleLister(lst[1], &theNameWrtStunning);
    lastAbsVal = lst[1][1].(prp);
    if (lst.length > 1) { // should always be true
      for (local a = 2; a <= lst.length; a++) {
        // Scenario 1: This party is at least two rooms away
        // from the last party
        if (lst[a][1].(prp) - lastAbsVal > 15 ||
            lst[a][1].(prp) - lastAbsVal < 15) {
          ". Behind <<lst[a-1].length > 1 ? 'them' : 'him'>>, 
            <<lst[a][1].relLocStr(true)>>, you see ";
          simpleLister(lst[a], &theNameWrtStunning);
        }
        // Scenario 2: This party is less than two rooms away
        // from the last party
        else {
          // Do "; " and ", " if you want.
          if (largestParty > 2) ", "; else ", ";
          "followed by ";
          simpleLister(lst[a], &theNameWrtStunning);
        }
        lastAbsVal = lst[a][1].(prp);
        // no need to add parenthetical stuff; this scenario presumably
        // implies that the slowing field is not involved
      }
    }
    ". ";
    if (lst[1][1].curState.stateGerund('') != '')
      "They are <<totalMembers > 2 ? 'all' : 'both'>>
        <<lst[1][1].curState.stateGerund('')>>. ";
    //if (lst[1][1].curState.stateGerund != nil)
    //  "They are <<totalMembers > 2 ? 'all' : 'both'>>
    //    <<lst[1][1].curState.stateGerund>>";
    //". ";
  }
  giveNpcReport {
    local lst = glob.getFormattedNpcList(nil);
    local lastAbsVal = 0;
    local largestGap = 0;
    local thisGap = 0;
    local dirStr;
    local prp;
    // This report works fine for all cases of seeing NPCs
    // within the alien building -- *except for one*.
    // Namely, it does a bad job of reporting the guards
    // and professors in the conference room during the game's
    // intro. So deal with that as a special case.
    if (!glob.isInEndgame && gPlayerChar.isIn(confRoom)) {
      if (gPlayerChar.canSee(youngGuard) &&
          gPlayerChar.canSee(oldGuard)) {
        "<.p>The young guard and the old guard are 
           standing here on either side of the door. ";
      }
      if (gPlayerChar.canSee(neton) &&
          gPlayerChar.canSee(ovan)) {
        if (neton.name != 'Neton')
          "<.p>Two aliens, in jackets of green and yellow,
            are sitting across the table from you. ";
        else
          "<.p>Neton and Ovan are sitting across the table
            from you. ";
      }
      // Important: this ensures that the NPCs in the
      // conference room aren't mentioned twice.
      return;
    }
    
    
    
    // If there is a coincident party, report it first.
    if (lst[5] && lst[5].length) {
      reportCoincidentParty(lst[5]);
    }
    for (local a = 1; a <= 4; a++) {
      // zero parties: do nothing
      if (lst[a].length == 0) {
      }
      // one party: do the one-party report
      else if (lst[a].length == 1) {
        reportParty(lst[a]);
      }
      // more than one party
      else {
        dirStr = dirList[a];
        // if there are at least two parties, and if they're towards the
        // south, and if the slowing field is off, then check to see if any
        // of the parties are at least two rooms apart from each other. 
        // If so, use reportFarParties(). Otherwise, use reportNearParties().
        if (!slowingField.isOn && dirStr == 'south') {
        
          if (dirStr == 'north' || dirStr == 'south')
            prp = &absYValForList;
          else
            prp = &absXValForList;
          lastAbsVal = lst[a][1][1].(prp);
          for (local b = 2; b <= lst[a].length; b++) {
            thisGap = lst[a][b][1].(prp) - lastAbsVal;
            if (thisGap < 0) thisGap = 0 - thisGap;
            if (thisGap > largestGap) largestGap = thisGap;
          }
          if (largestGap > 15)
            reportFarParties(lst[a], dirStr);
          else
            reportNearParties(lst[a]);
        }
        // In this case, there's more than one party, but either the
        // slowing field is on or else the direction is not south.
        // When this happens, there's never any need to do the 
        // "far party" report.
        else {
          reportNearParties(lst[a]);
        }
      }
    }
    //"<.p>Zoinks. ";
  }
  //local vec2 = 
  //  [ 
  //    [], // NPCs moving normally, whether slowed or not
  //    [], // NPCs who have just stepped into the slowing field
  //    [], // NPCs (i.e. guards) who have just stepped into view from the west
  //    []  // NPCs (i.e. assistant) have just stepped out of the confRoom
  //  ]
  //;
//  giveNpcReportForMovement {
//    local lst = glob.getFormattedAlienListForMovement;
//    local lastAbsVal = 0;
//    local largestGap = 0;
//    local thisGap = 0;
//    local dirStr;
//    local prp;
//    // If there is a coincident party, report it first.
//    if (lst[5] && lst[5].length) {
//      reportCoincidentParty(lst[5]);
//    }
//    for (local a = 1; a <= 4; a++) {
//      // zero parties: do nothing
//      if (lst[a].length == 0) {
//      }
//      // one party: do the one-party report
//      else if (lst[a].length == 1) {
//        reportParty(lst[a]);
//      }
//      // more than one party
//      else {
//        dirStr = dirList[a];
//        // if there are more than two parties, and if they're towards the
//        // south, and if the slowing field is off, then check to see if any
//        // of the parties are at least two rooms apart from each other. 
//        // If so, use reportFarParties(). Otherwise, use reportNearParties().
//        if (!slowingField.isOn && dirStr == 'south') {
//        
//          if (dirStr == 'north' || dirStr == 'south')
//            prp = &absYValForList;
//          else
//            prp = &absXValForList;
//          lastAbsVal = lst[a][1][1].(prp);
//          for (local b = 2; b <= lst[a].length; b++) {
//            thisGap = lst[a][b][1].(prp) - lastAbsVal;
//            if (thisGap < 0) thisGap = 0 - thisGap;
//            if (thisGap > largestGap) largestGap = thisGap;
//          }
//          if (largestGap > 15)
//            reportFarParties(lst[a], dirStr);
//          else
//            reportNearParties(lst[a]);
//        }
//        // In this case, there's more than one party, but either the
//        // slowing field is on or else the direction is not south.
//        // When this happens, there's never any need to do the 
//        // "far party" report.
//        else {
//          reportNearParties(lst[a]);
//        }
//      }
//    }
//    //"<.p>Zoinks. ";
//  }
  
/*  
  giveNpcReport {
    local lst = glob.getFormattedNpcList;
    local lastAbsVal = 0;
    local largestGap = 0;
    local thisGap = 0;
    local dirStr;
    local prp;
    for (local a = 1; a <= 4; a++) {
      // zero parties: do nothing
      if (lst[a].length == 0) {
      }
      // one party: do the one-party report
      else if (lst[a].length == 1) {
        reportParty(lst[a]);
      }
      // more than one party
      else {
        dirStr = dirList[a];
        // if there are more than two parties, and if they're towards the
        // south, and if the slowing field is off, then check to see if any
        // of the parties are at least two rooms apart from each other. 
        // If so, use reportFarParties(). Otherwise, use reportNearParties().
        if (!slowingField.isOn && dirStr == 'south') {
        
          if (dirStr == 'north' || dirStr == 'south')
            prp = &absYValForList;
          else
            prp = &absXValForList;
          lastAbsVal = lst[a][1][1].(prp);
          for (local b = 2; b <= lst[a].length; b++) {
            thisGap = lst[a][b][1].(prp) - lastAbsVal;
            if (thisGap < 0) thisGap = 0 - thisGap;
            if (thisGap > largestGap) largestGap = thisGap;
          }
          if (largestGap > 15)
            reportFarParties(lst[a], dirStr);
          else
            reportNearParties(lst[a]);
        }
        // In this case, there's more than one party, but either the
        // slowing field is on or else the direction is not south.
        // When this happens, there's never any need to do the 
        // "far party" report.
        else {
          reportNearParties(lst[a]);
        }
      }
    }
    //"<.p>Zoinks. ";
  }
*/
;

formattedListToken: object
  absYValForList = -1
  absXValForList = -1
;

formattedMovementListToken: object
  absoluteYValue = 10000
  absoluteXValue = 10000
;

// A very useful function, worth including in future TADS 3 projects. 
// To output something like "Neton, Ovan, and the old guard", 
// simply call simpleLister([neton, ovan, oldGuard], &theName);

simpleLister(lst, prop) {
  for (local a = 1; a <= lst.length; a++) {
    if (!prop) say(lst[a]);
    else say (lst[a].(prop));
    if (lst.length > 2 && a < lst.length)
      ", ";
    if (a == 1 && lst.length == 2)
      " ";
    if (a + 1 == lst.length)
      "and ";
  }
}

// A variation of the above simpleLister function, returning
// a single-quoted string instead of actually doing output.
simpleListerSq(lst, prop) {
  local msg = '';
  for (local a = 1; a <= lst.length; a++) {
    if (!prop) msg += lst[a];
    else msg += lst[a].(prop);
    if (lst.length > 2 && a < lst.length)
      msg += ', ';
    if (a == 1 && lst.length == 2)
      msg += ' ';
    if (a + 1 == lst.length)
      msg += 'and ';
  }
  return msg;
}

// -------------------------------------------------------------------
// NPCS: ALIENS: NPC description reports (outdated)
// -------------------------------------------------------------------

//mobj: Fixture
//  location = hallway9
//  //isListed() {
//  //  if (me.canSee(neton) 
//  //   || me.canSee(ovan)
//  //   || me.canSee(youngGuard)
//  //   || me.canSee(oldGuard)
//  //   || me.canSee(assistant)) return true;
//  //  else return nil;
//  //}
//  //isListedInContents = isListed()
//  specialDesc() {
//    local a, cur;
//    occupyingMuseum    = [];
//    occupyingSkyway2   = [];
//    occupyingSkyway1   = [];
//    occupyingSkyway0   = [];
//    occupyingSkywayN   = [];
//    occupyingHallway92 = [];
//    occupyingHallway91 = [];
//    occupyingHallway90 = [];
//    occupyingHallway9N = [];
//    occupyingStairs2   = [];
//    occupyingStairs1   = [];
//    occupyingStairs0   = [];
//    occupyingStairsN   = [];
//    occupyingHallway62 = [];
//    occupyingHallway61 = [];
//    occupyingHallway60 = [];
//    occupyingConfRoom  = [];
//    totalCount = 0;
//    glassCount = 0;
//    skywayCount = 0;
//    hallway9Count = 0;
//    southStairsCount = 0;
//    hallway6Count = 0;
//    for (a = 1; a <= 5; ++a) {
//      switch (a) {
//        case 1: cur = neton; break;
//        case 2: cur = ovan; break;
//        case 3: cur = youngGuard; break;
//        case 4: cur = oldGuard; break;
//        case 5: cur = assistant; break;
//      }
//      switch (cur.getOutermostRoom) {
//        case museum: 
//          occupyingMuseum = occupyingMuseum + [cur];
//          break;
//        case skyway:
//          switch (cur.yValue) {
//            case  2: occupyingSkyway2 = occupyingSkyway2 + [cur]; break;
//            case  1: occupyingSkyway1 = occupyingSkyway1 + [cur]; break;
//            case -1: occupyingSkywayN = occupyingSkywayN + [cur]; break;
//            default: occupyingSkyway0 = occupyingSkyway0 + [cur]; break;
//          }
//          break;
//        case hallway9:
//          switch (cur.yValue) {
//            case  2: occupyingHallway92 = occupyingHallway92 + [cur]; break;
//            case  1: occupyingHallway91 = occupyingHallway91 + [cur]; break;
//            case -1: occupyingHallway9N = occupyingHallway9N + [cur]; break;
//            default: occupyingHallway90 = occupyingHallway90 + [cur]; break;
//          }
//          break;
//        case stairs:
//          switch (cur.yValue) {
//            case  2: occupyingStairs2 = occupyingStairs2 + [cur]; break;
//            case  1: occupyingStairs1 = occupyingStairs1 + [cur]; break;
//            case -1: occupyingStairsN = occupyingStairsN + [cur]; break;
//            default: occupyingStairs0 = occupyingStairs0 + [cur]; break;
//          }
//          break;
//        case hallway6:
//          switch (cur.yValue) {
//            case  2: occupyingHallway62 = occupyingHallway62 + [cur]; break;
//            case  1: occupyingHallway61 = occupyingHallway61 + [cur]; break;
//            default: occupyingHallway60 = occupyingHallway60 + [cur]; break;
//          }
//          break;
//        case confRoom:
//          if (confDoor.isOpen) occupyingConfRoom = occupyingConfRoom + [cur];
//          break;
//      }
//    }
//    if (!occupyingMuseum.length
//     && !occupyingSkyway2.length
//     && !occupyingSkyway1.length
//     && !occupyingSkyway0.length
//     && !occupyingSkywayN.length
//     && !occupyingHallway92.length
//     && !occupyingHallway91.length
//     && !occupyingHallway90.length
//     && !occupyingHallway9N.length
//     && !occupyingStairs2.length
//     && !occupyingStairs1.length
//     && !occupyingStairs0.length
//     && !occupyingStairsN.length
//     && !occupyingHallway62.length
//     && !occupyingHallway61.length
//     && !occupyingHallway60.length
//     && !occupyingConfRoom.length) {
//      return nil;
//    }
//    //totalCount = 0;
//    if (occupyingMuseum.length)    mentionMuseum.doScript();
//    if (occupyingSkyway2.length)   mentionSkyway2.doScript();
//    if (occupyingSkyway1.length)   mentionSkyway1.doScript();
//    if (occupyingSkyway0.length)   mentionSkyway0.doScript();
//    if (occupyingSkywayN.length)   mentionSkywayN.doScript();
//    if (occupyingHallway92.length) mentionHallway92.doScript();
//    if (occupyingHallway91.length) mentionHallway91.doScript();
//    if (occupyingHallway90.length) mentionHallway90.doScript();
//    if (occupyingHallway9N.length) mentionHallway9N.doScript();
//    if (occupyingStairs2.length)   mentionStairs2.doScript();
//    if (occupyingStairs1.length)   mentionStairs1.doScript();
//    if (occupyingStairs0.length)   mentionStairs0.doScript();
//    if (occupyingStairsN.length)   mentionStairsN.doScript();
//    if (occupyingHallway62.length) mentionHallway62.doScript();
//    if (occupyingHallway61.length) mentionHallway61.doScript();
//    if (occupyingHallway60.length) mentionHallway60.doScript();
//    if (occupyingConfRoom.length)  mentionConfRoom.doScript();
//    return true;
//    //"There appear to be aliens within visual range! ";
//    //return true;
//  }
//  specialDescBeforeContents = nil
//  occupyingMuseum    = []
//  occupyingSkyway2   = []
//  occupyingSkyway1   = []
//  occupyingSkyway0   = []
//  occupyingSkywayN   = []
//  occupyingHallway92 = []
//  occupyingHallway91 = []
//  occupyingHallway90 = []
//  occupyingHallway9N = []
//  occupyingStairs2   = []
//  occupyingStairs1   = []
//  occupyingStairs0   = []
//  occupyingStairsN   = []
//  occupyingHallway62 = []
//  occupyingHallway61 = []
//  occupyingHallway60 = []
//  occupyingConfRoom  = []
//  tokenList = []
//  totalCount = 0
//  glassCount = 0
//  skywayCount = 0
//  hallway9Count = 0
//  southStairsCount = 0
//  hallway6Count = 0
//;
//
//class MentionScript: object
//  giveList() {
//    local str = '';
//    for (local a = 1; a<=asscList.length; ++a) {
//      str = str + asscList[a].theName;
//      if (a < asscList.length) {
//        if (asscList.length > 2) str = str + ', ';
//        else str = str + ' ';
//      }
//      if (a == asscList.length - 1)
//        str = str + 'and ';
//    }
//    return str;
//  }
//  asscList = mobj.tokenList
//;
//class SkywayScript: MentionScript
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    if (mobj.skywayCount) str = str + 'also ';
//    str = str + 'in the skyway';
//    if (!mobj.totalCount) str = str + ' to the south';
//    str = str + ', you can see ';
//    str = str + giveList;
//    str = str + ' charging towards you ';
//    if (slowingField.isOn) str = str + 'in absurdly slow motion. ';
//    else if (asscList.length > 1) str = str + 'as fast as they can. ';
//    else str = str + 'as fast as he can. ';
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    mobj.totalCount++;
//    mobj.skywayCount++;
//  }
//;
//class Hallway9Script: MentionScript
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    if (!mobj.totalCount) str = str + 'to the south, ';
//    if (mobj.hallway9Count) str = str + 'also in the hallway';
//    else str = str + 'in the hallway at the top of the stairs';
//    str = str + ', you can see ';
//    str = str + giveList;
//    str = str + ' charging towards you ';
//    if (slowingField.isOn) str = str + 'in absurdly slow motion. ';
//    else if (asscList.length > 1) str = str + 'as fast as they can. ';
//    else str = str + 'as fast as he can. ';
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    mobj.totalCount++;
//    mobj.hallway9Count++;
//  }
//;
//class SouthStairsScript: MentionScript
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    
//    str = str + 'as you ';
//    //if (mobj.glassCount) str = str + 'continue to ';
//    str = str + 'look ';
//    if (!mobj.totalCount) 'south ';
//    str = str + 'through the glass floor ';
//    //if (mobj.glassCount && !mobj.southStairsCount)
//    //  str = str + ', this time';
//    str = str + ' to the other side of the stairs';
//    
//    str = str + ', you can see ';
//    str = str + giveList;
//    str = str + ' charging towards you ';
//    if (slowingField.isOn) str = str + 'in absurdly slow motion. ';
//    else if (asscList.length > 1) str = str + 'as fast as they can. ';
//    else str = str + 'as fast as he can. ';
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    mobj.totalCount++;
//    mobj.glassCount++;
//    mobj.southStairsCount++;
//  }
//;
//class Hallway6Script: MentionScript
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    
//    str = str + 'as you ';
//    //if (mobj.glassCount) str = str + 'continue to ';
//    str = str + 'look ';
//    if (!mobj.totalCount) 'south ';
//    str = str + 'through the glass floor ';
//    if (mobj.glassCount && !mobj.southStairsCount)
//      str = str + ', this time';
//    str = str + ' to the hallway';
//    if (!hallway6Count) str = str + ' at the bottom of the stairs';
//    else str = str + ' beyond';
//    
//    str = str + ', you can see ';
//    str = str + giveList;
//    if (!killChargingText) {
//      str = str + ' charging towards you ';
//      if (slowingField.isOn) str = str + 'in absurdly slow motion';
//      else if (asscList.length > 1) str = str + 'as fast as they can';
//      else str = str + 'as fast as he can';
//    }
//    str = str + '. ';
//    if (mentionSlowingField && slowingField.isOn) {
//      if (asscList.length > 1) str = str + 'They are ';
//      else str = str + 'He is ';
//      str = str + 'presently caught in the slowing field. ';
//    }
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    mobj.totalCount++;
//    mobj.glassCount++;
//    mobj.hallway6Count++;
//  }
//;
//mentionMuseum: MentionScript
//  doScript() {
//    local netonIsInMuseum = nil;
//    local ovanIsInMuseum = nil;
//    local alienDir = 8; // 7=SW; 8=S; 9=SE
//    local alienInQuestion = neton;
//    if (neton.getOutermostRoom == museum) netonIsInMuseum = true;
//    if ( ovan.getOutermostRoom == museum)  ovanIsInMuseum = true;
//    if (netonIsInMuseum || ovanIsInMuseum)
//      mobj.totalCount++;
//    if (netonIsInMuseum && ovanIsInMuseum)
//      alienDir = 8;
//    else {
//      if (netonIsInMuseum) alienInQuestion = neton;
//      else alienInQuestion = ovan;
//      if (alienInQuestion.xValue < me.xValue) alienDir = 7;
//      else if (alienInQuestion.xValue > me.xValue) alienDir = 9;
//      else alienDir = 8;
//    }
//    "\b";
//    if (netonIsInMuseum && ovanIsInMuseum) "Neton and Ovan are ";
//    else if (netonIsInMuseum) "Neton is ";
//    else "Ovan is ";
//    "to your ";
//    if (alienDir == 7) "southwest ";
//    if (alienDir == 9) "southeast ";
//    else "south ";
//    "here in the museum. ";
//    if (netonIsInMuseum && ovanIsInMuseum) "They are ";
//    else "He is ";
//    "charging ";
//    if (alienDir == 7) "northeast ";
//    if (alienDir == 9) "northwest ";
//    else "north ";
//    "towards you ";
//    if (slowingField.isOn) "in absurdly slow motion. ";
//    else {
//      if (netonIsInMuseum && ovanIsInMuseum) "as fast as they can. ";
//      else "as fast as he can. ";
//    }
//    //"<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//  }
//;
//mentionSkyway2: SkywayScript
//  asscList = mobj.occupyingSkyway2
//;
//mentionSkyway1: SkywayScript
//  asscList = mobj.occupyingSkyway1
//;
//mentionSkyway0: SkywayScript
//  asscList = mobj.occupyingSkyway0
//;
//mentionSkywayN: SkywayScript
//  asscList = mobj.occupyingSkywayN
//;
//mentionHallway92: Hallway9Script
//  asscList = mobj.occupyingHallway92
//;
//mentionHallway91: Hallway9Script
//  asscList = mobj.occupyingHallway91
//;
//mentionHallway90: Hallway9Script
//  asscList = mobj.occupyingHallway90
//;
//mentionHallway9N: Hallway9Script
//  asscList = mobj.occupyingHallway9N
//;
//mentionStairs2: MentionScript
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    str = str + 'at the top of the stairs';
//    if (!mobj.totalCount) str = str + ' to the south';
//    str = str + ', you can see ';
//    str = str + giveList;
//    str = str + ' charging towards you ';
//    if (slowingField.isOn) str = str + 'in absurdly slow motion. ';
//    else if (asscList.length > 1) str = str + 'as fast as they can. ';
//    else str = str + 'as fast as he can. ';
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    mobj.totalCount++;
//    mobj.hallway9Count++;
//  }
//  asscList = mobj.occupyingStairs2
//;
//mentionStairs1: MentionScript
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    str = str + 'approaching the top of the stairs';
//    if (!mobj.totalCount) str = str + ' to the south';
//    str = str + ', you can see ';
//    str = str + giveList;
//    str = str + ' charging towards you ';
//    if (slowingField.isOn) str = str + 'in absurdly slow motion. ';
//    else if (asscList.length > 1) str = str + 'as fast as they can. ';
//    else str = str + 'as fast as he can. ';
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    mobj.totalCount++;
//    mobj.hallway9Count++;
//  }
//  asscList = mobj.occupyingStairs1
//;
//mentionStairs0: SouthStairsScript
//  asscList = mobj.occupyingStairs0
//;
//mentionStairsN: SouthStairsScript
//  asscList = mobj.occupyingStairsN
//;
//mentionHallway62: Hallway6Script
//  asscList = mobj.occupyingHallway62
//;
//mentionHallway61: Hallway6Script
//  mentionSlowingField = true
//  asscList = mobj.occupyingHallway61
//;
//mentionHallway60: Hallway6Script
//  killChargingText = true
//  /*
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    
//    str = str + 'as you ';
//    //if (mobj.glassCount) str = str + 'continue to ';
//    str = str + 'look ';
//    if (!mobj.totalCount) 'south ';
//    str = str + 'through the glass floor ';
//    if (mobj.glassCount && !mobj.southStairsCount)
//      str = str + ', this time';
//    str = str + ' to the hallway';
//    if (!hallway6Count) str = str + ' at the bottom of the stairs';
//    else str = str + ' beyond';
//    
//    str = str + ', you can see ';
//    str = str + giveList;
//    str = str + '. ';
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    //str = str + ' charging towards you ';
//    //if (slowingField.isOn) str = str + 'in absurdly slow motion. ';
//    //else if (asscList.length > 1) str = str + 'as fast as they can. ';
//    //else str = str + 'as fast as he can. ';
//    mobj.totalCount++;
//    mobj.glassCount++;
//    mobj.hallway6Count++;
//  }
//  */
//  asscList = mobj.occupyingHallway60
//;
//mentionConfRoom: MentionScript
//  doScript() {
//    local str = '';
//    if (mobj.totalCount > 1) str = 'still farther back, ';
//    else if (mobj.totalCount == 1) str = 'farther back, ';
//    
//    str = str + 'as you ';
//    //if (mobj.glassCount) str = str + 'continue to ';
//    str = str + 'look ';
//    if (!mobj.totalCount) 'south ';
//    str = str + 'through the glass floor ';
//    if (mobj.glassCount)
//      str = str + ', this time';
//    str = str + ' to the conference room at the very far end of the hallway';
//    
//    str = str + ', you can see ';
//    str = str + giveList;
//    str = str + ' charging towards you ';
//    if (slowingField.isOn) str = str + 'in absurdly slow motion. ';
//    else if (asscList.length > 1) str = str + 'as fast as they can. ';
//    else str = str + 'as fast as he can. ';
//    "<.p><<str.substr(1,1).toUpper>><<str.substr(2)>>";
//    mobj.totalCount++;
//    mobj.glassCount++;
//    mobj.hallway6Count++;
//  }
//  asscList = mobj.occupyingConfRoom
//;
//
//alienChasingSpecialDesc: ListGroupPrefixSuffix
//  groupPrefix = "\^"
//  groupSuffix = " are infesting the nearby area with their evil presence. "
//  createGroupSublister(parentLister) { return plainActorLister; }
//;
//
//class AlienNorthwards: ActorState
//  isInitState = true
//  specialDesc = nil
//  remoteSpecialDesc(pov) { return nil; }
//  distantSpecialDesc(pov) { return nil; }
//  //specialDesc = "<<getActor.name>>: Alien going northwards! "
//  //remoteSpecialDesc(pov) { "<<getActor.name>>: Alien going northwards! "; }
//  //distantSpecialDesc(pov) { "<<getActor.name>>: Alien going northwards! "; }
//  //specialDescListWith = [alienChasingSpecialDesc]
//;
//netonNorthwards:     AlienNorthwards location = neton;
//ovanNorthwards:      AlienNorthwards location = ovan;
//youngGuardNorthwards:    AlienNorthwards location = youngGuard;
//oldGuardNorthwards:    AlienNorthwards location = oldGuard;
//assistantNorthwards: AlienNorthwards location = assistant;

// -------------------------------------------------------------------
// NPCS: ALIENS: NPC ACTION REPORTS: endgameProfSequence (arguing)
// -------------------------------------------------------------------

// The following methods are designed to give reports about
// the NPCs, mainly when they are not in action -- e.g., for 
// room descriptions.

//enum open, closed;

endgameProfSequence: object 
  epsValue = 0
  netonMentionedCrash = nil
  seeProfs {
    "Then you turn your head, and you see Neton and Ovan 
      through the glass window to the north. 
      Fortunately, it seems that you are safely cut off 
      from them, as no door connects their room to yours. ";
  }
  firstPartOfSequence {
    ". . . and then you wake up. After a moment of disorientation, 
      the room comes into focus. You are lying on your back 
      on the couch, with the metal bulb just above your head. ";
  }
  secondPartOfSequence {
    "Through the window Neton glimpses you and says, 
        <.q>What! The human has awakened!<./q>
      <p>Ovan looks over at you and says, 
        <.q>I don<./s>t believe it! I made sure there 
        was no solution to the conversation menu!<./q>
      <p><.q>He didn<./s>t solve it,<./q> 
        says Neton irritably. <.q>He crashed the program.<./q>
      <p><.q>Oh,<./q> says Ovan. ";
  }
  //profsAreArguing = nil
  execute {
    //pleaseSay('<.p><font color=red><b>Running endgameProfSequence.execute.</b></font><.p>');
    epsValue++;
    // Whenever this method runs, it always means that the profs
    // are arguing, unless we specifically say down below that they
    // are done arguing.
    glob.enemyState = arguing;
    "<.p>";
    switch (epsValue) {
      case 1:
        //". . . and then you wake up. After a moment of disorientation, 
        //  the room comes into focus. You are lying on your back 
        //  on the couch, with the metal bulb just above your head. ";
        firstPartOfSequence;
        break;
      case 2:
        if (!dreamRoom.hasDefinitelyBeenDescribed) {
          gPlayerChar.lookAround(true);
          "<.p>";
        }
        secondPartOfSequence;
        netonMentionedCrash = true;
        break;
      case 3:
        "Beyond the window to the north, Neton points 
            to his computer and turns to Ovan. <.q>See here? 
            It says <.s>Subscript out of range in 
            caveMaze7.roomCount.<./s> You programmed that! 
            This is your fault!<./q>
          <p><i><.q>My</i> fault?<./q> Ovan retorts. 
            <.q>It<./s>s not <i>my</i> fault that 
            <i>your</i> programming language makes games crash. 
            Honestly, just because a number gets too big, 
            it makes games crash? Please!<./q> ";
        break;
      case 4:
        "Beyond the window to the north, Neton says, 
            <.q>I had a very good reason for doing it that 
            way. Not that you<./s>d understand, 
            Mr. I<./s>m-Just-An-Associate-Professor. 
            You didn<./s>t even know what a Boolean expression 
            was before I taught you.<./q>
          <p><.q>Oh, right,<./q> says Ovan, rolling his eyes. 
            <.q>I<./s>m sure you crawled out of your 
            mother<./s>s womb with expert-level knowledge on 
            Boolean expressions.<./q> ";
        break;
      case 5:
        "Beyond the window to the north, Neton says, 
            <.q>Don<./s>t you mouth off to me! This is 
            not the first time you<./s>ve fouled up. 
            After you worked on the Mexico maze, you said, 
            <.s>Neton, it<./s>s broken. Can you fix it?<./s> 
            After the pyramid maze, you said, 
            <.s>Neton, it<./s>s broken. Can you 
            fix it?<./s> When are you going to 
            learn to get things right?<./q>
          <p>Ovan shrugs. <.q>I guess whenever you<./s>re 
            not around to fix things,<./q> he says.
          <p>Neton<./s>s eyes bug out. Then he shouts, 
            <.q>You useless idiot!<./q> ";
        break;
      case 6:
        "Then, beyond the window to the north, 
            Ovan says, <.q>So you think I<./s>m an idiot, 
            do you? Well, just don<./s>t forget 
            why you got me to work on your game.<./q>
          <p><.q>Oh yeah? Why<./s>s that?<./q> says Neton.
          <p><.q>Because you couldn<./s>t write an imaginative 
            puzzle if your life depended on it!<./q> 
            shouts Ovan. <.q>And, oh yeah. One more 
            thing. Your room descriptions suck!<./q> ";
        break;
      case 7:
        "Beyond the window to the north, Neton rolls 
            his eyes sharply. <.q>For crying out 
            loud,<./q> he says. <.q>That<./s>s the last time 
            I ever give you a compliment. 
            <.s>Nice puzzles,<./s> I say once, and 
            already you<./s>ve got a big head.<./q>
          <p><.q>You said it twice,<./q> says Ovan.
          <p><.q>And all because I asked you to do a few 
            puzzles,<./q> says Neton. <.q>I suppose 
            if I hired you to do my laundry, 
            you<./s>d say I couldn<./s>t do it 
            myself. If I had you clean my toilets, you<./s>d 
            say you<./s>re better than me.<./q>";
        //<p>Ovan sputters a bit, speechless. 
        break;
      case 8:
        "Beyond the window to the north, Neton 
            isn<./s>t done with his rant. He says, 
            <.q>I can<./s>t believe you have the nerve 
            to say I can<./s>t write puzzles. 
            For crying out loud, anyone can see 
            you<./s>re just jealous of me!<./q>
          <p><i><.q>Jealous!<./q></i> Ovan squeals. 
            <.q>What could I possibly be jealous of?<./q>
          <p><.q>The fact that I solved <i>Cave Maze VII</i> 
            on my own, but you had to resort to a 
            walkthrough!<./q> says Neton triumphantly.
          <p>Ovan gasps, then hangs his head. 
            The knife has cut deep. ";
        break;
      case 9:
        "Beyond the window to the north, Ovan hangs 
            in a dismal funk. Several long seconds go by.
          <p>Then, finally, Ovan summons all his energy, 
            pulls himself together, and says, 
            <.q>Okay, Neton. You got me. I wasn<./s>t 
            smart enough to solve <i>Cave Maze VII</i> 
            on my own. And I wasn<./s>t 
            smart enough to do the programming right. 
            Heck, you<./s>re probably right to call me 
            a useless idiot. Well, fine. In that case, 
            since I<./s>m just a burden to you, I<./s>ll 
            shove off and leave you alone. 
            You think they<./s>ll let me work 
            in the salt mines? Ah, well. Maybe not. 
            But I<./s>ll find something.<./q>
          <p>With that, Ovan collects his things and gets 
            ready to go. ";
        break;
      case 10:
        "Beyond the window to the north, Neton breathes a 
            heavy sigh. Then he says, <.q>Oh, come on, Ovan. 
            You know you<./s>re not a burden. And you<./s>re not 
            an idiot, either.<./q>
          <p><.q>Yes I am,<./q> says Ovan, the tears welling up.
          <p><.q>No, you<./s>re not,<./q> says Neton. <.q>In fact, 
            you did design most of the game<./s>s best puzzles. 
            I would never have thought of the Mexico or pyramid puzzles
            on my own. Heck, I couldn<./s>t have finished the game
            without you.<./q>
          <p>Ovan brightens. <.q>You mean it?<./q>
          <p><.q>You bet,<./q> says Neton.
          <p>With that, Ovan gives a wide grin. 
            <.q>Aw, thanks, Neton!<./q> he says. ";
        break;
      case 11:
        "Beyond the window to the north, Neton says, 
            <.q>Now, come on. We<./s>ve got a lot of work 
            to do. We<./s>ve got to deal with this human. And I 
            tell you what. When we find him, I<./s>ll let you 
            deliver the fatal blow.<./q>
          <p><.q>Hey, that sounds like fun!<./q> says Ovan, 
            smiling enormously once again.
          <p><.q>Come to think of it, let<./s>s hurry,<./q> 
            says Neton. <.q>I don<./s>t actually remember locking 
            the door! Let<./s>s get the guards, too. 
            And I<./s>ll lock down the computers, just in case.<./q>
          <p>With that, Neton pushes a few buttons on his computer.
            Then the two of them pick up a couple of weapons that
            look like icepicks. Having done this, they head off 
            to the west. ";
        // The "hypodermic needle" version is commented out here:
        //"Beyond the window to the north, Neton says, 
        //    <.q>Now, come on. We<./s>ve got a lot of work 
        //    to do. We<./s>ve got to catch this human. And I 
        //    tell you what. When we find him, I<./s>ll let you 
        //    deliver the lethal injection.<./q>
        //  <p><.q>Hey, that sounds like fun!<./q> says Ovan, smiling 
        //    enormously once again.
        //  <p><.q>Come to think of it, let<./s>s hurry,<./q> 
        //    says Neton. <.q>I don<./s>t actually remember locking 
        //    the door! Let<./s>s get the guards, too.<./q>
        //  <p>The two of them pick up a couple of hypodermic 
        //    needles. With that, you see them head off to the west. ";
        letProfsExitOffice();
        glob.enemyState = goingToHallway6;
        break;
    }
  }
;

letProfsExitOffice() {
  netonIcepick.moveInto(neton);
  ovanIcepick.moveInto(ovan);
  //ovanPda.moveInto(ovan);
  // Ovan's tablet device is not needed, and I do not want to deal with
  // the disambiguation consequences of having its buttons around
  // in the corridor where the other buttons are.
  ovanPda.moveInto(nil); 
  officeDoor.makeOpen(true);
  neton.scMoveInto(hallway8);
  ovan.scMoveInto(hallway8);
}

// -------------------------------------------------------------------
// NPCS: ALIENS: NPC ACTION REPORTS: enemyState, etc.
// -------------------------------------------------------------------

// -------------------
// enemyState

enum arguing, waiting, goingToHallway6, goingToMuseum;

modify glob
  //profsAreArguing = nil
  enemyState = arguing
;

// -------------------
// noteMistake

noteMistake(str) {
  glob.mistakeStr = str;
}

modify glob
  mistakeStr = nil
;

// -------------------------------------------------------------------
// NPCS: ALIENS: NPC ACTION REPORTS: endgameDaemon
// -------------------------------------------------------------------

// endgameDaemon is by no means designed only to tell what NPCs do
// each turn, though that is part of it. This daemon also contains 
// all the stuff that needs to be done after normal action handling 
// in the endgame, as well as a couple of things in the intro as 
// well.

modify glob
  isInEndgame = nil
  endgameJeopardy = true
  iHaveBeenOnAquaPed = nil
;

endgameDaemon: DaemonComponent
  //location = me
  daemonID = nil
  startDaemon {
    moveInto(gPlayerChar);
    if (daemonID == nil) {
      daemonID = new Daemon(self, &daemon, 1);
    }
    // Otherwise, if the daemon is already running, let it continue.
  }
  endDaemon {
    if (daemonID != nil) daemonID.removeEvent;
    daemonID = nil;
    moveInto(nil);
  }
  thisDaemonHasBeenRunDuringEndgameJeopardy = nil
  daemon {
    // ---------------------
    // PART 1: BEFORE doEndgameJeopardy
    //
    // 1A. Set variable: glob.isInEndgame
    //
    // First, set the glob.isInEndgame variable properly.
    if (!me.isIn(confRoom) && !me.isIn(cell)) {
      glob.isInEndgame = true;
    }
    
    // 1B. Conference room stuff
    // 
    // Next, deal with confDaemon, a faux daemon, which does the 
    // Neton/Ovan conversation in the intro. Why is this introductory
    // thing in the endgameDaemon? I don't know. This part of the code
    // is months (years) old, and I'm scared to change it too much,
    // for fear of unintended consequences.
    if (confDaemon.isActive) {
      confDaemon.daemon;
    }
    glob.pluralTalkers = nil;
    
    // 1C. Announce recent mistake
    // 
    // As a top priority before printing out any other daemon text
    // for the endgame, let's report any thoughts the PC might have 
    // about having made a mistake.
    if (glob.mistakeStr) {
      if (glob.mistakeStr == true)
        "<.p>Some part of you wonders if you may have 
          made a mistake. ";
      else
        "<.p>\^<<glob.mistakeStr>>, some part of you
          wonders if you may have made a mistake. ";
      glob.mistakeStr = nil;
    }
    
    // ---------------------
    // PART 2: Call endgame jeopardy
    // 
    // Call endgameJeopardy() to let the NPCs execute their agenda.
    // That is, let them argue with each other, chase you, and/or 
    // try to kill you.
    //
    // 2A. Set variables
    // Make sure glob.enemyState is set to the proper value,
    // as well as thisDaemonHasBeenRunDuringEndgameJeopardy.
    if (glob.endgameJeopardy && !thisDaemonHasBeenRunDuringEndgameJeopardy) {
      if (gPlayerChar.isIn(dreamRoom)) {
        glob.enemyState = arguing;
      }
      thisDaemonHasBeenRunDuringEndgameJeopardy = true;
    }
    // 2B. Wake stunned NPCs.
    // Stunned NPCs must wake up **before** doEndgameJeopardy().
    if (glob.isInEndgame) {
      neton.pseudoStunDaemon;
      ovan.pseudoStunDaemon;
      oldGuard.pseudoStunDaemon;
      youngGuard.pseudoStunDaemon;
      assistant.pseudoStunDaemon;
    }
    // 2C. Do endgame jeopardy.
    // 
    // doEndgameJeopardy() will handle all the moving of the aliens,
    // their arguing, walking around, trying to kill you, etc.
    // We now execute doEndgameJeopardy even when glob.endgameJeopardy == nil
    // (because doEndgameJeopardy includes the code that will kill the PC
    // if he is dumb enough to walk into a room with hostile aliens,
    // and at one point I wanted this to happen even during debugging).
    if (glob.isInEndgame) {
      doEndgameJeopardy();
    }
    //if (glob.endgameJeopardy) {
    //  doEndgameJeopardy;
    //}
    
    // 2D. Outdated crap.
    // 
    // The following commented-out junk is a legacy from when the 
    // endgame map worked differently, in that it only showed 
    // the last known location of the NPCs, not their actual location.
    /*
    //if (me.location == dreamRoom) "In dreamRoom during endgameDaemon.daemon(). <.p>";
    //else "NOT in dreamRoom during endgameDaemon.daemon(). <.p>";
    //if (!me.canSee(officeDoor) && !me.canSee(officeDoor2)) "You can<./s>t see the office door. ";
    //else if (officeDoor.lks == open) "You can see that the office door is open. ";
    //else "You can see that the office door is closed. ";
    if (me.canSee(officeDoor) || me.canSee(officeDoor2)) {
      officeDoor.lks = officeDoor.isOpen;
    }
    if (me.canSee(hallDoors) || me.canSee(hallDoors2)) {
      hallDoors.lks = hallDoors.isOpen;
    }
    if (me.canSee(cellDoor) || me.canSee(cellDoor2)) {
      cellDoor.lks = cellDoor.isOpen;
    }
    if (me.canSee(breakDoor) || me.canSee(breakDoor2)) {
      breakDoor.lks = breakDoor.isOpen;
    }
    if (me.canSee(bathDoor) || me.canSee(bathDoor2)) {
      bathDoor.lks = bathDoor.isOpen;
    }
    if (me.canSee(confDoor) || me.canSee(confDoor2)) {
      confDoor.lks = confDoor.isOpen;
    }
    if (me.canSee(dreamDoor) || me.canSee(dreamDoor2)) {
      dreamDoor.lks = dreamDoor.isOpen;
    }
    // frontDoors.lks would always correspond to frontdoors.isOpen
    // slowingfield.lks would always correspond to slowingfield.isOn
    if (me.canSee(neton)) {
      neton.lkl = neton.location;
      neton.lkx = neton.xValue;
      neton.lky = neton.yValue;
      neton.lkx2 = neton.xOffset;
      neton.lky2 = neton.yOffset;
    }
    if (me.canSee(ovan)) {
      ovan.lkl = ovan.location;
      ovan.lkx = ovan.xValue;
      ovan.lky = ovan.yValue;
      ovan.lkx2 = ovan.xOffset;
      ovan.lky2 = ovan.yOffset;
    }
    if (me.canSee(youngGuard)) {
      youngGuard.lkl = youngGuard.location;
      youngGuard.lkx = youngGuard.xValue;
      youngGuard.lky = youngGuard.yValue;
      youngGuard.lkx2 = youngGuard.xOffset;
      youngGuard.lky2 = youngGuard.yOffset;
    }
    if (me.canSee(oldGuard)) {
      oldGuard.lkl = oldGuard.location;
      oldGuard.lkx = oldGuard.xValue;
      oldGuard.lky = oldGuard.yValue;
      oldGuard.lkx2 = oldGuard.xOffset;
      oldGuard.lky2 = oldGuard.yOffset;
    }
    if (me.canSee(assistant)) {
      assistant.lkl = assistant.location;
      assistant.lkx = assistant.xValue;
      assistant.lky = assistant.yValue;
      assistant.lkx2 = assistant.xOffset;
      assistant.lky2 = assistant.yOffset;
    }
    */
    /*
      for(local cur=firstObj(AlienRoom); cur!=nil; 
          cur=nextObj(cur,AlienRoom)) {
        if(me.canSee(cur) && !me.hasSeen(cur)) {
          me.setHasSeen(cur);
        }
      }
    */
    
    // ---------------------
    // PART 3: Friendly NPC stuff
    //
    // Let Vicki and Diane act on their own initiative,
    // if appropriate.
    if (vicki.rescued && !vicki.leaving) {
      vicki.waitDaemon();
    }
    else if (vicki.leaving && vicki.getOutermostRoom) {
      vicki.marchNorthOnOwnInitiative('Vicki and Diane ', nil);
    }
    // Special case: if the cell door has been opened,
    // Vicki and Diane should greet immediately greet you.
    if (cellDoor.isOpen && cellDoor.holdsPrisoners && vicki.isIn(cell)) {
      if (!gPlayerChar.isIn(cell)) {
        "And with that, Vicki and Diane come running through the door 
          to greet you. ";
        "<p>";
        vicki.moveIntoForTravel(hallway3);
        diane.moveIntoForTravel(hallway3);
      }
      cellDoor.holdsPrisoners = nil;
      vicki.rescued = true;
      diane.rescued = true;
      prisonerBehavior.letPrisonersGreetPc();
    }
    // This should work to make sure that the value
    // cellDoor.holdsPrisoners is always accurate.
    if (cellDoor.isOpen) {
      cellDoor.holdsPrisoners = nil;
      vicki.rescued = true;
      diane.rescued = true;
    }
    prisonerBehavior.letPrisonersGetStrayFood(vicki, nil);
    prisonerBehavior.letPrisonersAttemptFoodTheft();
    
    // ---------------------
    // PART 4: Flying stuff
    // 
    // If the fish dispenser button was just pushed and there
    // are presently any fish (or other flying objects) hanging
    // in the air above the museum, let them fall now and deal
    // with the consequences.
    local mflying;
    mflying = museum.contents.subset({x: x.ofKind(FlyingThing)});
    if (mflying.length > 0) {
      for (local a = 1; a <= mflying.length; a++) {
        if (!mflying[a].imminentlyFalling) {
          mflying[a].imminentlyFalling = true;
        }
        else if ((neton.location &&      neton.location.isInFishCorridor) ||
                  (ovan.location &&       ovan.location.isInFishCorridor) ||
            (youngGuard.location && youngGuard.location.isInFishCorridor) ||
              (oldGuard.location &&   oldGuard.location.isInFishCorridor) ||
             (assistant.location &&  assistant.location.isInFishCorridor)) {
          local northernmost = [vertToken];
          for (local a = 1; a <= 5; a++) {
            local guy;
            switch (a) {
              case 1: guy = ovan;       break;
              case 2: guy = neton;      break;
              case 3: guy = youngGuard; break;
              case 4: guy = oldGuard;   break;
              case 5: guy = assistant;  break;
            }
            if (guy.verticalValue > northernmost[1].verticalValue) {
              northernmost = [guy];
            }
            else if (guy.verticalValue == northernmost[1].verticalValue) {
              northernmost = northernmost + guy;
            }
          }
          local guyToHit;
          guyToHit = rand(northernmost);
          "<.p>";
          mflying[a].hitAlien(guyToHit);
          mflying[a].moveInto(nil);
          noticeDrain;
        }
        else {
          "<.p>";
          mflying[a].fallVanishMsg;
          mflying[a].moveInto(nil);
          noticeDrain;
        }
      }
    }
    
    // ---------------------
    // PART 5: Final miscellany
    // 
    // Some of the weapons and artifacts have daemons that 
    // need to run after most of the other stuff has happened.
    // Run those daemons.
    explosive.daemon();
    disrupter.daemon();
    laser.laserDaemon();
    
    // If this is the end of a turn that marks the game's
    // first use of colored text, then mention that fact.
    if (glob.seenArtColors == 1) {
      //// 2019-05-10: I never implemented this. What's more, I no longer think
      //// I should implement this. Comment it out and move on. 
      //"<.p>[You have reached a point in the game where there 
      //  is colored text. To get rid of the color, type COLOR OFF.
      //  To allow colored text again, type COLOR ON.] ";
      glob.seenArtColors = 2;
    }
    
    // Other miscellaneous stuff:
    //glob.actorReadyLoopCt = 0;
    glob.actorReadyPrecondHasBeenRunThisTurn = nil;
    if (me.isIn(aquaPed))
      glob.iHaveBeenOnAquaPed = true;
    
    // Do maintenance on how the computer should interpret you
    // in the future when you type YES or NO.
    if (drain.yesActive) { drain.yesActive = nil; }
    else { drain.yesState = 0; }
    //if (slowingField.yesActive) {
    //  slowingField.yesActive = nil;
    //  slowingField.prevActionClass = nil;
    //  slowingField.prevDobj = nil;
    //  slowingField.prevIobj = nil;
    //  slowingField.prevActionPhrase = '';
    //}
    if (slowingField.yesState == 2) {
      //"<.p><font color=red>sf.yesState, previously <<slowingField.yesState>>, ";
      slowingField.yesState = 1;
      //"is now <<slowingField.yesState>>.</font> ";
    }
    else if (slowingField.yesState == 1) {
      //"<.p><font color=red>sf.yesState, previously <<slowingField.yesState>>, ";
      slowingField.yesState = 0;
      slowingField.prevActionClass = nil;
      slowingField.prevDobj = nil;
      slowingField.prevIobj = nil;
      slowingField.prevActionPhrase = '';
      //"is now <<slowingField.yesState>>.</font> ";
    }
    //if (slowingField.yesActive) {
    //  slowingField.yesActive = nil;
    //  slowingField.prevActionClass = nil;
    //  slowingField.prevDobj = nil;
    //  slowingField.prevIobj = nil;
    //  slowingField.prevActionPhrase = '';
    //}
    ////else {
    ////  slowingField.yesState = 0;
    ////}
    
    // Every turn, check to see if the PC can see the front doors
    // while they're open. If so, he knows where they lead.
    if (me.canSee(frontDoors) && frontDoors.isOpen)
      frontDoors.obviouslyLeadOutside = true;
    // If Michelle Nizette's challenge manager is active 
    // unnecessarily (because the last of the aliens has just 
    // died), then deactivate it.
    if (!neton.realLocation &&
        !ovan.realLocation &&
        !oldGuard.realLocation &&
        !youngGuard.realLocation &&
        !assistant.realLocation)
    {
      if (challengeManager.challengeRunning) {
        challengeManager.setChallenge(nil);
      }
      if (!weaponAchievement.visible && glob.endgameJeopardy) {
        weaponAchievement.setVisible();
      }
      if (!slowingField.hasEverBeenOn) {
        weaponAchievement.achieve();
      }
    }
    // The slowingButton.warningValue thing is obsolete.
    //if (slowingButton.warningValue) slowingButton.warningValue--;
    
    
#ifdef __DEBUG
//    switch (ableSal.salGoal) {
//      case goOutside: "<.p>ableSal.salGoal == goOutside "; break;
//      case findPrisoners: "<.p>ableSal.salGoal == findPrisoners "; break;
//      case unlockCell: "<.p>ableSal.salGoal == unlockCell "; break;
//      default: "<.p>ableSal.salGoal == AN UNRECOGNIZED VALUE! "; break;
//    }
//    "<.p>ableSal.nearDoor == ";
//    if (!ableSal.nearDoor) {
//      "nil ";
//    } else {
//      "<<ableSal.nearDoor == nil ? 'nil' : ableSal.nearDoor.theName>>
//          (<<ableSal.nearDoor.isOpen ? 'open' : 'closed'>>) ";
//    }
#endif // __DEBUG
    
    
    // The very last thing: update the banner (to reflect,
    // e.g., any NPCs who have recently moved).
    nbmBanner.updateMe();
  }    
  noticeDrain {
    if (drain.getOutermostRoom != hallway6) {
      if (noDrain.ofKind(ShadowCaster))
        noDrain.scMoveInto(nil);
      else
        noDrain.moveInto(nil);
      
      if (drain.ofKind(ShadowCaster))
        drain.scMoveInto(hallway6);
      else
        drain.moveInto(hallway6);
      
      if (nadir.ofKind(ShadowCaster))
        nadir.scMoveInto(hallway6);
      else
        nadir.moveInto(hallway6);
    }
  }
;

// -------------------------------------------------------------------
// NPCS: ALIENS: NPC ACTION REPORTS: endgameJeopardy
// -------------------------------------------------------------------

// Here is where the NPCs really do their worst. Depending on 
// circumstances, they will argue with each other, run after you,
// and/or try to kill you.

// The doEndgameJeopardy method is so long that it deserves 
// its own table of contents. Here it is:
// 
// Step 1: Preliminaries
// Step 2: Killing prior to moving
// Step 3: Letting the NPCs execute their agenda
//   3A: Agenda Type A: Arguing
//   3B: Agenda Type B: Waiting
//   3C: Agenda Type C: Going to Hallway 6
//   3D: Agenda Type D: Going to the Museum
//     3D Part 1: Preliminaries
//     3D Part 2: Move the NPCs silently
//     3D Part 3: Reporting the movements of the NPCs
//     3D Part 4: Post-movement attacking
//       3D Part 4A: Post-movement range attacks
//       3D Part 4B: Post-movement melee attacks

modify Alien
  isSituatedForRangeAttack {
    if (me.getOutermostRoom.isInFishCorridor &&
        self.realLocation &&
        self.realLocation.getOutermostRoom.isInFishCorridor &&
        !self.isStunned)
      return true;
    else
      return nil;
  }
  hasFiredThisTurn = nil
;

modify endgameDaemon
  giveRangeWielderData {
    local npcList = [ovan, neton, youngGuard, oldGuard, assistant];
    local rangeWielders = [];
    local rwsInHitRange = [];
    local rwsInMissRange = [];
    local northernmostRws = [];
    local effectualRwsInHitRange = [];
    local newlyEquippedRws = [];
    local rwsNotHavingFiredThisTurn = [];
    local newWeapon = nil;
    local effectualWeaponInHitRange = nil;
    local withinHitRange = nil;
    local withinMissRange = nil;
    local hasNonDaggerWeapon = nil;
    for (local a = 1; a <= npcList.length; a++) {
      if (npcList[a].rangeWeapons.length
          && npcList[a].realLocation
          && !npcList[a].isStunned) {
        rangeWielders += npcList[a];
      }
    }
    for (local a = 1; a <= rangeWielders.length; a++) {
      newWeapon = nil;
      effectualWeaponInHitRange = nil;
      withinHitRange = nil;
      withinMissRange = nil;
      if (rangeWielders[a].isSituatedForRangeAttack) {
        for (local b = 1; b <= rangeWielders[a].rangeWeapons.length; b++) {
          // Throw a flag if the NPC has a new gun
          if (rangeWielders[a].rangeWeapons[b].isNewToNpc)
            newWeapon = true;
          // Throw a flag if at least one of the NPC's weapons can 
          // function properly (i.e. can sometimes kill and is not out of ammo).
          // Note that if the weapon is not a gun (i.e. is the dagger),
          // then the conditions are a bit more strict.
          if (rangeWielders[a].rangeWeapons[b].canKillNow && 
              rangeWielders[a].absoluteYValue - me.absYValForShooting 
              <= rangeWielders[a].rangeWeapons[b].maxHitDistance)
            effectualWeaponInHitRange = true;
          // Throw a flag if at least one of the NPC's weapons' range
          // is such that you (the PC) are definitely within its killing range.
          if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
               <= rangeWielders[a].rangeWeapons[b].maxHitDistance)
            withinHitRange = true;
          // Throw a flag if at least one of the NPC's weapons' range
          // is such that the NPC will *always* want to attack you, 
          // and will either miss you very narrowly or else actually hit you.
          if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
               <= rangeWielders[a].rangeWeapons[b].maxAlwaysShootDistance)
            withinMissRange = true;
          // Throw a flag if the NPC has a non-dagger range weapon
          if (rangeWielders[a].rangeWeapons[b].maxAlwaysShootDistance 
              > rangeWielders[a].rangeWeapons[b].maxHitDistance)
            hasNonDaggerWeapon = true;
        }
        
        if (newWeapon)
          newlyEquippedRws += rangeWielders[a];
        if (effectualWeaponInHitRange)
          effectualRwsInHitRange += rangeWielders[a];
        if (withinHitRange)
          rwsInHitRange += rangeWielders[a];
        else if (withinMissRange)
          rwsInMissRange += rangeWielders[a];
        // northernmostRws will never include anyone whose only 
        // range weapon is the dagger.
        if (hasNonDaggerWeapon) {
          // If northernmostRws is empty, replace it 
          // with the current actor.
          if (!northernmostRws.length)
            northernmostRws = [rangeWielders[a]];
          // If northernmostRws are not as far north as 
          // the current actor, replace it with the current actor.
          else if (northernmostRws[1].absoluteYValue
                   > rangeWielders[a].absoluteYValue)
            northernmostRws = [rangeWielders[a]];
          // If northernmostRws are *exactly as* far 
          // north as the current actor, *add* the current actor.
          else if (northernmostRws[1].absoluteYValue 
                  == rangeWielders[a].absoluteYValue)
            northernmostRws += [rangeWielders[a]];
        }
        if (!rangeWielders[a].hasFiredThisTurn) {
          rwsNotHavingFiredThisTurn += rangeWielders[a];
        }
      }
    }
    return [
       rangeWielders
      ,rwsInHitRange
      ,rwsInMissRange
      ,northernmostRws
      ,effectualRwsInHitRange
      ,newlyEquippedRws
      ,rwsNotHavingFiredThisTurn
    ];
  }
  attackerListByPriority =
    [youngGuard, oldGuard, assistant, ovan, neton]
  getAttackerFromList(lst) {
    local success = nil;
    for (local a = 1; a <= attackerListByPriority.length; a++) {
      for (local b = 1; b <= lst.length; b++) {
        if (attackerListByPriority[a] == lst[b]) {
          success = attackerListByPriority[a];
          break;
        }
      }
      if (success) break;
    }
    attackerListByPriority = 
      attackerListByPriority.removeElementAt(attackerListByPriority.indexOf(success))
      + success;
    return success;
  }
  executeRangeAttack(attacker, bothGuards) {
    //pleaseSay('<p>executeRangeAttack()');
    // Preliminaries
    local attackerDistance;
    local minDistance = 9999;
    local dummyList = [];
    local attackerSatisfied = nil;
    local loopCount = 0;
    local prefixStr = '';
    //local paragraphStr = '<.p>';
    // if this is a "both guards" attack, our means of dealing 
    // with it will be somewhat different. For the sake of argument,
    // let attacker equal the youngGuard.
    if (bothGuards) {
      attacker = youngGuard;
    }
    // If, in any other case, "attacker" is not one NPC but a list 
    // of NPCs, figure out which of the NPCs is most suitable.
    else if (dataType(attacker) == TypeList) {
      // Find the minimum distance between the 
      for (local a = 1; a <= attacker.length; a++) {
        if (attacker[a].absYValForShooting - me.absYValForShooting
            < minDistance)
          minDistance = 
            attacker[a].absYValForShooting - me.absYValForShooting;
      }
      for (local a = 1; a <= attacker.length; a++) {
        if (minDistance == 
            attacker[a].absYValForShooting - me.absYValForShooting)
          dummyList += attacker[a];
      }
      // Fix this later: better to have eligible attacker candidates
      // take turns than to choose among them randomly. Good enough
      // for now, though.
      attacker = getAttackerFromList(dummyList);
    }
    attackerDistance = 
      attacker.absYValForShooting - me.absYValForShooting;
    // Do a loop, since the NPC might need to fire more than one
    // weapon.
    while (attacker.rangeWeapons.length && !attackerSatisfied) {
      loopCount++;
      //paragraphStr = '<.p>';
      if (loopCount <= 1 && attacker.rangeWeapons[1].isNewToNpc) {
        // Do a paragraph break before this attack in all cirumstances 
        // except when the NPC initially attacks with a new weapon.
        //paragraphStr = '';
        prefixStr = 'with that, ';
      }
      else if (loopCount >= 2) {
        prefixStr = 'undeterred, ';
      }
      else {
        prefixStr = '';
      }
      
      // If the range weapon is not a gun, and the NPC is too far 
      // away to be sure of dealing a fatal blow to the PC, then 
      // refrain from doing an attack.
      if (!attacker.rangeWeapons[1].ofKind(Gun) && 
          attackerDistance > attacker.rangeWeapons[1].maxHitDistance) {
        if (glob.doKludgeStrings)
          "<.p><font color=red>executeRangeAttack: inappropriate dagger attack</font> ";
        "<.p>";
        attacker.rangeWeapons[1].refrainFromAttacking;
        // If we've reached the point where we're trying 
        // inappropriate dagger attacks, then for heaven's sake 
        // stop attacking.
        attackerSatisfied = true;
      }
      // In the case of the handgun (or, theoretically, any other
      // extraordinarily shoddy gun), the gun will be recognized as such 
      // as soon as it's first used, regardless of whether it hits or
      // misses. Report this circumstance, ditch the weapon, and 
      // prepare to try again.
      else if (attacker.rangeWeapons[1].missingRevealsShoddiness) {
        if (glob.doKludgeStrings)
          "<.p><font color=red>executeRangeAttack: extraordinarily shoddy gun</font> ";
        "<.p>";
        attacker.rangeWeapons[1].suddenRangeAttackParagraph(prefixStr, nil);
        attacker.rangeWeapons[1].reportNpcMiss(wideMiss, nil);
        attacker.tossGunDisgustedly(attacker.rangeWeapons[1]);
        attacker.hasFiredThisTurn = true;
        // Remember attack location for use in knowing where
        // to shoot next.
        prevAbsYValOfShooting = attacker.absYValForShooting;
        // Prepare to shoot again
        attackerSatisfied = nil;
      }
      // If the range weapon is out of ammo, say so, ditch the weapon,
      // and prepare to try again.
      else if (attacker.rangeWeapons[1].ammo <= 0) {
        if (glob.doKludgeStrings)
          "<.p><font color=red>executeRangeAttack: out of ammo</font> ";
        "<.p>";
        attacker.rangeWeapons[1].suddenRangeAttackParagraph(prefixStr, nil);
        attacker.rangeWeapons[1].reportNoNpcAmmo;
        attacker.tossGunDisgustedly(attacker.rangeWeapons[1]);
        attacker.hasFiredThisTurn = true;
        // Remember attack location for use in knowing where
        // to shoot next.
        prevAbsYValOfShooting = attacker.absYValForShooting;
        // Prepare to shoot again
        attackerSatisfied = nil;
      }
      // If the attacker is too far away to hit the PC with
      // the selected range weapon, let him fire and miss.
      else if (attackerDistance > attacker.rangeWeapons[1].maxHitDistance) {
        if (glob.doKludgeStrings) {
          "<.p><font color=red>executeRangeAttack: fire and miss</font> ";
          "<br><font color=red>attackerDistance == <<attackerDistance>>
            <br>attacker.rangeWeapons[1] == <<attacker.rangeWeapons[1].name>>
            <br>attacker.rangeWeapons[1].maxHitDistance == <<attacker.rangeWeapons[1].maxHitDistance>></font> ";
        }
        "<.p>";
        // Be sure to make use of the bothGuards flag, in case it's needed.
        attacker.rangeWeapons[1].suddenRangeAttackParagraph(prefixStr, bothGuards);
        if (attackerDistance <= 
            attacker.rangeWeapons[1].maxAlwaysShootDistance) {
          attacker.rangeWeapons[1].reportNpcMiss(narrowMiss, bothGuards);
          "\^<<endgameDaemon.sayNpcsCurse(bothGuards ? [oldGuard, youngGuard] : [attacker])>>, 
            while you take a deep breath. That was far too close. ";
        }
        else if (attackerDistance <= 
            attacker.rangeWeapons[1].maxAlwaysShootDistance + 100) {
          attacker.rangeWeapons[1].reportNpcMiss(mediumMiss, bothGuards);
          "\^<<endgameDaemon.sayNpcsCurse(bothGuards ? [oldGuard, youngGuard] : [attacker])>>, 
            while you take a deep breath. That was close. ";
        }
        else {
          attacker.rangeWeapons[1].reportNpcMiss(wideMiss, bothGuards);
          "\^<<endgameDaemon.sayNpcsCurse(bothGuards ? [oldGuard, youngGuard] : [attacker])>>. ";
        }
        // Carry out internal consequences of shooting -- 
        // e.g., decrease the gun's ammo, if applicable.
        // Out of laziness, I am *not* modifying this to make it
        // work perfectly when bothGuards == true. After all,
        // shootConsequences is entirely moot in that scenario.
        attacker.rangeWeapons[1].shootConsequences;
        attacker.hasFiredThisTurn = true; // presumably redundant
        // Remember attack location for use in knowing where
        // to shoot next.
        prevAbsYValOfShooting = attacker.absYValForShooting;
        // After this, the attacker has no need to attack 
        // again this turn.
        attackerSatisfied = true;
      }
      // If the attacker hits but the hit is harmless, say so,
      // ditch the weapon, and prepare to fire again.
      // 
      // Note that because this if-else structure has excluded all 
      // of the above possibilities, we can be sure we're in 
      // hit range at this point. In other words:
      // attackerDistance <= attacker.rangeWeapons[1].maxHitDistance
      else if (!attacker.rangeWeapons[1].canKillSometimes) {
        if (glob.doKludgeStrings)
          "<.p><font color=red>executeRangeAttack: fire and hit harmlessly</font> ";
        "<.p>";
        attacker.rangeWeapons[1].suddenRangeAttackParagraph(prefixStr, nil);
        attacker.rangeWeapons[1].deathParagraph(true, nil);
        attacker.tossGunDisgustedly(attacker.rangeWeapons[1]);
        // Carry out internal consequences of shooting -- 
        // e.g., decrease the gun's ammo, if applicable.
        attacker.rangeWeapons[1].shootConsequences;
        attacker.hasFiredThisTurn = true; // presumably redundant
        // Remember attack location for use in knowing where
        // to shoot next.
        prevAbsYValOfShooting = attacker.absYValForShooting;
        // Prepare to shoot again
        attackerSatisfied = nil;
      }
      // Having excluded all of the above scenarios, there is 
      // only one remaining possibility: the attacker hits you 
      // and kills you.
      else {
        if (glob.doKludgeStrings) {
          "<.p><font color=red>executeRangeAttack: fire, hit, and kill</font> ";
          "<br><font color=red>attackerDistance == <<attackerDistance>>
            <br>attacker.rangeWeapons[1] == <<attacker.rangeWeapons[1].name>>
            <br>attacker.rangeWeapons[1].maxHitDistance == <<attacker.rangeWeapons[1].maxHitDistance>></font> ";
        }
        "<.p>";
        if (prefixStr == '')
          prefixStr = 'suddenly ';
        // Be sure to make use of the bothGuards flag, in case it's needed
        attacker.rangeWeapons[1].suddenRangeAttackParagraph(prefixStr, bothGuards);
        attacker.rangeWeapons[1].deathParagraph(true, bothGuards);
        attacker.killPcAmusingly;
        // It seems pointless to deal with shootConsequences here,
        // since it's game over anyway. But whatever.
        // Also note: out of laziness, I am *not* modifying this to make it
        // work perfectly when bothGuards == true. After all,
        // shootConsequences is entirely moot in that scenario.
        attacker.rangeWeapons[1].shootConsequences;
        attacker.hasFiredThisTurn = true; // presumably redundant
        endGame(attacker.rangeWeapons[1].asscFinishType);
        // Remember attack location, though it seems pointless.
        prevAbsYValOfShooting = attacker.absYValForShooting;
        // Needless to say, your death satisfies the attacker.
        attackerSatisfied = true;
      }
    } // end of while loop
  }
//  // [...]
//    /*
//    Possible scenarios:
//    hit and kill (satisfied)
//    hit and no-harm-done (unsatisfied; throw away weapon)
//    wide/medium/narrow miss (satisfied)
//    no ammo (unsatisfied; throw away weapon)
//    obviously bad gun, like handgun (unsatisfied; throw away weapon)
//    dagger is too far away; don't throw it
//    */
//    
//    
//    // Always begin with a paragraph break.
//    
//    
//    
//    
//    // Assistant handling. We assume that the assistant will never
//    // be in a list with anybody else.
//    if (attacker == assistant) {
//      // Let the assistant do a deadly range attack, if applicable.
//      if (attackerDistance <= attacker.weapon.maxHitDistance) {
//        attacker.weapon.suddenRangeAttackParagraph('suddenly ', nil);
//        attacker.weapon.deathParagraph(true, nil);
//        attacker.killPcAmusingly;
//        endGame(ftDeath);
//      }
//      // No non-deadly range attack has been designed for the assistant.
//      else { }
//    }
//    // The attacker(s) are one or more guards.
//    else {
//      // No matter there's one or two guards, no matter whether they 
//      // hit or miss, their attack starts with them raising their
//      // hand cannons and shooting at you.
//      "\^<<attacker.theName>> 
//        raises his hand cannon and fires at you. ";
//      // If hitting and killing...
//      if (attackerDistance <= attacker.weapon.maxHitDistance) {
//        // Just one guard hitting and killing...
//        attacker.weapon.deathParagraph(true, nil);
//        attacker.killPcAmusingly;
//        endGame(ftDeath);
//      }
//      // If missing...
//      else {
//        "A bolt of plasma flies by you, ";
//        if (attackerDistance <= attacker.weapon.maxAlwaysShootDistance) {
//          "missing you by only <<rand('a hair','a fraction of an inch')>>. ";
//          "\^<<sayNpcsCurse(attacker)>>, while you take a deep breath.
//            That was far too close. ";
//        }
//        else if (attackerDistance - 100 <= attacker.weapon.maxAlwaysShootDistance) {
//          "missing you by only a couple of feet. ";
//          "\^<<sayNpcsCurse(attacker)>>, while you take a deep breath.
//            That was close. ";
//        }
//        //else if (attackerDistance - 200 <= attacker.weapon.maxAlwaysShootDistance) {
//        //  "missing you by a few feet. ";
//        //  "\^<<sayNpcsCurse(attacker)>>. ";
//        //}
//        else {
//          "missing you by a wide margin. ";
//          "\^<<sayNpcsCurse(attacker)>>. ";
//        }
//      }
//    }
//    prevAbsYValOfShooting = attacker.absYValForShooting;
//  }
  doEndgameJeopardy {
    // *****************************
    // *** STEP 1: PRELIMINARIES ***
    // *****************************
    // 
    // Note that the waking of of stunned NPCs must happen prior to this
    // point, in endgameDaemon.daemon.
    // 
    // A couple of local variables are assigned values here, so we can know
    // whether the PC has made the fatal mistake of walking into a room
    // full of NPCs who are (a) hostile, and (b) able to kill him.
    
    // The assistant MUST be at the end of npcList.
    local npcList =
      [ovan, neton, youngGuard, oldGuard, assistant];
    // Note to self: I never did anything with livingNpcs but 
    // initialize it. Presumably we can delete this if commenting it out
    // has caused no problems.
    // local livingNpcs = []; 
    local movingNpcs = [];
    // RANGEFLAG
    
    
    //local rangeWielders = [youngGuard, oldGuard, assistant];
    //local rangeAttackersWhoHit = [];
    //local rangeAttackersWhoMiss = [];
    //local northernmostGuards = [];
    
    
    //local rangeWielders = [];
    local rwsInHitRange = [];
    local rwsInMissRange = [];
    local northernmostRws = [];
    local effectualRwsInHitRange = [];
    local newlyEquippedRws = [];
    local rwsNotHavingFiredThisTurn = [];
    
    local ordinaryCloseNpcs = [];
    local slowedCloseNpcs = [];
    local stunnedCloseNpcs = [];
    local reportMoveList = nil;
    local adHoc = nil;
    local adHoc2 = nil;
    local adHoc3 = nil;
    local aliensInLastParagraph = 0;
    local profsWhoAttack = [];
    local predictedAbsYVal = 9999;
    //local veryCloseNpcsHere = [];
    
    // <NEW WORLD ORDER>
    // Hello. I would like to announce the NEW WORLD ORDER for the 
    // Nothing but Mazes endgame. The new world order is very simple:
    //    -- If glob.endgameJeopardy == nil, then we do not execute
    //         doEndgameJeopardy.
    //    -- No other rules, that is all.
    // This is in contradiction with what I had in mind before, and it 
    // may contradict some old comments still lingering in this code.
    // Never mind those. The new world order is, no doEndgameJeopardy
    // without glob.endgameJeopardy == true. I hope this makes for 
    // kinder, gentler debugging conditions. Thank you.
    if (!glob.endgameJeopardy) {
      return;
    } 
    // </NEW WORLD ORDER>
    
    // -------
    // Initialize values of livingNpcs, moving Npcs,
    // stunnedCloseNpcs, slowedCloseNpcs, and ordinaryCloseNpcs.
    
    // Note: the following loop only works provided that any 
    // stunned NPCs supposed to wake up this turn have already done so,
    // in endgameDaemon.daemon(). This should be taken care of now.
    
    for (local a = 1; a <= npcList.length; a++) {
      if (npcList[a].realLocation) {
        // Note to self: livingNpcs is presumably a useless variable
        // we should delete. See above.
        //livingNpcs = livingNpcs + npcList[a];
        if (!npcList[a].isStunned)
          movingNpcs = movingNpcs + npcList[a];
      }
      if (npcList[a].realLocation && 
          npcList[a].realLocation.getOutermostRoom == me.getOutermostRoom && 
          npcList[a].isVeryCloseToPc)
      {
        if (npcList[a].isStunned)
          { }
        else if (npcList[a].isSlowed)
          slowedCloseNpcs = slowedCloseNpcs + npcList[a];
        else
          ordinaryCloseNpcs = ordinaryCloseNpcs + npcList[a];
        //veryCloseNpcsHere = veryCloseNpcsHere.append(npcList[a]);
      }
      if (npcList[a].realLocation && 
          npcList[a].realLocation.getOutermostRoom == me.getOutermostRoom && 
          (npcList[a].isVeryCloseToPc || 
          (npcList[a].getOutermostRoom == hallway6 && me.getOutermostRoom == hallway6)))
      {
        // If the NPC is stunned now, we assume he will stay stunned
        // for the rest of the turn. That is, if he was going to wake up 
        // this turn, then he would have done so already.
        if (npcList[a].isStunned)
          stunnedCloseNpcs = stunnedCloseNpcs + npcList[a];
      }
    }
    // -------
    // None of the NPCs will have attacked yet this turn. Make sure
    // we understand this.
    for (local a = 1; a <= npcList.length; a++) {
      npcList[a].hasFiredThisTurn = nil;
    }
    // -------
    // Initialize the various lists associated with range wielders.
    adHoc = giveRangeWielderData;
    //rangeWielders = adHoc[1];
    rwsInHitRange = adHoc[2];
    rwsInMissRange = adHoc[3];
    northernmostRws = adHoc[4];
    effectualRwsInHitRange = adHoc[5];
    newlyEquippedRws = adHoc[6];
    rwsNotHavingFiredThisTurn = adHoc[7];
    
    
    local kludgeStringList = [
       'rangeWielders'
      ,'rwsInHitRange'
      ,'rwsInMissRange'
      ,'northernmostRws'
      ,'effectualRwsInHitRange'
      ,'newlyEquippedRws'
      ,'rwsNotHavingFiredThisTurn'
    ];
    if (glob.doKludgeStrings) {
      "<font color=red>";
      for (local a = 1; a <= adHoc.length; a++) {
        if (a == 1) "<.p>"; else "<br>";
        "<<kludgeStringList[a]>> = [";
        simpleLister(adHoc[a], &theName);
        "]";
      }
      "</font><.p>";
    }
    
    // Previous incarnation of this.
    /*
    for (local a = 1; a <= npcList.length; a++) {
      if (npcList[a].rangeWeapons.length) {
        rangeWielders += npcList[a];
      }
    }
    for (local a = 1; a <= rangeWielders.length; a++) {
      adHoc = 0; // adHoc == (rangeWielders[a] has a new weapon)
      if (rangeWielders[a].isSituatedForRangeAttack) {
        for (local b = 1; b <= rangeWielders[a].rangeWeapons.length; b++) {
          if (rangeWielders[a].rangeWeapons[b].isNewToNpc)
            adHoc = 1;
        }
      }
    }
    
    for (local a = 1; a <= rangeWielders.length; a++) {
      // If both the alien and the PC are in the "fish corridor"
      // (where any range attacks would take place), check to see if 
      // any range attacks should happen, whether successfully or not.
      if (me.getOutermostRoom.isInFishCorridor &&
          rangeWielders[a].realLocation &&
          rangeWielders[a].realLocation.getOutermostRoom.isInFishCorridor &&
          !rangeWielders[a].isStunned)
      {
        adHoc = 0;  // adHoc==1 means a weapon is within "definite hit" range
        adHoc2 = 0; // adHoc2==1 means a weapon is within "definite miss" range
        for (local b = 1; b <= rangeWielders[a].rangeWeapons.length; b++) {
          // If the alien is close enough to hit and kill the PC by 
          // range attack, let them do so.
          if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
               <= rangeWielders[a].rangeWeapons[b].maxHitDistance)
          {
            adHoc = 1;
          }
          // If the alien is close enough to *want* to *try* to hit the PC,
          // but not close enough to actually hit, let him aim and miss.
          if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
               <= rangeWielders[a].rangeWeapons[b].maxAlwaysShootDistance)
          {
            adHoc2 = 1;
          }
        }
        if (adHoc)
          rwsInHitRange += rangeWielders[a];
        else if (adHoc2)
          rwsInMissRange += rangeWielders[a];
      }
    }
    */
    // Even more previous incarnation of this, back when rangeWielders always equalled
    // [youngGuard, oldGuard, assistant]:
    /*
    for (local a = 1; a <= rangeWielders.length; a++) {
      // If both the alien and the PC are in the "fish corridor"
      // (where any range attacks would take place), check to see if 
      // any range attacks should happen, whether successfully or not.
      if (me.getOutermostRoom.isInFishCorridor &&
          rangeWielders[a].realLocation &&
          rangeWielders[a].realLocation.getOutermostRoom.isInFishCorridor &&
          !rangeWielders[a].isStunned)
      {
        // If the alien is close enough to hit and kill the PC by 
        // range attack, let them do so.
        if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
             <= rangeWielders[a].weapon.maxHitDistance)
        {
          rangeAttackersWhoHit = rangeAttackersWhoHit + rangeWielders[a];
        }
        // If the alien is close enough to *want* to *try* to hit the PC,
        // but not close enough to actually hit, let him aim and miss.
        else if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
                  <= rangeWielders[a].weapon.maxAlwaysShootDistance)
        {
          rangeAttackersWhoMiss = rangeAttackersWhoMiss + rangeWielders[a];
        }
      }
    }
    */
    // ***************************************
    // *** STEP 2: KILLING PRIOR TO MOVING ***
    // ***************************************
    // 
    // As a first priority before anything else, if the NPCs can
    // kill the PC without even having to move, let them do it.
    // E.g., if the PC has just walked into a room where there are 
    // hostile aliens who can currently kill him, let them kill him.
    // (Note that this section of code will NOT deal with some similar cases,
    // e.g., if you're on the north side of a room, and there's a slowed
    // alien on the south side of that room, and there are no other aliens
    // alive, and then you type SOUTH. In that case you die *before*
    // you leave the room, whereas here we deal only with cases where
    // you die *immediately after* arriving in a new room.)
    //
    // Pre-Movement Attack Scenario 1:
    // *Unslowed, unstunned* NPCs are very close, ergo you die.
    if (ordinaryCloseNpcs.length) {
      "<.p>";
      "Suddenly ";
      killPcByOrdinaryCloseNpcs(ordinaryCloseNpcs);
    }
    // Pre-Movement Attack Scenario 2:
    // *Slowed* NPCs are very close, ergo you die.
    else if (slowedCloseNpcs.length) {
      "<.p>";
      "Unfortunately for you, although ";
      simpleLister(slowedCloseNpcs, &theName);
      " <<slowedCloseNpcs.length == 1 ? 'is' : 'are'>> 
        slowed, ";
      killPcBySlowedCloseNpcs(slowedCloseNpcs);
    }
    // Pre-Movement Attack Scenario 3:
    // *Stunned* NPCs are very close, ergo you die.
    else if (stunnedCloseNpcs.length) {
      "<.p>";
      "You might not expect there to be any problem in 
        standing near ";
      simpleLister(stunnedCloseNpcs, &theName);
      ", since 
        <<stunnedCloseNpcs.length == 1 ? 'he is' : 'they<./s>re'>> 
        stunned. ";
      killPcByStunnedCloseNpcs(stunnedCloseNpcs);
    }
    // Pre-Movement Attack Scenario 4:
    // At this point we've dealt with all possible cases where the 
    // PC can be killed by *very close* aliens. But aliens bearing 
    // range weapons don't need to be very close. If aliens bearing 
    // range weapons are close enough to be able to kill you,
    // let them kill you now, before anybody budges an inch.
    else if (effectualRwsInHitRange.length) {
      if (glob.doKludgeStrings)
        "<p><font color=red>doEndJeo before movement: fire, hit, kill</font> ";
      executeRangeAttack(effectualRwsInHitRange, nil);
    }
    // Pre-Movement Attack Scenario 5:
    // We know now there will be no *deadly* pre-movement attacks 
    // this turn. Will there be any *non-deadly* pre-movement 
    // attacks? Only if there are any NPCs who suddenly find 
    // themselves equipped with a new gun. (That is, you threw 
    // them a gun and they caught it.) When this happens, they 
    // will normally want to try shooting you ASAP, even before 
    // moving. There is an exception, though: if the 
    // newly-equipped NPC is out of range now **but will be 
    // in range later this turn, after he moves**, then he'll 
    // hold off on attacking until after he moves.
    else if (newlyEquippedRws.length) {
      for (local a = 1; a <= newlyEquippedRws.length; a++) {
        if (!slowingField.isOn) {
          predictedAbsYVal = newlyEquippedRws[a].absoluteYValue - 100;
        }
        else if (newlyEquippedRws[a].yOffset == 1 ||
            assistant.absoluteYValue == 500) {
          predictedAbsYVal = newlyEquippedRws[a].absoluteYValue - 25;
        }
        else {
          predictedAbsYVal = newlyEquippedRws[a].absoluteYValue;
        }
        if (predictedAbsYVal - me.absYValForShooting 
            > newlyEquippedRws[a].rangeWeapons[1].maxHitDistance) {
          if (glob.doKludgeStrings)
            "<p><font color=red>doEndJeo before movement: fire with new gun</font> ";
          executeRangeAttack(newlyEquippedRws[a], nil);
        }
      }
    }
    /*
    if (rangeAttackersWhoHit.length) {
      rangeAttackersWhoHit[1].weapon.suddenRangeAttackParagraph('suddenly ', nil);
      rangeAttackersWhoHit[1].weapon.deathParagraph(true, nil);
      rangeAttackersWhoHit[1].killPcAmusingly;
      endGame(ftDeath);
      return;
    }
    */
    
    
/*
NEW PSEUDOCODE, NOV. 2008:

AFTER "VERY CLOSE" ATTACKS BUT BEFORE MOVEMENT:

if (at least one NPC has at least one range weapon that is
     (1) within "definite hit" range, and (2) can kill now):
  do one executeRangeAttack for the best choice of those NPCs. [KILL!]

if (at least one NPC has at least one range weapon that 
     they haven't fired before):
  do one or more executeRangeAttacks until all not-previously-fired 
   NPC-held range weapons have been fired. Remember which NPCs fired this turn.
  
AFTER MOVEMENT:

if (at least one NPC has at least one range weapon that is 
     (1) within "definite hit range," and (2) can kill now):
  do one executeRangeAttack for the best choice of those NPCs. [KILL!]

elseif (at least one NPC has at least one range weapon that is 
     (1) within "definite hit" range, and yet
     (2) cannot kill now, and yet also 
     (3) its wielder has not fired this turn):
  do one executeRangeAttack for the best choice of those NPCs.
   Remember that that NPC fired this turn, and remember the Ylocation.

elseif (both guards just arrived in hallway 6):
  do one bothGuardsRangeAttack.
   Remember that that NPC fired this turn, and remember the Ylocation.

elseif (at least one NPC has at least one range weapon that is
     (1) within "definitely shoot but miss" range, and
     (2) its wielder has not fired this turn):
  do one executeRangeAttack for the best choice of those NPCs. 
   Remember that that NPC fired this turn, and remember the Ylocation.

elseif ((1) the slowing field is off, and (2) there are any 
     remaining range-wielders who have not fired yet this turn):
  do one executeRangeAttack for the best choice of those NPCs, where 
   "best choice" includes "being among the northernmost range-wielders"
   as a top priority.
   Remember that that NPC fired this turn, and remember the Ylocation.

elseif ((1) the slowing field is off, and 
     (2) none of the above scenarios are true, and 
     (3) the difference between the northernmost range-wielders' Ylocation
     and the previous shooting's Ylocation is equal to the designated 
     "slowed sometimes-shoot interval"):
  do one executeRangeAttack for the best choice of those NPCs.
   Remember that that NPC fired this turn, and remember the Ylocation.
*/
    
    
    
    
    //local totedGun = pulseGun;
    //local toter = npcList.indexWhich({x: totedGun.isIn(x)});
    //if (toter) {
    //  toter = npcList[toter];
    //  totedGun.suddenRangeAttackParagraph('suddenly ', nil);
    //  totedGun.deathParagraph(true, nil);
    //  toter.killPcAmusingly;
    //  endGame(ftDeath);
    //  return;
    //}
    
    
    
    
    
    
    
    
    
    // *****************************************************
    // *** STEP 3: LETTING THE NPCS EXECUTE THEIR AGENDA ***
    // *****************************************************
    // 
    // And now that we've gotten to this point, we know for sure
    // none of the NPCs can kill the PC *BEFORE* moving.
    // Therefore, it is now time to move the NPCs, or otherwise
    // let the NPCs do their thing.
    // 
    // All the stuff below depends on glob.enemyState: i.e.,
    // it depends on whether the aliens are arguing, going to hallway6, 
    // going to the museum, etc.
    //
    // If glob.endgameJeopardy == nil, then we should already
    // have exited this method. But just in case I modify this
    // later, let's be *especially* concerned to do nothing 
    // past this point if glob.endgameJeopardy == nil.
    if (!glob.endgameJeopardy) {
      return;
    } 
    // -------------------------------
    // STEP 3A: Agenda Type A: Arguing
    // -------------------------------
    // 
    // If enemies are supposed to be arguing, let them continue arguing.
    if (glob.enemyState == arguing) {
      //if (endgameProfSequence.epsValue != 1) {
      //  endgameProfSequence.execute;
      //}
      endgameProfSequence.execute;
      return;
    }
    // -------------------------------
    // STEP 3B: Agenda Type B: Waiting
    // -------------------------------
    // 
    // If the enemies are supposed to be waiting in Hallway 8,
    // let them wait, but make sure they wait only one turn.
    if (glob.enemyState == waiting) {
      if (neton.realLocation == hallway8)
        glob.enemyState = goingToHallway6;
      return;
    }
    // ------------------------------------------
    // STEP 3C: Agenda Type C: Going to Hallway 6
    // ------------------------------------------
    // 
    // If Neton and Ovan are in the process of going to Hallway 6,
    // then deal with NPCs accordingly.
    // Note that we may safely assume here that the PC is not in the 
    // same room as any of the NPCs, as that case has been dealt with 
    // above.
    if (glob.enemyState == goingToHallway6) {
      switch (neton.realLocation.getOutermostRoom) {
        case hallway8:
          neton.scMoveInto(hallway7);
          ovan.scMoveInto(hallway7);
          if (me.canSee(neton))
            sayProfsRunTowardYou('north');
          break;
        case hallway7:
          if (me.isIn(hallway4)) {
            neton.scMoveInto(hallway4);
            ovan.scMoveInto(hallway4);
            "\^"; sayProfsRunIntoRoom('north');
            sayOvanKillsPc;
          }
          else {
            neton.scMoveInto(hallway4);
            ovan.scMoveInto(hallway4);
            if (me.canSee(neton))
              sayNpcsComeIntoView('west', 'north', [neton, ovan], nil, nil);
            if (glob.yellingAtGuardTakesTime) {
              neton.facingYou = nil;
            }
            else {
              if (me.canSee(neton))
                "<p>Neton shouts to the room to his south, saying 
                  something about <.q>eliminate him!<./q> With that, 
                  he and Ovan turn to face you. ";
            }
          }
          break;
        case hallway4:
          if (me.isIn(hallway5)) {
            neton.scMoveInto(hallway5);
            ovan.scMoveInto(hallway5);
            "\^"; sayProfsRunIntoRoom('west');
            sayOvanKillsPc;
          }
          else if (!neton.facingYou) {
            neton.facingYou = true;
            if (me.canSee(neton))
              "\^<<sayRelativeHallwayLoc('west')>>, Neton shouts to the room 
                  to his south, saying something about <.q>eliminate him!<./q> 
                  With that, he and Ovan turn to face you. ";
          }
          else { // neton.facingYou is true
            neton.scMoveInto(hallway5);
            ovan.scMoveInto(hallway5);
            oldGuard.scMoveInto(hallway4);
            oldGuard.makePosture(standing);
            //if (oldGuard.getFoodItem)
            //  oldGuard.getFoodItem.baseMoveInto(nil);
            oldGuardSandwich.baseMoveInto(nil);
            oldGuardSandwich.hasBeenMovedIntoNil = true;
            //"<p>I did oldGuard.getFoodItem.moveInto(nil)!!! ";
            //"oldGuard.getFoodItem now equals ";
            //if (!oldGuard.getFoodItem) "nil";
            //else "<<oldGuard.getFoodItem.name>>";
            //"!!! <p>";
            //local k=0;k=k/k;
            if (me.isIn(dreamRoom) && dreamDoor.isOpen) {
              sayNpcsComeIntoView('south', 'west', [neton, ovan], true, 
                'Beyond the doorway to the south');
            }
            else if (me.canSee(neton)) {
              sayProfsRunTowardYou('west');
              sayNpcsComeIntoView('west', 'south', [oldGuard], true, 
                '<p>Behind them');
            }
          }
          break;
        case hallway5:
          if (me.isIn(dreamRoom)) {
            neton.scMoveInto(dreamRoom);
            ovan.scMoveInto(dreamRoom);
            oldGuard.scMoveInto(hallway5);
            if (!dreamDoor.isOpen) {
              dreamDoor.makeOpen(true);
              "Suddenly the door springs open, and ";
            }
            sayProfsRunIntoRoom('south');
            sayOvanKillsPc;
          }
          else if (me.isIn(hallway6) && !slowingField.isOn) {
            neton.scMoveInto(hallway6);
            ovan.scMoveInto(hallway6);
            oldGuard.scMoveInto(hallway5);
            "\^"; sayProfsRunIntoRoom('west');
            sayOvanKillsPc;
          }
          // If the above cases are not true, then presumably 
          // the PC will be either: (a) north of Hallway 6; or 
          // (b) in Hallway 6, but north of the slowing field while
          // the slowing field is on.
          // In either case, the PC can see Neton's and Ovan's 
          // arrival into Hallway 6, but is not killed when it happens.
          else {
            neton.scMoveInto(hallway6);
            ovan.scMoveInto(hallway6);
            oldGuard.scMoveInto(hallway5);
            if (me.isIn(hallway6)) {
              "\^"; sayProfsRunIntoRoom('west');
              //sayNpcsComeIntoView('south', 'west', [neton, ovan], true, 
              //  'Across the room from you, on the other side 
              //    of the slowing field');
            }
            else {
              sayNpcsComeIntoView('south', 'west', [neton, ovan], true, 
                'South of you, in the hallway at the bottom of the stairs');
            }
            if (slowingField.isOn) {
              "<p>Suddenly seeing the slowing field, Ovan flinches in 
                astonishment. Neton<./s>s eyes smolder with rage,
                and he mutters something beneath his breath. ";
            }
            if (me.isIn(hallway6)) {
              "<p>\^<<sayRelativeHallwayLoc('west')>>, the old guard
                <<runVerb>>s toward you. ";
            }
            glob.enemyState = goingToMuseum;
            //goNorthCount = 0;
          }
          break;
        default:
          "ERROR: neton.realLocation.getOutermostRoom == ";
          if (!neton.realLocation)
            "nil";
          else
            "<<neton.realLocation.getOutermostRoom.roomIdentifierStr>>";
          "! I did not anticipate that! ";
          break;
      }
      return;
    }
    // -------------------------------------------
    // STEP 3D: Agenda Type D: Going to the Museum
    // -------------------------------------------
    // 
    // From here on out we deal with the most complicated agenda type:
    // glob.enemyState == goingToMuseum.
    // 
    // (It's worth noting that by the time we get to this point, 
    // the slowing field is either on or off, and it will remain 
    // in that state for the duration of your fight with the aliens.)
    if (glob.enemyState == goingToMuseum) {
      // ---------------------------------------
      // STEP 3D: Going to the Museum
      // Part 1: Preliminaries
      // 
      // If there are no aliens left alive, or if all living NPCs
      // are currently stunned, we have nothing to do.
      if (!movingNpcs.length) {
        return;
      }
      // Record the location of each alien with a ridiculous
      // amount of precision.
      for (local a = 1; a <= movingNpcs.length; a++) {
        movingNpcs[a].getOutermostRoomBeforeMove = movingNpcs[a].getOutermostRoom;
        movingNpcs[a].realLocationBeforeMove = movingNpcs[a].realLocation;
        movingNpcs[a].yValueBeforeMove  = movingNpcs[a].yValue;
        movingNpcs[a].yOffsetBeforeMove = movingNpcs[a].yOffset;
        movingNpcs[a].xValueBeforeMove  = movingNpcs[a].xValue;
        movingNpcs[a].xOffsetBeforeMove = movingNpcs[a].xOffset;
      }
      // ---------------------------------------
      // STEP 3D: Going to the Museum
      // Part 2: Move the NPCs silently
      // 
      // The first turn: Neton and Ovan just arrived in hallway 6. 
      // One of them might have been rendered dead or stunned since 
      // their arrival, but not both. In this case, regardless of 
      // whether the slowing field/apparatus is on, Neton and/or 
      // Ovan will be south of it. If such is true, treat this case 
      // separately. 
      if ((neton.getOutermostRoom == hallway6 && neton.yValue == 0 && !neton.isStunned) ||
          (ovan.getOutermostRoom == hallway6 && ovan.yValue == 0 && !ovan.isStunned)) {
        if (!slowingField.isOn) {
          if (neton.canMove)
            neton.scMoveInto(stairs);
          if (ovan.canMove)
            ovan.scMoveInto(stairs);
        }
        else {
          if (neton.canMove) {
            neton.yBaseValue = 1;
            neton.yOffset = 0;
          }
          if (ovan.canMove) {
            ovan.yBaseValue = 1;
            ovan.yOffset = 0;
          }
        }
        bathDoor.makeOpen(true);
        youngGuard.scMoveInto(hallway5);
      }
      // The second turn: The young guard is in hallway5, but hasn't
      // gone to hallway 6 yet. Treat this case separately.
      else if (youngGuard.getOutermostRoom == hallway5) {
        if (!slowingField.isOn) {
          if (neton.canMove)
            neton.scMoveInto(hallway9);
          if (ovan.canMove)
            ovan.scMoveInto(hallway9);
        }
        else {
          if (neton.canMove)
            neton.yOffset = 1;
          if (ovan.canMove)
            ovan.yOffset = 1;
        }
        oldGuard.scMoveInto(hallway6);
        youngGuard.scMoveInto(hallway6);
        assistant.considerMovingToHallway6;
      }
      // Treat all other cases in the standard way.
      // 
      // Note that the assistant causes some difficulties, because 
      // we haven't decided yet when he will appear.
      // 
      // Fortunately, the assistant will be at the end of the 
      // movingNpcs list (assuming he is alive at all and not stunned),
      // so when dealing with him we can assume the other NPCs
      // have already been silently moved. To further emphasize:
      // we **rely** upon the fact that the assistant is at the end
      // of npcList above, so do not change that.
      else {
        for (local a = 1; a <= movingNpcs.length; a++) {
          // If the NPC is stepping into the slowing field, then
          // move him accordingly, and deal with any consequences.
          if (movingNpcs[a].getOutermostRoom == hallway6 && 
              movingNpcs[a].yValue == 0) {
            if (!slowingField.isOn) {
              movingNpcs[a].scMoveInto(stairs);
            }
            //else if (movingNpcs[a].ofKind(Guard) || movingNpcs[a] == assistant) {
            //  movingNpcs[a].scMoveInto(nil);
            //}
            else {
              // Let the NPC step into the slowing field.
              movingNpcs[a].yBaseValue = 1;
              movingNpcs[a].yOffset = -1;
              movingNpcs[a].isSlowed = true;
              // When the assistant walks into the slowing field, 
              // if there are any NPCs who are exactly 1 or 2 slowed units[*]
              // north of the assistant, move them so they are 3 slowed
              // units away. Likewise, if any are 4 or 5 slowed units north,
              // move them so they are 6 slowed units away.
              // 
              // [*] Definition: a "slowed unit" is how far a slowed NPC
              // can go in one turn: basically, one-twelfth of a typical 
              // room's length from north to south.
              if (movingNpcs[a] == assistant && movingNpcs.length > 1) {
                for (local b = 1; b <= movingNpcs.length - 1; b++) {
                  if (movingNpcs[b].getOutermostRoom == hallway6 &&
                      movingNpcs[b].yValue == 1 &&
                      movingNpcs[b].yOffset is in (0, 1)) {
                    movingNpcs[b].yBaseValue = 2;
                    movingNpcs[b].yOffset = -1;
                  }
                  else if (movingNpcs[b].getOutermostRoom == hallway6 &&
                      movingNpcs[b].yValue == 2 &&
                      movingNpcs[b].yOffset is in (0, 1)) {
                    movingNpcs[b].scMoveInto(stairs);
                    movingNpcs[b].yBaseValue = -1;
                    movingNpcs[b].yOffset = -1;
                  }
                }
              }
            }
          }
          // If the NPC is the assistant and he's in the 
          // conference room, let him consider whether to step out
          // into the hallway.
          else if (movingNpcs[a] == assistant && 
                   assistant.getOutermostRoom == confRoom) {
            assistant.considerMovingToHallway6;
          }
          // All other scenarios entail the NPC either doing a normal
          // run to the north (if the slowing field is off) or doing a normal
          // charge in absurdly slow motion (if the field is off).
          // Both cases are simple, compared to the alternatives above.
          // 
          // Therefore, if the slowing field is off, let the NPC do a normal
          // run to the north.
          else if (!slowingField.isOn) {
            if (movingNpcs[a].getOutermostRoom != museum)
              movingNpcs[a].scMoveInto(movingNpcs[a].getOutermostRoom.north
                .getDestination(movingNpcs[a].getOutermostRoom, movingNpcs[a]));
          }
          // And if the slowing field is on, let the NPC
          // do a normal charge in absurdly slow motion.
          else {
            // If the NPC can't go any farther north, then don't let the
            // NPC move.
            if (movingNpcs[a] is in (neton, ovan) &&
                movingNpcs[a].getOutermostRoom == museum &&
                movingNpcs[a].yValue >= 3) {
            }
            else if (movingNpcs[a] is in (oldGuard, youngGuard, assistant) &&
                     movingNpcs[a].getOutermostRoom == skyway &&
                     movingNpcs[a].yValue >= 1) {
            }
            // If going north in slow motion means going to the next room,
            // then go to the next room.
            else if (movingNpcs[a].getOutermostRoom != museum &&
                movingNpcs[a].yValue == 2 &&
                movingNpcs[a].yOffset == 1) {
              movingNpcs[a].scMoveInto(movingNpcs[a].getOutermostRoom.north
                .getDestination(movingNpcs[a].getOutermostRoom, movingNpcs[a]));
              if (movingNpcs[a].getOutermostRoom == museum)
                movingNpcs[a].yBaseValue = -3;
              else
                movingNpcs[a].yBaseValue = -1;
              movingNpcs[a].yOffset = -1;
            }
            // Otherwise, if going north in slow motion means
            // moving to the next visible quartile[*] of the same room,
            // then do so.
            // [*] Or "octile" if in the museum, I suppose.
            else if (movingNpcs[a].yOffset == 1) {
              movingNpcs[a].yBaseValue++;
              movingNpcs[a].yOffset = -1;
            }
            // If none of the above cases is true, then all we need to do
            // is adjust the yOffset.
            else {
              movingNpcs[a].yOffset++;
            }
          }
        }
        // When the slowing field is off, the assistant is very often 
        // in the same room as the guard(s). When this happens, 
        // it looks bad on the map (with all the NPCs smooshed together). 
        // As such, adjust the baseYValue of the assistant as needed
        // for cosmetic reasons when the slowing field is off.
        if (!slowingField.isOn && 
            assistant.getOutermostRoom is in (stairs, hallway9, skyway)) {
          if ((assistant.getOutermostRoom == oldGuard.getOutermostRoom 
               && oldGuard.yValue == 0) ||
              (assistant.getOutermostRoom == youngGuard.getOutermostRoom 
               && youngGuard.yValue == 0))
            assistant.yBaseValue = -1;
          else
            assistant.yBaseValue = 0;
        }
      }
      // Huzzah! We have finished silently moving the NPCs.
      
      // ---------------------------------------
      // STEP 3D: Going to the Museum
      // Part 3: Reporting the movements of the NPCs.
      // 
      // For reference:
      // movingNpcs[a].getOutermostRoomBeforeMove = movingNpcs[a].getOutermostRoom;
      // movingNpcs[a].realLocationBeforeMove = movingNpcs[a].realLocation;
      // movingNpcs[a].yValueBeforeMove  = movingNpcs[a].yValue;
      // movingNpcs[a].yOffsetBeforeMove = movingNpcs[a].yOffset;
      // movingNpcs[a].xValueBeforeMove  = movingNpcs[a].xValue;
      // movingNpcs[a].xOffsetBeforeMove = movingNpcs[a].xOffset;
      // 
      // In the unique event that Neton and Ovan have just stepped into
      // the slowing field **while you are immediately north of the 
      // slowing field in hallway 6**, let them kill you in a unique way.
      // Treat this case separately.
      // 
      // Note to self: Don't worry about whether Neton and Ovan have
      // been thrown a gun, because it's not possible for that to have
      // happened yet in this scenario.
      if (neton.getOutermostRoom == hallway6 && me.isIn(hallway6) &&
          neton.yValue == 1) {
        "On the other side of the room, Neton and Ovan glare 
            at you through the slowing field.
            Then Neton cries, <.q>Get him!<./q> 
          <p>With that, Neton and Ovan 
            extend their <<neton.standardWeapon.pluralName>> 
            as far as they can in front of them,
            then run headlong into the slowing field. 
            The slowing field seems to freeze them 
            in their tracks, but not before Neton<./s>s 
            <<neton.standardWeapon.name>> <<neton.standardWeapon.hitsYouPhrase>>. 
          <<neton.standardWeapon.deathParagraph(nil, nil)>>";
        neton.killPcAmusingly;
        endGame(ftDeath);
        return;
      }
      // In the event that Neton and/or Ovan are unslowed and have just run 
      // into the room that you're in, let them kill you in a unique way.
      // Treat this case separately; no need to describe the movements
      // of any other NPCs.
      // 
      // Note: Again, don't worry about whether Neton and Ovan have
      // been thrown a deadly gun. If that had happened, they would 
      // have killed you in Step 2, before we got to this point.
      if ((neton.getOutermostRoom == me.getOutermostRoom ||
           ovan.getOutermostRoom == me.getOutermostRoom)
           && !slowingField.isOn)
      {
        adHoc = [];
        if (ovan.getOutermostRoom == me.getOutermostRoom)
          adHoc = adHoc + ovan;
        if (neton.getOutermostRoom == me.getOutermostRoom)
          adHoc = adHoc + neton;
        "\^";
        simpleLister(adHoc, &theName);
        " run<<adHoc.length == 1 ? 's' : ''>> into the room
          from the south. ";
        if (adHoc.length == 1)
          "In a flash, he springs into action, ";
        else
          "Both of them run toward you, but <<adHoc[1].theName>>
            is faster, ";
        "<<adHoc[1].standardWeapon.assaultingYouDesc>>";
        adHoc[1].standardWeapon.deathParagraph(nil, nil);
        adHoc[1].killPcAmusingly;
        endGame(ftDeath);
        return;
      }
      // If neither of the above two scenarios apply, then use the 
      // normal method of reporting NPC movement.
      // 
      // Set reportMoveList to be a list of all NPCs that might be 
      // in motion nearby, formatted in a very special way, as follows:
      // [ 
      //   [], // NPCs moving normally, whether slowed or not. Further
      //            subdivide this list into other lists for NPCs who are 
      //            near each other. E.g.:
      //            [[neton,ovan],[oldGuard,youngGuard],[assistant]]
      //   [], // NPCs who have just stepped into the slowing field
      //   [], // NPCs (i.e. guards) who have just stepped into view from the west
      //   []  // NPCs (i.e. assistant) have just stepped out of the confRoom
      // ]
      reportMoveList = glob.getFormattedAlienListForMovement;
      // First, deal with reportMoveList[1]: NPCs moving normally,
      // whether slowed or not. This is the most complicated case.
      if (reportMoveList[1].length) {
        // If only one party, just report the party.
        if (reportMoveList[1].length == 1) {
          reportMovingParty(reportMoveList[1][1]);
          aliensInLastParagraph = reportMoveList[1][1].length;
          //////////////////////////////////////////////////
          // Set "HIM" or "THEM" pronoun stuff
          //////////////////////////////////////////////////
        }
        // Otherwise, if there's at least two parties, 
        // decide whether they are two or more rooms apart.
        // If so, and if the slowing field is off, give the 
        // appropriate report.
        else {
          adHoc = 0;  // adHoc  = the largest gap between the aliens
          adHoc2 = 0; // adHoc2 = the gap currently being measured
                      // adHoc3 = the last absoluteYValue measured
          
          // remember the first absoluteYValue
          adHoc3 = reportMoveList[1][1][1].absoluteYValue;
          for (local b = 2; b <= reportMoveList[1].length; b++) {
            // Figure out the value of this gap. Subtract the current
            // absoluteYValue from the one last remembered.
            adHoc2 = reportMoveList[1][b][1].absoluteYValue - adHoc3;
            if (adHoc2 < 0) adHoc2 = 0 - adHoc2;
            // If this gap is longer than the longest previous gap,
            // then recognize that this is now the longest gap so far.
            if (adHoc2 > adHoc) adHoc = adHoc2;
            // Remember this as the last absoluteYValue measured.
            adHoc3 = reportMoveList[1][b][1].absoluteYValue;
          }
          if (adHoc >= 200 && !slowingField.isOn) {
            aliensInLastParagraph = 
              reportFarMovingParties(reportMoveList[1]);
          }
          else {
            reportNearMovingParties(reportMoveList[1]);
            // The number of aliens mentioned in the paragraph may not
            // be 2, but the point is that there are more than one.
            // All numbers greater than one should be functionally equivalent
            // for aliensInLastParagraph.
            aliensInLastParagraph = 2;
          }
        }
      }
      // Next, deal with reportMoveList[2]: NPCs who have just stepped
      // into the slowing field.
      if (reportMoveList[2].length) {
        if (reportMoveList[2].indexOf(neton) || reportMoveList[2].indexOf(ovan)) {
          "<.p>To the south, in the hallway at the bottom of the stairs, ";
          simpleLister(reportMoveList[2], &theName);
          " gaze<<reportMoveList[2].length == 1 ? 's' : ''>> 
              at the slowing field, until finally 
              <<reportMoveList[2][1].theName>> says something about 
              <.q>no other choice.<./q> ";
          "<p>With that, ";
          simpleLister(reportMoveList[2], &theName);
          " run<<reportMoveList[2].length == 1 ? 's' : ''>> 
              headlong into the slowing field, which seems to freeze ";
          if (reportMoveList[2].length == 1)
            "him in his tracks. ";
          else
            "them in their tracks. ";
        }
        else {
          "<.p>\^";
          if (aliensInLastParagraph)
            sayBehindWhom(reportMoveList[2][1], aliensInLastParagraph, nil);
          else
            "To the south, in the hallway at the bottom of the stairs";
          ", ";
          simpleLister(reportMoveList[2], &theName);
          " gaze<<reportMoveList[2].length == 1 ? 's' : ''>> ";
          // The guards are uneasy when looking at the slowing field,
          // whereas the assistant is thoughtful.
          if (reportMoveList[2].indexOf(youngGuard) || reportMoveList[2].indexOf(oldGuard))
            "uneasily ";
          else
            "thoughtfully ";
          "at the slowing field. ";
          if (reportMoveList[2].length == 1)
            "Then, suddenly, he runs ";
          else // reportMoveList[2].length > 1
            "Then, all at once, they run ";
          "headlong into the field, which seems to freeze 
            <<reportMoveList[2].length == 1 ? 'him in his' : 'them in their'>>
            tracks. ";
        }
        slowingField.hasSlowedNpcs = true;
        aliensInLastParagraph = reportMoveList[2].length;
      }
      // Next, deal with reportMoveList[3]: NPCs (i.e. guards)
      // who have just stepped into Hallway 6 from the west.
      if (reportMoveList[3].length) {
        // There's really no need to allow for the possibility that
        // reportMoveList[3] will ever be anything but 
        // [oldGuard,youngGuard], assuming it is not [].
        // Remember, Neton and Ovan will already have arrived in
        // Hallway 6 before this.
        "<.p>\^";
        sayBehindWhom(reportMoveList[3][1], aliensInLastParagraph, true);
        //"in the hallway at the bottom of the stairs";
        ", ";
        "the old guard and the young guard come into view from the west, 
            then turn to face you. ";
        aliensInLastParagraph = reportMoveList[3].length;
      }
      // Finally, deal with reportMoveList[4]: NPCs (i.e. the assistant)
      // who have just stepped out of the conference room.
      if (reportMoveList[4].length) {
        // There's really no need to allow for the possibility that
        // reportMoveList[4] will ever list anything but the assistant.
        "<.p>Suddenly, the door to the conference room opens, 
          and the assistant walks out. He looks around, sees you, 
          then pulls a dagger from his jacket and ";
        if (oldGuard.location == hallway6 && oldGuard.yValue == 0 &&
            youngGuard.location == hallway6 && youngGuard.yValue == 0)
          "takes his place beside the guards. ";
        else
          "prepares for combat. ";
      }
      // ---------------------------------------
      // STEP 3D: Going to the Museum
      // Part 4: Post-movement attacking.
      // 
      // In some cases the aliens are allowed to try to attack you 
      // immediately after they move. Handle this here.
      // 
      // Part 4A: Post-movement range attacks.
      // 
      // Before dealing with any attacks by Neton or Ovan, deal with
      // any range attacks by the guards or the assistant, since the
      // guards and assistant have actual range weapons.
      // 
      // Do at most one of the following:
      // 
      // Deadly attacks:
      // 1. If the guards can kill the PC, let one of them do it. 
      //    (As a subsetof this, do the killing a bit differently 
      //    if the guards are at Hallway 6 with yValue == 0.)
      // 2. Otherwise, if the assistant can kill the PC, let him do it.
      // 
      // Harmless attacks:
      // 3. Otherwise, if the guards are in Hallway 6 with yValue == 0, 
      //    let them *both* fire at the PC and miss.
      // 4. Otherwise, if the guards are NOT slowed, let one of them[*]
      //    fire at you and miss every single turn.
      // 5. Otherwise, if the guards ARE slowed -- and if either 
      //    (1) the guards are within maxAlwaysShootDistance, or 
      //    (2) the guards have just traversed slowedSometimesShootInterval
      //    since the last time they shot and missed --
      //    then let one of them fire at you and miss.
      //For each of the rangeWielders, determine:
      //1. whether he can currently kill the PC
      //2. whether he is within maxAlwaysShootDistance
      //3. whether he is one of the northernmost guards
      //4. whether he has traversed slowedSometimesShootInterval
      
      
      // 
      
      // In order to decide which range attackers should attack, let's 
      // redo the calculation we did above (at the end of Step 1)
      // for who should be able to hit now. We need to redo it because
      // the NPCs have moved since we did this calculation last.
      // -------
      // Initialize the various lists associated with range wielders.
      adHoc = giveRangeWielderData;
      //rangeWielders = adHoc[1];
      rwsInHitRange = adHoc[2];
      rwsInMissRange = adHoc[3];
      northernmostRws = adHoc[4];
      effectualRwsInHitRange = adHoc[5];
      newlyEquippedRws = adHoc[6];
      rwsNotHavingFiredThisTurn = adHoc[7];
      local kludgeStringList = [
         'rangeWielders'
        ,'rwsInHitRange'
        ,'rwsInMissRange'
        ,'northernmostRws'
        ,'effectualRwsInHitRange'
        ,'newlyEquippedRws'
        ,'rwsNotHavingFiredThisTurn'
      ];
      if (glob.doKludgeStrings) {
        "<font color=red>";
        for (local a = 1; a <= adHoc.length; a++) {
          if (a == 1) "<.p>"; else "<br>";
          "<<kludgeStringList[a]>> = [";
          simpleLister(adHoc[a], &theName);
          "]";
        }
        "</font><.p>";
      }
      // RANGEFLAG
      /*
      rangeAttackersWhoHit = [];
      rangeAttackersWhoMiss = [];
      northernmostGuards = [];
      for (local a = 1; a <= rangeWielders.length; a++) {
        // If both the alien and the PC are in the "fish corridor"
        // (where any range attacks would take place), check to see if 
        // any range attacks should happen, whether successfully or not.
        if (me.getOutermostRoom.isInFishCorridor &&
            rangeWielders[a].realLocation &&
            rangeWielders[a].realLocation.getOutermostRoom.isInFishCorridor &&
            !rangeWielders[a].isStunned)
        {
          // If the alien is close enough to hit and kill the PC by 
          // range attack, let them do so.
          if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
               <= rangeWielders[a].weapon.maxHitDistance)
          {
            rangeAttackersWhoHit = rangeAttackersWhoHit + rangeWielders[a];
          }
          // If the alien is close enough to *want* to *try* to hit the PC,
          // but not close enough to actually hit, let him aim and miss.
          else if (rangeWielders[a].absoluteYValue - me.absYValForShooting 
                    <= rangeWielders[a].weapon.maxAlwaysShootDistance)
          {
            rangeAttackersWhoMiss = rangeAttackersWhoMiss + rangeWielders[a];
          }
          // If the alien is a guard and is as far or farther north
          // than any other guard, act accordingly.
          if (rangeWielders[a].ofKind(Guard) && !northernmostGuards.length) {
            northernmostGuards = [rangeWielders[a]];
          }
          else if (rangeWielders[a].ofKind(Guard) && 
              northernmostGuards[1].absoluteYValue > rangeWielders[a].absoluteYValue) {
            northernmostGuards = [rangeWielders[a]];
          }
          else if (rangeWielders[a].ofKind(Guard) && 
              northernmostGuards[1].absoluteYValue == rangeWielders[a].absoluteYValue) {
            northernmostGuards = northernmostGuards + rangeWielders[a];
          }
        }
      }
      */
      // Deadly range attacks by guards/assistant:
      // 1. If the guards can kill the PC, let one of them do it. 
      //    (As a subsetof this, do the killing a bit differently 
      //    if the guards are at Hallway 6 with yValue == 0.)
      // 2. Otherwise, if the assistant can kill the PC, let him do it.
      // 
      // Harmless range attacks by guards/assistant:
      // 3. Otherwise, if the guards are in Hallway 6 with yValue == 0, 
      //    let them *both* fire at the PC and miss.
      // 4. Otherwise, if the guards are NOT slowed, let one of them[*]
      //    fire at you and miss every single turn.
      // 5. Otherwise, if the guards ARE slowed -- and if either 
      //    (1) the guards are within maxAlwaysShootDistance, or 
      //    (2) the guards have just traversed slowedSometimesShootInterval
      //    since the last time they shot and missed --
      //    then let one of them fire at you and miss.
      
//local k = inputManager.getKey(nil, nil);
//if (k == 'q') { k = 0; k=k/k; }
      // RANGEFLAG
      // As a top priority, if any NPC can kill you,
      // let him do so. I.e., 
      // if any NPC is wielding a range weapon that's 
      // good enough to kill you and near enough to kill you, 
      // let him kill you.
      if (effectualRwsInHitRange.length) {
        if (glob.doKludgeStrings)
          "<p><font color=red>doEndJeo after movement: fire, hit, kill</font> ";
        executeRangeAttack(effectualRwsInHitRange, nil);
      }
      // Otherwise, if any range-wielder is within
      // "definite hit" distance and hasn't fired so far
      // this turn, let him fire (even though we know,
      // having ruled out the above scenario, that his 
      // attack will not succeed).
      else if (rwsInHitRange.intersect(rwsNotHavingFiredThisTurn).length) {
        if (glob.doKludgeStrings)
          "<p><font color=red>doEndJeo after movement: fire and hit harmlessly</font> ";
        executeRangeAttack(rwsInHitRange.intersect(rwsNotHavingFiredThisTurn), nil);
      }
      // Otherwise, if both guards just arrived in Hallway 6,
      // let them both fire at you.
      else if (oldGuard.realLocation == hallway6 && oldGuard.yValue == 0 && !oldGuard.isStunned &&
          youngGuard.realLocation == hallway6 && youngGuard.yValue == 0 && !youngGuard.isStunned) {
        if (glob.doKludgeStrings)
          "<p><font color=red>doEndJeo after movement: two-guard attack</font> ";
        executeRangeAttack([oldGuard, youngGuard], true);
      }
      // Otherwise, if any range-wielder is within "definite 
      // miss" distance and hasn't fired so far this turn,
      // let him fire and miss.
      else if (rwsInMissRange.intersect(rwsNotHavingFiredThisTurn).length) {
        if (glob.doKludgeStrings)
          "<p><font color=red>doEndJeo after movement: fire and do a very near miss</font> ";
        executeRangeAttack(rwsInMissRange.intersect(rwsNotHavingFiredThisTurn), nil);
      }
      // Otherwise, if the slowing field is OFF, any NPC
      // capable of firing at you should do so.
      else if (!slowingField.isOn && rwsNotHavingFiredThisTurn.length) {
        if (glob.doKludgeStrings)
          "<p><font color=red>doEndJeo after movement: fire unconditionally because field is off</font> ";
        executeRangeAttack(rwsNotHavingFiredThisTurn, nil);
      }
      // Otherwise, if the slowing field is ON, and if none
      // of the above scenarios apply, let an NPC fire at you 
      // only if one of them is at the right north-south
      // position relative to where a range weapon was last fired.
      else if (slowingField.isOn && 
               northernmostRws.intersect(rwsNotHavingFiredThisTurn).length &&
               prevAbsYValOfShooting > northernmostRws[1].absYValForShooting &&
               prevAbsYValOfShooting - northernmostRws[1].absYValForShooting == slowedSometimesShootInterval) {
        if (glob.doKludgeStrings)
          "<p><font color=red>doEndJeo after movement: slowedSometimesShootInterval attack</font> ";
        executeRangeAttack(northernmostRws.intersect(rwsNotHavingFiredThisTurn), nil);
      }
      
      
      
      
      /*
      // Just after the guards enter the hallway, they always
      // try a range attack.
      if (oldGuard.realLocation == hallway6 && oldGuard.yValue == 0) {
        executeRangeAttack([oldGuard, youngGuard]);
        //executeRangeAttackFromTwoGuards();
      }
      // If both guards can kill the PC, let one of them do so.
      else if (rangeAttackersWhoHit.indexOf(oldGuard) && 
          rangeAttackersWhoHit.indexOf(youngGuard)) {
        executeRangeAttack(chooseGuard);
      }
      // If any other NPC can kill the PC, let him do so.
      else if (rangeAttackersWhoHit.length) {
        executeRangeAttack(rangeAttackersWhoHit[1]);
      }
      else if (!slowingField.isOn && northernmostGuards.length) {
        if (northernmostGuards.indexOf(oldGuard) && 
            northernmostGuards.indexOf(youngGuard))
          executeRangeAttack(chooseGuard);
        else
          executeRangeAttack(northernmostGuards[1]);
      }
      else if (slowingField.isOn && rangeAttackersWhoMiss.length) {
        if (rangeAttackersWhoMiss.indexOf(oldGuard) && 
            rangeAttackersWhoMiss.indexOf(youngGuard))
          executeRangeAttack(chooseGuard);
        else
          executeRangeAttack(rangeAttackersWhoMiss[1]);
      }
      else if (slowingField.isOn && northernmostGuards.length &&
               prevAbsYValOfShooting > northernmostGuards[1].absYValForShooting &&
               prevAbsYValOfShooting - northernmostGuards[1].absYValForShooting == slowedSometimesShootInterval) {
        if (northernmostGuards.indexOf(oldGuard) && 
            northernmostGuards.indexOf(youngGuard))
          executeRangeAttack(chooseGuard);
        else
          executeRangeAttack(northernmostGuards[1]);
      }
      */
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      
      // Here endeth the range attack stuff.
      
      // Part 4B: Post-movement melee attacks (by Neton and Ovan).
      // 
      // First, make sure the profsWhoAttack list consists of all the 
      // *slowed* professors who are in a position to seriously consider
      // attacking the NPC. (If any non-slowed professors were 
      // in a position to attack the PC, then the PC should already have 
      // been killed by now.) (By the same token, stunned professors 
      // should never be in a position to attack the PC at this point.)
      if (neton.realLocation && neton.absoluteYValue - me.absoluteYValue <= 25
           && slowingField.isOn && !neton.isStunned)
        profsWhoAttack = profsWhoAttack + neton;
      if (ovan.realLocation && ovan.absoluteYValue - me.absoluteYValue <= 25
           && slowingField.isOn && !ovan.isStunned)
        profsWhoAttack = profsWhoAttack + ovan;
      // If there is more than one professor in profsWhoAttack,
      // and if the professors are in the museum, then
      // make sure the closer professor is listed first.
      if (profsWhoAttack.length == 2 && 
          profsWhoAttack[1].realLocation.isOrIsIn(museum) &&
          profsWhoAttack[1].horizontalDistanceToPc
            > profsWhoAttack[2].horizontalDistanceToPc)
        profsWhoAttack = [profsWhoAttack[2], profsWhoAttack[1]];
      // If there are any professors in a position to try to attack,
      // let them try to attack.
      if (profsWhoAttack.length) {
        // If you can possibly go north even by a few feet, then
        // you will automatically do so in order to forestall
        // being hit, and Neton and Ovan will not follow through
        // with their attack.
        if (me.getOutermostRoom != museum || me.yValue < 4) {
          // First give a message describing that Neton and Ovan would
          // like to hit you, and that you escape unharmed. The message
          // depends on whether the professors are in the museum or not --
          // or, if they are in the museum, whether they are 
          // "horizontally close" to you or not.
          if (!profsWhoAttack[1].realLocation.isOrIsIn(museum) ||
              profsWhoAttack[1].horizontalDistanceToPc <= 1) {
            "<.p>Suddenly ";
            simpleLister(profsWhoAttack, &theName);
            " ";
            profsWhoAttack[1].standardWeapon.lungesAttackPhrase(profsWhoAttack.length > 1);
            ". Fortunately, because 
              <<profsWhoAttack.length == 1 ? 'he is' : 'they are'>>
              slowed, you have time to <<me.leapAwayPhrase>>. "; 
          }
          else {
            "<.p>Suddenly ";
            simpleLister(profsWhoAttack, &theName);
            " eye<<profsWhoAttack.length == 1 ? 's' : ''>> 
              you fixedly and 
              pull<<profsWhoAttack.length == 1 ? 's back his' : ' back their'>>
              <<profsWhoAttack.length == 1 ? profsWhoAttack[1].standardWeapon.name 
              : profsWhoAttack[1].standardWeapon.pluralName>> 
              as if to throw 
              <<profsWhoAttack.length == 1 ? 'it' : 'them'>>
              at you. ";
            "<p>In response, you instinctively <<me.leapAwayPhrase>>. 
              Now that you are a bit farther away, ";
            simpleLister(profsWhoAttack, &theName);
            if (profsWhoAttack.length == 1)
              " seems to change his mind, ";
            else
              " seem to change their minds, ";
            "holding off on attacking you for the moment. ";
          }
          // Now that the message is taken care of, deal with the underlying
          // game mechanics.
          // 
          // If the PC is standing on a pedestal, move him off the 
          // pedestal and adjust his xValue.
          if (me.location.ofKind(Pedestal)) {
            me.moveInto(me.location.location);
            if (me.xValue < 0)
              me.xBaseValue = -2;
            else
              me.xBaseValue = 2;
            //callWithSenseContext(nil, nil, new function { "[endgameDaemon.doEndgameJeopardy.[If the PC is standing on a pedestal, move him off the 
            //  pedestal and adjust his xValue.]] "; } );
          }
          // Move the PC one unit further north. 
          // 
          // Usually, this will just move the PC farther north 
          // in the same room. That's easy.
          if (me.getOutermostRoom == museum || me.yValue != 2) {
            me.yBaseValue++;
            //callWithSenseContext(nil, nil, new function { "[endgameDaemon.doEndgameJeopardy.[Usually, this will just move the PC farther north 
            //  in the same room.]] "; } );
          }
          // Otherwise, if moving one unit further north means going
          // into the next room, then do that, and then show the 
          // new room description accordingly.
          else {
            me.moveIntoForTravel(me.getOutermostRoom.north
              .getDestination(me.getOutermostRoom, me));
            if (me.getOutermostRoom == museum)
              me.yBaseValue = -3;
            else
              me.yBaseValue = -1;
            //callWithSenseContext(nil, nil, new function { "[endgameDaemon.doEndgameJeopardy.[Otherwise, if moving one unit further north means going
            //  into the next room.]] "; } );
            "<p>";
            nestedAction(Look);
          }
        }
        // If, on the other hand, you cannot possibly go any farther
        // north, then at this point Neton and Ovan will kill you.
        // (Never mind the fact that they are slowed, and never mind 
        // that their weapons aren't designed to be thrown. They will 
        // kill you anyway.)
        // RANGEFLAG POSSIBLY?
        else {
          "Suddenly ";
          simpleLister(profsWhoAttack, &theName);
          " eye<<profsWhoAttack.length == 1 ? 's' : ''>> 
            you fixedly and ";
          // If the nearest NPC is quite close horizontally, he will 
          // make as if to do a melee attack.
          if (profsWhoAttack[1].horizontalDistanceToPc <= 1) {
            if (profsWhoAttack.length == 1)
              "grabs his <<profsWhoAttack[1].standardWeapon.name>>. ";
            else
              "grab their <<profsWhoAttack[1].standardWeapon.pluralName>>";
            " tighter, preparing to attack. ";
          }
          // Otherwise, if the nearest NPC is close vertically but not
          // horizontally, he will make as if to do a range attack.
          else {
            "pull<<profsWhoAttack.length == 1 ? 's back his' : ' back their'>>
              <<profsWhoAttack.length == 1 ? profsWhoAttack[1].standardWeapon.name 
              : profsWhoAttack[1].standardWeapon.pluralName>> 
              as if to throw 
              <<profsWhoAttack.length == 1 ? 'it' : 'them'>>
              at you. ";
          }
          "Unfortunately, you cannot run
            any farther north, so there is only one means of escape.
            As quickly as you can, you begin to run around 
            <<profsWhoAttack.length == 1 ? 'him' : 'them'>>. ";
          "<p>But ";
          simpleLister(profsWhoAttack, &theName);
          " do<<profsWhoAttack.length == 1 ? 'es' : ''>> not give up. ";
          profsWhoAttack[1].standardWeapon.lastDitchSentence(profsWhoAttack.length > 1);
          profsWhoAttack[1].standardWeapon.rangeAttackSomehowSucceeds;
          profsWhoAttack[1].killPcAmusingly;
          endGame(ftDeath);
          return;
        }
      }
    }
  }
  executeRangeAttackFromTwoGuards {
    "<.p>If I had finished programming executeRangeAttackFromTwoGuards(),
      we would now be executing a range attack from two guards. ";
  }
  /*
  executeRangeAttack(attackers) {
    // Preliminaries
    local attackerDistance;
    if (dataType(attackers) != TypeList)
      attackers = [attackers];
    attackerDistance = 
      attackers[1].absYValForShooting - me.absYValForShooting;
    // Always begin with a paragraph break.
    "<.p>";
    // First deal with the more difficult, less likely scenario
    // where there is more than one attacker...
    if (attackers.length > 1) {
      // Unless I make big changes, there should never be more 
      // than one attacker except when the only two attackers 
      // are the guards...
      if (attackers.length == 2 && attackers.indexOf(oldGuard)
          && attackers.indexOf(youngGuard)) {
        "\^<<simpleLister(attackers, &theName)>> 
            raise their hand cannons and fire at you. ";
        if (attackerDistance <= attackers[1].weapon.maxHitDistance) {
          "The old guard misses you by a hair, but the young guard 
            does not. ";
          youngGuard.weapon.deathParagraph(nil, nil);
          youngGuard.killPcAmusingly;
          endGame(ftDeath);
        }
        else {
          " ";
        }
      }
      // ...but just in case, do a generic handling for any
      // other multi-attacker cases. Theoretically, this will 
      // often fail, but then, it should never happen.
      else {
        "\^<<simpleLister(attackers, &theName)>>
            raise their weapons and fire at you. 
            Unfortunately, their aim is dead-on. ";
      }
    }
    
    // Assistant handling. We assume that the assistant will never
    // be in a list with anybody else.
    if (attackers[1] == assistant) {
      // Let the assistant do a deadly range attack, if applicable.
      if (attackerDistance <= attackers[1].weapon.maxHitDistance) {
        attackers[1].weapon.suddenRangeAttackParagraph('suddenly ', nil);
        attackers[1].weapon.deathParagraph(true, nil);
        attackers[1].killPcAmusingly;
        endGame(ftDeath);
      }
      // No non-deadly range attack has been designed for the assistant.
      else { }
    }
    // The attacker(s) are one or more guards.
    else {
      // No matter there's one or two guards, no matter whether they 
      // hit or miss, their attack starts with them raising their
      // hand cannons and shooting at you.
      if (attackers.length == 1) {
        "\^<<attackers[1].theName>> 
          raises his hand cannon and fires at you. ";
      }
      else {
        "\^<<simpleLister(attackers, &theName)>> 
          raise their hand cannons and fire at you. ";
      }
      // If hitting and killing...
      if (attackerDistance <= attackers[1].weapon.maxHitDistance) {
        // Just one guard hitting and killing...
        if (attackers.length == 1) {
          //"This time, he does not miss. ";
          attackers[1].weapon.deathParagraph(true, nil);
          attackers[1].killPcAmusingly;
          endGame(ftDeath);
        }
        // Two guards hitting and killing...
        else {
          "The old guard misses you by a hair, but the young guard 
            does not. ";
          youngGuard.weapon.deathParagraph(nil, nil);
          youngGuard.killPcAmusingly;
          endGame(ftDeath);
        }
      }
      // If missing...
      else {
        if (attackers.length == 1)
          "A bolt of plasma flies by you, ";
        else
          "Two bolts of plasma fly by you, ";
        if (attackerDistance <= attackers[1].weapon.maxAlwaysShootDistance) {
          "missing you by only <<rand('a hair','a fraction of an inch')>>. ";
          "\^<<sayNpcsCurse(attackers)>>, while you take a deep breath.
            That was far too close. ";
        }
        else if (attackerDistance - 100 <= attackers[1].weapon.maxAlwaysShootDistance) {
          "missing you by only a couple of feet. ";
          "\^<<sayNpcsCurse(attackers)>>, while you take a deep breath.
            That was close. ";
        }
        //else if (attackerDistance - 200 <= attackers[1].weapon.maxAlwaysShootDistance) {
        //  "missing you by a few feet. ";
        //  "\^<<sayNpcsCurse(attackers)>>. ";
        //}
        else {
          "missing you by a wide margin. ";
          "\^<<sayNpcsCurse(attackers)>>. ";
        }
      }
    }
    prevAbsYValOfShooting = attackers[1].absYValForShooting;
  }
  */
  sayNpcsCurse(lst) {
    if (lst.length == 0) { }
    else if (lst.length == 1) {
      lst[1].sayCurse;
    }
    else if (lst[1].ofKind(Guard) && lst[2].ofKind(Guard)) {
      "the guards curse";
    }
    else {
      "the aliens curse";
    }
  }
  reportMovingParty(lst) {
    "<.p>";
    "\^<<lst[1].relLocStrForMovement(nil)>>, ";
    simpleLister(lst, &theName);
    " <<defaultRunPhrase(lst)>>. ";
  }
  reportNearMovingParties(lst) {
    local largestParty = 0;
    local totalMembers = 0;
    for (local a = 1; a <= lst.length; a++) {
      if (lst[a].length > largestParty) largestParty = lst[a].length;
      totalMembers = totalMembers + lst[a].length;
    }
    "<.p>";
    "\^<<lst[1][1].relLocStrForMovement(nil)>>, ";
    simpleLister(lst[1], &theName);
    " <<defaultRunPhrase(lst[1])>>";
    if (lst.length > 1) { // should always be true
      for (local a = 2; a <= lst.length; a++) {
        // Do "; " and ", " if you want.
        if (largestParty > 2) ", "; else ", ";
        "followed by ";
        simpleLister(lst[a], &theName);
        // Do parenthetical stuff if you want.
        if (lst[a][1].realLocation == hallway6 && slowingField.isOn &&
            lst[a][1].yValue == 1) {
          " (in the slowing field)";
        }
      }
    }
    ". ";
  }
  reportFarMovingParties(lst) {
    local lastAbsVal;
    local largestParty = 0;
    local totalMembers = 0;
    local aliensInLastParagraph = 0;
    for (local a = 1; a <= lst.length; a++) {
      if (lst[a].length > largestParty) largestParty = lst[a].length;
      totalMembers = totalMembers + lst[a].length;
    }
    "<.p>";
    "\^<<lst[1][1].relLocStrForMovement(nil)>>, ";
    simpleLister(lst[1], &theName);
    " <<defaultRunPhrase(lst[1])>>";
    lastAbsVal = lst[1][1].absoluteYValue;
    aliensInLastParagraph = lst[1].length;
    if (lst.length > 1) { // should always be true
      for (local a = 2; a <= lst.length; a++) {
        // Scenario 1: This party is at least two rooms away
        // from the last party
        if (lst[a][1].absoluteYValue - lastAbsVal >= 200 ||
            lst[a][1].absoluteYValue - lastAbsVal <= 200) {
          ". ";
          "<p>Behind <<lst[a-1].length > 1 ? 'them' : 'him'>>, 
            <<lst[a][1].relLocStrForMovement(nil)>>, ";
          simpleLister(lst[a], &theName);
          " <<defaultRunPhrase(lst[a])>>";
          aliensInLastParagraph = lst[a].length;
        }
        // Scenario 2: This party is less than two rooms away
        // from the last party
        else {
          // Do "; " and ", " if you want.
          if (largestParty > 2) ", "; else ", ";
          "followed by ";
          simpleLister(lst[a], &theName);
          aliensInLastParagraph = aliensInLastParagraph + lst[a].length;
        }
        lastAbsVal = lst[a][1].absoluteYValue;
        // no need to add parenthetical stuff; this scenario presumably
        // implies that the slowing field is not involved
      }
    }
    ". ";
    // We must return the proper plural value here.
    return (aliensInLastParagraph > 1);
  }
  // This must be a multiple of 25 or it will not work.
  slowedSometimesShootInterval = 50
  prevAbsYValOfShooting = 10000 // an arbitrarily large number
  chooseGuard {
    if (guardChoice == youngGuard)
      guardChoice = oldGuard;
    else
      guardChoice = youngGuard;
    return guardChoice;
  }
  guardChoice = oldGuard // this is the one NOT to start with.
  defaultRunPhrase(lst) {
    // vertical = the vertical distance between you and this party
    // horizontal = the horizontal distance between you and *the closest
    //   member* of this party
    local vertical = 0;   
    local horizontal = 0; // 
    local horizontal2 = 0;
    local oblique = nil;
    vertical = me.absoluteYValue - lst[1].absoluteYValue;
    // This line should be reduntant:
    if (vertical < 0)
      vertical = 0 - vertical;
    horizontal = me.absoluteXValue - lst[1].absoluteXValue;
    if (horizontal < 0)
      horizontal = 0 - horizontal;
    if (lst.length > 1) {
      horizontal2 = me.absoluteXValue - lst[2].absoluteXValue;
      if (horizontal2 < 0)
        horizontal2 = 0 - horizontal2;
      if (horizontal2 < horizontal)
        horizontal = horizontal2;
    }
    // The NPC(s) always go directly northward, even if they are 
    // in the museum and the PC is not directly north of them.
    // This may mean they are moving "obliquely" with respect to
    // the PC. By our definition, if the ratio of their horizontal 
    // difference to their vertical difference is 1:3 or greater, 
    // then the NPC(s) are proceeding obliquely.
    if (horizontal * 100 / vertical >= 33)
      oblique = true;
    if (lst[1].getOutermostRoom == museum && lst.length == 1 && 
        slowingField.isOn && oblique)
      " eye<<lst.length == 1 ? 's' : ''>> 
        you intently as 
        <<lst.length == 1 ? 'he continues' : 'they continue'>> 
        to <<slowedRunVerb>> northward in absurdly slow motion";
    else if (slowingField.isOn)
      " <<slowedRunVerb>><<lst.length == 1 ? 's' : ''>> toward you 
        in absurdly slow motion";
    else
      " <<runVerb>><<lst.length == 1 ? 's' : ''>> toward you";
  }
  sayBehindWhom(sampleAlien, aliensInLastParagraph, verbose) {
    if (aliensInLastParagraph >= 1) {
      if (aliensInLastParagraph == 1)
        "behind him";
      else
        "behind them";
      if (verbose)
        ", <<sampleAlien.relLocStr(true)>>";
    }
    else
      "<<sampleAlien.relLocStr(nil)>>";
  }
  sayOvanKillsPc {
    "Both of them rush toward you, but Ovan is faster, 
        pouncing on you and <<ovan.standardWeapon.hittingYouPhrase>>. 
      <<ovan.standardWeapon.deathParagraph(nil, nil)>>";
    //"Ovan kills you. <p>";
    ovan.killPcAmusingly;
    endGame(ftDeath);
  }
  sayProfsRunTowardYou(dirStr) {
    "\^<<sayRelativeHallwayLoc(dirStr)>>, Neton and Ovan 
      <<runVerb>> toward you. ";
  }
  sayProfsRunIntoRoom(dirStr) {
    "Neton and Ovan <<runVerb>> into the room from the <<dirStr>>";
    if (me.isIn(hallway6) && slowingField.isOn)
      ", then turn to look at you from behind the slowing field";
    ". ";
  }
  killPcByOrdinaryCloseNpcs(ordinaryCloseNpcs) {
    simpleLister(ordinaryCloseNpcs, &theName);
    if (!neton.facingYou) {
      " whirl<<ordinaryCloseNpcs.length == 1 ? 's' : ''>> 
        to face you. ";
      if (ordinaryCloseNpcs.length == 1)
        "Then he springs into action, ";
      else
        "\^<<ordinaryCloseNpcs[1].theName>> is the first to react, ";
    }
    else {
      if (ordinaryCloseNpcs.length == 1)
        " springs into action, ";
      else
        " spring into action. \^<<ordinaryCloseNpcs[1].theName>> is 
          <<ordinaryCloseNpcs.length <= 2 ? 'faster' : 'the fastest'>>, ";
    }
    "<<ordinaryCloseNpcs[1].standardWeapon.assaultingYouDesc>>";
    "<<ordinaryCloseNpcs[1].standardWeapon.deathParagraph(nil, nil)>>";
    ordinaryCloseNpcs[1].killPcAmusingly;
    endGame(ftDeath);
    return;
  }
  killPcBySlowedCloseNpcs(slowedCloseNpcs) {
    if (gPlayerChar.isIn(museum) && 
        (slowedCloseNpcs[1] == neton || slowedCloseNpcs[1] == ovan)) {
      if (slowedCloseNpcs.length == 1)
        "his upper body seems less affected 
          than his legs. ";
      else
        "their upper bodies seem less affected than their legs. ";
      "Realizing this may be 
        <<slowedCloseNpcs.length == 1 ? 'his' : 'their'>> last chance, 
        <<slowedCloseNpcs.length == 1 ? 'he makes' : 'they make'>>
        a last-ditch effort, ";
      slowedCloseNpcs[1].standardWeapon.lastDitchPhrase(slowedCloseNpcs.length > 1);
      "<p>";
      //
      slowedCloseNpcs[1].standardWeapon.rangeAttackSomehowSucceeds;
    }
    else {
      if (slowedCloseNpcs.length == 1)
        "his upper body seems less affected 
          than his legs. ";
      else
        "their upper bodies seem less affected than their legs. 
          <<slowedCloseNpcs.length == 2 ? 'Both' : 'All'>> 
          of them prepare to attack you, but 
          <<slowedCloseNpcs[1].theName>> is
          <<slowedCloseNpcs.length == 2 ? 'faster' : 'the fastest'>>. ";
      // "With some effort, he reaches over and pokes into your ribs
      // with his icepick."
      slowedCloseNpcs[1].standardWeapon.slowedAssaultSentence;
      // "For a moment, you are engulfed in blinding light and 
      // agonizing pain."
      // "Then <<glob.youCollapseToTheFloor>>."
      slowedCloseNpcs[1].standardWeapon.deathParagraph(nil, nil);
    }
    //local k = 0; k=k/k;
    slowedCloseNpcs[1].killPcAmusingly;
    endGame(ftDeath);
    return;
  }
  killPcByStunnedCloseNpcs(stunnedCloseNpcs) {
    "Apparently, however, that phaser was not as effective
      as you<./s>d hoped, because ";
    "<<stunnedCloseNpcs[1].theName>> seems
      to sense your proximity, and somehow
      he wakes up,
      <<stunnedCloseNpcs[1].standardWeapon.assaultingYouDesc>>";
    //"the <<stunnedCloseNpcs.length == 1 ? 'alien seems' : 'aliens seem'>>
    //  to sense your proximity, and somehow
    //  <<stunnedCloseNpcs.length == 1 ? 'he wakes' : 'they wake'>> up,
    //  <<stunnedCloseNpcs[1].assaultingYouDesc>>. ";
    if (gPlayerChar.isIn(museum))
      neton.standardWeapon.lastDitchSentence(stunnedCloseNpcs.length > 1);
    "<p><.odyssey>\^";
    simpleLister(stunnedCloseNpcs, &theName);
    " attack<<stunnedCloseNpcs.length == 1 ? 's' : ''>> 
      me unexpectidly!<./odyssey> ";
    "<br>";
    // Note: No killPcAmusingly here because it's a Scott Adams death.
    scottAdamsDeath();
    return;
  }
  sayNpcsComeIntoView(dirSeeStr, dirFromStr, npcList, turnToFace, downTheHallwayStr) {
    if (downTheHallwayStr)
      "\^<<downTheHallwayStr>>, ";
    else
      "\^<<sayRelativeHallwayLoc(dirSeeStr)>>, ";
    simpleLister(npcList, &theName);
    " come<<npcList.length == 1 ? 's' : ''>> 
      into view from the 
      <<dirFromStr>>";
    if (turnToFace)
      ", then turn<<npcList.length == 1 ? 's' : ''>> to face you";
    ". ";
  }
  sayRelativeHallwayLoc(dirStr) {
    return 'down the ' + dirStr + 'ern hallway';
  }
  runVerb = 'run'
  slowedRunVerb = 'charge'
  //goNorthCount = 0
;

modify glob
  doKludgeStrings = nil
  yellingAtGuardTakesTime = true
;

enum wideMiss, mediumMiss, narrowMiss;

modify neton
  facingYou = true
;
modify assistant
  turnsWaited = 0
  turnsToWaitBeforeMoving = (slowingField.isOn ? 1 : 0)
  considerMovingToHallway6 {
    if (getOutermostRoom != confRoom)
      return;
    if (turnsWaited >= turnsToWaitBeforeMoving) {
      confDoor.makeOpen(true);
      scMoveInto(hallway6);
    }
    else {
      turnsWaited++;
    }
  }
;

vertToken: object
  verticalValue = 0
;

modify Alien
  horizontalDistanceToPc {
    if (!realLocation)
      return 10000;
    if (xValue - me.xValue >= 0)
      return xValue - me.xValue;
    else
      return me.xValue - xValue;
  }
;

modify me
  leapAwayPhrase {
    local roomToLeapTo;
    if (me.getOutermostRoom == museum || me.yValue < 2)
      roomToLeapTo = me.getOutermostRoom;
    else switch (me.getOutermostRoom) {
      case skyway:
      case hallway9:
      case stairs:
      case hallway6:
        roomToLeapTo = me.getOutermostRoom.north
          .getDestination(me.getOutermostRoom, me);
        break;
      default:
        roomToLeapTo = me.getOutermostRoom;
        break;
    }
    "leap away";
    if (me.location.ofKind(Pedestal))
      " off the pedestal";
    ", heading ";
    switch (roomToLeapTo) {
      case stairs:
        "north up the stairs";
        break;
      case museum:
        if (me.getOutermostRoom == museum)
          "further ";
        "north into the museum";
        break;
      default:
        "north down the <<roomToLeapTo.name>>";
        break;
    }
  }
;

modify Alien
  isSlowed = nil
  //isSlowed {
  //  if (realLocation && self.absYValForList <= 49 && slowingField.isOn)
  //    return true;
  //  return nil;
  //}
  //canKillPcIfPcEntersRoom {
  //  if (!isSlowed )
  //    return true;
  //  if (yValue > 0)
  //    return true;
  //  if (self.ofKind(Guard) || self == assistant)
  //    return true;
  //  return nil;
  //}
  isVeryCloseToPc {
    if (!realLocation)
      return nil;
    if (!realLocation.ofKind(AlienRoom))
      return nil;
    if (!realLocation.isInFishCorridor)
      return (realLocation == me.getOutermostRoom);
    // We can probably assume that if the slowing field is off
    // and the aliens are not stunned, the rules below do not apply.
    if (!slowingField.isOn && !isStunned)
      return (realLocation == me.getOutermostRoom);
//    // In the unique event that the PC and the alien
//    // are both in Hallway 6, even if separated by the
//    // slowing field, we must declare that they are
//    // "very close," in order to avoid buggy situations
//    // such as the PC being able to walk west around
//    // stunned aliens who are standing just south of
//    // the slowing field.
//    if (me.getOutermostRoom == hallway6 &&
//        getOutermostRoom == hallway6)
//      return true;
    // Otherwise, the alien is in the fish corridor
    // and no special conditions apply. In this case,
    // isVeryCloseToPc depends on whether the alien is 
    // only one vertical map unit away from the PC.
    if (absoluteYValue - me.absoluteYValue >= -25 &&
        absoluteYValue - me.absoluteYValue <= 25)
      return true;
    return nil;
  }
;

modify Actor
  // kludgey, but good enough
  relDirStr {
    local meRow  = gPlayerChar.getOutermostRoom.isInRow;
    if (getOutermostRoom.isInRow < meRow)
      return 'north';
    if (getOutermostRoom.isInRow > meRow)
      return 'south';
    local meColumn  = gPlayerChar.getOutermostRoom.isInColumn;
    if (getOutermostRoom.isInColumn < meColumn)
      return 'west';
    if (getOutermostRoom.isInColumn > meColumn)
      return 'east';
    if (absYValForList < me.absYValForList)
      return 'south';
    return 'coincident';
  }
  relLocStr(simple) {
    switch (getOutermostRoom) {
      case office:
        if (!gPlayerChar.isIn(hallway8))
          return 'through the window to the ' + relDirStr;
        break;
      case dreamRoom:
        if (gPlayerChar.isIn(office))
          return 'through the window to the ' + relDirStr;
        break;
      case museum:
      case skyway:
      case stairs:
        if (gPlayerChar.isIn(getOutermostRoom) && !simple)
          return 'south of you ' + getOutermostRoom.actorInName;
        break;
      case hallway9:
        if (gPlayerChar.isIn(hallway9) && !simple)
          return 'south of you in the hallway at the top of the stairs';
        else if (!simple)
          return 'to the south, in the hallway at the top of the stairs';
        else
          return 'in the hallway at the top of the stairs';
        //break;
      case hallway6:
        if (!slowingField.isOn) { // slowing field is off
          if (gPlayerChar.isIn(hallway9) && !simple)
            return
              'south of you in the hallway at the bottom of the stairs';
          else if (!simple)
            return 'to the south, ' +
              'in the hallway at the bottom of the stairs';
          else
            return 'in the hallway at the bottom of the stairs';
        }
        else { // slowing field is on
          if (yValue == 2)
            return 'just to the north of the slowing field';
          if (yValue == 1)
            return 'right in the middle of the slowing field';
          // For the following, yValue == 0; that is, south of slowing field
          if (gPlayerChar.isIn(hallway6))
            return 'across the room, on the other side of the slowing field';
          return 'on the other side of the slowing field';
        }
    }
    // all other cases are default
    if (!simple)
      return getOutermostRoom.actorInName + ' to the ' + relDirStr;
    else
      return getOutermostRoom.actorInName;
  }
  relLocStrForMovement(simple) {
    // Screw this. I tried to resist describing characters' locations
    // in the same way when they are moving as when they are staying still
    // (because that can create a set of paragraphs with jarringly similar
    // beginnings if you LOOK before the aliens move).
    // However, there is basically no decent way of accomplishing this.
    // The modifications commented out below just don't sound good to me.
    return relLocStr(simple);
    
    //if (!gPlayerChar.isIn(getOutermostRoom) && !simple) {
    //  switch (getOutermostRoom) {
    //    case skyway:
    //      return 'down in the skyway to the south';
    //    case stairs:
    //      return 'down on the stairs to the south';
    //    case hallway9:
    //      return 'down the hallway, north of the stairs';
    //  }
    //}
    //return relLocStr(simple);
  }
  relLocForNpcDesc {
    if (getOutermostRoom == hallway6 && slowingField.isOn && !gPlayerChar.isIn(hallway6)) {
      return 'in the hallway at the bottom of the stairs, '
        + relLocStr(nil);
    }
    else {
      return relLocStr(nil);
    }
  }
  absXValForList {
    return getOutermostRoom.isInColumn * 10;
  }
  absYValForList {
    return getOutermostRoom.isInRow * 10 - yValue;
  }
;

// Note to self: glob.giveAlienMovementReport() seems not to be used.
// I could probably comment it out if I wanted.

modify glob
  giveAlienMovementReport {
    // Receive a list of the movingNpcs that is formatted in
    // just the right way to make things convenient for us to report.
    local lst = glob.getFormattedAlienListForMovement;
    if (lst[1].length) {
    }
    if (lst[2].length) {
      
    }
    if (lst[3].length) {
    }
    if (lst[4].length) {
      "<.p>Suddenly, the door to the conference room opens, 
        and the assistant walks out. He looks around, sees you, 
        then pulls a dagger from his jacket and ";
      if (oldGuard.getOutermostRoom == hallway6 &&
          oldGuard.yValue == 0 &&
          youngGuard.getOutermostRoom == hallway6 &&
          youngGuard.yValue == 0)
        "takes his place next to the guards. ";
      else if (slowingField.isOn)
        "readies himself for combat. ";
      else
        "readies himself for combat. ";
    }
  }
/*
  doEndgameJeopardy {
//    // First of all, if the PC has walked into a room where there
//    // are hostile NPCs who are able to kill him, then let them kill him.
//    if (neton.realLocation && 
//          neton.realLocation.getOutermostRoom == me.getOutermostRoom) {
//      // Update the banner so that the program allows the proper
//      // amount of horizontal room for the non-map part of the window
//      // (and thus the "press space for more" message won't show up
//      // in the wrong spot).
//      //nbmBanner.updateMe;
//      //nestedAction(Look);
//      "<.p>Neton kills you. ";
//      "Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. Neton kills you. ";
//      endGame(ftDeath);
//      //considerKillingPc;
//    }
    // If endgameJeopardy && glob.enemyState == arguing, then 
    // let the profs argue.
    if (glob.enemyState == arguing) {
      //if (endgameProfSequence.epsValue != 1) {
        endgameProfSequence.execute;
      //}
    }
    else if (glob.enemyState == waiting) {
      if (neton.realLocation == hallway8)
        glob.enemyState = goingToHallway6;
    }
    else if (glob.enemyState == goingToHallway6) {
      switch (neton.realLocation.getOutermostRoom) {
        case hallway8:
          neton.scMoveInto(hallway7);
          ovan.scMoveInto(hallway7);
          if (me.canSee(neton))
            sayProfsRunTowardYou('north');
          break;
        case hallway7:
          if (me.isIn(hallway4)) {
            neton.scMoveInto(hallway4);
            ovan.scMoveInto(hallway4);
            "\^"; sayProfsRunIntoRoom('north');
            sayOvanKillsPc;
          }
          else {
            neton.scMoveInto(hallway4);
            ovan.scMoveInto(hallway4);
            if (me.canSee(neton))
              sayNpcsComeIntoView('west', 'north', [neton, ovan], nil, nil);
            if (glob.yellingAtGuardTakesTime) {
              neton.facingYou = nil;
            }
            else {
              if (me.canSee(neton))
                "<p>Neton shouts to the room to his south, saying 
                  something about <.q>eliminate him!<./q> With that, 
                  he and Ovan turn to face you. ";
            }
          }
          break;
        case hallway4:
          if (me.isIn(hallway5)) {
            neton.scMoveInto(hallway5);
            ovan.scMoveInto(hallway5);
            "\^"; sayProfsRunIntoRoom('west');
            sayOvanKillsPc;
          }
          else if (!neton.facingYou) {
            neton.facingYou = true;
            if (me.canSee(neton))
              "\^<<sayRelativeHallwayLoc('west')>>, Neton shouts to the room 
                  to his south, saying something about <.q>eliminate him!<./q> 
                  With that, he and Ovan turn to face you. ";
          }
          else { // neton.facingYou is true
            neton.scMoveInto(hallway5);
            ovan.scMoveInto(hallway5);
            if (oldGuard.getFoodItem)
              oldGuard.getFoodItem.moveInto(nil);
            oldGuard.makePosture(standing);
            oldGuard.scMoveInto(hallway4);
            if (me.isIn(dreamRoom) && dreamDoor.isOpen) {
              sayNpcsComeIntoView('south', 'west', [neton, ovan], true, 
                'Beyond the doorway to the south');
            }
            else if (me.canSee(neton)) {
              sayProfsRunTowardYou('west');
              sayNpcsComeIntoView('west', 'south', [oldGuard], true, 
                '<p>Behind them');
            }
          }
          break;
        case hallway5:
          if (me.isIn(dreamRoom)) {
            neton.scMoveInto(dreamRoom);
            ovan.scMoveInto(dreamRoom);
            oldGuard.scMoveInto(hallway5);
            if (!dreamDoor.isOpen) {
              dreamDoor.makeOpen(true);
              "Suddenly the door springs open, and ";
            }
            sayProfsRunIntoRoom('south');
            sayOvanKillsPc;
          }
          else if (me.isIn(hallway6) && !slowingField.isOn) {
            neton.scMoveInto(hallway6);
            ovan.scMoveInto(hallway6);
            oldGuard.scMoveInto(hallway5);
            "\^"; sayProfsRunIntoRoom('west');
            sayOvanKillsPc;
          }
          // If the above cases are not true, then presumably 
          // the PC will be either (a) north of Hallway 6 or 
          // (b) in Hallway 6, but north of the slowing field while
          // the slowing field is on.
          // In either case, the PC can see Neton's and Ovan's 
          // arrival into Hallway 6, but is not killed when it happens.
          else {
            neton.scMoveInto(hallway6);
            ovan.scMoveInto(hallway6);
            oldGuard.scMoveInto(hallway5);
            if (me.isIn(hallway6)) {
              "\^"; sayProfsRunIntoRoom('west');
              //sayNpcsComeIntoView('south', 'west', [neton, ovan], true, 
              //  'Across the room from you, on the other side 
              //    of the slowing field');
            }
            else {
              sayNpcsComeIntoView('south', 'west', [neton, ovan], true, 
                'South of you, in the hallway at the bottom of the stairs');
            }
            "<p>Suddenly seeing the slowing field, Ovan flinches in 
              astonishment. Neton<./s>s eyes smolder with rage,
              and he mutters something beneath his breath. ";
            if (me.isIn(hallway6)) {
              "<p>\^<<sayRelativeHallwayLoc('west')>>, the old guard
                <<runVerb>>s toward you. ";
            }
            glob.enemyState = goingToMuseum;
            goNorthCount = 0;
          }
          break;
        default:
          "ERROR: neton.realLocation.getOutermostRoom == ";
          if (!neton.realLocation)
            "nil";
          else
            "<<neton.realLocation.getOutermostRoom.roomIdentifierStr>>";
          "! I did not anticipate that! ";
          break;
      }
    }
    // If the above cases are not true, then by this time Neton 
    // and Ovan will have already reached Hallway 6.
    // At this point, the slowing field is either on or off, 
    // and it will remain in that state until all the aliens
    // are dead.
    else if (glob.enemyState == goingToMuseum && !slowingField.isOn) {
      goNorthCount++;
      //if (neton.get) {
      //}
      if (goNorthCount == 1) {
        
      }
    }
    else if (glob.enemyState == goingToMuseum) { // slowing field is on
      goNorthCount++;
      // In the first turn of goingToMuseum, it could be the case that
      // Neton, Ovan, and the PC are all in Hallway 6 (with the slowing
      // field between them). This is a unique case; treat it separately.
      if (goNorthCount == 1 && me.isIn(hallway6)) {
        neton.yBaseValue = 1;
        ovan.yBaseValue = 1;
        bathDoor.makeOpen(true);
        youngGuard.moveInto(hallway5);
        "On the other side of the room, Neton and Ovan glare 
            at you through the slowing field.
            Then Neton cries, <.q>Get him!<./q> 
          <p>With that, Neton and Ovan 
            extend their <<neton.weapon.pluralName>> 
            as far as they can in front of them,
            then run headlong into the slowing field. 
            The slowing field seems to freeze them 
            in their tracks, but not before Neton<./s>s 
            <<neton.weapon.name>> <<neton.weapon.netonHitsYouPhrase>>. 
          <<neton.weapon.deathParagraph(nil, nil)>>";
        neton.killPcAmusingly;
        endGame(ftDeath);
      }
    }
  }
*/
;


// -------------------------------------------------------------------
// NPCS: PRISONERS: BEHAVIOR: Greeting you
// -------------------------------------------------------------------

prisonerBehavior: object
  letPrisonersGreetPc() {
    local unusualClothing = nil;
    local temptingFoodList = nil;
    local containersToBeOpened = [];
    local noteworthyPossessions = nil;
    //local nonWeaponsListed = nil;
    //local pcPossessions = [];
    //local tempList = [];
    //local possessionsNamed = [nil, nil, nil, nil];
    /*
    Bogus variables that will have to be replaced:
    noteworthyPossessions
    */
    
    // Preliminary calculations
    // Clothing calculations
    for (local a = 1; a <= unusualClothingList.length; a++) {
      if (unusualClothingList[a].isWornBy(gPlayerChar)) {
        unusualClothing = unusualClothingList[a];
        break;
      }
    }
    //if      (pearls      .isWornBy(gPlayerChar)) unusualClothing = pearls      ;
    //else if (silkCape    .isWornBy(gPlayerChar)) unusualClothing = silkCape    ;
    //else if (coat        .isWornBy(gPlayerChar)) unusualClothing = coat        ;
    //else if (greenJacket .isWornBy(gPlayerChar)) unusualClothing = greenJacket ;
    //else if (yellowJacket.isWornBy(gPlayerChar)) unusualClothing = yellowJacket;
    //else if (beigeJacket .isWornBy(gPlayerChar)) unusualClothing = beigeJacket ;
    
    
    // Do temptingFoodList calculations. Make sure temptingFoodList
    // always equals either nil or else a list with more than one element.
    gPlayerChar.calculatePossessions;
    temptingFoodList = getTemptingFoodList;
    containersToBeOpened =
      getContainersToBeOpened(temptingFoodList);
    
    // "Holy shit! You actually survived!"
    // Diane is always the speaker here. Diane speaks about you 
    // in the third person here, unless she comes out into the hallway 
    // to greet you; then it's second person.
    setSpeaker('Diane');
    "<.q>Holy shit!<./q> says Diane. 
      <.q><<gPlayerChar.isIn(cell) ? 'He' : 'You'>> 
      actually survived!<./q> ";
    
    // "Look at all that stuff he's carrying!"
    // Vicki is always the speaker here.
    
    // "possessionsCommentary" carries out Vicki's entire comment
    // on what the PC is carrying. Depending on whether there is 
    // further stuff to comment on (unusual clothing, tempting food),
    // it will modify slightly what it says at the end. 
    // Also, it will return a non-nil value if it finds possessions
    // to comment on, but will return nil otherwise.
    
    noteworthyPossessions =
      possessionsCommentary(!unusualClothing && !temptingFoodList);
//    switch (possessionsCommentary) {
//      case FridgePart:
//        // "...How can you carry all that?"
//        break;
//      case ArtifactGun:
//        // "...Be careful with those!"
//        break;
//      //default:
//      //  break;
//    }
    
//    if (noteworthyPossessions) {
//      setSpeaker('Vicki');
//      "<p><.q>Yeah, and look at all that stuff he<./s>s carrying!<./q> 
//        <<speaker>> cries. <.q>Seven firearms, three bowls of soup, 
//        and&mdash;what are those, refrigerator drawers?<./q> ";
//      // If the PC is either carrying food or wearing anything unusual,
//      // then let Vicki end with a throwaway question that will go
//      // unanswered.
//      if (unusualClothing || temptingFoodList) {
//        "Then she looks at you quizzically. 
//          <.q>How can you carry all that?<./q> ";
//      }
//      // In the "carrying a lot, but wearing nothing special and
//      // having no food" scenario, (1) avoid having Vicki address
//      // the PC in the second person, and (2) let Diane briefly respond.
//      else {
//        "Then her glance turns quizzical. 
//          <.q>How can he carry all that?<./q> ";
//        setSpeaker('Diane');
//        "<p><.q>A talented man indeed, our Gary,<./q> says Diane
//          wryly. ";
//        // My wife strongly disapproved of this "breaking the fourth wall"
//        // line; maybe she's right.
//        //"<p>Diane shrugs. <.q>Well, he plays a lot of computer games,
//        //  right? I think it<./s>s an acquired skill.<./q> ";
//      }
//    }
    
    // weird clothing comments
    if (unusualClothing) {
      if (speaker == 'Diane') {
        setSpeaker('Vicki');
        "<p><.q>I knew you<./s>d make it, Gary!<./q> Vicki cries.
          <.q>And looking better than ever, too!<./q> ";
      }
      // We can now safely assume that the speaker is Diane.
      setSpeaker('Diane');
      "<p>";
      if (unusualClothing == pearls)
        "<.q>Personally, I<./s>d like to know what<./s>s up with
          the pearl necklace,<./q> says Diane. <.q>Has <<me.firstName>>
          been a cross-dresser all this time? Maybe he only just now
          found the right accessory to go with his outfit.<./q> ";
      else if (unusualClothing == coat)
        "<.q>Personally, I think the parka is a nice touch,<./q>
          says Diane. <.q>Only I<./s>m surprised he didn<./s>t
          save it for winter. He must be burning up.<./q> ";
      else if (unusualClothing == silkCape)
        "<.q>Personally, I<./s>d like to know what<./s>s up
          with the silk cape,<./q> says Diane. <.q>Now that
          he<./s>s rescuing us, he has to dress up 
          like a superhero?<./q> ";
      else { // jacket
        "<.q>You know, I think there<./s>s something odd
          about that <<unusualClothing.name>>,<./q> says Diane.
          Then, her eyes widening, she adds, <.q>Hold on.
          That used to belong to <<unusualClothing.originalOwner.theName>>,
          didn<./s>t it?<./q> ";
      }
      // Final comments: in the "wearing unusual clothing, but not
      // carrying any edible food" scenario," let Vicki give one final
      // comment.
      if (!temptingFoodList) {
        setSpeaker('Vicki');
        if (unusualClothing == pearls)
          "<p>Vicki shakes her head, and you<./s>re not sure
            if she<./s>s shaking her head at your necklace or 
            at Diane<./s>s remarks. ";
        else if (unusualClothing == coat)
          "<p><.q>Maybe the aliens had him running through the 
            glacier maze,<./q> says Vicki. <.q>I wouldn<./s>t 
            put it past them.<./q> ";
        else if (unusualClothing == silkCape)
          "<p>Vicki, unable to suppress a chuckle, shakes
            her head. ";
        else { // jacket
          "<p><.q>It certainly is the same 
            color,<./q> says Vicki. ";
        }
      }
    }
    
    // Before doing the whole "get food" thing, check on one other scenario.
    // If the PC (1) is not carrying much, (2) is not wearing anything 
    // special, and (3) has no tempting food, then let Vicki say one
    // last thing, rather than let the exchange end with Diane's
    // "holy shit" comment.
    if (!noteworthyPossessions && !unusualClothing && !temptingFoodList) {
      setSpeaker('Vicki');
      "<p><.q>Gary, you returned!<./q> says Vicki.
        <.q>I knew you<./s>d rescue us if you could!<./q> ";
    }
    // Look for any stray food. If it exists, get it. If it doesn't...
    if (!letPrisonersGetStrayFood(speaker == 'Vicki' ? 'Diane' : 'Vicki', true)) {
      // ...then look for any food to be stolen from the PC.
      if (temptingFoodList) {
        // We do not know who will be speaking next, but we know
        // it should be different from the person who last spoke.
        switchSpeaker;
        // Let the prisoners steal the food; deal with the consequences;
        // describe the theft.
        doFoodTheft(
           temptingFoodList // temptingFoodList
          ,containersToBeOpened // containersToBeOpened
          ,true // nowRescuing
          ,(!noteworthyPossessions && !unusualClothing) // preambleRequired
        );
      }
    }
  }
  getTemptingFoodList {
    local temptingFoodList = gPlayerChar.possessionsMatching(Satiating, []);
    temptingFoodList = temptingFoodList.subset({x: x.tastiness >= 1});
    // Never return a list of zero length. Return nil instead.
    if (!temptingFoodList.length)
      return nil;
    return temptingFoodList;
  }
  getContainersToBeOpened(temptingFoodList) {
    local containersToBeOpened = [];
    if (temptingFoodList && temptingFoodList.length && 
        temptingFoodList[1].location.ofKind(Openable) &&
        !temptingFoodList[1].location.isOpen) {
      containersToBeOpened = 
        containersToBeOpened.appendUnique([temptingFoodList[1].location]);
    }
    if (temptingFoodList && temptingFoodList.length && temptingFoodList.length > 1 &&
        temptingFoodList[2].location.ofKind(Openable) &&
        !temptingFoodList[2].location.isOpen) {
      containersToBeOpened = 
        containersToBeOpened.appendUnique([temptingFoodList[2].location]);
    }
    //local k = inputManager.getKey(nil, nil);
    //if (k.toLower == 'q')
    //  { k=0;k=k/k; }
    return containersToBeOpened;
  }
  unusualClothingList = [
     pearls
    ,silkCape
    ,coat
    ,greenJacket
    ,yellowJacket
    ,beigeJacket
  ]
  possessionsCommentary(furtherCommentary) {
    local nonWeaponsListed = nil;
    local explosiveListed = nil;
    local daggerListed = nil;
    //local pcPossessions = [];
    local tempList = [];
    local tempList2 = [];
    //local tempList3 = [];
    local soupList = [];
    local foodList = [];
    local beverageList = [];
    local weaponsNamed = [nil, nil, nil];
    local weaponsCounted = 0;
    
    possessionsNamed = [nil, nil, nil, nil];
    possessionsCounted = [0, 0, 0, 0];
    
    // Possession calculations
    gPlayerChar.calculatePossessions;
    
    // If the PC is holding at least 5 things in his hands, then make 
    // every effort to comment on the amount of stuff he is carrying.
    if (gPlayerChar.possessionsMatching(Thing, beingHeld).length >= 5) {
      // End-of-list stuff: Fridge parts
      tempList = gPlayerChar.possessionsMatching(FridgeDrawer, []);
      tempList2 = gPlayerChar.possessionsMatching(FridgeShelf, []);
      if (tempList.length || tempList2.length) {
        if (tempList.length >= 2) {
          possessionsCounted[4] = tempList.length;
          possessionsNamed[4] = 'and&mdash;what are those, refrigerator drawers?';
        }
        else if (tempList2.length >= 2) {
          possessionsCounted[4] = tempList.length;
          possessionsNamed[4] = 'and&mdash;what are those, refrigerator shelves?';
        }
        else if (tempList.length) {
          possessionsCounted[4] = tempList.length;
          possessionsNamed[4] = 'and&mdash;what is that, a refrigerator drawer?';
        }
        else if (tempList2.length) {
          possessionsCounted[4] = tempList.length;
          possessionsNamed[4] = 'and&mdash;what is that, a refrigerator shelf?';
        }
        nonWeaponsListed = true;
      }
      // End-of-list stuff: Explosive
      if (explosive.isBeingHeldBy(gPlayerChar) && !possessionsNamed[4]) {
        possessionsCounted[4] = 1;
        possessionsNamed[4] = 'and&mdash;what is that, an explosive?';
        explosiveListed = true;
      }
      // End-of-list stuff: Dagger
      if (dagger.isBeingHeldBy(gPlayerChar) && !possessionsNamed[4]) {
        possessionsCounted[4] = 1;
        possessionsNamed[4] = 'and&mdash;what is that, a dagger?';
        daggerListed = true;
      }
      
      // Check for guns.
      tempList = gPlayerChar.possessionsMatching(Gun, assumingOneOrMoreHeld);
      if (tempList.length) {
        possessionsCounted[1] = tempList.length;
        if (tempList.length == 1)
          possessionsNamed[1] = 'a ' + (tempList[1].bulk > 50 ? 'huge ' : '') + 'gun';
        else if (tempList.length == 2)
          possessionsNamed[1] = '';
      }
      
      // Check for soup, food, and beverages.
      soupList = gPlayerChar.possessionsMatching(FlowingInBowl, assumingOneOrMoreHeld);
      foodList = gPlayerChar.possessionsMatching(Satiating, assumingOneOrMoreHeld);
      foodList = foodList.subset({x: !x.ofKind(FlowingInBowl)});
      beverageList = gPlayerChar.possessionsMatching(Quenching, assumingOneOrMoreHeld);
      if (soupList.length >= 2 && possessionSlot) {
        possessionsCounted[possessionSlot] = soupList.length;
        possessionsNamed[possessionSlot] = spellInt(soupList.length) + ' bowls of soup';
        nonWeaponsListed = true;
      }
      if (foodList.length >= 6 && possessionSlot) {
        possessionsCounted[possessionSlot] = foodList.length;
        possessionsNamed[possessionSlot] = 'about ' 
          + spellInt(foodList.length) + ' food items';
        nonWeaponsListed = true;
      }
      if (beverageList.length >= 3 && possessionSlot) {
        possessionsCounted[possessionSlot] = beverageList.length;
        possessionsNamed[possessionSlot] = spellInt(beverageList.length) + ' beverages';
        nonWeaponsListed = true;
      }
      if (foodList.length >= 3 && foodList.length <= 5 && possessionSlot) {
        possessionsCounted[possessionSlot] = foodList.length;
        possessionsNamed[possessionSlot] = (foodList.length >= 4 ? 'about ' : '')
          + spellInt(foodList.length) + ' food items';
        nonWeaponsListed = true;
      }
      if (soupList.length == 1 && possessionSlot) {
        possessionsCounted[possessionSlot] = soupList.length;
        possessionsNamed[possessionSlot] = 'a bowl of ' + soupList[1].foodName;
        nonWeaponsListed = true;
      }
      if (beverageList.length >= 1 && beverageList.length <= 2 && possessionSlot) {
        possessionsCounted[possessionSlot] = beverageList.length;
        if (beverageList.length >= 2)
          possessionsNamed[possessionSlot] = spellInt(beverageList.length) + ' beverages';
        else
          possessionsNamed[possessionSlot] = 'a ' + beverageList[1].containerNoun
            + ' of ' + beverageList[1].contentsName;
        nonWeaponsListed = true;
      }
      if (foodList.length >= 1 && foodList.length <= 2 && possessionSlot) {
        possessionsCounted[possessionSlot] = foodList.length;
        if (foodList.length >= 2)
          // My wife suggests changing 'a couple of food items' to 'some food'.
          possessionsNamed[possessionSlot] = 'a couple of food items'; 
        else
          possessionsNamed[possessionSlot] = foodList[1].aFoodName;
        nonWeaponsListed = true;
      }
      
      // Check for unusual clothes (but only if none of the unusual clothes
      // are being worn)
      tempList = gPlayerChar.possessionsMatching(Wearable, [assumingNoneIsWorn, assumingOneOrMoreHeld]);
      if (tempList.length && possessionSlot) {
        //local k=0;k=k/k;
        possessionsCounted[possessionSlot] = tempList.length;
        if (tempList.length >= 3)
          possessionsNamed[possessionSlot] = 'about ' + spellInt(tempList.length)
            + ' pieces of clothing';
        else if (tempList.length == 2)
          possessionsNamed[possessionSlot] = 'a couple pieces of clothing';
        else
          possessionsNamed[possessionSlot] = tempList[1].aName;
        nonWeaponsListed = true;
      }
      
      // Check for explosive.
      if (explosive.isBeingHeldBy(gPlayerChar) && possessionSlot 
          && !explosiveListed) {
        possessionsCounted[possessionSlot] = 1;
        possessionsNamed[possessionSlot] = 'some kind of explosive';
        explosiveListed = true;
      }
      
      // Check for dagger. If the explosive has been mentioned, don't
      // mention the dagger, because we'd like to minimize the chances
      // of the list consisting of nothing but weapons.
      if (dagger.isBeingHeldBy(gPlayerChar) && possessionSlot 
          && !daggerListed && !explosiveListed) {
        possessionsCounted[possessionSlot] = 1;
        possessionsNamed[possessionSlot] = 'a dagger';
        daggerListed = true;
      }
      
      // Check for various containers that once contained food or liquid.
      tempList2 = [
         // From Vicki's point of view, a flask doesn't look all that different
         // from a bottle.
         ['bottle','bottles',[ExFlowingOpenableBottle,ExFlowingFlask]]
        ,['bowl'  ,'bowls'  ,ExFlowingBowl]
        ,['bag'   ,'bags'   ,ExFlowingOpenableBag]
        ,['glass' ,'glasses',ExFlowingGlass]
      ];
      if (possessionSlot) {
        for (local a = 1; a <= tempList2.length; a++) {
          tempList = gPlayerChar.possessionsMatching(tempList2[a][3], 
                       assumingOneOrMoreHeld);
          if (tempList.length && possessionSlot) {
            possessionsCounted[possessionSlot] = tempList.length;
            if (tempList.length >= 3)
              possessionsNamed[possessionSlot] = spellInt(tempList.length) + ' '
                + tempList2[a][2];
            else if (tempList.length == 2)
              possessionsNamed[possessionSlot] = 'a couple of ' 
                + tempList2[a][2];
            else
              possessionsNamed[possessionSlot] = 'a ' + tempList2[a][1];
            nonWeaponsListed = true;
          }
        }
      }
      
      // Check for unused wrappers.
      tempList = gPlayerChar.possessionsMatching(Wrapper, 
        [assumingOneOrMoreHeld, notBeingWrapped]);
      if (tempList.length && possessionSlot) {
        possessionsCounted[possessionSlot] = tempList.length;
        if (tempList.length >= 3)
          possessionsNamed[possessionSlot] = 'about ' + spellInt(tempList.length)
            + ' wrappers';
        else if (tempList.length == 2)
          possessionsNamed[possessionSlot] = 'a couple of wrappers';
        else
          possessionsNamed[possessionSlot] = 'a wrapper';
        nonWeaponsListed = true;
      }
      
      // Get rid of the item in slot 3, if applicable. Add "and all
      // the rest," if applicable.
      if (possessionsNamed[4]) {
        possessionsCounted[3] = 0;
        possessionsNamed[3] = nil;
      }
      else {
        if (possessionsCounted[1] + possessionsCounted[2] + possessionsCounted[3]
            < gPlayerChar.possessions.length) {
          possessionsNamed[4] = 'and all the rest&mdash;';
        }
      }
      
      // Now decide whether to remark upon "all that stuff
      // he's carrying."
      if (possessionsNamed[1] && (possessionsNamed[2] || possessionsNamed[4])
          && nonWeaponsListed) {
        setSpeaker('Vicki');
        "<p>Eyeing you with amazement, Vicki cries, <.q>Yeah, and look at
          all that stuff he<./s>s carrying! \^";
        "<<possessionsNamed[1]>>";
        if (possessionsNamed[2])
          ", <<possessionsNamed[2]>>";
        if (possessionsNamed[3])
          ", <<possessionsNamed[3]>>";
        if (possessionsNamed[4])
          ", <<possessionsNamed[4]>>";
        else
          "&mdash;";
        "<./q> Then, quizzically, she says";
        if (!furtherCommentary) {
          " to you, <.q>How can you carry all that?<./q>";
        }
        else {
          ", <.q>How can he carry all that?<./q> ";
          setSpeaker('Diane');
          "<p><.q>A talented man indeed, our Gary,<./q> says Diane
            wryly. ";
          // My wife strongly disapproved of this "breaking the fourth wall"
          // line; maybe she's right.
          //"<p>Diane shrugs. <.q>Well, he plays a lot of computer games,
          //  right? I think it<./s>s an acquired skill.<./q> ";
        }
        return FridgePart;
      }
    }
    if (gPlayerChar.possessions.indexOf(dagger) ||
             gPlayerChar.possessionsMatching(Gun, []).length || 
             gPlayerChar.possessions.indexOf(explosive)) {
      if (gPlayerChar.possessions.indexOf(dagger))
        weaponsNamed[1] = 'a huge dagger';
      if (gPlayerChar.possessionsMatching(Gun, []).length >= 3)
        weaponsNamed[2] = 'about '
          + spellInt(gPlayerChar.possessionsMatching(Gun, []).length)
          + ' different guns';
      else if (gPlayerChar.possessionsMatching(Gun, []).length == 2)
        weaponsNamed[2] = spellInt(gPlayerChar.possessionsMatching(Gun, []).length)
          + ' different guns';
      else if (gPlayerChar.possessionsMatching(Gun, []).length == 1)
        weaponsNamed[2] = 'a dangerous-looking gun';
      if (gPlayerChar.possessions.indexOf(explosive))
        weaponsNamed[3] = 'what is that, an explosive?';
      
      setSpeaker('Vicki');
      "<p>Eyeing you with amazement, Vicki cries, <.q>Yeah, and look at
        what he<./s>s carrying";
      if (weaponsNamed[3])
        "&mdash;";
      else
        "! \^";
      if (weaponsNamed[1]) {
        "<<weaponsNamed[1]>>";
        weaponsCounted++;
      }
      if (weaponsNamed[2]) {
        if (weaponsNamed[1] && weaponsNamed[3])
          ", ";
        else if (weaponsNamed[1])
          ", and ";
        "<<weaponsNamed[2]>>";
        weaponsCounted = weaponsCounted + 
          gPlayerChar.possessionsMatching(Gun, []).length;
      }
      if (weaponsNamed[3]) {
        if (weaponsNamed[1] || weaponsNamed[2])
          ", and&mdash;";
        "<<weaponsNamed[3]>>";
        weaponsCounted++;
      }
      else {
        "!";
      }
      if (!furtherCommentary) {
        "<./q> Then, to you, she adds, <.q>Please be careful with
          <<weaponsCounted >= 2 ? 'those' : 'that'>>.<./q> ";
      }
      else {
        "<./q> Then she adds, <.q>I just hope he<./s>s careful with
          <<weaponsCounted >= 2 ? 'those' : 'that'>>.<./q> ";
        setSpeaker('Diane');
        "<p>Diane, for her part, says, <.q>This is good news.
          To fight against Neton and his brainless minions,
          we need all the weapons we can get.<./q> ";
      }
      return Gun;
    }
    return nil;
  }
//    if (noteworthyPossessions) {
//      setSpeaker('Vicki');
//      "<p><.q>Yeah, and look at all that stuff he<./s>s carrying!<./q> 
//        <<speaker>> cries. <.q>Seven firearms, three bowls of soup, 
//        and&mdash;what are those, refrigerator drawers?<./q> ";
//      // If the PC is either carrying food or wearing anything unusual,
//      // then let Vicki end with a throwaway question that will go
//      // unanswered.
//      if (unusualClothing || temptingFoodList) {
//        "Then she looks at you quizzically. 
//          <.q>How can you carry all that?<./q> ";
//      }
//      // In the "carrying a lot, but wearing nothing special and
//      // having no food" scenario, (1) avoid having Vicki address
//      // the PC in the second person, and (2) let Diane briefly respond.
//      else {
//        "Then her glance turns quizzical. 
//          <.q>How can he carry all that?<./q> ";
//        setSpeaker('Diane');
//        "<p><.q>A talented man indeed, our Gary,<./q> says Diane
//          wryly. ";
//        // My wife strongly disapproved of this "breaking the fourth wall"
//        // line; maybe she's right.
//        //"<p>Diane shrugs. <.q>Well, he plays a lot of computer games,
//        //  right? I think it<./s>s an acquired skill.<./q> ";
//      }
//    }
  possessionsNamed = [nil, nil, nil, nil]
  possessionSlot {
    if (!possessionsNamed[1]) return 1;
    if (!possessionsNamed[2]) return 2;
    if (!possessionsNamed[3]) return 3;
    return 0;
  }
  possessionsCounted = [0, 0, 0, 0]
  addToPossessionsCounted(num) {
    if (!possessionsNamed[3] || !possessionsNamed[4])
      possessionsCounted += num;
  }
  speaker = 'Diane'
  listener = 'Vicki'
  speakerObj {
    if (speaker == 'Diane')
      return diane;
    else
      return vicki;
  }
  listenerObj {
    if (listener == 'Diane')
      return diane;
    else
      return vicki;
  }
  setSpeaker(sp) {
    if (sp == 'Diane') {
      speaker = 'Diane';
      listener = 'Vicki';
    }
    else {
      speaker = 'Vicki';
      listener = 'Diane';
    }
  }
  switchSpeaker {
    if (speaker == 'Diane') {
      speaker = 'Vicki';
      listener = 'Diane';
    }
    else {
      speaker = 'Diane';
      listener = 'Vicki';
    }
  }
;  

enum assumingOneOrMoreHeld;
enum assumingNoneIsWorn;
enum beingWorn;
enum beingHeld;
enum notBeingWrapped;

modify Thing
  isBeingHeldBy(actor) {
    if (isHeldBy(actor))
      return true;
    if (location && location.ofKind(FridgeShelf) && location.location == actor)
      return true;
    return nil;
  }
;

modify Actor
  calculatePossessions {
    // Return all things in the actor (whether directly or indirectly),
    // but exclude components, etc., such as body parts. Also exclude
    // Gary's shirt and pants, which go without saying.
    _possessions = 
      scopeList.subset({x: x.isIn(self) && !x.ofKind(NonPortable)
        && !x.ofKind(MyClothing)});
  }
  possessions() {
    if (_possessions) return _possessions;
    calculatePossessions;
    return _possessions;
  }
  _possessions = nil
  possessionsMatching(classList, conditionsList) {
    local matchingList = [];
    if (dataType(classList) != TypeList)
      classList = [classList];
    if (dataType(conditionsList) != TypeList)
      conditionsList = [conditionsList];
    if (classList.length == 0)
      return [];
    // For each element in the classList, add all the PC's possessions
    // that belong to that specified class. Make sure this does not
    // result in any duplicates in the list (hence appendUnique).
    for (local a = 1; a <= classList.length; a++) {
      matchingList = matchingList.appendUnique(possessions.subset(
        {x: x.ofKind(classList[a])}));
    }
    //if (matchingList.length == 0)
    //  return matchingList;
    
    if (conditionsList.indexOf(assumingNoneIsWorn) &&
        matchingList.subset({x: x.ofKind(Wearable) && x.isWorn}).length)
      return [];
    if (conditionsList.indexOf(assumingOneOrMoreHeld) &&
        matchingList.subset({x: x.isBeingHeldBy(self)}).length == 0)
      return [];
    if (conditionsList.indexOf(beingWorn))
      matchingList = matchingList.subset({x: x.ofKind(Wearable) && x.isWorn});
    if (conditionsList.indexOf(beingHeld))
      matchingList = matchingList.subset({x: x.isBeingHeldBy(self)});
    if (conditionsList.indexOf(notBeingWrapped))
      matchingList = matchingList.subset({x: x.ofKind(Wrapper) && !x.isWrapped});
    return matchingList;
  }
;

//prisonerBehavior: object
//  letPrisonersGreetPc() {
//    local unusualClothing = nil;
//    local temptingFoodList = nil;
//    local containersToBeOpened = [];
//    local noteworthyPossessions = nil;
//    //local nonWeaponsListed = nil;
//    //local pcPossessions = [];
//    //local tempList = [];
//    //local possessionsNamed = [nil, nil, nil, nil];
//    /*
//    Bogus variables that will have to be replaced:
//    noteworthyPossessions
//    */
//    
//    // Preliminary calculations
//    // Clothing calculations
//    if      (silkCape    .isWornBy(gPlayerChar)) unusualClothing = silkCape    ;
//    else if (coat        .isWornBy(gPlayerChar)) unusualClothing = coat        ;
//    else if (greenJacket .isWornBy(gPlayerChar)) unusualClothing = greenJacket ;
//    else if (yellowJacket.isWornBy(gPlayerChar)) unusualClothing = yellowJacket;
//    else if (beigeJacket .isWornBy(gPlayerChar)) unusualClothing = beigeJacket ;
//    // Do temptingFoodList calculations. Make sure temptingFoodList
//    // always equals either nil or else a list with more than one element.
//    gPlayerChar.calculatePossessions;
//    temptingFoodList = gPlayerChar.possessionsMatching(Satiating, []);
//    temptingFoodList = temptingFoodList.subset({x: x.tastiness >= 1});
//    if (!temptingFoodList.length)
//      temptingFoodList = nil;
//    if (temptingFoodList && temptingFoodList.length && 
//        temptingFoodList[1].location.ofKind(Openable) &&
//        !temptingFoodList[1].location.isOpen)
//      containersToBeOpened.append(temptingFoodList[1].location);
//    if (temptingFoodList && temptingFoodList.length && temptingFoodList.length > 1 &&
//        temptingFoodList[2].location.ofKind(Openable) &&
//        !temptingFoodList[2].location.isOpen)
//      containersToBeOpened.append(temptingFoodList[2].location);
//    
//    // "Holy shit! You actually survived!"
//    // Diane is always the speaker here. Diane speaks about you 
//    // in the third person here, unless she comes out into the hallway 
//    // to greet you; then it's second person.
//    setSpeaker('Diane');
//    "<.q>Holy shit!<./q> says Diane. 
//      <.q><<gPlayerChar.isIn(cell) ? 'He' : 'You'>> 
//      actually survived!<./q> ";
//    
//    // "Look at all that stuff he's carrying!"
//    // Vicki is always the speaker here.
//    
//    // "possessionsCommentary" carries out Vicki's entire comment
//    // on what the PC is carrying. Depending on whether there is 
//    // further stuff to comment on (unusual clothing, tempting food),
//    // it will modify slightly what it says at the end. 
//    // Also, it will return a non-nil value if it finds possessions
//    // to comment on, but will return nil otherwise.
//    
//    noteworthyPossessions =
//      possessionsCommentary(!unusualClothing && !temptingFoodList);
////    switch (possessionsCommentary) {
////      case FridgePart:
////        // "...How can you carry all that?"
////        break;
////      case Gun:
////        // "...Be careful with those!"
////        break;
////      //default:
////      //  break;
////    }
//    
////    if (noteworthyPossessions) {
////      setSpeaker('Vicki');
////      "<p><.q>Yeah, and look at all that stuff he<./s>s carrying!<./q> 
////        <<speaker>> cries. <.q>Seven firearms, three bowls of soup, 
////        and&mdash;what are those, refrigerator drawers?<./q> ";
////      // If the PC is either carrying food or wearing anything unusual,
////      // then let Vicki end with a throwaway question that will go
////      // unanswered.
////      if (unusualClothing || temptingFoodList) {
////        "Then she looks at you quizzically. 
////          <.q>How can you carry all that?<./q> ";
////      }
////      // In the "carrying a lot, but wearing nothing special and
////      // having no food" scenario, (1) avoid having Vicki address
////      // the PC in the second person, and (2) let Diane briefly respond.
////      else {
////        "Then her glance turns quizzical. 
////          <.q>How can he carry all that?<./q> ";
////        setSpeaker('Diane');
////        "<p><.q>A talented man indeed, our Gary,<./q> says Diane
////          wryly. ";
////        // My wife strongly disapproved of this "breaking the fourth wall"
////        // line; maybe she's right.
////        //"<p>Diane shrugs. <.q>Well, he plays a lot of computer games,
////        //  right? I think it<./s>s an acquired skill.<./q> ";
////      }
////    }
//    
//    // weird clothing comments
//    if (unusualClothing) {
//      if (speaker == 'Diane') {
//        setSpeaker('Vicki');
//        "<p><.q>I knew you<./s>d make it, Gary!<./q> Vicki cries.
//          <.q>And looking better than ever, too!<./q> ";
//      }
//      // We can now safely assume that the speaker is Diane.
//      setSpeaker('Diane');
//      "<p>";
//      if (unusualClothing == coat)
//        "<.q>Personally, I think the parka is a nice touch,<./q>
//          says Diane. <.q>Only, I<./s>m surprised he didn<./s>t
//          save it for winter. He must be burning up.<./q> ";
//      else if (unusualClothing == silkCape)
//        "<.q>Personally, I<./s>d like to know what<./s>s up
//          with the silk cape,<./q> says Diane. <.q>Now that
//          he<./s>s rescuing us, he has to dress up 
//          like a superhero?<./q> ";
//      else { // jacket
//        "<.q>You know, I think there<./s>s something odd
//          about that <<unusualClothing.name>>,<./q> says Diane.
//          Then, her eyes widening, she adds, <.q>Hold on.
//          That used to belong to <<unusualClothing.originalOwner.theName>>,
//          didn<./s>t it?<./q> ";
//      }
//      // Final comments: in the "wearing unusual clothing, but not
//      // carrying any edible food" scenario," let Vicki give one final
//      // comment.
//      if (!temptingFoodList) {
//        setSpeaker('Vicki');
//        if (unusualClothing == coat)
//          "<p><.q>Maybe the aliens had him running through the 
//            glacier maze,<./q> says Vicki. <.q>I wouldn<./s>t 
//            put it past them.<./q> ";
//        else if (unusualClothing == silkCape)
//          "<p>Vicki, unable to suppress a chuckle, shakes
//            her head. ";
//        else { // jacket
//          "<p><.q>It certainly does appear to be the same 
//            color,<./q> says Vicki. ";
//        }
//      }
//    }
//    
//    // Before doing the whole food thing, check on one other scenario.
//    // If the PC (1) is not carrying much, (2) is not wearing anything 
//    // special, and (3) has no tempting food, then let Vicki say one
//    // last thing, rather than let the exchange end with Diane's
//    // "holy shit" comment.
//    if (!noteworthyPossessions && !unusualClothing && !temptingFoodList) {
//      setSpeaker('Vicki');
//      "<p><.q>It<./s>s great to see you, Gary!<./q> says Vicki.
//        <.q>Thank you so much for coming!<./q> ";
//    }
//    
//    // If the PC is carrying any tempting food items, let Vicki and Diane 
//    // respond accordingly.
//    if (temptingFoodList) {
//      // We do not know who will be speaking next, but we know
//      // it should be different from the person who last spoke.
//      switchSpeaker;
//      // The wording of this next paragraph will differ depending on
//      // whether anything has been said since Diane's "holy shit" comment.
//      if (!noteworthyPossessions && !unusualClothing)
//        "<p><.q>It<./s>s great to see you, Gary!<./q> <<speaker>> cries.
//          Then, eyeing your possessions, she says, <.q>Hey, 
//          wait a minute, <<listener>>. This man has food! ";
//      else
//        "<p><<speaker>> says, <.q>Wait a minute, <<listener>>.
//          Can<./s>t you see this man has food? ";
//      "Real food! I mean, he has 
//        <<temptingFoodList[1].aFoodName>>!<./q> ";
//      speakerObj.desiredFood = temptingFoodList[1];
//      // First, for this next part, switch speaker.
//      switchSpeaker;
//      // This next paragraph varies depending on two things:
//      // whether Vicki or Diane is the one who speaks next,
//      // and whether there is more than one tempting food item.
//      if (temptingFoodList.length <= 1) {
//        "<p><.q>Whoa, you<./s>re right,<./q> says <<speaker>>.
//          <.q>That <<temptingFoodList[1].foodName>> looks awfully
//          good.";
//        speakerObj.desiredFood = temptingFoodList[1];
//      }
//      else {
//        "<p><.q>Whoa, you<./s>re right,<./q> says <<speaker>>.
//          <.q>But never mind <<temptingFoodList[1].theFoodName>>.
//          I<./s>m looking at <<temptingFoodList[2].theFoodName>>.
//          Mmm, <<temptingFoodList[2].foodName>>.";
//        speakerObj.desiredFood = temptingFoodList[2];
//      }
//      // We take great pains to make sure Vicki is the last 
//      // to speak here. The next part of the exchange involves 
//      // stealing the food, and Diane has to be the one 
//      // to do that.
//      if (speaker == 'Vicki')
//        " Gary, could we please have&mdash;<./q> ";
//      else
//        "<./q>
//          <p>Vicki says, <.q>Gary, could we please 
//          have&mdash;<./q> ";
//      // The great food robbery.
//      "<p>But Diane can<./s>t wait. Before you know what<./s>s
//        happening, she comes up to you";
//      // A minor point: If any of the food items are in 
//      // containers, we'll have to make sure Diane opens them.
//      if (containersToBeOpened.length) {
//        for (local a = 1; a <= containersToBeOpened.length; a++) {
//          containersToBeOpened[a].makeOpen(true);
//        }
//        ", opens <<containersToBeOpened[1].theName>>";
//        if (containersToBeOpened.length > 1)
//          " and <<containersToBeOpened[2].name>>";
//        ",";
//      }
//      // We now return to our regularly scheduled food robbery.
//      " and seizes <<temptingFoodList[1].theFoodName>>";
//      if (temptingFoodList.length > 1)
//        " and <<temptingFoodList[2].foodName>>";
//      ". ";
//      // Vicki comes last on purpose. If Vicki and Diane both want,
//      // e.g., the same bowl of soup, then Vicki will end up
//      // holding the bowl.
//      if (diane.desiredFood)
//        diane.desiredFood.baseMoveInto(diane);
//      if (vicki.desiredFood)
//        vicki.desiredFood.baseMoveInto(vicki);
//      // The remaining text is largely different, depending
//      // on whether there is only one food item that must be shared,
//      // or whether there is more than one.
//      if (temptingFoodList.length <= 1) {
//        "Hungrily, she <<diane.desiredFood.beginsToDevourPhrase>>. 
//          <p><.q>Hold on there, Diane!<./q> Vicki shouts
//            with surprising ferocity.
//          <p>Diane, who had just opened her mouth for more of
//            <<diane.desiredFood.theFoodName>>, now pulls back
//            and says, <.q>Oh. Sorry.<./q> With that,
//            she gives the rest of <<diane.desiredFood.theFoodName>>
//            to Vicki, who 
//            <<vicki.desiredFood.finishesDevouringPhrase>>.
//          <p>Turning to you, Diane says, <.q>Sorry, but you
//            don<./s>t know what kind of food cravings we<./s>ve had.
//            We<./s>ve been here a lot longer than you.<./q>
//          <p>Done eating now, Vicki says with some embarassment,
//            <.q>Uh, yeah. We don<./s>t normally steal, but this
//            was an emergency.<./q> ";
//      }
//      else {
//        "<.q>Here you go,<./q> she says to Vicki, handing her 
//            <<vicki.desiredFood.theFoodName>>.
//          <p>Vicki says to you, <.q>Sorry, but you don<./s>t know
//            what kind of food cravings we<./s>ve had. We<./s>ve
//            been here a lot longer than you.<./q>
//          <p>With that, Vicki hungrily 
//            <<vicki.desiredFood.devoursPhrase>>.
//            Diane, for her part, 
//            <<diane.desiredFood.scarfsPhrase>>. ";
//      }
////      // If we skip over the preconditions, the action phase
////      // of the Eat verb should do what we need for (1) getting
////      // rid of the food, and (2) carrying out any side effects
////      // such as empty soup bowls, etc., that remain afterwards.
////      temptingFoodList[1].actionDobjEat();
////      if (temptingFoodList.length > 1)
////        temptingFoodList[2].actionDobjEat();
//      if (temptingFoodList[1].ofKind(FlowingInContainer))
//        temptingFoodList[1].processConsumption;
//      else
//        temptingFoodList[1].eatingConsequences;
//      temptingFoodList[1].moveInto(nil);
//      if (temptingFoodList.length > 1) {
//        //temptingFoodList[2].actionDobjEat();
//        if (temptingFoodList[2].ofKind(FlowingInContainer))
//          temptingFoodList[2].processConsumption;
//        else
//          temptingFoodList[2].eatingConsequences;
//        temptingFoodList[2].moveInto(nil);
//      }
//    }
//  }
//  possessionsCommentary(furtherCommentary) {
//    local nonWeaponsListed = nil;
//    local explosiveListed = nil;
//    local daggerListed = nil;
//    //local pcPossessions = [];
//    local tempList = [];
//    local tempList2 = [];
//    //local tempList3 = [];
//    local soupList = [];
//    local foodList = [];
//    local beverageList = [];
//    local weaponsNamed = [nil, nil, nil];
//    local weaponsCounted = 0;
//    
//    possessionsNamed = [nil, nil, nil, nil];
//    possessionsCounted = [0, 0, 0, 0];
//    
//    // Possession calculations
//    gPlayerChar.calculatePossessions;
//    
//    // If the PC is holding at least 5 things in his hands, then make 
//    // every effort to comment on the amount of stuff he is carrying.
//    if (gPlayerChar.possessionsMatching(Thing, beingHeld).length >= 5) {
//      // End-of-list stuff: Fridge parts
//      tempList = gPlayerChar.possessionsMatching(FridgeDrawer, []);
//      tempList2 = gPlayerChar.possessionsMatching(FridgeShelf, []);
//      if (tempList.length || tempList2.length) {
//        if (tempList.length >= 2) {
//          possessionsCounted[4] = tempList.length;
//          possessionsNamed[4] = 'and&mdash;what are those, refrigerator drawers?';
//        }
//        else if (tempList2.length >= 2) {
//          possessionsCounted[4] = tempList.length;
//          possessionsNamed[4] = 'and&mdash;what are those, refrigerator shelves?';
//        }
//        else if (tempList.length) {
//          possessionsCounted[4] = tempList.length;
//          possessionsNamed[4] = 'and&mdash;what is that, a refrigerator drawer?';
//        }
//        else if (tempList2.length) {
//          possessionsCounted[4] = tempList.length;
//          possessionsNamed[4] = 'and&mdash;what is that, a refrigerator shelf?';
//        }
//        nonWeaponsListed = true;
//      }
//      // End-of-list stuff: Explosive
//      if (explosive.isBeingHeldBy(gPlayerChar) && !possessionsNamed[4]) {
//        possessionsCounted[4] = 1;
//        possessionsNamed[4] = 'and&mdash;what is that, an explosive?';
//        explosiveListed = true;
//      }
//      // End-of-list stuff: Dagger
//      if (dagger.isBeingHeldBy(gPlayerChar) && !possessionsNamed[4]) {
//        possessionsCounted[4] = 1;
//        possessionsNamed[4] = 'and&mdash;what is that, a dagger?';
//        daggerListed = true;
//      }
//      
//      // Check for guns.
//      tempList = gPlayerChar.possessionsMatching(Gun, assumingOneOrMoreHeld);
//      if (tempList.length) {
//        possessionsCounted[1] = tempList.length;
//        if (tempList.length == 1)
//          possessionsNamed[1] = 'a ' + (tempList[1].bulk > 50 ? 'huge ' : '') + 'gun';
//        else if (tempList.length == 2)
//          possessionsNamed[1] = '';
//      }
//      
//      // Check for soup, food, and beverages.
//      soupList = gPlayerChar.possessionsMatching(FlowingInBowl, assumingOneOrMoreHeld);
//      foodList = gPlayerChar.possessionsMatching(Satiating, assumingOneOrMoreHeld);
//      foodList = foodList.subset({x: !x.ofKind(FlowingInBowl)});
//      beverageList = gPlayerChar.possessionsMatching(Quenching, assumingOneOrMoreHeld);
//      if (soupList.length >= 2 && possessionSlot) {
//        possessionsCounted[possessionSlot] = soupList.length;
//        possessionsNamed[possessionSlot] = spellInt(soupList.length) + ' bowls of soup';
//        nonWeaponsListed = true;
//      }
//      if (foodList.length >= 6 && possessionSlot) {
//        possessionsCounted[possessionSlot] = foodList.length;
//        possessionsNamed[possessionSlot] = 'about ' 
//          + spellInt(foodList.length) + ' food items';
//        nonWeaponsListed = true;
//      }
//      if (beverageList.length >= 3 && possessionSlot) {
//        possessionsCounted[possessionSlot] = beverageList.length;
//        possessionsNamed[possessionSlot] = spellInt(beverageList.length) + ' beverages';
//        nonWeaponsListed = true;
//      }
//      if (foodList.length >= 3 && foodList.length <= 5 && possessionSlot) {
//        possessionsCounted[possessionSlot] = foodList.length;
//        possessionsNamed[possessionSlot] = (foodList.length >= 4 ? 'about ' : '')
//          + spellInt(foodList.length) + ' food items';
//        nonWeaponsListed = true;
//      }
//      if (soupList.length == 1 && possessionSlot) {
//        possessionsCounted[possessionSlot] = soupList.length;
//        possessionsNamed[possessionSlot] = 'a bowl of ' + soupList[1].foodName;
//        nonWeaponsListed = true;
//      }
//      if (beverageList.length >= 1 && beverageList.length <= 2 && possessionSlot) {
//        possessionsCounted[possessionSlot] = beverageList.length;
//        if (beverageList.length >= 2)
//          possessionsNamed[possessionSlot] = spellInt(beverageList.length) + ' beverages';
//        else
//          possessionsNamed[possessionSlot] = 'a ' + beverageList[1].containerNoun
//            + ' of ' + beverageList[1].contentsName;
//        nonWeaponsListed = true;
//      }
//      if (foodList.length >= 1 && foodList.length <= 2 && possessionSlot) {
//        possessionsCounted[possessionSlot] = foodList.length;
//        if (foodList.length >= 2)
//          // My wife suggests changing 'a couple of food items' to 'some food'.
//          possessionsNamed[possessionSlot] = 'a couple of food items'; 
//        else
//          possessionsNamed[possessionSlot] = foodList[1].aFoodName;
//        nonWeaponsListed = true;
//      }
//      
//      // Check for unusual clothes (but only if none of the unusual clothes
//      // are being worn)
//      tempList = gPlayerChar.possessionsMatching(Wearable, [assumingNoneIsWorn, assumingOneOrMoreHeld]);
//      if (tempList.length && possessionSlot) {
//        //local k=0;k=k/k;
//        possessionsCounted[possessionSlot] = tempList.length;
//        if (tempList.length >= 3)
//          possessionsNamed[possessionSlot] = 'about ' + spellInt(tempList.length)
//            + ' pieces of clothing';
//        else if (tempList.length == 2)
//          possessionsNamed[possessionSlot] = 'a couple pieces of clothing';
//        else
//          possessionsNamed[possessionSlot] = tempList[1].aName;
//        nonWeaponsListed = true;
//      }
//      
//      // Check for explosive.
//      if (explosive.isBeingHeldBy(gPlayerChar) && possessionSlot 
//          && !explosiveListed) {
//        possessionsCounted[possessionSlot] = 1;
//        possessionsNamed[possessionSlot] = 'some kind of explosive';
//        explosiveListed = true;
//      }
//      
//      // Check for dagger. If the explosive has been mentioned, don't
//      // mention the dagger, because we'd like to minimize the chances
//      // of the list consisting of nothing but weapons.
//      if (dagger.isBeingHeldBy(gPlayerChar) && possessionSlot 
//          && !daggerListed && !explosiveListed) {
//        possessionsCounted[possessionSlot] = 1;
//        possessionsNamed[possessionSlot] = 'a dagger';
//        daggerListed = true;
//      }
//      
//      // Check for various containers that once contained food or liquid.
//      tempList2 = [
//         // From Vicki's point of view, a flask doesn't look all that different
//         // from a bottle.
//         ['bottle','bottles',[ExFlowingOpenableBottle,ExFlowingFlask]]
//        ,['bowl'  ,'bowls'  ,ExFlowingBowl]
//        ,['bag'   ,'bags'   ,ExFlowingOpenableBag]
//        ,['glass' ,'glasses',ExFlowingGlass]
//      ];
//      if (possessionSlot) {
//        for (local a = 1; a <= tempList2.length; a++) {
//          tempList = gPlayerChar.possessionsMatching(tempList2[a][3], 
//                       assumingOneOrMoreHeld);
//          if (tempList.length && possessionSlot) {
//            possessionsCounted[possessionSlot] = tempList.length;
//            if (tempList.length >= 3)
//              possessionsNamed[possessionSlot] = spellInt(tempList.length) + ' '
//                + tempList2[a][2];
//            else if (tempList.length == 2)
//              possessionsNamed[possessionSlot] = 'a couple of ' 
//                + tempList2[a][2];
//            else
//              possessionsNamed[possessionSlot] = 'a ' + tempList2[a][1];
//            nonWeaponsListed = true;
//          }
//        }
//      }
//      
//      // Check for unused wrappers.
//      tempList = gPlayerChar.possessionsMatching(Wrapper, 
//        [assumingOneOrMoreHeld, notBeingWrapped]);
//      if (tempList.length && possessionSlot) {
//        possessionsCounted[possessionSlot] = tempList.length;
//        if (tempList.length >= 3)
//          possessionsNamed[possessionSlot] = 'about ' + spellInt(tempList.length)
//            + ' wrappers';
//        else if (tempList.length == 2)
//          possessionsNamed[possessionSlot] = 'a couple of wrappers';
//        else
//          possessionsNamed[possessionSlot] = 'a wrapper';
//        nonWeaponsListed = true;
//      }
//      
//      // Get rid of the item in slot 3, if applicable. Add "and all
//      // the rest," if applicable.
//      if (possessionsNamed[4]) {
//        possessionsCounted[3] = 0;
//        possessionsNamed[3] = nil;
//      }
//      else {
//        if (possessionsCounted[1] + possessionsCounted[2] + possessionsCounted[3]
//            < gPlayerChar.possessions.length) {
//          possessionsNamed[4] = 'and all the rest&mdash;';
//        }
//      }
//      
//      // Now decide whether to remark upon "all that stuff
//      // he's carrying."
//      if (possessionsNamed[1] && (possessionsNamed[2] || possessionsNamed[4])
//          && nonWeaponsListed) {
//        setSpeaker('Vicki');
//        "<p>Eyeing you with amazement, Vicki cries, <.q>Yeah, and look at
//          all that stuff he<./s>s carrying! \^";
//        "<<possessionsNamed[1]>>";
//        if (possessionsNamed[2])
//          ", <<possessionsNamed[2]>>";
//        if (possessionsNamed[3])
//          ", <<possessionsNamed[3]>>";
//        if (possessionsNamed[4])
//          ", <<possessionsNamed[4]>>";
//        else
//          "&mdash;";
//        "<./q> Then, quizzically, she says";
//        if (!furtherCommentary) {
//          " to you, <.q>How can you carry all that?<./q>";
//        }
//        else {
//          ", <.q>How can he carry all that?<./q> ";
//          setSpeaker('Diane');
//          "<p><.q>A talented man indeed, our Gary,<./q> says Diane
//            wryly. ";
//          // My wife strongly disapproved of this "breaking the fourth wall"
//          // line; maybe she's right.
//          //"<p>Diane shrugs. <.q>Well, he plays a lot of computer games,
//          //  right? I think it<./s>s an acquired skill.<./q> ";
//        }
//        return FridgePart;
//      }
//    }
//    if (gPlayerChar.possessions.indexOf(dagger) ||
//             gPlayerChar.possessionsMatching(Gun, []).length || 
//             gPlayerChar.possessions.indexOf(explosive)) {
//      if (gPlayerChar.possessions.indexOf(dagger))
//        weaponsNamed[1] = 'a huge dagger';
//      if (gPlayerChar.possessionsMatching(Gun, []).length >= 3)
//        weaponsNamed[2] = 'about '
//          + spellInt(gPlayerChar.possessionsMatching(Gun, []).length)
//          + ' different guns';
//      else if (gPlayerChar.possessionsMatching(Gun, []).length == 2)
//        weaponsNamed[2] = spellInt(gPlayerChar.possessionsMatching(Gun, []).length)
//          + ' different guns';
//      else if (gPlayerChar.possessionsMatching(Gun, []).length == 1)
//        weaponsNamed[2] = 'a dangerous-looking gun';
//      if (gPlayerChar.possessions.indexOf(explosive))
//        weaponsNamed[3] = 'what is that, an explosive?';
//      
//      setSpeaker('Vicki');
//      "<p>Eyeing you with amazement, Vicki cries, <.q>Yeah, and look at
//        what he<./s>s carrying";
//      if (weaponsNamed[3])
//        "&mdash;";
//      else
//        "! \^";
//      if (weaponsNamed[1]) {
//        "<<weaponsNamed[1]>>";
//        weaponsCounted++;
//      }
//      if (weaponsNamed[2]) {
//        if (weaponsNamed[1] && weaponsNamed[3])
//          ", ";
//        else if (weaponsNamed[1])
//          ", and ";
//        "<<weaponsNamed[2]>>";
//        weaponsCounted = weaponsCounted + 
//          gPlayerChar.possessionsMatching(Gun, []).length;
//      }
//      if (weaponsNamed[3]) {
//        if (weaponsNamed[1] || weaponsNamed[2])
//          ", and&mdash;";
//        "<<weaponsNamed[3]>>";
//        weaponsCounted++;
//      }
//      else {
//        "!";
//      }
//      if (!furtherCommentary) {
//        "<./q> Then, to you, she adds, <.q>Please be careful with
//          <<weaponsCounted >= 2 ? 'those' : 'that'>>.<./q> ";
//      }
//      else {
//        "<./q> Then she adds, <.q>I just hope he<./s>s careful with
//          <<weaponsCounted >= 2 ? 'those' : 'that'>>.<./q> ";
//        setSpeaker('Diane');
//        "<p>Diane, for her part, says, <.q>This is good news.
//          To fight against Neton and his brainless minions,
//          we need all the weapons we can get.<./q> ";
//      }
//      return Gun;
//    }
//    return nil;
//  }
////    if (noteworthyPossessions) {
////      setSpeaker('Vicki');
////      "<p><.q>Yeah, and look at all that stuff he<./s>s carrying!<./q> 
////        <<speaker>> cries. <.q>Seven firearms, three bowls of soup, 
////        and&mdash;what are those, refrigerator drawers?<./q> ";
////      // If the PC is either carrying food or wearing anything unusual,
////      // then let Vicki end with a throwaway question that will go
////      // unanswered.
////      if (unusualClothing || temptingFoodList) {
////        "Then she looks at you quizzically. 
////          <.q>How can you carry all that?<./q> ";
////      }
////      // In the "carrying a lot, but wearing nothing special and
////      // having no food" scenario, (1) avoid having Vicki address
////      // the PC in the second person, and (2) let Diane briefly respond.
////      else {
////        "Then her glance turns quizzical. 
////          <.q>How can he carry all that?<./q> ";
////        setSpeaker('Diane');
////        "<p><.q>A talented man indeed, our Gary,<./q> says Diane
////          wryly. ";
////        // My wife strongly disapproved of this "breaking the fourth wall"
////        // line; maybe she's right.
////        //"<p>Diane shrugs. <.q>Well, he plays a lot of computer games,
////        //  right? I think it<./s>s an acquired skill.<./q> ";
////      }
////    }
//  possessionsNamed = [nil, nil, nil, nil]
//  possessionSlot {
//    if (!possessionsNamed[1]) return 1;
//    if (!possessionsNamed[2]) return 2;
//    if (!possessionsNamed[3]) return 3;
//    return 0;
//  }
//  possessionsCounted = [0, 0, 0, 0]
//  addToPossessionsCounted(num) {
//    if (!possessionsNamed[3] || !possessionsNamed[4])
//      possessionsCounted += num;
//  }
//  speaker = 'Diane'
//  listener = 'Vicki'
//  speakerObj {
//    if (speaker == 'Diane')
//      return diane;
//    else
//      return vicki;
//  }
//  listenerObj {
//    if (listener == 'Diane')
//      return diane;
//    else
//      return vicki;
//  }
//  setSpeaker(sp) {
//    if (sp == 'Diane') {
//      speaker = 'Diane';
//      listener = 'Vicki';
//    }
//    else {
//      speaker = 'Vicki';
//      listener = 'Diane';
//    }
//  }
//  switchSpeaker {
//    if (speaker == 'Diane') {
//      speaker = 'Vicki';
//      listener = 'Diane';
//    }
//    else {
//      speaker = 'Diane';
//      listener = 'Vicki';
//    }
//  }
//;

// -------------------------------------------------------------------
// NPCS: PRISONERS: BEHAVIOR: Taking and/or stealing food
// -------------------------------------------------------------------

modify prisonerBehavior
  letPrisonersAttemptFoodTheft {
    local temptingFoodList, containersToBeOpened;
    if (
      // If Vicki's not going to steal food...
      (vicki.getOutermostRoom != gPlayerChar.getOutermostRoom
        || vicki.foodEaten > 0)
      // ...AND Diane's not going to steal food...
      && (diane.getOutermostRoom != gPlayerChar.getOutermostRoom
        || diane.foodEaten > 0)
    )
      // then stop here.
      return;
    // Do temptingFoodList calculations. Make sure temptingFoodList
    // always equals either nil or else a list with more than one element.
    gPlayerChar.calculatePossessions;
    temptingFoodList = getTemptingFoodList;
    // If there's no tempting food to be stolen, don't go any further.
    if (!temptingFoodList)
      return;
    containersToBeOpened =
      getContainersToBeOpened(temptingFoodList);
    setSpeaker('Vicki');
    doFoodTheft(
         temptingFoodList // temptingFoodList
        ,containersToBeOpened // containersToBeOpened
        ,nil // nowRescuing
        ,nil // preambleRequired
    );
  }
  letPrisonersGetStrayFood(whoFirst, preambleRequired) {
    // Unlike letPersonersAttemptFoodTheft, in which any and all
    // food is grabbed just once, here each of the prisoners takes
    // food separately, so we need two lists of tempting food,
    // plus two lists of containers to be opened.
    local temptingFoodList = [];
    local foodToBeStolen = [[], []];
    local containersToBeOpened = [[], []];
    local maxToTake = 0;
    local prisonerHunger = [0, 0];
    local prisonerList = [];
    local firstNum = 0;
    local lastNum = 0;
    local verbose = (me.getOutermostRoom == vicki.getOutermostRoom);
    //local howMany = 0;
    // If the prisoners haven't yet been rescued, or if
    // neither of them is hungry, then end here.
    if (cellDoor.holdsPrisoners ||
        (!vicki.isHungry && !diane.isHungry))
      return nil;
    // Deal with the whoFirst stuff
    if (whoFirst == 'Vicki' || whoFirst == vicki) {
      prisonerList = [vicki, diane];
      setSpeaker('Vicki');
    }
    else {
      prisonerList = [diane, vicki];
      setSpeaker('Diane');
    }
    // Before anything else, we must figure out how many 
    // food items are in plain view near the prisoners
    // and can be taken without stealing them from anybody.
    temptingFoodList = vicki.scopeList.subset({x: 
      x.ofKind(Satiating) && x.tastiness > 0 &&
      x.getOutermostRoom == vicki.getOutermostRoom &&
      !x.isIn(me) && !x.isIn(vicki) && !x.isIn(diane)});
    // If there is no tempting food that can be taken without
    // stealing, then end here.
    if (temptingFoodList.length <= 0)
      return nil;
    // From this point on, we can assume two things:
    // (1) one or more of the prisoners could still stand to 
    // eat something, and (2) there is food to be had without
    // stealing. Let the food-taking commence.
    
    // Set the values to describe how many things each prisoner
    // wants to eat.
    for (local a = 1; a <= 2; a++) {
      prisonerHunger[a] = prisonerList[a].satiationLevel
        - prisonerList[a].foodEaten;
      if (prisonerHunger[a] > 2)
        prisonerHunger[a] = 2;
      if (prisonerHunger[a] < 0)
        prisonerHunger[a] = 0;
    }
    // Let maxToTake = the total number of things to be stolen.
    // This will be the sum total number of food items desired
    // by both Vicki and Diane, or the number of available food 
    // items, whichever is less.
    if (temptingFoodList.length <= prisonerHunger[1] + prisonerHunger[2])
      maxToTake = temptingFoodList.length;
    else
      maxToTake = prisonerHunger[1] + prisonerHunger[2];
    // Redundant, but just to be safe:
    if (maxToTake <= 0)
      return nil;
    // Let foodToBeStolen[1] = the first "n" elements in 
    // temptingFoodList, where "n" = 1 if maxToTake = 1 or 2;
    // or "n" = 2 if maxToTake = 3 or 4;
    foodToBeStolen[1] = temptingFoodList.sublist(1, (maxToTake + 1) / 2);
    //for (local a = 1; a <= (maxToTake + 1) / 2; a++) {
    //  foodToBeStolen[1] += temptingFoodList[a];
    //}
    // Let foodToBeStolen[2] = all of the first "n" elements in
    // temptingFoodList -- where "n" = maxToTake -- **except** those
    // in foodToBeStolen[1].
    foodToBeStolen[2] = temptingFoodList.sublist(1, maxToTake)
      .subset({x: !foodToBeStolen[1].indexOf(x)});
    // Let containersToBeOpened[1] and containersToBeOpened[2] be
    // lists of the containers that must be opened to obtain the foods
    // listed in foodToBeStolen[1] and foodToBeStolen[2], respectively.
    containersToBeOpened[1] =
      getContainersToBeOpened(foodToBeStolen[1]);
    containersToBeOpened[2] =
      getContainersToBeOpened(foodToBeStolen[2])
        .subset({x: !containersToBeOpened[1].indexOf(x)});
    // 
    if (foodToBeStolen[1].length > 0)
      firstNum = 1;
    else
      firstNum = 2;
    if (foodToBeStolen[2].length > 0)
      lastNum = 2;
    else
      lastNum = 1;
    // Redundant, but just to be safe:
    if (lastNum < firstNum)
      return nil;
    //howMany = lastNum - firstNum + 1;
    // We should now have all the information we need.
    for (local a = firstNum; a <= lastNum; a++) {
      // Preamble
      if (preambleRequired)
        "<p>";
      if (a == firstNum && verbose) {
        "Then, suddenly, <<prisonerList[a].theName>> cries,
          <.q>Whoa! Look what I found!<./q> 
          And she bends down to ";
      }
      else if (verbose) {
        "<p><.q>Yeah! And here<./s>s more!<./q> cries 
          <<prisonerList[2].theName>>, bending to  ";
      }
      // open containers, if applicable
      if (containersToBeOpened[a].length == 2) {
        if (verbose)
          "open the <<containersToBeOpened[a][1].theName>> 
            and <<containersToBeOpened[a][2].name>> so she can ";
        containersToBeOpened[a][1].makeOpen(true);
        containersToBeOpened[a][2].makeOpen(true);
      }
      else if (containersToBeOpened[a].length == 1) {
        if (verbose)
          "open <<containersToBeOpened[a][1].theName>> and ";
        containersToBeOpened[a][1].makeOpen(true);
      }
      // pick up food
      if (verbose) {
        "pick up <<foodToBeStolen[a][1].aFoodName>>";
        if (foodToBeStolen[a].length > 1) {
          " and <<foodToBeStolen[a][2].aFoodName>>";
        }
        ". ";
      }
    }
    // If prisoners are visible only in the distance, give a unique 
    // and much shorter message.
    if (!verbose && me.canSee(vicki)) {
      "<.p>Down the hallway to the ";
      if (me.getOutermostRoom.isInColumn > vicki.getOutermostRoom.isInColumn)
        "west, ";
      else
        "north, ";
      if (lastNum > firstNum || prisonerList[2].foodEaten <= prisonerList[1].foodEaten)
        "Vicki and Diane find some food to their liking. 
          They pick it up and proceed to eat it. ";
      else
        "<<prisonerList[firstNum].theName>> finds some food to her liking. 
          She picks it up and proceeds to eat it.]";
    }
    for (local a = firstNum; a <= lastNum; a++) {
      if (a == 1 && foodToBeStolen[a].length == 1 
          && prisonerList[2].foodEaten <= prisonerList[1].foodEaten) {
        if (verbose) {
          "And with that, <<prisonerList[1].theName>>
              <<foodToBeStolen[a][1].beginsToDevourPhrase>>. 
            <p><.q>Hold on there, <<prisonerList[1].theName>>!<./q> 
              <<prisonerList[2].theName>> shouts with surprising ferocity. 
            <p>\^<<prisonerList[1].theName>>, who had just opened
              her mouth for more of <<foodToBeStolen[a][1].theFoodName>>, 
              now says, <.q>Oh. Sorry.<./q> With that, she gives 
              the rest of <<foodToBeStolen[a][1].theFoodName>> to 
              <<prisonerList[2].theName>>, who 
              <<foodToBeStolen[a][1].finishesDevouringPhrase>>. ";
        }
        foodToBeStolen[a][1].baseMoveInto(prisonerList[2]);
        prisonerList[1].foodEaten += 1;
        prisonerList[2].foodEaten += 1;
      }
      else if (a == firstNum) {
        if (foodToBeStolen[a].length == 1) {
          // devoursPhrase is preferred here.
          if (verbose)
            "<p>With that, <<prisonerList[a].theName>> 
              <<foodToBeStolen[a][1].devoursPhrase>>. ";
          foodToBeStolen[a][1].baseMoveInto(prisonerList[a]);
          // To minimize the potential for numerous tedious instances 
          // of NPCs picking up food and eating it, we exaggerate
          // the nutritive value of food eaten in this way.
          // Just don't let foodEaten become greater than satiationLevel.
          prisonerList[a].foodEaten += 2;
          if (prisonerList[a].foodEaten > prisonerList[a].satiationLevel)
            prisonerList[a].foodEaten = prisonerList[a].satiationLevel;
        }
        else { // foodToBeStolen[a].length == 2
          // Note paragraph break. If this sentence gets too long,
          // a paragraph break after it seems appropriate.
          if (verbose)
            "<p>With that, <<prisonerList[a].theName>> 
              <<foodToBeStolen[a][1].scarfsPhrase>>, then 
              <<foodToBeStolen[a][2].devoursPhrase>>. <p>";
          foodToBeStolen[a][1].baseMoveInto(prisonerList[a]);
          foodToBeStolen[a][2].baseMoveInto(prisonerList[a]);
          // Again to minimize instances of NPCs picking up food,
          // we arbitrarily declare that this meal of two food items
          // fills the NPC up.
          prisonerList[a].foodEaten = prisonerList[a].satiationLevel;
        }
        //prisonerList[a].foodEaten += foodToBeStolen[a].length;
      }
      else {
        if (verbose)
          "\^<<prisonerList[a].theName>>, for her part, ";
        if (foodToBeStolen[a].length == 1) {
          // scarfsPhrase is preferred here.
          if (verbose)
            "<<foodToBeStolen[a][1].scarfsPhrase>>. ";
          foodToBeStolen[a][1].baseMoveInto(prisonerList[a]);
          // To minimize the potential for numerous tedious instances 
          // of NPCs picking up food and eating it, we exaggerate
          // the nutritive value of food eaten in this way.
          // Just don't let foodEaten become greater than satiationLevel.
          prisonerList[a].foodEaten += 2;
          if (prisonerList[a].foodEaten > prisonerList[a].satiationLevel)
            prisonerList[a].foodEaten = prisonerList[a].satiationLevel;
        }
        else { // foodToBeStolen[a].length == 2
          // Note paragraph break. If this sentence gets too long,
          // a paragraph break after it seems appropriate.
          if (verbose)
            "<<foodToBeStolen[a][1].scarfsPhrase>>, then 
              <<foodToBeStolen[a][2].devoursPhrase>>. <p>";
          foodToBeStolen[a][1].baseMoveInto(prisonerList[a]);
          foodToBeStolen[a][2].baseMoveInto(prisonerList[a]);
          // Again to minimize instances of NPCs picking up food,
          // we arbitrarily declare that this meal of two food items
          // fills the NPC up.
          prisonerList[a].foodEaten = prisonerList[a].satiationLevel;
        }
        //prisonerList[a].foodEaten += foodToBeStolen[a].length;
      }
      for (local b = 1; b <= foodToBeStolen[a].length; b++) {
        if (foodToBeStolen[a][b].ofKind(FlowingInContainer))
          foodToBeStolen[a][b].processConsumption;
        else
          foodToBeStolen[a][b].eatingConsequences;
        foodToBeStolen[a][b].moveInto(nil);
      }
      //if (foodToBeStolen[a].length > 1) {
      //  if (foodToBeStolen[a][2].ofKind(FlowingInContainer))
      //    foodToBeStolen[a][2].processConsumption;
      //  else
      //    foodToBeStolen[a][2].eatingConsequences;
      //  foodToBeStolen[a][2].moveInto(nil);
      //}
    }
    //local k = inputManager.getKey(nil, nil);
    //if (k.toLower == 'q')
    //  { k=0;k=k/k; }
    return true;
  }
  doFoodTheft(temptingFoodList, containersToBeOpened, nowRescuing, 
              preambleRequired) {
    // Without tempting food items, nothing can be done here.
    if (!temptingFoodList || !temptingFoodList.length)
      return;
    // The wording of this next paragraph will differ depending on
    // whether it is to be uttered during the initial rescue
    // encounter. And if this is during that encounter, 
    // the wording will also depend on whether anything has been said 
    // since Diane's initial "holy shit" comment.
    if (nowRescuing && preambleRequired)
      "<p><.q>It<./s>s great to see you, Gary!<./q> <<speaker>> cries.
        Then, eyeing your possessions, she says, <.q>Hey, 
        wait a minute, <<listener>>. This man has food! ";
    else if (nowRescuing)
      "<p><<speaker>> says, <.q>Wait a minute, <<listener>>.
        Can<./s>t you see this man has food? ";
    else // !nowRescuing
      "<.p>Then, all of a sudden, <<speaker>> says, 
        <.q>Hey, look, <<listener>>! This man has food! ";
    "Real food! I mean, he has 
      <<temptingFoodList[1].aFoodName>>!<./q> ";
    speakerObj.desiredFood = temptingFoodList[1];
    // First, for this next part, switch speaker.
    switchSpeaker;
    // This next paragraph varies depending on two things:
    // whether Vicki or Diane is the one who speaks next,
    // and whether there is more than one tempting food item.
    if (temptingFoodList.length <= 1) {
      "<p><.q>Whoa, you<./s>re right,<./q> says <<speaker>>.
        <.q><<nameForCommentaryIsPlural ? 'Those' : 'That'>> 
        <<temptingFoodList[1].foodName>> 
        look<<nameForCommentaryIsPlural ? '' : 's'>> awfully
        good.";
      speakerObj.desiredFood = temptingFoodList[1];
    }
    else {
      "<p><.q>Whoa, you<./s>re right,<./q> says <<speaker>>.
        <.q>But never mind <<temptingFoodList[1].theFoodName>>.
        I<./s>m looking at <<temptingFoodList[2].theFoodName>>.
        Mmm, <<temptingFoodList[2].foodName>>.";
      speakerObj.desiredFood = temptingFoodList[2];
    }
    // We take great pains to make sure Vicki is the last 
    // to speak here. The next part of the exchange involves 
    // stealing the food, and Diane has to be the one 
    // to do that.
    if (speaker == 'Vicki')
      " Gary, could we please have&mdash;<./q> ";
    else
      "<./q>
        <p>Vicki says, <.q>Gary, could we please 
        have&mdash;<./q> ";
    // The great food robbery.
    "<p>But Diane can<./s>t wait. Before you know what<./s>s
      happening, she comes up to you";
    // A minor point: If any of the food items are in 
    // containers, we'll have to make sure Diane opens them.
    if (containersToBeOpened.length) {
      for (local a = 1; a <= containersToBeOpened.length; a++) {
        containersToBeOpened[a].makeOpen(true);
      }
      ", opens <<containersToBeOpened[1].theName>>";
      if (containersToBeOpened.length > 1)
        " and <<containersToBeOpened[2].name>>";
      ",";
    }
    // We now return to our regularly scheduled food robbery.
    " and seizes <<temptingFoodList[1].theFoodName>>";
    if (temptingFoodList.length > 1)
      " and <<temptingFoodList[2].foodName>>";
    ". ";
    // Vicki comes last on purpose. If Vicki and Diane both want,
    // e.g., the same bowl of soup, then Vicki will end up
    // holding the bowl.
    if (diane.desiredFood)
      diane.desiredFood.baseMoveInto(diane);
    if (vicki.desiredFood)
      vicki.desiredFood.baseMoveInto(vicki);
    // The remaining text is largely different, depending
    // on whether there is only one food item that must be shared,
    // or whether there is more than one.
    if (temptingFoodList.length <= 1) {
      "Hungrily, she <<diane.desiredFood.beginsToDevourPhrase>>. 
        <p><.q>Hold on there, Diane!<./q> Vicki shouts
          with surprising ferocity.
        <p>Diane, who had just opened her mouth for more of
          <<diane.desiredFood.theFoodName>>, now pulls back
          and says, <.q>Oh. Sorry.<./q> With that,
          she gives the rest of <<diane.desiredFood.theFoodName>>
          to Vicki, who 
          <<vicki.desiredFood.finishesDevouringPhrase>>.
        <p>Turning to you, Diane says, <.q>Sorry, but you
          don<./s>t know what kind of food cravings we<./s>ve had.
          We<./s>ve been here a lot longer than you.<./q>
        <p>Done eating now, Vicki says with some embarassment,
          <.q>Uh, yeah. We don<./s>t normally steal, but this
          was an emergency.<./q> ";
    }
    else {
      "<.q>Here you go,<./q> she says to Vicki, handing her 
          <<vicki.desiredFood.theFoodName>>.
        <p>Vicki says to you, <.q>Sorry, but you don<./s>t know
          what kind of food cravings we<./s>ve had. We<./s>ve
          been here a lot longer than you.<./q>
        <p>With that, Vicki hungrily 
          <<vicki.desiredFood.devoursPhrase>>.
          Diane, for her part, 
          <<diane.desiredFood.scarfsPhrase>>. ";
    }
    vicki.foodEaten++;
    diane.foodEaten++;
//    // If we skip over the preconditions, the action phase
//    // of the Eat verb should do what we need for (1) getting
//    // rid of the food, and (2) carrying out any side effects
//    // such as empty soup bowls, etc., that remain afterwards.
//    temptingFoodList[1].actionDobjEat();
//    if (temptingFoodList.length > 1)
//      temptingFoodList[2].actionDobjEat();
    if (temptingFoodList[1].ofKind(FlowingInContainer))
      temptingFoodList[1].processConsumption;
    else
      temptingFoodList[1].eatingConsequences;
    temptingFoodList[1].moveInto(nil);
    if (temptingFoodList.length > 1) {
      //temptingFoodList[2].actionDobjEat();
      if (temptingFoodList[2].ofKind(FlowingInContainer))
        temptingFoodList[2].processConsumption;
      else
        temptingFoodList[2].eatingConsequences;
      temptingFoodList[2].moveInto(nil);
    }
  }
;

// -------------------------------------------------------------------
// NPCS: PRISONERS: BEHAVIOR: Give/show stuff to Vicki/Diane
// -------------------------------------------------------------------

enum ordinaryDrink, alcoholicDrink, oil, 
  flowingFood, soupFood, goodFood, rawFood, unpeeledFood, cannedFood;

enum take, eat, give;

modify Thing
  // An ordinary thing falls into no special broad category 
  // that makes it interesting to Vicki or Diane.
  giveShowType = self
  vickiShowResponse {
    "Vicki glances at {it dobj/him} without much interest,
      shrugs, then looks away. ";
  }
  dianeShowResponse {
    if (gDobj.isIn(me))
      "<.q>Congratulations,<./q> says Diane. <.q>You<./s>re 
        the proud owner of {a dobj/him}.<./q> ";
    else
      "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve 
        successfully located {the dobj/him}.<./q> ";
  }
  vickiGiveResponse {
    "<.q>Uh, no thanks,<./q> says Vicki. ";
  }
  dianeGiveResponse {
    "<.q>No, no,<./q> says Diane. <.q>You<./s>re not going to 
      pawn that off on me.<./q> ";
  }
;
modify Prisoner
  iobjFor(ShowTo) {
    action {
      noteObjectShown(gDobj);
      //gActor.noteConversation(self);
      //curState.handleConversation(gActor, gDobj, showConvType);
      
      // First, a preliminary sentence about showing the dobj.
      if (gDobj == me)
        "You point out yourself to {the iobj/her}. "; 
      else if (gDobj == gIobj)
        "You point out {the dobj/her} to herself. ";
      else if (gDobj.isIn(me))
        "You show <<gDobj.theNameForCommentary>> to {the iobj/her}. ";
      else
        "You point out <<gDobj.theNameForCommentary>> to {the iobj/her}. ";
      
      "<p>";
      if (self == vicki)
        gDobj.vickiShowResponse;
      else // diane
        gDobj.dianeShowResponse;
    }
  }
  iobjFor(GiveTo) {
    action {
      noteObjectShown(gDobj);
      //gActor.noteConversation(self);
      //curState.handleConversation(gActor, gDobj, giveConvType);
      
      // First, a preliminary sentence about showing the dobj.
      "You offer {the dobj/him} to {the iobj/him}. ";
      
      "<p>";
      if (self == vicki)
        gDobj.vickiGiveResponse;
      else // diane
        gDobj.dianeGiveResponse;
    }
  }
;

//      if (gDobj.isIn(self) && gDobj.ofKind(PrisonerClothing)) {
//        if (self == vicki)
//          "<.q>Not the height of fashion, is it?<./q> says Vicki.
//            <.q>But it suffices.<./q> ";
//        else // diane
//          "<.q>Yep, I<./s>m wearing clothes, all right,<./q> says Diane. ";
//        return;
//      }
//      if (gDobj.isIn(self)) {
//        if (self == vicki)
//          "<.q>Hey, thanks for <<gDobj.theNameForCommentary>>,<./q>
//            says Vicki. <.q>I really appreciate it.<./q> ";
//        else // diane
//          "<.q>I suppose I should thank you for giving me 
//            <<gDobj.theNameForCommentary>>,<./q> Diane remarks,
//            noncommittally. ";
//        return;
//      }
//      //if (gDobj.isIn(self)) {
//      //  if (self == vicki)
//      //    "<.q>Hey, thanks for <<gDobj.theNameForCommentary>>,<./q>
//      //      says Vicki. <.q>I really appreciate it.<./q> ";
//      //  else // diane
//      //    "<.q>Why look!<./q> Diane remarks. <.q>I<./s>ve got 
//      //      <<gDobj.aNameForCommentary>>. And I owe it all to you.<./q> ";
//      //  return;
//      //}
//      if (gDobj.giveShowType == alcoholicDrink) {
//        if (self == vicki)
//          "<.q>Hey, I hope you<./s>re not planning on getting drunk
//            just yet,<./q> says Vicki. <.q>We have an important task
//            in front of us&mdash;namely, getting out of here.<./q> ";
//        else // diane
//          "<.q>Hey, we could have a pretty good party with that 
//            later on,<./q> says Diane. <.q>On the other hand, 
//            maybe we should save it for medicinal use. 
//            Decisions, decisions.<./q> ";
//        return;
//      }
//      if (gDobj.giveShowType == ordinaryDrink) {
//        if (self == vicki)
//          "<.q>I<./s>m not thirsty now,<./q> says Vicki. 
//            <.q>But it may come in handy later.<./q> ";
//        else
//          "<.q>Not a bad find,<./q> says Diane. <.q>Maybe we<./s>ll
//            be thirsty for it later on.<./q> ";
//        return;
//      }
//      if (gDobj.giveShowType == oil) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      if (gDobj.giveShowType == tableSalt) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      if (gDobj.giveShowType == flowingFood) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      if (gDobj.giveShowType == soupFood) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      if (gDobj.giveShowType == unpeeledFood) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      if (gDobj.giveShowType == rawFood) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      if (gDobj.giveShowType == cannedFood) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      if (gDobj.giveShowType == goodFood) {
//        if (self == vicki)
//          " ";
//        else
//          " ";
//        return;
//      }
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      
//      if (gDobj.isIn(self))
//      switch (gDobj.giveShowType) {
//        case alcoholicDrink:
//          if (self == vicki)
//            "<.q>Hey, I hope you<./s>re not planning on getting drunk
//              just yet,<./q> says Vicki. <.q>We have a serious task
//              in front of us&mdash;namely, getting out of here.<./q> ";
//          else // diane
//            "<.q>Hey, we could have a pretty good party with that 
//              later on,<./q> says Diane. <.q>On the other hand, 
//              maybe we should save it for medicinal use. 
//              Decisions, decisions.<./q> ";
//          break;
//        case ordinaryDrink:
//          if (self == vicki)
//            "<.q>Hey, I hope you<./s>re not planning on getting drunk
//              just yet,<./q> says Vicki. <.q>We have a serious task
//              in front of us&mdash;namely, getting out of here.<./q> ";
//          else // diane
//            "<.q>Not a bad find,<./q> says Diane. <.q>Maybe we<./s>ll
//              be thirsty for it later on.<./q> ";
//          break;
//        case oil:
//        case tableSalt:
//        case unpeeledFood:
//          if (gDobj == melon) {
//          }
//          
//          break;
//          
//          break;
//        case flowingFood:
//          
//          break;
//        case soupFood:
//          
//          break;
//        case goodFood:
//          
//          break;
//        case rawFood:
//          
//          break;
//          
//          break;
//        case cannedFood:
//          
//          break;
//        case bras:
//          
//          break;
//        case ceramicBear:
//          
//          break;
//        case coat:
//          
//          break;
//        case shogun:
//          
//          break;
//        case FridgePart:
//          
//          break;
//        case foodCube:
//          
//          break;
//        case Gun:
//          
//          break;
//        case explosive:
//          
//          break;
//        default:
//          
//          break;
//      }

// -------------------------------------------------------------------
// NPCS: PRISONERS: BEHAVIOR: Marching north
// -------------------------------------------------------------------

modify vicki
  waitLength = 0 // for endgame NPC initiatives
  //northSuggestions = 0 // more endgame stuff
  utCountOne = 0
  utCountTwo = 0
  utCountThree = 0
  utCountFour = 0
  waitDaemon() { // a pseudo-daemon for the endgame only
    waitLength++;
    //"BeforeSay. ";
    //say(waitList[waitLength]);
    
    //if (waitList == nil)
    //  {local k=0;k=k/k;}
    if (waitLength <= 0)
      return;
    if (dataType(waitList[waitLength]) != TypeNil &&
        me.getOutermostRoom == vicki.getOutermostRoom 
        && !vicki.isAntagonized && !diane.isAntagonized) {
      (waitList[waitLength])();
    }
    //"AfterSay. ";
    if (waitLength == waitList.length) {
      vicki.leaving = true;
      diane.leaving = true;
      marchNorthOnOwnInitiative('<p>And with that, the two of them ', true);
    }
  }
  marchNorthOnOwnInitiative(nearPreamble, suddenly) {
    local visible = me.canSee(vicki);
    local near = (me.getOutermostRoom == vicki.getOutermostRoom);
    if (near && suddenly)
      "<p>And with that, the two of them ";
    else if (near && vicki.getOutermostRoom == hallway1 && !vicki.isAntagonized)
      "Vicki turns back to you and waves goodbye. With that, 
        she and Diane ";
    else if (near)
      "Vicki and Diane ";
    else if (visible) {
      "Down the hallway to the ";
      if (me.getOutermostRoom.isInColumn > vicki.getOutermostRoom.isInColumn)
        "west, ";
      else
        "north, ";
      if (suddenly)
        "Diane turns her head to you and calls out something about
            <.q>Can<./s>t wait any longer!<./q>
          <p>Vicki calls out, <.q>See you outside the building!<./q> 
          <p>With that, she and Diane ";
      else if (vicki.getOutermostRoom == hallway1)
        "Vicki turns back to you and waves goodbye. With that,
          she and Diane ";
      else
        "Vicki and Diane ";
    }
    else if (suddenly && !near && !visible) {
      "Down the hallway, you hear Vicki shouting
        something that sounds like,
        <.q>See you outside the building, <<me.firstName>>!<./q> ";
    }
    if (vicki.getOutermostRoom == hallway3 && !hallDoors.isOpen) {
      hallDoors.makeOpen(true);
      if (near)
        "open the doors to the north and walk through them 
          into the hallway beyond. ";
      else if (visible)
        "open a set of doors and walk 
          <<me.getOutermostRoom.isInColumn > vicki.getOutermostRoom.isInColumn 
          ? 'out of sight' : 'off'>> to the north. ";
    }
    else if (vicki.getOutermostRoom == hallway1) {
      vicki.scMoveInto(nil);
      diane.scMoveInto(nil);
      if (near) {
        if (!frontDoors.isOpen)
          "open the front doors to the north and walk through them 
            into the world beyond. ";
        else
          "walk north out of the building. ";
        frontDoors.obviouslyLeadOutside = true;
      }
      else if (visible) {
        if (!frontDoors.isOpen)
          "open the front doors and ";
        "walk out of the building. ";
        frontDoors.obviouslyLeadOutside = true;
      }
      if (!frontDoors.isOpen)
        frontDoors.makeOpen(true);
    }
    else {
      if (visible) {
        "walk <<me.getOutermostRoom.isInColumn > vicki.getOutermostRoom.isInColumn 
          ? 'out of sight to the north' 
          : 'away from you' + (near ? ' to the north' : '')>>. ";
      }
    }
    if (vicki.getOutermostRoom) {
      vicki.scMoveInto(
        vicki.getOutermostRoom.north.getDestination(
        vicki.getOutermostRoom, vicki));
      diane.scMoveInto(
        diane.getOutermostRoom.north.getDestination(
        diane.getOutermostRoom, diane));
    }
  }
  waitList = waitTwelve
  waitTwelve = [
     nil //  1
    ,nil //  2
    ,new function { firstImpatientUtterance; }
    ,nil //  4
    ,nil //  5
    ,new function { secondImpatientUtterance; }
    ,nil //  7
    ,nil //  8
    ,new function { thirdImpatientUtterance; }
    ,nil // 10
    ,nil // 11
    ,new function { fourthImpatientUtterance; }
  ]
  waitNine = [
     nil //  1
    ,nil //  2
    ,new function { firstOrSecondImpatientUtterance; }
    ,nil //  4
    ,nil //  5
    ,new function { thirdImpatientUtterance; }
    ,nil //  7
    ,nil //  8
    ,new function { fourthImpatientUtterance; }
  ]
  waitSix = [
     nil //  1
    ,nil //  2
    ,new function { firstOrSecondOrThirdImpatientUtterance; }
    ,nil //  4
    ,nil //  5
    ,new function { fourthImpatientUtterance; }
  ]
  firstImpatientUtterance {
    utCountOne++;
    //"Zoinks1. ";
    if (utCountOne == 1)
      "<.q>Just so you know,<./q> says Vicki, <.q>we overheard 
        the guards say that the exit to the building is north 
        of here.<./q> ";
    else if (utCountOne == 2)
      "<.q>Remember,<./q> says Vicki, <.q>the guards said 
        that the exit to the building is north 
        of here.<./q> ";
    else
      say(rand(
         'Vicki looks wistfully off to the north. '
        ,'Vicki looks longingly off to the north. '
        ,'Diane looks north and taps her foot against the floor
           impastiently. '
        ,'Diane looks north and crosses her arms in impatience. '
      ));
  }
  secondImpatientUtterance {
    utCountTwo++;
    //"Zoinks2. ";
    if (utCountTwo == 1)
      "Diane sighs, then says to you, <.q>Say, <<me.firstName>>. 
          No offense, but we won<./s>t wait forever.<./q> 
          Pointing to the north, she says, <.q>We intend 
          to get out of here, with or without you.<./q>
        <p><.q>She<./s>s right,<./q> says Vicki. <.q>We don<./s>t 
          want to go without you, but&mdash;well, 
          it<./s>s really dangerous to escape from a prison cell 
          unless you also intend to escape from the prison.<./q> ";
    else
      say(rand(
         'Vicki looks wistfully off to the north. '
        ,'Vicki looks longingly off to the north. '
        ,'Diane looks north and taps her foot against the floor
           impastiently. '
        ,'Diane looks north and crosses her arms in impatience. '
      ));
  }
  thirdImpatientUtterance {
    utCountThree++;
    //"Zoinks3. ";
    if (utCountThree == 1)
      "Diane gives you a sidelong glance, then says to Vicki, 
          <.q>Should we leave?<./q>
        <p><.q>It doesn<./s>t look like Gary wants to leave 
          quite yet,<./q> says Vicki. <.q>We can wait 
          a bit longer.<./q> Then, after a pause, she adds, 
          <.q>Just a <i>bit</i> longer.<./q> ";
    else
      say(rand(
         'Vicki looks wistfully off to the north. '
        ,'Vicki looks longingly off to the north. '
        ,'Diane looks north and taps her foot against the floor
           impastiently. '
        ,'Diane looks north and crosses her arms in impatience. '
      ));
      //say(rand(
      //   '<.q>I<./s>m starting to lose my patience,<./q> says Diane,
      //     pointing to the north. <.q>The exit is that way.<./q> '
      //  ,'Diane gives you a sidelong glance, then says to Vicki,
      //     <.q>Do we have to wait any longer for this guy?<./q> '
      //  ,'Diane says, <.q>I<./s>m leaving soon, with or without
      //     the two of you.<./q> '
      //));
  }
  fourthImpatientUtterance = 
    "Diane says, <.q>All right, enough waiting. Let<./s>s 
        get out of here.<./q>
      <p>Vicki nods. Turning to you, she says, <.q>Hope to see you 
        soon, Gary. We<./s>ll meet you outside the building 
        when you<./s>re done in here.<./q> "
  firstOrSecondImpatientUtterance {
    if (utCountOne <= 1)
      return firstImpatientUtterance;
    else
      return secondImpatientUtterance;
  }
  firstOrSecondOrThirdImpatientUtterance {
    if (utCountOne <= 1)
      return firstImpatientUtterance;
    else if (utCountTwo <= 0)
      return secondImpatientUtterance;
    else
      return thirdImpatientUtterance;
  }
  askWhereGoing {
    if (!askedWhereGoing)
      "As you head off, Vicki calls, <.q>Hey, where are you 
          going? I think the exit is north of here!<./q>
        <p><.q>Let him 
          <<gPlayerChar.location == cell ? 'go back to the cell' : 'wander off'>> 
          if he wants to,<./q> says Diane. <.q>We can leave
          without him if it comes down to it.<./q> ";
    else
      "<.q>Don<./s>t be gone too long,<./q> says Vicki. <.q>Diane and I 
        plan to get out of here soon!<./q> ";
    askedWhereGoing = true;
  }
  askedWhereGoing = nil
//  firstImpatientUtterance {
//    utCountOne++;
//    "Zoinks1. ";
//    if (utCountOne == 1)
//      return
//        '<.q>Just so you know,<./q> says Vicki, <.q>we overheard 
//          the guards say that the exit to the building is north 
//          of here.<./q> ';
//    else if (utCountOne == 2)
//      return
//        '<.q>Remember,<./q> says Vicki, <.q>the guards said 
//          that the exit to the building is north 
//          of here.<./q> ';
//    else
//      return rand(
//         'Vicki looks wistfully off to the north. '
//        ,'Vicki looks longingly off to the north. '
//        ,'Diane looks north and taps her foot against the floor
//           impastiently. '
//        ,'Diane looks north and crosses her arms in impatience. '
//      );
//  }
//  secondImpatientUtterance {
//    utCountTwo++;
//    "Zoinks2. ";
//    if (utCountTwo == 1)
//      return
//        'Diane sighs, then says to you, <.q>Say, ' + me.firstName + '. 
//            No offense, but we won<./s>t wait forever.<./q> 
//            Pointing to the north, she says, <.q>We intend 
//            to get out of here, with or without you.<./q>
//          <p><.q>She<./s>s right,<./q> says Vicki. <.q>We don<./s>t 
//            want to go without you, but&mdash;well, 
//            it<./s>s really dangerous to escape from a prison cell 
//            unless you also intend to escape from the prison.<./q> ';
//    else
//      return rand(
//         'Vicki looks wistfully off to the north. '
//        ,'Vicki looks longingly off to the north. '
//        ,'Diane looks north and taps her foot against the floor
//           impastiently. '
//        ,'Diane looks north and crosses her arms in impatience. '
//      );
//  }
//  thirdImpatientUtterance {
//    utCountThree++;
//    "Zoinks3. ";
//    if (utCountThree == 1)
//      return
//        'Diane gives you a sidelong glance, then says to Vicki, 
//            <.q>Should we leave?<./q>
//          <p>"It doesn<./s>t look like Gary wants to leave 
//            quite yet,<./q> says Vicki. <.q>We can wait 
//            a bit longer.<./q> Then, after a pause, she adds, 
//            <.q>Just a <i>bit</i> longer.<./q> ';
//    else
//      return rand(
//         '<.q>I<./s>m starting to lose my patience,<./q> says Diane,
//           pointing to the north. <.q>The exit is that way.<./q> '
//        ,'Diane gives you a sidelong glance, then says to Vicki,
//           <.q>I <i>really</i> want to leave soon.<./q> '
//        ,'Diane says, <.q>I<./s>m leaving soon, with or without
//           the two of you.<./q> '
//      );
//  }
//  fourthImpatientUtterance = 
//    '<.q>All right, enough waiting. Let<./s>s get out of here.<./q>
//      <p>Vicki nods. Turning to you, she says, <.q>Hope to see you 
//        soon, Gary. We<./s>ll meet you outside the building 
//        when you<./s>re done in here.<./q> '
;

// -------------------------------------------------------------------
// NPCS: PRISONERS: Endgame conversation
// -------------------------------------------------------------------

vd2Main: QMain
  options = [
     vd2Finished
    ,vd2Killed
    ,vd2Now
    ,vd2Later
  ]
;

considerMakingPrisonersMorePatient() {
  vicki.waitLength = -1;
  if (vicki.waitList != vicki.waitTwelve)
    vicki.waitList = vicki.waitNine;
}

//  1 = Mexico   Sierra Madre      a maze with a map of Mexico
//  2 = animals  animal walking    a maze with a bunch of animals
//  3 = floor    wheels on floor   

//  4 = twisty   spherical chamber 
//  5 = quat1    compass needle    
//  6 = escape   spherical chamber 
//  7 = pyramid1 Egyptian tomb     a maze with a pyramid

//  8 = pyramid2 Egyptian tomb     a maze with a pyramid
//  9 = Africa   Sahara            a maze with a map of Africa
// 10 = books    library           a few mazes based on old books

// 11 = movies   library           a few mazes based on old movies
// 12 = quat2    compass needle    

// 13 = hacman                     a 'Net-Hac-Man' maze

/*
pyramid
Africa
animals
old books OR old movies
Mexico
*/

modify glob
  vd2InitialQuip = nil
  converseAboutGame() {
    local msg = '';
    local mazeMentions = 0;
    "<p><.q>It was&mdash;well, it was nothing but mazes,<./q> 
        you say. ";
    if (py1Rm23.supermazeDestination.isSolved || 
        py2Rm23.supermazeDestination.isSolved) {
      msg += 'a maze with a pyramid, ';
      mazeMentions++;
    }
    if (gambiaRoom.supermazeDestination.isSolved) {
      msg += 'a maze with a map of Africa, ';
      mazeMentions++;
    }
    if (mazeMentions < 2 && alligatorRoom.supermazeDestination.isSolved) {
      msg += 'a maze with a bunch of animals, ';
      mazeMentions++;
    }
    if (mazeMentions < 2 && 
        (tolstoyMaze.supermazeDestination.isSolved ||
         starwarsMaze.supermazeDestination.isSolved)) {
      msg += 'a few mazes based on old ';
      if (tolstoyMaze.supermazeDestination.isSolved) {
        msg += 'books';
        if (starwarsMaze.supermazeDestination.isSolved)
          msg += ' and movies';
      }
      else if (starwarsMaze.supermazeDestination.isSolved) {
        msg += 'movies';
      }
      msg += ', ';
      mazeMentions++;
    }
    if (mazeMentions < 2 && bajasurRoom.supermazeDestination.isSolved) {
      msg += 'a maze with a map of Mexico, ';
      mazeMentions++;
    }
    //"a maze with a pyramid, a maze with a map of Africa, ";
    "<.q>There <<msg.startsWith('a few') ? 'were' : 'was'>> 
        <<msg>>even a <.s>Net-Hac-Man<./s> maze, of all things.<./q> ";
    "<p><.q>What the hell is a <.s>Net-Hac-Man<./s> maze?<./q> 
        says Diane.
      <p><.q>It<./s>s a combination of Pac-Man and NetHack,<./q> 
        you say. Then, seeing her blank look, you add, 
        <.q>Nevermind, it<./s>s not worth explaining.<./q>
      <p><.q>But how was the game, really?<./q> asks Vicki.
        <.q>I mean, did you like it?<./q> ";
  }
  converseAboutKilling() {
    "<p><.q>Excellent work, <<me.firstName>>,<./q>
        says Diane. <.q>How did you manage it?<./q> ";
    "<p><.q>After I finished their game, I escaped
        and made my way to a museum, where I found some
        weapons,<./q> you say. <.q>That I was all I needed
        to take care of them.<./q> ";
    "<p><.q>Outstanding,<./q> says Diane. 
        Then, musing, she adds,
        <.q>I<./s>m a little jealous, actually. 
        I wanted to waste a few of those bastards
        myself.<./q> ";
  }
;

vd2Finished: Quip
  desc {
    "<.q>Good news&mdash;I survived 
      the aliens<./s> maze game!<./q> ";
  }
  reply {
    considerMakingPrisonersMorePatient();
    "<.q>Good news&mdash;I survived the aliens<./s> 
        maze game!<./q> you say. ";
    "<p><.q>That<./s>s great, <<me.firstName>>!<./q> 
        says Vicki. <.q>How did you do it?<./q>
      <p><.q>Well, back when I hacked into their
        computer system, I modified their maze game,<./q> 
        you say. <.q>Apparently this
        had the effect of putting the game into <.s>debug<./s> mode.
        Thus, 
        I got to play it as a text adventure 
        rather than an immersive VR experience. 
        I had all the advantages of being able 
        to save, restore, and undo, 
        so I was never in any real danger.<./q>
      <p><.q>Wonderful!<./q> says Vicki. Then she adds,
        <.q>Actually, you<./s>ve got me curious 
        now&mdash;what was the game like?<./q> ";
    glob.converseAboutGame();
    glob.vd2InitialQuip = self;
  }
  reply2 {
    "<p><.q>Just a second. That doesn<./s>t explain how you got here,<./q>
        says Diane. <.q>What happened to the aliens?<./q> ";
    "<p><.q>After I solved their game, they were so surprised
        that I managed to escape. 
        I ran to this one museum, where I found 
        some weapons. That was all I needed to take care
        of all five aliens.<./q> ";
    //"<p><.q>No, I played their game and solved it,<./q> 
    //    you say. <.q>In fact, they were so surprised by this 
    //    that I was able to escape from them. 
    //    I managed to run to this one museum, 
    //    where I found the weaponry I needed.<./q> ";
    "<p><.q>Outstanding,<./q> says Diane. 
        Then, musing, she adds,
        <.q>I<./s>m a little jealous, actually. 
        I wanted to waste a few of those bastards
        myself.<./q> ";
    "<p><.q>Well, it sounds like the coast is clear,<./q>
        says Vicki,
        <.q>so if you don<./s>t have any other plans,
        <<me.firstName>>, then let<./s>s get out of here.
        We<./s>re ready whenever you are.<./q> ";
  }
  killZ = true
  options = [
     vd2Disliked
    ,vd2Liked
  ]
  qOff = [vd2Finished, vd2Killed]
  qOn = [vd2Now]
;
vd2Killed: Quip
  desc {
    "<.q>Good news&mdash;I killed
        all the aliens in the building!<./q> ";
  }
  reply {
    considerMakingPrisonersMorePatient();
    "<.q>Good news&mdash;I killed all the aliens 
        in the building!<./q> you say. ";
    glob.converseAboutKilling();
    //"<p><.q>There<./s>s one thing I don<./s>t understand,<./q> 
    //    says Vicki. <.q>How did you get the opportunity 
    //    to fight them? Did you escape before they 
    //    forced you to play their maze game?<./q>
    //  <p><.q>No, I played their game and solved it,<./q> 
    //    you say. <.q>In fact, they were so surprised by this 
    //    that I was able to escape from them. 
    //    I managed to run to this one museum, 
    //    where I found the weaponry I needed.<./q> ";
    "<p><.q>Just a second,<./q> says Vicki. <.q>Did you 
        say you actually finished their game?<./q> ";
    "<p><.q>Yep,<./q> you say. <.q>When I went into VR,
        I modified the game, effectively putting it into
        <.s>debug<./s> mode and thus making it easy to win.<./q> ";
    "<p><.q>Remarkable,<./q> says Vicki. Then she adds,
        <.q>Say, what was their game like?<./q> ";
    glob.converseAboutGame();
    glob.vd2InitialQuip = self;
  }
  reply2 {
    "<p><.q>Yes, this is all very interesting,<./q> 
        says Diane, <.q>but enough talk already! 
        I say we get out of this building now, 
        while we still can!<./q>
      <p><.q>Good idea,<./q> says Vicki. 
        <.q>Now that you mention it, I think
        we<./s>re ready to go whenever you are,
        <<me.firstName>>.<./q> ";
  }
  options = [
     vd2Disliked
    ,vd2Liked
  ]
  killZ = true
  qOff = [vd2Finished, vd2Killed]
  qOn = [vd2Now]
;
vd2Now: Quip
  desc {
    considerMakingPrisonersMorePatient();
    "<.q>So, what should we do now?<./q> ";
  }
  reply {
    "<.q>So, what should we do now?<./q> you ask. ";
    "<p><.q>Hmm,<./q> says Diane. <.q>Maybe, uh, 
        get out of here?<./q>
      <p><.q>I<./s>m with Diane,<./q> says Vicki. 
        <.q>There<./s>s got to be an exit out of this place, 
        and from what we<./s>ve overheard from the guards, 
        it sounds like the exit might be north of here.<./q> ";
  }
  //isOn = nil
  qOff = [vd2Now]
  qOn = [vd2Later]
;
vd2Later: Quip
  desc {
    "<.q>What I meant to say is, what should we do
      after we escape this place?<./q> ";
  }
  reply {
    considerMakingPrisonersMorePatient();
    "<.q>What I meant to say is, what should we do
        after we escape this place?<./q> you say. ";
    "<p><.q>You mean <i>if</i> we escape,<./q> 
        says Diane. <.q>The odds of which 
        become smaller with each minute we spend 
        needlessly gabbing. Come on, <<me.firstName>>, 
        let<./s>s get out of here!<./q> ";
  }
  isOn = nil
  qOff = [vd2Later]
;
vd2Disliked: Quip
  desc {
    "<.q>Are you kidding me? That game sucked like 
      a bilge pump.<./q> ";
  }
  reply {
    "<.q>Are you kidding me? That game sucked like 
        a bilge pump,<./q> you say. ";
    "<p><.q>I can<./s>t say I<./s>m surprised,<./q> 
        Vicki replies. ";
    if (glob.vd2InitialQuip)
      glob.vd2InitialQuip.reply2;
  }
;
vd2Liked: Quip
  desc {
    "<.q>You know, it<./s>s funny. I didn<./s>t think the
      game was half bad.<./q> ";
  }
  reply {
    "<.q>You know, it<./s>s funny,<./q> you say. 
        <.q>I didn<./s>t think the game was half bad.<./q> ";
    "<p>Vicki<./s>s eyes widen. <.q>Wow,<./q> she says. 
        <.q>That<./s>s the most surprising thing 
        you<./s>ve told us so far.<./q> ";
    if (glob.vd2InitialQuip)
      glob.vd2InitialQuip.reply2;
  }
;




// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

// List all the guns in the game.

//DefineIAction(Guns)
//  execAction() {
//    local objList = [];
//    local classes = [Gun, GunThing];
//    local classNames = ['Gun', 'Gun'];
//    for (local a = 1; a <= classes.length; a++) {
//      for (local cur = firstObj(classes[a]); cur != nil; 
//          cur = nextObj(cur, classes[a])) {
//        if (!objList.indexOf(cur))
//          objList += cur;
//      }
//    }
//    "<table border=\"0\">";
//    for (local a = 1; a <= objList.length; a++) {
//      "<tr><td><<objList[a].name>></td>";
//      for (local b = 1; b <= classes.length; b++) {
//        "<td>";
//        "<<objList[a].ofKind(classes[b]) ? classNames[b] : 'nah'>>";
//        "</td>";
//      }
//      "</tr>";
//    }
//    "</table>";
//  }
//;
//
//VerbRule(Guns)
//  'guns'
//  : GunsAction
//  verbPhrase = 'display/displaying gun info'
//;

DefineIAction(Genocide)
  execAction {
    local yeah = nil;
    if (gPlayerChar == me && glob.isInEndgame) {
      if (     neton.realLocation) {      neton.moveInto(nil); yeah = true; }
      if (      ovan.realLocation) {       ovan.moveInto(nil); yeah = true; }
      if (  oldGuard.realLocation) {   oldGuard.moveInto(nil); yeah = true; }
      if (youngGuard.realLocation) { youngGuard.moveInto(nil); yeah = true; }
      if ( assistant.realLocation) {  assistant.moveInto(nil); yeah = true; }
      if (yeah)
        "Genocide accomplished. ";
      else
        "Unable to accomplish genocide. ";
    }
    "Can<./s>t do genocide here. ";
  }
;

VerbRule(Genocide)
  'genocide'
  : GenocideAction
  verbPhrase = 'genocide/genociding'
;

DefineIAction(Bloof)
  execAction() {
    //mainReport('Okay, you bloof. ');
    for (local cur = firstObj(Satiating); cur != nil; 
         cur = nextObj(cur, Satiating)) {
      if (cur.tastiness >= 1) {
        "<p><.q>Real food! I mean, he has 
            <font color=red><<cur.aFoodName>></font>!<./q>
          <p><.q>Never mind 
            <font color=red><<cur.theFoodName>></font>.<./q>
          <p><.q>I<./s>m looking at 
            <font color=red><<cur.theFoodName>></font>.
            Mmm, <font color=red><<cur.foodName>></font>.<./q>
          <p>The person seizes <font color=red><<cur.theFoodName>></font>
            and sandwich.
          <p>The person seizes the sandwich and 
            <font color=red><<cur.foodName>></font>.
          <p><.q>Here,<./q> the person says to her, handing her
            <font color=red><<cur.theFoodName>></font>.
          <p>The first person 
            <font color=red><<cur.devoursPhrase>></font>.
          <p>The second person, for her part,
            <font color=red><<cur.scarfsPhrase>></font>.
          <p>As an act of beginning to eat, the first person
            <font color=red><<cur.beginsToDevourPhrase>></font>.
          <p>After receiving what's left of the food item in question, the second person
            <font color=red><<cur.finishesDevouringPhrase>></font>. ";
        inputManager.getKey(nil, nil);
        "<hr>";
      }
    }
  }
;
VerbRule(Bloof)
  'bloof'
  : BloofAction
  verbPhrase = 'bloof/bloofing'
;

//DefineIAction(Scoof)
//  execAction() {
//    gPlayerChar.calculatePossessions;
//    mainReport('Okay, possession stuff is calculated. ');
//  }
//;
//VerbRule(Scoof)
//  'scoof'
//  : ScoofAction
//  verbPhrase = 'scoof/scoofing'
//;
DefineIAction(Scoof)
  execAction() {
    //local origin;
    local movePlace;
    local itemList = [
       coat
      ,silkCape
      //,greenJacket
      //,yellowJacket
      //,beigeJacket
      //,youngGuardUniform
      //,oldGuardUniform
      
      ,shotgun
      ,laser
      //,tRemovingGun
      //,removingGun
      ,oldGuardHandCannon
      ,youngGuardHandCannon
      ,phaser
      ,handgun
      ,aryUng
      ,pulseGun
      //,electricPistol
      //,blaster
      //,rayGun
      
      ,foodCube
      ,brats
      ,mutton
      ,steak
      ,beets
      ,bakedBeans
      ,chocolaeSyrup
      ,chocolateSyrup
      ,lemon
      ,melon
      ,oatCracker
      ,oaCracker
      ,roasBeefSandwich
      ,carroCake
      ,friedEgg
      ,torte
      ,taco
      ,roastBeefSandwich
      ,carrotCake
      ,milkChocolate
      ,iceCreamBar
      ,tableSalt
      
      ,truffles
      ,ruffles
      ,specialK
      ,minestroneSoup
      ,minesroneSoup
      ,chickenNoodleSoup
      ,clamChowder
      
      ,sake
      ,bitters
      ,vegetableOil
      ,vegeableOil
      ,dietPepsi
      ,chocolateMilk
      ,chocolaeMilk
      
      ,conicalFlask
      ,roundFlask
      ,tallBottle
      ,wideBottle
      ,shortBottle
      ,narrowBottle
      ,largeGlass
      ,smallGlass
      ,greenBag
      ,blueBag
      ,redBowl
      ,pinkBowl
      ,yellowBowl
      ,orangeBowl
      
      ,upperFridgeDrawer
      ,lowerFridgeDrawer
      ,upperFridgeShelf
      ,lowerFridgeShelf
      
      //,ovanPda
      //,cryoPapers
      //,netonBooks
      ,pad
      ,explosive
      ,xenite
      ,shogun
      ,certificate
      ,ceramicBear
      ,tiedPipes
      ,ore
      ,stake
      ,bras
      ,woodenStick
      
      ,assisan
      ,greenJacke
      ,yellowJacke
      ,beigeJacke
      ,cellOile
      ,bathOile
      ,milkChocolae
      ,seak
      ,aco
      ,coa
      ,cerificae
      ,wideBole
      ,shorBole
      ,narrowBole
      ,woodenSick
      ,elecricPisol
      ,xenie
      ,blaser
    ];
    "Scoof, then. ";
    movePlace = hallway4;
    if (!vicki.isIn(cell) || !diane.isIn(cell)) {
      vicki.moveIntoForTravel(cell);
      diane.moveIntoForTravel(cell);
    }
    //origin = gPlayerChar.location;
    if (gPlayerChar.posture == standing)
      gPlayerChar.makePosture(standing);
    if (!gPlayerChar.isIn(movePlace))
      gPlayerChar.moveIntoForTravel(movePlace);
    if (gPlayerChar.location) {
      gPlayerChar.location.enteringRoom(gPlayerChar);
      //gPlayerChar.location.travelerArriving(gPlayerChar, origin, nil, nil);
    }
    //nestedAction(Look);
    if (cellDoor.isOpen)
      cellDoor.makeOpen(nil);
    if (cellDoor.isLocked)
      cellDoor.makeLocked(nil);
    cellDoor.holdsPrisoners = true;
    if (!upperFridgeDrawer.isIn(movePlace)) upperFridgeDrawer.baseMoveInto(movePlace);
    if (!lowerFridgeDrawer.isIn(movePlace)) lowerFridgeDrawer.baseMoveInto(movePlace);
    if (!upperFridgeShelf.isIn(movePlace)) upperFridgeShelf.baseMoveInto(movePlace);
    if (!lowerFridgeShelf.isIn(movePlace)) lowerFridgeShelf.baseMoveInto(movePlace);
    for (local a = 1; a <= itemList.length; a++) {
      if (!itemList[a].isIn(movePlace))
        itemList[a].baseMoveInto(movePlace);
      if (itemList[a].isWorn)
        itemList[a].makeWornBy(nil);
    }
    nbmBanner.updateMe;
  }
;
VerbRule(Scoof)
  'scoof' | 'sc' | 'sf'
  : ScoofAction
  verbPhrase = 'scoof/scoofing'
;

DefineIAction(KludgeStrings)
  execAction() {
    if (glob.doKludgeStrings) {
      "Okay, glob.doKludgeStrings is now set to nil. ";
      glob.doKludgeStrings = nil;
    }
    else {
      "Okay, glob.doKludgeStrings is now set to true. ";
      glob.doKludgeStrings = true;
    }
  }
;
VerbRule(KludgeStrings)
  'kstrings'
  : KludgeStringsAction
  verbPhrase = 'turn/turning kludge strings off'
;


#endif // __DEBUG
