#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// ###############################################################################
// ###############################################################################
// NOTE TO SELF FOR FUTURE VERSIONS
// ###############################################################################
// ###############################################################################

// NOTE TO SELF: CONSIDER THE FOLLOWING FOR FUTURE VERSIONS:
// populate glob.authorEmail if my email changes
// don't forget to change versionInfo.version for future versions
// don't forget to include the resources listed below under "additional resources to include"
// make sure glob.beginWithDebuggingMenu = nil

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// NOTE TO READER
// MAKEFILE DETAILS
// PRELIMINARIES: versionInfo, gameMain
// PRELIMINARIES: glob and transientGlob objects
// PRELIMINARIES: Misc. stuff
// PRELIMINARIES: "Action Fuse" stuff
// PRELIMINARIES: exitLister settings
// PRELIMINARIES: end-of-game stuff
// PRELIMINARIES: finish options
// PRELIMINARIES: font face modifications: (Verdana, Courier, etc.)
// PRELIMINARIES: statusLine modifications
// PRELIMINARIES: new scripts
// PRELIMINARIES: exitLister modifications [commented out]
// PRELIMINARIES: Room & RoomPart modifications
// PLAYER CHARACTER STUFF: Gary Randall -- i.e., "me"
// PLAYER CHARACTER STUFF: Gary Randall's clothing
// PLAYER CHARACTER STUFF: miscellaneous stuff for all PCs
// EXTENSION MODIFICATIONS: ncDebugActions.t
// EXTENSION MODIFICATIONS: ncYesNo.t
// EXTENSION MODIFICATIONS: msg_custom.t
// EXTENSION MODIFICATIONS: autosave.t
// EXTENSION MODIFICATIONS: qtalk.t
// MESSAGE SUBSTITUTION PARAMETER MODIFICATIONS
// MESSAGE MODIFICATIONS (due to personal taste)
// MAIN BANNER STUFF -- OLD SYSTEM
// MAIN BANNER STUFF -- NEW SYSTEM
// MAIN BANNER STUFF
// DEBUG STUFF
// NOTES

// -------------------------------------------------------------------
// NOTE TO READER
// -------------------------------------------------------------------

// REGARDING THE QUALITY OF THIS SOURCE CODE:
// 
// I've often found it extremely helpful to look at the source code 
// of TADS 3 games, even if such code is full of kludges, is badly 
// commented, or just plain sucks in various ways that aren't evident 
// to players.
// 
// In that spirit, I am releasing the source code to Nothing but
// Mazes, even though the code sucks in a lot of ways. 
// 
// Most of the code of Nothing but Mazes was written around 2006-07, 
// back when I had only just recently learned what object oriented 
// programming was, and was just learning TADS 3.
// 
// Hope you enjoy the source code of this game!
// 
// Greg Boettcher

// -------------------------------------------------------------------
// COMPILATION DETAILS: BASIC MAKEFILE
// -------------------------------------------------------------------

// Note to reader:

// This tells you the order of inclusion of my *.t files.
// This does not include external resources such as the image files
// that make up the numerous interactive maps.

/*

# TADS 3 makefile
#
# Warning: this file was mechanically generated.  You may edit this file
# manually, but your changes might be modified or discarded when
# you load this file into a TADS development tool.  The TADS tools
# generally retain the comment at the start of the file and the
# comment marked "##sources" below, but other comments might be
# discarded, the formatting might be changed, and some option
# settings might be modified.

-pre
-D LANGUAGE=en_us
-D MESSAGESTYLE=neu
-D INSTRUCTIONS_MENU=true
-U __TESTING=true
-Fy obj
-Fo obj
-v
-w1

##sources
-lib system
-lib adv3/adv3
-lib autosave/autosave
-source msg_custom
-source 1msg_mazes
-source qtalk
-source qtalkverbs
-source ncDebugActions
-source ncYesNo
-source achievement
-source 1mazes
-source 1actions
-source 1coffin
-source 1npcs
-source 1conf
-source 1cell
-source 1vr
-source 2animals
-source 2bookmovie
-source 2floor
-source 2nations
-source 2pyramid
-source 2quat
-source 2supermaze
-source 2twisty
-source 2hacman
-source 3argument
-source 3endgame
-source 3extreme
-source 3npcs
-source 3guns
-source 3endmap

-res
GameInfo.txt
*/

// -------------------------------------------------------------------
// COMPILATION DETAILS: ADDITIONAL RESOURCES TO INCLUDE
// -------------------------------------------------------------------

// Note to readers:
// This section pertains to multimedia resources that I do not currently intend 
// to release to the public. These multimedia resources should not be necessary 
// for you to be able to take the released source code and compile a runnable version
// of Nothing but Mazes.

// Note to self:
// The following resources need to be added before each release. They also
// generally need to be removed from the .t3m file before doing any substantial 
// modifications, as they cause the TADS 3 Workbench to load very slowly. 

/*
The following folders of multimedia content need to be added to each release:

africa
animals
bkmv
compass
endgame
escape
floor
hacman
illustrations
mexico
pyr1
pyr2
pyr3
pyr4
quat1
quat2
sound
supmaze
text
twisty

autosave is NOT needed as a resource. It's source code, not a resource. 
debug    is NOT needed as a resource
obj      is NOT needed as a resource
Scripts  is NOT needed as a resource
web      is NOT needed as a resource
zzz_misc is NOT needed as a resource. It's my miscellaneous stuff.

To state the obvious, these are not needed as resources either:
*/

// -------------------------------------------------------------------
// PRELIMINARIES: versionInfo, gameMain
// -------------------------------------------------------------------

versionInfo: GameID
  name        = 'Nothing but Mazes'
  byline      = 'by Greg Boettcher'
  htmlByLine  = 'by Greg Boettcher'
  htmlByline  = 'by <a href="mailto:' + glob.authorEmail + '">Greg Boettcher</a>'
  
  version     = '2.0: Full version (20190812) '
  // I am using versionWithLineBreaks in ABOUTBOX. Nothing else uses versionWithLineBreaks.
  // This is a kludge, but whatever.
  versionWithLineBreaks {
    local str = version;
    str = str.findReplace(': ', ': \n', ReplaceAll);
    str = str.findReplace(' (', ' \n(', ReplaceAll);
    return str;
  }
  authorEmail = 'Greg Boettcher <' + glob.authorEmail + '>'
  desc        = 'The year is 2189. 
                  Nuclear war has ravaged the earth.
                  Most of humanity has been wiped out.
                  But for two aliens named Neton and Ovan,
                  there\'s an even bigger problem. 
                  And they need you to help.'
  htmlDesc    = 'The year is 2189.
                  Nuclear war has ravaged the earth. 
                  Most of humanity has been wiped out.
                  But for two aliens named Neton and Ovan,
                  there&rsquo;s an even bigger problem. 
                  And they need you to help.'
  //presentationProfile = 'Multimedia' // the default. You could try changing to 'Plain Text', 'Multimedia'
  //licenseType = 'Freeware' // Default. Other types include 'Public Domain', 'Shareware', 'Commercial Demo', 'Commercial', or 'Other'
  //copyingRules = 'Nominal cost only; compilations allowed' // Default. Other types include Prohibited, No Restrictions, No-Cost  Only, At-Cost Only, and Other
  copyingRules = 'No-cost only; compilations prohibited'
  
  gameUrl = 'http://www.gregboettcher.com/mazes/'
  firstPublished = '2019'
  languageCode = 'en-US'
  
  // This has been obviated by the about/credits/instructions/hints menu
  showCredit() { }
  // Ditto
  showAbout() { }
;

/*
      //"To play this game, you need an 
      //    interpreter that can (a) display graphics and
      //    (b) play TADS 3 games of version <<moduleAdv3.version>>.
      //    Sadly, as of January 2009, there are only
      //    two such interpreters: (1) the HTML TADS
      //    Player's Kit for Windows, and (2)
      //    HyperTADS for Mac OS 9.
      //  <p>The Player Kit for Windows is available here:
      //    <br>http://www.tads.org/tads3.htm#downloads
      //  <p>HyperTADS (only for Mac OS 9; cannot be used on 
      //  <p>Why do you need a graphical interpreter?
      //    This game contains graphics, and it is absolutely
      //    impossible to win this game unless you can see
      //    the graphics. 
      //  <p>Non-Windows users are not necessarily out of luck,
      //    however. Some people have reported success at
      //    playing this game under an emulator or similar
      //    software. Please see the accompanying file,
      //    mazes_readme.txt, for more details.
      //  <p>If you need assistance, feel free to email me. ";
*/
/*
      "You cannot play the game with this interpreter. 
          To play this game, you need one of the following:
        \b(1) A *graphical* interpreter to run this .t3 file. 
          There are two of these:
        \b- For Windows: You can run this .t3 file using 
          the HTML TADS Player Kit. Download it from: 
          http://www.tads.org/tads3.htm#downloads
        \n- For Mac OS 9 (not for Intel-based Macs): 
          You can run this .t3 file using HyperTADS. 
          Download it from: http://www.hypertads.org/
        \b(2) Or, if you have a way of running Windows 
          .exe files, you can download the .exe version 
          of this game from: 
          http://www.gregboettcher.com/mazes/
        \b- On Windows, you can simply run the .exe file.
        \n- On Linux, it is reportedly easy to run the 
          .exe version of this game using Wine: 
          http://www.winehq.org/
        \n- On Mac OS X, FreeBSD, and Solaris, you can try 
          using Wine as well, though I've received no reports 
          as to how easy this is: http://www.winehq.org/
        \n- On any other system, you will only be able 
          to play this game if you can find a Windows emulator 
          for your system. Sorry, but there's nothing I can do.
        \bAre graphics really necessary for this game? 
          Yes. It is absolutely impossible to win this game 
          unless you can see its graphics. 
          For more information, visit my site or email me.
        \bhttp://www.gregboettcher.com/mazes/ ";
*/

gameMain: GameMainDef
  initialPlayerChar = me
  showIntro() {
    local troubleWithGraphics = nil;
    if (systemInfo(SysInfoInterpClass) != SysInfoIClassHTML)
      troubleWithGraphics = true;
    if (troubleWithGraphics && glob.blockBadTerps) {
      "You cannot play the game with this interpreter. To play this game, 
          you need a *full multimedia* interpreter for HTML TADS, 
          such as the following: \b";
      "- TADS Player Kit (Windows): 
          http://www.tads.org/tads3.htm \n";
      "- QTADS (Linux, Mac OS X, etc.): 
          http://qtads.sourceforge.net/ \n";
      "- CocoaTADS (Mac OS X): 
          http://www.charlessoft.com/ \b";
      "Many thanks to Mike Roberts, Nikos Chantziaras, and Charles Srstka, 
          respectively, for writing the above software. \b";
      "Are graphics really necessary for this game? Yes. 
          It is absolutely impossible to win this game unless you can see 
          its graphics. For more information, visit my site or email me: \n";
      "<<versionInfo.gameUrl>> \n";
      "<<glob.authorEmail>>\n";
      inputManager.getKey(nil, nil);
      throw new QuittingException;
    }
    // The artifacts in the museum are set up so that I can change
    // their locations easily. Deal with the consequences of this
    // now.
    initArtLocations();
    if (glob.changeFont) "<.nbmfont>";
    if (glob.changeColors) "<.nbmcolors>";
    
//    // This next part is a big deal. The game begins in an entirely 
//    // different way when debugging vs. when not debugging.
//    #ifdef __DEBUG
//      // If debugging, begin with a menu that gives the player a choice
//      // of what part of the game to debug. The menu is constructed
//      // using my extension, qtalk.t.
//      maybeNbmCls(RestartAction);
//      startMenu.select;
//    #endif
//    #ifndef __DEBUG
//      // If not debugging, just begin normally. Note that this is
//      // precisely the same as selecting option 1 from the aforementioned
//      // menu, so this, too, requires my qtalk.t extension.
//      goToIntro.execute;
//    #endif
    
    // We want to retrieve the achievement-scope data before we 
    // do the menu
    achievementScopeManager.loadData();
    
    #ifdef __DEBUG
      glob.beginWithDebuggingMenu = true;
    #endif
    if (glob.beginWithDebuggingMenu) {
      // If debugging, begin with a menu that gives the player a choice
      // of what part of the game to debug. The menu is constructed
      // using my extension, qtalk.t.
      maybeNbmCls(RestartAction);
      startMenu.select;
    }
    else {
      // If not debugging, just begin normally. Note that this is
      // precisely the same as selecting option 1 from the aforementioned
      // menu, so this, too, requires my qtalk.t extension.
      goToIntro.execute;
    }
  }
  setAboutBox() {
    "<ABOUTBOX>";
    "<body bgcolor=silver>";
    
    glob.rememberedFont = glob.font;
    glob.font = verdana;
    "<.nbmfont>";
    
    "<center>";
    "<table>";
    " <tr>";
    "  <td width=\"215\">";
    "   <p><font size=\"4\"><b>Nothing but Mazes</b></font>";
    "   <p><font size=\"3\">by Greg Boettcher</font>";
    "   <p><font size=\"2\">Version <<versionInfo.versionWithLineBreaks>></font>";
    "  </td>";
    "  <td width=\"215\"><img src=\"illustrations/mazestitle215.png\" width=\"215\" height=\"215\" ></td>";
    " </tr>";
    "</table>";
    "</center>";
    "</ABOUTBOX>";
    
    glob.font = glob.rememberedFont;
    
    /*
    "<ABOUTBOX>";
    glob.rememberedFont = glob.font;
    glob.font = verdana;
    "<.nbmfont>";
    if (glob.changeFont) "<.nbmfont>";
    "<CENTER>";
    "<body bgcolor=silver>";
    "&nbsp;
      <p><font size=\"5\"><b>Nothing but Mazes</b></font>
      <p>by Greg Boettcher
      <p>Version <<versionInfo.versionWithLineBreaks>>
      </CENTER>";
    "</ABOUTBOX>";
    glob.font = glob.rememberedFont;
    */
  }
  showExitsInStatusline = nil
  allowYouMeMixing = nil
  allVerbsAllowAll = nil // Default is true. When set to nil, only basic inventory management verbs allow all.
  //maxScore() { } Can override this, although TADS 3 comes with a way of automatically calculating the maximum score.
  //scoreRankTable = nil // See the I Must Play source code for an example of how to do a score rank table.
  //showGoodbye() { "<.p>Thanks for playing!\b"; }
  //newGame() { } There should be no reason to override this. Square Circle didn't.
  //restoreAndRunGame() { } Override if you want to provide for the "restore at startup because user clicked on saved game" scenario.
  //setGameTitle() { } Title of window.
  //filterPluralMatches = true // set this to nil to override TADS 3's capability of ruling out the illogical when dealing with plural phrases.
;

// -------------------------------------------------------------------
// PRELIMINARIES: Misc. stuff
// -------------------------------------------------------------------

// ---------------------------
// This "glob" object will be modified throughout my code to store 
// all my game's pseudo-global variables.

glob: object
  beginWithDebuggingMenu = nil
  authorEmail = 'paradoxgreg@gmail.com'
;

// ---------------------------
// Ditto with this for variables that need to be remembered 
// throughout a play session, irrespective of whether, e.g., 
// the player has typed RESTART.

transient transientGlob: object
;


// ---------------------------
// To ensure splash image is only shown once, and not after RESTART.

modify transientGlob
  sessionBegun = nil
;

// ---------------------------
// playSound: a function to make it easier to standardize the way sound 
// is played. 
// soundTag is a parameter that either takes the form of 
// 'sound/alien.mp3' (a relative path to the sound file)
// or else
// '<sound src=\"sound/alien.mp3\" layer=foreground>' (the complete sound tag)
// 
// As a developer who has easy access only to a Windows playform, I don't 
// know if I have the ability to easily test whether the try/catch here does 
// any good. But it seemed like a good idea just in case.

function playSound(soundTag) {
  
  soundTag = trimString(soundTag);
  if (!soundTag.startsWith('<sound') || !soundTag.endsWith('>')) {
    soundTag = '<sound src=\"' + soundTag + '\" layer=foreground>';
  }
  
  try {
    if (glob.musicOn) {
      "<<soundTag>>";
    }
  }
  catch (Exception ex) {
    // If trying to play the sound produces an exception that we can catch, 
    // ignore the exception and move on.
  }
}

// ---------------------------
// trimString(str): trim the leading and trailing spaces from a string.
function trimString(str) {
  while (str.startsWith(' ')) {
    str = str.substr(2);
  }
  while (str.endsWith(' ')) {
    str = str.substr(1, -1);
  }
  return str;
}



// ---------------------------
// To deal with non-HTML-enabled 'terps

modify glob
  // Disallow non-HTML-enabled interpreters from running the game?
  blockBadTerps = true
;

// If during debugging I select the initial option 
// "Go to endgame with daemons," then I want the endgame daemon 
// to run once before the player even has the chance to take one turn.
// 
// This is a pretty unusual thing to want to do. As far as I can tell,
// the easiest way to accomplish it is to hack runGame().
modify runGame(look) {
  if (look) {
    withActionEnv(EventAction, gPlayerChar,
                  {: gPlayerChar.lookAround(true) });
  }
  
  // BEGIN HACK
  if (endgameDaemon.daemonID != nil)
    endgameDaemon.daemon;
  // END HACK
  
  runScheduler();
}

// ---------------------------
// To prevent an awkward "Unknown exception" error when I throw 
// a Quitting Exception during gameMain.showIntro().
// Mike Roberts devised this solution for me in answering
// my question on raif. Thanks, Mike.

modify main(args) {
  try {
    replaced(args);
  }
  catch (QuittingException q) { }
}

// ---------------------------
// To get rid of the "oops" note.

//modify libMessages
//  offerOopsNote = nil
//;

modify libMessages
  oopsNote() { }
;

#ifdef standardLibMessages
modify standardLibMessages
  oopsNote() { }
;
#endif // standardLibMessages

// ---------------------------
// Debugging stuff which is not used and could, I supposed, be
// deleted.

//daemonObj: Component
//  location = me
//  daemonID = nil
//  startDaemon {
//    daemonID = new Daemon(self, &daemon, 1);
//  }
//  daemon {
//    "<.p>Daemon running. ";
//  }
//  endDaemon {
//    if (daemonID != nil) daemonID.removeEvent;
//    daemonID = nil;
//  }
//;

// ---------------------------
// nbmCls(), maybeNbmCls(), nbmPause(), and gKey()

// The main purpose of nbmCls() is to make sure the font and colors
// are changed after clearing the screen.

nbmCls() {
  // We need a paragraph break before we clear the screen, because
  // otherwise the transcript will look weird.
  "<.p>";
  cls();
  if (glob.changeFont) "<.nbmfont>";
  if (glob.changeColors) "<.nbmcolors>";
}

// Do we want to do nbmCls() in various scenarios? I want to be
// able to change my mind on this, so I have set up the following
// function.

maybeNbmCls(action) {
  if (actionRequiresCls(action)) {
    nbmCls();
    reportMaybeNbmCls('');
  }
}

actionRequiresCls(action) {
  switch(action) {
    case UndoAction   : return nil;
    case RestoreAction: return true;
    case RetryAction  : return true;
    case RestartAction: return true;
    case ResetAction  : return true;
    case EscapeAction : return true;
    case StopAction   : return true;
    case BeginAction  : return true;
    default           : return nil;
  }
}

/*
// ---------------------------------
// COMMENTS ON INNER-GAME META-VERBS

         Assc.                           Assc.
Name of  old                             new
command  command  Outer? 1 2 Inner? 3 4  command(s)
SAVE     -         YES   - -  YES   - -  - 
RESTORE  -         YES   Y Y  YES   Y Y  - 
UNDO     -         YES   Y Y  YES   Y Y  - 
QUIT     -         YES   Y Y  YES   - Y  ESCAPE, STOP
RESTART  -         YES   Y Y  YES   - Y  RESET, BEGIN
ESCAPE   QUIT       -    - -  YES   - -  - 
STOP     QUIT       -    - -  YES   Y Y  - 
RESET    RESTART    -    - -  YES   - -  - 
BEGIN    RESTART    -    - -  YES   Y Y  - 

1 = In outer game, is action listed after "game over"?
2 = In outer game, is action possible after "game over"?
3 = In inner game, is action listed after "game over"?
4 = In inner game, is action possible after "game over"?
*/

/*
maybeNbmCls(action) {
  switch(action) {
    case UndoAction   : return;
    case RestoreAction: nbmCls(); reportMaybeNbmCls('RestoreAction'); return;
    case RetryAction  : nbmCls(); reportMaybeNbmCls('RetryAction  '); return;
    case RestartAction: return; //nbmCls(); reportMaybeNbmCls('RestartAction'); return;
    
    case EscapeAction : nbmCls(); reportMaybeNbmCls('EscapeAction '); return;
    case StopAction   : nbmCls(); reportMaybeNbmCls('StopAction   '); return;
    case ResetAction  : nbmCls(); reportMaybeNbmCls('ResetAction  '); return;
    case BeginAction  : nbmCls(); reportMaybeNbmCls('BeginAction  '); return;
    default           : nbmCls(); reportMaybeNbmCls('default      '); return;
  }
}
*/

reportMaybeNbmCls(str) {
  //pleaseSay('<font color=red>nbmCls()</font><.p>'); 
}

// If I want to change all instances of inputManager.pauseForMore(true)
// to inputManager.getKey(nil, nil), I can do it here.

nbmPause() {
  inputManager.pauseForMore(true);
}

gKey() {
  if (inputManager.getKey(nil, nil).toLower == 'q')
    return 'q';
  else
    return nil;
  
  //return inputManager.getKey(nil, nil);
  
  //local k = inputManager.getKey(nil, nil);
  //// If the user types Q, deliberately cause a run-time error.
  //if (k.toLower == 'q') {
  //  k = 0;
  //  k = k / k;
  //}
  //return nil;
}

// ---------------------------
// General-purpose style tags

dquoStyleTag: StyleTag 'q'
  openText  = '&ldquo;'
  closeText = '&rdquo;'
;

//squoStyleTag: StyleTag 'sq'
//  openText  = '&lsquo;'
//  closeText = '&rsquo;'
//;

squoStyleTag: StyleTag 's'
  openText  = '&lsquo;'
  closeText = '&rsquo;'
;

// ---------------------------
// verboseModeIsOn()

verboseModeIsOn() {
#ifdef TADS308
  return gameMain.verboseMode;
#else
  return gameMain.verboseMode.isOn;
#endif
}

// ---------------------------
// cancelPendingCommands()

// This is awkward because it's based on the condition
// (gAction.ofKind(EventAction)). That's probably not 
// a good universal determining factor, but it seems to work
// in all relevant cases in this game.
cancelPendingCommands() {
  //// Cancel any pending commands
  //gPlayerChar.pendingCommand = [];
  if (gAction.ofKind(EventAction))
    gPlayerChar.pendingCommand = new Vector(5);
  else
    throw new TerminateCommandException();
}

// -------------------------------------------------------------------
// PRELIMINARIES: "Action Fuse" stuff
// -------------------------------------------------------------------

// Begin comments written in March 2007:
// 
// This "action fuse" stuff was written a long time ago, and apparently
// isn't used anywhere else in my code. I am a little hazy about why
// I wrote it, but I believe my intention was to create a system whereby, 
// for example, if an NPC screams, you could then write an action fuse 
// so that if the player typed "listen" during the next turn (and only 
// during the next turn), then it would give an appropriate response
// about the scream echoing around the room. (I'm well aware that there
// are supposed to be other TADS 3 ways of handling this, but I regard
// TADS 3's system of sensation to be unnecessarily complicated, and I
// intend to avoid learning it if I possibly can.)
// 
// At any rate, the following is apparently not used anywhere in my code,
// but here it is anyway.

// Begin comments which must have been written in 2005 or 2006:
// 
// This "action fuse" idea is inspired by ncYesNo.t by Nikos Chantziaras
// and steals a large amount of its code from that.
// 
// Theoretically I could have more than one action fuse going at a time,
// so allow for that. I don't know if one can very easily do something like...
//   new ActionFuse(Listen, 'You hear footsteps. ');
// ... but since I don't feel all that comfortable with dynamic objects,
// I decided not to experiment with this. Therefore, what follows 
// is a different, kludgier solution, utilizing the "successor" property.

modify Actor
  beforeAction() {
    if (self == gPlayerChar && gActor == gPlayerChar) {
      if (actionFuse4.isActive && gAction.ofKind(actionFuse4.myAction)) {
        actionFuse4.doResponse;
        exit;
      }
      if (actionFuse3.isActive && gAction.ofKind(actionFuse3.myAction)) {
        actionFuse3.doResponse;
        exit;
      }
      if (actionFuse2.isActive && gAction.ofKind(actionFuse2.myAction)) {
        actionFuse2.doResponse;
        exit;
      }
      if (actionFuse.isActive && gAction.ofKind(actionFuse.myAction)) {
        actionFuse.doResponse;
        exit;
      }
    }
    inherited();
  }
;

class BaseActionFuse: object {
  doResponse {
    if (!myResponse)
      { }
    else if (dataType(myResponse) == TypeSString)
      say(myResponse);
    else
      (myResponse)();
  }
  set(action, resp, [args]) {
    local dur;
    if (args && args.length > 0)
      dur = args[1];
    // Ignore any remaining args.
    
    if (isActive) {
      successor.set(action, resp, dur);
    }
    else { // this fuse is inactive, so go ahead and use it.
      
      // if dur is unspecified, set it to a duration of 1 turn.
      // For that matter, if dur is specified as 0, change it to 1,
      // as 0 will never be a useful value.
      if (!dur) dur = 1;
      
      myAction = action;
      myResponse = resp;
      isActive = true;
      myFuse = new Fuse(self, &reset, dur);
    }
  }
  reset() {
    if (isActive) {
      myAction = nil;
      myResponse = nil;
      isActive = nil;
      myFuse = nil;
    }
  }
  isActive = nil
  myAction = nil
  myResponse = nil
  myFuse = nil
  successor = nil // override
}

actionFuse : BaseActionFuse successor = actionFuse2;
actionFuse2: BaseActionFuse successor = actionFuse3;
actionFuse3: BaseActionFuse successor = actionFuse4;
actionFuse4: BaseActionFuse successor = actionFuse5;
actionFuse5: object
  set(action, resp, [args]) { }
;

// -------------------------------------------------------------------
// PRELIMINARIES: exitLister settings
// -------------------------------------------------------------------

// We want to change the default settings for when exits are listed, 
// both for the status line and for room descriptions.

modify exitsMode
  inRoomDesc = nil
  inStatusLine = nil
;

modify glob
  exitsPreviouslyInRoomDesc = nil
  exitsPreviouslyInStatus = nil
;

storeExitSettings() {
  glob.exitsPreviouslyInRoomDesc = exitsMode.inRoomDesc;
  glob.exitsPreviouslyInStatus = exitsMode.inStatusLine;
  exitsMode.inRoomDesc = nil;
  exitsMode.inStatusLine = nil;
}
retrieveExitSettings() {
  exitsMode.inRoomDesc = glob.exitsPreviouslyInRoomDesc;
  exitsMode.inStatusLine = glob.exitsPreviouslyInStatus;
  glob.exitsPreviouslyInRoomDesc = nil;
  glob.exitsPreviouslyInStatus = nil;
}


// -------------------------------------------------------------------
// PRELIMINARIES: end-of-game stuff
// -------------------------------------------------------------------

modify FinishType
  isWinningEnding = nil
;

ftScottAdams: FinishType finishMsg=&finishScottAdamsMsg;
ftTwisty    : FinishType finishMsg=&finishTwistyMsg;
ftIntro     : FinishType finishMsg=&finishIntroMsg
  isWinningEnding = true
;
modify ftVictory
  isWinningEnding = true
;
// This is the ending you get if you "win" the game without
// rescuing Vicki and Diane.
ftEscape: FinishType
  finishMsg = 'You have escaped'
  // After giving it some thought, I've decided that if you 
  // don't rescue Vicki and Diane, you shouldn't get 
  // AMUSING in the options at game end.
  //isWinningEnding = true
;


modify libMessages
  showFinishMsg(msg) {
    "\b\b<center>";          // "<big>";
    "<b>*** <<msg>>\ ***</b>"; // "</big>";
    "</center>\b\b";
  }
  finishDeathMsg() { return '\^' + gPlayerChar.theName + ' ' 
                          + gPlayerChar.verbToHave + ' died'; }
  finishVictoryMsg    = 'You have won'
  finishFailureMsg    = 'You have failed'
  finishGameOverMsg   = 'Game over'
  finishScottAdamsMsg = 'ADVENTURE over'
  finishTwistyMsg     = 'You have entered a maze of twisty 
                          little passages, all alike'
  finishIntroMsg      = 'You have successfully completed the intro'
;

// This endGame() function brought to you by Eric Eve. I have modified 
// his code a bit, though.

function endGame(ft) {
  //if (gPlayerChar == 
  // later, maybe add finishOptionFullScore
  //local k=0;k=k/k;
  glob.pcIsDead = true;
  //pleaseSay('Noof! Noof! ');
  nbmBanner.updateMe;
  if (ft && ft.isWinningEnding) {
    achievementTasksForVictory();
    finishGameMsg(ft, 
      [
          finishOptionUndo
        , finishOptionNbmCredits
        , finishOptionAchievements
        , finishOptionTrailer
        , finishOptionMaking
        , finishOptionFeelies
      ]
    );
  }
  else if (gPlayerChar == bot) {
    finishGameMsg(ft, [mfoUndo]);
  }
  else if (glob.isInEndgame) {
    finishGameMsg(ft, [finishOptionUndo, finishOptionAchievements, finishOptionRetry]);
  }
  else {
    finishGameMsg(ft, [finishOptionUndo, finishOptionRetry]);
  }
}

modify glob
  pcIsDead = nil
;

function scottAdamsDeath() {
  "<.odyssey>I<./s>m DEAD!\n
    I<./s>m in a lot of TROUBLE!<./odyssey> ";
  endGame(ftScottAdams);
}

// -------------------------------------------------------------------
// PRELIMINARIES: finish options
// -------------------------------------------------------------------

/*
R: Restore
S: Restart
U: Undo
A: Achievements
C: Credits
W: Artwork
T: Trailer
F: Feelies
O: Pay it forward
Q: Quit
*/

finishOptionNbmCredits: FinishOption
  desc = "view the <<aHrefAlt('credits', 'CREDITS', '<b>C</b>REDITS',
          'View the credits')>>"
  responseKeyword = 'credits'
  responseChar = 'c'
  doOption() {
    "<p><b><font size='+1'>MAIN CREDITS</font></b>
      <br><br>
      <<glob.mainCreditsText>>
      <p><b><font size='+1'>MUSIC CREDITS</font></b>
      <br><br>
      <<glob.musicCreditsText>>
      <br><br><br>
      <p><b><font size='+1'>PHOTO CREDITS</font></b>
      <p><br>
      <<glob.photoCreditsText>>
      <p><br>
      <p><b><font size='+1'>QUOTATION CREDITS</font></b>
      <br><br>
      <<glob.quotationCreditsText>>
      ";
    return true;
  }
;

finishOptionTrailer: FinishOption
  desc = "view the <<aHrefAlt('trailer', 'TRAILER', '<b>T</b>RAILER',
          'View the trailer')>>"
  responseKeyword = 'trailer'
  responseChar = 't'
  doOption() {
    "As described in the <.q>MAKING of the game<./q> segment, 
      I put in a lot of work to create a 
      three-minute YouTube trailer video for this game. 
      If you haven<./s>t watched it yet, you should! It<./s>s here:
      <br>
      <br>
      https://www.youtube.com/watch?v=tgq9ECfv504
      <br>
      <br> ";
    return true;
  }
;

finishOptionMaking: FinishOption
  desc = "read about the <<aHrefAlt('making', 'MAKING', '<b>M</b>AKING',
          'Read about the making of the game')>> of the game"
  responseKeyword = 'making'
  responseChar = 'm'
  doOption() {
    "I<./s>ve tried to keep this brief, but I<./s>ve failed. Some of you 
    are not going to read this. But some of you will, so here goes\ .\ .\ .
    <p>
    My work on this game between 2005 and 2019 says a lot 
    about the changes in my life during that period. 
    <p>
    <b>My life in 2005</b>
    <p>
    In 2005, I had a lot more time on my hands than I do now. 
    I had a degree in creative writing, but hadn<./s>t 
    written much for a few years. I didn<./s>t have a wide 
    circle of friends, suffered from social anxiety, and in fact 
    for that very reason I was making a living as a janitor. 
    <p>
    During the year or two leading up to that, I<./s>d found rec.arts.int-fiction, 
    a community of indie game developers and players. I<./s>d greatly 
    enjoyed learning game development languages including 
    Inform 6 and TADS 3. My imagination exploded and I started 
    programming. 
    <p>
    <b>Developing the game in 2005&ndash;06</b>
    <p>
    I chose TADS 3 for <i>Nothing but Mazes</i> because it seemed 
    really good at handling multimedia, as well as standard text adventure 
    functionality. And I spent a huge amount of time working 
    on the game<./s>s multimedia. 
    <p>
    Multimedia:<br>
    I remember posing for a photo, seated and holding a spoon, 
    so that later I could use that photo to paint the 
    illustration of Gary in the hospital. I remember spending 
    four whole days using Photoshop to create the 1,816 images 
    that made up the pyramid mazes. 
    <p>
    Programming:<br>
    I remember cobbling together some crazy algorithms to 
    create an implementation of Pac-Man that pretty much held 
    together, plus some weird NetHack-style combat. For the 
    end of the game, I had to model slowed-down aliens who 
    can be at different positions within the same room. 
    And a lot more; it went on and on. 
    <p>
    Writing:<br>
    I remember many hours spent writing the dialogue 
    in the conference room at the beginning of the game. 
    I got some use out of my background in creative writing, 
    I guess. When one of my testers recently spoke of my 
    <.q>deft characterization,<./q> I was happy about that. 
    <p>
    By the end of 
    December 2006, the game was mostly finished. That is, 
    it had a beginning, a middle, and an end, though the end 
    may not have been completely polished. 
    <p>
    <b>My life with Daphne Brinkerhoff</b>
    <p>
    Fairly early in my involvement in the rec.arts.int-fiction 
    game development community, I met Daphne Brinkerhoff. 
    We started a long distance relationship, until soon 
    she moved out to Wisconsin to be with me. My development 
    of <i>Nothing but Mazes</i> was largely done during that 
    first year or so that we were together. Then, in June 2007, 
    we got married. (Fast-forward to the present: 
    Daphne and I just celebrated our 12th wedding anniversary.)
    <p>
    For a picture of Daphne and me, scroll down to the bottom of this page:
    <p>
    https://gregboettcher.com/blog/the-story-of-me-part-2/
    <p>
    <b>School and career</b>
    <p>
    In 2007, Daphne went back to school for a computer science 
    degree. The following year, I decided to do the same thing. 
    For me, it was an obvious way to build on what I<./s>d learned 
    in doing game development. As a result, 2008&ndash;10 became a 
    really intense period for me, particularly during 
    fall 2009, when I took four computer science classes 
    at the same time. I<./s>m glad I<./s>ll never have to do that again. 
    <p>
    Daphne graduated in May 2010, and I graduated in December 2010. 
    We both got jobs as software developers in Minnesota<./s>s 
    Twin Cities, where we<./s>ve been living ever since. Now my job 
    was perhaps a bit more stressful, but was also more rewarding 
    and put me on a better foot financially. 
    <p>
    I intended to complete and release <i>Nothing but Mazes</i>, but 
    as a student I was way too busy to work on it, and then 
    as a professional software developer I often had a hard time 
    prioritizing it. 
    <p>
    This in itself might not have been so horrible, but with 
    hindsight, one thing ended up being a bad thing. As I focused 
    on my career as a software developer, I ended up giving up 
    all the time I<./s>d spent doing creative activities, including 
    both game development and fiction writing. 
    <p>
    <b>2017&ndash;2019</b>
    <p>
    2017 was a watershed year for me, and although 
    I can't go into the reasons why in this narrative, 
    the bottom line is that I grew up quite a bit during that year, 
    shook off some bad habits, worked at overcoming my social 
    anxiety, and&mdash;most relevant to this story&mdash;started 
    to work on creative projects again. 
    <p>
    During the period from January to July 2018, I worked on 
    the <i>Nothing but Mazes</i> trailer. Yes, it took a long time, and 
    most of those months were spent painting ten new illustrations 
    just for the trailer. From August 2018 to March 2019, 
    I went back to fiction writing in a very serious way.
    Then, from about April to 
    August 2019, I completed <i>Nothing but Mazes.</i>
    <p>
    Now that <i>Nothing but Mazes</i> is released, I<./s>m happy to let it 
    stand as my main achievement in the realm of game development. 
    It<./s>s a comedic game, and therefore in some ways not a very serious one, 
    but it<./s>s one that I<./s>m very proud of. 
    <p>
    <b>Future efforts: Fiction writing, and <i>Animal Stories</i></b>
    <p>
    For now, my plan is to get back to my original passion, 
    fiction writing. During the months of August to October 2018, 
    I wrote a short story I<./s>m really proud of. It<./s>s going to be the 
    first story in a collection called <i>Animal Stories,</i> in which the 
    first story is narrated by a single-celled organism and the 
    last story is narrated by a human being.
    <p>
    What? Does that mean the 2018 story was about a single-celled 
    organism? Yes it was, and in exploring how single-celled 
    organisms evolved into sponges, I aimed to explore how 
    human beings developed from hunter-gatherers to settlers living 
    in large cities. The story isn<./s>t published, but you can 
    read about it here:
    <p>
	https://gregboettcher.com/blog/the-writing-of-the-single-celled-organism-story/
    <p>
    I have additional stories lined up: a jellyfish story about 
    the end of the world; a cephalopod story about how 
    the ocean<./s>s first top predators evolved; and more. 
    <p>
    If this project sounds interesting to you, please consider 
    following me. I expect to give many updates about it in 
    the coming years, and if I do complete it, it will be 
    opus magnum that I<./s>ll be very proud of. 
    To follow me as a fiction writer:
    <ul>
    <li>Newsletter: https://gregboettcher.com/ 
	and see <.q>Newsletter signup<./q> on the left</li>
    <li>Twitter: @GregBoet</li>
    </ul>
    <p>
    <b>Feedback, fundraiser, and feelies package</b>
    <p>
    If you enjoyed this game, please feel free to post a review 
    on intfiction.org, or email me. My address is:
    <p>
    paradoxgreg@x.com, where x = gmail
    <p>
    And finally, if you are reading this before 
    September 15, 2019, please type FEELIES to learn how you can 
    get a nice feelies package 
    just by donating an easy $5 to an excellent charity. 
    ";
    return true;
  }
;

finishOptionFeelies: FinishOption
  desc = "get a nice <<aHrefAlt('feelies', 'FEELIES', '<b>F</b>EELIES',
          'Get a nice feelies package by donating a mere $5 to an excellent charity')>> 
          package by donating a mere $5 to an excellent charity"
  responseKeyword = 'feelies'
  responseChar = 'f'
  doOption() {
    "If you<./s>re reading this before September 15, 2019, 
      then you have a chance to score a package of feelies memorabilia 
      for this game for a mere $5&ndash;50 donation to an excellent 
      charity. But you must donate before September 15!
      <p>
      I put this idea together because it doesn<./s>t seem very 
      easy to monetize interactive fiction as a paid product. 
      So I figured instead I<./s>d try to raise funds for a worthy cause.
      <p>
      What comes in the feelies package?
      <ul>
      <li>A certificate from the Oo, stamped with signature 
      green ink, in the original Oo language.</li>
      <li>Another copy of the same certificate, stamped 
      with signature green ink, translated into English.</li>
      <li>A small pamphlet that serves as a Rosetta stone 
      for deciphering the Oo alphabet.</li>
      <li>Up to 6 copies each of up to 4 postcards. 
      For details on these postcards, click on the link below.</li>
      </ul>
      <p>
      The charity I<./s>ve chosen is Evidence Action, 
      which provides safe drinking water and fights 
      debilitating diseases in developing countries. 
      <p>
      There are four donation levels that provide 
      four different quantities of items in your feelies package. 
      For details, see the link below.
      <p>
      To find out how to make the donation 
      and get the feelies, go to the following link, read the details, 
      and follow the instructions there.
      <p>
      All the information you need is at:
      <br>
      <br>
      https://gregboettcher.com/mazesfundraiser/
      <br>
      <br> ";
    return true;
  }
;

modify finishOptionAchievements
  // This matches achievements.t as of right now (2019-08-10), but I could see achievements.t
  // needing to be changed so that the key to be pressed is usually something than "A", which often 
  // means "amusing". In NBM, by contrast, "A" should stand for ACHIEVEMENTS, since there is no 
  // AMUSING option here.
  desc = "view the <<aHrefAlt('achievements', 'ACHIEVEMENTS', '<b>A</b>CHIEVEMENTS',
            'Show achievements')>>"
  responseKeyword = 'achievements'
  responseChar = 'a'
;

// I guess the finishOptionAmusing style of
// Return to Ditch Day is better suited to my game
// than that of Square Circle.

modify finishOptionAmusing
  // 2019-05-16: In making the decision either to update this list of 
  // AMUSING options, or to get rid of it, I've decided that getting rid of it seems easier.
  isListed = nil
  doOption() {
    "\bA few amusing things to try:
    <p>[Note to self: these only pertain to the intro.
    update this later.]
    <.p>
    <ul>
    \n<li>Hit the narrow container 
            after you learn you<./s>re lying in it.
    \n<li>Hit the container before you learn of its existence.
    \n<li>Talk to the professors in the conference room. 
            (Numerous jokes and pieces of information can 
            be picked up this way.)
    \n<li>Give unwanted and/or false answers to the 
            professors<./s> questions.
    \n<li>Ask Vicki and Diane about Neton or Ovan.
    \n<li>Ask Vicki about Diane.
    \n<li>Try to kiss Vicki or Diane.
    \n<li>Taste or eat a food cube. Then try doing that 
            with another food cube.
    \n<li>Show things to Diane. Try giving a food cube to her.
    \n<li>Try putting a food cube in the toilet.
    \n<li>Try running <i>Cave Maze VII</i> in Ovan<./s>s
            secure menu.
    \n<li>Try running mazes.exe while in the VR place.
    \n<li>Go to sleep without making any modifications to 
            mazes.exe.
    \n<li>Go to sleep while mazes.exe has been compiled to 
            a non-viable state.
    \n<li>Go to sleep while mazes.exe has been compiled to
            either include or exclude <<beachChairM.theName>> 
            and/or <<butterflyIdM.theName>>.
    \n<li>Shout under various circumstances.
    \n<li>Type XYZZY, PLUGH, or PLOVER. Then do it again.
    </ul>
    <.p>";
    
    return true;
  }
;

// -------------------------------------------------------------------
// PRELIMINARIES: font face modifications: (Verdana, Courier, etc.)
// -------------------------------------------------------------------

// As you can plainly see, this section is a damn mess. I pity the
// fool who uses it as a model.

modify glob
  font   = verdana // or courier
  parser = human   // or alien or hacman
  status = blank   // or zork or trinity
  //changeFont = 'face=\"Verdana, Tahoma, Geneva, TADS-Sans\" size=\"3\"'
  changeFont() {
    if (font == courier)
      return 'face="Consolas, Courier New, Courier, TADS-Typewriter\"';
    else
      return 'face=\"Myriad Web Pro, Verdana, Tahoma, Geneva, TADS-Sans\"';
  }
  changeColors = '<body bgcolor=\"#FFFFFF\" text=\"#000000\">'
  changeStatusColors = '<body bgcolor=\"#C0C0C0\" text=\"#000000\">'
  //versionForAboutBox = (versionInfo.version) // may be changed later
;

gameStyleTag: StyleTag 'game' '<i>' '</i>';

nbmfontStyleTag: HtmlStyleTag 'nbmfont'
  htmlOpenText   = '<basefont ' + glob.changeFont + '>'
  //htmlOpenText   = glob.changeFont
  htmlCloseText  = '' // note that this is never used
  plainOpenText  = ''
  plainCloseText = '' // never used
;
nbmStatusFontStyleTag: HtmlStyleTag 'nbmstatusfont'
  htmlOpenText   = '<font ' + glob.changeFont + '>'
  //htmlOpenText   = glob.changeFont
  htmlCloseText  = '</font>' // note that this never needs to be used
  plainOpenText  = ''
  plainCloseText = '' // never used
;
nbmColorsStyleTag: HtmlStyleTag 'nbmcolors'
  //htmlOpenText   = '<basefont face=\'' + glob.changeFont + '\'>'
  htmlOpenText   = glob.changeColors
  htmlCloseText  = '' // note that this is never used
  plainOpenText  = ''
  plainCloseText = '' // never used
;
nbmStatusColorsStyleTag: HtmlStyleTag 'nbmstatuscolors'
  //htmlOpenText   = '<basefont face=\'' + glob.changeFont + '\'>'
  htmlOpenText   = glob.changeStatusColors
  htmlCloseText  = '' // note that this never needs to be used
  plainOpenText  = ''
  plainCloseText = '' // never used
;

modify libMessages
  // Modified in order to force font change to remain in place
  // at every command prompt.
  mainCommandPrompt(which) { 
    "\b";
    //if (glob.changeFont) "<.nbmfont>";
    //if (glob.changeColors) "<.nbmcolors>";
    "<.nbmfont>";
    "<.nbmcolors>";
    "&gt;";
  }
;

// Modified so that the input font isn't different from the
// regular font (but is in bold).
modify inputlineStyleTag
  htmlOpenText = '<b>'
  htmlCloseText = '</b>'
;

// -------------------------------------------------------------------
// PRELIMINARIES: statusLine modifications
// -------------------------------------------------------------------

enum blank, trinity, zork, human, alien, hacman, verdana, courier;

modify glob
  status = blank
;

// Modified for the following purposes:
// 1. To change the font
// 2. 
// 3. To change "0/0" to "Score: 0"

modify statuslineExitLister
  showListEmpty(pov, parent)
  {
    "<br>";
    if (glob.status == trinity)
      "<tab align=center>";
    "<b>Exits:</b> <i>None</i><br>";
  }
  showListPrefixWide(cnt, pov, parent)
  {
    "<br>";
    if (glob.status == trinity)
      "<tab align=center>";
    "<b>Exits:</b> ";
  }
;

modify statusLine
  // TADS 3.0.18 version of hack.
  // Note: This function has changed between 3.0.18 and 3.1.3,
  // but until I see my status line malfunctioning, I'm not going
  // to introduce the new, apparently-cosmetic changes into my code.
  showStatusHtml() {
    if (glob.status != blank) {
      if (glob.status == trinity) {
        "<tab align=center>";
      }
      "<a plain href='<<libMessages.commandLookAround>>'>";
      showStatusLeft();
      "</a>";
      if (glob.status == zork) {
        "<tab align=right>";
        //"<a plain href='<<libMessages.commandFullScore>>'>";
        showStatusRight();
        //"</a>";
      }
      if (gPlayerChar.location != nil) {
        //if (glob.status == trinity)
        //  "<tab align=center>";
        //"H1:\n<tab align=center>H2: ";
        gPlayerChar.location.showStatuslineExits();
      }
    }
    else {
      "&nbsp;";
    }
  }
  
  // Modified for Net-Hac-Man
  showStatusLeft() {
    if (gPlayerChar.getOutermostRoom && 
        gPlayerChar.getOutermostRoom.ofKind(HacRoom))
      "<b>Net-Hac-Man!</b>";
    else
      inherited();
  }

  // Modified to change "0/0" to "Score: 0", or perhaps to just 
  // eliminate the score thing.
  showStatusRight() {
    local s;
    if ((s = libGlobal.scoreObj) != nil) {
      "Score: <<s.totalScore>>";
    }
  }
  // Modified for the new font face:
  beginStatusLine()
  {
    local oldStr;
    switch(statusDispMode)
    {
    case StatusModeApi:
      statuslineBanner.clearWindow();
      statuslineBanner.setSize(getEstimatedHeightHtml(),
                   BannerSizeAbsolute, true);
      oldStr = statuslineBanner.setOutputStream();
      "<body bgcolor=statusbg text=statustext>";
      //Added:
      if (glob.changeFont)   statuslineBanner.writeToBanner('<.nbmstatusfont>');
      if (glob.changeColors) statuslineBanner.writeToBanner('<.nbmstatuscolors>');
      break;
    
    //// 2016-11-09: Begin stuff to consider for TADS 3.1.3. This is what's in the library.
    //case StatusModeBrowser:
    //  // browser UI - clear the window
    //  statuslineBanner.clearWindow();
    //  // switch to its output stream
    //  oldStr = statuslineBanner.setOutputStream();
    //  break;
    //// end stuff added 2016-11-09
    
    case StatusModeTag:
      oldStr = outputManager.setOutputStream(statusTagOutputStream);
      "<banner id=StatusLine height=previous
      border><body bgcolor=statusbg text=statustext>";
      //Added:
      if (glob.changeFont)   statuslineBanner.writeToBanner('<.nbmstatusfont>');
      if (glob.changeColors) statuslineBanner.writeToBanner('<.nbmstatuscolors>');
      break;
    case StatusModeText:
      flushOutput();
      statusMode(StatModeStatus);
      oldStr = outputManager.setOutputStream(statusLeftOutputStream);
      break;
    }
    return oldStr;
  }
  // Modified for the new font face:
  endStatusLine(oldStr)
  {
    outputManager.setOutputStream(oldStr);
    switch (statusDispMode)
    {
    case StatusModeApi:
      //Added:
      if (glob.changeFont)   statuslineBanner.writeToBanner('<./nbmstatusfont>');
      if (glob.changeColors) statuslineBanner.writeToBanner('<./nbmstatuscolors>');
      statuslineBanner.writeToBanner('\n');
      statuslineBanner.sizeToContents();
      break;
    case StatusModeTag:
      //Added:
      if (glob.changeFont)
        statusTagOutputStream.writeToStream('</font>');
      statusTagOutputStream.writeToStream('</banner>');
      break;
    case StatusModeText:
      statusMode(StatModeNormal);
    }
  }
;

// -------------------------------------------------------------------
// PRELIMINARIES: new scripts
// -------------------------------------------------------------------

class CyclicList: CyclicEventList
  doScript() {
    local idx;
    local returnval;
    // get our current event state
    idx = getScriptState();
    // if it's a valid index in our list, fire the event
    if (idx >= 1 && idx <= eventList.length()) {
      // get the string value to return
      returnval = eventList[idx];
    }
    // perform any end-of-script processing
    scriptDone();
    // return the string
    return returnval;
  }
;

// -------------------------------------------------------------------
// PRELIMINARIES: exitLister modifications
// -------------------------------------------------------------------

// Hacked for the sake of a scenario like this, where there's one room
// with two separate halls leading out of it, both named "Hall"...
//                  Hall - Room - Hall
// The modification aims to make it so that TADS 3 doesn't say, "The 
// only obvious exit leads east (or west), back to the hallway."
// 
// Note that this modification should no longer be necessary in 
// current versions in TADS 3, where this bug has been fixed, but
// I may be compiling this with the old TADS 3.0.8.

/*
modify exitLister
  showExitsWithLister(actor, loc, lister, locIsLit)
  {
    local destList;
    local showDest;
    local options;
    showDest = lister.listerShowsDest;
    options = 0;
    destList = new Vector(Direction.allDirections.length());
    foreach (local dir in Direction.allDirections)
    {
      local conn;
      if ((conn = loc.getTravelConnector(dir, actor)) != nil
        && conn.isConnectorApparent(loc, actor)
        && conn.isConnectorListed
        && (locIsLit || conn.isConnectorVisibleInDark(loc, actor)))
      {
        local dest;
        local destName = nil;
        local destIsBack;
        dest = conn.getApparentDestination(loc, actor);
        destIsBack = (conn == actor.lastTravelBack);
        if (dest != nil
          && showDest
          && (destName = dest.getDestName(actor, loc)) != nil)
        {
          local orig;
          options |= ExitLister.hasDestNameFlag;
          if (destIsBack)
            options |= ExitLister.hasBackNameFlag;
          
          
          // START HACK
          orig = destList.valWhich({x: x.dest_ == dest});
          // END HACK
          
          
          if (orig != nil)
          {
            orig.others_ += dir;
            if (destIsBack)
              orig.destIsBack_ = true;
            continue;
          }
        }
        destList.append(new DestInfo(dir, dest, destName,
                        destIsBack));
      }
    }
    lister.showListAll(destList.toList(), options, 0);
  }
;
*/

// -------------------------------------------------------------------
// PRELIMINARIES: Room & RoomPart modifications
// -------------------------------------------------------------------

// I hate having four separate wall objects in each room, as though each
// were individually important. I'd much rather have one object, "walls."

modify Room
  roomParts = [defaultFloor, defaultCeiling, defaultWalls]
;
defaultWalls: RoomPart
  vocabWords = 'wall*walls'
  name = 'walls'
  desc = "{You/he} see{s} nothing special about the walls. "
  isPlural = true
  dobjFor(Hit) asDobjFor(Attack)
  isWall = true
;

modify defaultCeiling
  uselessToAttackMsg = '{The dobj/he} is just barely within reach.
    It<./s>s a little too awkward for you to deliver it any kind of 
    solid blow. '
  uselessToHitMsg = (uselessToAttackMsg)
  dobjFor(AttackWith) asDobjFor(Attack)
  dobjFor(HitWith) asDobjFor(Hit)
;

modify Room
  //dobjFor(LookUnder) {
  //  verify { illogical(&cannotLookUnderMsg); }
  //}
  //dobjFor(LookBehind) {
  //  verify { illogical(&cannotLookBehindMsg); }
  //}
  
  // The following is fixed in recent versions of TADS 3:
  /*
  dobjFor(LookIn) remapTo(Look)
  dobjFor(Smell) remapTo(SmellImplicit)
  dobjFor(ListenTo) remapTo(ListenImplicit)
  */
  
  // I really would have liked to remap "get out of room" as "out",
  // but I got big-time errors doing this and gave up, since I had
  // limited time.
  // 
  // The following alternative is no longer necessary due to 
  // the fact that the latest TADS 3 versions have amended this.
  /*
  dobjFor(GetOutOf) {
    remap() {
      // remap only if this isn't an implied action
      if (gAction.parentAction == nil) {
        // if we have an apparent Out destination, go there;
        // otherwise it's not obvious where we're supposed to go 
        if (out != nil
          && out.getApparentDestination(self, gActor) != nil)
          return [OutAction];
        else
          return [VagueTravelAction];
      }
      // don't remap here - use the standard handling
      return inherited();
    }
  }
  */
  
  // Boy, do recent versions of TADS 3 have a thorough implementation
  // of dobjFor(Enter). Let's assume it covers all the stuff I covered
  // here.
  /*
  dobjFor(Board) asDobjFor(Enter)
  dobjFor(Enter) {
    verify {
      if (gActor.isIn(self))
        illogicalAlready('{You\'re} already in {the dobj/him}. ');
    }
    check {
      reportFailure(&whereToGoMsg);
      exit;
    }
  }
  */
;


// -------------------------------------------------------------------
// PLAYER CHARACTER STUFF: Gary Randall -- i.e., "me":
// the initial PC, and the protagonist of the game as a whole
// -------------------------------------------------------------------

me: Person
  // "me" and "myself" already refer to the PC
  vocabWords = (firstName.toLower + ' ' + lastName.toLower + ' i')
  location = nil // Will be changed after two moves.
  //location = crawlway
  name = firstName
  isHim = true // superfluous, I suppose
  isProperName = true
  fullName = 'Gary Randall'
  firstName = 'Gary'
  lastName = 'Randall'
  purportedSpecies = human
  isMe = true
  hasExplainedOrigin = nil
  knowsMazeGameTitle = nil
  pcDesc {
    if (isIn(coffin)) {
      "You certainly can<./s>t see yourself in the dark. ";
      feelDesc;
    }
    else {
      // physical description
      if (!hasSeenSelfInMirror && !canSee(mirror))
        preMirrorDesc;
      else if (isIn(bathroom)) {
        "Looking into the mirror reveals that ";
        mirrorDesc;
      }
      else if (isIn(dreamRoom) || isIn(office)) {
        "The reflective window easily allows you to
          glimpse your reflection. \^";
        mirrorDesc;
      }
      else // hasSeenSelfInMirror
        postMirrorDesc;
      
      // emotional description
      emotionalDesc;
      
      //// clothing description. I may not keep this
      //// In fact, this needs to be changed anyway
      //"You<./s>re wearing <<myShirt.aName>> 
      //  and <<myPants.aName>>. ";
    }
  }
  // The following describe the PC only in a visual way, 
  // and disregard any clothing.
  preMirrorDesc =
    "Without being able to look in a mirror, you know 
      you<./s>re a gray-haired man in your sixties. "
  mirrorDesc {
    "you<./s>re visibly older than you once were, 
      with deeper wrinkles and more textured skin. 
      Your hair, gray as ever, is combed attractively. ";
    hasSeenSelfInMirror = true;
  }
  postMirrorDesc =
    "Having seen your reflection earlier, 
      you know you<./s>re looking older than you once did, 
      with deeper wrinkles and more textured skin. 
      Your hair, gray as ever, is combed attractively. "
  // Describes the PC's mindset
  emotionalDesc =
    "All in all, you<./s>re feeling pretty good,
      in spite of being legally dead. "
  hasSeenSelfInMirror = nil
  //whatDesc {
  //  if (isIn(coffin))
  //    "That<./s>s a good question. You don<./s>t know the answer. ";
  //  else
  //    "You<./s>re a man from the twenty-first century who has woken up
  //      to a strange future. ";
  //}
  seeFeelMethod {
    "You run your hands over your body, but unfortunately you don<./s>t learn
      anything to speak of. In fact, you are a little too 
      disoriented even to remember who you are. ";
    //"(If you were more awake, you'd realize that you're an
    //  adult male human, but that goes without saying.) ";
  }
  feelDesc {
    if (isIn(coffin))
      "You run your hands over your body, but unfortunately you don<./s>t learn
        anything to speak of. In fact, you are a little too 
        disoriented even to remember who you are. ";
    else
      inherited;
  }
  intendedClothes = [myShirt, myPants]
  dobjFor(Break) asDobjFor(Attack)
  uselessToAttackMsg {
    return 'No doubt it would be fun to while away the hours 
      inflicting pain upon yourself, but, practically speaking,
      it wouldn<./s>t help much. ';
  }
  uselessToHitMsg {
    return 'No doubt it would be fun to while away the hours 
      inflicting pain upon yourself, but, practically speaking,
      it wouldn<./s>t help much. ';
  }
  
  dobjFor(Push) {
    verify {
      illogical('You see no reason to push yourself around. ');
    }
  }
  dobjFor(Pull) {
    verify {
      illogical('You can<./s>t pull yourself. ');
    }
  }
  dobjFor(Move) {
    verify {
      illogical('You<./s>ll have to say which way to go. ');
    }
  }
  dobjFor(MoveWith) {
    verify {
      illogical('You can<./s>t move yourself that way. ');
    }
  }
  dobjFor(AttackWith) asDobjFor(Attack)
  dobjFor(HitWith) asDobjFor(Hit)
  dianeShowResponse =
    "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve 
      successfully located yourself.<./q> "
;

// -------------------------------------------------------------------
// PLAYER CHARACTER STUFF: Gary Randall's clothing
// -------------------------------------------------------------------

// Some of this code is influenced by Mike Roberts' Return to Ditch 
// Day source.

class InitiallyWorn: Wearable
  wornBy = (location)
  hideFromAll(action) { return true; }
;

class MyClothing: InitiallyWorn
  dobjFor(Doff) {
    check() {
      "You see no reason to go around without a <<clothingType>>. ";
      exit;
    }
  }
  hideFromAll(action) {
    return action.ofKind(DropAction)
      || action.ofKind(DoffAction)
      || action.ofKind(PutInAction)
      || inherited(action);
  }
  //isQualifiedName = true
;

myShirt: MyClothing
  '(drab) (gray) (grey) shirt*clothing*clothes'
  'gray shirt'
  @me
  "Your shirt is drab gray, poorly fitting,
    and not much of a fashion statement. 
    On the other hand, at least it<./s>s clean. "
  clothingType = 'shirt'
  disambigName = 'your gray shirt'
  theDisambigName = (disambigName)
  aDisambigName = (disambigName)
  theName = (disambigName)
;

myPants: MyClothing
  '(drab) (gray) (grey) pants/trousers/pair*clothing*clothes'
  'gray pants'
  @me
  "Your pants are drab gray. They don<./s>t fit you very well,
    but they<./s>re serviceable. "
  isPlural = true
  isQualifiedName = true
  clothingType = 'pair of pants'
  disambigName = 'your gray pants'
  aDisambigName = (disambigName)
  theName = (disambigName)
;

// -------------------------------------------------------------------
// PLAYER CHARACTER STUFF: miscellaneous stuff for all PCs
// -------------------------------------------------------------------

modify Actor
  dobjFor(TalkTo) {
    verify() {
      if (gDobj == gActor)
        illogical('Talking to yourself probably wouldn<./s>t be
          all that productive. ');
      else
        nonObvious;
      //inherited();
    }
  }
  iobjFor(ThrowAt) {
    verify {
      // Don't permit the PC to throw things at himself
      if (self == gActor) {
        illogical('{You/he} can<./s>t easily throw anything at 
          {yourself/himself}. ');
      }
      inherited();
    }
  }
;

modify NonPortable
  iobjFor(ThrowAt) {
    verify {
      // if gIobj is NonPortable and it's in gActor, then presumably 
      // the actor is trying to throw stuff at his own body parts.
      // Prohibit this.
      if (isIn(gActor)) {
        illogical('{You/he} can<./s>t easily throw anything at 
          {yourself/himself}. ');
      }
      inherited();
    }
  }
;

modify Thing
  iobjFor(ThrowAt) {
    verify {
      // Don't permit the PC to throw things at whatever he's carrying or wearing
      if (isIn(gActor)) {
        illogicalNow('{You/he} can<./s>t easily do that while {you\'re} ' 
          + (isWorn ? 'wearing' : 'carrying') + ' {the iobj/him}. ');
      }
      inherited();
    }
  }
;

modify Actor
  realName = name
;


// -------------------------------------------------------------------
// EXTENSION MODIFICATIONS: ncDebugActions.t
// -------------------------------------------------------------------

// Modify "pow," a debug verb, so that it works whether you can stand 
// up or not (for the sake of the coffin in the beginning, where you 
// can't stand up). 

#ifdef __DEBUG
modify Thing {
  dobjFor(Pow) {
    preCond = [] // no actorStanding
  }
}
#endif // __DEBUG

// -------------------------------------------------------------------
// EXTENSION MODIFICATIONS: ncYesNo.t
// -------------------------------------------------------------------

modify glob
  sleepFuseIsOn = nil
  vegetableOilFuseIsOn = nil
  vegeableOilFuseIsOn = nil
  tableSaltFuseIsOn = nil
  altarFuseIsOn = nil
  hitAnimalFuseIsOn = nil
  mazeHoleFuseIsOn = nil
  goAnimalFuseIsOn = nil
  //slowingFieldFuseIsOn = nil
;

modify ncYesNo
  defaultYesAnswer = playerActionMessages.useTalkToMsg
  defaultNoAnswer = playerActionMessages.useTalkToMsg
  reset() {
    if (self._active) {
      
      
      //START HACK
      
      
      
      
      glob.sleepFuseIsOn = nil;
      glob.vegetableOilFuseIsOn = nil;
      glob.vegeableOilFuseIsOn = nil;
      glob.tableSaltFuseIsOn = nil;
      glob.altarFuseIsOn = nil;
      glob.pdaFuseIsOn = nil;
      glob.hitAnimalFuseIsOn = nil;
      glob.goAnimalFuseIsOn = nil;
      glob.mazeHoleFuseIsOn = nil;
      YesAction.actionTime = 0;
      NoAction.actionTime = 0;
      //END HACK
      
      
      self._onYes = nil;
      self._onNo = nil;
      self._active = nil;
      self._myFuse.removeEvent();
      self._myFuse = nil;
      if (self._lastIssuer.isPlayerChar()) {
        self._lastIssuer.lastInterlocutor = self._lastInterlocutor;
      }
    }
  }
  set( yes, no )
  {
    if (self._active) self.reset();
    
    
    //START HACK
    YesAction.actionTime = 1;
    NoAction.actionTime = 1;
    //END HACK
    
    
    self._onYes = yes;
    self._onNo = no;
    self._active = true;
    self._myFuse = new Fuse(self, &reset, 1);
    self._lastIssuer = gIssuingActor;
    self._lastInterlocutor = self._lastIssuer.getCurrentInterlocutor();
  }
;

/*
modify YesAction {
  execAction()
  {
    if (gActor.isPlayerChar()) {
      if (ncYesNo._active) {
        if (dataType(ncYesNo._onYes) == TypeSString) {
          say(ncYesNo._onYes);
        } else {
          (ncYesNo._onYes)();
        }
      } else {
        if (gIssuingActor.getCurrentInterlocutor()) {
          "Sheeite. "; //mainReport(&useTalkToMsg); // modified from ncYesNo.t
        } else {
          "Sheeite. "; say(ncYesNo.defaultYesAnswer);
        }
      }
    } else {
      "Sheeite. "; //mainReport(&useTalkToMsg); // modified from ncYesNo.t
    }
  }
}

modify NoAction {
  execAction()
  {
    if (gActor.isPlayerChar()) {
      if (ncYesNo._active) {
        if (dataType(ncYesNo._onNo) == TypeSString) {
          say(ncYesNo._onNo);
        } else {
          (ncYesNo._onNo)();
        }
      } else {
        if (gIssuingActor.getCurrentInterlocutor()) {
          inherited();
        } else {
          say(ncYesNo.defaultNoAnswer);
        }
      }
    } else {
      inherited();
    }
  }
}
*/

// -------------------------------------------------------------------
// EXTENSION MODIFICATIONS: msg_custom.t
// -------------------------------------------------------------------

// [T3] = TADS default
// [GB] = my personal preference

modify libGlobal
  thisStoryNotTheStory = always     // never, sometimes[T3], always[GB]
  gameNotStory         = true       // nil[T3], true[GB]
  useContractions      = usually    // never, seldom, sometimes[T3], 
                                    //   usually[GB], always
  preferCasual         = true       // nil[T3], true[GB]
  useSmartQuotes       = always     // never, sometimes[T3 (3.0.9)], 
                                    //   always[T3 (3.0.10+)] [GB]
  youMustPref          = youllHaveTo// youMust[T3], youllHaveTo[GB], 
                                    //   youdHaveTo, youllNeedTo, youdNeedTo
;

// Modifications required due to the fact that msg_custom.t is
// really designed for TADS 3.0.12 rather than 3.0.8:

/*
modify playerMessages
  noMatch(actor, txt) {
    "\^<<gActor.nameSeesNo>> <<txt>> here. ";
  }
;
*/

// -------------------------------------------------------------------
// EXTENSION MODIFICATIONS: autosave.t
// -------------------------------------------------------------------

// ---------------------------
// autosave.t modified for the following purposes: 
// (1) Rephrasing the "begin challenge" and "end challenge"
//     messages to suit my taste, 
// (2) changing "story" to "game," and 
// (3) eliminating the RETRY HIDE suggestion.

modify libMessages
  autoSave_challengeStarting =
    "You have reached a challenging and time-sensitive part
      of the game. "
  autoSave_retryEnabled =
    "From the next turn on, you can type <<aHref('retry', 'RETRY',
    'Retry the current challenge')>> to restore the current
    position. You might also wish to 
    <<aHref('save', 'SAVE', 'save the game position')>>
    now."
  autoSave_challengeEnding =
    "Congratulations on overcoming the time-sensitive part
      of the game. "
  autoSave_retryDisabled =
    "From now on, there will be no need to type RETRY."
  //autoSave_challengeStarting =
  //  "This game has reached a challenging stage where your actions could
  //  have irrecoverable consequences. "
  autoSave_challengeChanging =
    "This game has reached a point of temporary safety.  However, {your} next
    actions could still have irrecoverable consequences. "
  //autoSave_challengeEnding =
  //  "This game has reached a period of respite where {your} actions are
  //  unlikely to have irrecoverable consequences. "
  autoSave_notRetrying =
    "<.parser>Continuing the game.<./parser> "
  autoSave_retryOkay =
    ""
    //"<.parser>Retrying . . .<./parser> "
  //autoSave_retryNoChallenge =
  //  "<.parser>There is currently no need to restore a previous
  //  position.<./parser> "
  
  // No need to inform about the RETRY HIDE command or whatever.
  autoSave_suggestReportsOff = ""
;

modify notificationStyleTag
  openText = '['
  closeText = ']'
;


/*
// ---------------------------
// Changes to make pre-retry confirmation NOT a universal necessity.

// It is indeed a good idea to require confirmation when the user types
// RETRY in the middle of a game, but to get such confirmation after
// the game is over is just a waste of time. Fix this.

modify challengeManager
  // Previously this method required no argument, but now we need to 
  // remember whether we should be prompting for confirmation before
  // we go ahead and retry the current challenge.
  doRetryChallenge(getConfirmation)
  {
    if (!challengeRunning) libMessages.autoSave_retryNoChallenge();
    else if (autoSavedGame == nil) libMessages.autoSave_retryUnavailable();
    else if (challengeStarting) libMessages.autoSave_retryChallengeStarting();
    else
    {
      local bytes = autoSavedGame;
      // This line has been changed to use the new argument:
      local succ = RetryAction.performRestore(bytes, getConfirmation);
      if (succ)
      {
        reportChallengeRestart();
        update(bytes);
        throw new TerminateCommandException();
      }
    }
  }
;

modify RetryAction
  // Previously the call to challengeManager.doRetryChallenge()
  // required no argument. Now the argument is "true", to indicate
  // we do need confirmation before retrying.
  doRetryChallenge() { challengeManager.doRetryChallenge(true); }
  // Previously this method required only one argument. Now a second
  // argument is required so we know whether to get confirmation
  // before retrying.
  performRestore(bytes, getConfirmation)
  {
    local origElapsedTime = realTimeManager.getElapsedTime();
    libMessages.autoSave_confirmRetry();
    // The following line has been changed to use the new argument:
    if (getConfirmation && !yesOrNo())
    {
      libMessages.autoSave_notRetrying();
      return nil;
    }
    try { restoreGameFromByteArray(bytes); }
    catch (FileException exc)
    {
      if (exc.ofKind(FileSafetyException))
          libMessages.autoSave_retryFileSafetyTooRestrictive();
      else libMessages.autoSave_retryFileException(exc);
      realTimeManager.setElapsedTime(origElapsedTime);
      return nil;
    }
    libMessages.autoSave_retryOkay();
    PostRestoreObject.restoreCode = 3;
    PostRestoreObject.classExec();
    return true;
  }
;

modify finishOptionRetry
  // Instead of calling RetryAction.doRetryChallenge(),
  // call challengeManager.doRetryChallenge(), which can take
  // an argument ("nil"), to indicate that we do not need
  // confirmation before retrying.
  doOption()
  {
    challengeManager.doRetryChallenge(nil);
    return true;
  }
;
*/

// -------------------------------------------------------------------
// EXTENSION MODIFICATIONS: qtalk.t
// -------------------------------------------------------------------

#ifndef usePastTense
modify gameMain
  usePastTense = nil
;
#endif // usePastTense

// Note: As of 29 Oct 2007, when I modified the version of qtalk.t
// used by this game, these modifications here are no longer 
// necessary or desirable.
/*
modify Quip
  select() {
    local dealwith, first, seencontent, optionobj, onoptions, 
      selected, objflag, a, k;
    dealwith = self;
    first = true;
    seencontent = nil;
    // Do a gigantic loop, because this quip could be only
    // the first of many in an extended conversation.
    do {
      // Auto-Deactivation:
      // This section does nothing unless you set 
      // libGlobal.autoDeactivate to true. If, however, 
      // libGlobal.autoDeactivate == true, then continually check 
      // for any quips whose option properties are all turned off.
      // Upon finding any such quips, turn them off.
      if (libGlobal.autoDeactivate) {
        do {
          objflag = 0;
          for(local obj = firstObj(Quip) ; obj ; 
                    obj = nextObj(obj, Quip)) { 
            if (obj.propDefined(&options)
                && dataType(obj.options) == TypeList 
                && obj.isOn && obj.options.length() > 0) {
              onoptions = 0;
              for (a = 1, local cnt = obj.options.length(); 
                   a <= cnt; ++a) {
                if (obj.options[a].propDefined(&isOn)) {
                  if (obj.options[a].isOn) ++onoptions;
                }
              }
              if (onoptions == 0) {
                obj.isOn = nil;
                ++objflag;
              }
            }
          }
        } while (objflag != 0);
      }
      
      // Keep track of whether we've seen actual content; i.e.
      // whether we've yet seen a normal quip whose main purpose
      // is to give the content in its reply property, as opposed to 
      // a quip whose main purpose is to provide options.
      if (dealwith.quipType == regularQuip)
        seencontent = true;
      
      // If the current Quip provides a qOff property, and if
      // qOff is a list, then turn off all the quips in the list.
      // If qOff is not a list, or if it's an empty list, 
      // ignore it.
      if (dealwith.propDefined(&qOff) 
          && dataType(dealwith.qOff) == TypeList
          && dealwith.qOff.length() > 0) {
        for (a = 1, local cnt = dealwith.qOff.length(); 
             a <= cnt; ++a) {
          dealwith.qOff[a].isOn = nil;
        }
      }
      
      // If dealwith.qOffSelf = true, then turn
      // the current Quip off.
      if (dealwith.qOffSelf)
        dealwith.isOn = nil;
      
      // If the current Quip provides a qOn property, and if
      // qOn is a list, then turn on all the quips in the list.
      // If qOn is not a list, or if it's an empty list, 
      // ignore it.
      if (dealwith.propDefined(&qOn)
          && dataType(dealwith.qOn) == TypeList
          && dealwith.qOn.length() > 0) {
        for (a = 1, local cnt = dealwith.qOn.length(); 
             a <= cnt; ++a) {
          dealwith.qOn[a].isOn = true;
        }
      }
      
      // Print/execute the reply property.
      if (dealwith.propDefined(&reply)) {
        dealwith.reply;
      }
      else {
        " "; // So as to not get "Nothing obvious happens."
      }
      
      // Next, determine whether we need to print options
      // and ask the player to make a selection.
      // 
      // The first step in this process is to determine "optionobj":
      // the quip that is supposed to store the information about 
      // any options that are to be printed. "Optionobj"
      // is the quip currently being considered, unless a "transfer"
      // property is provided.
      if (dealwith.propDefined(&transfer) && dealwith.transfer != nil)
        optionobj = dealwith.transfer;
      else
        optionobj = dealwith;
      
      // Print either a line break or a paragraph mark, depending
      // on circumstances.
      if (optionobj.breakBeforeOptions)
        "<.p>";
      else
        "\n";
      
      // Check to see if the current quip provides options, 
      // and if at least one of those options is on.
      onoptions = 0;
      if (optionobj.propDefined(&options)
          && (dataType(optionobj.options) == TypeList) 
          && optionobj.options.length() > 0) {
        //pleaseSay('<.p><font color=red>Looking at <.q>options<./q></font><.p>');
        for (a = 1, local cnt = optionobj.options.length(); 
             a <= cnt; ++a) {
          if (optionobj.options[a].isOn) ++onoptions;
        }
      }
      
      // Begin scenario: the current quip provides options, 
      // and at least one of them is turned on.
      if (onoptions > 0) {
        // If we're supposed to ask a question before listing the 
        // options, then ask the question.
        if (optionobj.killQ == nil) {
          if (!first)
            "\n";
          "<<optionobj.quipQuestion>>";
          //"What would {you/he} like to say? ";
          "\n";
        }
        
        // List the options, then do a paragraph break.
        onoptions = 0;
        for (a = 1, local cnt = optionobj.options.length(); 
             a <= cnt; ++a) {
          if (optionobj.options[a].propDefined(&isOn)) {
            if (optionobj.options[a].isOn) {
              ++onoptions;
              "<<optionobj.quipOptionStart>>";
              "<<onoptions>>";
              "<<optionobj.quipOptionEnd>>";
              "<<optionobj.options[a].desc>> ";
              "\n";
            }
          }
        }
        "<.p>";
        
        // Get input
        do {
          "<.inputline>";
          "<<optionobj.selectAnOption>>";
          if (!optionobj.killZ)
            "<<optionobj.orZeroToSayNothing>>";
          "<<optionobj.quipPrompt>>";
          "<./inputline>";
          k = inputManager.getInputLine(nil, nil);
          selected = qToInteger(k);
          if (optionobj.killZ == true && selected == 0)
            selected = -1;
        } while ((selected < 0) || (selected > onoptions));
        
        // If the player chooses "0" to say nothing -- and if
        // this is supposed to successfully end the conversation --
        // then end the conversation.
        if (selected == 0 && optionobj.zeroOption == nil) {
          // If so far we've only seen quips whose main purpose
          // is to provide options rather than give content,
          // then print the appropriate message.
          if (seencontent == nil) {
            //"{You/he} decide{s} not to say anything after all. ";
            
            
            
            // BEGIN MODIFICATIONS TO BE INCLUDED IN A NEW QTALK.T RELEASE
            // MODIFICATIONS MADE OCT. 2007
            if (optionobj.propDefined(&decideToSayNoQuip))
              "<<optionobj.decideToSayNoQuip>>";
            else if (playerActionMessages.propDefined(&decideToSayNoQuip))
              "<<playerActionMessages.decideToSayNoQuip>>";
            else
              "<.p>";
            //"<<optionobj.decideToSayNoQuip>>";
            // END MODIFICATIONS
            
            
            
            "\n";
          }
          // If we *have* seen content by this point, then
          // just exit without another word.
          else {
            " "; // So as to not get "Nothing obvious happens."
          }
          return;
        }
        
        // If the player chooses "0" to say nothing, BUT the
        // game has defined a custom response to "0", then we
        // will have to deal with that custom response next
        // instead of just exiting.
        if (selected == 0 && optionobj.zeroOption != nil) {
          dealwith = optionobj.zeroOption;
        }
        
        // If the player has chosen an option that isn't "0",
        // then we will just have to deal with the corresponding
        // quip next time around. Let dealwith = that quip.
        else {
          onoptions = 0;
          for (a = 1, local cnt = optionobj.options.length(); 
               a <= cnt; ++a) {
            if (optionobj.options[a].propDefined(&isOn)) {
              if (optionobj.options[a].isOn) {
                ++onoptions;
                if (selected == onoptions) {
                  dealwith = optionobj.options[a];
                  break;
                }
              }
            }
          }
        }
      }
      // End "at least one option is turned on" scenario.

      // Begin scenario: the current quip provides no options, 
      // or all of its options are turned off.
      else {
        if (optionobj.quipType == mainMenuQuip) {
          
          
          
          // BEGIN MODIFICATIONS TO BE INCLUDED IN A NEW QTALK.T RELEASE
          // MODIFICATIONS MADE OCT. 2007
          if (optionobj.propDefined(&canSayNoQuip))
            "<<optionobj.canSayNoQuip>>";
          else if (playerActionMessages.propDefined(&canSayNoQuip))
            "<<playerActionMessages.canSayNoQuip>>";
          else
            "<.p>";
          // END MODIFICATIONS
          
          
          
          //"{You/he} can't think of anything to say. ";
          "\n";
        }
        dealwith = nil; // end this routine
        //return;
      }
      // End "no options turned on" scenario.
      
      // Any subsequent iterations of the loop will not be
      // the first iteration anymore.
      first = nil;
    
    // If this is the last quip to be dealt with (that is,
    // dealwith = nil), then exit the loop. Otherwise,
    // do the loop again.
    } while (dealwith != nil);
    
    // We're done.
    return;
  }
;

// Quip modifications specific to my game
modify Quip
  canSayNoQuip {
    if (gActor == bot && gDobj == bot)
      return 'You can<./s>t think of anything to say. ';
    else
      return '{You/he} {can\'t} think of anything to say. ';
  }
  decideToSayNoQuip {
    if (gActor == bot && gDobj == bot)
      return 'You decide not to say anything after all. ';
    else
      return '{You/he} decide{s/d} not to say anything after all. ';
  }
;


modify Quip
  select() {
    local dealwith, first, seencontent, optionobj, onoptions, 
      selected, objflag, a, k;
    dealwith = self;
    first = 1;
    seencontent = nil;
    do {  // Do a big loop, because this quip could be only
          // the first of many in an extended conversation.
      if (first == 1)  // first == 1 only on the
        first = 2;     // first time through the loop.
      
      // 
      // 
      // (List spot 1)
      if (libGlobal.autoDeactivate) {
        do {
          objflag = 0;
          for(local obj = firstObj(Quip) ; obj ; 
                    obj = nextObj(obj, Quip)) { 
            if (obj.propDefined(&options)) {
              onoptions = 0;
              if (obj.propType(&options) == TypeList) {
                if (obj.isOn && obj.options.length() > 0) {
                  for (a = 1, local cnt = obj.options.length(); 
                       a <= cnt; ++a) {
                    if (obj.options[a].propDefined(&isOn)) {
                      if (obj.options[a].isOn) ++onoptions;
                    }
                  }
                  if (onoptions == 0) {
                    obj.isOn = nil;
                    ++objflag;
                  }
                }
              }
            }
          }
        } while (objflag != 0);
      }
      
      if (dealwith.quipType == regularQuip)
        seencontent = true;
      
      // If the current Quip provides a qOff property...
      if (dealwith.propDefined(&qOff)) {
        // ...and if qOff is a list...
        if (dealwith.propType(&qOff) == TypeList) {
          // ...and if the list has at least one item,
          // then do the following. Otherwise, ignore it.
          if (dealwith.qOff.length() > 0) {
            for (a = 1, local cnt = dealwith.qOff.length(); 
                 a <= cnt; ++a) {
              dealwith.qOff[a].isOn = nil;
            }
          }
        }
      }
      // If the current Quip provides a qOn property...
      if (dealwith.propDefined(&qOn)) {
        // ...and if qOn is a list...
        if (dealwith.propType(&qOn) == TypeList) {
          // ...and if the list has at least one item,
          // then do the following. Otherwise, ignore it.
          if (dealwith.qOn.length() > 0) {
            for (a = 1, local cnt = dealwith.qOn.length(); 
                 a <= cnt; ++a) {
              dealwith.qOn[a].isOn = true;
            }
          }
        }
      }
      
      //"[<<dealwith.reply>>]";
      if (dealwith.propDefined(&reply) && dealwith.reply) {
        dealwith.reply;
        
        
        //START HACK
        //END HACK
        
        
        
      }
      else {
        " "; // So as not to get "Nothing obvious happens."
      }
      
      // Optionobj=dealwith unless there is a dealwith.transfer
      if (dealwith.propDefined(&transfer)) {
        if (dealwith.transfer != nil)
          optionobj = dealwith.transfer;
        else 
          optionobj = dealwith;
      }
      else
        optionobj = dealwith;
      
      if (optionobj.killQ) say(nlchar);
      else "<.p>";
      
      // We can't give a list of options until we verify that the
      // current quip provides options, and that at least one of
      // those options is on.
      // ARRAYSPOT
      onoptions = 0;
      if (optionobj.propDefined(&options)) {
        if (optionobj.propType(&options) == TypeList) {
          if (optionobj.options.length() > 0) {
            for (a = 1, local cnt = optionobj.options.length(); 
                 a <= cnt; ++a) {
              if (optionobj.options[a].propDefined(&isOn)) {
                if (optionobj.options[a].isOn) ++onoptions;
              }
            }
          }
        }
      }
      
      // If the current quip provides options, and if at least
      // one of them is on, then...
      if (onoptions > 0) {
        if (optionobj.killQ == nil) {
          if (first != 1) say(nlchar);
          say(sayWhatMsg);
          say(nlchar);
        }
        
        //ARRAYSPOT
        onoptions = 0;
        for (a = 1, local cnt = optionobj.options.length(); 
             a <= cnt; ++a) {
          if (optionobj.options[a].propDefined(&isOn)) {
            if (optionobj.options[a].isOn) {
              ++onoptions;
              "<<glob.quipOpenParen>><<onoptions>><<glob.quipCloseParen>> 
                <<optionobj.options[a].desc>> ";
              say(nlchar);
            }
          }
        }
        say(brchar);
        
        
        // START HACK
        local k = inputManager.getKey(nil,nil);
        if (k == 'q') { k=0; k=k/k; }
        // END HACK
        
        do {
          "<.inputline>";
          "Select an option ";
          if (optionobj.killZ == nil) "or 0 to exit ";
          "\>\> ";
          "<./inputline>";
          k = inputManager.getInputLine(nil, nil);
          selected = qToInteger(k);
          if (optionobj.killZ == true && selected == 0)
            selected = -1;
        } while ((selected < 0) || (selected > onoptions));
        
        if (selected == 0 && optionobj.zeroOption == nil) {
          if (seencontent == nil) {
            "{You/he} decide{s} not to say anything after all. ";
            say(nlchar);
          }
          else {
            " "; // So as not to get "Nothing obvious happens."
          }
          return;
        }
        
        if (selected == 0 && optionobj.zeroOption != nil) {
          dealwith = optionobj.zeroOption;
        }
        else {
          // ARRAYSPOT
          onoptions = 0;
          for (a = 1, local cnt = optionobj.options.length(); 
               a <= cnt; ++a) {
            if (optionobj.options[a].propDefined(&isOn)) {
              if (optionobj.options[a].isOn) {
                ++onoptions;
                if (selected == onoptions) {
                  dealwith = optionobj.options[a];
                  break;
                }
              }
            }
          }
        }
      }
      // If the current quip provides no options, or if all of
      // its options are turned off...
      else {
        if (optionobj.quipType == mainMenuQuip) {
          "{You/he} can't think of anything to say. ";
          say(nlchar);
        }
        dealwith = nil; // end this routine
        //return;
      }
    } while (dealwith != nil);
//if (self.ofKind(nil)) self.quipType = self.quipType;
    return;
  }
  sayWhatMsg = 'What would you like to say? '
;

modify glob
  quipOpenParen = '('
  quipCloseParen = ')'
;
*/

// -------------------------------------------------------------------
// MESSAGE SUBSTITUTION PARAMETER MODIFICATIONS
// -------------------------------------------------------------------

// Note to self: (1) This is now taken care of by msg_custom.t.
// (2) Furthermore, if you modify langMessageBuilder.paramList_
// beyond what is done in msg_custom.t, things will be screwy. 
// So... time to comment this out. But we'll need to put it back in
// again if we ever get rid of msg_custom.t.

// Make it so any TADS 3.0.9-based message substitution parameters
// I have are dealt with properly.

#ifdef TADS308

//modify langMessageBuilder //: MessageBuilder
//    // I can't seem to find a way to modify this list, so I'm just
//    // doing a wholesale replacement of it.
//    paramList_ = [
//        // parameters that imply the actor as the target object
//        ['you/he', &theName, 'actor', nil, true],
//        ['you/she', &theName, 'actor', nil, true],
//        ['you\'re/he\'s', &itIsContraction, 'actor', nil, true],
//        ['you\'re/she\'s', &itIsContraction, 'actor', nil, true],
//        ['you\'re', &itIsContraction, 'actor', nil, true],
//        ['you/him', &theNameObj, 'actor', &itReflexive, nil],
//        ['you/her', &theNameObj, 'actor', &itReflexive, nil],
//        ['your/her', &theNamePossAdj, 'actor', nil, nil],
//        ['your/his', &theNamePossAdj, 'actor', nil, nil],
//        ['your', &theNamePossAdj, 'actor', nil, nil],
//        ['yours/hers', &theNamePossNoun, 'actor', nil, nil],
//        ['yours/his', &theNamePossNoun, 'actor', nil, nil],
//        ['yours', &theNamePossNoun, 'actor', nil, nil],
//        ['yourself/himself', &itReflexive, 'actor', nil, nil],
//        ['yourself/herself', &itReflexive, 'actor', nil, nil],
//        ['yourself', &itReflexive, 'actor', nil, nil],
//        // parameters that don't imply any target object
//        ['the/he', &theName, nil, nil, true],
//        ['the/she', &theName, nil, nil, true],
//        ['the/him', &theNameObj, nil, &itReflexive, nil],
//        ['the/her', &theNameObj, nil, &itReflexive, nil],
//        ['the\'s/her', &theNamePossAdj, nil, &itPossAdj, nil],
//        ['the\'s/hers', &theNamePossNoun, nil, &itPossNoun, nil],
//        // Verb 's' endings.  In most cases, you should use 's/d', 's/ed',
//        // or 's/?ed' rather than 's'
//        ['s', &verbEndingS, nil, nil, true],
///*NEW!*/ ['s/d', &verbEndingSD, nil, nil, true],
///*NEW!*/ ['s/ed', &verbEndingSEd, nil, nil, true],
///*NEW!*/ ['s/?ed', &verbEndingSMessageBuilder_, nil, nil, true],
//        ['es', &verbEndingEs, nil, nil, true],
///*NEW*/ ['es/ed', &verbEndingEs, nil, nil, true],
//        ['ies', &verbEndingIes, nil, nil, true],
///*NEW*/ ['ies/ied', &verbEndingIes, nil, nil, true],
//        ['is', &verbToBe, nil, nil, true],
//        ['are', &verbToBe, nil, nil, true],
//        ['was', &verbWas, nil, nil, true],
//        ['were', &verbWas, nil, nil, true],
//        ['has', &verbToHave, nil, nil, true],
//        ['have', &verbToHave, nil, nil, true],
///*NEW!*/ ['does', &verbToDo, nil, nil, true],
///*NEW*/ ['do', &verbToDo, nil, nil, true],
///*NEW!*/ ['goes', &verbToGo, nil, nil, true],
///*NEW*/ ['go', &verbToGo, nil, nil, true],
///*NEW!*/ ['comes', &verbToCome, nil, nil, true],
///*NEW*/ ['come', &verbToCome, nil, nil, true],
///*NEW!*/ ['leaves', &verbToLeave, nil, nil, true],
///*NEW*/ ['leave', &verbToLeave, nil, nil, true],
///*NEW!*/ ['sees', &verbToSee, nil, nil, true],
///*NEW*/ ['see', &verbToSee, nil, nil, true],
///*NEW!*/ ['says', &verbToSay, nil, nil, true],
///*NEW*/ ['say', &verbToSay, nil, nil, true],
///*NEW!*/ ['must', &verbMust, nil, nil, true],
///*NEW!*/ ['can', &verbCan, nil, nil, true],
///*NEW!*/ ['cannot', &verbCannot, nil, nil, true],
///*NEW!*/ ['can\'t', &verbCant, nil, nil, true],
///*NEW!*/ ['will', &verbWill, nil, nil, true],
///*NEW!*/ ['won\'t', &verbWont, nil, nil, true],
//        ['a/he', &aName, nil, nil, true],
//        ['an/he', &aName, nil, nil, true],
//        ['a/she', &aName, nil, nil, true],
//        ['an/she', &aName, nil, nil, true],
//        ['a/him', &aNameObj, nil, &itReflexive, nil],
//        ['an/him', &aNameObj, nil, &itReflexive, nil],
//        ['a/her', &aNameObj, nil, &itReflexive, nil],
//        ['an/her', &aNameObj, nil, &itReflexive, nil],
//        ['it/he', &itNom, nil, nil, true],
//        ['it/she', &itNom, nil, nil, true],
//        ['it/him', &itObj, nil, &itReflexive, nil],
//        ['it/her', &itObj, nil, &itReflexive, nil],
//        // note that we don't have its/his, because that leaves
//        // ambiguous whether we want an adjective or noun form - so we
//        // only use the feminine pronouns with these, to make the
//        // meaning unambiguous 
//        ['its/her', &itPossAdj, nil, nil, nil],
//        ['its/hers', &itPossNoun, nil, nil, nil],
//        
//        ['it\'s/he\'s', &itIsContraction, nil, nil, true],
//        ['it\'s/she\'s', &itIsContraction, nil, nil, true],
//        ['it\'s', &itIsContraction, nil, nil, true],
//        ['that/he', &thatNom, nil, nil, true],
//        ['that/she', &thatNom, nil, nil, true],
//        ['that/him', &thatObj, nil, &itReflexive, nil],
//        ['that/her', &thatObj, nil, &itReflexive, nil],
//        ['that\'s', &thatIsContraction, nil, nil, true],
//        ['itself', &itReflexive, nil, nil, nil],
//        ['itself/himself', &itReflexive, nil, nil, nil],
//        ['itself/herself', &itReflexive, nil, nil, nil],
//        // default preposition for standing in/on something
//        ['on', &actorInName, nil, nil, nil],
//        ['in', &actorInName, nil, nil, nil],
//        ['outof', &actorOutOfName, nil, nil, nil],
//        ['offof', &actorOutOfName, nil, nil, nil],
//        ['onto', &actorIntoName, nil, nil, nil],
//        ['into', &actorIntoName, nil, nil, nil],
//        // The special invisible subject marker - this can be used to
//        // mark the subject in sentences that vary from the
//        // subject-verb-object structure that most English sentences
//        // take.  The usual SVO structure allows the message builder to
//        // see the subject first in most sentences naturally, but in
//        // unusual sentence forms it is sometimes useful to be able to
//        // mark the subject explicitly.  This doesn't actually result in
//        // any output; it's purely for marking the subject for our
//        // internal book-keeping.
//        // 
//        // (The main reason the message builder wants to know the subject
//        // in the first place is so that it can use a reflexive pronoun
//        // if the same object ends up being used as a direct or indirect
//        // object: "you can't open yourself" rather than "you can't open
//        // you.")  
//        ['subj', &dummyName, nil, nil, true]
//    ]
//;
//
//modify Thing
//    verbEndingS { return isPlural ? '' : 's'; }
//    verbEndingSD = (verbEndingS)
//    verbEndingSEd = (verbEndingS)
//    verbEndingSMessageBuilder_ = (verbEndingS)
//    verbToDo = 'do'
//    nameDoes = (theName + ' ' + verbToDo)
//    verbToGo = ('go' + verbEndingEs)
//    verbToCome = ('come' + verbEndingS)
//    verbToLeave = ('leave' + verbEndingS)
//    verbToSee = ('see' + verbEndingS)
//    nameSees = (theName + ' ' + verbToSee)
//    verbToSay = ('say' + verbEndingS)
//    nameSays = (theName + ' ' + verbToSay)
//    verbMust = 'must'
//    verbCan = 'can'
//    verbCannot = 'cannot'
//    verbCant = 'can&rsquo;t'
//    verbWill = 'will'
//    verbWont = 'won&rsquo;t'
//;
//
//tSel(presVal, pastVal) {
//  return presVal;
//}

#endif //TADS308

// -------------------------------------------------------------------
// MESSAGE MODIFICATIONS
// -------------------------------------------------------------------

// Message modifications due to personal taste.


modify libMessages
  // I don't feel like bothering players with messages about 
  // NOTIFY ON and NOTIFY OFF. 
  firstScoreChange(delta) {
    scoreChange(delta);
  }
  // When the score increases, don't mention the FULL SCORE
  // command, which doesn't exist in my game. Also, I prefer
  // to leave the score increase number as a raw integer (55)
  // rather than spelling it out (fifty-five).
  basicScoreChange(delta) {
    "Your score
    has just <<delta > 0 ? 'in' : 'de'>>creased by
    <<(delta > 0 ? delta : -delta)>>
    point<<delta is in (1, -1) ? '' : 's'>>.";
  }
;

modify playerActionMessages
  // 'yell' | 'scream' | 'shout' | 'holler'
  okayYellMsg {
    // if gAction.getOrigTokenList has a value, then I assume
    // this should work fine
    //if (gAction && gAction.getOrigTokenList)
    //  return '{You/he} ' + gAction.getOrigTokenList[1][1].toLower() 
    //    + '{s/ed} as loud as {it actor/he} {can}. ';
    //else
    //  return '{You/he} scream{s/ed} as loud as {it actor/he} {can}. ';
    return '{You/he} scream{s/ed} as loud as {it actor/he} {can}. ';
  }
  outOfReachMsg(obj) {
    gMessageParams(obj);
    return '{You/he} {can\'t} reach {the obj/him} 
      from where {you/he} {are}. ';
  }
;

modify OutOfReach
  cannotReachFromOutsideMsg(dest) { return &outOfReachMsg; }
  cannotReachFromInsideMsg(dest) { return &outOfReachMsg; }
;

// message replacements for the sake of "game" rather than "story"

//modify libMessages
//  noAboutInfo = "<.parser>This game has no ABOUT
//                 information.<./parser> "
//  noSuchFootnote(num) {
//    "<.parser>This game hasn<./s>t mentioned any such
//    footnote.<./parser> ";
//  }
//  invalidCommandToken(ch) {
//    "<.parser>This game doesn<./s>t know how to use the character
//    &lsquo;<<ch>>&rsquo; in a command.<./parser> ";
//  }
//  oopsNote() {
//    if (offerOopsNote) {
//      "<.commandsep><.notification>If this was an accidental
//      misspelling, you can correct it by typing OOPS followed by the
//      corrected word now.  Any time this game points out an unknown
//      word, you can correct a misspelling using OOPS as your next
//      command.<./notification> ";
//      libMessages.offerOopsNote = nil;
//    }
//  }
//  oopsOutOfContext = "<.parser>You can only use OOPS to correct
//    a misspelling immediately after the game points out a word
//    it doesn<./s>t know.<./parser> "
//  systemActionToNPC() {
//    "<.parser>That command cannot be directed to another
//    character in this game.<./parser> ";
//  }
//  notTerminating() {
//    "<.parser>Continuing the game.<./parser> ";
//  }
//  notRestarting() { "<.parser>Continuing the game.<./parser> "; }
//  restoreInvalidMatch() {
//    "<.parser>Failed: the file was not saved by this
//    game (or was saved by an incompatible version of
//    the game).<./parser> ";
//  }
//  pausePrompt() {
//    "<.parser>The story is now paused.  Please press
//    the space bar when you are ready to resume the game, or
//    press the <.s>S<./s> key to save the current position.<./parser><.p>";
//  }
//  pauseSaving() {
//    "<.parser>Saving the game...<./parser><.p>";
//  }
//  pauseEnded() {
//    "<.parser>Resuming the game.<./parser> ";
//  }
//  hintsNotPresent = '<.parser>Sorry, this game doesn<./s>t
//                     have any built-in hints.<./parser> '
//  //commandNotPresent = "<.parser>That command isn<./s>t needed
//  //                     here.<./parser> "
//  scoreNotPresent = "<.parser>This game doesn<./s>t use
//                     scoring.<./parser> "
//;
//
//modify playerMessages
//  commandNotUnderstood(actor) {
//    "<.parser>This game doesn<./s>t understand that command.<./parser> ";
//  }
//  reflexiveNotAllowed(actor, typ, pronounWord) {
//    "<.parser>This game doesn<./s>t know how to use the word
//    <q><<pronounWord>></q> like that.<./parser> ";
//  }
//  wrongReflexive(actor, typ, pronounWord) {
//    "<.parser>This game dn<./s>t understand what the
//    word <q><<pronounWord>></q> refers to.<./parser> ";
//  }
//  ambiguousNounPhrase(actor, originalText, matchList, fullMatchList) {
//    "<.parser>This game doesn<./s>t know which
//    <<originalText>> you mean.<./parser> ";
//  }
//  cannotChangeActor() {
//    "<.parser>You cannot address more than one character on
//    a single command line in this game.<./parser> ";
//  }
//  askUnknownWord(actor, txt) {
//    "<.parser>The word <q><<txt>></q> is not necessary in this
//    game.<./parser> ";
//    oopsNote();
//  }
//  wordIsUnknown(actor, txt) {
//    "<.parser>This game doesn<./s>t understand that
//    command.<./parser> ";
//  }
//;


// -------------------------------------------------------------------
// MAIN BANNER STUFF -- OLD SYSTEM
// -------------------------------------------------------------------

/*
-- This is the old system, used before 2019-08-01

             // Banner? {1=intro, 2=mazes, 3=game}=yes -=no 
             // |  Used as values in books/movie mazes? b=yes
             // |  |
             // |  |
             // |  |
             // |  |
             // |  |
             // v  v
enum
   confPic   // 1
  ,cellPic   // 1
  ,vrPic     // 1
  ,beachPic  // 1
  ,emptyPic  // 1
  ,supermaze // 2
  ,africa    // 2
  ,elmexico  // 2
  ,quat1     // 2
  ,quat2     // 2
  ,pyramid1  // 2
  ,pyramid2  // 2
  ,twisty    // 2
  ,escape    // 2
  ,animals   // 2
  ,floor     // 2
  ,nethacman // 2
  ,endgame   // 3
  ,tolstoy   // 2  b  Book  1: War and Peace
  ,hawthorne // 2  b  Book  2: The Scarlet Letter
  ,dumas     // 2  b  Book  3: The Three Musketeers
  ,dickens   // 2  b  Book  4: A Tale of Two Cities
  ,defoe     // 2  b  Book  5: Robinson Crusoe
  ,austen    // 2  b  Book  6: Pride and Prejudice
  ,carroll   // 2  b  Book  7: Alice in Wonderland
  ,dostoevsky// 2  b  Book  8: The Brothers Karamazov
  ,chaucer   // 2  b  Book  9: The Canterbury Tales
  ,proust    // 2  b  Book 10: Remembrance of Things Past
  ,twain     // 2  b  Book 11: The Adventures of Tom Sawyer
  ,nights    // 2  b  Book 12: The Thousand and One Nights
  ,marquez   // 2  b  Book 13: One Hundred Years of Solitude
  ,starwars  // 2  b  Movie  1: Star Wars
  ,casablanca// 2  b  Movie  2: Casablanca
  ,planet    // 2  b  Movie  3: Planet of the Apes
  ,lawrence  // 2  b  Movie  4: Lawrence of Arabia
  ,saving    // 2  b  Movie  5: Saving Private Ryan
  ,untouch   // 2  b  Movie  6: The Untouchables
  ,silence   // 2  b  Movie  7: The Silence of the Lambs
  ,bridge    // 2  b  Movie  8: The Bridge on the River Kwai
  ,manchurian// 2  b  Movie  9: The Manchurian Candidate
  ,shawshank // 2  b  Movie 10: The Shawshank Redemption
  ,valance   // 2  b  Movie 11: The Man Who Shot Liberty Valance
  ,cuckoo    // 2  b  Movie 12: One Flew Over the Cuckoo's Nest
  ,crouching // 2  b  Movie 13: Crouching Tiger, Hidden Dragon
;

nbmBanner: BannerWindow
  updateMe() {
    if (showBanner(nil,      // parent = nil; i.e. the main window.
          BannerLast,        // where = BannerLast: the main window's last priority.
          nil,               // other = irrelevant
          BannerTypeText,    // windowType = BannerTypeText: a regular window
          BannerAlignRight,  // align = BannerAlignRight
          50,                // size = 50 characters wide
          BannerSizeAbsolute,// sizeUnits = BannerSizeAbsolute: units as wide as a "0"
          BannerStyleBorder))// styleFlags = BannerStyleBorder
    {
      //if (gKey()) { local k=0;k=k/k; }
      //if (gPlayerChar && gPlayerChar.getOutermostRoom && 
      //    gPlayerChar.getOutermostRoom.ofKind(HacRoom)) {
      //  if (gKey()) { local k=0;k=k/k; }
      //}
      clearWindow();
      if (glob.changeFont)   writeToBanner('<.nbmfont>');
      if (glob.changeColors) writeToBanner('<.nbmcolors>');
      //getOutermostRoom()
      local x = gPlayerChar.getOutermostRoom();
      if (x == nil) {
        removeBanner();
        return;
      }
      if (x.bannerValue == nethacman)
        glob.localHacNpcs = 
          glob.hacNpcs.subset({x: x.getOutermostRoom != nil});
      switch (x.bannerValue) {
        case nil:
          removeBanner();
          return;
        case confPic:    writeToBanner(confPicPrint());       break;
        case cellPic:    writeToBanner(cellPicPrint());       break;
        case vrPic:      writeToBanner(vrPicPrint());         break;
        case beachPic:   writeToBanner(beachPicPrint());      break;
        case emptyPic:   writeToBanner(emptyPicPrint());      break;
        case supermaze:  writeToBanner(supermazeMapPrint());  break;
        case africa:     writeToBanner(africaMapPrint());     break;
        case elmexico:   writeToBanner(mexicoMapPrint());     break;
        case animals:    writeToBanner(animalMapPrint());     break;
        case twisty:     writeToBanner(twistyMapPrint());     break;
        case escape:     writeToBanner(escapeMapPrint());     break;
        case floor:      writeToBanner(floorMapPrint());      break;
        case quat1:      writeToBanner(quat1MapPrint());      break;
        case quat2:      writeToBanner(quat2MapPrint());      break;
        case nethacman:  writeToBanner(hacMapPrint());        break;
        case endgame:    writeToBanner(endgameMapPrint());    break;
        case pyramid1:   writeToBanner(pyramid1MapPrint());   break;
        case pyramid2:   writeToBanner(pyramid2MapPrint());   break;
        
        case tolstoy:    writeToBanner(tolstoyMapPrint());    break;
        case hawthorne:  writeToBanner(hawthorneMapPrint());  break;
        case dumas:      writeToBanner(dumasMapPrint());      break;
        case dickens:    writeToBanner(dickensMapPrint());    break;
        case defoe:      writeToBanner(defoeMapPrint());      break;
        case austen:     writeToBanner(austenMapPrint());     break;
        case carroll:    writeToBanner(carrollMapPrint());    break;
        case dostoevsky: writeToBanner(dostoevskyMapPrint()); break;
        case chaucer:    writeToBanner(chaucerMapPrint());    break;
        case proust:     writeToBanner(proustMapPrint());     break;
        case twain:      writeToBanner(twainMapPrint());      break;
        case nights:     writeToBanner(nightsMapPrint());     break;
        case marquez:    writeToBanner(marquezMapPrint());    break;
        
        case starwars:   writeToBanner(starwarsMapPrint());   break;
        case casablanca: writeToBanner(casablancaMapPrint()); break;
        case planet:     writeToBanner(planetMapPrint());     break;
        case lawrence:   writeToBanner(lawrenceMapPrint());   break;
        case saving:     writeToBanner(savingMapPrint());     break;
        case untouch:    writeToBanner(untouchMapPrint());    break;
        case silence:    writeToBanner(silenceMapPrint());    break;
        case bridge:     writeToBanner(bridgeMapPrint());     break;
        case manchurian: writeToBanner(manchurianMapPrint()); break;
        case shawshank:  writeToBanner(shawshankMapPrint());  break;
        case valance:    writeToBanner(valanceMapPrint());    break;
        case cuckoo:     writeToBanner(cuckooMapPrint());     break;
        case crouching:  writeToBanner(crouchingMapPrint());  break;
        default:
          writeToBanner('ERROR: Unanticipated banner value at
            this location. \n');
      }
      sizeToContents();
    }
  }
  //This didn't seem to work, except with respect to whether or not
  //the banner should be shown. It didn't update the banner.
  //updateForRestore() {
  //  updateMe();
  //}
;

*/

// -------------------------------------------------------------------
// MAIN BANNER STUFF -- NEW SYSTEM
// -------------------------------------------------------------------

modify glob
  // With this implementation, there can be at most two sizes for every image,
  // represented here as one of the following two integers:
  // 1 : small, suitable for 800x600 resolution
  // 2 : larger, suitable for 1024x768 resolution or better
  imageSize = 2
;

class BannerOutputToken: object
  getContent() { } // override
;

class ImageBannerOutputToken: BannerOutputToken
  getContent() {
    return getContentOutput();
  }
  // getContentOutput can be used as is, or can be overridden
  getContentOutput() {
    return '<img src="' + (glob.imageSize == 1 ? imageSize1 : imageSize2) + '">';
  }
  imageSize1 = nil // override
  imageSize2 = nil // override
;

class MapBannerOutputToken: BannerOutputToken
  getContent() {
    return getContentOutput();
  }
  getContentOutput() { } // override this
;

cellFood  : ImageBannerOutputToken imageSize1 = 'illustrations/termfood2_0420.jpg' imageSize2 = 'illustrations/termfood2_0605.jpg';
cellKill  : ImageBannerOutputToken imageSize1 = 'illustrations/killyou_0420.jpg' imageSize2 = 'illustrations/killyou_0605.jpg';
cellTerm  : ImageBannerOutputToken imageSize1 = 'illustrations/terminal2_0420.jpg' imageSize2 = 'illustrations/terminal2_0605.jpg';
cellPris  : ImageBannerOutputToken imageSize1 = 'illustrations/prisoners2_0420.jpg' imageSize2 = 'illustrations/prisoners2_0605.jpg';
confRmPic : ImageBannerOutputToken imageSize1 = 'illustrations/confroom2_0420.jpg' imageSize2 = 'illustrations/confroom2_0605.jpg';
confPfPic : ImageBannerOutputToken imageSize1 = 'illustrations/confprofs2_0420.jpg' imageSize2 = 'illustrations/confprofs2_0605.jpg';
vrPic     : ImageBannerOutputToken imageSize1 = 'illustrations/level9_330.png' imageSize2 = 'illustrations/level9_495.png' ;
beachPic  : ImageBannerOutputToken imageSize1 = 'illustrations/beach_400.png' imageSize2 = 'illustrations/beach_600.png' ;
emptyPic  : ImageBannerOutputToken imageSize1 = 'illustrations/empty_330.png' imageSize2 = 'illustrations/empty_495.png' ;
//cellPic   : ImageBannerOutputToken getContentOutput() { return cellPicPrint();       } ; // returns one of four pictures
//confPic   : ImageBannerOutputToken getContentOutput() { return confPicPrint();       } ; // returns one of two pictures
//vrPic     : ImageBannerOutputToken getContentOutput() { return vrPicPrint();         } ;
//beachPic  : ImageBannerOutputToken getContentOutput() { return beachPicPrint();      } ;
//emptyPic  : ImageBannerOutputToken getContentOutput() { return emptyPicPrint();      } ;
supermaze : MapBannerOutputToken getContentOutput() { return supermazeMapPrint();  } ;
africa    : MapBannerOutputToken getContentOutput() { return africaMapPrint();     } ;
elmexico  : MapBannerOutputToken getContentOutput() { return mexicoMapPrint();     } ;
animals   : MapBannerOutputToken getContentOutput() { return animalMapPrint();     } ;
twisty    : MapBannerOutputToken getContentOutput() { return twistyMapPrint();     } ;
escape    : MapBannerOutputToken getContentOutput() { return escapeMapPrint();     } ;
floor     : MapBannerOutputToken getContentOutput() { return floorMapPrint();      } ;
quat1     : MapBannerOutputToken getContentOutput() { return quat1MapPrint();      } ;
quat2     : MapBannerOutputToken getContentOutput() { return quat2MapPrint();      } ;
nethacman : MapBannerOutputToken getContentOutput() { return hacMapPrint();        } ;
endgame   : MapBannerOutputToken getContentOutput() { return endgameMapPrint();    } ;
pyramid1  : MapBannerOutputToken getContentOutput() { return pyramid1MapPrint();   } ;
pyramid2  : MapBannerOutputToken getContentOutput() { return pyramid2MapPrint();   } ;
tolstoy   : MapBannerOutputToken getContentOutput() { return tolstoyMapPrint();    } ;
hawthorne : MapBannerOutputToken getContentOutput() { return hawthorneMapPrint();  } ;
dumas     : MapBannerOutputToken getContentOutput() { return dumasMapPrint();      } ;
dickens   : MapBannerOutputToken getContentOutput() { return dickensMapPrint();    } ;
defoe     : MapBannerOutputToken getContentOutput() { return defoeMapPrint();      } ;
austen    : MapBannerOutputToken getContentOutput() { return austenMapPrint();     } ;
carroll   : MapBannerOutputToken getContentOutput() { return carrollMapPrint();    } ;
dostoevsky: MapBannerOutputToken getContentOutput() { return dostoevskyMapPrint(); } ;
chaucer   : MapBannerOutputToken getContentOutput() { return chaucerMapPrint();    } ;
proust    : MapBannerOutputToken getContentOutput() { return proustMapPrint();     } ;
twain     : MapBannerOutputToken getContentOutput() { return twainMapPrint();      } ;
nights    : MapBannerOutputToken getContentOutput() { return nightsMapPrint();     } ;
marquez   : MapBannerOutputToken getContentOutput() { return marquezMapPrint();    } ;
starwars  : MapBannerOutputToken getContentOutput() { return starwarsMapPrint();   } ;
casablanca: MapBannerOutputToken getContentOutput() { return casablancaMapPrint(); } ;
planet    : MapBannerOutputToken getContentOutput() { return planetMapPrint();     } ;
lawrence  : MapBannerOutputToken getContentOutput() { return lawrenceMapPrint();   } ;
saving    : MapBannerOutputToken getContentOutput() { return savingMapPrint();     } ;
untouch   : MapBannerOutputToken getContentOutput() { return untouchMapPrint();    } ;
silence   : MapBannerOutputToken getContentOutput() { return silenceMapPrint();    } ;
bridge    : MapBannerOutputToken getContentOutput() { return bridgeMapPrint();     } ;
manchurian: MapBannerOutputToken getContentOutput() { return manchurianMapPrint(); } ;
shawshank : MapBannerOutputToken getContentOutput() { return shawshankMapPrint();  } ;
valance   : MapBannerOutputToken getContentOutput() { return valanceMapPrint();    } ;
cuckoo    : MapBannerOutputToken getContentOutput() { return cuckooMapPrint();     } ;
crouching : MapBannerOutputToken getContentOutput() { return crouchingMapPrint();  } ;

nbmBanner: BannerWindow
  updateMe() {
    if (showBanner(nil,      // parent = nil; i.e. the main window.
          BannerLast,        // where = BannerLast: the main window's last priority.
          nil,               // other = irrelevant
          BannerTypeText,    // windowType = BannerTypeText: a regular window
          BannerAlignRight,  // align = BannerAlignRight
          50,                // size = 50 characters wide
          BannerSizeAbsolute,// sizeUnits = BannerSizeAbsolute: units as wide as a "0"
          BannerStyleBorder))// styleFlags = BannerStyleBorder
    {
      //if (gKey()) { local k=0;k=k/k; }
      //if (gPlayerChar && gPlayerChar.getOutermostRoom && 
      //    gPlayerChar.getOutermostRoom.ofKind(HacRoom)) {
      //  if (gKey()) { local k=0;k=k/k; }
      //}
      clearWindow();
      if (glob.changeFont)   writeToBanner('<.nbmfont>');
      if (glob.changeColors) writeToBanner('<.nbmcolors>');
      //getOutermostRoom()
      local x = gPlayerChar.getOutermostRoom();
      if (x == nil) {
        removeBanner();
        return;
      }
      if (x.bannerValue == nethacman) {
        glob.localHacNpcs = 
          glob.hacNpcs.subset({x: x.getOutermostRoom != nil});
      }
      
      if (x.bannerValue == nil) {
        removeBanner();
        return;
      }
      else if (dataType(x.bannerValue) == TypeObject && x.bannerValue.ofKind(BannerOutputToken)) {
        writeToBanner(x.bannerValue.getContent());
      }
      else {
        writeToBanner('ERROR: Unanticipated banner value at
          this location. \n');
      }
      sizeToContents();
    }
  }
  //This didn't seem to work, except with respect to whether or not
  //the banner should be shown. It didn't update the banner.
  //updateForRestore() {
  //  updateMe();
  //}
;

// -------------------------------------------------------------------
// MAIN BANNER STUFF
// -------------------------------------------------------------------

modify Room
  bannerValue = nil
  enteringRoom(traveler) {
    nbmBanner.updateMe();
  }
;

nbmPostRestoreObject: PostRestoreObject
  execute {
    if (PostRestoreObject.restoreCode == 3)
      maybeNbmCls(RetryAction);
    else
      maybeNbmCls(RestoreAction);
    updateBannerAndFont();
  }
;

nbmPostUndoObject: PostUndoObject
  execute {
    maybeNbmCls(UndoAction);
    updateBannerAndFont();
  }
;

updateBannerAndFont() {
  // Banner must be updated to reflect changed circumstances
  // upon undoing or restoring.
  nbmBanner.updateMe();
  // Font must be updated in case the undo or restore
  // requires a change of font.
  "<.nbmfont>";
}

// finishGameMsg() has been hacked for two reasons:
// (1) So as to update the banner again at the end of the game.
// (2) So as to change the finish options when gPlayerChar==bot.
// (3) So as to include Michel Nizette's stuff to get rid of
//     finishOptionRetry when it is not applicable.
replace finishGameMsg(msg, extra) {
  local lst;
  
  
  //START HACK
  local lstStart, lstEnd;
  if (gPlayerChar != bot) {
    lstStart = [finishOptionRestore, finishOptionRestart];
    lstEnd   = [finishOptionQuit];
  }
  else {
    if (bot.getOutermostRoom && bot.getOutermostRoom != bot
        && !bot.getOutermostRoom.ofKind(BasicSupermazeRoom))
      lstStart = [mfoRestore, mfoReset, mfoBegin];
    else
      lstStart = [mfoRestore, mfoBegin];
    lstEnd   = [mfoStop, mfoQuit, mfoRestart];
    //foRestart = finishOptionBegin;
    //foQuit    = finishOptionStop;
  }
  if (!glob.dontUpdateBanner)
    nbmBanner.updateMe();
  
  local result = challengeManager.beforeFinishGame();
  if (!result && extra != nil && extra.indexOf(finishOptionRetry) != nil)
      extra -= finishOptionRetry;
  //END HACK
  
  
  if (dataType(msg) == TypeObject) {
    msg = msg.finishMsg;
    if (dataType(msg) == TypeProp)
      msg = libMessages.(msg);
  }
  if (msg != nil)
    libMessages.showFinishMsg(msg);
  if (extra != nil && extra.indexWhich({x: x.showScoreInFinish}) != nil) {
    "<.p>";
    libGlobal.scoreObj.showScore();
    "<.p>";
  }
  senseContext.setSenseContext(nil, sight);
  gActor = gPlayerChar;
  
  
  // START HACK
  lst = lstStart;
  if (extra != nil)
    lst += extra;
  lst += lstEnd;
  //else {
  //  lst = [mfoRestore, mfoBegin, mfoUndo, mfoStop,]
  //}
  //local k = 0; k=k/k;
  // END HACK
  
  
  processOptions(lst);
}


// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

DefineIAction(Cheat)
  execAction() {
    glob.knowsAboutFifthTier = true; // food dispenser password
    vd1Main.select();
    mainReport('Okay, cheating accomplished. ');
  }
;
VerbRule(Cheat)
  'cheat'
  : CheatAction
  verbPhrase = 'cheat/cheating'
;


kitchen: Room 'Kitchen'
  "This is a kitchen. The bathroom is to the west; to the east you can
    go outside. North goes to a maze. "
  west = platf
  east = yard
  north = africaTest
  southeast = dimRoom
;
//+ blaster: Gun, Container, Thing 'blaster/blast' 'blaster';
//+ stunner: Gun, Container, Thing 'stunner/stun' 'stunner';
+ box: OpenableContainer 'box' 'box';
+ feather: Thing 'feather' 'feather';
//+ rifle: Gun, Container, Thing 'rifle' 'rifle';
+ hat: Wearable 'hat' 'hat';
+ cartridge: Thing 'clip/cartridge' 'cartridge' "A rifle cartridge. ";
+ fluff: Thing 'fluff' 'fluff' isProperName=true;
//+ pistol: Gun, Container, Thing 'pistol' 'pistol';
//+ cat: Actor 'cat' 'cat';

+ pinata: Thing 
  vocabWords = 'pinata/pinyata/pi\u00F1ata' 
  name = 'pi\u00F1ata' 
  desc = "The pi\u00F1ata is full of goodies and ready 
    for someone to break it open. " 
; 

platf: Room 'Platform' 'the platform'
  "This is a platform. The kitchen is to the east. "
  east = kitchen
;

dimRoom: Room 'Dim room'
  "This is a really dim room. "
  brightness = 2
  northwest = kitchen
;

+ book: Readable 'book' 'book'
  readDesc = "You skim through the book and learn many fascinating things. "
;

yard: OutdoorRoom 'Outside'
  "You are outside. The sky is overhead. The sun is in the sky.
    West takes you back into the house. "
  west = kitchen
;
+ sun: Distant 'sun' 'sun';

//enum alien     ,   gateway   ,   twoaliens ,   prisoners ,   supermaze ,   africa    ,   elmexico  ,   books     ,   movies    ,   quat1     ,   quat2     ,   pyramid1  ,   pyramid2  ,   twisty    ,   escape    ,   animals   ,   floor     ,   nethacman ,  invisible ,   other     ,   endgame   ,   tolstoy   ,   hawthorne ,   dumas     ,   dickens   ,   defoe     ,   austen    ,   carroll   ,   dostoevsky,   chaucer   ,   proust    ,   twain     ,   nights    ,   marquez   ,   starwars  ,   casablanca,   planet    ,   lawrence  ,   saving    ,   untouch   ,   silence   ,   bridge    ,   manchurian,   shawshank ,   valance   ,   cuckoo    ,   crouching ; 
//nbmBanner: object;

#endif // __DEBUG

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

// --------------
// THE GRAND COMPREHENSIVE TO-DO LIST

// This is now contained in the spreadsheet "nbm to-do.xls".

// --------------
// NOTES TO BETA-TESTERS

/*
Make sure to test the limits of the MazePortable class.

When in the part of the maze containing the dragon and Adam Thornton, try interacting with the characters to the maximum extent that you can.
Be sure to request hints as often as you can.
Use all the special inner-game meta-verbs that you can when in the inner game -- that is, the verbs listed with the verb INFO.
Try dropping things while in the book/movie mazes and the Hac-Man maze, then wandering away and coming back and seeing if the things are where they should be.

*/

// --------------
// NOTES TO MYSELF

/*
Maze Add-Ons:
  MoreThanJustUngulates.nbm // wapiti graffiti in twisty maze, and graffiti by zebra, yak, etc.
  butterflyidentification.nbm
  beachchair.nbm
  robotnavigator.nbm // or whatever you call the one that permits you to have a chance at winning
About:
  This was going to be an easy game, and for the most part it is. Although it is possible to lock yourself out of victory, these cases usually either (1) result from obviously reckless behavior, (2) are preceded by a warning of impending danger, or else (3) can be fixed with a single "undo."
  However, upon further research, I've discovered that although people SAY they like fairness, they give all the awards to games that are savagely cruel and sadistic. One need look no further than Photopia, whose merciless maze I have yet to solve after three months of painstaking mapping.
  Therefore, I must 
  Therefore, I feel I have no choice but to intersperse this game with rare but extremely unfair traps. I won't tell you what these traps look like, but suffice it to say that if you run into Mr. Snuffleupagus in a trenchcoat and galoshes, it's time to restore your game. These and other traps serve no other purpose than to be beastly, vicious, and cruel.
  These traps are random, so you may or may not encounter them. But don't be fooled; this game is not easy. On Zarf's cruelty scale, it is beyond cruel. It is "cruel and unusual."
  //, since I know there are those who enjoy that sort of thing. I trust that by doing this, I am maximizing my chances of winning a bunch of awards.
Music:
  Music: Opening music:  Synth: First seeing alien.
  Music: Title music:    Organ: The Labyrinth Prelude
  Music: Ending fanfare: Horns: Dum da-da-da!
  Music: Credits:        Piano: Ragtime or whatever.
Sound:
  "Oh god. Who wrote this game?"
Bugs:
  Odys1.desc prints two \b's, not one, if the gun is examined while
    in terse mode if there are no items in the room.
Amusing things to try:
  "wake up alien" after you've stunned one of them with
    the Scott Adams phaser.
  SET PHASER TO DESTROY. Actually, SET PHASER -- then
    TO DESTROY.
  PLUG IN HANDGUN.
Credits:
  Written by:
    Greg Boettcher
  Programmed by:
    Greg Boettcher 
  Music composed by:
    Greg Boettcher
  Artwork by:
    Greg Boettcher
  Puzzles by:
    Greg Boettcher
  Extent of originality of puzzles:
    Not as much as in System's Twilight, but still.
  Puzzle Inspiration:
    Cliff Johnson, The Fool's Errand
    Cliff Johnson, 3 in Three
    Andrew Plotkin, System's Twilight
    The Giant Book of Games.
    The Second Giant Book of Games.
    PQRST Puzzle Competition
  SF inspiration:
    Frederick Pohl's Gateway
    Gateway 2: Homeworld
    Spider and Web
  Thanks for permissions:
    Lance Micklus, Dog Star Adventure
    Scott Adams, Strange Odyssey
    Peter Killworth, Countdown to Doom
    Pete Austin, et al., Snowball
    Essex, by Synapse
    Magnetic Scrolls
    The Hitchhiker's Guide to the Galaxy
    Leather Goddesses of Phobos
    some game by Magnetic Scrolls
    Gateway 2: Homeworld
    Mike Roberts, Deep Space Drifter
    The Legend Lives! by David Baggett
    Sins Against Mimesis, by Adam Thornton
    Spider and Web, by Andrew Plotkin
    Worlds Apart
    Heroine's Mantle
    Centipede
    Max Blaster and Doris de Lightning Against the Parrot Creatures of Venus, by Dan Shiovitz and Emily Short
    Scavenger, by Quintin Stone
  TADS 3
    Mike Roberts
  Other TADS 3 Developers
    Eric Eve
    Steve Breslin
    Michel Nizette
  TADS 3 Documentation
    Mike Roberts
    Eric Eve
    Steve Breslin
  TADS 3 Extension Libraries:
    people.
  Technical assistance:
    M.D. Dollahite
    Steve Breslin
    Eric Eve
    Khelwood
    Guilherme de Sousa
    Mike Roberts
  Providers of TADS 3 Source Code:
    Mike Roberts
    Eric Eve
    Geoff Fortytwo
  Moral Support
    Daphne Brinkerhoff
  Astronomy consultants:
    Jacob Navia
    Bill Owen
  Interactive fiction consultants
    Daphne Brinkerhoff
    Cirk R. Bejnar (all kinds of responses to my post)
    Boluc Papuccuoglu (Fish! recommendation)
    Sean Murphy (Xenos information)
  Geography advisor:
    Scott A. Zillmer
  Map research associate:
    Scott A. Zillmer
  Maps:
    Ask Scott where they came from.
  Photography credits:
    Specially thank that yak guy.
    Moon photo: NASA
  Bibliography of books:
    Oxford Handbook of the World
    National Geographic World Atlas
    CIA World Factbook
    The Columbia Encyclopedia, Sixth Edition
    Wikipedia
  Misc notes:
    This game was created without purchasing the overpriced Anagram Genius. If you have a copy of Anagram Genius, please send it to:
  To support me:
    Send me money.
    Send me a warez copy of Anagram Genius or Daggerfall.

Feelies package:
paper print: 8.5"x11" print of Nothing but Mazes maze (vector)
paper print: 8.5"x11" print of Nothing but Mazes maze (vector)
physical CD: Printed CD.
software on CD: The game.
software on CD: Rhapsody out of Madness
software on CD: all the artwork as JPGs
software on CD: "the making of the game"

*/

// --------------
// OLD NOTE TO READER

// I've often found it extremely helpful to look at the source code 
// of TADS 3 games, even if such code follows "bad form," is full 
// of kludges, or is badly commented.
// 
// In that spirit, I am releasing the source code to Nothing but
// Mazes, even though the code sucks in some ways. 
// 
// How does it suck? A few examples:
// 
// Do not imitate my way of modeling things that can be seen from a distance in the endgame. The way I did it was outrageously ass-backwards -- e.g., in entailed some NPCs being MultiLoc's. If you follow this example, the programming gods will punish you. Trust me, I know. 
// If you need to capitalize a string (str), do not type:
//      str.substr(1,1).toUpper() + str.substr(2)
// ...as I did many times. Instead, just type:
//      '\^' + str
// 
// I'd certainly rather release my code as is than go through all 
// the work of trying to perfect it first, a task which would 
// probably bog down and result in my never releasing the code at 
// all.
// 
// Therefore, be warned: this code contains heinous flaws (though, 
// I hope, few actual bugs). I am releasing it anyway in the hope
// that it may be of interest to the TADS 3 community. I am not guaranteeing its 
// suitability for any given purpose.
// 
// By the way, for a list of other TADS 3 games whose code has been 
// released, check out "Step 1B" at the following link:
// 
// http://www.gregboettcher.com/games/aiop.htm
